/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.python.embedding.tools.jbang;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.python.embedding.tools.exec.GraalPyRunner;
import org.graalvm.python.embedding.tools.exec.SubprocessLog;
import org.graalvm.python.embedding.tools.vfs.VFSUtils;

public class JBangIntegration {
    private static final String PIP = "//PIP";
    private static final String PIP_DROP = "//PIP_DROP";
    private static final String PYTHON_LANGUAGE = "python-language";
    private static final String PYTHON_RESOURCES = "python-resources";
    private static final String PYTHON_LAUNCHER = "python-launcher";
    private static final String GRAALPY_GROUP = String.join((CharSequence)File.separator, "org", "graalvm", "python");
    private static final boolean IS_WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private static final String LAUNCHER = IS_WINDOWS ? "graalpy.exe" : "graalpy.sh";
    private static final SubprocessLog LOG = new SubprocessLog(){};

    public static Map<String, Object> postBuild(Path temporaryJar, Path pomFile, List<Map.Entry<String, String>> repositories, List<Map.Entry<String, Path>> dependencies, List<String> comments, boolean nativeImage) {
        Path home;
        Path vfs;
        block20: {
            vfs = temporaryJar.resolve("org.graalvm.python.vfs");
            Path venv = vfs.resolve("venv");
            home = vfs.resolve("home");
            try {
                Files.createDirectories(vfs, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new Error(e);
            }
            for (String comment : comments) {
                if (!comment.startsWith(PIP)) continue;
                JBangIntegration.ensureVenv(venv, dependencies);
                try {
                    String[] pkgs = (String[])Arrays.stream(comment.substring(PIP.length()).trim().split(" ")).filter(s -> !s.trim().isEmpty()).toArray(String[]::new);
                    GraalPyRunner.runPip(venv, "install", LOG, pkgs);
                }
                catch (IOException | InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            if (Files.exists(venv, new LinkOption[0])) {
                try {
                    Stream<Path> filter = Files.list(venv.resolve("lib")).filter(p -> p.getFileName().toString().startsWith("python3"));
                    Optional<Path> libFolderOptional = filter.findFirst();
                    Path libFolder = libFolderOptional.orElse(venv.resolve("lib"));
                    if (libFolder == null) break block20;
                    ArrayList<String> dropFolders = new ArrayList<String>();
                    dropFolders.add("pip");
                    dropFolders.add("setuptools");
                    for (String comment : comments) {
                        if (!comment.startsWith(PIP_DROP)) continue;
                        dropFolders.add(comment.substring(PIP_DROP.length()).trim());
                    }
                    for (String s2 : dropFolders) {
                        Path folder = libFolder.resolve("site-packages").resolve(s2);
                        if (!Files.exists(folder, new LinkOption[0])) continue;
                        Stream<Path> f = Files.walk(folder, new FileVisitOption[0]);
                        try {
                            f.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                        }
                        finally {
                            if (f == null) continue;
                            f.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (nativeImage) {
            try {
                VFSUtils.copyGraalPyHome(JBangIntegration.calculateClasspath(dependencies), home, null, null, LOG);
                Path niConfig = temporaryJar.resolve("META-INF").resolve("native-image");
                Files.createDirectories(niConfig, new FileAttribute[0]);
                Files.writeString(niConfig.resolve("native-image.properties"), (CharSequence)"Args = -H:-CopyLanguageResources", new OpenOption[0]);
                Files.writeString(niConfig.resolve("resource-config.json"), (CharSequence)"{\n  \"resources\": {\n    \"includes\": [\n      {\"pattern\": \"vfs/.*\"}\n    ]\n  }\n}\n", new OpenOption[0]);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            VFSUtils.generateVFSFilesList(vfs);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new HashMap<String, Object>();
    }

    private static Path getLauncherPath(String projectPath) {
        return Paths.get(projectPath, LAUNCHER);
    }

    private static void generateLaunchers(List<Map.Entry<String, Path>> dependencies, String projectPath) {
        System.out.println("Generating GraalPy launchers");
        Path launcher = JBangIntegration.getLauncherPath(projectPath);
        if (!Files.exists(launcher, new LinkOption[0])) {
            HashSet<String> classpath = JBangIntegration.calculateClasspath(dependencies);
            Path java = Paths.get(System.getProperty("java.home"), "bin", "java");
            if (!IS_WINDOWS) {
                String script = String.format("#!/usr/bin/env bash\n%s -classpath %s %s --python.Executable=\"$0\" \"$@\"\n", java, String.join((CharSequence)File.pathSeparator, classpath), "com.oracle.graal.python.shell.GraalPythonMain");
                try {
                    Path parent = launcher.getParent();
                    if (parent != null) {
                        Files.createDirectories(parent, new FileAttribute[0]);
                    }
                    Files.writeString(launcher, (CharSequence)script, new OpenOption[0]);
                    Set<PosixFilePermission> perms = Files.getPosixFilePermissions(launcher, new LinkOption[0]);
                    perms.addAll(List.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE));
                    Files.setPosixFilePermissions(launcher, perms);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            String script = String.format("import os, shutil, struct, venv\nfrom pathlib import Path\nvl = os.path.join(venv.__path__[0], 'scripts', 'nt', 'graalpy.exe')\ntl = os.path.join(r'%s')\nos.makedirs(Path(tl).parent.absolute(), exist_ok=True)\nshutil.copy(vl, tl)\ncmd = r'%s -classpath \"%s\" %s'\npyvenvcfg = os.path.join(os.path.dirname(tl), \"pyvenv.cfg\")\nwith open(pyvenvcfg, 'w', encoding='utf-8') as f:\n    f.write('venvlauncher_command = ')\n    f.write(cmd)\n", launcher, java, String.join((CharSequence)File.pathSeparator, classpath), "com.oracle.graal.python.shell.GraalPythonMain");
            try {
                File tmp = File.createTempFile("create_launcher", ".py");
                tmp.deleteOnExit();
                try (FileWriter wr = new FileWriter(tmp);){
                    wr.write(script);
                }
                GraalPyRunner.run(JBangIntegration.calculateClasspath(dependencies), LOG, tmp.getAbsolutePath());
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void ensureVenv(Path venv, List<Map.Entry<String, Path>> dependencies) {
        if (Files.exists(venv, new LinkOption[0])) {
            return;
        }
        Path venvDirectory = venv.toAbsolutePath();
        Path parent = venv.getParent();
        if (parent != null) {
            String parentString = parent.toString();
            JBangIntegration.generateLaunchers(dependencies, parentString);
            try {
                GraalPyRunner.runLauncher(JBangIntegration.getLauncherPath(parentString).toString(), LOG, "-m", "venv", venvDirectory.toString(), "--without-pip");
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
            try {
                GraalPyRunner.runVenvBin(venvDirectory, "graalpy", LOG, "-I", "-m", "ensurepip");
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static Collection<Path> resolveProjectDependencies(List<Map.Entry<String, Path>> dependencies) {
        return dependencies.stream().map(e -> (Path)e.getValue()).collect(Collectors.toList());
    }

    private static void getGraalPyArtifact(List<Map.Entry<String, Path>> dependencies, String aid) {
        Collection<Path> projectArtifacts = JBangIntegration.resolveProjectDependencies(dependencies);
        for (Path a : projectArtifacts) {
            Path fileName;
            Path parent = a.getParent();
            if (parent == null || (fileName = a.getFileName()) == null || !parent.toString().contains(GRAALPY_GROUP) || !fileName.toString().contains(aid)) continue;
            return;
        }
        throw new RuntimeException(String.format("Missing GraalPy dependency %s:%s. Please add it to your pom", GRAALPY_GROUP, aid));
    }

    private static HashSet<String> calculateClasspath(List<Map.Entry<String, Path>> dependencies) {
        HashSet<String> classpath = new HashSet<String>();
        JBangIntegration.getGraalPyArtifact(dependencies, PYTHON_LANGUAGE);
        JBangIntegration.getGraalPyArtifact(dependencies, PYTHON_LAUNCHER);
        JBangIntegration.getGraalPyArtifact(dependencies, PYTHON_RESOURCES);
        for (Path r : JBangIntegration.resolveProjectDependencies(dependencies)) {
            classpath.add(r.toAbsolutePath().toString());
        }
        return classpath;
    }
}

