/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.python.embedding.tools.exec;

import java.util.ArrayList;
import java.util.List;

public interface BuildToolLog {
    public void subProcessOut(String var1);

    public void subProcessErr(String var1);

    default public void lifecycle(String s) {
        this.info(s);
    }

    public void info(String var1);

    public void warning(String var1);

    public void warning(String var1, Throwable var2);

    public void error(String var1);

    public void debug(String var1);

    public boolean isWarningEnabled();

    default public boolean isLifecycleEnabled() {
        return true;
    }

    public boolean isInfoEnabled();

    public boolean isErrorEnabled();

    public boolean isDebugEnabled();

    public boolean isSubprocessOutEnabled();

    public static final class CollectOutputLog
    implements BuildToolLog {
        private final List<String> output = new ArrayList<String>();
        private final BuildToolLog delegate;

        public CollectOutputLog(BuildToolLog delegate) {
            this.delegate = delegate;
        }

        public List<String> getOutput() {
            return this.output;
        }

        @Override
        public boolean isDebugEnabled() {
            return this.delegate.isDebugEnabled();
        }

        @Override
        public boolean isInfoEnabled() {
            return this.delegate.isInfoEnabled();
        }

        @Override
        public void info(String s) {
            this.delegate.info(s);
        }

        @Override
        public void warning(String s) {
            this.delegate.warning(s);
        }

        @Override
        public void warning(String s, Throwable t) {
            this.delegate.warning(s, t);
        }

        @Override
        public void error(String s) {
            this.delegate.error(s);
        }

        @Override
        public void debug(String s) {
            this.delegate.debug(s);
        }

        @Override
        public boolean isWarningEnabled() {
            return this.delegate.isWarningEnabled();
        }

        @Override
        public boolean isErrorEnabled() {
            return this.delegate.isErrorEnabled();
        }

        @Override
        public boolean isSubprocessOutEnabled() {
            return true;
        }

        @Override
        public void subProcessOut(String s) {
            this.output.add(s);
        }

        @Override
        public void subProcessErr(String s) {
            this.delegate.error(s);
        }
    }
}

