/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.python.embedding.tools.exec;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.graalvm.python.embedding.tools.exec.BuildToolLog;
import org.graalvm.python.embedding.tools.exec.SuppressFBWarnings;

public class GraalPyRunner {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private static final String BIN_DIR = IS_WINDOWS ? "Scripts" : "bin";
    private static final String EXE_SUFFIX = IS_WINDOWS ? ".exe" : "";

    public static String[] getExtraJavaOptions() {
        String javaVersion = System.getProperty("java.version");
        try {
            if (Integer.parseInt(javaVersion) >= 24) {
                return new String[]{"--sun-misc-unsafe-memory-access=allow"};
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new String[0];
    }

    public static void run(Set<String> classpath, BuildToolLog log, String ... args) throws IOException, InterruptedException {
        GraalPyRunner.run(String.join((CharSequence)File.pathSeparator, classpath), log, args);
    }

    public static void run(String classpath, BuildToolLog log, String ... args) throws IOException, InterruptedException {
        String workdir = System.getProperty("exec.workingdir");
        Path java = Paths.get(System.getProperty("java.home"), "bin", "java");
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(java.toString());
        cmd.add("--enable-native-access=ALL-UNNAMED");
        cmd.addAll(Arrays.asList(GraalPyRunner.getExtraJavaOptions()));
        cmd.add("-classpath");
        cmd.add(classpath);
        cmd.add("com.oracle.graal.python.shell.GraalPythonMain");
        cmd.addAll(List.of(args));
        ProcessBuilder pb = new ProcessBuilder(cmd);
        if (workdir != null) {
            pb.directory(new File(workdir));
        }
        GraalPyRunner.infoCmd(log, "Running GraalPy:", cmd);
        GraalPyRunner.runProcess(pb, log);
    }

    public static void runLauncher(String launcherPath, BuildToolLog log, String ... args) throws IOException, InterruptedException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(launcherPath);
        cmd.addAll(List.of(args));
        GraalPyRunner.infoCmd(log, "Running:", cmd);
        ProcessBuilder pb = new ProcessBuilder(cmd);
        GraalPyRunner.runProcess(pb, log);
    }

    public static void runPip(Path venvDirectory, String command, BuildToolLog log, String ... args) throws IOException, InterruptedException {
        ArrayList<String> newArgs = new ArrayList<String>();
        newArgs.add("-m");
        newArgs.add("pip");
        GraalPyRunner.addProxy(newArgs);
        newArgs.add(command);
        newArgs.addAll(List.of(args));
        GraalPyRunner.runVenvBin(venvDirectory, "graalpy", log, newArgs);
    }

    public static void runVenvBin(Path venvDirectory, String command, BuildToolLog log, String ... args) throws IOException, InterruptedException {
        GraalPyRunner.runVenvBin(venvDirectory, command, log, List.of(args));
    }

    private static void runVenvBin(Path venvDirectory, String command, BuildToolLog log, List<String> args) throws IOException, InterruptedException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(venvDirectory.resolve(BIN_DIR).resolve(command + EXE_SUFFIX).toString());
        cmd.addAll(args);
        GraalPyRunner.infoCmd(log, "Executing:", cmd);
        ProcessBuilder pb = new ProcessBuilder(cmd);
        GraalPyRunner.runProcess(pb, log);
    }

    private static void addProxy(ArrayList<String> args) {
        if (System.getenv("http_proxy") == null && System.getenv("https_proxy") == null) {
            ProxySelector proxySelector = ProxySelector.getDefault();
            List<Proxy> proxies = proxySelector.select(URI.create("https://pypi.org"));
            String proxyAddr = null;
            for (Proxy proxy : proxies) {
                if (proxy.type() != Proxy.Type.HTTP) continue;
                proxyAddr = GraalPyRunner.fixProtocol(proxy.address().toString(), "http");
                break;
            }
            if (proxyAddr != null) {
                args.add("--proxy");
                args.add(proxyAddr);
            }
        }
    }

    private static String fixProtocol(String proxyAddress, String protocol) {
        return proxyAddress.startsWith(protocol) ? proxyAddress : protocol + "://" + proxyAddress;
    }

    private static void runProcess(ProcessBuilder pb, BuildToolLog log) throws IOException, InterruptedException {
        Process process = pb.start();
        Thread outputReader = new Thread(() -> {
            try (InputStream is = process.getInputStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    GraalPyRunner.subProcessOut(log, line);
                }
            }
            catch (IOException e) {
                GraalPyRunner.warn(log, "exception while reading subprocess out", e);
            }
        });
        outputReader.start();
        Thread errorReader = new Thread(() -> {
            try (BufferedReader errorBufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = errorBufferedReader.readLine()) != null) {
                    GraalPyRunner.subProcessErr(log, line);
                }
            }
            catch (IOException e) {
                GraalPyRunner.warn(log, "exception while reading subprocess err", e);
            }
        });
        errorReader.start();
        process.waitFor();
        outputReader.join();
        errorReader.join();
        if (process.exitValue() != 0) {
            throw new RuntimeException(String.format("Running command: '%s' ended with code %d.See the error output above.", String.join((CharSequence)" ", pb.command()), process.exitValue()));
        }
    }

    @SuppressFBWarnings(value={"UC_USELESS_VOID_METHOD"})
    private static void warn(BuildToolLog log, String txt, Throwable t) {
        if (log.isWarningEnabled()) {
            log.warning(txt, t);
        }
    }

    @SuppressFBWarnings(value={"UC_USELESS_VOID_METHOD"})
    private static void infoCmd(BuildToolLog log, String msg, List<String> cmd) {
        if (log.isInfoEnabled()) {
            log.info(String.format("%s %s", msg, String.join((CharSequence)" ", cmd)));
        }
    }

    private static void subProcessOut(BuildToolLog log, String txt) {
        if (log.isSubprocessOutEnabled()) {
            log.subProcessOut(txt);
        }
    }

    @SuppressFBWarnings(value={"UC_USELESS_VOID_METHOD"})
    private static void subProcessErr(BuildToolLog log, String txt) {
        if (log.isErrorEnabled()) {
            log.subProcessErr(txt);
        }
    }
}

