/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.capsule.PyCapsule;
import com.oracle.graal.python.builtins.objects.capsule.PyCapsuleNameMatchesNode;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.statement.AbstractImportNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextCapsuleBuiltins {

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Pointer, args={ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.Int}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyCapsule_Import
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyCapsule_Import() {
        }

        @Specialization
        Object doGeneric(TruffleString name, int noBlock, @Cached PyCapsuleNameMatchesNode nameMatchesNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.IndexOfStringNode indexOfStringNode, @Cached TruffleString.SubstringNode substringNode, @Cached ReadAttributeFromObjectNode getAttrNode) {
            PyCapsule capsule;
            TruffleString trace = name;
            Object object = null;
            while (trace != null) {
                int traceLen = codePointLengthNode.execute((AbstractTruffleString)trace, PythonUtils.TS_ENCODING);
                int dotIdx = indexOfStringNode.execute((AbstractTruffleString)trace, (AbstractTruffleString)StringLiterals.T_DOT, 0, traceLen, PythonUtils.TS_ENCODING);
                TruffleString dot = null;
                if (dotIdx >= 0) {
                    dot = substringNode.execute((AbstractTruffleString)trace, dotIdx + 1, traceLen - dotIdx - 1, PythonUtils.TS_ENCODING, false);
                    trace = substringNode.execute((AbstractTruffleString)trace, 0, dotIdx, PythonUtils.TS_ENCODING, false);
                }
                if (object == null) {
                    object = AbstractImportNode.importModule(trace, AbstractImportNode.T_IMPORT_ALL);
                    if (object == PNone.NO_VALUE) {
                        throw this.raise(PythonBuiltinClassType.ImportError, ErrorMessages.PY_CAPSULE_IMPORT_S_IS_NOT_VALID, trace);
                    }
                } else {
                    object = getAttrNode.execute(object, trace);
                }
                trace = dot;
            }
            PyCapsule pyCapsule = capsule = object instanceof PyCapsule ? (PyCapsule)object : null;
            if (capsule != null && PyCapsule_IsValid.doCapsule(capsule, name, this, nameMatchesNode) == 1) {
                return capsule.getPointer();
            }
            throw this.raise(PythonBuiltinClassType.AttributeError, ErrorMessages.PY_CAPSULE_IMPORT_S_IS_NOT_VALID, name);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.Pointer}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyCapsule_SetContext
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyCapsule_SetContext() {
        }

        @Specialization
        int doCapsule(PyCapsule o, Object context) {
            if (o.getPointer() == null) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_SetContext");
            }
            o.setContext(context);
            return 0;
        }

        @Fallback
        Object doError(Object o, Object name) {
            throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_SetContext");
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.PY_CAPSULE_DESTRUCTOR}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyCapsule_SetDestructor
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyCapsule_SetDestructor() {
        }

        @Specialization
        int doCapsule(PyCapsule o, Object destructor) {
            if (o.getPointer() == null) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_SetDestructor");
            }
            o.setDestructor(destructor);
            return 0;
        }

        @Fallback
        Object doError(Object o, Object name) {
            throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_SetDestructor");
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyCapsule_SetName
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyCapsule_SetName() {
        }

        @Specialization
        int doCapsuleTruffleString(PyCapsule o, TruffleString name) {
            if (o.getPointer() == null) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_SetName");
            }
            TruffleString n = name;
            o.setName(n);
            return 0;
        }

        @Specialization(guards={"isNoValue(name)"})
        int doCapsuleNone(PyCapsule o, PNone name) {
            if (o.getPointer() == null) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_SetName");
            }
            o.setName(null);
            return 0;
        }

        @Fallback
        Object doError(Object o, Object name) {
            throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_SetName");
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.Pointer}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyCapsule_SetPointer
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyCapsule_SetPointer() {
        }

        @Specialization
        int doCapsule(PyCapsule o, Object pointer, @CachedLibrary(limit="2") InteropLibrary interopLibrary) {
            if (interopLibrary.isNull(pointer)) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.PY_CAPSULE_IMPORT_S_IS_NOT_VALID);
            }
            if (o.getPointer() == null) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_SetPointer");
            }
            o.setPointer(pointer);
            return 0;
        }

        @Fallback
        Object doError(Object o, Object name) {
            throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_SetPointer");
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Pointer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyCapsule_GetContext
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyCapsule_GetContext() {
        }

        @Specialization
        Object doCapsule(PyCapsule o) {
            if (o.getPointer() == null) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_GetContext");
            }
            if (o.getContext() == null) {
                return this.getNULL();
            }
            return o.getContext();
        }

        @Fallback
        Object doError(Object o) {
            throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_GetPointer");
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PY_CAPSULE_DESTRUCTOR, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyCapsule_GetDestructor
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyCapsule_GetDestructor() {
        }

        @Specialization
        Object doCapsule(PyCapsule o) {
            if (o.getPointer() == null) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_GetDestructor");
            }
            if (o.getDestructor() == null) {
                return this.getNULL();
            }
            return o.getDestructor();
        }

        @Fallback
        Object doError(Object o) {
            throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_GetPointer");
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.ConstCharPtr, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyCapsule_GetName
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyCapsule_GetName() {
        }

        private void checkLegalCapsule(PyCapsule capsule) {
            if (capsule.getPointer() == null) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_GetName");
            }
        }

        private static Object tsToNative(TruffleString tname, TruffleString.GetInternalNativePointerNode getInternalNativePointerNode) {
            if (tname.isNative()) {
                return getInternalNativePointerNode.execute((AbstractTruffleString)tname, TruffleString.Encoding.UTF_8);
            }
            return new CArrayWrappers.CStringWrapper(tname);
        }

        @Specialization(guards={"isTruffleString(name)"})
        Object doTruffleString(PyCapsule o, @Bind(value="o.getName()") Object name, @Cached.Shared(value="a") @Cached TruffleString.GetInternalNativePointerNode getInternalNativePointerNode) {
            this.checkLegalCapsule(o);
            return PyCapsule_GetName.tsToNative((TruffleString)name, getInternalNativePointerNode);
        }

        @Specialization(replaces={"doTruffleString"})
        Object doGeneric(PyCapsule o, @Bind(value="o.getName()") Object name, @Cached.Shared(value="a") @Cached TruffleString.GetInternalNativePointerNode getInternalNativePointerNode) {
            this.checkLegalCapsule(o);
            if (name == null) {
                return this.getNULL();
            }
            if (name instanceof TruffleString) {
                return PyCapsule_GetName.tsToNative((TruffleString)name, getInternalNativePointerNode);
            }
            return name;
        }

        @Fallback
        Object doit(Object o) {
            throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_GetName");
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Pointer, args={ArgDescriptor.PyObject, ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyCapsule_GetPointer
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyCapsule_GetPointer() {
        }

        @Specialization
        Object doCapsule(PyCapsule o, Object name, @Cached PyCapsuleNameMatchesNode nameMatchesNode) {
            if (o.getPointer() == null) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_GetPointer");
            }
            if (!nameMatchesNode.execute(this, name, o.getName())) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.PY_CAPSULE_IMPORT_S_IS_NOT_VALID);
            }
            return o.getPointer();
        }

        @Fallback
        Object doError(Object o, Object name) {
            throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_GetPointer");
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Direct)
    public static abstract class PyCapsule_IsValid
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        @Specialization
        public static int doCapsule(PyCapsule o, TruffleString name, @Bind(value="this") Node inliningTarget, @Cached PyCapsuleNameMatchesNode nameMatchesNode) {
            if (o.getPointer() == null) {
                return 0;
            }
            if (!nameMatchesNode.execute(inliningTarget, name, o.getName())) {
                return 0;
            }
            return 1;
        }

        @Fallback
        static Object doError(Object o, Object name) {
            return 0;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.Pointer, ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.PY_CAPSULE_DESTRUCTOR}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyCapsule_New
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyCapsule_New() {
        }

        @Specialization
        Object doGeneric(Object pointer, Object name, Object destructor, @CachedLibrary(limit="2") InteropLibrary interopLibrary) {
            if (interopLibrary.isNull(pointer)) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT);
            }
            Object n = interopLibrary.isNull(name) ? null : name;
            return this.factory().createCapsule(pointer, n, destructor);
        }
    }
}

