/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.ctypes.CDataObject;
import com.oracle.graal.python.builtins.modules.ctypes.CDataTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CFieldBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesNodes;
import com.oracle.graal.python.builtins.modules.ctypes.FFIType;
import com.oracle.graal.python.builtins.modules.ctypes.LazyPyCSimpleTypeBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ctypes.PyCArgObject;
import com.oracle.graal.python.builtins.modules.ctypes.PyCFuncPtrObject;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.modules.ctypes.memory.Pointer;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeVoidPtr;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.method.PDecoratedMethod;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.function.BuiltinFunctionRootNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectSlowPathFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

public final class LazyPyCSimpleTypeBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        throw CompilerDirectives.shouldNotReachHere((String)"Should not be part of initialization!");
    }

    @CompilerDirectives.TruffleBoundary
    protected static void addCVoidPFromParam(PythonObjectSlowPathFactory factory, PythonLanguage language, Object type) {
        NodeFactory<CVoidPFromParamNode> rawFactory = LazyPyCSimpleTypeBuiltinsFactory.CVoidPFromParamNodeFactory.getInstance();
        Builtin rawNodeBuiltin = CVoidPFromParamNode.class.getAnnotation(Builtin.class);
        LazyPyCSimpleTypeBuiltins.addClassMethod(factory, language, type, rawFactory, rawNodeBuiltin);
    }

    @CompilerDirectives.TruffleBoundary
    protected static void addCCharPFromParam(PythonObjectSlowPathFactory factory, PythonLanguage language, Object type) {
        NodeFactory<CCharPFromParamNode> rawFactory = LazyPyCSimpleTypeBuiltinsFactory.CCharPFromParamNodeFactory.getInstance();
        Builtin rawNodeBuiltin = CCharPFromParamNode.class.getAnnotation(Builtin.class);
        LazyPyCSimpleTypeBuiltins.addClassMethod(factory, language, type, rawFactory, rawNodeBuiltin);
    }

    @CompilerDirectives.TruffleBoundary
    protected static void addCWCharPFromParam(PythonObjectSlowPathFactory factory, PythonLanguage language, Object type) {
        NodeFactory<CWCharPFromParamNode> rawFactory = LazyPyCSimpleTypeBuiltinsFactory.CWCharPFromParamNodeFactory.getInstance();
        Builtin rawNodeBuiltin = CWCharPFromParamNode.class.getAnnotation(Builtin.class);
        LazyPyCSimpleTypeBuiltins.addClassMethod(factory, language, type, rawFactory, rawNodeBuiltin);
    }

    @CompilerDirectives.TruffleBoundary
    private static void addClassMethod(PythonObjectSlowPathFactory objectFactory, PythonLanguage language, Object type, NodeFactory<? extends PythonBuiltinBaseNode> nodeFactory, Builtin builtin) {
        TruffleString name = PythonUtils.toTruffleStringUncached(builtin.name());
        PNone builtinDoc = PNone.NONE;
        RootCallTarget callTarget = language.createCachedCallTarget(l -> new BuiltinFunctionRootNode((PythonLanguage)((Object)l), builtin, nodeFactory, true), nodeFactory.getNodeClass(), builtin.name());
        int flags = PBuiltinFunction.getFlags(builtin, callTarget);
        PBuiltinFunction function = objectFactory.createBuiltinFunction(name, type, 1, flags, callTarget);
        PDecoratedMethod classMethod = objectFactory.createClassmethodFromCallableObj(function);
        function.setAttribute(SpecialAttributeNames.T___DOC__, builtinDoc);
        WriteAttributeToObjectNode.getUncached(true).execute(type, name, (Object)classMethod);
    }

    @Builtin(name="from_param", minNumOfPositionalArgs=2, declaresExplicitSelf=true)
    @ImportStatic(value={CDataTypeBuiltins.class})
    @GenerateNodeFactory
    protected static abstract class CVoidPFromParamNode
    extends PythonBinaryBuiltinNode {
        protected CVoidPFromParamNode() {
        }

        @Specialization
        Object none(Object type, PNone value) {
            return PNone.NONE;
        }

        protected static boolean isLong(Node inliningTarget, Object value, PyLongCheckNode longCheckNode) {
            return value instanceof PythonNativeVoidPtr || longCheckNode.execute(inliningTarget, value);
        }

        @Specialization(guards={"isLong(this, value, longCheckNode)"})
        Object voidPtr(Object type, Object value, @Bind(value="this") Node inliningTarget, @Cached PyLongCheckNode longCheckNode, @Cached.Exclusive @Cached CFieldBuiltins.SetFuncNode setFuncNode) {
            PyCArgObject parg = this.factory().createCArgObject();
            parg.pffi_type = FFIType.ffi_type_pointer;
            parg.tag = (char)80;
            parg.valuePointer = Pointer.allocate(parg.pffi_type, parg.pffi_type.size);
            setFuncNode.execute(null, FFIType.FieldSet.P_set, parg.valuePointer, value, 0);
            parg.obj = PNone.NONE;
            return parg;
        }

        @Specialization
        Object bytes(Object type, PBytes value, @Cached.Exclusive @Cached CFieldBuiltins.SetFuncNode setFuncNode) {
            PyCArgObject parg = this.factory().createCArgObject();
            parg.pffi_type = FFIType.ffi_type_pointer;
            parg.tag = (char)122;
            parg.valuePointer = Pointer.allocate(parg.pffi_type, parg.pffi_type.size);
            setFuncNode.execute(null, FFIType.FieldSet.z_set, parg.valuePointer, value, 0);
            parg.obj = value;
            return parg;
        }

        @Specialization
        Object string(Object type, TruffleString value, @Cached.Exclusive @Cached CFieldBuiltins.SetFuncNode setFuncNode) {
            PyCArgObject parg = this.factory().createCArgObject();
            parg.pffi_type = FFIType.ffi_type_pointer;
            parg.tag = (char)90;
            parg.valuePointer = Pointer.allocate(parg.pffi_type, parg.pffi_type.size);
            setFuncNode.execute(null, FFIType.FieldSet.Z_set, parg.valuePointer, value, 0);
            parg.obj = value;
            return parg;
        }

        @Specialization(guards={"!isNone(value)", "!isPBytes(value)", "!isString(value)", "!isLong(this, value, longCheckNode)"})
        Object c_void_p_from_param(VirtualFrame frame, Object type, Object value, @Bind(value="this") Node inliningTarget, @Cached PyLongCheckNode longCheckNode, @Cached CtypesNodes.PyTypeCheck pyTypeCheck, @Cached BuiltinFunctions.IsInstanceNode isInstanceNode, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached CVoidPFromParamNode cVoidPFromParamNode, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached PyObjectLookupAttr lookupAttr) {
            int code;
            StgDictObject stgd;
            boolean res = isInstanceNode.executeWith(frame, value, type);
            if (res) {
                return value;
            }
            if (pyTypeCheck.isArrayObject(value) || pyTypeCheck.isPointerObject(value)) {
                return value;
            }
            if (PGuards.isPyCArg(value)) {
                PyCArgObject a = (PyCArgObject)value;
                if (a.tag == 'P') {
                    return value;
                }
            }
            if (value instanceof PyCFuncPtrObject) {
                PyCFuncPtrObject func = (PyCFuncPtrObject)value;
                if (pyTypeCheck.isPyCFuncPtrObject(value)) {
                    PyCArgObject parg = this.factory().createCArgObject();
                    parg.pffi_type = FFIType.ffi_type_pointer;
                    parg.tag = (char)80;
                    parg.valuePointer = func.b_ptr;
                    parg.obj = value;
                    return parg;
                }
            }
            if ((stgd = pyObjectStgDictNode.execute(value)) != null && pyTypeCheck.isCDataObject(value) && PGuards.isTruffleString(stgd.proto) && ((code = codePointAtIndexNode.execute((AbstractTruffleString)((TruffleString)stgd.proto), 0, PythonUtils.TS_ENCODING)) == 122 || code == 90)) {
                PyCArgObject parg = this.factory().createCArgObject();
                parg.pffi_type = FFIType.ffi_type_pointer;
                parg.tag = (char)90;
                parg.obj = value;
                parg.valuePointer = ((CDataObject)value).b_ptr;
                return parg;
            }
            Object as_parameter = lookupAttr.execute((Frame)frame, inliningTarget, value, CDataTypeBuiltins.T__AS_PARAMETER_);
            if (as_parameter != PNone.NO_VALUE) {
                return cVoidPFromParamNode.execute(frame, type, as_parameter);
            }
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.WRONG_TYPE);
        }
    }

    @Builtin(name="from_param", minNumOfPositionalArgs=2)
    @ImportStatic(value={CDataTypeBuiltins.class})
    @GenerateNodeFactory
    protected static abstract class CCharPFromParamNode
    extends PythonBinaryBuiltinNode {
        protected CCharPFromParamNode() {
        }

        @Specialization
        Object none(Object type, PNone value) {
            return PNone.NONE;
        }

        @Specialization
        Object bytes(Object type, PBytes value, @Cached CFieldBuiltins.SetFuncNode setFuncNode) {
            PyCArgObject parg = this.factory().createCArgObject();
            parg.pffi_type = FFIType.ffi_type_pointer;
            parg.tag = (char)122;
            parg.valuePointer = Pointer.allocate(parg.pffi_type, parg.pffi_type.size);
            setFuncNode.execute(null, FFIType.FieldSet.z_set, parg.valuePointer, value, 0);
            parg.obj = value;
            return parg;
        }

        @Specialization(guards={"!isNone(value)", "!isBytes(value)"})
        Object c_char_p_from_param(VirtualFrame frame, Object type, Object value, @Bind(value="this") Node inliningTarget, @Cached BuiltinFunctions.IsInstanceNode isInstanceNode, @Cached CtypesNodes.PyTypeCheck pyTypeCheck, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached CCharPFromParamNode cCharPFromParamNode, @Cached PyObjectLookupAttr lookupAttr) {
            Object as_parameter;
            StgDictObject dict;
            boolean res = isInstanceNode.executeWith(frame, value, type);
            if (res) {
                return value;
            }
            if (pyTypeCheck.isArrayObject(value) || pyTypeCheck.isPointerObject(value)) {
                StgDictObject dt = pyObjectStgDictNode.execute(value);
                assert (dt != null) : "Cannot be NULL for pointer or array objects";
                StgDictObject stgDictObject = dict = dt.proto != null ? pyTypeStgDictNode.execute(dt.proto) : null;
                if (dict != null && dict.setfunc == FFIType.FieldDesc.c.setfunc) {
                    return value;
                }
            }
            if (PGuards.isPyCArg(value)) {
                PyCArgObject a = (PyCArgObject)value;
                dict = pyObjectStgDictNode.execute(a.obj);
                if (dict != null && dict.setfunc == FFIType.FieldDesc.c.setfunc) {
                    return value;
                }
            }
            if ((as_parameter = lookupAttr.execute((Frame)frame, inliningTarget, value, CDataTypeBuiltins.T__AS_PARAMETER_)) != PNone.NO_VALUE) {
                return cCharPFromParamNode.execute(frame, type, as_parameter);
            }
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.WRONG_TYPE);
        }
    }

    @Builtin(name="from_param", minNumOfPositionalArgs=2, declaresExplicitSelf=true)
    @ImportStatic(value={CDataTypeBuiltins.class})
    @GenerateNodeFactory
    protected static abstract class CWCharPFromParamNode
    extends PythonBinaryBuiltinNode {
        protected CWCharPFromParamNode() {
        }

        @Specialization
        Object none(Object type, PNone value) {
            return PNone.NONE;
        }

        @Specialization(guards={"!isNone(value)"})
        Object c_wchar_p_from_param(VirtualFrame frame, Object type, Object value, @Bind(value="this") Node inliningTarget, @Cached CFieldBuiltins.SetFuncNode setFuncNode, @Cached BuiltinFunctions.IsInstanceNode isInstanceNode, @Cached CtypesNodes.PyTypeCheck pyTypeCheck, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached CWCharPFromParamNode cwCharPFromParamNode, @Cached PyObjectLookupAttr lookupAttr) {
            Object as_parameter;
            StgDictObject dict;
            if (PGuards.isString(value)) {
                PyCArgObject parg = this.factory().createCArgObject();
                parg.pffi_type = FFIType.ffi_type_pointer;
                parg.tag = (char)90;
                parg.valuePointer = Pointer.allocate(parg.pffi_type, parg.pffi_type.size);
                parg.obj = setFuncNode.execute(frame, FFIType.FieldDesc.Z.setfunc, parg.valuePointer, value, 0);
                return parg;
            }
            boolean res = isInstanceNode.executeWith(frame, value, type);
            if (res) {
                return value;
            }
            if (pyTypeCheck.isArrayObject(value) || pyTypeCheck.isPointerObject(value)) {
                StgDictObject dt = pyObjectStgDictNode.execute(value);
                assert (dt != null) : "Cannot be NULL for pointer or array objects";
                StgDictObject stgDictObject = dict = dt.proto != null ? pyTypeStgDictNode.execute(dt.proto) : null;
                if (dict != null && dict.setfunc == FFIType.FieldDesc.u.setfunc) {
                    return value;
                }
            }
            if (PGuards.isPyCArg(value)) {
                PyCArgObject a = (PyCArgObject)value;
                dict = pyObjectStgDictNode.execute(a.obj);
                if (dict != null && dict.setfunc == FFIType.FieldDesc.u.setfunc) {
                    return value;
                }
            }
            if ((as_parameter = lookupAttr.execute((Frame)frame, inliningTarget, value, CDataTypeBuiltins.T__AS_PARAMETER_)) != PNone.NO_VALUE) {
                return cwCharPFromParamNode.execute(frame, type, as_parameter);
            }
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.WRONG_TYPE);
        }
    }
}

