/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy;

public class GraalHPyBoxing {
    private static final long NAN_BOXING_BASE = 0x7000000000000L;
    private static final long NAN_BOXING_MASK = -281474976710656L;
    private static final long NAN_BOXING_INT = 0x1000000000000L;
    private static final long NAN_BOXING_INT_MASK = 0xFFFFFFFFL;
    private static final long NAN_BOXING_MAX_HANDLE = Integer.MAX_VALUE;
    public static final int SINGLETON_HANDLE_MAX = 3;

    public static boolean isBoxedDouble(long value) {
        return Long.compareUnsigned(value, 0x7000000000000L) >= 0;
    }

    public static boolean isBoxedHandle(long value) {
        return Long.compareUnsigned(value, Integer.MAX_VALUE) <= 0;
    }

    public static boolean isBoxedInt(long value) {
        return (value & 0xFFFF000000000000L) == 0x1000000000000L;
    }

    public static boolean isBoxedNullHandle(long value) {
        return value == 0L;
    }

    public static int unboxHandle(long value) {
        return (int)value;
    }

    public static long boxHandle(int handle) {
        return handle;
    }

    public static double unboxDouble(long value) {
        return Double.longBitsToDouble(value - 0x7000000000000L);
    }

    public static long boxDouble(double value) {
        assert (Long.compareUnsigned(Double.doubleToRawLongBits(value) + 0x7000000000000L, 0x7000000000000L) >= 0);
        long doubleBits = Double.doubleToRawLongBits(value);
        return doubleBits + 0x7000000000000L;
    }

    public static int unboxInt(long value) {
        return (int)(value - 0x1000000000000L);
    }

    public static long boxInt(int value) {
        return ((long)value & 0xFFFFFFFFL) + 0x1000000000000L;
    }

    public static boolean isBoxablePrimitive(Object value) {
        return value instanceof Double || value instanceof Integer;
    }
}

