/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.socket;

import com.oracle.graal.python.annotations.ClinicConverterFactory;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.socket.PSocket;
import com.oracle.graal.python.builtins.objects.socket.SocketNodesFactory;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyLongAsIntNode;
import com.oracle.graal.python.lib.PyTimeFromObjectNode;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PNodeWithRaise;
import com.oracle.graal.python.nodes.PNodeWithRaiseAndIndirectCall;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PosixConstants;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.net.IDN;

public abstract class SocketNodes {

    public static abstract class ParseTimeoutNode
    extends PNodeWithRaise {
        public abstract long execute(VirtualFrame var1, Object var2);

        @Specialization(guards={"isNone(none)"})
        static long parse(PNone none) {
            return -1L;
        }

        @Specialization(guards={"!isNone(seconds)"})
        long parse(VirtualFrame frame, Object seconds, @Bind(value="this") Node inliningTarget, @Cached PyTimeFromObjectNode timeFromObjectNode) {
            long timeout = timeFromObjectNode.execute(frame, inliningTarget, seconds, PyTimeFromObjectNode.RoundType.TIMEOUT, 1000000000L);
            if (timeout < 0L) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.TIMEOUT_VALUE_OUT_OF_RANGE);
            }
            return timeout;
        }
    }

    public static abstract class IdnaFromStringOrBytesConverterNode
    extends ArgumentCastNode.ArgumentCastNodeWithRaise {
        private final String builtinName;
        private final int argumentIndex;

        public IdnaFromStringOrBytesConverterNode(String builtinName, int argumentIndex) {
            this.builtinName = builtinName;
            this.argumentIndex = argumentIndex;
        }

        public abstract TruffleString execute(VirtualFrame var1, Object var2);

        @Specialization
        TruffleString convert(TruffleString value, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached.Shared @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return fromJavaStringNode.execute(this.idna(toJavaStringNode.execute((AbstractTruffleString)value)), PythonUtils.TS_ENCODING);
        }

        @Specialization
        TruffleString convert(PString value, @Cached CastToJavaStringNode cast, @Cached.Shared @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return fromJavaStringNode.execute(this.idna(cast.execute(value)), PythonUtils.TS_ENCODING);
        }

        @Specialization
        TruffleString convert(PBytesLike value, @Cached BytesNodes.ToBytesNode toBytesNode, @Cached.Shared @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return fromJavaStringNode.execute(IdnaFromStringOrBytesConverterNode.newString(toBytesNode.execute(value)), PythonUtils.TS_ENCODING);
        }

        @CompilerDirectives.TruffleBoundary
        private static String newString(byte[] bytes) {
            return new String(bytes);
        }

        @Fallback
        TruffleString error(Object value) {
            if (this.builtinName != null) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ARG_MUST_BE_STRING_OR_BYTELIKE_OR_BYTEARRAY, this.builtinName, this.argumentIndex, value);
            }
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.STR_BYTES_OR_BYTEARRAY_EXPECTED, value);
        }

        @CompilerDirectives.TruffleBoundary
        private String idna(String name) {
            try {
                return IDN.toASCII(name);
            }
            catch (IllegalArgumentException e) {
                throw this.raise(PythonBuiltinClassType.UnicodeError, ErrorMessages.IDN_ENC_FAILED, e.getMessage());
            }
        }

        @ClinicConverterFactory
        @NeverDefault
        public static IdnaFromStringOrBytesConverterNode create(@ClinicConverterFactory.BuiltinName String builtinName, @ClinicConverterFactory.ArgumentIndex int argumentIndex) {
            return SocketNodesFactory.IdnaFromStringOrBytesConverterNodeGen.create(builtinName, argumentIndex);
        }

        @NeverDefault
        public static IdnaFromStringOrBytesConverterNode create() {
            return SocketNodesFactory.IdnaFromStringOrBytesConverterNodeGen.create(null, 0);
        }
    }

    public static abstract class MakeIpAddrNode
    extends PNodeWithRaise {
        public abstract Object execute(VirtualFrame var1, PosixSupportLibrary.UniversalSockAddr var2);

        @Specialization(limit="1")
        Object makeAddr(VirtualFrame frame, PosixSupportLibrary.UniversalSockAddr addr, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @CachedLibrary(value="addr") PosixSupportLibrary.UniversalSockAddrLibrary addrLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            try {
                PythonContext context = PythonContext.get(this);
                int family = addrLib.getFamily(addr);
                if (family == PosixConstants.AF_INET.value) {
                    PosixSupportLibrary.Inet4SockAddr inet4SockAddr = addrLib.asInet4SockAddr(addr);
                    PosixSupport posixSupport = context.getPosixSupport();
                    return posixLib.getPathAsString(posixSupport, posixLib.inet_ntop(posixSupport, family, inet4SockAddr.getAddressAsBytes()));
                }
                if (family == PosixConstants.AF_INET6.value) {
                    PosixSupportLibrary.Inet6SockAddr inet6SockAddr = addrLib.asInet6SockAddr(addr);
                    PosixSupport posixSupport = context.getPosixSupport();
                    return posixLib.getPathAsString(posixSupport, posixLib.inet_ntop(posixSupport, family, inet6SockAddr.getAddress()));
                }
                throw this.raise(PythonBuiltinClassType.NotImplementedError, PythonUtils.toTruffleStringUncached("makesockaddr: unknown address family"));
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSError((Frame)frame, e.getErrorCode(), fromJavaStringNode.execute(e.getMessage(), PythonUtils.TS_ENCODING), null, null);
            }
        }
    }

    public static abstract class MakeSockAddrNode
    extends PNodeWithRaise {
        public abstract Object execute(VirtualFrame var1, PosixSupportLibrary.UniversalSockAddr var2);

        @Specialization(limit="1")
        Object makeSockAddr(VirtualFrame frame, PosixSupportLibrary.UniversalSockAddr addr, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @CachedLibrary(value="addr") PosixSupportLibrary.UniversalSockAddrLibrary addrLib, @Cached PythonObjectFactory factory, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            try {
                PythonContext context = PythonContext.get(this);
                int family = addrLib.getFamily(addr);
                if (family == PosixConstants.AF_INET.value) {
                    PosixSupportLibrary.Inet4SockAddr inet4SockAddr = addrLib.asInet4SockAddr(addr);
                    PosixSupport posixSupport = context.getPosixSupport();
                    TruffleString addressString = posixLib.getPathAsString(posixSupport, posixLib.inet_ntop(posixSupport, family, inet4SockAddr.getAddressAsBytes()));
                    return factory.createTuple(new Object[]{addressString, inet4SockAddr.getPort()});
                }
                if (family == PosixConstants.AF_INET6.value) {
                    PosixSupportLibrary.Inet6SockAddr inet6SockAddr = addrLib.asInet6SockAddr(addr);
                    PosixSupport posixSupport = context.getPosixSupport();
                    TruffleString addressString = posixLib.getPathAsString(posixSupport, posixLib.inet_ntop(posixSupport, family, inet6SockAddr.getAddress()));
                    return factory.createTuple(new Object[]{addressString, inet6SockAddr.getPort(), inet6SockAddr.getFlowInfo(), inet6SockAddr.getScopeId()});
                }
                if (family == PosixConstants.AF_UNIX.value) {
                    PosixSupportLibrary.UnixSockAddr unixSockAddr = addrLib.asUnixSockAddr(addr);
                    byte[] path = unixSockAddr.getPath();
                    if (PosixConstants.IS_LINUX && path.length > 0 && path[0] == 0) {
                        return factory.createBytes(PythonUtils.arrayCopyOf(path, path.length));
                    }
                    return MakeSockAddrNode.bytesToString(path, fromByteArrayNode, switchEncodingNode);
                }
                if (family == PosixConstants.AF_UNSPEC.value) {
                    return PNone.NONE;
                }
                throw this.raise(PythonBuiltinClassType.NotImplementedError, PythonUtils.toTruffleStringUncached("makesockaddr: unknown address family"));
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSError((Frame)frame, e.getErrorCode(), fromJavaStringNode.execute(e.getMessage(), PythonUtils.TS_ENCODING), null, null);
            }
        }

        private static TruffleString bytesToString(byte[] path, TruffleString.FromByteArrayNode fromByteArrayNode, TruffleString.SwitchEncodingNode switchEncodingNode) {
            int len;
            for (len = 0; len < path.length && path[len] != 0; ++len) {
            }
            return switchEncodingNode.execute((AbstractTruffleString)fromByteArrayNode.execute(path, 0, len, TruffleString.Encoding.UTF_8, true), PythonUtils.TS_ENCODING);
        }
    }

    public static abstract class SetIpAddrNode
    extends PNodeWithRaise {
        private static final TruffleString T_BROADCAST_IP = PythonUtils.tsLiteral("255.255.255.255");
        private static final TruffleString T_BROADCAST = PythonUtils.tsLiteral("<broadcast>");

        public abstract PosixSupportLibrary.UniversalSockAddr execute(VirtualFrame var1, TruffleString var2, int var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        @Specialization
        PosixSupportLibrary.UniversalSockAddr setipaddr(VirtualFrame frame, TruffleString name, int family, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @CachedLibrary(limit="1") PosixSupportLibrary.AddrInfoCursorLibrary addrInfoLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached TruffleString.EqualNode equalNode, @Cached TruffleString.ByteIndexOfCodePointNode byteIndexOfCodePointNode, @Cached GilNode gil) {
            try {
                PythonContext context = PythonContext.get(this);
                if (name.isEmpty()) {
                    gil.release(true);
                    try {
                        PosixSupport posixSupport = context.getPosixSupport();
                        PosixSupportLibrary.AddrInfoCursor cursor = posixLib.getaddrinfo(posixSupport, null, posixLib.createPathFromString(posixSupport, StringLiterals.T_ZERO), family, PosixConstants.SOCK_DGRAM.value, 0, PosixConstants.AI_PASSIVE.value);
                        try {
                            if (addrInfoLib.next(cursor)) {
                                throw this.raise(PythonBuiltinClassType.OSError, ErrorMessages.WILD_CARD_RESOLVED_TO_MULTIPLE_ADDRESS);
                            }
                            PosixSupportLibrary.UniversalSockAddr universalSockAddr = addrInfoLib.getSockAddr(cursor);
                            addrInfoLib.release(cursor);
                            return universalSockAddr;
                        }
                        catch (Throwable throwable) {
                            addrInfoLib.release(cursor);
                            throw throwable;
                        }
                    }
                    finally {
                        gil.acquire();
                    }
                }
                if (equalNode.execute((AbstractTruffleString)name, (AbstractTruffleString)T_BROADCAST_IP, PythonUtils.TS_ENCODING) || equalNode.execute((AbstractTruffleString)name, (AbstractTruffleString)T_BROADCAST, PythonUtils.TS_ENCODING)) {
                    if (family != PosixConstants.AF_INET.value && family != PosixConstants.AF_UNSPEC.value) {
                        throw this.raise(PythonBuiltinClassType.OSError, ErrorMessages.ADDRESS_FAMILY_MISMATCHED);
                    }
                    PosixSupport posixSupport = context.getPosixSupport();
                    return posixLib.createUniversalSockAddr(posixSupport, new PosixSupportLibrary.Inet4SockAddr(0, PosixConstants.INADDR_BROADCAST.value));
                }
                if (family == PosixConstants.AF_INET.value || family == PosixConstants.AF_UNSPEC.value) {
                    try {
                        PosixSupport posixSupport = context.getPosixSupport();
                        byte[] bytes = posixLib.inet_pton(posixSupport, PosixConstants.AF_INET.value, posixLib.createPathFromString(posixSupport, name));
                        return posixLib.createUniversalSockAddr(posixSupport, new PosixSupportLibrary.Inet4SockAddr(0, bytes));
                    }
                    catch (PosixSupportLibrary.InvalidAddressException | PosixSupportLibrary.PosixException posixSupport) {
                        // empty catch block
                    }
                }
                if (!(family != PosixConstants.AF_INET6.value && family != PosixConstants.AF_UNSPEC.value || SetIpAddrNode.hasScopeId(name, byteIndexOfCodePointNode))) {
                    try {
                        PosixSupport posixSupport = context.getPosixSupport();
                        byte[] bytes = posixLib.inet_pton(posixSupport, PosixConstants.AF_INET6.value, posixLib.createPathFromString(posixSupport, name));
                        return posixLib.createUniversalSockAddr(posixSupport, new PosixSupportLibrary.Inet6SockAddr(0, bytes, 0, 0));
                    }
                    catch (PosixSupportLibrary.InvalidAddressException | PosixSupportLibrary.PosixException posixSupport) {
                        // empty catch block
                    }
                }
                gil.release(true);
                try {
                    PosixSupport posixSupport = context.getPosixSupport();
                    PosixSupportLibrary.AddrInfoCursor cursor = posixLib.getaddrinfo(posixSupport, posixLib.createPathFromString(posixSupport, name), null, family, 0, 0, 0);
                    try {
                        PosixSupportLibrary.UniversalSockAddr universalSockAddr = addrInfoLib.getSockAddr(cursor);
                        addrInfoLib.release(cursor);
                        return universalSockAddr;
                    }
                    catch (Throwable throwable) {
                        addrInfoLib.release(cursor);
                        throw throwable;
                    }
                }
                finally {
                    gil.acquire();
                }
            }
            catch (PosixSupportLibrary.GetAddrInfoException e) {
                throw constructAndRaiseNode.get(inliningTarget).executeWithArgsOnly((Frame)frame, PythonBuiltinClassType.SocketGAIError, new Object[]{e.getErrorCode(), e.getMessage()});
            }
        }

        private static boolean hasScopeId(TruffleString name, TruffleString.ByteIndexOfCodePointNode byteIndexOfCodePointNode) {
            return byteIndexOfCodePointNode.execute((AbstractTruffleString)name, 37, 0, name.byteLength(PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING) >= 0;
        }
    }

    public static abstract class GetSockAddrArgNode
    extends PNodeWithRaiseAndIndirectCall {
        public abstract PosixSupportLibrary.UniversalSockAddr execute(VirtualFrame var1, PSocket var2, Object var3, String var4);

        @Specialization(guards={"isInet(socket)"})
        PosixSupportLibrary.UniversalSockAddr doInet(VirtualFrame frame, PSocket socket, Object address, String caller, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") @Cached.Shared(value="posixLib") PosixSupportLibrary posixLib, @CachedLibrary(limit="1") @Cached.Shared(value="sockAddrLib") PosixSupportLibrary.UniversalSockAddrLibrary sockAddrLib, @Cached @Cached.Shared(value="getObjectArray") SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached @Cached.Shared(value="asInt") PyLongAsIntNode asIntNode, @Cached @Cached.Shared(value="idnaConverter") IdnaFromStringOrBytesConverterNode idnaConverter, @Cached @Cached.Shared(value="errorProfile") BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached @Cached.Shared(value="setIpAddr") SetIpAddrNode setIpAddrNode) {
            PythonContext context = PythonContext.get(this);
            if (!(address instanceof PTuple)) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_AF_INET_VALUES_MUST_BE_TUPLE_NOT_P, caller, address);
            }
            Object[] hostAndPort = getObjectArrayNode.execute(inliningTarget, address);
            if (hostAndPort.length != 2) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.AF_INET_VALUES_MUST_BE_PAIR);
            }
            TruffleString host = idnaConverter.execute(frame, hostAndPort[0]);
            int port = this.parsePort(frame, caller, asIntNode, inliningTarget, errorProfile, hostAndPort[1]);
            PosixSupportLibrary.UniversalSockAddr addr = setIpAddrNode.execute(frame, host, PosixConstants.AF_INET.value);
            PosixSupport posixSupport = context.getPosixSupport();
            return posixLib.createUniversalSockAddr(posixSupport, new PosixSupportLibrary.Inet4SockAddr(port, sockAddrLib.asInet4SockAddr(addr).getAddress()));
        }

        @Specialization(guards={"isInet6(socket)"})
        PosixSupportLibrary.UniversalSockAddr doInet6(VirtualFrame frame, PSocket socket, Object address, String caller, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") @Cached.Shared(value="posixLib") PosixSupportLibrary posixLib, @CachedLibrary(limit="1") @Cached.Shared(value="sockAddrLib") PosixSupportLibrary.UniversalSockAddrLibrary sockAddrLib, @Cached @Cached.Shared(value="getObjectArray") SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached @Cached.Shared(value="asInt") PyLongAsIntNode asIntNode, @Cached @Cached.Shared(value="idnaConverter") IdnaFromStringOrBytesConverterNode idnaConverter, @Cached @Cached.Shared(value="errorProfile") BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached @Cached.Shared(value="setIpAddr") SetIpAddrNode setIpAddrNode) {
            PythonContext context = PythonContext.get(this);
            if (!(address instanceof PTuple)) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_AF_INET_VALUES_MUST_BE_TUPLE_NOT_S, caller, address);
            }
            Object[] hostAndPort = getObjectArrayNode.execute(inliningTarget, address);
            if (hostAndPort.length < 2 || hostAndPort.length > 4) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.AF_INET6_ADDR_MUST_BE_TUPLE);
            }
            TruffleString host = idnaConverter.execute(frame, hostAndPort[0]);
            int port = this.parsePort(frame, caller, asIntNode, inliningTarget, errorProfile, hostAndPort[1]);
            int flowinfo = 0;
            if (hostAndPort.length > 2 && ((flowinfo = asIntNode.execute((Frame)frame, inliningTarget, hostAndPort[2])) < 0 || flowinfo > 1048575)) {
                throw this.raise(PythonBuiltinClassType.OverflowError, ErrorMessages.S_FLOWINFO_RANGE, caller);
            }
            int scopeid = 0;
            if (hostAndPort.length > 3) {
                scopeid = asIntNode.execute((Frame)frame, inliningTarget, hostAndPort[3]);
            }
            PosixSupportLibrary.UniversalSockAddr addr = setIpAddrNode.execute(frame, host, PosixConstants.AF_INET6.value);
            PosixSupport posixSupport = context.getPosixSupport();
            return posixLib.createUniversalSockAddr(posixSupport, new PosixSupportLibrary.Inet6SockAddr(port, sockAddrLib.asInet6SockAddr(addr).getAddress(), flowinfo, scopeid));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isUnix(socket)"})
        PosixSupportLibrary.UniversalSockAddr doUnix(VirtualFrame frame, PSocket socket, Object address, String caller, @Bind(value="this") Node inliningTarget, @Cached PyUnicodeCheckNode unicodeCheckNode, @Cached CastToTruffleStringNode toTruffleStringNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode, @CachedLibrary(limit="1") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @CachedLibrary(limit="1") @Cached.Shared(value="posixLib") PosixSupportLibrary posixLib) {
            byte[] path;
            if (unicodeCheckNode.execute(inliningTarget, address)) {
                TruffleString utf8 = switchEncodingNode.execute((AbstractTruffleString)toTruffleStringNode.execute(inliningTarget, address), TruffleString.Encoding.UTF_8);
                path = copyToByteArrayNode.execute((AbstractTruffleString)utf8, TruffleString.Encoding.UTF_8);
            } else {
                Object buffer = bufferAcquireLib.acquireReadonly(address, frame, this);
                try {
                    path = bufferLib.getCopiedByteArray(buffer);
                }
                finally {
                    bufferLib.release(buffer, frame, this);
                }
            }
            if (!PosixConstants.IS_LINUX || path.length > 0 && path[0] != 0) {
                path = PythonUtils.arrayCopyOf(path, path.length + 1);
            }
            if (path.length > PosixConstants.SIZEOF_STRUCT_SOCKADDR_UN_SUN_PATH.value) {
                throw this.raise(PythonBuiltinClassType.OSError, ErrorMessages.AF_UNIX_PATH_TOO_LONG, caller);
            }
            PythonContext context = PythonContext.get(this);
            PosixSupport posixSupport = context.getPosixSupport();
            try {
                return posixLib.createUniversalSockAddr(posixSupport, new PosixSupportLibrary.UnixSockAddr(path));
            }
            catch (PosixSupportLibrary.UnsupportedPosixFeatureException e) {
                throw this.raise(PythonBuiltinClassType.OSError, ErrorMessages.AF_UNIX_NOT_SUPPORTED, caller);
            }
        }

        @Specialization(guards={"!isInet(socket)", "!isInet6(socket)", "!isUnix(socket)"})
        PosixSupportLibrary.UniversalSockAddr getSockAddr(VirtualFrame frame, PSocket socket, Object address, String caller) {
            throw this.raise(PythonBuiltinClassType.OSError, ErrorMessages.BAD_FAMILY, caller);
        }

        static boolean isInet(PSocket socket) {
            return socket.getFamily() == PosixConstants.AF_INET.value;
        }

        static boolean isInet6(PSocket socket) {
            return socket.getFamily() == PosixConstants.AF_INET6.value;
        }

        static boolean isUnix(PSocket socket) {
            return socket.getFamily() == PosixConstants.AF_UNIX.value;
        }

        private int parsePort(VirtualFrame frame, String caller, PyLongAsIntNode asIntNode, Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, Object portObj) {
            int port;
            try {
                port = asIntNode.execute((Frame)frame, inliningTarget, portObj);
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonBuiltinClassType.OverflowError, errorProfile);
                port = -1;
            }
            if (port < 0 || port > 65535) {
                throw this.raise(PythonBuiltinClassType.OverflowError, ErrorMessages.S_PORT_RANGE, caller);
            }
            return port;
        }
    }
}

