/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.lib.PyUnicodeDecode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.IndirectCallData;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class PyUnicodeFromEncodedObject
extends PNodeWithContext {
    public abstract Object execute(Frame var1, Node var2, Object var3, Object var4, Object var5);

    @Specialization
    static Object doBytes(VirtualFrame frame, Node inliningTarget, PBytes object, Object encoding, Object errors, @Cached.Exclusive @Cached InlinedConditionProfile emptyStringProfile, @Cached.Exclusive @Cached PyUnicodeDecode decode) {
        if (emptyStringProfile.profile(inliningTarget, object.getSequenceStorage().length() == 0)) {
            return StringLiterals.T_EMPTY_STRING;
        }
        return decode.execute((Frame)frame, inliningTarget, object, encoding, errors);
    }

    @Specialization
    static Object doString(VirtualFrame frame, TruffleString object, Object encoding, Object errors, @Cached.Shared @Cached(inline=false) PRaiseNode raiseNode) {
        throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.DECODING_STR_NOT_SUPPORTED);
    }

    @Specialization
    static Object doPString(VirtualFrame frame, PString object, Object encoding, Object errors, @Cached.Shared @Cached(inline=false) PRaiseNode raiseNode) {
        throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.DECODING_STR_NOT_SUPPORTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(guards={"!isPBytes(object)", "!isString(object)"}, limit="3")
    static Object doBuffer(VirtualFrame frame, Node inliningTarget, Object object, Object encoding, Object errors, @Cached(inline=false) IndirectCallData indirectCallNode, @Cached.Exclusive @Cached InlinedConditionProfile emptyStringProfile, @CachedLibrary(value="object") PythonBufferAcquireLibrary bufferAcquireLib, @Cached.Exclusive @Cached PyUnicodeDecode decode, @CachedLibrary(value="object") PythonBufferAccessLibrary bufferLib, @Cached(inline=false) TruffleString.FromByteArrayNode fromByteArrayNode, @Cached(inline=false) TruffleString.SwitchEncodingNode switchEncodingNode) {
        Object buffer = bufferAcquireLib.acquireReadonly(object, frame, PythonContext.get(inliningTarget), PythonLanguage.get(inliningTarget), indirectCallNode);
        try {
            int len = bufferLib.getBufferLength(buffer);
            if (emptyStringProfile.profile(inliningTarget, len == 0)) {
                TruffleString truffleString = StringLiterals.T_EMPTY_STRING;
                return truffleString;
            }
            TruffleString utf8 = fromByteArrayNode.execute(bufferLib.getInternalOrCopiedByteArray(object), 0, len, TruffleString.Encoding.UTF_8, true);
            TruffleString unicode = switchEncodingNode.execute((AbstractTruffleString)utf8, PythonUtils.TS_ENCODING);
            Object object2 = decode.execute((Frame)frame, inliningTarget, unicode, encoding, errors);
            return object2;
        }
        finally {
            bufferLib.release(object, frame, indirectCallNode);
        }
    }
}

