/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.builtins.objects.mmap.PMMap;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.util.BufferToTruffleStringNodeGen;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.sequence.storage.NativeByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;

@ImportStatic(value={PGuards.class})
public abstract class BufferToTruffleStringNode
extends PNodeWithContext {
    protected final boolean allowMemoryView;

    protected BufferToTruffleStringNode(boolean allowMemoryView) {
        this.allowMemoryView = allowMemoryView;
    }

    public abstract TruffleString execute(Object var1, int var2);

    @Specialization(guards={"bufferLib.hasInternalByteArray(buffer)"}, limit="4")
    static TruffleString doWithInternalByteArray(Object buffer, int byteOffset, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached TruffleString.FromByteArrayNode fromByteArrayNode) {
        PythonBufferAccessLibrary.assertIsBuffer(buffer);
        byte[] bytes = bufferLib.getInternalByteArray(buffer);
        int bytesLen = bufferLib.getBufferLength(buffer);
        return fromByteArrayNode.execute(bytes, byteOffset, bytesLen - byteOffset, TruffleString.Encoding.ISO_8859_1, false);
    }

    @Specialization(guards={"isNativeByteSequenceStorage(bytes.getSequenceStorage())"})
    static TruffleString doNativeBytesLike(PBytesLike bytes, int byteOffset, @Cached.Shared @Cached TruffleString.FromNativePointerNode fromNativePointerNode) {
        NativeByteSequenceStorage store = (NativeByteSequenceStorage)bytes.getSequenceStorage();
        Object ptr = store.getPtr();
        int bytesLen = store.length();
        return fromNativePointerNode.execute(ptr, byteOffset, bytesLen - byteOffset, TruffleString.Encoding.ISO_8859_1, false);
    }

    @Specialization
    static TruffleString doMMap(PMMap mmap, int byteOffset, @Bind(value="this") Node inliningTarget, @Cached InlinedBranchProfile unsupportedPosix, @CachedLibrary(limit="4") PosixSupportLibrary posixLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached TruffleString.FromNativePointerNode fromNativePointerNode, @Cached.Shared @Cached TruffleString.FromByteArrayNode fromByteArrayNode) {
        int bytesLen = bufferLib.getBufferLength(mmap);
        try {
            MMapPointer ptr = new MMapPointer(posixLib.mmapGetPointer(PythonContext.get(inliningTarget).getPosixSupport(), mmap.getPosixSupportHandle()));
            return fromNativePointerNode.execute((Object)ptr, byteOffset, bytesLen - byteOffset, TruffleString.Encoding.ISO_8859_1, false);
        }
        catch (PosixSupportLibrary.UnsupportedPosixFeatureException e) {
            unsupportedPosix.enter(inliningTarget);
            byte[] bytes = bufferLib.getInternalOrCopiedByteArray(mmap);
            return fromByteArrayNode.execute(bytes, byteOffset, bytesLen - byteOffset, TruffleString.Encoding.ISO_8859_1, false);
        }
    }

    @Specialization(guards={"allowMemoryView"})
    static TruffleString doMemoryView(PMemoryView memoryView, int byteOffset, @Cached(value="create(false)") BufferToTruffleStringNode bufferToTruffleStringNode) {
        int internalByteOffset = memoryView.getOffset();
        return bufferToTruffleStringNode.execute(memoryView.getBuffer(), byteOffset + internalByteOffset);
    }

    @Fallback
    static TruffleString doWithInternalOrCopiedByteArray(Object buffer, int byteOffset, @CachedLibrary(limit="5") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached TruffleString.FromByteArrayNode fromByteArrayNode) {
        PythonBufferAccessLibrary.assertIsBuffer(buffer);
        byte[] bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
        int bytesLen = bufferLib.getBufferLength(buffer);
        return fromByteArrayNode.execute(bytes, byteOffset, bytesLen - byteOffset, TruffleString.Encoding.ISO_8859_1, false);
    }

    protected static boolean isNativeByteSequenceStorage(SequenceStorage store) {
        return store instanceof NativeByteSequenceStorage;
    }

    @NeverDefault
    public static BufferToTruffleStringNode create() {
        return BufferToTruffleStringNode.create(true);
    }

    @NeverDefault
    public static BufferToTruffleStringNode create(boolean allowMemoryView) {
        return BufferToTruffleStringNodeGen.create(allowMemoryView);
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class MMapPointer
    implements TruffleObject {
        public final long pointer;

        public MMapPointer(long pointer) {
            this.pointer = pointer;
        }

        @ExportMessage
        boolean isPointer() {
            return true;
        }

        @ExportMessage
        long asPointer() {
            return this.pointer;
        }
    }
}

