/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.runtime.AsyncHandler;
import com.oracle.graal.python.runtime.NativeLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;

public class NFIBz2Support {
    private static final TruffleLogger LOGGER = PythonLanguage.getLogger(NFIBz2Support.class);
    private static final String SUPPORTING_NATIVE_LIB_NAME = "bz2support";
    private final PythonContext pythonContext;
    private final NativeLibrary.TypedNativeLibrary<Bz2NativeFunctions> typedNativeLib;
    @CompilerDirectives.CompilationFinal
    private boolean available;

    private NFIBz2Support(PythonContext context, NativeLibrary.NFIBackend backend, String noNativeAccessHelp) {
        if (context.isNativeAccessAllowed()) {
            this.pythonContext = context;
            this.typedNativeLib = NativeLibrary.create((String)PythonContext.getSupportLibName(SUPPORTING_NATIVE_LIB_NAME), (Enum[])Bz2NativeFunctions.values(), (NativeLibrary.NFIBackend)backend, (String)noNativeAccessHelp, (boolean)false);
            this.available = true;
        } else {
            this.pythonContext = null;
            this.typedNativeLib = null;
            this.available = false;
        }
    }

    public static NFIBz2Support createNative(PythonContext context, String noNativeAccessHelp) {
        return new NFIBz2Support(context, NativeLibrary.NFIBackend.NATIVE, noNativeAccessHelp);
    }

    public static NFIBz2Support createLLVM(PythonContext context, String noNativeAccessHelp) {
        return new NFIBz2Support(context, NativeLibrary.NFIBackend.LLVM, noNativeAccessHelp);
    }

    public void notAvailable() {
        if (this.available) {
            CompilerAsserts.neverPartOfCompilation((String)"Checking NFIBz2Support availability should only be done during initialization.");
            this.available = false;
        }
    }

    public boolean isAvailable() {
        return this.available;
    }

    public Object getTimeElapsed(Object zst) {
        return this.typedNativeLib.callUncached(this.pythonContext, Bz2NativeFunctions.bz_get_timeElapsed, zst);
    }

    public Object gcReleaseHelper(Object bzst) {
        return this.typedNativeLib.callUncached(this.pythonContext, Bz2NativeFunctions.bz_gc_helper, bzst);
    }

    public Object createStream(NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.call(this.typedNativeLib, Bz2NativeFunctions.bz_create_bzst_stream, new Object[0]);
    }

    public void deallocateStream(Object bzst, NativeLibrary.InvokeNativeFunction invokeNode2) {
        invokeNode2.call(this.typedNativeLib, Bz2NativeFunctions.bz_free_stream, bzst);
    }

    public long getNextInIndex(Object bzst, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callLong(this.typedNativeLib, Bz2NativeFunctions.bz_get_next_in_index, bzst);
    }

    public long getBzsAvailInReal(Object bzst, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callLong(this.typedNativeLib, Bz2NativeFunctions.bz_get_bzs_avail_in_real, bzst);
    }

    public void setBzsAvailInReal(Object bzst, long v, NativeLibrary.InvokeNativeFunction invokeNode2) {
        invokeNode2.call(this.typedNativeLib, Bz2NativeFunctions.bz_set_bzs_avail_in_real, bzst, v);
    }

    public long getOutputBufferSize(Object bzst, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callLong(this.typedNativeLib, Bz2NativeFunctions.bz_get_output_buffer_size, bzst);
    }

    public void getOutputBuffer(Object bzst, Object dest, NativeLibrary.InvokeNativeFunction invokeNode2) {
        invokeNode2.call(this.typedNativeLib, Bz2NativeFunctions.bz_get_output_buffer, bzst, dest);
    }

    public int compressInit(Object bzst, int compresslevel, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, Bz2NativeFunctions.bz_compressor_init, bzst, compresslevel);
    }

    public int compress(Object bzst, Object data, long len, int action, long bufsize, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, Bz2NativeFunctions.bz_compress, bzst, data, len, action, bufsize);
    }

    public int decompressInit(Object bzst, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, Bz2NativeFunctions.bz_decompress_init, bzst);
    }

    public int decompress(Object bzst, Object input_buffer, long offset, long max_length, long bufsize, long bzs_avail_in_real, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, Bz2NativeFunctions.bz_decompress, bzst, input_buffer, offset, max_length, bufsize, bzs_avail_in_real);
    }

    static enum Bz2NativeFunctions implements NativeLibrary.NativeFunction
    {
        bz_create_bzst_stream("(): POINTER"),
        bz_get_timeElapsed("(POINTER): DOUBLE"),
        bz_free_stream("(POINTER): VOID"),
        bz_gc_helper("(POINTER): VOID"),
        bz_get_next_in_index("(POINTER): SINT64"),
        bz_get_bzs_avail_in_real("(POINTER): SINT64"),
        bz_set_bzs_avail_in_real("(POINTER, SINT64): VOID"),
        bz_get_output_buffer_size("(POINTER): UINT64"),
        bz_get_output_buffer("(POINTER, [UINT8]): VOID"),
        bz_compressor_init("(POINTER, SINT32): SINT32"),
        bz_compress("(POINTER, [UINT8], SINT64, SINT32, SINT64): SINT32"),
        bz_decompress_init("(POINTER): SINT32"),
        bz_decompress("(POINTER, [UINT8], SINT64, SINT64, SINT64, SINT64): SINT32");

        private final String signature;

        private Bz2NativeFunctions(String signature) {
            this.signature = signature;
        }

        @Override
        public String signature() {
            return this.signature;
        }
    }

    public static class Pointer
    extends AsyncHandler.SharedFinalizer.FinalizableReference {
        private final NFIBz2Support lib;

        public Pointer(Object referent, Object ptr, NFIBz2Support lib) {
            super(referent, ptr, lib.pythonContext.getSharedFinalizer());
            this.lib = lib;
        }

        protected void doRelease() {
            this.lib.gcReleaseHelper(this.getReference());
        }

        @Override
        public AsyncHandler.AsyncAction release() {
            if (!this.isReleased()) {
                return new PointerReleaseCallback(this);
            }
            return null;
        }
    }

    static class PointerReleaseCallback
    implements AsyncHandler.AsyncAction {
        private final Pointer pointer;

        public PointerReleaseCallback(Pointer pointer) {
            this.pointer = pointer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(PythonContext context) {
            Pointer pointer = this.pointer;
            synchronized (pointer) {
                if (this.pointer.isReleased()) {
                    return;
                }
                try {
                    this.pointer.doRelease();
                    this.pointer.markReleased();
                    LOGGER.finest("NFIBz2Support pointer has been freed");
                }
                catch (Exception e) {
                    LOGGER.severe("Error while trying to free NFIBz2Support pointer: " + e.getMessage());
                }
            }
        }
    }
}

