/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.formatting;

import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.lib.PyMappingCheckNode;
import com.oracle.graal.python.lib.PyObjectAsciiNode;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.lib.PyObjectStrAsTruffleStringNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.formatting.FormatProcessor;
import com.oracle.graal.python.runtime.formatting.FormattingBuffer;
import com.oracle.graal.python.runtime.formatting.InternalFormat;
import com.oracle.graal.python.runtime.formatting.TextFormatter;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.strings.TruffleString;

public final class StringFormatProcessor
extends FormatProcessor<String> {
    private final String formatText;

    public StringFormatProcessor(Python3Core core, PRaiseNode raiseNode, TupleBuiltins.GetItemNode getTupleItemNode, String format) {
        super(core, raiseNode, getTupleItemNode, new FormattingBuffer.StringFormattingBuffer(format.length() + 100));
        this.index = 0;
        this.formatText = format;
    }

    @Override
    protected String getFormatType() {
        return "string";
    }

    @Override
    public char pop() {
        try {
            return this.formatText.charAt(this.index++);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw this.raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.INCOMPLETE_FORMAT);
        }
    }

    @Override
    boolean hasNext() {
        return this.index < this.formatText.length();
    }

    @Override
    int parseNumber(int start, int end) {
        return Integer.parseInt(this.formatText.substring(start, end));
    }

    @Override
    Object parseMappingKey(int start, int end) {
        return PythonUtils.toTruffleStringUncached(this.formatText.substring(start, end));
    }

    @Override
    protected boolean isMapping(Object obj) {
        return !(obj instanceof PTuple) && !(obj instanceof PString) && !(obj instanceof TruffleString) && !TruffleStringMigrationHelpers.isJavaString(obj) && PyMappingCheckNode.executeUncached(obj);
    }

    private static boolean isOneCharacter(String str) {
        return str.length() == 1 || str.length() == 2 && str.codePointCount(0, 2) == 1;
    }

    @Override
    protected InternalFormat.Formatter handleSingleCharacterFormat(InternalFormat.Spec spec) {
        InternalFormat.Formatter f;
        Object arg = this.getArg();
        if (arg instanceof PString) {
            arg = ((PString)arg).getValueUncached();
        }
        if (arg instanceof TruffleString && ((TruffleString)arg).codePointLengthUncached(PythonUtils.TS_ENCODING) == 1) {
            TextFormatter ft = this.setupFormat(new TextFormatter(this.raiseNode, this.buffer, spec));
            f = ft;
            ft.format(((TruffleString)arg).toJavaStringUncached());
        } else if (TruffleStringMigrationHelpers.isJavaString(arg) && StringFormatProcessor.isOneCharacter((String)arg)) {
            TextFormatter ft = this.setupFormat(new TextFormatter(this.raiseNode, this.buffer, spec));
            f = ft;
            ft.format((String)arg);
        } else {
            f = this.formatInteger(this.asNumber(arg, spec.type), spec);
            if (f == null) {
                throw this.raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.REQUIRES_INT_OR_CHAR, Character.valueOf(spec.type));
            }
        }
        return f;
    }

    @Override
    protected InternalFormat.Formatter handleRemainingFormats(InternalFormat.Spec spec) {
        TruffleString result;
        Object arg = this.getArg();
        switch (spec.type) {
            case 'a': {
                result = PyObjectAsciiNode.executeUncached(arg);
                break;
            }
            case 's': {
                result = PyObjectStrAsTruffleStringNode.executeUncached(arg);
                break;
            }
            case 'r': {
                result = PyObjectReprAsTruffleStringNode.executeUncached(arg);
                break;
            }
            default: {
                return null;
            }
        }
        TextFormatter ft = new TextFormatter(this.raiseNode, this.buffer, spec);
        ft.format(result.toJavaStringUncached());
        return ft;
    }
}

