/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python;

import com.oracle.graal.python.PythonFileDetector;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.modules.MarshalModuleBuiltins;
import com.oracle.graal.python.builtins.modules.SignalModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.ellipsis.PEllipsis;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.BuiltinMethodDescriptor;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.type.MroShape;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.TypeBuiltins;
import com.oracle.graal.python.compiler.CodeUnit;
import com.oracle.graal.python.compiler.CompilationUnit;
import com.oracle.graal.python.compiler.Compiler;
import com.oracle.graal.python.compiler.RaisePythonExceptionErrorCallback;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.HiddenAttributes;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.GenericInvokeNode;
import com.oracle.graal.python.nodes.exception.TopLevelExceptionHandler;
import com.oracle.graal.python.nodes.frame.GetFrameLocalsNode;
import com.oracle.graal.python.nodes.frame.MaterializeFrameNode;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.pegparser.FutureFeature;
import com.oracle.graal.python.pegparser.InputType;
import com.oracle.graal.python.pegparser.NodeFactory;
import com.oracle.graal.python.pegparser.Parser;
import com.oracle.graal.python.pegparser.sst.ArgTy;
import com.oracle.graal.python.pegparser.sst.ArgumentsTy;
import com.oracle.graal.python.pegparser.sst.ModTy;
import com.oracle.graal.python.pegparser.sst.StmtTy;
import com.oracle.graal.python.pegparser.tokenizer.SourceRange;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.Function;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ContextThreadLocal;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.debug.DebuggerTags;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.ProvidedTags;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExecutableNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionValues;

@TruffleLanguage.Registration(id="python", name="Python", implementationName="GraalPy", version="3.10.13", characterMimeTypes={"text/x-python", "text/x-python-\u0000\u0000-eval", "text/x-python-\u0000\u0000-compile", "text/x-python-\u0001\u0000-eval", "text/x-python-\u0001\u0000-compile", "text/x-python-\u0002\u0000-eval", "text/x-python-\u0002\u0000-compile", "text/x-python-\u0000\u0100-eval", "text/x-python-\u0000\u0100-compile", "text/x-python-\u0001\u0100-eval", "text/x-python-\u0001\u0100-compile", "text/x-python-\u0002\u0100-eval", "text/x-python-\u0002\u0100-compile", "text/x-python-\u0000@-eval", "text/x-python-\u0000@-compile", "text/x-python-\u0001@-eval", "text/x-python-\u0001@-compile", "text/x-python-\u0002@-eval", "text/x-python-\u0002@-compile", "text/x-python-\u0000\u0140-eval", "text/x-python-\u0000\u0140-compile", "text/x-python-\u0001\u0140-eval", "text/x-python-\u0001\u0140-compile", "text/x-python-\u0002\u0140-eval", "text/x-python-\u0002\u0140-compile"}, byteMimeTypes={"application/x-python-bytecode"}, defaultMimeType="text/x-python", dependentLanguages={"nfi", "llvm"}, interactive=true, internal=false, contextPolicy=TruffleLanguage.ContextPolicy.SHARED, fileTypeDetectors={PythonFileDetector.class}, website="https://www.graalvm.org/python/")
@ProvidedTags(value={StandardTags.CallTag.class, StandardTags.StatementTag.class, StandardTags.RootTag.class, StandardTags.RootBodyTag.class, StandardTags.TryBlockTag.class, StandardTags.ExpressionTag.class, StandardTags.ReadVariableTag.class, StandardTags.WriteVariableTag.class, DebuggerTags.AlwaysHalt.class})
public final class PythonLanguage
extends TruffleLanguage<PythonContext> {
    public static final String J_GRAALPYTHON_ID = "graalpy";
    public static final TruffleString T_GRAALPYTHON_ID = PythonUtils.tsLiteral("graalpy");
    public static final String ID = "python";
    public static final String NAME = "Python";
    public static final String IMPLEMENTATION_NAME = "GraalPy";
    public static final int MAJOR = 3;
    public static final int MINOR = 10;
    public static final int MICRO = 13;
    public static final int RELEASE_LEVEL_ALPHA = 10;
    public static final int RELEASE_LEVEL_BETA = 11;
    public static final int RELEASE_LEVEL_GAMMA = 12;
    public static final int RELEASE_LEVEL_FINAL = 15;
    public static final int RELEASE_LEVEL = 10;
    public static final TruffleString RELEASE_LEVEL_STRING;
    public static final String FROZEN_FILENAME_PREFIX = "<frozen ";
    public static final String FROZEN_FILENAME_SUFFIX = ">";
    public static final int GRAALVM_MAJOR = 24;
    public static final int GRAALVM_MINOR = 0;
    public static final String DEV_TAG;
    public static final int RELEASE_SERIAL = 0;
    public static final int VERSION_HEX = 50990496;
    public static final String VERSION = "3.10.13";
    public static final int API_VERSION = 1013;
    public static final String MIME_TYPE = "text/x-python";
    static final String MIME_PREFIX = "text/x-python-";
    static final int OPT_FLAGS_LEN = 2;
    static final String MIME_KIND_COMPILE = "compile";
    static final String MIME_KIND_EVAL = "eval";
    static final int MIME_FLAG_SHIFTBY = 16;
    static final int MIME_KIND_START;
    public static final String MIME_TYPE_BYTECODE = "application/x-python-bytecode";
    public static final TruffleString[] T_DEFAULT_PYTHON_EXTENSIONS;
    private static final TruffleLogger LOGGER;
    private static final TruffleLanguage.LanguageReference<PythonLanguage> REFERENCE;
    public final Assumption noTracingOrProfilingAssumption = Assumption.create((String)"No tracing function was set");
    @CompilerDirectives.CompilationFinal
    private boolean singleContext = true;
    public final Assumption singleThreadedAssumption = Truffle.getRuntime().createAssumption("Only a single thread is active");
    private final ConcurrentHashMap<Object, RootCallTarget> cachedCallTargets = new ConcurrentHashMap();
    private final ConcurrentHashMap<BuiltinMethodDescriptor, RootCallTarget> descriptorCallTargets = new ConcurrentHashMap();
    private final Shape emptyShape = Shape.newBuilder().allowImplicitCastIntToDouble(false).allowImplicitCastIntToLong(true).shapeFlags(0).propertyAssumptions(true).build();
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Shape[] builtinTypeInstanceShapes = new Shape[PythonBuiltinClassType.VALUES.length];
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final Object[] CONTEXT_INSENSITIVE_SINGLETONS;
    public final ConcurrentHashMap<TruffleString, Semaphore> namedSemaphores = new ConcurrentHashMap();
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private volatile Object[] engineOptionsStorage;
    @CompilerDirectives.CompilationFinal
    private volatile OptionValues engineOptions;
    private Shape cApiSymbolCache;
    private final ContextThreadLocal<PythonContext.PythonThreadState> threadState = this.locals.createContextThreadLocal(PythonContext.PythonThreadState::new);
    public final ConcurrentHashMap<String, HiddenKey> typeHiddenKeys = new ConcurrentHashMap<String, HiddenKey>(TypeBuiltins.INITIAL_HIDDEN_TYPE_KEYS);
    private final MroShape mroShapeRoot = MroShape.createRoot();
    private final ConcurrentHashMap<TruffleString, CallTarget> cachedCode = new ConcurrentHashMap();
    private final Map<Node, IndirectCallData> indirectCallDataMap = Collections.synchronizedMap(new WeakHashMap());

    private static boolean mimeTypesComplete(ArrayList<String> mimeJavaStrings) {
        ArrayList<CallSite> mimeTypes = new ArrayList<CallSite>();
        FutureFeature[] all = FutureFeature.values();
        for (int flagset = 0; flagset < 1 << all.length; ++flagset) {
            int flags = 0;
            for (int i = 0; i < all.length; ++i) {
                if ((flagset & 1 << i) == 0) continue;
                flags |= all[i].flagValue;
            }
            for (int opt = 0; opt <= 2; ++opt) {
                for (String typ : new String[]{MIME_KIND_EVAL, MIME_KIND_COMPILE}) {
                    mimeTypes.add((CallSite)((Object)(MIME_PREFIX + PythonLanguage.optFlagsToMime(opt, flags) + "-" + typ)));
                    mimeJavaStrings.add(String.format("\"%s\\%d\\u%04x-%s\"", MIME_PREFIX, opt, flags >> 16, typ));
                }
            }
        }
        HashSet<String> currentMimeTypes = new HashSet<String>(List.of(PythonLanguage.class.getAnnotation(TruffleLanguage.Registration.class).characterMimeTypes()));
        return currentMimeTypes.containsAll(mimeTypes);
    }

    @Idempotent
    public boolean isSingleContext() {
        return this.singleContext;
    }

    public static PythonLanguage get(Node node) {
        return (PythonLanguage)REFERENCE.get(node);
    }

    public static int getNumberOfSpecialSingletons() {
        return CONTEXT_INSENSITIVE_SINGLETONS.length;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN)
    public static int getSingletonNativeWrapperIdx(Object obj) {
        for (int i = 0; i < CONTEXT_INSENSITIVE_SINGLETONS.length; ++i) {
            if (CONTEXT_INSENSITIVE_SINGLETONS[i] != obj) continue;
            return i;
        }
        return -1;
    }

    public ContextThreadLocal<PythonContext.PythonThreadState> getThreadStateLocal() {
        return this.threadState;
    }

    public MroShape getMroShapeRoot() {
        return this.mroShapeRoot;
    }

    protected void finalizeContext(PythonContext context) {
        context.finalizeContext();
        super.finalizeContext((Object)context);
    }

    protected boolean areOptionsCompatible(OptionValues firstOptions, OptionValues newOptions) {
        return PythonOptions.areOptionsCompatible(firstOptions, newOptions);
    }

    protected boolean patchContext(PythonContext context, TruffleLanguage.Env newEnv) {
        if (!this.areOptionsCompatible(context.getEnv().getOptions(), newEnv.getOptions())) {
            Python3Core.writeInfo("Cannot use preinitialized context.");
            return false;
        }
        context.initializeHomeAndPrefixPaths(newEnv, this.getLanguageHome());
        Python3Core.writeInfo("Using preinitialized context.");
        context.patch(newEnv);
        return true;
    }

    protected PythonContext createContext(TruffleLanguage.Env env) {
        PythonContext context = new PythonContext(this, env);
        context.initializeHomeAndPrefixPaths(env, this.getLanguageHome());
        Object[] engineOptionsUnroll = this.engineOptionsStorage;
        if (engineOptionsUnroll == null) {
            this.engineOptionsStorage = PythonOptions.createEngineOptionValuesStorage(env);
        } else assert (Arrays.equals(engineOptionsUnroll, PythonOptions.createEngineOptionValuesStorage(env))) : "invalid engine options";
        OptionValues options = this.engineOptions;
        if (options == null) {
            this.engineOptions = PythonOptions.createEngineOptions(env);
        } else assert (this.areOptionsCompatible(options, PythonOptions.createEngineOptions(env))) : "invalid engine options";
        return context;
    }

    @Idempotent
    public <T> T getEngineOption(OptionKey<T> key) {
        assert (this.engineOptions != null);
        if (CompilerDirectives.inInterpreter()) {
            return (T)this.engineOptions.get(key);
        }
        return PythonOptions.getOptionUnrolling(this.engineOptionsStorage, PythonOptions.getEngineOptionKeys(), key);
    }

    protected OptionDescriptors getOptionDescriptors() {
        return PythonOptions.DESCRIPTORS;
    }

    protected void initializeContext(PythonContext context) {
        context.initialize();
    }

    private static String optFlagsToMime(int optimize, int flags) {
        if (optimize < 0) {
            optimize = 0;
        } else if (optimize > 2) {
            optimize = 2;
        }
        String optField = new String(new byte[]{(byte)optimize});
        String flagField = new String(new int[]{(flags & FutureFeature.ALL_FLAGS) >> 16}, 0, 1);
        assert (flagField.length() == 1) : "flags in mime type ended up a surrogate";
        return optField + flagField;
    }

    public static String getCompileMimeType(int optimize, int flags) {
        String optFlags = PythonLanguage.optFlagsToMime(optimize, flags);
        return MIME_PREFIX + optFlags + "-compile";
    }

    public static String getEvalMimeType(int optimize, int flags) {
        String optFlags = PythonLanguage.optFlagsToMime(optimize, flags);
        return MIME_PREFIX + optFlags + "-eval";
    }

    protected CallTarget parse(TruffleLanguage.ParsingRequest request) {
        InputType type;
        PythonContext context = PythonContext.get(null);
        Source source = request.getSource();
        if (source.getMimeType() == null || MIME_TYPE.equals(source.getMimeType())) {
            if (!request.getArgumentNames().isEmpty() && source.isInteractive()) {
                throw new IllegalStateException("parse with arguments not allowed for interactive sources");
            }
            InputType inputType = source.isInteractive() ? InputType.SINGLE : InputType.FILE;
            return this.parse(context, source, inputType, true, 0, source.isInteractive(), request.getArgumentNames(), EnumSet.noneOf(FutureFeature.class));
        }
        if (!request.getArgumentNames().isEmpty()) {
            throw new IllegalStateException("parse with arguments is only allowed for text/x-python mime type");
        }
        if (MIME_TYPE_BYTECODE.equals(source.getMimeType())) {
            byte[] bytes = source.getBytes().toByteArray();
            CodeUnit code = MarshalModuleBuiltins.deserializeCodeUnit(bytes);
            boolean internal = PythonLanguage.shouldMarkSourceInternal(context);
            String name = source.getName();
            if (name != null && !name.isEmpty()) {
                Source textSource = PythonLanguage.tryLoadSource(context, code, internal, name);
                if (textSource == null && name.startsWith(FROZEN_FILENAME_PREFIX) && name.endsWith(FROZEN_FILENAME_SUFFIX)) {
                    String id = name.substring(FROZEN_FILENAME_PREFIX.length(), name.length() - FROZEN_FILENAME_SUFFIX.length());
                    String fs = context.getEnv().getFileNameSeparator();
                    String path = String.valueOf(context.getStdlibHome()) + fs + id.replace(".", fs) + ".py";
                    textSource = PythonLanguage.tryLoadSource(context, code, internal, path);
                    if (textSource == null) {
                        path = String.valueOf(context.getStdlibHome()) + fs + id.replace(".", fs) + fs + "__init__.py";
                        textSource = PythonLanguage.tryLoadSource(context, code, internal, path);
                    }
                }
                if (textSource != null) {
                    source = textSource;
                }
            }
            if (internal && !source.isInternal()) {
                source = Source.newBuilder((Source)source).internal(true).build();
            }
            PBytecodeRootNode rootNode = PBytecodeRootNode.create(this, code, source);
            return PythonUtils.getOrCreateCallTarget(rootNode);
        }
        String mime = source.getMimeType();
        String prefix = mime.substring(0, MIME_PREFIX.length());
        if (!prefix.equals(MIME_PREFIX)) {
            throw CompilerDirectives.shouldNotReachHere((String)("unknown mime type: " + mime));
        }
        String kind = mime.substring(MIME_KIND_START);
        if (kind.equals(MIME_KIND_COMPILE)) {
            type = InputType.FILE;
        } else if (kind.equals(MIME_KIND_EVAL)) {
            type = InputType.EVAL;
        } else {
            throw CompilerDirectives.shouldNotReachHere((String)("unknown compilation kind: " + kind + " from mime type: " + mime));
        }
        int optimize = mime.codePointAt(MIME_PREFIX.length());
        int flags = mime.codePointAt(MIME_PREFIX.length() + 1) << 16;
        if (0 > optimize || optimize > 2 || (flags & ~FutureFeature.ALL_FLAGS) != 0) {
            throw CompilerDirectives.shouldNotReachHere((String)("Invalid value for optlevel or flags: " + optimize + "," + flags + " from mime type: " + mime));
        }
        assert (!source.isInteractive());
        return this.parse(context, source, type, false, optimize, false, null, FutureFeature.fromFlags(flags));
    }

    private static Source tryLoadSource(PythonContext context, CodeUnit code, boolean internal, String path) {
        try {
            return Source.newBuilder((String)ID, (TruffleFile)context.getEnv().getPublicTruffleFile(path)).name(code.name.toJavaStringUncached()).internal(internal).build();
        }
        catch (IOException | SecurityException | UnsupportedOperationException | InvalidPathException e) {
            return null;
        }
    }

    public RootCallTarget parse(PythonContext context, Source source, InputType type, boolean topLevel, int optimize, boolean interactiveTerminal, List<String> argumentNames, EnumSet<FutureFeature> futureFeatures) {
        RaisePythonExceptionErrorCallback errorCb = new RaisePythonExceptionErrorCallback(source, PythonOptions.isPExceptionWithJavaStacktrace(this));
        try {
            Parser parser = Compiler.createParser(source.getCharacters().toString(), errorCb, type, interactiveTerminal);
            ModTy mod = (ModTy)parser.parse();
            assert (mod != null);
            return this.compileForBytecodeInterpreter(context, mod, source, topLevel, optimize, argumentNames, errorCb, futureFeatures);
        }
        catch (PException e) {
            if (topLevel) {
                PythonUtils.getOrCreateCallTarget(new TopLevelExceptionHandler(this, e)).call(new Object[0]);
            }
            throw e;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public RootCallTarget compileForBytecodeInterpreter(PythonContext context, ModTy mod, Source source, boolean topLevel, int optimize, List<String> argumentNames, RaisePythonExceptionErrorCallback errorCallback, int flags) {
        return this.compileForBytecodeInterpreter(context, mod, source, topLevel, optimize, argumentNames, errorCallback, FutureFeature.fromFlags(flags));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public RootCallTarget compileForBytecodeInterpreter(PythonContext context, ModTy modIn, Source source, boolean topLevel, int optimize, List<String> argumentNames, RaisePythonExceptionErrorCallback errorCallback, EnumSet<FutureFeature> futureFeatures) {
        RaisePythonExceptionErrorCallback errorCb = errorCallback;
        if (errorCb == null) {
            errorCb = new RaisePythonExceptionErrorCallback(source, PythonOptions.isPExceptionWithJavaStacktrace(this));
        }
        try {
            Compiler compiler = new Compiler(errorCb);
            boolean hasArguments = argumentNames != null && !argumentNames.isEmpty();
            ModTy mod = hasArguments ? PythonLanguage.transformASTForExecutionWithArguments(argumentNames, modIn) : modIn;
            CompilationUnit cu = compiler.compile(mod, EnumSet.noneOf(Compiler.Flags.class), optimize, futureFeatures);
            CodeUnit co = cu.assemble();
            RootNode rootNode = PBytecodeRootNode.create(this, co, source, errorCb);
            if (topLevel) {
                GilNode gil = GilNode.getUncached();
                boolean wasAcquired = gil.acquire(context, (Node)rootNode);
                try {
                    errorCb.triggerDeprecationWarnings();
                }
                finally {
                    gil.release(context, wasAcquired);
                }
            }
            if (hasArguments) {
                rootNode = new RootNodeWithArguments(this, rootNode);
            }
            if (topLevel && context.isCoreInitialized()) {
                rootNode = new TopLevelExceptionHandler(this, rootNode, source);
            }
            return PythonUtils.getOrCreateCallTarget(rootNode);
        }
        catch (PException e) {
            if (topLevel) {
                PythonUtils.getOrCreateCallTarget(new TopLevelExceptionHandler(this, e)).call(new Object[0]);
            }
            throw e;
        }
    }

    private static ModTy transformASTForExecutionWithArguments(List<String> argumentNames, ModTy mod) {
        StmtTy lastStmt;
        NodeFactory nodeFactory = new NodeFactory();
        ArgTy[] astArgArray = new ArgTy[argumentNames.size()];
        for (int i = 0; i < astArgArray.length; ++i) {
            astArgArray[i] = nodeFactory.createArgument(argumentNames.get(i), null, null, SourceRange.ARTIFICIAL_RANGE);
        }
        ArgumentsTy astArgs = nodeFactory.createArguments(null, null, astArgArray, null, null);
        StmtTy[] body = ((ModTy.Module)mod).body;
        if (body != null && body.length > 0 && (lastStmt = (body = Arrays.copyOf(body, body.length))[body.length - 1]) instanceof StmtTy.Expr) {
            body[body.length - 1] = nodeFactory.createReturn(((StmtTy.Expr)lastStmt).value, lastStmt.getSourceRange());
        }
        String fnName = "execute";
        StmtTy astFunction = nodeFactory.createFunctionDef(fnName, astArgs, body, null, null, SourceRange.ARTIFICIAL_RANGE);
        StmtTy astGetFunction = nodeFactory.createExpression(nodeFactory.createVariable(fnName, SourceRange.ARTIFICIAL_RANGE), SourceRange.ARTIFICIAL_RANGE);
        return nodeFactory.createModule(new StmtTy[]{astFunction, astGetFunction}, ((ModTy.Module)mod).typeIgnores, SourceRange.ARTIFICIAL_RANGE);
    }

    public ExecutableNode parse(TruffleLanguage.InlineParsingRequest request) {
        PythonContext context = PythonContext.get(null);
        final RootCallTarget callTarget = this.parse(context, request.getSource(), InputType.EVAL, false, 0, false, null, EnumSet.noneOf(FutureFeature.class));
        return new ExecutableNode(this, this){
            @Node.Child
            private GilNode gilNode;
            @Node.Child
            private GenericInvokeNode invokeNode;
            @Node.Child
            private MaterializeFrameNode materializeFrameNode;
            @Node.Child
            private GetFrameLocalsNode getFrameLocalsNode;
            final /* synthetic */ PythonLanguage this$0;
            {
                this.this$0 = this$0;
                super(language);
                this.gilNode = GilNode.create();
                this.invokeNode = GenericInvokeNode.create();
                this.materializeFrameNode = MaterializeFrameNode.create();
                this.getFrameLocalsNode = GetFrameLocalsNode.create();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object execute(VirtualFrame frame) {
                Object[] arguments = PArguments.create();
                PFrame pFrame = this.materializeFrameNode.execute((Node)this, false, true, (Frame)frame);
                Object pLocals = this.getFrameLocalsNode.executeCached(pFrame);
                PArguments.setSpecialArgument(arguments, pLocals);
                PArguments.setGlobals(arguments, PArguments.getGlobals((Frame)frame));
                boolean wasAcquired = this.gilNode.acquire();
                try {
                    Object object = this.invokeNode.execute(callTarget, arguments);
                    return object;
                }
                finally {
                    this.gilNode.release(wasAcquired);
                }
            }
        };
    }

    protected Object getLanguageView(PythonContext context, Object value) {
        assert (!(value instanceof PythonAbstractObject));
        PythonObjectFactory factory = PythonObjectFactory.getUncached();
        InteropLibrary interopLib = (InteropLibrary)InteropLibrary.getFactory().getUncached(value);
        try {
            if (interopLib.isBoolean(value)) {
                if (interopLib.asBoolean(value)) {
                    return context.getTrue();
                }
                return context.getFalse();
            }
            if (interopLib.isString(value)) {
                return factory.createString(interopLib.asTruffleString(value).switchEncodingUncached(PythonUtils.TS_ENCODING));
            }
            if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
                return factory.createInt(interopLib.asLong(value));
            }
            if (value instanceof Float || value instanceof Double) {
                return factory.createFloat(interopLib.asDouble(value));
            }
            if (interopLib.fitsInLong(value)) {
                return factory.createInt(interopLib.asLong(value));
            }
            if (interopLib.fitsInDouble(value)) {
                return factory.createFloat(interopLib.asDouble(value));
            }
            return new ForeignLanguageView(value);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException(e);
        }
    }

    public String getHome() {
        return this.getLanguageHome();
    }

    @Idempotent
    public static boolean canCache(Object value) {
        CompilerAsserts.neverPartOfCompilation();
        return value instanceof Long || value instanceof Integer || value instanceof Boolean || value instanceof Double || TruffleStringMigrationHelpers.isJavaString(value) && ((String)value).length() <= 16 || value instanceof TruffleString && ((TruffleString)value).byteLength(PythonUtils.TS_ENCODING) <= 64 || PythonLanguage.isContextInsensitiveSingleton(value);
    }

    private static boolean isContextInsensitiveSingleton(Object value) {
        for (Object singleton : CONTEXT_INSENSITIVE_SINGLETONS) {
            if (value != singleton) continue;
            return true;
        }
        return false;
    }

    protected boolean isVisible(PythonContext context, Object value) {
        return value != PNone.NONE && value != PNone.NO_VALUE;
    }

    protected Object getScope(PythonContext context) {
        return context.getTopScopeObject();
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleLogger getLogger(Class<?> clazz) {
        return TruffleLogger.getLogger((String)ID, clazz);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleLogger getLogger(String name) {
        return TruffleLogger.getLogger((String)ID, (String)name);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleLogger getCompatibilityLogger(Class<?> clazz) {
        return TruffleLogger.getLogger((String)ID, (String)("compatibility." + clazz.getName()));
    }

    public static Source newSource(PythonContext ctxt, TruffleString tsrc, TruffleString name, boolean mayBeFile, String mime) {
        try {
            Source.LiteralBuilder sourceBuilder = null;
            String src = tsrc.toJavaStringUncached();
            if (mayBeFile) {
                try {
                    TruffleFile truffleFile = ctxt.getPublicTruffleFileRelaxed(name, T_DEFAULT_PYTHON_EXTENSIONS);
                    if (truffleFile.exists(new LinkOption[0]) && ((long)src.length() == truffleFile.size(new LinkOption[0]) || (long)src.getBytes().length == truffleFile.size(new LinkOption[0]))) {
                        sourceBuilder = Source.newBuilder((String)ID, (TruffleFile)truffleFile);
                        sourceBuilder.content((CharSequence)src);
                    }
                }
                catch (IOException | SecurityException | InvalidPathException e) {
                    sourceBuilder = null;
                }
            }
            if (sourceBuilder == null) {
                sourceBuilder = Source.newBuilder((String)ID, (CharSequence)src, (String)name.toJavaStringUncached());
            }
            if (mime != null) {
                sourceBuilder.mimeType(mime);
            }
            return PythonLanguage.newSource(ctxt, sourceBuilder);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Source newSource(PythonContext ctxt, TruffleFile src, String name) throws IOException {
        return PythonLanguage.newSource(ctxt, Source.newBuilder((String)ID, (TruffleFile)src).name(name));
    }

    private static Source newSource(PythonContext context, Source.SourceBuilder srcBuilder) throws IOException {
        if (PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 && ImageInfo.inImageBuildtimeCode()) {
            srcBuilder.canonicalizePath(false);
        }
        if (PythonLanguage.shouldMarkSourceInternal(context)) {
            srcBuilder.internal(true);
        }
        return srcBuilder.build();
    }

    private static boolean shouldMarkSourceInternal(PythonContext ctxt) {
        return !ctxt.isCoreInitialized() && ctxt.getLanguage().getEngineOption(PythonOptions.ExposeInternalSources) == false;
    }

    protected void initializeMultipleContexts() {
        super.initializeMultipleContexts();
        this.singleContext = false;
    }

    @CompilerDirectives.TruffleBoundary
    public CallTarget cacheCode(TruffleString filename, Supplier<CallTarget> createCode) {
        if (!this.singleContext) {
            return this.cachedCode.computeIfAbsent(filename, f -> {
                LOGGER.log(Level.FINEST, () -> "Caching CallTarget for " + String.valueOf(filename));
                return (CallTarget)createCode.get();
            });
        }
        return (CallTarget)createCode.get();
    }

    protected boolean isThreadAccessAllowed(Thread thread, boolean singleThreaded) {
        if (singleThreaded) {
            return super.isThreadAccessAllowed(thread, singleThreaded);
        }
        return true;
    }

    protected void initializeMultiThreading(PythonContext context) {
        if (this.singleThreadedAssumption.isValid()) {
            this.singleThreadedAssumption.invalidate();
            context.initializeMultiThreading();
        }
    }

    protected void initializeThread(PythonContext context, Thread thread) {
        context.attachThread(thread, this.threadState);
    }

    protected void disposeThread(PythonContext context, Thread thread) {
        context.disposeThread(thread);
    }

    public Shape getEmptyShape() {
        return this.emptyShape;
    }

    public Shape getShapeForClass(PythonAbstractClass klass) {
        if (this.isSingleContext()) {
            return Shape.newBuilder((Shape)this.getEmptyShape()).addConstantProperty((Object)HiddenAttributes.CLASS, (Object)klass, 0).build();
        }
        return this.getEmptyShape();
    }

    public static Shape getShapeForClassWithoutDict(PythonManagedClass klass) {
        return Shape.newBuilder((Shape)klass.getInstanceShape()).shapeFlags(2).build();
    }

    public Shape getBuiltinTypeInstanceShape(PythonBuiltinClassType type) {
        int ordinal = type.ordinal();
        Shape shape = this.builtinTypeInstanceShapes[ordinal];
        if (shape == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Shape.DerivedBuilder shapeBuilder = Shape.newBuilder((Shape)this.getEmptyShape()).addConstantProperty((Object)HiddenAttributes.CLASS, (Object)type, 0);
            if (!type.isBuiltinWithDict()) {
                shapeBuilder.shapeFlags(2);
            }
            this.builtinTypeInstanceShapes[ordinal] = shape = shapeBuilder.build();
        }
        return shape;
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized Shape getCApiSymbolCacheShape() {
        if (this.cApiSymbolCache == null) {
            this.cApiSymbolCache = Shape.newBuilder().build();
        }
        return this.cApiSymbolCache;
    }

    public RootCallTarget createCachedCallTarget(Function<PythonLanguage, RootNode> rootNodeFunction, Object key) {
        CompilerAsserts.neverPartOfCompilation();
        if (!this.singleContext) {
            return this.cachedCallTargets.computeIfAbsent(key, k -> PythonUtils.getOrCreateCallTarget((RootNode)rootNodeFunction.apply(this)));
        }
        return PythonUtils.getOrCreateCallTarget((RootNode)rootNodeFunction.apply(this));
    }

    public RootCallTarget createCachedCallTarget(Function<PythonLanguage, RootNode> rootNodeFunction, Object ... cacheKeys) {
        return this.createCachedCallTarget(rootNodeFunction, (Object)Arrays.asList(cacheKeys));
    }

    public void registerBuiltinDescriptorCallTarget(BuiltinMethodDescriptor descriptor, RootCallTarget callTarget) {
        this.descriptorCallTargets.put(descriptor, callTarget);
    }

    @CompilerDirectives.TruffleBoundary
    public RootCallTarget getDescriptorCallTarget(BuiltinMethodDescriptor descriptor) {
        RootCallTarget callTarget = this.descriptorCallTargets.get(descriptor);
        assert (callTarget != null) : "Missing call target for builtin slot descriptor " + String.valueOf(descriptor);
        return callTarget;
    }

    protected void exitContext(PythonContext context, TruffleLanguage.ExitMode exitMode, int exitCode) {
        PythonModule signalModule;
        if (context.getCApiContext() != null) {
            context.getCApiContext().finalizeCapi();
        }
        if (!PythonOptions.WITHOUT_PLATFORM_ACCESS && !ImageInfo.inImageBuildtimeCode() && (signalModule = context.lookupBuiltinModule(BuiltinNames.T__SIGNAL)) != null) {
            SignalModuleBuiltins.resetSignalHandlers(signalModule);
        }
    }

    public static IndirectCallData lookupIndirectCallData(Node node) {
        CompilerAsserts.neverPartOfCompilation();
        return PythonLanguage.get((Node)node).indirectCallDataMap.get(node);
    }

    public static IndirectCallData createIndirectCallData(Node node) {
        CompilerAsserts.neverPartOfCompilation();
        return PythonLanguage.get((Node)node).indirectCallDataMap.computeIfAbsent(node, n -> new IndirectCallData(node));
    }

    static {
        switch (10) {
            case 10: {
                RELEASE_LEVEL_STRING = PythonUtils.tsLiteral("alpha");
                break;
            }
            case 11: {
                RELEASE_LEVEL_STRING = PythonUtils.tsLiteral("beta");
                break;
            }
            case 12: {
                RELEASE_LEVEL_STRING = PythonUtils.tsLiteral("rc");
                break;
            }
            default: {
                RELEASE_LEVEL_STRING = PythonUtils.tsLiteral("final");
            }
        }
        try (InputStream is = PythonLanguage.class.getResourceAsStream("/graalpy_versions");){
            int ch = is.read() - 32;
            if (3 != ch) {
                throw new RuntimeException("suite.py version info does not match PythonLanguage#MAJOR: " + ch);
            }
            ch = is.read() - 32;
            if (10 != ch) {
                throw new RuntimeException("suite.py version info does not match PythonLanguage#MINOR: " + ch);
            }
            ch = is.read() - 32;
            if (13 != ch) {
                throw new RuntimeException("suite.py version info does not match PythonLanguage#MICRO: " + ch);
            }
            ch = is.read() - 32;
            if (24 != ch) {
                throw new RuntimeException("suite.py version info does not match PythonLanguage#GRAALVM_MAJOR: " + ch);
            }
            ch = is.read() - 32;
            if (0 != ch) {
                throw new RuntimeException("suite.py version info does not match PythonLanguage#GRAALVM_MINOR: " + ch);
            }
            byte[] rev = new byte[14];
            DEV_TAG = is.read(rev) == rev.length ? new String(rev).strip() : "";
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        MIME_KIND_START = MIME_PREFIX.length() + 2 + 1;
        ArrayList<String> mimeJavaStrings = new ArrayList<String>();
        assert (PythonLanguage.mimeTypesComplete(mimeJavaStrings)) : "Expected all of {" + String.join((CharSequence)", ", mimeJavaStrings) + "} in the PythonLanguage characterMimeTypes";
        T_DEFAULT_PYTHON_EXTENSIONS = new TruffleString[]{StringLiterals.T_PY_EXTENSION, PythonUtils.tsLiteral(".pyc")};
        LOGGER = TruffleLogger.getLogger((String)ID, PythonLanguage.class);
        REFERENCE = TruffleLanguage.LanguageReference.create(PythonLanguage.class);
        CONTEXT_INSENSITIVE_SINGLETONS = new Object[]{PNone.NONE, PNone.NO_VALUE, PEllipsis.INSTANCE, PNotImplemented.NOT_IMPLEMENTED};
    }

    private static class RootNodeWithArguments
    extends RootNode {
        private final RootNode innerRootNode;
        @Node.Child
        private DirectCallNode callModuleNode;
        @Node.Child
        private CallNode callFunctionNode;

        public RootNodeWithArguments(PythonLanguage language, RootNode innerRootNode) {
            super((TruffleLanguage)language);
            this.innerRootNode = innerRootNode;
            this.callModuleNode = DirectCallNode.create((CallTarget)innerRootNode.getCallTarget());
            this.callFunctionNode = CallNode.create();
        }

        public Object execute(VirtualFrame frame) {
            Object function = this.callModuleNode.call(frame.getArguments());
            Object[] arguments = PythonUtils.arrayCopyOfRange(frame.getArguments(), 9, frame.getArguments().length);
            return this.callFunctionNode.execute((Frame)frame, function, arguments);
        }

        public SourceSection getSourceSection() {
            return this.innerRootNode.getSourceSection();
        }

        public String getName() {
            return this.innerRootNode.getName();
        }
    }

    @ExportLibrary(value=InteropLibrary.class, delegateTo="delegate")
    static class ForeignLanguageView
    implements TruffleObject {
        final Object delegate;

        ForeignLanguageView(Object delegate) {
            this.delegate = delegate;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        String toDisplayString(boolean allowSideEffects, @CachedLibrary(value="this.delegate") InteropLibrary lib) {
            return "<foreign '" + String.valueOf(lib.toDisplayString(this.delegate, allowSideEffects)) + "'>";
        }

        @ExportMessage
        boolean hasLanguage() {
            return true;
        }

        @ExportMessage
        Class<? extends TruffleLanguage<?>> getLanguage() {
            return PythonLanguage.class;
        }
    }
}

