/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.modules.AbcModuleBuiltins;
import com.oracle.graal.python.builtins.modules.ArrayModuleBuiltins;
import com.oracle.graal.python.builtins.modules.AsyncioModuleBuiltins;
import com.oracle.graal.python.builtins.modules.AtexitModuleBuiltins;
import com.oracle.graal.python.builtins.modules.BinasciiModuleBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinConstructors;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.CmathModuleBuiltins;
import com.oracle.graal.python.builtins.modules.CodecsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.CodecsTruffleModuleBuiltins;
import com.oracle.graal.python.builtins.modules.CollectionsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.ContextvarsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.CryptModuleBuiltins;
import com.oracle.graal.python.builtins.modules.ErrnoModuleBuiltins;
import com.oracle.graal.python.builtins.modules.FaulthandlerModuleBuiltins;
import com.oracle.graal.python.builtins.modules.FcntlModuleBuiltins;
import com.oracle.graal.python.builtins.modules.GcModuleBuiltins;
import com.oracle.graal.python.builtins.modules.GraalHPyDebugModuleBuiltins;
import com.oracle.graal.python.builtins.modules.GraalHPyTraceModuleBuiltins;
import com.oracle.graal.python.builtins.modules.GraalHPyUniversalModuleBuiltins;
import com.oracle.graal.python.builtins.modules.GraalPythonModuleBuiltins;
import com.oracle.graal.python.builtins.modules.ImpModuleBuiltins;
import com.oracle.graal.python.builtins.modules.ItertoolsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.JArrayModuleBuiltins;
import com.oracle.graal.python.builtins.modules.JavaModuleBuiltins;
import com.oracle.graal.python.builtins.modules.LocaleModuleBuiltins;
import com.oracle.graal.python.builtins.modules.LsprofModuleBuiltins;
import com.oracle.graal.python.builtins.modules.MMapModuleBuiltins;
import com.oracle.graal.python.builtins.modules.MarshalModuleBuiltins;
import com.oracle.graal.python.builtins.modules.MathModuleBuiltins;
import com.oracle.graal.python.builtins.modules.NtModuleBuiltins;
import com.oracle.graal.python.builtins.modules.OperatorModuleBuiltins;
import com.oracle.graal.python.builtins.modules.PolyglotModuleBuiltins;
import com.oracle.graal.python.builtins.modules.PosixModuleBuiltins;
import com.oracle.graal.python.builtins.modules.PosixShMemModuleBuiltins;
import com.oracle.graal.python.builtins.modules.PosixSubprocessModuleBuiltins;
import com.oracle.graal.python.builtins.modules.PwdModuleBuiltins;
import com.oracle.graal.python.builtins.modules.PyExpatModuleBuiltins;
import com.oracle.graal.python.builtins.modules.QueueModuleBuiltins;
import com.oracle.graal.python.builtins.modules.RandomModuleBuiltins;
import com.oracle.graal.python.builtins.modules.ReadlineModuleBuiltins;
import com.oracle.graal.python.builtins.modules.ResourceModuleBuiltins;
import com.oracle.graal.python.builtins.modules.SREModuleBuiltins;
import com.oracle.graal.python.builtins.modules.SSLModuleBuiltins;
import com.oracle.graal.python.builtins.modules.SelectModuleBuiltins;
import com.oracle.graal.python.builtins.modules.SignalModuleBuiltins;
import com.oracle.graal.python.builtins.modules.SocketModuleBuiltins;
import com.oracle.graal.python.builtins.modules.StringModuleBuiltins;
import com.oracle.graal.python.builtins.modules.SysModuleBuiltins;
import com.oracle.graal.python.builtins.modules.TermiosModuleBuiltins;
import com.oracle.graal.python.builtins.modules.ThreadModuleBuiltins;
import com.oracle.graal.python.builtins.modules.TimeModuleBuiltins;
import com.oracle.graal.python.builtins.modules.TracemallocModuleBuiltins;
import com.oracle.graal.python.builtins.modules.UnicodeDataModuleBuiltins;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.WeakRefModuleBuiltins;
import com.oracle.graal.python.builtins.modules.WinapiModuleBuiltins;
import com.oracle.graal.python.builtins.modules.WinregModuleBuiltins;
import com.oracle.graal.python.builtins.modules.ast.AstBuiltins;
import com.oracle.graal.python.builtins.modules.ast.AstModuleBuiltins;
import com.oracle.graal.python.builtins.modules.bz2.BZ2CompressorBuiltins;
import com.oracle.graal.python.builtins.modules.bz2.BZ2DecompressorBuiltins;
import com.oracle.graal.python.builtins.modules.bz2.BZ2ModuleBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.CodecCtxBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.CodecsCNModuleBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.CodecsHKModuleBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.CodecsISO2022ModuleBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.CodecsJPModuleBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.CodecsKRModuleBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.CodecsTWModuleBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteIncrementalDecoderBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteIncrementalEncoderBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteStreamReaderBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteStreamWriterBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibytecodecModuleBuiltins;
import com.oracle.graal.python.builtins.modules.csv.CSVDialectBuiltins;
import com.oracle.graal.python.builtins.modules.csv.CSVModuleBuiltins;
import com.oracle.graal.python.builtins.modules.csv.CSVReaderBuiltins;
import com.oracle.graal.python.builtins.modules.csv.CSVWriterBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CArgObjectBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CDataBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CDataTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CDataTypeSequenceBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CFieldBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesModuleBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.PyCArrayBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.PyCArrayTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.PyCFuncPtrBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.PyCFuncPtrTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.PyCPointerBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.PyCPointerTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.PyCSimpleTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.PyCStructTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.SimpleCDataBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StructUnionTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StructureBuiltins;
import com.oracle.graal.python.builtins.modules.functools.FunctoolsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.functools.KeyWrapperBuiltins;
import com.oracle.graal.python.builtins.modules.functools.LruCacheWrapperBuiltins;
import com.oracle.graal.python.builtins.modules.functools.PartialBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.Blake2ModuleBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.Blake2bObjectBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.Blake2sObjectBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.DigestObjectBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.HashObjectBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.HashlibModuleBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.Md5ModuleBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.Sha1ModuleBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.Sha256ModuleBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.Sha3ModuleBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.Sha512ModuleBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.ShakeDigestObjectBuiltins;
import com.oracle.graal.python.builtins.modules.io.BufferedIOBaseBuiltins;
import com.oracle.graal.python.builtins.modules.io.BufferedIOMixinBuiltins;
import com.oracle.graal.python.builtins.modules.io.BufferedRWPairBuiltins;
import com.oracle.graal.python.builtins.modules.io.BufferedRandomBuiltins;
import com.oracle.graal.python.builtins.modules.io.BufferedReaderBuiltins;
import com.oracle.graal.python.builtins.modules.io.BufferedReaderMixinBuiltins;
import com.oracle.graal.python.builtins.modules.io.BufferedWriterBuiltins;
import com.oracle.graal.python.builtins.modules.io.BufferedWriterMixinBuiltins;
import com.oracle.graal.python.builtins.modules.io.BytesIOBuiltins;
import com.oracle.graal.python.builtins.modules.io.FileIOBuiltins;
import com.oracle.graal.python.builtins.modules.io.IOBaseBuiltins;
import com.oracle.graal.python.builtins.modules.io.IOBaseDictBuiltins;
import com.oracle.graal.python.builtins.modules.io.IOModuleBuiltins;
import com.oracle.graal.python.builtins.modules.io.IncrementalNewlineDecoderBuiltins;
import com.oracle.graal.python.builtins.modules.io.RawIOBaseBuiltins;
import com.oracle.graal.python.builtins.modules.io.StringIOBuiltins;
import com.oracle.graal.python.builtins.modules.io.TextIOBaseBuiltins;
import com.oracle.graal.python.builtins.modules.io.TextIOWrapperBuiltins;
import com.oracle.graal.python.builtins.modules.json.JSONEncoderBuiltins;
import com.oracle.graal.python.builtins.modules.json.JSONModuleBuiltins;
import com.oracle.graal.python.builtins.modules.json.JSONScannerBuiltins;
import com.oracle.graal.python.builtins.modules.lzma.LZMACompressorBuiltins;
import com.oracle.graal.python.builtins.modules.lzma.LZMADecompressorBuiltins;
import com.oracle.graal.python.builtins.modules.lzma.LZMAModuleBuiltins;
import com.oracle.graal.python.builtins.modules.multiprocessing.GraalPySemLockBuiltins;
import com.oracle.graal.python.builtins.modules.multiprocessing.MultiprocessingGraalPyModuleBuiltins;
import com.oracle.graal.python.builtins.modules.multiprocessing.MultiprocessingModuleBuiltins;
import com.oracle.graal.python.builtins.modules.multiprocessing.SemLockBuiltins;
import com.oracle.graal.python.builtins.modules.zlib.ZLibModuleBuiltins;
import com.oracle.graal.python.builtins.modules.zlib.ZlibCompressBuiltins;
import com.oracle.graal.python.builtins.modules.zlib.ZlibDecompressBuiltins;
import com.oracle.graal.python.builtins.objects.NoneBuiltins;
import com.oracle.graal.python.builtins.objects.NotImplementedBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.array.ArrayBuiltins;
import com.oracle.graal.python.builtins.objects.asyncio.AsyncGenSendBuiltins;
import com.oracle.graal.python.builtins.objects.asyncio.AsyncGenThrowBuiltins;
import com.oracle.graal.python.builtins.objects.asyncio.AsyncGeneratorBuiltins;
import com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltins;
import com.oracle.graal.python.builtins.objects.bool.BoolBuiltins;
import com.oracle.graal.python.builtins.objects.bytes.ByteArrayBuiltins;
import com.oracle.graal.python.builtins.objects.bytes.BytesBuiltins;
import com.oracle.graal.python.builtins.objects.cell.CellBuiltins;
import com.oracle.graal.python.builtins.objects.code.CodeBuiltins;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins;
import com.oracle.graal.python.builtins.objects.contextvars.ContextBuiltins;
import com.oracle.graal.python.builtins.objects.contextvars.ContextIteratorBuiltins;
import com.oracle.graal.python.builtins.objects.contextvars.ContextVarBuiltins;
import com.oracle.graal.python.builtins.objects.contextvars.TokenBuiltins;
import com.oracle.graal.python.builtins.objects.deque.DequeBuiltins;
import com.oracle.graal.python.builtins.objects.deque.DequeIterBuiltins;
import com.oracle.graal.python.builtins.objects.dict.DefaultDictBuiltins;
import com.oracle.graal.python.builtins.objects.dict.DictBuiltins;
import com.oracle.graal.python.builtins.objects.dict.DictReprBuiltin;
import com.oracle.graal.python.builtins.objects.dict.DictValuesBuiltins;
import com.oracle.graal.python.builtins.objects.dict.DictViewBuiltins;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.ellipsis.EllipsisBuiltins;
import com.oracle.graal.python.builtins.objects.enumerate.EnumerateBuiltins;
import com.oracle.graal.python.builtins.objects.exception.BaseExceptionBuiltins;
import com.oracle.graal.python.builtins.objects.exception.ImportErrorBuiltins;
import com.oracle.graal.python.builtins.objects.exception.KeyErrorBuiltins;
import com.oracle.graal.python.builtins.objects.exception.OsErrorBuiltins;
import com.oracle.graal.python.builtins.objects.exception.StopIterationBuiltins;
import com.oracle.graal.python.builtins.objects.exception.SyntaxErrorBuiltins;
import com.oracle.graal.python.builtins.objects.exception.SystemExitBuiltins;
import com.oracle.graal.python.builtins.objects.exception.UnicodeDecodeErrorBuiltins;
import com.oracle.graal.python.builtins.objects.exception.UnicodeEncodeErrorBuiltins;
import com.oracle.graal.python.builtins.objects.exception.UnicodeErrorBuiltins;
import com.oracle.graal.python.builtins.objects.exception.UnicodeTranslateErrorBuiltins;
import com.oracle.graal.python.builtins.objects.floats.FloatBuiltins;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.foreign.ForeignObjectBuiltins;
import com.oracle.graal.python.builtins.objects.frame.FrameBuiltins;
import com.oracle.graal.python.builtins.objects.function.AbstractFunctionBuiltins;
import com.oracle.graal.python.builtins.objects.function.BuiltinFunctionBuiltins;
import com.oracle.graal.python.builtins.objects.function.FunctionBuiltins;
import com.oracle.graal.python.builtins.objects.function.MethodDescriptorBuiltins;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.WrapperDescriptorBuiltins;
import com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins;
import com.oracle.graal.python.builtins.objects.generator.CoroutineBuiltins;
import com.oracle.graal.python.builtins.objects.generator.GeneratorBuiltins;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.DescriptorBuiltins;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.GetSetDescriptorTypeBuiltins;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.MemberDescriptorBuiltins;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.iterator.ForeignIteratorBuiltins;
import com.oracle.graal.python.builtins.objects.iterator.IteratorBuiltins;
import com.oracle.graal.python.builtins.objects.iterator.PZipBuiltins;
import com.oracle.graal.python.builtins.objects.iterator.SentinelIteratorBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.AccumulateBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.ChainBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.CombinationsBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.CompressBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.CountBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.CycleBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.DropwhileBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.FilterfalseBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.GroupByBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.GrouperBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.IsliceBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.PairwiseBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.PermutationsBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.ProductBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.RepeatBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.StarmapBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.TakewhileBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.TeeBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.TeeDataObjectBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.ZipLongestBuiltins;
import com.oracle.graal.python.builtins.objects.list.ListBuiltins;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.map.MapBuiltins;
import com.oracle.graal.python.builtins.objects.mappingproxy.MappingproxyBuiltins;
import com.oracle.graal.python.builtins.objects.memoryview.MemoryViewBuiltins;
import com.oracle.graal.python.builtins.objects.method.AbstractBuiltinMethodBuiltins;
import com.oracle.graal.python.builtins.objects.method.AbstractMethodBuiltins;
import com.oracle.graal.python.builtins.objects.method.BuiltinClassmethodBuiltins;
import com.oracle.graal.python.builtins.objects.method.BuiltinFunctionOrMethodBuiltins;
import com.oracle.graal.python.builtins.objects.method.ClassmethodBuiltins;
import com.oracle.graal.python.builtins.objects.method.DecoratedMethodBuiltins;
import com.oracle.graal.python.builtins.objects.method.InstancemethodBuiltins;
import com.oracle.graal.python.builtins.objects.method.MethodBuiltins;
import com.oracle.graal.python.builtins.objects.method.MethodWrapperBuiltins;
import com.oracle.graal.python.builtins.objects.method.StaticmethodBuiltins;
import com.oracle.graal.python.builtins.objects.mmap.MMapBuiltins;
import com.oracle.graal.python.builtins.objects.module.ModuleBuiltins;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.namespace.SimpleNamespaceBuiltins;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.ordereddict.OrderedDictBuiltins;
import com.oracle.graal.python.builtins.objects.ordereddict.OrderedDictItemsBuiltins;
import com.oracle.graal.python.builtins.objects.ordereddict.OrderedDictIteratorBuiltins;
import com.oracle.graal.python.builtins.objects.ordereddict.OrderedDictKeysBuiltins;
import com.oracle.graal.python.builtins.objects.ordereddict.OrderedDictValuesBuiltins;
import com.oracle.graal.python.builtins.objects.posix.DirEntryBuiltins;
import com.oracle.graal.python.builtins.objects.posix.ScandirIteratorBuiltins;
import com.oracle.graal.python.builtins.objects.property.PropertyBuiltins;
import com.oracle.graal.python.builtins.objects.queue.SimpleQueueBuiltins;
import com.oracle.graal.python.builtins.objects.random.RandomBuiltins;
import com.oracle.graal.python.builtins.objects.range.RangeBuiltins;
import com.oracle.graal.python.builtins.objects.referencetype.ReferenceTypeBuiltins;
import com.oracle.graal.python.builtins.objects.reversed.ReversedBuiltins;
import com.oracle.graal.python.builtins.objects.set.BaseSetBuiltins;
import com.oracle.graal.python.builtins.objects.set.FrozenSetBuiltins;
import com.oracle.graal.python.builtins.objects.set.SetBuiltins;
import com.oracle.graal.python.builtins.objects.slice.SliceBuiltins;
import com.oracle.graal.python.builtins.objects.socket.SocketBuiltins;
import com.oracle.graal.python.builtins.objects.ssl.MemoryBIOBuiltins;
import com.oracle.graal.python.builtins.objects.ssl.SSLContextBuiltins;
import com.oracle.graal.python.builtins.objects.ssl.SSLErrorBuiltins;
import com.oracle.graal.python.builtins.objects.ssl.SSLSocketBuiltins;
import com.oracle.graal.python.builtins.objects.str.StringBuiltins;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.superobject.SuperBuiltins;
import com.oracle.graal.python.builtins.objects.thread.LockBuiltins;
import com.oracle.graal.python.builtins.objects.thread.RLockBuiltins;
import com.oracle.graal.python.builtins.objects.thread.ThreadBuiltins;
import com.oracle.graal.python.builtins.objects.thread.ThreadLocalBuiltins;
import com.oracle.graal.python.builtins.objects.traceback.TracebackBuiltins;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.builtins.objects.tuple.TupleGetterBuiltins;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TypeBuiltins;
import com.oracle.graal.python.builtins.objects.types.GenericAliasBuiltins;
import com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins;
import com.oracle.graal.python.lib.PyDictSetItem;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromDynamicObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToDynamicObjectNode;
import com.oracle.graal.python.nodes.call.GenericInvokeNode;
import com.oracle.graal.python.pegparser.FutureFeature;
import com.oracle.graal.python.pegparser.InputType;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.interop.PythonMapScope;
import com.oracle.graal.python.runtime.object.PythonObjectSlowPathFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import org.graalvm.nativeimage.ImageInfo;

public abstract class Python3Core {
    private static final int REC_LIM = 1000;
    private static final int NATIVE_REC_LIM = 8000;
    private static final TruffleLogger LOGGER = PythonLanguage.getLogger(Python3Core.class);
    private static final TruffleString T___ANONYMOUS__ = PythonUtils.tsLiteral("__anonymous__");
    private static final TruffleString T_IMPORTLIB = PythonUtils.tsLiteral("importlib");
    private static final TruffleString T_IMPORTLIB_BOOTSTRAP_EXTERNAL = PythonUtils.tsLiteral("importlib._bootstrap_external");
    private static final TruffleString T__FROZEN_IMPORTLIB_EXTERNAL = PythonUtils.tsLiteral("_frozen_importlib_external");
    private static final TruffleString T__FROZEN_IMPORTLIB = PythonUtils.tsLiteral("_frozen_importlib");
    private static final TruffleString T_IMPORTLIB_BOOTSTRAP = PythonUtils.tsLiteral("importlib._bootstrap");
    private final TruffleString[] coreFiles;
    private final PythonBuiltins[] builtins;
    private static final boolean hasProfilerTool;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final PythonBuiltinClass[] builtinTypes = new PythonBuiltinClass[PythonBuiltinClassType.VALUES.length];
    private final Map<TruffleString, PythonModule> builtinModules = new HashMap<TruffleString, PythonModule>();
    @CompilerDirectives.CompilationFinal
    private PythonModule builtinsModule;
    @CompilerDirectives.CompilationFinal
    private PythonModule sysModule;
    @CompilerDirectives.CompilationFinal
    private PDict sysModules;
    @CompilerDirectives.CompilationFinal
    private PFunction importFunc;
    @CompilerDirectives.CompilationFinal
    private PythonModule importlib;
    @CompilerDirectives.CompilationFinal
    private PInt pyTrue;
    @CompilerDirectives.CompilationFinal
    private PInt pyFalse;
    @CompilerDirectives.CompilationFinal
    private PFloat pyNaN;
    private final SysModuleState sysModuleState = new SysModuleState();
    @CompilerDirectives.CompilationFinal
    private Object globalScopeObject;
    private volatile boolean initialized;
    private final PythonLanguage language;
    @CompilerDirectives.CompilationFinal
    private PythonObjectSlowPathFactory objectFactory;

    private static TruffleString[] initializeCoreFiles() {
        ArrayList<TruffleString> coreFiles = new ArrayList<TruffleString>(Arrays.asList(PythonUtils.toTruffleStringUncached("__graalpython__"), PythonUtils.toTruffleStringUncached("_weakref"), PythonUtils.toTruffleStringUncached("unicodedata"), PythonUtils.toTruffleStringUncached("_sre"), PythonUtils.toTruffleStringUncached("function"), PythonUtils.toTruffleStringUncached("_sysconfig"), PythonUtils.toTruffleStringUncached("java"), PythonUtils.toTruffleStringUncached("pip_hook"), PythonUtils.toTruffleStringUncached("_struct")));
        if (!ImageInfo.inImageRuntimeCode()) {
            ServiceLoader<PythonBuiltins> providers = ServiceLoader.load(PythonBuiltins.class, Python3Core.class.getClassLoader());
            PythonOS currentOs = PythonOS.getPythonOS();
            for (PythonBuiltins builtin : providers) {
                CoreFunctions annotation = builtin.getClass().getAnnotation(CoreFunctions.class);
                if (annotation.pythonFile().isEmpty() || annotation.os() != PythonOS.PLATFORM_ANY && annotation.os() != currentOs) continue;
                coreFiles.add(PythonUtils.toTruffleStringUncached(annotation.pythonFile()));
            }
        }
        coreFiles.removeAll(Arrays.asList(new TruffleString[]{null}));
        return coreFiles.toArray(new TruffleString[coreFiles.size()]);
    }

    private static void filterBuiltins(List<PythonBuiltins> builtins) {
        PythonOS currentOs = PythonOS.getPythonOS();
        ArrayList<PythonBuiltins> toRemove = new ArrayList<PythonBuiltins>();
        for (PythonBuiltins builtin : builtins) {
            if (builtin == null) {
                toRemove.add(builtin);
                continue;
            }
            CoreFunctions annotation = builtin.getClass().getAnnotation(CoreFunctions.class);
            if (annotation.os() == PythonOS.PLATFORM_ANY || annotation.os() == currentOs) continue;
            toRemove.add(builtin);
        }
        builtins.removeAll(toRemove);
    }

    private static PythonBuiltins[] initializeBuiltins(boolean nativeAccessAllowed, boolean socketIOAllowed) {
        ArrayList<PythonBuiltins> builtins = new ArrayList<PythonBuiltins>(Arrays.asList(new BuiltinConstructors(), new AbcModuleBuiltins(), new BuiltinFunctions(), new DecoratedMethodBuiltins(), new ClassmethodBuiltins(), new StaticmethodBuiltins(), new InstancemethodBuiltins(), new SimpleNamespaceBuiltins(), new PolyglotModuleBuiltins(), new ObjectBuiltins(), new CellBuiltins(), new BoolBuiltins(), new FloatBuiltins(), new BytesBuiltins(), new ByteArrayBuiltins(), new ComplexBuiltins(), new TypeBuiltins(), new IntBuiltins(), new ForeignObjectBuiltins(), new ListBuiltins(), new DictBuiltins(), new DictReprBuiltin(), new DictViewBuiltins(), new DictValuesBuiltins(), new RangeBuiltins(), new SliceBuiltins(), new TupleBuiltins(), new StringBuiltins(), new BaseSetBuiltins(), new SetBuiltins(), new FrozenSetBuiltins(), new IteratorBuiltins(), new ReversedBuiltins(), new PZipBuiltins(), new EnumerateBuiltins(), new MapBuiltins(), new NotImplementedBuiltins(), new NoneBuiltins(), new EllipsisBuiltins(), new SentinelIteratorBuiltins(), new ForeignIteratorBuiltins(), new GeneratorBuiltins(), new CoroutineBuiltins(), new CoroutineWrapperBuiltins(), new CommonGeneratorBuiltins(), new AbstractFunctionBuiltins(), new FunctionBuiltins(), new BuiltinFunctionBuiltins(), new MethodDescriptorBuiltins(), new WrapperDescriptorBuiltins(), new AbstractMethodBuiltins(), new MethodBuiltins(), new AbstractBuiltinMethodBuiltins(), new BuiltinFunctionOrMethodBuiltins(), new MethodWrapperBuiltins(), new BuiltinClassmethodBuiltins(), new CodeBuiltins(), new FrameBuiltins(), new MappingproxyBuiltins(), new DescriptorBuiltins(), new GetSetDescriptorTypeBuiltins(), new MemberDescriptorBuiltins(), new PropertyBuiltins(), new BaseExceptionBuiltins(), new PosixModuleBuiltins(), new NtModuleBuiltins(), new WinregModuleBuiltins(), new WinapiModuleBuiltins(), new CryptModuleBuiltins(), new ScandirIteratorBuiltins(), new DirEntryBuiltins(), new ImpModuleBuiltins(), new ArrayModuleBuiltins(), new ArrayBuiltins(), new TermiosModuleBuiltins(), new TimeModuleBuiltins(), new ModuleBuiltins(), new MathModuleBuiltins(), new CmathModuleBuiltins(), new MarshalModuleBuiltins(), new RandomModuleBuiltins(), new RandomBuiltins(), new WeakRefModuleBuiltins(), new ReferenceTypeBuiltins(), new TracemallocModuleBuiltins(), new ContextVarBuiltins(), new ContextBuiltins(), new TokenBuiltins(), new ContextIteratorBuiltins(), new GenericAliasBuiltins(), new UnionTypeBuiltins(), new SystemExitBuiltins(), new ImportErrorBuiltins(), new StopIterationBuiltins(), new KeyErrorBuiltins(), new SyntaxErrorBuiltins(), new OsErrorBuiltins(), new UnicodeErrorBuiltins(), new UnicodeEncodeErrorBuiltins(), new UnicodeDecodeErrorBuiltins(), new UnicodeTranslateErrorBuiltins(), new IOModuleBuiltins(), new IOBaseBuiltins(), new BufferedIOBaseBuiltins(), new RawIOBaseBuiltins(), new TextIOBaseBuiltins(), new BufferedReaderBuiltins(), new BufferedWriterBuiltins(), new BufferedRandomBuiltins(), new BufferedReaderMixinBuiltins(), new BufferedWriterMixinBuiltins(), new BufferedIOMixinBuiltins(), new FileIOBuiltins(), new TextIOWrapperBuiltins(), new IncrementalNewlineDecoderBuiltins(), new BufferedRWPairBuiltins(), new BytesIOBuiltins(), new StringIOBuiltins(), new IOBaseDictBuiltins(), new MultibyteCodecBuiltins(), new MultibytecodecModuleBuiltins(), new MultibyteIncrementalDecoderBuiltins(), new MultibyteIncrementalEncoderBuiltins(), new MultibyteStreamReaderBuiltins(), new MultibyteStreamWriterBuiltins(), new CodecCtxBuiltins(), new CodecsCNModuleBuiltins(), new CodecsHKModuleBuiltins(), new CodecsISO2022ModuleBuiltins(), new CodecsJPModuleBuiltins(), new CodecsKRModuleBuiltins(), new CodecsTWModuleBuiltins(), new StringModuleBuiltins(), new ItertoolsModuleBuiltins(), new KeyWrapperBuiltins(), new PartialBuiltins(), new LruCacheWrapperBuiltins(), new FunctoolsModuleBuiltins(), new ErrnoModuleBuiltins(), new CodecsModuleBuiltins(), new CodecsTruffleModuleBuiltins(), new DequeBuiltins(), new DequeIterBuiltins(), new OrderedDictBuiltins(), new OrderedDictKeysBuiltins(), new OrderedDictValuesBuiltins(), new OrderedDictItemsBuiltins(), new OrderedDictIteratorBuiltins(), new CollectionsModuleBuiltins(), new DefaultDictBuiltins(), new TupleGetterBuiltins(), new JavaModuleBuiltins(), new JArrayModuleBuiltins(), new CSVModuleBuiltins(), new JSONModuleBuiltins(), new SREModuleBuiltins(), new AstModuleBuiltins(), PythonOptions.WITHOUT_NATIVE_POSIX && (PythonOptions.WITHOUT_JAVA_INET || !socketIOAllowed) ? null : new SelectModuleBuiltins(), PythonOptions.WITHOUT_NATIVE_POSIX && (PythonOptions.WITHOUT_JAVA_INET || !socketIOAllowed) ? null : new SocketModuleBuiltins(), PythonOptions.WITHOUT_NATIVE_POSIX && (PythonOptions.WITHOUT_JAVA_INET || !socketIOAllowed) ? null : new SocketBuiltins(), PythonOptions.WITHOUT_PLATFORM_ACCESS ? null : new SignalModuleBuiltins(), new TracebackBuiltins(), new GcModuleBuiltins(), new AtexitModuleBuiltins(), new FaulthandlerModuleBuiltins(), new UnicodeDataModuleBuiltins(), new LocaleModuleBuiltins(), new SysModuleBuiltins(), new MemoryViewBuiltins(), new SuperBuiltins(), PythonOptions.WITHOUT_SSL ? null : new SSLModuleBuiltins(), PythonOptions.WITHOUT_SSL ? null : new SSLContextBuiltins(), PythonOptions.WITHOUT_SSL ? null : new SSLErrorBuiltins(), PythonOptions.WITHOUT_SSL ? null : new SSLSocketBuiltins(), PythonOptions.WITHOUT_SSL ? null : new MemoryBIOBuiltins(), new BinasciiModuleBuiltins(), new PosixShMemModuleBuiltins(), PythonOptions.WITHOUT_PLATFORM_ACCESS ? null : new PosixSubprocessModuleBuiltins(), new ReadlineModuleBuiltins(), new OperatorModuleBuiltins(), PythonOptions.WITHOUT_DIGEST ? null : new Md5ModuleBuiltins(), PythonOptions.WITHOUT_DIGEST ? null : new Sha1ModuleBuiltins(), PythonOptions.WITHOUT_DIGEST ? null : new Sha256ModuleBuiltins(), PythonOptions.WITHOUT_DIGEST ? null : new Sha512ModuleBuiltins(), PythonOptions.WITHOUT_DIGEST ? null : new Sha3ModuleBuiltins(), PythonOptions.WITHOUT_DIGEST ? null : new Blake2ModuleBuiltins(), PythonOptions.WITHOUT_DIGEST ? null : new DigestObjectBuiltins(), PythonOptions.WITHOUT_DIGEST ? null : new HashObjectBuiltins(), PythonOptions.WITHOUT_DIGEST ? null : new ShakeDigestObjectBuiltins(), PythonOptions.WITHOUT_DIGEST ? null : new Blake2bObjectBuiltins(), PythonOptions.WITHOUT_DIGEST ? null : new Blake2sObjectBuiltins(), PythonOptions.WITHOUT_DIGEST ? null : new HashlibModuleBuiltins(), new PyExpatModuleBuiltins(), new AccumulateBuiltins(), new CombinationsBuiltins(), new CompressBuiltins(), new DropwhileBuiltins(), new ChainBuiltins(), new CountBuiltins(), new CycleBuiltins(), new FilterfalseBuiltins(), new GroupByBuiltins(), new GrouperBuiltins(), new IsliceBuiltins(), new PairwiseBuiltins(), new PermutationsBuiltins(), new ProductBuiltins(), new RepeatBuiltins(), new StarmapBuiltins(), new TakewhileBuiltins(), new TeeBuiltins(), new TeeDataObjectBuiltins(), new ZipLongestBuiltins(), PythonOptions.WITHOUT_COMPRESSION_LIBRARIES ? null : new ZLibModuleBuiltins(), PythonOptions.WITHOUT_COMPRESSION_LIBRARIES ? null : new ZlibCompressBuiltins(), PythonOptions.WITHOUT_COMPRESSION_LIBRARIES ? null : new ZlibDecompressBuiltins(), new MMapModuleBuiltins(), new FcntlModuleBuiltins(), new MMapBuiltins(), new SimpleQueueBuiltins(), new QueueModuleBuiltins(), new ThreadModuleBuiltins(), new ThreadBuiltins(), new ThreadLocalBuiltins(), new LockBuiltins(), new RLockBuiltins(), new PwdModuleBuiltins(), new ResourceModuleBuiltins(), new ContextvarsModuleBuiltins(), PythonOptions.WITHOUT_COMPRESSION_LIBRARIES ? null : new LZMAModuleBuiltins(), PythonOptions.WITHOUT_COMPRESSION_LIBRARIES ? null : new LZMACompressorBuiltins(), PythonOptions.WITHOUT_COMPRESSION_LIBRARIES ? null : new LZMADecompressorBuiltins(), PythonOptions.WITHOUT_NATIVE_POSIX ? null : new MultiprocessingModuleBuiltins(), PythonOptions.WITHOUT_NATIVE_POSIX ? null : new SemLockBuiltins(), new MultiprocessingGraalPyModuleBuiltins(), new GraalPySemLockBuiltins(), new WarningsModuleBuiltins(), new GraalPythonModuleBuiltins(), new JSONScannerBuiltins(), new JSONEncoderBuiltins(), new CSVDialectBuiltins(), new CSVReaderBuiltins(), new CSVWriterBuiltins(), new AstBuiltins(), new CArgObjectBuiltins(), new CDataTypeBuiltins(), new CDataTypeSequenceBuiltins(), new CFieldBuiltins(), new CtypesModuleBuiltins(), new PyCArrayTypeBuiltins(), new PyCFuncPtrBuiltins(), new PyCFuncPtrTypeBuiltins(), new PyCPointerTypeBuiltins(), new PyCSimpleTypeBuiltins(), new PyCStructTypeBuiltins(), new StgDictBuiltins(), new StructUnionTypeBuiltins(), new StructureBuiltins(), new com.oracle.graal.python.builtins.modules.ctypes.UnionTypeBuiltins(), new SimpleCDataBuiltins(), new PyCArrayBuiltins(), new PyCPointerBuiltins(), new CDataBuiltins(), new GraalHPyUniversalModuleBuiltins(), new GraalHPyDebugModuleBuiltins(), new GraalHPyTraceModuleBuiltins(), new AsyncioModuleBuiltins(), new AsyncGeneratorBuiltins(), new AsyncGenSendBuiltins(), new AsyncGenThrowBuiltins()));
        if (hasProfilerTool) {
            builtins.add(new LsprofModuleBuiltins());
            builtins.add(LsprofModuleBuiltins.newProfilerBuiltins());
        }
        if (!PythonOptions.WITHOUT_COMPRESSION_LIBRARIES && (nativeAccessAllowed || ImageInfo.inImageBuildtimeCode())) {
            builtins.add(new BZ2CompressorBuiltins());
            builtins.add(new BZ2DecompressorBuiltins());
            builtins.add(new BZ2ModuleBuiltins());
        }
        ServiceLoader<PythonBuiltins> providers = ServiceLoader.load(PythonBuiltins.class, Python3Core.class.getClassLoader());
        for (PythonBuiltins builtin : providers) {
            builtins.add(builtin);
        }
        Python3Core.filterBuiltins(builtins);
        return builtins.toArray(new PythonBuiltins[builtins.size()]);
    }

    public Python3Core(PythonLanguage language, boolean isNativeSupportAllowed, boolean socketIOAllowed) {
        this.language = language;
        this.builtins = Python3Core.initializeBuiltins(isNativeSupportAllowed, socketIOAllowed);
        this.coreFiles = Python3Core.initializeCoreFiles();
    }

    public SysModuleState getSysModuleState() {
        return this.sysModuleState;
    }

    public final PythonContext getContext() {
        return (PythonContext)this;
    }

    public final PythonLanguage getLanguage() {
        return this.language;
    }

    public final boolean isCoreInitialized() {
        return this.initialized;
    }

    public final void initialize(PythonContext context) {
        this.objectFactory = new PythonObjectSlowPathFactory(context.getAllocationReporter(), context.getLanguage());
        this.initializeJavaCore();
        this.initializeImportlib();
        this.initializePython3Core(context.getCoreHomeOrFail());
        assert (SpecialMethodSlot.checkSlotOverrides(this));
        this.initialized = true;
    }

    private void initializeJavaCore() {
        this.initializeTypes();
        this.populateBuiltins();
        SpecialMethodSlot.initializeBuiltinsSpecialMethodSlots(this);
        this.publishBuiltinModules();
        this.builtinsModule = this.builtinModules.get(BuiltinNames.T_BUILTINS);
    }

    private void initializeImportlib() {
        PythonModule bootstrapExternal;
        PythonModule bootstrap = ImpModuleBuiltins.importFrozenModuleObject(this, T__FROZEN_IMPORTLIB, false);
        PyObjectCallMethodObjArgs callNode = PyObjectCallMethodObjArgs.getUncached();
        WriteAttributeToDynamicObjectNode writeNode = WriteAttributeToDynamicObjectNode.getUncached();
        ReadAttributeFromDynamicObjectNode readNode = ReadAttributeFromDynamicObjectNode.getUncached();
        PyDictSetItem setItem = PyDictSetItem.getUncached();
        writeNode.execute((Object)this.lookupBuiltinModule(BuiltinNames.T__WEAKREF), StringLiterals.T_REF, (Object)this.lookupType(PythonBuiltinClassType.PReferenceType));
        if (bootstrap == null) {
            bootstrapExternal = this.createModule(T_IMPORTLIB_BOOTSTRAP_EXTERNAL);
            bootstrap = this.createModule(T_IMPORTLIB_BOOTSTRAP);
            this.loadFile(PythonUtils.toTruffleStringUncached("importlib/_bootstrap_external"), this.getContext().getStdlibHome(), bootstrapExternal);
            this.loadFile(PythonUtils.toTruffleStringUncached("importlib/_bootstrap"), this.getContext().getStdlibHome(), bootstrap);
        } else {
            bootstrapExternal = ImpModuleBuiltins.importFrozenModuleObject(this, T__FROZEN_IMPORTLIB_EXTERNAL, true);
            setItem.execute(null, null, this.sysModules, T_IMPORTLIB_BOOTSTRAP, bootstrap);
            setItem.execute(null, null, this.sysModules, T_IMPORTLIB_BOOTSTRAP_EXTERNAL, bootstrapExternal);
            LOGGER.log(Level.FINE, () -> "import '" + String.valueOf(T__FROZEN_IMPORTLIB) + "' # <frozen>");
            LOGGER.log(Level.FINE, () -> "import '" + String.valueOf(T__FROZEN_IMPORTLIB_EXTERNAL) + "' # <frozen>");
        }
        setItem.execute(null, null, this.sysModules, T__FROZEN_IMPORTLIB, bootstrap);
        setItem.execute(null, null, this.sysModules, T__FROZEN_IMPORTLIB_EXTERNAL, bootstrapExternal);
        writeNode.execute((Object)bootstrap, SpecialAttributeNames.T___PACKAGE__, (Object)T_IMPORTLIB);
        writeNode.execute((Object)bootstrapExternal, SpecialAttributeNames.T___PACKAGE__, (Object)T_IMPORTLIB);
        callNode.execute(null, null, bootstrap, PythonUtils.toTruffleStringUncached("_install"), this.getSysModule(), this.lookupBuiltinModule(ImpModuleBuiltins.T__IMP));
        writeNode.execute((Object)this.getBuiltins(), BuiltinNames.T___IMPORT__, readNode.execute((Object)bootstrap, BuiltinNames.T___IMPORT__));
        callNode.execute(null, null, bootstrap, PythonUtils.toTruffleStringUncached("_install_external_importers"), new Object[0]);
        if (!PythonOptions.WITHOUT_COMPRESSION_LIBRARIES) {
            Object pathHooks = readNode.execute((Object)this.sysModule, PythonUtils.toTruffleStringUncached("path_hooks"));
            if (!(pathHooks instanceof PList)) {
                LOGGER.log(Level.FINE, () -> "unable to get sys.path_hooks");
                LOGGER.log(Level.FINE, () -> "initializing zipimport failed");
            } else {
                PList pathHooksList = (PList)pathHooks;
                LOGGER.log(Level.FINE, () -> "# installing zipimport hook");
                TruffleString t_zipimport = PythonUtils.toTruffleStringUncached("zipimport");
                PythonModule zipimport = ImpModuleBuiltins.importFrozenModuleObject(this, t_zipimport, false);
                if (zipimport == null) {
                    zipimport = this.createModule(t_zipimport);
                    try {
                        this.loadFile(t_zipimport, this.getContext().getStdlibHome(), zipimport);
                    }
                    catch (PException e) {
                        zipimport = null;
                        this.removeBuiltinModule(t_zipimport);
                    }
                } else {
                    setItem.execute(null, null, this.sysModules, t_zipimport, zipimport);
                    LOGGER.log(Level.FINE, () -> "import 'zipimport' # <frozen>");
                }
                if (zipimport == null) {
                    LOGGER.log(Level.FINE, () -> "# can't import zipimport");
                } else {
                    writeNode.execute((Object)zipimport, BuiltinNames.T___BUILTINS__, (Object)this.getBuiltins());
                    Object zipimporter = readNode.execute((Object)zipimport, PythonUtils.toTruffleStringUncached("zipimporter"));
                    if (zipimporter == PNone.NO_VALUE) {
                        LOGGER.log(Level.FINE, () -> "# can't import zipimport.zipimporter");
                    } else {
                        SequenceStorage store = pathHooksList.getSequenceStorage();
                        pathHooksList.setSequenceStorage(SequenceStorageNodes.InsertItemNode.executeUncached(store, 0, zipimporter));
                        LOGGER.log(Level.FINE, () -> "# installed zipimport hook");
                    }
                }
            }
        }
        this.importFunc = (PFunction)readNode.execute((Object)bootstrap, BuiltinNames.T___IMPORT__);
        this.importlib = bootstrap;
        PythonBuiltinClass moduleType = this.lookupType(PythonBuiltinClassType.PythonModule);
        writeNode.execute((Object)moduleType, SpecialMethodNames.T___REPR__, readNode.execute((Object)bootstrap, PythonUtils.toTruffleStringUncached("_module_repr")));
        SpecialMethodSlot.reinitializeSpecialMethodSlots(moduleType, this.getLanguage());
    }

    private void initializePython3Core(TruffleString coreHome) {
        this.loadFile(BuiltinNames.T_BUILTINS, coreHome);
        for (TruffleString s : this.coreFiles) {
            this.loadFile(s, coreHome);
        }
        this.initialized = true;
    }

    public final void postInitialize() {
        if (!ImageInfo.inImageBuildtimeCode() || ImageInfo.inImageRuntimeCode()) {
            this.initialized = false;
            for (PythonBuiltins builtin : this.builtins) {
                CoreFunctions annotation = builtin.getClass().getAnnotation(CoreFunctions.class);
                if (!annotation.isEager() && annotation.extendClasses().length == 0) continue;
                builtin.postInitialize(this);
            }
            if (!PythonOptions.WITHOUT_COMPRESSION_LIBRARIES && ImageInfo.inImageCode() && !this.getContext().isNativeAccessAllowed()) {
                this.removeBuiltinModule(BuiltinNames.T_BZ2);
            }
            this.globalScopeObject = PythonMapScope.createTopScope(this.getContext());
            this.getContext().getSharedFinalizer().registerAsyncAction();
            if (!PythonOptions.AUTOMATIC_ASYNC_ACTIONS) {
                if (this.getContext().getEnv().isPolyglotBindingsAccessAllowed()) {
                    this.getContext().getEnv().exportSymbol("PollPythonAsyncActions", this.getContext().getEnv().asGuestValue((Object)new Runnable(){

                        @Override
                        public void run() {
                            Python3Core.this.getContext().pollAsyncActions();
                        }
                    }));
                } else {
                    LOGGER.log(Level.SEVERE, "AutomaticAsyncActions are disabled, but PolyglotBindingsAccess is not allowed. Cannot expose `PollPythonAsyncActions'. If this is not called regularly, Python will leak memory.");
                }
            }
            this.initialized = true;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public final void removeBuiltinModule(TruffleString name) {
        assert (!this.initialized) : "can only remove builtin modules before initialization is finished";
        this.builtinModules.remove(name);
        if (this.sysModules != null) {
            this.sysModules.delItem(name);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public final PythonModule lookupBuiltinModule(TruffleString name) {
        return this.builtinModules.get(name);
    }

    public final PythonBuiltinClass lookupType(PythonBuiltinClassType type) {
        assert (this.builtinTypes[type.ordinal()] != null);
        return this.builtinTypes[type.ordinal()];
    }

    @CompilerDirectives.TruffleBoundary
    public final Object[] builtinModuleNames() {
        return this.builtinModules.keySet().toArray();
    }

    public final PythonModule getBuiltins() {
        return this.builtinsModule;
    }

    public final void registerTypeInBuiltins(TruffleString name, PythonBuiltinClassType type) {
        assert (this.builtinsModule != null) : "builtins module was not yet initialized: cannot register type";
        this.builtinsModule.setAttribute(name, this.lookupType(type));
    }

    public final PythonModule getSysModule() {
        return this.sysModule;
    }

    public final PDict getSysModules() {
        return this.sysModules;
    }

    public final PythonModule getImportlib() {
        return this.importlib;
    }

    public final PFunction getImportFunc() {
        return this.importFunc;
    }

    public final Object getStderr() {
        try {
            return PyObjectLookupAttr.executeUncached(this.sysModule, BuiltinNames.T_STDERR);
        }
        catch (PException e) {
            try {
                this.getContext().getEnv().err().write("lost sys.stderr\n".getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    private void publishBuiltinModules() {
        assert (this.sysModules != null);
        for (Map.Entry<TruffleString, PythonModule> entry : this.builtinModules.entrySet()) {
            CoreFunctions annotation;
            PythonModule pythonModule = entry.getValue();
            PythonBuiltins moduleBuiltins = pythonModule.getBuiltins();
            if (moduleBuiltins == null || !(annotation = moduleBuiltins.getClass().getAnnotation(CoreFunctions.class)).isEager()) continue;
            this.sysModules.setItem(entry.getKey(), pythonModule);
        }
    }

    private PythonBuiltinClass initializeBuiltinClass(PythonBuiltinClassType type) {
        int index = type.ordinal();
        if (this.builtinTypes[index] == null) {
            this.builtinTypes[index] = type.getBase() == null ? new PythonBuiltinClass(this.getLanguage(), type, null) : new PythonBuiltinClass(this.getLanguage(), type, this.initializeBuiltinClass(type.getBase()));
        }
        return this.builtinTypes[index];
    }

    private void initializeTypes() {
        for (PythonBuiltinClassType pythonBuiltinClassType : PythonBuiltinClassType.VALUES) {
            this.initializeBuiltinClass(pythonBuiltinClassType);
        }
        for (PythonBuiltins pythonBuiltins : this.builtins) {
            CoreFunctions annotation = pythonBuiltins.getClass().getAnnotation(CoreFunctions.class);
            if (annotation.defineModule().length() <= 0) continue;
            this.createModule(PythonUtils.toTruffleStringUncached(annotation.defineModule()), pythonBuiltins);
        }
        for (PythonBuiltinClassType pythonBuiltinClassType : PythonBuiltinClassType.VALUES) {
            TruffleString module = pythonBuiltinClassType.getPublishInModule();
            if (module == null) continue;
            PythonModule pythonModule = this.lookupBuiltinModule(module);
            if (pythonModule != null) {
                pythonModule.setAttribute(pythonBuiltinClassType.getName(), this.lookupType(pythonBuiltinClassType));
            }
            if (!module.toJavaStringUncached().equals("posix") || (pythonModule = this.lookupBuiltinModule(BuiltinNames.T_NT)) == null) continue;
            pythonModule.setAttribute(pythonBuiltinClassType.getName(), this.lookupType(pythonBuiltinClassType));
        }
        this.pyTrue = this.factory().createInt((Object)PythonBuiltinClassType.Boolean, BigInteger.ONE);
        this.pyFalse = this.factory().createInt((Object)PythonBuiltinClassType.Boolean, BigInteger.ZERO);
        this.pyNaN = this.factory().createFloat(Double.NaN);
    }

    private void populateBuiltins() {
        for (PythonBuiltins builtin : this.builtins) {
            PythonModule module;
            builtin.initialize(this);
            CoreFunctions annotation = builtin.getClass().getAnnotation(CoreFunctions.class);
            if (annotation.defineModule().length() > 0 && (module = this.builtinModules.get(PythonUtils.toTruffleStringUncached(annotation.defineModule()))) != null) {
                this.addBuiltinsTo(module, builtin);
            }
            if (annotation.extendsModule().length() > 0 && (module = this.builtinModules.get(PythonUtils.toTruffleStringUncached(annotation.extendsModule()))) != null) {
                this.addBuiltinsTo(module, builtin);
            }
            for (PythonBuiltinClassType klass : annotation.extendClasses()) {
                this.addBuiltinsTo(this.lookupType(klass), builtin);
            }
        }
        this.sysModule = this.builtinModules.get(BuiltinNames.T_SYS);
        this.sysModules = (PDict)this.sysModule.getAttribute(BuiltinNames.T_MODULES);
    }

    private PythonModule createModule(TruffleString name) {
        return this.createModule(name, null);
    }

    private void addBuiltinModule(TruffleString name, PythonModule module) {
        this.builtinModules.put(name, module);
        if (this.sysModules != null) {
            this.sysModules.setItem(name, module);
        }
    }

    private PythonModule createModule(TruffleString name, PythonBuiltins moduleBuiltins) {
        PythonModule mod = this.builtinModules.get(name);
        if (mod == null) {
            mod = this.factory().createPythonModule(name);
            if (moduleBuiltins != null) {
                mod.setBuiltins(moduleBuiltins);
            }
            this.addBuiltinModule(name, mod);
        }
        return mod;
    }

    private void addBuiltinsTo(PythonObject obj, PythonBuiltins builtinsForObj) {
        builtinsForObj.addConstantsToModuleObject(obj);
        builtinsForObj.addFunctionsToModuleObject(obj, this.objectFactory);
    }

    @CompilerDirectives.TruffleBoundary
    private Source getInternalSource(TruffleString basename, TruffleString prefix) {
        String errorMessage;
        PythonContext ctxt = this.getContext();
        TruffleLanguage.Env env = ctxt.getEnv();
        String suffix = env.getFileNameSeparator() + String.valueOf(basename) + ".py";
        TruffleFile file = env.getInternalTruffleFile(String.valueOf(prefix) + suffix);
        try {
            return PythonLanguage.newSource(ctxt, file, basename.toJavaStringUncached());
        }
        catch (IOException e) {
            errorMessage = "Startup failed, could not read core library from " + String.valueOf(file) + ". Maybe you need to set python.CoreHome and python.StdLibHome.";
        }
        catch (SecurityException e) {
            errorMessage = "Startup failed, a security exception occurred while reading from " + String.valueOf(file) + ". Maybe you need to set python.CoreHome and python.StdLibHome.";
        }
        LOGGER.log(Level.SEVERE, errorMessage);
        RuntimeException e = new RuntimeException(errorMessage);
        throw e;
    }

    private void loadFile(TruffleString s, TruffleString prefix) {
        PythonModule mod = this.lookupBuiltinModule(s);
        if (mod == null) {
            mod = this.factory().createPythonModule(T___ANONYMOUS__);
        }
        this.loadFile(s, prefix, mod);
    }

    private void loadFile(TruffleString s, TruffleString prefix, PythonModule mod) {
        if (ImpModuleBuiltins.importFrozenModuleObject(this, StringUtils.cat(StringLiterals.T_GRAALPYTHON, StringLiterals.T_DOT, s), false, mod) != null) {
            LOGGER.log(Level.FINE, () -> "import '" + String.valueOf(s) + "' # <frozen>");
            return;
        }
        Supplier getCode = () -> {
            Source source = this.getInternalSource(s, prefix);
            return this.getLanguage().parse(this.getContext(), source, InputType.FILE, false, 0, false, null, EnumSet.noneOf(FutureFeature.class));
        };
        RootCallTarget callTarget = (RootCallTarget)this.getLanguage().cacheCode(s, getCode);
        GenericInvokeNode.getUncached().execute(callTarget, PArguments.withGlobals(mod));
    }

    public final PythonObjectSlowPathFactory factory() {
        return this.objectFactory;
    }

    public final PInt getTrue() {
        return this.pyTrue;
    }

    public final PInt getFalse() {
        return this.pyFalse;
    }

    public final PFloat getNaN() {
        return this.pyNaN;
    }

    public final Object getTopScopeObject() {
        return this.globalScopeObject;
    }

    public static void writeInfo(String message) {
        PythonLanguage.getLogger(Python3Core.class).fine(message);
    }

    public static void writeInfo(Supplier<String> messageSupplier) {
        PythonLanguage.getLogger(Python3Core.class).fine(messageSupplier);
    }

    static {
        Class<?> c = null;
        try {
            c = Class.forName("com.oracle.truffle.tools.profiler.CPUSampler");
        }
        catch (ClassNotFoundException | LinkageError throwable) {
            // empty catch block
        }
        hasProfilerTool = c != null;
        Object var0 = null;
    }

    @CompilerDirectives.ValueType
    public static class SysModuleState {
        private int recursionLimit = ImageInfo.inImageCode() ? 8000 : 1000;
        private int checkInterval = 100;
        private double switchInterval = 0.005;

        public int getRecursionLimit() {
            return this.recursionLimit;
        }

        public void setRecursionLimit(int recursionLimit) {
            this.recursionLimit = recursionLimit;
        }

        public int getCheckInterval() {
            return this.checkInterval;
        }

        public void setCheckInterval(int checkInterval) {
            this.checkInterval = checkInterval;
        }

        public double getSwitchInterval() {
            return this.switchInterval;
        }

        public void setSwitchInterval(double switchInterval) {
            this.switchInterval = switchInterval;
        }
    }
}

