/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ResourceModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.thread.PThread;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.StructSequence;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.util.List;
import org.graalvm.nativeimage.ImageInfo;

@CoreFunctions(defineModule="resource")
public final class ResourceModuleBuiltins
extends PythonBuiltins {
    static int RUSAGE_CHILDREN = -1;
    static int RUSAGE_SELF = 0;
    static int RUSAGE_THREAD = 1;
    static int RLIMIT_CPU = 0;
    static int RLIMIT_FSIZE = 1;
    static int RLIMIT_DATA = 2;
    static int RLIMIT_STACK = 3;
    static int RLIMIT_CORE = 4;
    static int RLIMIT_AS = 5;
    static int RLIMIT_RSS = 5;
    static int RLIMIT_MEMLOCK = 6;
    static int RLIMIT_NPROC = 7;
    static int RLIMIT_NOFILE = 8;
    static long RLIM_INFINITY = Long.MAX_VALUE;
    static final StructSequence.BuiltinTypeDescriptor STRUCT_RUSAGE_DESC = new StructSequence.BuiltinTypeDescriptor(PythonBuiltinClassType.PStructRusage, "struct_rusage: Result from getrusage.\n\nThis object may be accessed either as a tuple of\n    (utime,stime,maxrss,ixrss,idrss,isrss,minflt,majflt,\n    nswap,inblock,oublock,msgsnd,msgrcv,nsignals,nvcsw,nivcsw)\nor via the attributes ru_utime, ru_stime, ru_maxrss, and so on.", 16, new String[]{"ru_utime", "ru_stime", "ru_maxrss", "ru_ixrss", "ru_idrss", "ru_isrss", "ru_minflt", "ru_majflt", "ru_nswap", "ru_inblock", "ru_oublock", "ru_msgsnd", "ru_msgrcv", "ru_nsignals", "ru_nvcsw", "ru_nivcsw"}, new String[]{"user time used", "system time used", "max. resident set size", "shared memory size", "unshared data size", "unshared stack size", "page faults not requiring I/O", "page faults requiring I/O", "number of swap outs", "block input operations", "block output operations", "IPC messages sent", "IPC messages received", "signals received", "voluntary context switches", "involuntary context switches"});

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ResourceModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        this.addBuiltinConstant("RUSAGE_CHILDREN", (Object)RUSAGE_CHILDREN);
        this.addBuiltinConstant("RUSAGE_SELF", (Object)RUSAGE_SELF);
        this.addBuiltinConstant("RUSAGE_THREAD", (Object)RUSAGE_THREAD);
        this.addBuiltinConstant("RLIMIT_CPU", (Object)RLIMIT_CPU);
        this.addBuiltinConstant("RLIMIT_FSIZE", (Object)RLIMIT_FSIZE);
        this.addBuiltinConstant("RLIMIT_DATA", (Object)RLIMIT_DATA);
        this.addBuiltinConstant("RLIMIT_STACK", (Object)RLIMIT_STACK);
        this.addBuiltinConstant("RLIMIT_CORE", (Object)RLIMIT_CORE);
        this.addBuiltinConstant("RLIMIT_AS", (Object)RLIMIT_AS);
        this.addBuiltinConstant("RLIMIT_RSS", (Object)RLIMIT_RSS);
        this.addBuiltinConstant("RLIMIT_MEMLOCK", (Object)RLIMIT_MEMLOCK);
        this.addBuiltinConstant("RLIMIT_NPROC", (Object)RLIMIT_NPROC);
        this.addBuiltinConstant("RLIMIT_NOFILE", (Object)RLIMIT_NOFILE);
        this.addBuiltinConstant("RLIM_INFINITY", (Object)RLIM_INFINITY);
        StructSequence.initType(core, STRUCT_RUSAGE_DESC);
    }

    @Builtin(name="getrlimit", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetRLimitNode
    extends PythonBuiltinNode {
        GetRLimitNode() {
        }

        @Specialization
        static PTuple getPageSize(int which, @Cached PythonObjectFactory factory) {
            return factory.createTuple(new Object[]{RLIM_INFINITY, RLIM_INFINITY});
        }
    }

    @Builtin(name="getpagesize", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class GetPageSizeNode
    extends PythonBuiltinNode {
        GetPageSizeNode() {
        }

        @Specialization
        static int getPageSize() {
            return 4096;
        }
    }

    @Builtin(name="getrusage", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @ImportStatic(value={ResourceModuleBuiltins.class})
    static abstract class GetRuUsageNode
    extends PythonBuiltinNode {
        GetRuUsageNode() {
        }

        @Specialization(guards={"who == RUSAGE_THREAD"})
        @CompilerDirectives.TruffleBoundary
        PTuple getruusageThread(int who) {
            long ru_maxrss;
            long id = PThread.getThreadId(Thread.currentThread());
            Runtime runtime = Runtime.getRuntime();
            double ru_utime = 0.0;
            double ru_stime = 0.0;
            if (!ImageInfo.inImageCode()) {
                ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                if (threadMXBean.isCurrentThreadCpuTimeSupported()) {
                    ru_utime = (double)threadMXBean.getThreadUserTime(id) / 1.0E9;
                    ru_stime = (double)Math.max(0L, threadMXBean.getThreadCpuTime(id) - threadMXBean.getThreadUserTime(id)) / 1.0E9;
                }
                if (threadMXBean instanceof com.sun.management.ThreadMXBean) {
                    com.sun.management.ThreadMXBean thMxBean = (com.sun.management.ThreadMXBean)threadMXBean;
                    ru_maxrss = thMxBean.getThreadAllocatedBytes(id);
                } else {
                    ru_maxrss = runtime.maxMemory();
                }
            } else {
                ru_maxrss = runtime.maxMemory();
            }
            String osName = System.getProperty("os.name");
            if (osName.contains("Linux")) {
                ru_maxrss /= 1024L;
            }
            long ru_ixrss = -1L;
            long ru_idrss = -1L;
            long ru_isrss = -1L;
            long ru_minflt = -1L;
            long ru_majflt = -1L;
            long ru_nswap = -1L;
            long ru_inblock = -1L;
            long ru_oublock = -1L;
            long ru_msgsnd = -1L;
            long ru_msgrcv = -1L;
            long ru_nsignals = -1L;
            long ru_nvcsw = -1L;
            long ru_nivcsw = -1L;
            return PythonObjectFactory.getUncached().createStructSeq(STRUCT_RUSAGE_DESC, ru_utime, ru_stime, ru_maxrss, ru_ixrss, ru_idrss, ru_isrss, ru_minflt, ru_majflt, ru_nswap, ru_inblock, ru_oublock, ru_msgsnd, ru_msgrcv, ru_nsignals, ru_nvcsw, ru_nivcsw);
        }

        @Specialization(guards={"who == RUSAGE_SELF"})
        @CompilerDirectives.TruffleBoundary
        PTuple getruusageSelf(int who) {
            long ru_maxrss;
            Runtime runtime = Runtime.getRuntime();
            double ru_utime = 0.0;
            double ru_stime = 0.0;
            if (!ImageInfo.inImageCode()) {
                ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                if (threadMXBean.isThreadCpuTimeSupported()) {
                    for (long thId : threadMXBean.getAllThreadIds()) {
                        long tu = threadMXBean.getThreadUserTime(thId);
                        long tc = threadMXBean.getThreadCpuTime(thId);
                        if (tu != -1L) {
                            ru_utime += (double)tu / 1.0E9;
                        }
                        if (tu == -1L || tc == -1L) continue;
                        ru_stime += (double)Math.max(0L, tc - tu) / 1.0E9;
                    }
                }
                MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
                MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
                MemoryUsage nonHeapMemoryUsage = memoryMXBean.getNonHeapMemoryUsage();
                ru_maxrss = heapMemoryUsage.getCommitted() + nonHeapMemoryUsage.getCommitted();
            } else {
                ru_maxrss = runtime.maxMemory();
            }
            String osName = System.getProperty("os.name");
            if (osName.contains("Linux")) {
                ru_maxrss /= 1024L;
            }
            long ru_ixrss = -1L;
            long ru_idrss = -1L;
            long ru_isrss = -1L;
            long ru_minflt = -1L;
            long ru_majflt = -1L;
            long ru_nswap = -1L;
            long ru_inblock = -1L;
            long ru_oublock = -1L;
            long ru_msgsnd = -1L;
            long ru_msgrcv = -1L;
            long ru_nsignals = -1L;
            long ru_nvcsw = -1L;
            long ru_nivcsw = -1L;
            return PythonObjectFactory.getUncached().createStructSeq(STRUCT_RUSAGE_DESC, ru_utime, ru_stime, ru_maxrss, ru_ixrss, ru_idrss, ru_isrss, ru_minflt, ru_majflt, ru_nswap, ru_inblock, ru_oublock, ru_msgsnd, ru_msgrcv, ru_nsignals, ru_nvcsw, ru_nivcsw);
        }

        @Fallback
        static PTuple getruusage(Object who, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.RUSAGE_NOT_YET_IMPLEMENED);
        }
    }
}

