/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.BuiltinConstructors;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeClass;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.PrimitiveNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.dict.DictBuiltins;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.GetSetDescriptor;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.iterator.IteratorNodes;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.mappingproxy.PMappingproxy;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyMappingCheckNode;
import com.oracle.graal.python.lib.PyNumberCheckNode;
import com.oracle.graal.python.lib.PyNumberFloatNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyObjectDelItem;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PySequenceCheckNode;
import com.oracle.graal.python.lib.PySequenceContainsNode;
import com.oracle.graal.python.lib.PySequenceGetItemNode;
import com.oracle.graal.python.lib.PySequenceIterSearchNode;
import com.oracle.graal.python.lib.PySliceNew;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToDynamicObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallBinaryNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallTernaryNode;
import com.oracle.graal.python.nodes.expression.BinaryArithmetic;
import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.expression.InplaceArithmetic;
import com.oracle.graal.python.nodes.expression.LookupAndCallInplaceNode;
import com.oracle.graal.python.nodes.expression.TernaryArithmetic;
import com.oracle.graal.python.nodes.expression.UnaryArithmetic;
import com.oracle.graal.python.nodes.expression.UnaryOpNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.truffle.PythonTypes;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextAbstractBuiltins {
    private static PList getKeys(VirtualFrame frame, Node inliningTarget, Object obj, PyObjectGetAttr getAttrNode, CallNode callNode, ListNodes.ConstructListNode listNode) {
        Object attr = getAttrNode.execute((Frame)frame, inliningTarget, obj, SpecialMethodNames.T_KEYS);
        return listNode.execute((Frame)frame, callNode.execute((Frame)frame, attr, new Object[0]));
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyObject_SetDoc
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyObject_SetDoc() {
        }

        @Specialization
        static int set(PBuiltinFunction obj, TruffleString value, @Cached.Shared(value="write") @Cached WriteAttributeToDynamicObjectNode write) {
            write.execute((Object)obj, SpecialAttributeNames.T___DOC__, (Object)value);
            return 1;
        }

        @Specialization
        static int set(PBuiltinMethod obj, TruffleString value, @Cached.Shared(value="write") @Cached WriteAttributeToDynamicObjectNode write) {
            PyObject_SetDoc.set(obj.getBuiltinFunction(), value, write);
            return 1;
        }

        @Specialization
        static int set(GetSetDescriptor obj, TruffleString value, @Cached.Shared(value="write") @Cached WriteAttributeToDynamicObjectNode write) {
            write.execute((Object)obj, SpecialAttributeNames.T___DOC__, (Object)value);
            return 1;
        }

        @Specialization(guards={"isType.execute(inliningTarget, type)"}, limit="1")
        static int set(PythonNativeClass type, TruffleString value, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.IsTypeNode isType, @Cached(value="createForceType()") WriteAttributeToObjectNode write) {
            write.execute((Object)type, SpecialAttributeNames.T___DOC__, (Object)value);
            return 1;
        }

        @Fallback
        static int set(Object obj, Object value) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere((String)("Don't know how to set doc for " + String.valueOf(obj.getClass())));
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.ConstCharPtr, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyObject_GetDoc
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyObject_GetDoc() {
        }

        @Specialization
        Object get(Object obj, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttr lookupAttr, @Cached CExtNodes.AsCharPointerNode asCharPointerNode) {
            try {
                Object doc = lookupAttr.execute(null, inliningTarget, obj, SpecialAttributeNames.T___DOC__);
                if (!(doc instanceof PNone)) {
                    return asCharPointerNode.execute(doc);
                }
            }
            catch (PException pException) {
                // empty catch block
            }
            return this.getNULL();
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyIter_Next
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyIter_Next() {
        }

        @Specialization
        Object check(Object object, @Bind(value="this") Node inliningTarget, @Cached BuiltinFunctions.NextNode nextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isClassProfile) {
            try {
                return nextNode.execute(null, object, PNone.NO_VALUE);
            }
            catch (PException e) {
                if (isClassProfile.profileException(inliningTarget, e, PythonBuiltinClassType.StopIteration)) {
                    return this.getNativeNull();
                }
                throw e;
            }
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Py_ssize_t, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyMapping_Size
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyMapping_Size() {
        }

        @Specialization(guards={"!isNativeObject(obj)"})
        static int doMapping(Object obj, @Bind(value="this") Node inliningTarget, @Cached PyObjectSizeNode sizeNode, @Cached TypeNodes.IsSameTypeNode isSameType, @Cached GetClassNode getClassNode, @Cached PRaiseNode.Lazy raiseNode) {
            Object cls = getClassNode.execute(inliningTarget, obj);
            if (isSameType.execute(inliningTarget, cls, (Object)PythonBuiltinClassType.PSet) || isSameType.execute(inliningTarget, cls, (Object)PythonBuiltinClassType.PFrozenSet) || isSameType.execute(inliningTarget, cls, (Object)PythonBuiltinClassType.PDeque)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_ISNT_MAPPING, obj);
            }
            return sizeNode.execute(null, inliningTarget, obj);
        }

        @Specialization(guards={"isNativeObject(obj)"})
        static Object doNative(Object obj, @Cached CApiTransitions.PythonToNativeNode toSulongNode, @Cached CExtNodes.PCallCapiFunction callCapiFunction) {
            return callCapiFunction.call(NativeCAPISymbol.FUN_PY_TRUFFLE_PY_MAPPING_SIZE, toSulongNode.execute(obj));
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyMapping_Check
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyMapping_Check() {
        }

        @Specialization(guards={"!isNativeObject(object)"})
        static int doPythonObject(Object object, @Bind(value="this") Node inliningTarget, @Cached PyMappingCheckNode checkNode) {
            return PInt.intValue(checkNode.execute(inliningTarget, object));
        }

        @Specialization(guards={"isNativeObject(obj)"})
        static Object doNative(Object obj, @Cached CApiTransitions.PythonToNativeNode toSulongNode, @Cached CExtNodes.PCallCapiFunction callCapiFunction) {
            return callCapiFunction.call(NativeCAPISymbol.FUN_PY_TRUFFLE_PY_MAPPING_CHECK, toSulongNode.execute(obj));
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyMapping_Values
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyMapping_Values() {
        }

        @Specialization
        static Object values(PDict obj, @Cached.Shared @Cached ListNodes.ConstructListNode listNode, @Cached DictBuiltins.ValuesNode valuesNode) {
            return listNode.execute(null, valuesNode.execute(null, obj));
        }

        @Specialization(guards={"!isDict(obj)"})
        static Object values(Object obj, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttrNode, @Cached CallNode callNode, @Cached.Shared @Cached ListNodes.ConstructListNode listNode, @Cached PRaiseNode.Lazy raiseNode) {
            PyMapping_Values.checkNonNullArg(inliningTarget, obj, raiseNode);
            Object attr = getAttrNode.execute(inliningTarget, obj, SpecialMethodNames.T_VALUES);
            return listNode.execute(null, callNode.execute(attr, new Object[0]));
        }
    }

    @PythonCextBuiltins.CApiBuiltins(value={@PythonCextBuiltins.CApiBuiltin(name="PyDict_Items", ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct), @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)})
    static abstract class PyMapping_Items
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyMapping_Items() {
        }

        @Specialization
        static Object items(PDict obj, @Cached DictBuiltins.ItemsNode itemsNode, @Cached.Shared @Cached ListNodes.ConstructListNode listNode) {
            return listNode.execute(null, itemsNode.execute(null, obj));
        }

        @Specialization(guards={"!isDict(obj)"})
        static Object items(Object obj, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttrNode, @Cached CallNode callNode, @Cached.Shared @Cached ListNodes.ConstructListNode listNode) {
            Object attr = getAttrNode.execute(inliningTarget, obj, SpecialMethodNames.T_ITEMS);
            return listNode.execute(null, callNode.execute(attr, new Object[0]));
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyMapping_Keys
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyMapping_Keys() {
        }

        @Specialization
        Object keys(PDict obj, @Cached DictBuiltins.KeysNode keysNode, @Cached.Shared @Cached ListNodes.ConstructListNode listNode) {
            return listNode.execute(null, keysNode.execute(null, obj));
        }

        @Specialization(guards={"!isDict(obj)"})
        Object keys(Object obj, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttrNode, @Cached CallNode callNode, @Cached.Shared @Cached ListNodes.ConstructListNode listNode) {
            return PythonCextAbstractBuiltins.getKeys(null, inliningTarget, obj, getAttrNode, callNode, listNode);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Py_ssize_t, args={ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyObject_LengthHint
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyObject_LengthHint() {
        }

        @Specialization
        static long doGenericUnboxed(Object obj, long defaultValue, @Bind(value="this") Node inliningTarget, @Cached IteratorNodes.GetLength getLength) {
            int len = getLength.execute(null, inliningTarget, obj);
            if (len == -1) {
                return defaultValue;
            }
            return len;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Py_ssize_t, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyObject_Size
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyObject_Size() {
        }

        @Specialization(guards={"!isNativeObject(obj)"})
        static int doGenericUnboxed(Object obj, @Bind(value="this") Node inliningTarget, @Cached PyObjectSizeNode sizeNode) {
            return sizeNode.execute(null, inliningTarget, obj);
        }

        @Specialization(guards={"isNativeObject(obj)"})
        static Object size(Object obj, @Cached CApiTransitions.PythonToNativeNode toSulongNode, @Cached CExtNodes.PCallCapiFunction callCapiFunction) {
            return callCapiFunction.call(NativeCAPISymbol.FUN_PY_TRUFFLE_PY_OBJECT_SIZE, toSulongNode.execute(obj));
        }
    }

    @PythonCextBuiltins.CApiBuiltins(value={@PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct), @PythonCextBuiltins.CApiBuiltin(name="PyTruffleObject_GetItemString", ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Ignored)})
    static abstract class PyObject_GetItem
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyObject_GetItem() {
        }

        @Specialization
        Object doManaged(Object list, Object key, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetItem getItem) {
            return getItem.execute(null, inliningTarget, list, key);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Py_ssize_t, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PySequence_Index
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PySequence_Index() {
        }

        @Specialization
        static int contains(Object haystack, Object needle, @Bind(value="this") Node inliningTarget, @Cached PySequenceIterSearchNode searchNode) {
            return searchNode.execute(inliningTarget, haystack, needle, 2);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Py_ssize_t, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PySequence_Count
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PySequence_Count() {
        }

        @Specialization
        static int contains(Object haystack, Object needle, @Bind(value="this") Node inliningTarget, @Cached PySequenceIterSearchNode searchNode) {
            return searchNode.execute(inliningTarget, haystack, needle, 1);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t, ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PySequence_DelSlice
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PySequence_DelSlice() {
        }

        @Specialization
        static int setSlice(Object sequence, Object iLow, Object iHigh, @Bind(value="this") Node inliningTarget, @Cached(value="create(DelItem)") LookupAndCallBinaryNode delItemNode, @Cached PySliceNew sliceNode) {
            delItemNode.executeObject(null, sequence, sliceNode.execute(inliningTarget, iLow, iHigh, PNone.NONE));
            return 0;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t, ArgDescriptor.Py_ssize_t, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PySequence_SetSlice
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        PySequence_SetSlice() {
        }

        @Specialization
        static int setSlice(Object sequence, Object iLow, Object iHigh, Object s, @Bind(value="this") Node inliningTarget, @Cached(value="create(SetItem)") LookupAndCallTernaryNode setItemNode, @Cached PySliceNew sliceNode) {
            setItemNode.execute(null, sequence, sliceNode.execute(inliningTarget, iLow, iHigh, PNone.NONE), s);
            return 0;
        }
    }

    @PythonCextBuiltins.CApiBuiltins(value={@PythonCextBuiltins.CApiBuiltin(name="PySequence_Length", ret=ArgDescriptor.Py_ssize_t, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct), @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Py_ssize_t, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)})
    static abstract class PySequence_Size
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PySequence_Size() {
        }

        @Specialization(guards={"!isNativeObject(obj)"})
        static Object doSequence(Object obj, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.IsSameTypeNode isSameType, @Cached GetClassNode getClassNode, @Cached PyObjectSizeNode sizeNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (obj instanceof PMappingproxy || isSameType.execute(inliningTarget, getClassNode.execute(inliningTarget, obj), (Object)PythonBuiltinClassType.PDict)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_A_SEQUENCE, obj);
            }
            return sizeNode.execute(null, inliningTarget, obj);
        }

        @Specialization(guards={"isNativeObject(obj)"})
        static Object doNative(Object obj, @Cached CApiTransitions.PythonToNativeNode toSulongNode, @Cached CExtNodes.PCallCapiFunction callCapiFunction) {
            return callCapiFunction.call(NativeCAPISymbol.FUN_PY_TRUFFLE_PY_SEQUENCE_SIZE, toSulongNode.execute(obj));
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PySequence_GetItem
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PySequence_GetItem() {
        }

        @Specialization
        Object doManaged(Object delegate, long position, @Cached PySequenceGetItemNode getItemNode) {
            if ((long)((int)position) != position) {
                throw PRaiseNode.raiseUncached(this, PythonBuiltinClassType.OverflowError, ErrorMessages.CANNOT_FIT_P_INTO_INDEXSIZED_INT, position);
            }
            return getItemNode.execute(null, delegate, (int)position);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PySequence_Check
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PySequence_Check() {
        }

        @Specialization
        static int check(Object object, @Bind(value="this") Node inliningTarget, @Cached PySequenceCheckNode check) {
            if (object == PNone.NO_VALUE) {
                return PInt.intValue(false);
            }
            return PInt.intValue(check.execute(inliningTarget, object));
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PySequence_DelItem
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PySequence_DelItem() {
        }

        @Specialization
        static Object run(Object o, Object i, @Bind(value="this") Node inliningTarget, @Cached PyObjectDelItem delItemNode) {
            delItemNode.execute(null, inliningTarget, o, i);
            return 0;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PySequence_InPlaceConcat
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PySequence_InPlaceConcat() {
        }

        @Specialization(guards={"checkNode.execute(inliningTarget, s1)"}, limit="1")
        static Object concat(Object s1, Object s2, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttr lookupNode, @Cached CallNode callNode, @Cached(value="createAdd()") BinaryArithmetic.AddNode addNode, @Cached.Exclusive @Cached PySequenceCheckNode checkNode) {
            Object iaddCallable = lookupNode.execute(null, inliningTarget, s1, SpecialMethodNames.T___IADD__);
            if (iaddCallable != PNone.NO_VALUE) {
                return callNode.execute(iaddCallable, s2);
            }
            return addNode.executeObject(null, s1, s2);
        }

        @Specialization(guards={"!checkNode.execute(inliningTarget, s1)"}, limit="1")
        static Object concat(Object s1, Object s2, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PySequenceCheckNode checkNode, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_CANT_BE_CONCATENATED, s1);
        }

        protected BinaryArithmetic.AddNode createAdd() {
            return (BinaryArithmetic.AddNode)BinaryArithmetic.Add.create();
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PySequence_Concat
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PySequence_Concat() {
        }

        @Specialization(guards={"checkNode.execute(inliningTarget, s1)", "checkNode.execute(inliningTarget, s1)"})
        Object concat(Object s1, Object s2, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="check") @Cached PySequenceCheckNode checkNode, @Cached(value="createAdd()") BinaryArithmetic.AddNode addNode) {
            return addNode.executeObject(null, s1, s2);
        }

        @Specialization(guards={"!checkNode.execute(inliningTarget, s1) || checkNode.execute(inliningTarget, s2)"})
        static Object cantConcat(Object s1, Object s2, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="check") @Cached PySequenceCheckNode checkNode, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_CANT_BE_CONCATENATED, s1);
        }

        @NeverDefault
        protected BinaryArithmetic.AddNode createAdd() {
            return (BinaryArithmetic.AddNode)BinaryArithmetic.Add.create();
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PySequence_InPlaceRepeat
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PySequence_InPlaceRepeat() {
        }

        @Specialization(guards={"checkNode.execute(inliningTarget, obj)"}, limit="1")
        static Object repeat(Object obj, long n, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttr lookupNode, @Cached CallNode callNode, @Cached(value="createMul()") BinaryArithmetic.MulNode mulNode, @Cached.Exclusive @Cached PySequenceCheckNode checkNode) {
            Object imulCallable = lookupNode.execute(null, inliningTarget, obj, SpecialMethodNames.T___IMUL__);
            if (imulCallable != PNone.NO_VALUE) {
                Object ret = callNode.execute(imulCallable, n);
                return ret;
            }
            return mulNode.executeObject(null, obj, n);
        }

        @Specialization(guards={"!checkNode.execute(inliningTarget, obj)"}, limit="1")
        static Object repeat(Object obj, Object n, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PySequenceCheckNode checkNode, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_CANT_BE_REPEATED, obj);
        }

        protected BinaryArithmetic.MulNode createMul() {
            return (BinaryArithmetic.MulNode)BinaryArithmetic.Mul.create();
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PySequence_Repeat
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PySequence_Repeat() {
        }

        @Specialization(guards={"checkNode.execute(inliningTarget, obj)"})
        Object repeat(Object obj, long n, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="check") @Cached PySequenceCheckNode checkNode, @Cached(value="createMul()") BinaryArithmetic.MulNode mulNode) {
            return mulNode.executeObject(null, obj, n);
        }

        @Specialization(guards={"!checkNode.execute(inliningTarget, obj)"})
        static Object repeat(Object obj, Object n, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="check") @Cached PySequenceCheckNode checkNode, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_CANT_BE_REPEATED, obj);
        }

        @NeverDefault
        protected BinaryArithmetic.MulNode createMul() {
            return (BinaryArithmetic.MulNode)BinaryArithmetic.Mul.create();
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PySequence_Contains
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PySequence_Contains() {
        }

        @Specialization
        static int contains(Object haystack, Object needle, @Bind(value="this") Node inliningTarget, @Cached PySequenceContainsNode containsNode) {
            return PInt.intValue(containsNode.execute(null, inliningTarget, haystack, needle));
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t, ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Direct)
    @TypeSystemReference(value=PythonTypes.class)
    static abstract class PySequence_GetSlice
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PySequence_GetSlice() {
        }

        @Specialization(guards={"checkNode.execute(inliningTarget, obj)"}, limit="1")
        static Object getSlice(Object obj, long iLow, long iHigh, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PySequenceCheckNode checkNode, @Cached PyObjectLookupAttr lookupAttrNode, @Cached PySliceNew sliceNode, @Cached CallNode callNode) {
            Object getItemCallable = lookupAttrNode.execute(null, inliningTarget, obj, SpecialMethodNames.T___GETITEM__);
            return callNode.execute(getItemCallable, sliceNode.execute(inliningTarget, iLow, iHigh, PNone.NONE));
        }

        @Specialization(guards={"!checkNode.execute(inliningTarget, obj)"}, limit="1")
        static Object getSlice(Object obj, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PySequenceCheckNode checkNode, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_IS_UNSLICEABLE, obj);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    public static abstract class PySequence_SetItem
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        @Specialization(guards={"checkNode.execute(inliningTarget, obj)"}, limit="1")
        static Object setItem(Object obj, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PySequenceCheckNode checkNode, @Cached PyObjectLookupAttr lookupAttrNode, @Cached InlinedConditionProfile hasSetItem, @Cached CallNode callNode, @Cached PRaiseNode.Lazy raiseNode) {
            Object setItemCallable = lookupAttrNode.execute(null, inliningTarget, obj, SpecialMethodNames.T___SETITEM__);
            if (hasSetItem.profile(inliningTarget, setItemCallable == PNone.NO_VALUE)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.P_OBJ_DOES_NOT_SUPPORT_ITEM_ASSIGMENT, obj);
            }
            callNode.execute(setItemCallable, key, value);
            return 0;
        }

        @Specialization(guards={"!checkNode.execute(inliningTarget, obj)"}, limit="1")
        static Object setItem(Object obj, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PySequenceCheckNode checkNode, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_A_SEQUENCE, obj);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PySequence_List
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PySequence_List() {
        }

        @Specialization
        Object values(Object obj, @Cached ListNodes.ConstructListNode listNode) {
            return listNode.execute(null, obj);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PySequence_Tuple
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PySequence_Tuple() {
        }

        @Specialization
        Object values(Object obj, @Bind(value="this") Node inliningTarget, @Cached BuiltinConstructors.TupleNode tupleNode, @Cached GetClassNode getClassNode) {
            if (getClassNode.execute(inliningTarget, obj) == PythonBuiltinClassType.PTuple) {
                return obj;
            }
            return tupleNode.execute(null, (Object)PythonBuiltinClassType.PTuple, obj);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyNumber_Power
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        @Node.Child
        private LookupAndCallTernaryNode callNode;

        PyNumber_Power() {
        }

        @Specialization
        Object doGeneric(Object o1, Object o2, Object o3) {
            return this.ensureCallNode().execute(null, o1, o2, o3);
        }

        private LookupAndCallTernaryNode ensureCallNode() {
            if (this.callNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callNode = (LookupAndCallTernaryNode)this.insert(TernaryArithmetic.Pow.create());
            }
            return this.callNode;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyNumber_InPlacePower
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyNumber_InPlacePower() {
        }

        @Specialization(guards={"o1.isIntLike()", "o2.isIntLike()", "o3.isIntLike()"})
        static Object doIntLikePrimitiveWrapper(PrimitiveNativeWrapper o1, PrimitiveNativeWrapper o2, PrimitiveNativeWrapper o3, @Cached.Shared @Cached(value="createIPow()") LookupAndCallInplaceNode callNode) {
            return callNode.executeTernary(null, o1.getLong(), o2.getLong(), o3.getLong());
        }

        @Specialization(replaces={"doIntLikePrimitiveWrapper"})
        static Object doGeneric(Object o1, Object o2, Object o3, @Cached.Shared @Cached(value="createIPow()") LookupAndCallInplaceNode callNode) {
            return callNode.executeTernary(null, o1, o2, o3);
        }

        @NeverDefault
        static LookupAndCallInplaceNode createIPow() {
            return InplaceArithmetic.IPow.create();
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Int}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleNumber_InPlaceBinOp
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        static int MAX_CACHE_SIZE = InplaceArithmetic.values().length;

        PyTruffleNumber_InPlaceBinOp() {
        }

        @Specialization(guards={"cachedOp == op"}, limit="MAX_CACHE_SIZE")
        static Object doIntLikePrimitiveWrapper(Object left, Object right, int op, @Cached(value="op") int cachedOp, @Cached(value="createCallNode(op)") LookupAndCallInplaceNode callNode) {
            return callNode.execute(null, left, right);
        }

        static LookupAndCallInplaceNode createCallNode(int op) {
            return PyTruffleNumber_InPlaceBinOp.getInplaceArithmetic(op).create();
        }

        private static InplaceArithmetic getInplaceArithmetic(int op) {
            switch (op) {
                case 0: {
                    return InplaceArithmetic.IAdd;
                }
                case 1: {
                    return InplaceArithmetic.ISub;
                }
                case 2: {
                    return InplaceArithmetic.IMul;
                }
                case 3: {
                    return InplaceArithmetic.ITrueDiv;
                }
                case 4: {
                    return InplaceArithmetic.ILShift;
                }
                case 5: {
                    return InplaceArithmetic.IRShift;
                }
                case 6: {
                    return InplaceArithmetic.IOr;
                }
                case 7: {
                    return InplaceArithmetic.IAnd;
                }
                case 8: {
                    return InplaceArithmetic.IXor;
                }
                case 9: {
                    return InplaceArithmetic.IFloorDiv;
                }
                case 10: {
                    return InplaceArithmetic.IMod;
                }
                case 12: {
                    return InplaceArithmetic.IMatMul;
                }
            }
            throw CompilerDirectives.shouldNotReachHere((String)"invalid binary operator");
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Int}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleNumber_BinOp
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        static int MAX_CACHE_SIZE = BinaryArithmetic.values().length;

        PyTruffleNumber_BinOp() {
        }

        @Specialization(guards={"cachedOp == op"}, limit="MAX_CACHE_SIZE")
        static Object doIntLikePrimitiveWrapper(Object left, Object right, int op, @Cached(value="op") int cachedOp, @Cached(value="createCallNode(op)") BinaryOpNode callNode) {
            return callNode.executeObject(null, left, right);
        }

        static BinaryOpNode createCallNode(int op) {
            return PyTruffleNumber_BinOp.getBinaryArithmetic(op).create();
        }

        private static BinaryArithmetic getBinaryArithmetic(int op) {
            switch (op) {
                case 0: {
                    return BinaryArithmetic.Add;
                }
                case 1: {
                    return BinaryArithmetic.Sub;
                }
                case 2: {
                    return BinaryArithmetic.Mul;
                }
                case 3: {
                    return BinaryArithmetic.TrueDiv;
                }
                case 4: {
                    return BinaryArithmetic.LShift;
                }
                case 5: {
                    return BinaryArithmetic.RShift;
                }
                case 6: {
                    return BinaryArithmetic.Or;
                }
                case 7: {
                    return BinaryArithmetic.And;
                }
                case 8: {
                    return BinaryArithmetic.Xor;
                }
                case 9: {
                    return BinaryArithmetic.FloorDiv;
                }
                case 10: {
                    return BinaryArithmetic.Mod;
                }
                case 12: {
                    return BinaryArithmetic.MatMul;
                }
            }
            throw CompilerDirectives.shouldNotReachHere((String)"invalid binary operator");
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.Int}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleNumber_UnaryOp
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        static int MAX_CACHE_SIZE = UnaryArithmetic.values().length;

        PyTruffleNumber_UnaryOp() {
        }

        @Specialization(guards={"cachedOp == op"}, limit="MAX_CACHE_SIZE")
        static Object doIntLikePrimitiveWrapper(Object left, int op, @Cached(value="op") int cachedOp, @Cached(value="createCallNode(op)") UnaryOpNode callNode) {
            return callNode.executeCached(null, left);
        }

        static UnaryOpNode createCallNode(int op) {
            return (switch (op) {
                case 0 -> UnaryArithmetic.Pos;
                case 1 -> UnaryArithmetic.Neg;
                case 2 -> UnaryArithmetic.Invert;
                default -> throw CompilerDirectives.shouldNotReachHere((String)"invalid unary operator");
            }).create();
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyNumber_Float
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyNumber_Float() {
        }

        @Specialization
        static double doDoubleNativeWrapper(double object) {
            return object;
        }

        @Specialization
        static double doLongNativeWrapper(long object) {
            return object;
        }

        @Specialization
        static Object doGeneric(Object object, @Bind(value="this") Node inliningTarget, @Cached PyNumberFloatNode pyNumberFloat) {
            return pyNumberFloat.execute(inliningTarget, object);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.Int}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyNumber_ToBase
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyNumber_ToBase() {
        }

        @Specialization(guards={"base == 2"})
        static Object toBase(Object n, int base, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyNumberIndexNode indexNode, @Cached BuiltinFunctions.BinNode binNode) {
            Object i = indexNode.execute(null, inliningTarget, n);
            return binNode.execute(null, i);
        }

        @Specialization(guards={"base == 8"})
        static Object toBase(Object n, int base, @Cached BuiltinFunctions.OctNode octNode) {
            return octNode.execute(null, n);
        }

        @Specialization(guards={"base == 10"})
        static Object toBase(Object n, int base, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyNumberIndexNode indexNode, @Cached BuiltinConstructors.StrNode strNode) {
            Object i = indexNode.execute(null, inliningTarget, n);
            if (i instanceof Boolean) {
                i = (Boolean)i != false ? 1 : 0;
            }
            return strNode.executeWith(i);
        }

        @Specialization(guards={"base == 16"})
        static Object toBase(Object n, int base, @Cached PyNumber_Index indexNode, @Cached BuiltinFunctions.HexNode hexNode) {
            Object i = indexNode.execute(n);
            return hexNode.execute(null, i);
        }

        @Specialization(guards={"!checkBase(base)"})
        static Object toBase(Object n, int base, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.BASE_MUST_BE);
        }

        protected boolean checkBase(int base) {
            return base == 2 || base == 8 || base == 10 || base == 16;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyNumber_Divmod
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyNumber_Divmod() {
        }

        @Specialization
        static Object div(Object a, Object b, @Cached BuiltinFunctions.DivModNode divNode) {
            return divNode.execute(null, a, b);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyNumber_Absolute
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyNumber_Absolute() {
        }

        @Specialization
        static Object abs(Object obj, @Cached BuiltinFunctions.AbsNode absNode) {
            return absNode.execute(null, obj);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyNumber_Long
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyNumber_Long() {
        }

        @Specialization
        static int nlong(int i) {
            return i;
        }

        @Specialization
        static long nlong(long i) {
            return i;
        }

        @Fallback
        static Object nlong(Object obj, @Cached BuiltinConstructors.IntNode intNode) {
            return intNode.executeWith(null, obj, PNone.NO_VALUE);
        }
    }

    @PythonCextBuiltins.CApiBuiltins(value={@PythonCextBuiltins.CApiBuiltin(name="_PyNumber_Index", ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct), @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)})
    static abstract class PyNumber_Index
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyNumber_Index() {
        }

        @Specialization
        static Object index(Object obj, @Bind(value="this") Node inliningTarget, @Cached PyNumberIndexNode indexNode, @Cached PRaiseNode.Lazy raiseNode) {
            PyNumber_Index.checkNonNullArg(inliningTarget, obj, raiseNode);
            return indexNode.execute(null, inliningTarget, obj);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyNumber_Check
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyNumber_Check() {
        }

        @Specialization
        static Object check(Object obj, @Bind(value="this") Node inliningTarget, @Cached PyNumberCheckNode checkNode) {
            return PInt.intValue(checkNode.execute(inliningTarget, obj));
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyIndex_Check
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyIndex_Check() {
        }

        @Specialization
        static Object check(Object obj, @Bind(value="this") Node inliningTarget, @Cached PyIndexCheckNode checkNode) {
            return checkNode.execute(inliningTarget, obj) ? 1 : 0;
        }
    }
}

