/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.BuiltinConstructors;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.complex.PComplex;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextComplexBuiltins {
    static boolean isComplexSubtype(Node inliningTarget, Object obj, GetClassNode getClassNode, IsSubtypeNode isSubtypeNode) {
        return isSubtypeNode.execute(getClassNode.execute(inliningTarget, obj), (Object)PythonBuiltinClassType.PComplex);
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.Double, ArgDescriptor.Double}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyComplex_FromDoubles
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyComplex_FromDoubles() {
        }

        @Specialization
        static PComplex asDouble(double r, double i, @Cached PythonObjectFactory factory) {
            return factory.createComplex(r, i);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Double, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    @ImportStatic(value={PythonCextComplexBuiltins.class})
    static abstract class PyComplex_ImagAsDouble
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        public static final TruffleString T_IMAG = PythonUtils.tsLiteral("imag");

        PyComplex_ImagAsDouble() {
        }

        @Specialization
        static double asDouble(PComplex d) {
            return d.getImag();
        }

        @Specialization(guards={"!isPComplex(obj)", "isComplexSubtype(inliningTarget, obj, getClassNode, isSubtypeNode)"})
        static Object asDouble(Object obj, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttr, @Cached CallNode callNode, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            return callNode.execute(getAttr.execute(null, inliningTarget, obj, T_IMAG), new Object[0]);
        }

        @Specialization(guards={"!isPComplex(obj)", "!isComplexSubtype(inliningTarget, obj, getClassNode, isSubtypeNode)"})
        static Object asDouble(Object obj, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            return 0.0;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Double, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    @ImportStatic(value={PythonCextComplexBuiltins.class})
    static abstract class PyComplex_RealAsDouble
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        public static final TruffleString T_REAL = PythonUtils.tsLiteral("real");

        PyComplex_RealAsDouble() {
        }

        @Specialization
        static double asDouble(PComplex d) {
            return d.getReal();
        }

        @Specialization(guards={"!isPComplex(obj)"})
        static Object asDouble(Object obj, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile isComplexSubtypeProfile, @Cached PyObjectGetAttr getAttr, @Cached CallNode callNode, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode, @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString name = isComplexSubtypeProfile.profile(inliningTarget, PythonCextComplexBuiltins.isComplexSubtype(inliningTarget, obj, getClassNode, isSubtypeNode)) ? T_REAL : SpecialMethodNames.T___FLOAT__;
            try {
                return callNode.execute(getAttr.execute(null, inliningTarget, obj, name), new Object[0]);
            }
            catch (PException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError);
            }
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleComplex_AsCComplex
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTruffleComplex_AsCComplex() {
        }

        @Specialization
        static PTuple asComplex(PComplex c, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createTuple(new Object[]{c.getReal(), c.getImag()});
        }

        @Specialization(guards={"!isPComplex(obj)"})
        static Object asComplex(Object obj, @Cached BuiltinConstructors.ComplexNode complexNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            PComplex c = (PComplex)complexNode.execute(null, (Object)PythonBuiltinClassType.PComplex, obj, PNone.NO_VALUE);
            return factory.createTuple(new Object[]{c.getReal(), c.getImag()});
        }
    }
}

