/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextMethodBuiltins;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.str.StringBuiltins;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextModuleBuiltins {
    static boolean isModuleSubtype(Node inliningTarget, Object obj, GetClassNode getClassNode, IsSubtypeNode isSubtypeNode) {
        return isSubtypeNode.execute(null, getClassNode.execute(inliningTarget, obj), (Object)PythonBuiltinClassType.PythonModule);
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.Pointer, ArgDescriptor.PyObject, ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.Pointer, ArgDescriptor.Int, ArgDescriptor.Int, ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleModule_AddFunctionToModule
    extends PythonCextBuiltins.CApi7BuiltinNode {
        PyTruffleModule_AddFunctionToModule() {
        }

        @Specialization
        static Object moduleFunction(Object methodDefPtr, PythonModule mod, TruffleString name, Object cfunc, int flags, int wrapper, Object doc, @Bind(value="this") Node inliningTarget, @Cached ObjectBuiltins.SetattrNode setattrNode, @CachedLibrary(limit="1") DynamicObjectLibrary dylib, @Cached PythonCextMethodBuiltins.CFunctionNewExMethodNode cFunctionNewExMethodNode) {
            Object modName = dylib.getOrDefault(mod.getStorage(), (Object)SpecialAttributeNames.T___NAME__, null);
            assert (modName != null) : "module name is missing!";
            Object func = cFunctionNewExMethodNode.execute(inliningTarget, methodDefPtr, name, cfunc, flags, wrapper, mod, modName, doc);
            setattrNode.execute(null, mod, name, func);
            return 0;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.Long}, call=PythonCextBuiltins.CApiCallPath.Direct)
    @ImportStatic(value={PythonCextModuleBuiltins.class})
    static abstract class PyModule_AddIntConstant
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyModule_AddIntConstant() {
        }

        @Specialization(guards={"isModuleSubtype(inliningTarget, m, getClassNode, isSubtypeNode)"})
        static Object addObject(Object m, TruffleString k, long o, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached WriteAttributeToObjectNode writeAtrrNode) {
            writeAtrrNode.execute(m, k, (Object)o);
            return 0;
        }

        @Specialization(guards={"!isModuleSubtype(inliningTarget, m, getClassNode, isSubtypeNode)"})
        static Object pop(Object m, Object key, Object defaultValue, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_NEEDS_S_AS_FIRST_ARG, "PyModule_AddIntConstant", "module");
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    @ImportStatic(value={PythonCextModuleBuiltins.class})
    static abstract class PyModule_AddObjectRef
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyModule_AddObjectRef() {
        }

        @Specialization(guards={"isModuleSubtype(inliningTarget, m, getClassNode, isSubtypeNode)"})
        static Object addObject(Object m, TruffleString k, Object o, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached WriteAttributeToObjectNode writeAtrrNode) {
            writeAtrrNode.execute(m, k, o);
            return 0;
        }

        @Specialization(guards={"!isModuleSubtype(inliningTarget, m, getClassNode, isSubtypeNode)"})
        static Object pop(Object m, Object key, Object defaultValue, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_NEEDS_S_AS_FIRST_ARG, "PyModule_AddObjectRef", "module");
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyModule_GetNameObject
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyModule_GetNameObject() {
        }

        @Specialization
        static Object getName(Object o, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttr lookupAttrNode) {
            return lookupAttrNode.execute(null, inliningTarget, o, SpecialAttributeNames.T___NAME__);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyModuleObjectTransfer, args={ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class _PyTruffleModule_CreateInitialized_PyModule_New
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        _PyTruffleModule_CreateInitialized_PyModule_New() {
        }

        @Specialization
        Object run(TruffleString name, @Cached CallNode callNode, @Cached ObjectBuiltins.SetattrNode setattrNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached StringBuiltins.PrefixSuffixNode prefixSuffixNode, @Cached TruffleString.LastIndexOfCodePointNode lastIndexNode, @Cached TruffleString.SubstringNode substringNode) {
            TruffleString pyPackageContext;
            TruffleString newModuleName = name;
            PythonContext ctx = this.getContext();
            TruffleString truffleString = pyPackageContext = ctx.getPyPackageContext() == null ? null : ctx.getPyPackageContext();
            if (pyPackageContext != null && prefixSuffixNode.endsWith(pyPackageContext, newModuleName, 0, codePointLengthNode.execute((AbstractTruffleString)pyPackageContext, PythonUtils.TS_ENCODING))) {
                newModuleName = pyPackageContext;
                ctx.setPyPackageContext(null);
            }
            Object newModule = callNode.execute((Object)PythonBuiltinClassType.PythonModule, newModuleName);
            int nameLength = codePointLengthNode.execute((AbstractTruffleString)newModuleName, PythonUtils.TS_ENCODING);
            int idx = lastIndexNode.execute((AbstractTruffleString)newModuleName, 46, nameLength, 0, PythonUtils.TS_ENCODING);
            if (idx > -1) {
                setattrNode.execute(null, newModule, SpecialAttributeNames.T___PACKAGE__, substringNode.execute((AbstractTruffleString)newModuleName, 0, idx, PythonUtils.TS_ENCODING, false));
            }
            return newModule;
        }
    }

    @PythonCextBuiltins.CApiBuiltins(value={@PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObjectAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Direct), @PythonCextBuiltins.CApiBuiltin(name="PyModule_New", ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Direct)})
    static abstract class PyModule_NewObject
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyModule_NewObject() {
        }

        @Specialization
        static Object run(TruffleString name, @Cached CallNode callNode) {
            return callNode.execute((Object)PythonBuiltinClassType.PythonModule, name);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyModule_SetDocString
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyModule_SetDocString() {
        }

        @Specialization
        static int run(PythonModule module, Object doc, @Cached ObjectBuiltins.SetattrNode setattrNode) {
            setattrNode.execute(null, module, SpecialAttributeNames.T___DOC__, doc);
            return 0;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Py_ssize_t, args={}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class _PyTruffleModule_GetAndIncMaxModuleNumber
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        _PyTruffleModule_GetAndIncMaxModuleNumber() {
        }

        @Specialization
        long doIt() {
            return this.getCApiContext().getAndIncMaxModuleNumber();
        }
    }
}

