/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cjkcodecs;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextCapsuleBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.DBCSMap;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodec;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibytecodecModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.capsule.PyCapsule;
import com.oracle.graal.python.builtins.objects.capsule.PyCapsuleNameMatchesNode;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.CharsetMapping;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.charset.Charset;
import java.util.List;

@CoreFunctions(defineModule="_multibytecodec")
public final class MultibytecodecModuleBuiltins
extends PythonBuiltins {
    static final TruffleString PyMultibyteCodec_CAPSULE_NAME = PythonUtils.tsLiteral("multibytecodec.__map_*");
    protected static final int MBERR_TOOSMALL = -1;
    protected static final int MBERR_TOOFEW = -2;
    protected static final int MBERR_INTERNAL = -3;
    protected static final TruffleString ERROR_STRICT = StringLiterals.T_STRICT;
    protected static final TruffleString ERROR_IGNORE = StringLiterals.T_IGNORE;
    protected static final TruffleString ERROR_REPLACE = StringLiterals.T_REPLACE;
    static final int MBENC_FLUSH = 1;
    public static final int MBENC_MAX = 1;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MultibytecodecModuleBuiltinsFactory.getFactories();
    }

    protected static void registerCodec(String name, int cidx, MultibyteCodec.CodecType ct, int midx, DBCSMap.MappingType mt, DBCSMap[] maps, MultibyteCodec[] codecs, PythonModule codec, PythonObjectFactory factory) {
        TruffleString tsName = PythonUtils.toTruffleStringUncached(name);
        TruffleString normalizedEncoding = CharsetMapping.normalizeUncached(tsName);
        Charset charset = CharsetMapping.getCharsetNormalized(normalizedEncoding);
        if (charset != null) {
            if (cidx != -1) {
                codecs[cidx] = new MultibyteCodec(tsName, charset, ct);
            }
            if (midx != -1) {
                DBCSMap h = maps[midx] = new DBCSMap(name, tsName, charset, mt);
                codec.setAttribute(PythonUtils.toTruffleStringUncached(h.charsetMapName), factory.createCapsule(h, PyMultibyteCodec_CAPSULE_NAME, null));
            }
        }
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
    }

    @Builtin(name="__create_codec", minNumOfPositionalArgs=1, doc="__create_codec($module, arg, /)\n--\n\n")
    @GenerateNodeFactory
    static abstract class CreateCodecNode
    extends PythonUnaryBuiltinNode {
        CreateCodecNode() {
        }

        @Specialization
        static Object createCodec(PyCapsule arg, @Bind(value="this") Node inliningTarget, @Cached PyCapsuleNameMatchesNode nameMatchesNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            return CreateCodecNode.createCodec(inliningTarget, arg, nameMatchesNode, factory, raiseNode);
        }

        static Object createCodec(Node inliningTarget, PyCapsule arg, PyCapsuleNameMatchesNode nameMatchesNode, PythonObjectFactory factory, PRaiseNode.Lazy raiseNode) {
            if (PythonCextCapsuleBuiltins.PyCapsule_IsValid.doCapsule(arg, PyMultibyteCodec_CAPSULE_NAME, inliningTarget, nameMatchesNode) == 0) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.ARGUMENT_TYPE_INVALID);
            }
            MultibyteCodec codec = (MultibyteCodec)arg.getPointer();
            codec.codecinit();
            return factory.createMultibyteCodecObject((Object)PythonBuiltinClassType.MultibyteCodec, codec);
        }

        @Fallback
        static Object createCodec(VirtualFrame frame, Object arg, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.ARGUMENT_TYPE_INVALID);
        }
    }
}

