/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CDataBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ctypes.CDataObject;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesModuleBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.modules.ctypes.memory.PointerNodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PyCData})
public final class CDataBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CDataBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @ImportStatic(value={SpecialAttributeNames.class})
    @GenerateNodeFactory
    static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        SetStateNode() {
        }

        @Specialization
        static Object PyCData_setstate(VirtualFrame frame, CDataObject self, PTuple args, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.GetInternalObjectArrayNode getArray, @Cached(value="create(T___DICT__)") GetAttributeNode getAttributeNode, @Cached GetClassNode getClassNode, @Cached TypeNodes.GetNameNode getNameNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOtherNode, @Cached PRaiseNode.Lazy raiseNode) {
            Object[] array = getArray.execute(inliningTarget, args.getSequenceStorage());
            if (array.length < 3 || !PGuards.isDict(array[0]) || !PGuards.isInteger(array[2])) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError);
            }
            PDict dict = (PDict)array[0];
            Object data = array[1];
            int len = asSizeNode.executeExact((Frame)frame, inliningTarget, array[2]);
            if (len > self.b_size) {
                len = self.b_size;
            }
            SetStateNode.memmove(inliningTarget, self.b_ptr, data, len);
            Object mydict = getAttributeNode.executeObject(frame, self);
            if (!PGuards.isDict(mydict)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.S_DICT_MUST_BE_A_DICTIONARY_NOT_S, getNameNode.execute(inliningTarget, getClassNode.execute(inliningTarget, self)), getNameNode.execute(inliningTarget, getClassNode.execute(inliningTarget, mydict)));
            }
            PDict selfDict = (PDict)mydict;
            addAllToOtherNode.execute((Frame)frame, inliningTarget, dict.getDictStorage(), selfDict);
            return PNone.NONE;
        }

        private static void memmove(Node raisingNode, Object dest, Object src, int len) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PRaiseNode.raiseUncached(raisingNode, PythonErrorType.NotImplementedError, PythonUtils.toTruffleStringUncached("memmove is partially supported."));
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    protected static abstract class BaseReduceNode
    extends PythonUnaryBuiltinNode {
        protected BaseReduceNode() {
        }

        @Specialization
        static Object reduce(VirtualFrame frame, CDataObject self, @Bind(value="this") Node inliningTarget, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached(value="create(T___DICT__)") GetAttributeNode getAttributeNode, @CachedLibrary(limit="1") DynamicObjectLibrary dylib, @Cached PointerNodes.ReadBytesNode readBytesNode, @Cached GetClassNode getClassNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            StgDictObject stgDict = pyObjectStgDictNode.execute(inliningTarget, self);
            if ((stgDict.flags & 0x300) != 0) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.CTYPES_OBJECTS_CONTAINING_POINTERS_CANNOT_BE_PICKLED);
            }
            Object dict = getAttributeNode.executeObject(frame, self);
            Object[] t1 = new Object[]{dict, null};
            t1[1] = factory.createBytes(readBytesNode.execute(inliningTarget, self.b_ptr, self.b_size));
            Object clazz = getClassNode.execute(inliningTarget, self);
            Object[] t2 = new Object[]{clazz, factory.createTuple(t1)};
            PythonModule ctypes = PythonContext.get(inliningTarget).lookupBuiltinModule(BuiltinNames.T__CTYPES);
            Object unpickle = dylib.getOrDefault(ctypes.getStorage(), (Object)CtypesModuleBuiltins.T_UNPICKLE, null);
            if (unpickle == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(inliningTarget, PythonErrorType.NotImplementedError, PythonUtils.toTruffleStringUncached("unpickle isn't supported yet."));
            }
            Object[] t3 = new Object[]{unpickle, factory.createTuple(t2)};
            return factory.createTuple(t3);
        }
    }

    @Builtin(name="__hash__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    protected static abstract class HashNode
    extends PythonBuiltinNode {
        protected HashNode() {
        }

        @Specialization
        static long hash(CDataObject self, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.UNHASHABLE_TYPE);
        }
    }

    @Builtin(name="__ctypes_from_outparam__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    protected static abstract class CtypesFromOutparamNode
    extends PythonUnaryBuiltinNode {
        protected CtypesFromOutparamNode() {
        }

        @Specialization
        static Object PyCData_from_outparam(CDataObject self) {
            return self;
        }
    }

    @Builtin(name="_objects", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=1, isGetter=true, doc="internal objects tree (NEVER CHANGE THIS OBJECT!)")
    @GenerateNodeFactory
    protected static abstract class ObjectsNode
    extends PythonUnaryBuiltinNode {
        protected ObjectsNode() {
        }

        @Specialization
        Object getObjects(CDataObject self) {
            return self.b_objects == null ? PNone.NONE : self.b_objects;
        }
    }

    @Builtin(name="_b_needsfree_", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=1, isGetter=true, doc="whether the object owns the memory or not")
    @GenerateNodeFactory
    protected static abstract class BNeedsFreeNode
    extends PythonUnaryBuiltinNode {
        protected BNeedsFreeNode() {
        }

        @Specialization
        Object getBNeedsFree(CDataObject self) {
            return self.b_needsfree;
        }
    }

    @Builtin(name="_b_base_", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=1, isGetter=true, doc="the base object")
    @GenerateNodeFactory
    protected static abstract class BBaseNode
    extends PythonUnaryBuiltinNode {
        protected BBaseNode() {
        }

        @Specialization
        Object getBBase(CDataObject self) {
            return self.b_base == null ? PNone.NONE : self.b_base;
        }
    }
}

