/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CDataTypeSequenceBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.ctypes.CDataTypeSequenceBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesModuleBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.PyCArrayTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.PyCPointerTypeBuiltins;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.function.builtins.clinic.IndexConversionNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PyCStructType, PythonBuiltinClassType.UnionType, PythonBuiltinClassType.PyCArrayType, PythonBuiltinClassType.PyCFuncPtrType, PythonBuiltinClassType.PyCPointerType, PythonBuiltinClassType.PyCSimpleType})
public final class CDataTypeSequenceBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CDataTypeSequenceBuiltinsFactory.getFactories();
    }

    @Builtin(name="__mul__", minNumOfPositionalArgs=2, parameterNames={"itemtype", "length"})
    @ArgumentClinic(name="length", conversionClass=IndexConversionNode.class)
    @GenerateNodeFactory
    static abstract class RepeatNode
    extends PythonBinaryClinicBuiltinNode {
        RepeatNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CDataTypeSequenceBuiltinsClinicProviders.RepeatNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"length >= 0"})
        static Object PyCArrayType_from_ctype(VirtualFrame frame, Object itemtype, int length, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageSetItem setItem, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached CallNode callNode, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached TypeNodes.GetNameNode getNameNode, @Cached StringUtils.SimpleTruffleStringFormatNode simpleFormatNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            PTuple key = factory.createTuple(new Object[]{itemtype, length});
            CtypesModuleBuiltins.CtypesThreadState ctypes = CtypesModuleBuiltins.CtypesThreadState.get(PythonContext.get(inliningTarget), PythonLanguage.get(inliningTarget));
            Object result = getItem.execute((Frame)frame, inliningTarget, ctypes.cache, key);
            if (result != null) {
                return result;
            }
            if (!isTypeNode.execute(inliningTarget, itemtype)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.EXPECTED_A_TYPE_OBJECT);
            }
            TruffleString name = simpleFormatNode.format("%s_Array_%d", getNameNode.execute(inliningTarget, itemtype), length);
            PDict dict = factory.createDict(new PKeyword[]{new PKeyword(PyCArrayTypeBuiltins.T__LENGTH_, length), new PKeyword(PyCPointerTypeBuiltins.T__TYPE_, itemtype)});
            PTuple tuple = factory.createTuple(new Object[]{PythonBuiltinClassType.PyCArray});
            result = callNode.execute((Frame)frame, (Object)PythonBuiltinClassType.PyCArrayType, new Object[]{name, tuple, dict});
            HashingStorage newStorage = setItem.execute((Frame)frame, inliningTarget, ctypes.cache, key, result);
            assert (newStorage == ctypes.cache);
            return result;
        }

        @Specialization(guards={"length < 0"})
        static Object error(Object self, int length, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.ARRAY_LENGTH_MUST_BE_0_NOT_D, length);
        }
    }
}

