/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes.memory;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesNodes;
import com.oracle.graal.python.builtins.modules.ctypes.memory.Pointer;
import com.oracle.graal.python.builtins.modules.ctypes.memory.PointerNodesFactory;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeVoidPtr;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.util.CastToJavaUnsignedLongNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativeSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import sun.misc.Unsafe;

public abstract class PointerNodes {
    protected static boolean isMultipleOf8(int num) {
        return num % 8 == 0;
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class PointerArrayToBytesNode
    extends Node {
        PointerArrayToBytesNode() {
        }

        abstract Pointer.ByteArrayStorage execute(Node var1, Pointer.MemoryBlock var2, Pointer.PointerArrayStorage var3);

        @Specialization
        static Pointer.ByteArrayStorage convert(Node inliningTarget, Pointer.MemoryBlock memory, Pointer.PointerArrayStorage storage, @Cached GetPointerValueAsLongNode toNativeNode) {
            byte[] bytes = new byte[storage.pointers.length * 8];
            for (int i = 0; i < storage.pointers.length; ++i) {
                Pointer itemPointer = storage.pointers[i];
                long pointer = toNativeNode.execute(inliningTarget, itemPointer.memory, itemPointer.memory.storage, itemPointer.offset);
                PythonUtils.ARRAY_ACCESSOR.putLong(bytes, i * 8, pointer);
            }
            Pointer.ByteArrayStorage newStorage = new Pointer.ByteArrayStorage(bytes);
            memory.storage = newStorage;
            return newStorage;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PointerNodes.class})
    public static abstract class WritePointerNode
    extends Node {
        public final void execute(Node inliningTarget, Pointer ptr, Pointer value) {
            this.execute(inliningTarget, ptr.memory, ptr.memory.storage, ptr.offset, value);
        }

        protected abstract void execute(Node var1, Pointer.MemoryBlock var2, Pointer.Storage var3, int var4, Pointer var5);

        @Specialization(guards={"isMultipleOf8(offset)"})
        static void doPointerArray(Pointer.MemoryBlock memory, Pointer.PointerArrayStorage storage, int offset, Pointer value) {
            storage.pointers[offset / 8] = value;
        }

        @Specialization
        static void doZero(Pointer.MemoryBlock memory, Pointer.ZeroStorage storage, int offset, Pointer value) {
            WritePointerNode.doPointerArray(memory, storage.allocatePointers(memory), offset, value);
        }

        @Fallback
        static void doOther(Node inliningTarget, Pointer.MemoryBlock memory, Pointer.Storage storage, int offset, Pointer value, @Cached WriteLongNode writeLongNode, @Cached GetPointerValueAsLongNode toNativeNode) {
            long nativePointer = toNativeNode.execute(inliningTarget, value.memory, value.memory.storage, value.offset);
            writeLongNode.execute(inliningTarget, memory, storage, offset, nativePointer);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ReadPythonObject
    extends Node {
        public final Object execute(Node inliningTarget, Pointer ptr) {
            return this.execute(inliningTarget, ptr.memory, ptr.memory.storage, ptr.offset);
        }

        protected abstract Object execute(Node var1, Pointer.MemoryBlock var2, Pointer.Storage var3, int var4);

        @Specialization(guards={"offset == 0"})
        static Object doPythonObject(Pointer.MemoryBlock memory, Pointer.PythonObjectStorage storage, int offset) {
            return storage.pythonObject;
        }

        @Fallback
        static Object doGeneric(Node inliningTarget, Pointer.MemoryBlock memory, Pointer.Storage storage, int offset, @Cached GetPointerValueAsObjectNode getPointerValueAsObjectNode, @Cached CExtNodes.ResolvePointerNode resolveHandleNode, @Cached(inline=false) CApiTransitions.NativeToPythonNode nativeToPythonNode) {
            Object pointerObject = getPointerValueAsObjectNode.execute(inliningTarget, memory, storage, offset);
            return nativeToPythonNode.execute(resolveHandleNode.execute(inliningTarget, pointerObject));
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PointerNodes.class})
    public static abstract class ReadPointerNode
    extends Node {
        public final Pointer execute(Node inliningTarget, Pointer ptr) {
            return this.execute(inliningTarget, ptr.memory, ptr.memory.storage, ptr.offset);
        }

        protected abstract Pointer execute(Node var1, Pointer.MemoryBlock var2, Pointer.Storage var3, int var4);

        @Specialization(guards={"isMultipleOf8(offset)"})
        static Pointer doPointerArray(Pointer.MemoryBlock memory, Pointer.PointerArrayStorage storage, int offset) {
            return storage.pointers[offset / 8];
        }

        @Fallback
        static Pointer doOther(Node inliningTarget, Pointer.MemoryBlock memory, Pointer.Storage storage, int offset, @Cached ReadLongNode readLongNode) {
            return Pointer.nativeMemory(readLongNode.execute(inliningTarget, memory, storage, offset));
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class PointerFromLongNode
    extends Node {
        public abstract Pointer execute(Node var1, Object var2);

        @Specialization
        static Pointer doNativeVoidPtr(PythonNativeVoidPtr value) {
            Object pointerObject = value.getPointerObject();
            if (pointerObject instanceof Pointer) {
                Pointer pointer = (Pointer)pointerObject;
                return pointer;
            }
            return Pointer.nativeMemory(pointerObject);
        }

        @Fallback
        static Pointer doLong(Node inliningTarget, Object value, @Cached CastToJavaUnsignedLongNode cast) {
            long pointer = cast.execute(inliningTarget, value);
            return Pointer.nativeMemory(pointer);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class FreeNode
    extends Node {
        public final void execute(Node inliningTarget, Pointer pointer) {
            this.execute(inliningTarget, pointer.memory.storage, pointer.offset);
            pointer.memory.storage = Pointer.NULL.memory.storage;
        }

        abstract void execute(Node var1, Pointer.Storage var2, int var3);

        @Specialization
        @CompilerDirectives.TruffleBoundary
        void doNativeMemory(Node inliningTarget, Pointer.LongPointerStorage storage, int offset) {
            PythonContext context = PythonContext.get(inliningTarget);
            context.freeNativeMemory(storage.pointer + (long)offset);
        }

        @Specialization
        void doObjectPointer(Pointer.ObjectPointerStorage storage, int offset) {
        }

        @Fallback
        void doNothing(Pointer.Storage storage, int offset) {
        }

        public static FreeNode getUncached() {
            return PointerNodesFactory.FreeNodeGen.getUncached();
        }
    }

    @GenerateUncached
    @GenerateInline
    public static abstract class GetPointerValueAsLongNode
    extends AbstractGetPointerValueNode {
        public final long execute(Node inliningTarget, Pointer ptr) {
            return this.execute(inliningTarget, ptr.memory, ptr.memory.storage, ptr.offset);
        }

        protected abstract long execute(Node var1, Pointer.MemoryBlock var2, Pointer.Storage var3, int var4);

        @Specialization
        static long doObjectPointer(Node inliningTarget, Pointer.MemoryBlock memory, Pointer.ObjectPointerStorage storage, int offset) {
            throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.NotImplementedError, ErrorMessages.CANNOT_CONVERT_OBJECT_POINTER_TO_NATIVE);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetPointerValueAsObjectNode
    extends AbstractGetPointerValueNode {
        public final Object execute(Node inliningTarget, Pointer ptr) {
            return this.execute(inliningTarget, ptr.memory, ptr.memory.storage, ptr.offset);
        }

        protected abstract Object execute(Node var1, Pointer.MemoryBlock var2, Pointer.Storage var3, int var4);

        @Specialization
        static Object doObjectPointer(Node inliningTarget, Pointer.MemoryBlock memory, Pointer.ObjectPointerStorage storage, int offset) {
            if (offset != 0) {
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.NotImplementedError, ErrorMessages.CANNOT_APPLY_OFFSET_TO_AN_OBJECT_POINTER);
            }
            return storage.pointer;
        }
    }

    @GenerateCached(value=false)
    public static abstract class AbstractGetPointerValueNode
    extends Node {
        @Specialization
        static long doNull(Pointer.MemoryBlock memory, Pointer.NullStorage storage, int offset) {
            return offset;
        }

        @Specialization
        static long doNativePointer(Pointer.MemoryBlock memory, Pointer.LongPointerStorage storage, int offset) {
            return storage.pointer + (long)offset;
        }

        @Specialization
        static long doBytes(Node inliningTarget, Pointer.MemoryBlock memory, Pointer.ByteArrayStorage storage, int offset) {
            int len = storage.bytes.length;
            PythonContext context = PythonContext.get(inliningTarget);
            long pointer = context.allocateNativeMemory(len);
            context.copyNativeMemory(pointer, storage.bytes, 0, len);
            memory.storage = new Pointer.LongPointerStorage(pointer);
            return pointer + (long)offset;
        }

        @Specialization
        static long doZero(Node inliningTarget, Pointer.MemoryBlock memory, Pointer.ZeroStorage storage, int offset) {
            int len = storage.size;
            PythonContext context = PythonContext.get(inliningTarget);
            long pointer = context.allocateNativeMemory(len);
            context.setNativeMemory(pointer, len, (byte)0);
            memory.storage = new Pointer.LongPointerStorage(pointer);
            return pointer + (long)offset;
        }

        @Specialization
        static long doPointerArray(Node inliningTarget, Pointer.MemoryBlock memory, Pointer.PointerArrayStorage storage, int offset, @Cached(inline=false) GetPointerValueAsLongNode toNativeNode) {
            PythonContext context = PythonContext.get(inliningTarget);
            Unsafe unsafe = context.getUnsafe();
            long pointer = context.allocateNativeMemory((long)storage.pointers.length * 8L);
            for (int i = 0; i < storage.pointers.length; ++i) {
                Pointer itemPointer = storage.pointers[i];
                long subpointer = toNativeNode.execute(inliningTarget, itemPointer.memory, itemPointer.memory.storage, itemPointer.offset);
                unsafe.putLong(pointer + (long)i * 8L, subpointer);
            }
            memory.storage = new Pointer.LongPointerStorage(pointer);
            return pointer + (long)offset;
        }

        @Specialization
        static long doMemoryView(Node inliningTarget, Pointer.MemoryBlock memory, Pointer.MemoryViewStorage storage, int offset, @CachedLibrary(limit="1") InteropLibrary ilib, @Cached(inline=false) SequenceStorageNodes.StorageToNativeNode storageToNativeNode) {
            PMemoryView mv = storage.memoryView;
            Object ptr = null;
            if (mv.getBufferPointer() != null) {
                ptr = mv.getBufferPointer();
            } else {
                Object object = mv.getBuffer();
                if (object instanceof PBytesLike) {
                    PBytesLike bytes = (PBytesLike)object;
                    SequenceStorage sequenceStorage = bytes.getSequenceStorage();
                    if (sequenceStorage instanceof NativeSequenceStorage) {
                        NativeSequenceStorage nativeSequenceStorage = (NativeSequenceStorage)sequenceStorage;
                        ptr = nativeSequenceStorage.getPtr();
                    }
                    if ((sequenceStorage = bytes.getSequenceStorage()) instanceof ByteSequenceStorage) {
                        ByteSequenceStorage byteSequenceStorage = (ByteSequenceStorage)sequenceStorage;
                        NativeSequenceStorage nativeStorage = storageToNativeNode.execute(byteSequenceStorage.getInternalByteArray(), byteSequenceStorage.length());
                        bytes.setSequenceStorage(nativeStorage);
                        ptr = nativeStorage.getPtr();
                    }
                }
            }
            if (ptr != null && ilib.isPointer(ptr)) {
                try {
                    long nativePointer = ilib.asPointer(ptr);
                    memory.storage = new Pointer.LongPointerStorage(nativePointer);
                    return nativePointer + (long)offset;
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.NotImplementedError, ErrorMessages.MEMORYVIEW_CANNOT_BE_CONVERTED_TO_NATIVE_MEMORY);
        }

        @Specialization
        static long doPythonObject(Node inliningTarget, Pointer.MemoryBlock memory, Pointer.PythonObjectStorage storage, int offset, @Cached(inline=false) CApiTransitions.PythonToNativeNode toNativeNode, @CachedLibrary(limit="1") InteropLibrary lib) {
            long nativePointer;
            Object nativeObject = toNativeNode.execute(storage.pythonObject);
            if (nativeObject instanceof Long) {
                Long longPointer = (Long)nativeObject;
                nativePointer = longPointer;
            } else {
                if (!lib.isPointer(nativeObject)) {
                    lib.toNative(nativeObject);
                    if (!lib.isPointer(nativeObject)) {
                        throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.NotImplementedError, ErrorMessages.CANNOT_CONVERT_OBJECT_POINTER_TO_NATIVE);
                    }
                }
                try {
                    nativePointer = lib.asPointer(nativeObject);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            memory.storage = new Pointer.LongPointerStorage(nativePointer);
            return nativePointer + (long)offset;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class WCsLenNode
    extends Node {
        public final int execute(Node inliningTarget, Pointer ptr) {
            return this.execute(inliningTarget, ptr, -1);
        }

        public final int execute(Node inliningTarget, Pointer ptr, int max) {
            return this.execute(inliningTarget, ptr.memory, ptr.memory.storage, ptr.offset, max);
        }

        protected abstract int execute(Node var1, Pointer.MemoryBlock var2, Pointer.Storage var3, int var4, int var5);

        @Specialization
        static int doOther(Node inliningTarget, Pointer.MemoryBlock memory, Pointer.Storage storage, int offset, int max, @Cached ReadByteNode readByteNode) {
            int maxlen = Integer.MAX_VALUE;
            if (max >= 0) {
                maxlen = offset + max * CtypesNodes.WCHAR_T_SIZE;
            }
            block0: for (int i = offset; i < maxlen; i += CtypesNodes.WCHAR_T_SIZE) {
                for (int j = 0; j < CtypesNodes.WCHAR_T_SIZE; ++j) {
                    if (readByteNode.execute(inliningTarget, memory, storage, i + j) != 0) continue block0;
                }
                return i / CtypesNodes.WCHAR_T_SIZE - offset;
            }
            if (max >= 0) {
                return max;
            }
            throw CompilerDirectives.shouldNotReachHere((String)"NULL terminator not found");
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class StrLenNode
    extends Node {
        public final int execute(Node inliningTarget, Pointer ptr) {
            return this.execute(inliningTarget, ptr, -1);
        }

        public final int execute(Node inliningTarget, Pointer ptr, int max) {
            return this.execute(inliningTarget, ptr.memory, ptr.memory.storage, ptr.offset, max);
        }

        protected abstract int execute(Node var1, Pointer.MemoryBlock var2, Pointer.Storage var3, int var4, int var5);

        @Specialization
        static int doOther(Node inliningTarget, Pointer.MemoryBlock memory, Pointer.Storage storage, int offset, int max, @Cached ReadByteNode readByteNode) {
            int maxlen = Integer.MAX_VALUE;
            if (max >= 0) {
                maxlen = offset + max;
            }
            for (int i = offset; i < maxlen; ++i) {
                if (readByteNode.execute(inliningTarget, memory, storage, i) != 0) continue;
                return i - offset;
            }
            if (max >= 0) {
                return max;
            }
            throw CompilerDirectives.shouldNotReachHere((String)"NULL terminator not found");
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PointerNodes.class})
    public static abstract class MemcpyNode
    extends Node {
        public final void execute(Node inliningTarget, Pointer dst, Pointer src, int size) {
            this.execute(inliningTarget, dst.memory, dst.memory.storage, dst.offset, src.memory, src.memory.storage, src.offset, size);
        }

        protected abstract void execute(Node var1, Pointer.MemoryBlock var2, Pointer.Storage var3, int var4, Pointer.MemoryBlock var5, Pointer.Storage var6, int var7, int var8);

        @Specialization
        static void doBytesBytes(Pointer.MemoryBlock dstMemory, Pointer.ByteArrayStorage dst, int dstOffset, Pointer.MemoryBlock srcMemory, Pointer.ByteArrayStorage src, int srcOffset, int size) {
            PythonUtils.arraycopy(src.bytes, srcOffset, dst.bytes, dstOffset, size);
        }

        @Specialization(guards={"isMultipleOf8(size)", "isMultipleOf8(dstOffset)", "isMultipleOf8(srcOffset)"})
        static void doPointerPointer(Pointer.MemoryBlock dstMemory, Pointer.PointerArrayStorage dst, int dstOffset, Pointer.MemoryBlock srcMemory, Pointer.PointerArrayStorage src, int srcOffset, int size) {
            for (int i = 0; i < size; i += 8) {
                dst.pointers[(dstOffset + i) / 8] = src.pointers[(srcOffset + i) / 8];
            }
        }

        @Specialization(guards={"isMultipleOf8(size)", "isMultipleOf8(dstOffset)", "isMultipleOf8(srcOffset)"})
        static void doZeroPointer(Pointer.MemoryBlock dstMemory, Pointer.ZeroStorage dst, int dstOffset, Pointer.MemoryBlock srcMemory, Pointer.PointerArrayStorage src, int srcOffset, int size) {
            MemcpyNode.doPointerPointer(dstMemory, dst.allocatePointers(dstMemory), dstOffset, srcMemory, src, srcOffset, size);
        }

        @Fallback
        static void doOther(Node inliningTarget, Pointer.MemoryBlock dstMemory, Pointer.Storage dst, int dstOffset, Pointer.MemoryBlock srcMemory, Pointer.Storage src, int srcOffset, int size, @Cached ReadBytesNode readBytesNode, @Cached WriteBytesNode writeBytesNode) {
            byte[] tmp = new byte[size];
            readBytesNode.execute(inliningTarget, tmp, 0, srcMemory, src, srcOffset, size);
            writeBytesNode.execute(inliningTarget, dstMemory, dst, dstOffset, tmp, 0, size);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PointerNodes.class})
    public static abstract class WriteLongNode
    extends Node {
        public final void execute(Node inliningTarget, Pointer dst, long value) {
            this.execute(inliningTarget, dst.memory, dst.memory.storage, dst.offset, value);
        }

        protected abstract void execute(Node var1, Pointer.MemoryBlock var2, Pointer.Storage var3, int var4, long var5);

        @Specialization
        static void doBytes(Pointer.MemoryBlock dstMemory, Pointer.ByteArrayStorage dst, int dstOffset, long value) {
            PythonUtils.ARRAY_ACCESSOR.putLong(dst.bytes, dstOffset, value);
        }

        @Specialization
        static void doZero(Pointer.MemoryBlock dstMemory, Pointer.ZeroStorage dst, int dstOffset, long value) {
            if (value != 0L) {
                WriteLongNode.doBytes(dstMemory, dst.allocateBytes(dstMemory), dstOffset, value);
            }
        }

        @Specialization(guards={"value == 0", "isMultipleOf8(dstOffset)"})
        static void doPointerArray(Pointer.MemoryBlock dstMemory, Pointer.PointerArrayStorage dst, int dstOffset, long value) {
            dst.pointers[dstOffset / 8] = Pointer.NULL;
        }

        @Specialization
        static void doNativeMemory(Node inliningTarget, Pointer.MemoryBlock dstMemory, Pointer.LongPointerStorage dst, int dstOffset, long value) {
            Unsafe unsafe = PythonContext.get(inliningTarget).getUnsafe();
            unsafe.putLong(dst.pointer + (long)dstOffset, value);
        }

        @Fallback
        static void doOther(Node inliningTarget, Pointer.MemoryBlock dstMemory, Pointer.Storage dst, int dstOffset, long value, @Cached WriteBytesNode writeBytesNode) {
            byte[] tmp = new byte[8];
            PythonUtils.ARRAY_ACCESSOR.putLong(tmp, 0, value);
            writeBytesNode.execute(inliningTarget, dstMemory, dst, dstOffset, tmp, 0, tmp.length);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class WriteIntNode
    extends Node {
        public final void execute(Node inliningTarget, Pointer dst, int value) {
            this.execute(inliningTarget, dst.memory, dst.memory.storage, dst.offset, value);
        }

        protected abstract void execute(Node var1, Pointer.MemoryBlock var2, Pointer.Storage var3, int var4, int var5);

        @Specialization
        static void doBytes(Pointer.MemoryBlock dstMemory, Pointer.ByteArrayStorage dst, int dstOffset, int value) {
            PythonUtils.ARRAY_ACCESSOR.putInt(dst.bytes, dstOffset, value);
        }

        @Specialization
        static void doZero(Pointer.MemoryBlock dstMemory, Pointer.ZeroStorage dst, int dstOffset, int value) {
            if (value != 0) {
                WriteIntNode.doBytes(dstMemory, dst.allocateBytes(dstMemory), dstOffset, value);
            }
        }

        @Specialization
        static void doNativeMemory(Node inliningTarget, Pointer.MemoryBlock dstMemory, Pointer.LongPointerStorage dst, int dstOffset, int value) {
            Unsafe unsafe = PythonContext.get(inliningTarget).getUnsafe();
            unsafe.putInt(dst.pointer + (long)dstOffset, value);
        }

        @Fallback
        static void doOther(Node inliningTarget, Pointer.MemoryBlock dstMemory, Pointer.Storage dst, int dstOffset, int value, @Cached WriteBytesNode writeBytesNode) {
            byte[] tmp = new byte[4];
            PythonUtils.ARRAY_ACCESSOR.putInt(tmp, 0, value);
            writeBytesNode.execute(inliningTarget, dstMemory, dst, dstOffset, tmp, 0, tmp.length);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class WriteShortNode
    extends Node {
        public final void execute(Node inliningTarget, Pointer dst, short value) {
            this.execute(inliningTarget, dst.memory, dst.memory.storage, dst.offset, value);
        }

        protected abstract void execute(Node var1, Pointer.MemoryBlock var2, Pointer.Storage var3, int var4, short var5);

        @Specialization
        static void doBytes(Pointer.MemoryBlock dstMemory, Pointer.ByteArrayStorage dst, int dstOffset, short value) {
            PythonUtils.ARRAY_ACCESSOR.putShort(dst.bytes, dstOffset, value);
        }

        @Specialization
        static void doZero(Pointer.MemoryBlock dstMemory, Pointer.ZeroStorage dst, int dstOffset, short value) {
            if (value != 0) {
                WriteShortNode.doBytes(dstMemory, dst.allocateBytes(dstMemory), dstOffset, value);
            }
        }

        @Specialization
        static void doNativeMemory(Node inliningTarget, Pointer.MemoryBlock dstMemory, Pointer.LongPointerStorage dst, int dstOffset, short value) {
            Unsafe unsafe = PythonContext.get(inliningTarget).getUnsafe();
            unsafe.putShort(dst.pointer + (long)dstOffset, value);
        }

        @Fallback
        static void doOther(Node inliningTarget, Pointer.MemoryBlock dstMemory, Pointer.Storage dst, int dstOffset, short value, @Cached WriteBytesNode writeBytesNode) {
            byte[] tmp = new byte[2];
            PythonUtils.ARRAY_ACCESSOR.putShort(tmp, 0, value);
            writeBytesNode.execute(inliningTarget, dstMemory, dst, dstOffset, tmp, 0, tmp.length);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class WriteByteNode
    extends Node {
        public final void execute(Node inliningTarget, Pointer dst, byte value) {
            this.execute(inliningTarget, dst.memory, dst.memory.storage, dst.offset, value);
        }

        protected abstract void execute(Node var1, Pointer.MemoryBlock var2, Pointer.Storage var3, int var4, byte var5);

        @Specialization
        static void doBytes(Pointer.MemoryBlock dstMemory, Pointer.ByteArrayStorage dst, int dstOffset, byte value) {
            dst.bytes[dstOffset] = value;
        }

        @Specialization
        static void doZero(Pointer.MemoryBlock dstMemory, Pointer.ZeroStorage dst, int dstOffset, byte value) {
            if (value != 0) {
                WriteByteNode.doBytes(dstMemory, dst.allocateBytes(dstMemory), dstOffset, value);
            }
        }

        @Specialization
        static void doNativeMemory(Node inliningTarget, Pointer.MemoryBlock dstMemory, Pointer.LongPointerStorage dst, int dstOffset, byte value) {
            Unsafe unsafe = PythonContext.get(inliningTarget).getUnsafe();
            unsafe.putByte(dst.pointer + (long)dstOffset, value);
        }

        @Fallback
        static void doOther(Node inliningTarget, Pointer.MemoryBlock dstMemory, Pointer.Storage dst, int dstOffset, byte value, @Cached WriteBytesNode writeBytesNode) {
            writeBytesNode.execute(inliningTarget, dstMemory, dst, dstOffset, new byte[]{value}, 0, 1);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class WriteBytesNode
    extends Node {
        public final void execute(Node inliningTarget, Pointer dst, byte[] src) {
            this.execute(inliningTarget, dst, src, 0, src.length);
        }

        public final void execute(Node inliningTarget, Pointer dst, long value) {
            byte[] tmp = new byte[8];
            PythonUtils.ARRAY_ACCESSOR.putLong(tmp, 0, value);
            this.execute(inliningTarget, dst, tmp);
        }

        public final void execute(Node inliningTarget, Pointer dst, byte[] src, int srcOffset, int size) {
            this.execute(inliningTarget, dst.memory, dst.memory.storage, dst.offset, src, srcOffset, size);
        }

        protected abstract void execute(Node var1, Pointer.MemoryBlock var2, Pointer.Storage var3, int var4, byte[] var5, int var6, int var7);

        @Specialization
        static void doBytes(Pointer.MemoryBlock dstMemory, Pointer.ByteArrayStorage dst, int dstOffset, byte[] src, int srcOffset, int size) {
            PythonUtils.arraycopy(src, srcOffset, dst.bytes, dstOffset, size);
        }

        @Specialization
        static void doZero(Pointer.MemoryBlock dstMemory, Pointer.ZeroStorage dst, int dstOffset, byte[] src, int srcOffset, int size) {
            WriteBytesNode.doBytes(dstMemory, dst.allocateBytes(dstMemory), dstOffset, src, srcOffset, size);
        }

        @Specialization(limit="1")
        static void doMemoryView(Pointer.MemoryBlock dstMemory, Pointer.MemoryViewStorage dst, int dstOffset, byte[] src, int srcOffset, int size, @CachedLibrary(value="dst.memoryView") PythonBufferAccessLibrary bufferLib) {
            bufferLib.writeFromByteArray(dst.memoryView, dstOffset, src, srcOffset, size);
        }

        @Specialization
        static void doNativeMemory(Node inliningTarget, Pointer.MemoryBlock dstMemory, Pointer.LongPointerStorage dst, int dstOffset, byte[] src, int srcOffset, int size) {
            PythonContext context = PythonContext.get(inliningTarget);
            context.copyNativeMemory(dst.pointer + (long)dstOffset, src, srcOffset, size);
        }

        @Specialization
        static void doPointerArray(Node inliningTarget, Pointer.MemoryBlock dstMemory, Pointer.PointerArrayStorage dst, int dstOffset, byte[] src, int srcOffset, int size, @Cached PointerArrayToBytesNode toBytesNode) {
            Pointer.ByteArrayStorage newStorage = toBytesNode.execute(inliningTarget, dstMemory, dst);
            WriteBytesNode.doBytes(dstMemory, newStorage, dstOffset, src, srcOffset, size);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ReadLongNode
    extends Node {
        public final long execute(Node inliningTarget, Pointer ptr) {
            return this.execute(inliningTarget, ptr.memory, ptr.memory.storage, ptr.offset);
        }

        protected abstract long execute(Node var1, Pointer.MemoryBlock var2, Pointer.Storage var3, int var4);

        @Specialization
        static long doBytes(Pointer.MemoryBlock memory, Pointer.ByteArrayStorage storage, int offset) {
            return PythonUtils.ARRAY_ACCESSOR.getLong(storage.bytes, offset);
        }

        @Specialization
        static long doZero(Pointer.MemoryBlock memory, Pointer.ZeroStorage storage, int offset) {
            storage.boundsCheck(offset, 8);
            return 0L;
        }

        @Specialization
        static long doNativeMemory(Node inliningTarget, Pointer.MemoryBlock memory, Pointer.LongPointerStorage storage, int offset) {
            Unsafe unsafe = PythonContext.get(inliningTarget).getUnsafe();
            return unsafe.getLong(storage.pointer + (long)offset);
        }

        @Fallback
        static long doOther(Node inliningTarget, Pointer.MemoryBlock memory, Pointer.Storage storage, int offset, @Cached ReadBytesNode read) {
            byte[] tmp = new byte[8];
            read.execute(inliningTarget, tmp, 0, memory, storage, offset, tmp.length);
            return PythonUtils.ARRAY_ACCESSOR.getLong(tmp, 0);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ReadIntNode
    extends Node {
        public final int execute(Node inliningTarget, Pointer ptr) {
            return this.execute(inliningTarget, ptr.memory, ptr.memory.storage, ptr.offset);
        }

        protected abstract int execute(Node var1, Pointer.MemoryBlock var2, Pointer.Storage var3, int var4);

        @Specialization
        static int doBytes(Pointer.MemoryBlock memory, Pointer.ByteArrayStorage storage, int offset) {
            return PythonUtils.ARRAY_ACCESSOR.getInt(storage.bytes, offset);
        }

        @Specialization
        static int doZero(Pointer.MemoryBlock memory, Pointer.ZeroStorage storage, int offset) {
            storage.boundsCheck(offset, 4);
            return 0;
        }

        @Specialization
        static int doNativeMemory(Node inliningTarget, Pointer.MemoryBlock memory, Pointer.LongPointerStorage storage, int offset) {
            Unsafe unsafe = PythonContext.get(inliningTarget).getUnsafe();
            return unsafe.getInt(storage.pointer + (long)offset);
        }

        @Fallback
        static int doOther(Node inliningTarget, Pointer.MemoryBlock memory, Pointer.Storage storage, int offset, @Cached ReadBytesNode read) {
            byte[] tmp = new byte[4];
            read.execute(inliningTarget, tmp, 0, memory, storage, offset, tmp.length);
            return PythonUtils.ARRAY_ACCESSOR.getInt(tmp, 0);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ReadShortNode
    extends Node {
        public final short execute(Node inliningTarget, Pointer ptr) {
            return this.execute(inliningTarget, ptr.memory, ptr.memory.storage, ptr.offset);
        }

        protected abstract short execute(Node var1, Pointer.MemoryBlock var2, Pointer.Storage var3, int var4);

        @Specialization
        static short doBytes(Pointer.MemoryBlock memory, Pointer.ByteArrayStorage storage, int offset) {
            return PythonUtils.ARRAY_ACCESSOR.getShort(storage.bytes, offset);
        }

        @Specialization
        static short doZero(Pointer.MemoryBlock memory, Pointer.ZeroStorage storage, int offset) {
            storage.boundsCheck(offset, 2);
            return 0;
        }

        @Specialization
        static short doNativeMemory(Node inliningTarget, Pointer.MemoryBlock memory, Pointer.LongPointerStorage storage, int offset) {
            Unsafe unsafe = PythonContext.get(inliningTarget).getUnsafe();
            return unsafe.getShort(storage.pointer + (long)offset);
        }

        @Fallback
        static short doOther(Node inliningTarget, Pointer.MemoryBlock memory, Pointer.Storage storage, int offset, @Cached ReadBytesNode read) {
            byte[] tmp = new byte[2];
            read.execute(inliningTarget, tmp, 0, memory, storage, offset, tmp.length);
            return PythonUtils.ARRAY_ACCESSOR.getShort(tmp, 0);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ReadByteNode
    extends Node {
        public final byte execute(Node inliningTarget, Pointer ptr) {
            return this.execute(inliningTarget, ptr.memory, ptr.memory.storage, ptr.offset);
        }

        protected abstract byte execute(Node var1, Pointer.MemoryBlock var2, Pointer.Storage var3, int var4);

        @Specialization
        static byte doBytes(Pointer.MemoryBlock memory, Pointer.ByteArrayStorage storage, int offset) {
            return storage.bytes[offset];
        }

        @Specialization
        static byte doZero(Pointer.MemoryBlock memory, Pointer.ZeroStorage storage, int offset) {
            storage.boundsCheck(offset, 1);
            return 0;
        }

        @Specialization(limit="1")
        static byte doMemoryView(Pointer.MemoryBlock memory, Pointer.MemoryViewStorage storage, int offset, @CachedLibrary(value="storage.memoryView") PythonBufferAccessLibrary bufferLib) {
            return bufferLib.readByte(storage.memoryView, offset);
        }

        @Specialization
        static byte doNativeMemory(Node inliningTarget, Pointer.MemoryBlock memory, Pointer.LongPointerStorage storage, int offset) {
            Unsafe unsafe = PythonContext.get(inliningTarget).getUnsafe();
            return unsafe.getByte(storage.pointer + (long)offset);
        }

        @Fallback
        static byte doOther(Node inliningTarget, Pointer.MemoryBlock memory, Pointer.Storage storage, int offset, @Cached ReadBytesNode read) {
            byte[] tmp = new byte[1];
            read.execute(inliningTarget, tmp, 0, memory, storage, offset, tmp.length);
            return PythonUtils.ARRAY_ACCESSOR.getByte(tmp, 0);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ReadBytesNode
    extends Node {
        public final void execute(Node inliningTarget, byte[] dst, int dstOffset, Pointer src, int size) {
            this.execute(inliningTarget, dst, dstOffset, src.memory, src.memory.storage, src.offset, size);
        }

        public final byte[] execute(Node inliningTarget, Pointer src, int size) {
            byte[] result = new byte[size];
            this.execute(inliningTarget, result, 0, src, size);
            return result;
        }

        protected abstract void execute(Node var1, byte[] var2, int var3, Pointer.MemoryBlock var4, Pointer.Storage var5, int var6, int var7);

        @Specialization
        static void doZero(byte[] dst, int dstOffset, Pointer.MemoryBlock srcMemory, Pointer.ZeroStorage src, int srcOffset, int size) {
            src.boundsCheck(srcOffset, size);
            PythonUtils.fill(dst, dstOffset, dstOffset + size, (byte)0);
        }

        @Specialization
        static void doBytes(byte[] dst, int dstOffset, Pointer.MemoryBlock srcMemory, Pointer.ByteArrayStorage src, int srcOffset, int size) {
            PythonUtils.arraycopy(src.bytes, srcOffset, dst, dstOffset, size);
        }

        @Specialization(limit="1")
        static void doMemoryView(byte[] dst, int dstOffset, Pointer.MemoryBlock srcMemory, Pointer.MemoryViewStorage src, int srcOffset, int size, @CachedLibrary(value="src.memoryView") PythonBufferAccessLibrary bufferLib) {
            bufferLib.readIntoByteArray(src.memoryView, srcOffset, dst, dstOffset, size);
        }

        @Specialization
        static void doNull(byte[] dst, int dstOffset, Pointer.MemoryBlock srcMemory, Pointer.NullStorage src, int srcOffset, int size) {
            if (size != 0) {
                throw CompilerDirectives.shouldNotReachHere((String)"Reading from NULL pointer");
            }
        }

        @Specialization
        static void doPointerArray(Node inliningTarget, byte[] dst, int dstOffset, Pointer.MemoryBlock srcMemory, Pointer.PointerArrayStorage src, int srcOffset, int size, @Cached PointerArrayToBytesNode toBytesNode) {
            Pointer.ByteArrayStorage newStorage = toBytesNode.execute(inliningTarget, srcMemory, src);
            ReadBytesNode.doBytes(dst, dstOffset, srcMemory, newStorage, srcOffset, size);
        }

        @Specialization
        static void doNativeMemory(Node inliningTarget, byte[] dst, int dstOffset, Pointer.MemoryBlock srcMemory, Pointer.LongPointerStorage src, int srcOffset, int size) {
            PythonContext context = PythonContext.get(inliningTarget);
            context.copyNativeMemory(dst, dstOffset, src.pointer + (long)srcOffset, size);
        }
    }
}

