/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.annotations.ClinicConverterFactory;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.io.BufferedRandomBuiltins;
import com.oracle.graal.python.builtins.modules.io.BufferedReaderBuiltins;
import com.oracle.graal.python.builtins.modules.io.BufferedWriterBuiltins;
import com.oracle.graal.python.builtins.modules.io.IONodesFactory;
import com.oracle.graal.python.builtins.modules.io.PBuffered;
import com.oracle.graal.python.builtins.modules.io.PFileIO;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringIterator;

public class IONodes {
    public static final String J_DETACH = "detach";
    public static final TruffleString T_DETACH = PythonUtils.tsLiteral("detach");
    public static final String J_FLUSH = "flush";
    public static final TruffleString T_FLUSH = PythonUtils.tsLiteral("flush");
    public static final String J_CLOSE = "close";
    public static final TruffleString T_CLOSE = PythonUtils.tsLiteral("close");
    public static final String J_SEEKABLE = "seekable";
    public static final TruffleString T_SEEKABLE = PythonUtils.tsLiteral("seekable");
    public static final String J_READABLE = "readable";
    public static final TruffleString T_READABLE = StringLiterals.T_READABLE;
    public static final String J_WRITABLE = "writable";
    public static final TruffleString T_WRITABLE = StringLiterals.T_WRITABLE;
    public static final String J_FILENO = "fileno";
    public static final TruffleString T_FILENO = PythonUtils.tsLiteral("fileno");
    public static final String J_ISATTY = "isatty";
    public static final TruffleString T_ISATTY = PythonUtils.tsLiteral("isatty");
    public static final String J_READ = "read";
    public static final TruffleString T_READ = PythonUtils.tsLiteral("read");
    public static final String J_PEEK = "peek";
    public static final TruffleString T_PEEK = PythonUtils.tsLiteral("peek");
    public static final String J_READ1 = "read1";
    public static final TruffleString T_READ1 = PythonUtils.tsLiteral("read1");
    public static final String J_READINTO = "readinto";
    public static final TruffleString T_READINTO = PythonUtils.tsLiteral("readinto");
    public static final String J_READINTO1 = "readinto1";
    public static final TruffleString T_READINTO1 = PythonUtils.tsLiteral("readinto1");
    public static final String J_READLINE = "readline";
    public static final TruffleString T_READLINE = BuiltinNames.T_READLINE;
    public static final String J_READLINES = "readlines";
    public static final String J_WRITELINES = "writelines";
    public static final String J_WRITE = "write";
    public static final TruffleString T_WRITE = PythonUtils.tsLiteral("write");
    public static final String J_SEEK = "seek";
    public static final TruffleString T_SEEK = PythonUtils.tsLiteral("seek");
    public static final String J_TELL = "tell";
    public static final TruffleString T_TELL = PythonUtils.tsLiteral("tell");
    public static final String J_TRUNCATE = "truncate";
    public static final TruffleString T_TRUNCATE = PythonUtils.tsLiteral("truncate");
    public static final String J_RAW = "raw";
    public static final String J_CLOSED = "closed";
    public static final TruffleString T_CLOSED = PythonUtils.tsLiteral("closed");
    public static final String J_NAME = "name";
    public static final TruffleString T_NAME = PythonUtils.tsLiteral("name");
    public static final String J_MODE = "mode";
    public static final TruffleString T_MODE = PythonUtils.tsLiteral("mode");
    public static final String J_GETBUFFER = "getbuffer";
    public static final String J_GETVALUE = "getvalue";
    public static final String J_READALL = "readall";
    public static final TruffleString T_READALL = PythonUtils.tsLiteral("readall");
    public static final String J_CLOSEFD = "closefd";
    public static final String J_DECODE = "decode";
    public static final TruffleString T_DECODE = PythonUtils.tsLiteral("decode");
    public static final String J_ENCODE = "encode";
    public static final TruffleString T_ENCODE = PythonUtils.tsLiteral("encode");
    public static final String J_GETSTATE = "getstate";
    public static final TruffleString T_GETSTATE = PythonUtils.tsLiteral("getstate");
    public static final String J_SETSTATE = "setstate";
    public static final TruffleString T_SETSTATE = PythonUtils.tsLiteral("setstate");
    public static final String J_RESET = "reset";
    public static final TruffleString T_RESET = PythonUtils.tsLiteral("reset");
    public static final String J_NEWLINES = "newlines";
    public static final TruffleString T_NEWLINES = PythonUtils.tsLiteral("newlines");
    public static final String J_LINE_BUFFERING = "line_buffering";
    public static final String J_ENCODING = "encoding";
    public static final TruffleString T_ENCODING = PythonUtils.tsLiteral("encoding");
    public static final String J_BUFFER = "buffer";
    public static final TruffleString T_BUFFER = PythonUtils.tsLiteral("buffer");
    public static final String J_ERRORS = "errors";
    public static final String J_RECONFIGURE = "reconfigure";
    public static final String J_WRITE_THROUGH = "write_through";
    public static final String J__DEALLOC_WARN = "_dealloc_warn";
    public static final TruffleString T__DEALLOC_WARN = PythonUtils.tsLiteral("_dealloc_warn");
    public static final String J__FINALIZING = "_finalizing";
    public static final String J__BLKSIZE = "_blksize";
    public static final String J___IOBASE_CLOSED = "__IOBase_closed";
    public static final TruffleString T___IOBASE_CLOSED = PythonUtils.tsLiteral("__IOBase_closed");
    public static final String J__CHECKCLOSED = "_checkClosed";
    public static final String J__CHECKSEEKABLE = "_checkSeekable";
    public static final String J__CHECKREADABLE = "_checkReadable";
    public static final String J__CHECKWRITABLE = "_checkWritable";
    public static final String J__CHUNK_SIZE = "_CHUNK_SIZE";
    public static final TruffleString T__CHUNK_SIZE = PythonUtils.tsLiteral("_CHUNK_SIZE");
    public static final TruffleString T_R = PythonUtils.tsLiteral("r");
    public static final TruffleString T_W = PythonUtils.tsLiteral("w");
    public static final TruffleString T_RB = PythonUtils.tsLiteral("rb");

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ToTruffleStringNode
    extends Node {
        public abstract TruffleString execute(Node var1, Object var2);

        public static boolean isString(Object s) {
            return s instanceof TruffleString;
        }

        @Specialization
        static TruffleString string(TruffleString s) {
            return s;
        }

        @Specialization(guards={"!isString(s)"})
        static TruffleString str(Node inliningTarget, Object s, @Cached CastToTruffleStringNode str, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                return str.execute(inliningTarget, s);
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.EXPECTED_OBJ_TYPE_S_GOT_P, "str", s);
            }
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class CreateBufferedIONode
    extends Node {
        public abstract PBuffered execute(VirtualFrame var1, Node var2, PFileIO var3, int var4, PythonObjectFactory var5, IOMode var6);

        protected static boolean isRandom(IOMode mode) {
            return mode.updating;
        }

        protected static boolean isWriting(IOMode mode) {
            return mode.creating || mode.writing || mode.appending;
        }

        protected static boolean isReading(IOMode mode) {
            return mode.reading;
        }

        @Specialization(guards={"isRandom(mode)"})
        static PBuffered createRandom(VirtualFrame frame, Node inliningTarget, PFileIO fileIO, int buffering, PythonObjectFactory factory, IOMode mode, @Cached BufferedRandomBuiltins.BufferedRandomInit initBuffered) {
            PBuffered buffer = factory.createBufferedRandom((Object)PythonBuiltinClassType.PBufferedRandom);
            initBuffered.execute(frame, inliningTarget, buffer, fileIO, buffering, factory);
            return buffer;
        }

        @Specialization(guards={"!isRandom(mode)", "isWriting(mode)"})
        static PBuffered createWriter(VirtualFrame frame, Node inliningTarget, PFileIO fileIO, int buffering, PythonObjectFactory factory, IOMode mode, @Cached BufferedWriterBuiltins.BufferedWriterInit initBuffered) {
            PBuffered buffer = factory.createBufferedWriter((Object)PythonBuiltinClassType.PBufferedWriter);
            initBuffered.execute(frame, inliningTarget, buffer, fileIO, buffering, factory);
            return buffer;
        }

        @Specialization(guards={"!isRandom(mode)", "!isWriting(mode)", "isReading(mode)"})
        static PBuffered createWriter(VirtualFrame frame, Node inliningTarget, PFileIO fileIO, int buffering, PythonObjectFactory factory, IOMode mode, @Cached BufferedReaderBuiltins.BufferedReaderInit initBuffered) {
            PBuffered buffer = factory.createBufferedReader((Object)PythonBuiltinClassType.PBufferedReader);
            initBuffered.execute(frame, inliningTarget, buffer, fileIO, buffering, factory);
            return buffer;
        }
    }

    @ImportStatic(value={PGuards.class})
    public static abstract class CastOpenNameNode
    extends ArgumentCastNode {
        public static final int MAX = Integer.MAX_VALUE;

        @Override
        public abstract Object execute(VirtualFrame var1, Object var2);

        @Specialization(guards={"fd >= 0"})
        static int fast(int fd) {
            return fd;
        }

        @Specialization(guards={"fd >= 0", "fd <= MAX"})
        static int fast(long fd) {
            return (int)fd;
        }

        @Specialization(guards={"!isInteger(nameobj)"})
        static Object generic(VirtualFrame frame, Object nameobj, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.DecodeUTF8FSPathNode fspath, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (indexCheckNode.execute(inliningTarget, nameobj)) {
                int fd = asSizeNode.executeExact((Frame)frame, inliningTarget, nameobj);
                if (fd < 0) {
                    CastOpenNameNode.err(fd, raiseNode.get(inliningTarget));
                }
                return fd;
            }
            return fspath.execute(frame, nameobj);
        }

        @Specialization(guards={"fd < 0"})
        static int err(int fd, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.OPENER_RETURNED_D, fd);
        }

        @Specialization(guards={"fd < 0"})
        static int err(long fd, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.OPENER_RETURNED_D, fd);
        }

        @ClinicConverterFactory
        @NeverDefault
        public static CastOpenNameNode create() {
            return IONodesFactory.CastOpenNameNodeGen.create();
        }
    }

    public static abstract class CreateIOModeNode
    extends ArgumentCastNode {
        protected final boolean warnUniversal;

        protected CreateIOModeNode(boolean warnUniversal) {
            this.warnUniversal = warnUniversal;
        }

        @Override
        public abstract IOMode execute(VirtualFrame var1, Object var2);

        @Specialization
        static IOMode none(PNone none) {
            return IOMode.R;
        }

        @Specialization
        static IOMode done(IOMode mode) {
            return mode;
        }

        @Fallback
        IOMode generic(VirtualFrame frame, Object modeObj, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode toString, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleStringIterator.NextNode nextNode, @Cached InlinedBranchProfile errProfile1, @Cached InlinedBranchProfile errProfile2, @Cached InlinedBranchProfile errProfile3, @Cached WarningsModuleBuiltins.WarnNode warnNode, @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString mode;
            try {
                mode = toString.execute(inliningTarget, modeObj);
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
            }
            IOMode m = new IOMode(mode, createCodePointIteratorNode, nextNode);
            if (m.hasNil) {
                errProfile1.enter(inliningTarget);
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.EMBEDDED_NULL_CHARACTER);
            }
            if (m.isInvalid) {
                errProfile2.enter(inliningTarget);
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.INVALID_MODE_S, mode);
            }
            if (this.warnUniversal && m.universal) {
                errProfile3.enter(inliningTarget);
                warnNode.warnEx((Frame)frame, (Object)PythonBuiltinClassType.DeprecationWarning, ErrorMessages.U_MODE_DEPRACATED, 1);
            }
            return m;
        }

        @ClinicConverterFactory
        @NeverDefault
        public static CreateIOModeNode create(boolean warnUniversal) {
            return IONodesFactory.CreateIOModeNodeGen.create(warnUniversal);
        }
    }

    @CompilerDirectives.ValueType
    public static final class IOMode {
        public static final IOMode R = new IOMode(T_R, true, false, false, 1);
        public static final IOMode W = new IOMode(T_W, false, true, false, 1);
        public static final IOMode RB = new IOMode(T_RB, true, false, true, 1);
        boolean creating;
        boolean reading;
        boolean writing;
        boolean appending;
        boolean updating;
        boolean text;
        boolean binary;
        boolean universal;
        boolean isInvalid;
        int xrwa = 0;
        boolean isBad;
        boolean hasNil;
        final TruffleString mode;

        private IOMode(TruffleString mode, boolean reading, boolean writing, boolean binary, int xrwa) {
            this.mode = mode;
            this.reading = reading;
            this.writing = writing;
            this.binary = binary;
            this.xrwa = xrwa;
        }

        IOMode(TruffleString mode, TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, TruffleStringIterator.NextNode nextNode) {
            this.mode = mode;
            int flags = 0;
            TruffleStringIterator it = createCodePointIteratorNode.execute((AbstractTruffleString)mode, PythonUtils.TS_ENCODING);
            while (it.hasNext()) {
                int current;
                int c = nextNode.execute(it);
                switch (c) {
                    case 120: {
                        current = 2;
                        this.creating = true;
                        break;
                    }
                    case 114: {
                        current = 4;
                        this.reading = true;
                        break;
                    }
                    case 119: {
                        current = 8;
                        this.writing = true;
                        break;
                    }
                    case 97: {
                        current = 16;
                        this.appending = true;
                        break;
                    }
                    case 43: {
                        current = 32;
                        this.updating = true;
                        break;
                    }
                    case 116: {
                        current = 64;
                        this.text = true;
                        break;
                    }
                    case 98: {
                        current = 128;
                        this.binary = true;
                        break;
                    }
                    case 85: {
                        current = 256;
                        this.universal = true;
                        this.reading = true;
                        break;
                    }
                    case 0: {
                        this.hasNil = true;
                        return;
                    }
                    default: {
                        this.isInvalid = true;
                        return;
                    }
                }
                if ((flags & current) > 0) {
                    this.isBad = true;
                    return;
                }
                flags |= current;
            }
            this.xrwa += IOMode.isSet(this.creating);
            this.xrwa += IOMode.isSet(this.reading);
            this.xrwa += IOMode.isSet(this.writing);
            this.xrwa += IOMode.isSet(this.appending);
        }

        private static int isSet(boolean b) {
            return b ? 1 : 0;
        }

        public static boolean isInvalidMode(IOMode mode) {
            return mode.isInvalid;
        }

        public static boolean isBadMode(IOMode mode) {
            return mode.isBad || IOMode.isXRWA(mode);
        }

        public static boolean isValidUniveral(IOMode mode) {
            if (mode.universal) {
                return !mode.creating && !mode.writing && !mode.appending && !mode.updating;
            }
            return true;
        }

        public static boolean isXRWA(IOMode mode) {
            return mode.xrwa > 1;
        }

        public static boolean isUnknown(IOMode mode) {
            return mode.xrwa == 0 && !mode.updating;
        }

        public static boolean isTB(IOMode mode) {
            return mode.text && IOMode.isBinary(mode);
        }

        public static boolean isBinary(IOMode mode) {
            return mode.binary;
        }
    }
}

