/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.modules.io.RawIOBaseBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.io.RawIOBaseBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.bytes.PByteArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;
import java.io.ByteArrayOutputStream;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PRawIOBase})
public final class RawIOBaseBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return RawIOBaseBuiltinsFactory.getFactories();
    }

    @Builtin(name="write", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class WriteNode
    extends PythonBuiltinNode {
        WriteNode() {
        }

        @Specialization
        static Object write(Object self, Object args, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.NotImplementedError);
        }
    }

    @Builtin(name="readinto", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class ReadIntoNode
    extends PythonBuiltinNode {
        ReadIntoNode() {
        }

        @Specialization
        static Object readinto(Object self, Object args, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.NotImplementedError);
        }
    }

    @Builtin(name="readall", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReadallNode
    extends PythonBuiltinNode {
        ReadallNode() {
        }

        @Specialization
        static Object readall(VirtualFrame frame, Object self, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethodRead, @Cached InlinedConditionProfile dataNoneProfile, @Cached InlinedConditionProfile chunksSize0Profile, @Cached InlinedCountingConditionProfile bytesLen0Profile, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            ByteArrayOutputStream chunks = BytesUtils.createOutputStream();
            while (true) {
                Object data;
                if (dataNoneProfile.profile(inliningTarget, (data = callMethodRead.execute((Frame)frame, inliningTarget, self, IONodes.T_READ, 8192)) == PNone.NONE)) {
                    if (!chunksSize0Profile.profile(inliningTarget, chunks.size() == 0)) break;
                    return data;
                }
                if (!(data instanceof PBytes)) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.S_SHOULD_RETURN_BYTES, "read()");
                }
                byte[] bytes = bufferLib.getInternalOrCopiedByteArray(data);
                int bytesLen = bufferLib.getBufferLength(data);
                if (bytesLen0Profile.profile(inliningTarget, bytesLen == 0)) break;
                BytesUtils.append(chunks, bytes, bytesLen);
            }
            return factory.createBytes(BytesUtils.toByteArray(chunks));
        }
    }

    @Builtin(name="read", minNumOfPositionalArgs=1, parameterNames={"$self", "$size"})
    @ArgumentClinic(name="$size", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class ReadNode
    extends PythonBinaryClinicBuiltinNode {
        ReadNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return RawIOBaseBuiltinsClinicProviders.ReadNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"size < 0"})
        static Object readall(VirtualFrame frame, Object self, int size, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self, IONodes.T_READALL, new Object[0]);
        }

        @Specialization(guards={"size >= 0"})
        static Object read(VirtualFrame frame, Object self, int size, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.ToBytesNode toBytes, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callMethodReadInto, @Cached PyNumberAsSizeNode asSizeNode, @Cached PythonObjectFactory factory) {
            PByteArray b = factory.createByteArray(new byte[size]);
            Object res = callMethodReadInto.execute((Frame)frame, inliningTarget, self, IONodes.T_READINTO, b);
            if (res == PNone.NONE) {
                return res;
            }
            int n = asSizeNode.executeExact((Frame)frame, inliningTarget, res, PythonErrorType.ValueError);
            if (n == 0) {
                return factory.createBytes(PythonUtils.EMPTY_BYTE_ARRAY);
            }
            byte[] bytes = toBytes.execute(b);
            if (n < size) {
                return factory.createBytes(PythonUtils.arrayCopyOf(bytes, n));
            }
            return factory.createBytes(bytes);
        }
    }
}

