/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.builtins.modules.io.TextIOBaseBuiltins;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@GeneratedBy(value=TextIOBaseBuiltins.class)
public final class TextIOBaseBuiltinsFactory {
    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return Arrays.asList(DetachNodeFactory.getInstance(), ReadNodeFactory.getInstance(), ReadlineNodeFactory.getInstance(), WriteNodeFactory.getInstance(), EncodingNodeFactory.getInstance(), NewlinesNodeFactory.getInstance(), ErrorsNodeFactory.getInstance());
    }

    @GeneratedBy(value=TextIOBaseBuiltins.DetachNode.class)
    static final class DetachNodeFactory
    implements NodeFactory<TextIOBaseBuiltins.DetachNode> {
        private static final DetachNodeFactory DETACH_NODE_FACTORY_INSTANCE = new DetachNodeFactory();

        private DetachNodeFactory() {
        }

        public Class<TextIOBaseBuiltins.DetachNode> getNodeClass() {
            return TextIOBaseBuiltins.DetachNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(ReadArgumentNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(ReadArgumentNode[].class));
        }

        public TextIOBaseBuiltins.DetachNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return DetachNodeFactory.create((ReadArgumentNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<TextIOBaseBuiltins.DetachNode> getInstance() {
            return DETACH_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TextIOBaseBuiltins.DetachNode create(ReadArgumentNode[] arguments) {
            return new DetachNodeGen(arguments);
        }

        @GeneratedBy(value=TextIOBaseBuiltins.DetachNode.class)
        static final class DetachNodeGen
        extends TextIOBaseBuiltins.DetachNode {
            @Node.Child
            private ReadArgumentNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private PRaiseNode raiseNode_;

            private DetachNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                PRaiseNode raiseNode__;
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                if (state_0 != 0 && (raiseNode__ = this.raiseNode_) != null) {
                    return TextIOBaseBuiltins.DetachNode.detach(arguments0Value_, raiseNode__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value_);
            }

            private Object executeAndSpecialize(Object arguments0Value) {
                int state_0 = this.state_0_;
                PRaiseNode raiseNode__ = (PRaiseNode)this.insert(PRaiseNode.create());
                Objects.requireNonNull(raiseNode__, "Specialization 'detach(Object, PRaiseNode)' cache 'raiseNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.raiseNode_ = raiseNode__;
                this.state_0_ = state_0 |= 1;
                return TextIOBaseBuiltins.DetachNode.detach(arguments0Value, raiseNode__);
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=TextIOBaseBuiltins.ReadNode.class)
    static final class ReadNodeFactory
    implements NodeFactory<TextIOBaseBuiltins.ReadNode> {
        private static final ReadNodeFactory READ_NODE_FACTORY_INSTANCE = new ReadNodeFactory();

        private ReadNodeFactory() {
        }

        public Class<TextIOBaseBuiltins.ReadNode> getNodeClass() {
            return TextIOBaseBuiltins.ReadNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(ReadArgumentNode.class, ReadArgumentNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(ReadArgumentNode[].class));
        }

        public TextIOBaseBuiltins.ReadNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return ReadNodeFactory.create((ReadArgumentNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<TextIOBaseBuiltins.ReadNode> getInstance() {
            return READ_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TextIOBaseBuiltins.ReadNode create(ReadArgumentNode[] arguments) {
            return new ReadNodeGen(arguments);
        }

        @GeneratedBy(value=TextIOBaseBuiltins.ReadNode.class)
        static final class ReadNodeGen
        extends TextIOBaseBuiltins.ReadNode {
            @Node.Child
            private ReadArgumentNode arguments0_;
            @Node.Child
            private ReadArgumentNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private PRaiseNode raiseNode_;

            private ReadNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                PRaiseNode raiseNode__;
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                if (state_0 != 0 && (raiseNode__ = this.raiseNode_) != null) {
                    return TextIOBaseBuiltins.ReadNode.read(arguments0Value_, arguments1Value_, raiseNode__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
            }

            private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
                int state_0 = this.state_0_;
                PRaiseNode raiseNode__ = (PRaiseNode)this.insert(PRaiseNode.create());
                Objects.requireNonNull(raiseNode__, "Specialization 'read(Object, Object, PRaiseNode)' cache 'raiseNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.raiseNode_ = raiseNode__;
                this.state_0_ = state_0 |= 1;
                return TextIOBaseBuiltins.ReadNode.read(arguments0Value, arguments1Value, raiseNode__);
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=TextIOBaseBuiltins.ReadlineNode.class)
    static final class ReadlineNodeFactory
    implements NodeFactory<TextIOBaseBuiltins.ReadlineNode> {
        private static final ReadlineNodeFactory READLINE_NODE_FACTORY_INSTANCE = new ReadlineNodeFactory();

        private ReadlineNodeFactory() {
        }

        public Class<TextIOBaseBuiltins.ReadlineNode> getNodeClass() {
            return TextIOBaseBuiltins.ReadlineNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(ReadArgumentNode.class, ReadArgumentNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(ReadArgumentNode[].class));
        }

        public TextIOBaseBuiltins.ReadlineNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return ReadlineNodeFactory.create((ReadArgumentNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<TextIOBaseBuiltins.ReadlineNode> getInstance() {
            return READLINE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TextIOBaseBuiltins.ReadlineNode create(ReadArgumentNode[] arguments) {
            return new ReadlineNodeGen(arguments);
        }

        @GeneratedBy(value=TextIOBaseBuiltins.ReadlineNode.class)
        static final class ReadlineNodeGen
        extends TextIOBaseBuiltins.ReadlineNode {
            @Node.Child
            private ReadArgumentNode arguments0_;
            @Node.Child
            private ReadArgumentNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private PRaiseNode raiseNode_;

            private ReadlineNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                PRaiseNode raiseNode__;
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                if (state_0 != 0 && (raiseNode__ = this.raiseNode_) != null) {
                    return TextIOBaseBuiltins.ReadlineNode.read(arguments0Value_, arguments1Value_, raiseNode__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
            }

            private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
                int state_0 = this.state_0_;
                PRaiseNode raiseNode__ = (PRaiseNode)this.insert(PRaiseNode.create());
                Objects.requireNonNull(raiseNode__, "Specialization 'read(Object, Object, PRaiseNode)' cache 'raiseNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.raiseNode_ = raiseNode__;
                this.state_0_ = state_0 |= 1;
                return TextIOBaseBuiltins.ReadlineNode.read(arguments0Value, arguments1Value, raiseNode__);
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=TextIOBaseBuiltins.WriteNode.class)
    static final class WriteNodeFactory
    implements NodeFactory<TextIOBaseBuiltins.WriteNode> {
        private static final WriteNodeFactory WRITE_NODE_FACTORY_INSTANCE = new WriteNodeFactory();

        private WriteNodeFactory() {
        }

        public Class<TextIOBaseBuiltins.WriteNode> getNodeClass() {
            return TextIOBaseBuiltins.WriteNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(ReadArgumentNode.class, ReadArgumentNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(ReadArgumentNode[].class));
        }

        public TextIOBaseBuiltins.WriteNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return WriteNodeFactory.create((ReadArgumentNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<TextIOBaseBuiltins.WriteNode> getInstance() {
            return WRITE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TextIOBaseBuiltins.WriteNode create(ReadArgumentNode[] arguments) {
            return new WriteNodeGen(arguments);
        }

        @GeneratedBy(value=TextIOBaseBuiltins.WriteNode.class)
        static final class WriteNodeGen
        extends TextIOBaseBuiltins.WriteNode {
            @Node.Child
            private ReadArgumentNode arguments0_;
            @Node.Child
            private ReadArgumentNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private PRaiseNode raiseNode_;

            private WriteNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                PRaiseNode raiseNode__;
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                if (state_0 != 0 && (raiseNode__ = this.raiseNode_) != null) {
                    return TextIOBaseBuiltins.WriteNode.write(arguments0Value_, arguments1Value_, raiseNode__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
            }

            private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
                int state_0 = this.state_0_;
                PRaiseNode raiseNode__ = (PRaiseNode)this.insert(PRaiseNode.create());
                Objects.requireNonNull(raiseNode__, "Specialization 'write(Object, Object, PRaiseNode)' cache 'raiseNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.raiseNode_ = raiseNode__;
                this.state_0_ = state_0 |= 1;
                return TextIOBaseBuiltins.WriteNode.write(arguments0Value, arguments1Value, raiseNode__);
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=TextIOBaseBuiltins.EncodingNode.class)
    static final class EncodingNodeFactory
    implements NodeFactory<TextIOBaseBuiltins.EncodingNode> {
        private static final EncodingNodeFactory ENCODING_NODE_FACTORY_INSTANCE = new EncodingNodeFactory();

        private EncodingNodeFactory() {
        }

        public Class<TextIOBaseBuiltins.EncodingNode> getNodeClass() {
            return TextIOBaseBuiltins.EncodingNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public TextIOBaseBuiltins.EncodingNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return EncodingNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<TextIOBaseBuiltins.EncodingNode> getInstance() {
            return ENCODING_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TextIOBaseBuiltins.EncodingNode create() {
            return new EncodingNodeGen();
        }

        @GeneratedBy(value=TextIOBaseBuiltins.EncodingNode.class)
        static final class EncodingNodeGen
        extends TextIOBaseBuiltins.EncodingNode {
            private EncodingNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                return TextIOBaseBuiltins.EncodingNode.doit(arg0Value);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=TextIOBaseBuiltins.NewlinesNode.class)
    static final class NewlinesNodeFactory
    implements NodeFactory<TextIOBaseBuiltins.NewlinesNode> {
        private static final NewlinesNodeFactory NEWLINES_NODE_FACTORY_INSTANCE = new NewlinesNodeFactory();

        private NewlinesNodeFactory() {
        }

        public Class<TextIOBaseBuiltins.NewlinesNode> getNodeClass() {
            return TextIOBaseBuiltins.NewlinesNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public TextIOBaseBuiltins.NewlinesNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return NewlinesNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<TextIOBaseBuiltins.NewlinesNode> getInstance() {
            return NEWLINES_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TextIOBaseBuiltins.NewlinesNode create() {
            return new NewlinesNodeGen();
        }

        @GeneratedBy(value=TextIOBaseBuiltins.NewlinesNode.class)
        static final class NewlinesNodeGen
        extends TextIOBaseBuiltins.NewlinesNode {
            private NewlinesNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                return TextIOBaseBuiltins.NewlinesNode.doit(arg0Value);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=TextIOBaseBuiltins.ErrorsNode.class)
    static final class ErrorsNodeFactory
    implements NodeFactory<TextIOBaseBuiltins.ErrorsNode> {
        private static final ErrorsNodeFactory ERRORS_NODE_FACTORY_INSTANCE = new ErrorsNodeFactory();

        private ErrorsNodeFactory() {
        }

        public Class<TextIOBaseBuiltins.ErrorsNode> getNodeClass() {
            return TextIOBaseBuiltins.ErrorsNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public TextIOBaseBuiltins.ErrorsNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return ErrorsNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<TextIOBaseBuiltins.ErrorsNode> getInstance() {
            return ERRORS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TextIOBaseBuiltins.ErrorsNode create() {
            return new ErrorsNodeGen();
        }

        @GeneratedBy(value=TextIOBaseBuiltins.ErrorsNode.class)
        static final class ErrorsNodeGen
        extends TextIOBaseBuiltins.ErrorsNode {
            private ErrorsNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                return TextIOBaseBuiltins.ErrorsNode.doit(arg0Value);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }
        }
    }
}

