/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.bytes.PByteArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeClass;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeVoidPtr;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGuards;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.PrimitiveNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PySequenceArrayWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonObjectNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitionsFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.GetNativeWrapperNode;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtContext;
import com.oracle.graal.python.builtins.objects.cext.common.GetNextVaArgNode;
import com.oracle.graal.python.builtins.objects.cext.common.NativeCExtSymbol;
import com.oracle.graal.python.builtins.objects.cext.structs.CConstants;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.complex.PComplex;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.module.ModuleGetNameNode;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.TypeBuiltins;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToDynamicObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.frame.GetCurrentFrameRef;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.nodes.util.CastToJavaStringNodeGen;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.graal.python.util.Function;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class CExtNodes {
    private static final String J_UNICODE = "unicode";
    private static final String J_SUBTYPE_NEW = "_subtype_new";

    @CompilerDirectives.TruffleBoundary
    public static Object pointerAdd(Object pointer, long offset) {
        return PCallCapiFunction.getUncached().call(NativeCAPISymbol.FUN_PTR_ADD, pointer, offset);
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class PCallCapiFunction
    extends Node {
        public static Object callUncached(NativeCAPISymbol symbol, Object ... args) {
            return PCallCapiFunction.getUncached().execute(symbol, args);
        }

        public final Object call(NativeCAPISymbol symbol, Object ... args) {
            return this.execute(symbol, args);
        }

        protected abstract Object execute(NativeCAPISymbol var1, Object[] var2);

        @Specialization
        static Object doWithoutContext(NativeCAPISymbol name, Object[] args, @Bind(value="this") Node inliningTarget, @Cached CExtCommonNodes.ImportCExtSymbolNode importCExtSymbolNode, @CachedLibrary(limit="1") InteropLibrary interopLibrary, @Cached CExtCommonNodes.EnsureTruffleStringNode ensureTruffleStringNode) {
            try {
                CApiContext cApiContext;
                PythonContext pythonContext = PythonContext.get(inliningTarget);
                if (!pythonContext.hasCApiContext()) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    cApiContext = CApiContext.ensureCapiWasLoaded();
                } else {
                    cApiContext = pythonContext.getCApiContext();
                }
                return ensureTruffleStringNode.execute(inliningTarget, interopLibrary.execute(importCExtSymbolNode.execute(inliningTarget, cApiContext, name), args));
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        @NeverDefault
        public static PCallCapiFunction create() {
            return CExtNodesFactory.PCallCapiFunctionNodeGen.create();
        }

        public static PCallCapiFunction getUncached() {
            return CExtNodesFactory.PCallCapiFunctionNodeGen.getUncached();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={CApiGuards.class, PGuards.class})
    public static abstract class CreateFunctionNode
    extends Node {
        private static final TruffleLogger LOGGER = CApiContext.getLogger(CreateFunctionNode.class);

        public static Object executeUncached(TruffleString name, Object callable, Object wrapper, Object type, Object flags) {
            return CExtNodesFactory.CreateFunctionNodeGen.getUncached().execute(null, name, callable, wrapper, type, flags);
        }

        public abstract Object execute(Node var1, TruffleString var2, Object var3, Object var4, Object var5, Object var6);

        @Specialization(guards={"!isNoValue(type)", "isNoValue(wrapper)"})
        static Object doPythonCallableWithoutWrapper(TruffleString name, PythonNativeWrapper callable, PNone wrapper, Object type, Object flags) {
            return callable.getDelegate();
        }

        @Specialization(guards={"!isNoValue(type)"})
        @CompilerDirectives.TruffleBoundary
        static Object doPythonCallable(TruffleString name, PythonNativeWrapper callable, int signature, Object type, int flags) {
            PythonContext context;
            PythonLanguage language;
            Object managedCallable = callable.getDelegate();
            PBuiltinFunction function = ExternalFunctionNodes.PExternalFunctionWrapper.createWrapperFunction(name, managedCallable, type, flags, signature, language = (context = PythonContext.get(null)).getLanguage(), (PythonObjectFactory)context.factory(), false);
            return function != null ? function : managedCallable;
        }

        @Specialization(guards={"!isNativeWrapper(callable)"})
        @CompilerDirectives.TruffleBoundary
        static Object doNativeCallableWithWrapper(TruffleString name, Object callable, int signature, Object type, int flags, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib) {
            boolean doArgAndResultConversion;
            PythonContext context = PythonContext.get(null);
            Object resolvedCallable = CreateFunctionNode.resolveClosurePointer(context, callable, lib);
            if (resolvedCallable != null) {
                doArgAndResultConversion = false;
            } else {
                doArgAndResultConversion = true;
                resolvedCallable = callable;
            }
            PythonLanguage language = context.getLanguage();
            PBuiltinFunction function = ExternalFunctionNodes.PExternalFunctionWrapper.createWrapperFunction(name, resolvedCallable, type, flags, signature, language, (PythonObjectFactory)context.factory(), doArgAndResultConversion);
            return function != null ? function : resolvedCallable;
        }

        @Specialization(guards={"isNoValue(wrapper)", "!isNativeWrapper(callable)"})
        @CompilerDirectives.TruffleBoundary
        static PBuiltinFunction doNativeCallableWithoutWrapper(TruffleString name, Object callable, Object type, PNone wrapper, Object flags, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib) {
            PythonContext context = PythonContext.get(null);
            PBuiltinFunction managedCallable = CreateFunctionNode.resolveClosurePointer(context, callable, lib);
            if (managedCallable != null) {
                return managedCallable;
            }
            PythonLanguage language = context.getLanguage();
            return ExternalFunctionNodes.PExternalFunctionWrapper.createWrapperFunction(name, callable, type, 0, ExternalFunctionNodes.PExternalFunctionWrapper.DIRECT, language, (PythonObjectFactory)context.factory(), true);
        }

        @CompilerDirectives.TruffleBoundary
        public static PBuiltinFunction resolveClosurePointer(PythonContext context, Object callable, InteropLibrary lib) {
            if (lib.isPointer(callable)) {
                long pointer;
                try {
                    pointer = lib.asPointer(callable);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                Object delegate = context.getCApiContext().getClosureDelegate(pointer);
                if (delegate instanceof PBuiltinFunction) {
                    PBuiltinFunction function = (PBuiltinFunction)delegate;
                    LOGGER.fine(() -> PythonUtils.formatJString("forwarding %d 0x%x to %s", pointer, pointer, function));
                    return function;
                }
            }
            return null;
        }
    }

    @GenerateInline(value=false)
    @ImportStatic(value={CApiGuards.class})
    static abstract class ReleaseNativeWrapperNode
    extends Node {
        ReleaseNativeWrapperNode() {
        }

        public abstract void execute(Object var1);

        @Specialization
        static void doNativeWrapper(PythonNativeWrapper.PythonAbstractObjectNativeWrapper nativeWrapper) {
        }

        @Specialization(guards={"!isNativeWrapper(object)"})
        static void doOther(Object object) {
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CreateMemoryViewFromNativeNode
    extends PNodeWithContext {
        public abstract PMemoryView execute(Node var1, PythonNativeObject var2, int var3);

        @Specialization
        static PMemoryView fromNative(PythonNativeObject buf, int flags, @Cached(inline=false) CApiTransitions.PythonToNativeNode toSulongNode, @Cached(inline=false) CApiTransitions.NativeToPythonNode asPythonObjectNode, @Cached(inline=false) PCallCapiFunction callCapiFunction, @Cached(inline=false) ExternalFunctionNodes.DefaultCheckFunctionResultNode checkFunctionResultNode) {
            Object result = callCapiFunction.call(NativeCAPISymbol.FUN_PY_TRUFFLE_MEMORYVIEW_FROM_OBJECT, toSulongNode.execute(buf), flags);
            checkFunctionResultNode.execute(PythonContext.get(callCapiFunction), NativeCAPISymbol.FUN_PY_TRUFFLE_MEMORYVIEW_FROM_OBJECT.getTsName(), result);
            return (PMemoryView)asPythonObjectNode.execute(result);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class HasNativeBufferNode
    extends PNodeWithContext {
        public abstract boolean execute(Node var1, PythonAbstractNativeObject var2);

        @Specialization
        static boolean readTpAsBuffer(PythonAbstractNativeObject object, @CachedLibrary(limit="3") InteropLibrary lib, @Cached(inline=false) CStructAccess.ReadPointerNode readType, @Cached(inline=false) CStructAccess.ReadPointerNode readAsBuffer) {
            Object type = readType.readFromObj(object, CFields.PyObject__ob_type);
            Object result = readAsBuffer.read(type, CFields.PyTypeObject__tp_as_buffer);
            return !PGuards.isNullOrZero(result, lib);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CreateMethodNode
    extends PNodeWithContext {
        public abstract PBuiltinFunction execute(Node var1, Object var2, int var3);

        @Specialization
        static PBuiltinFunction doIt(Object methodDef, int element, @CachedLibrary(limit="2") InteropLibrary resultLib, @Cached(inline=false) CStructAccess.ReadPointerNode readPointerNode, @Cached(inline=false) CStructAccess.ReadI32Node readI32Node, @Cached(inline=false) FromCharPointerNode fromCharPointerNode, @Cached(inline=false) PythonObjectFactory factory, @Cached(inline=false) WriteAttributeToDynamicObjectNode writeAttributeToDynamicObjectNode) {
            Object methodNamePtr = readPointerNode.readStructArrayElement(methodDef, element, CFields.PyMethodDef__ml_name);
            if (resultLib.isNull(methodNamePtr) || methodNamePtr instanceof Long && (Long)methodNamePtr == 0L) {
                return null;
            }
            TruffleString methodName = fromCharPointerNode.execute(methodNamePtr);
            PNone methodDoc = PNone.NONE;
            Object methodDocPtr = readPointerNode.readStructArrayElement(methodDef, element, CFields.PyMethodDef__ml_doc);
            if (!resultLib.isNull(methodDocPtr)) {
                methodDoc = fromCharPointerNode.execute(methodDocPtr, false);
            }
            int flags = readI32Node.readStructArrayElement(methodDef, element, CFields.PyMethodDef__ml_flags);
            Object mlMethObj = readPointerNode.readStructArrayElement(methodDef, element, CFields.PyMethodDef__ml_meth);
            ExternalFunctionNodes.PExternalFunctionWrapper sig = ExternalFunctionNodes.PExternalFunctionWrapper.fromMethodFlags(flags);
            RootCallTarget callTarget = ExternalFunctionNodes.PExternalFunctionWrapper.getOrCreateCallTarget(sig, PythonLanguage.get(factory), methodName, true, CExtContext.isMethStatic(flags));
            mlMethObj = NativeCExtSymbol.ensureExecutable(mlMethObj, sig);
            PKeyword[] kwDefaults = ExternalFunctionNodes.createKwDefaults(mlMethObj);
            PBuiltinFunction function = factory.createBuiltinFunction(methodName, null, PythonUtils.EMPTY_OBJECT_ARRAY, kwDefaults, flags, callTarget);
            writeAttributeToDynamicObjectNode.execute((Object)function.getStorage(), SpecialAttributeNames.T___DOC__, (Object)methodDoc);
            return function;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class ExecModuleNode
    extends MultiPhaseExtensionModuleInitNode {
        public abstract int execute(CApiContext var1, PythonModule var2, Object var3);

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static int doGeneric(CApiContext capiContext, PythonModule module, Object moduleDef, @Bind(value="this") Node inliningTarget, @Cached ModuleGetNameNode getNameNode, @Cached CStructAccess.ReadI64Node readI64, @Cached CStructAccess.AllocateNode alloc, @Cached CStructAccess.ReadPointerNode readPointerNode, @Cached CStructAccess.ReadI32Node readI32Node, @CachedLibrary(limit="3") InteropLibrary interopLib, @Cached PRaiseNode raiseNode) {
            block12: {
                InteropLibrary U = InteropLibrary.getUncached();
                TruffleString mName = getNameNode.execute(inliningTarget, module);
                long mSize = readI64.read(moduleDef, CFields.PyModuleDef__m_size);
                try {
                    Object slotDefinitions;
                    if (mSize >= 0L) {
                        Object mdState = alloc.alloc(mSize == 0L ? 1L : mSize);
                        assert (mdState != null && !InteropLibrary.getUncached().isNull(mdState));
                        module.setNativeModuleState(mdState);
                    }
                    if (interopLib.isNull(slotDefinitions = readPointerNode.read(moduleDef, CFields.PyModuleDef__m_slots))) {
                        return 0;
                    }
                    int i = 0;
                    while (true) {
                        int slotId = readI32Node.readStructArrayElement(slotDefinitions, i, CFields.PyModuleDef_Slot__slot);
                        switch (slotId) {
                            case 0: {
                                break block12;
                            }
                            case 1: {
                                break;
                            }
                            case 2: {
                                Object result;
                                int iResult;
                                Object execFunction = readPointerNode.readStructArrayElement(slotDefinitions, i, CFields.PyModuleDef_Slot__value);
                                if (!U.isExecutable(execFunction)) {
                                    Object signature = capiContext.getContext().getEnv().parseInternal(Source.newBuilder((String)"nfi", (CharSequence)"(POINTER):SINT32", (String)"exec").build(), new String[0]).call(new Object[0]);
                                    execFunction = SignatureLibrary.getUncached().bind(signature, execFunction);
                                }
                                CExtCommonNodes.CheckFunctionResultNode.checkFunctionResult(inliningTarget, mName, (iResult = interopLib.asInt(result = interopLib.execute(execFunction, new Object[]{CApiTransitions.PythonToNativeNode.executeUncached(module)}))) != 0, true, PythonLanguage.get(raiseNode), capiContext.getContext(), InlinedConditionProfile.getUncached(), ErrorMessages.EXECUTION_FAILED_WITHOUT_EXCEPTION, ErrorMessages.EXECUTION_RAISED_EXCEPTION);
                                break;
                            }
                            default: {
                                throw raiseNode.raise(PythonErrorType.SystemError, ErrorMessages.MODULE_INITIALIZED_WITH_UNKNOWN_SLOT, mName, slotId);
                            }
                        }
                        ++i;
                    }
                }
                catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            return 0;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class CreateModuleNode
    extends MultiPhaseExtensionModuleInitNode {
        public abstract Object execute(CApiContext var1, CExtContext.ModuleSpec var2, Object var3, Object var4);

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object doGeneric(CApiContext capiContext, CExtContext.ModuleSpec moduleSpec, Object moduleDefWrapper, Object library, @Bind(value="this") Node inliningTarget, @Cached PythonObjectFactory factory, @Cached InlinedConditionProfile errOccurredProfile, @Cached CStructAccess.ReadPointerNode readPointer, @Cached CStructAccess.ReadI64Node readI64, @CachedLibrary(limit="3") InteropLibrary interopLib, @Cached FromCharPointerNode fromCharPointerNode, @Cached WriteAttributeToObjectNode writeAttrNode, @Cached WriteAttributeToDynamicObjectNode writeAttrToMethodNode, @Cached CreateMethodNode addLegacyMethodNode, @Cached CApiTransitions.NativeToPythonStealingNode toJavaNode, @Cached CStructAccess.ReadPointerNode readPointerNode, @Cached CStructAccess.ReadI32Node readI32Node, @Cached PRaiseNode.Lazy raiseNode) {
            Object module;
            Object moduleDef = moduleDefWrapper instanceof PythonAbstractNativeObject ? ((PythonAbstractNativeObject)moduleDefWrapper).getPtr() : moduleDefWrapper;
            TruffleString mName = moduleSpec.name;
            Object docPtr = readPointer.read(moduleDef, CFields.PyModuleDef__m_doc);
            PNone mDoc = PGuards.isNullOrZero(docPtr, interopLib) ? PNone.NO_VALUE : fromCharPointerNode.execute(docPtr);
            long mSize = readI64.read(moduleDef, CFields.PyModuleDef__m_size);
            if (mSize < 0L) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, ErrorMessages.M_SIZE_CANNOT_BE_NEGATIVE, mName);
            }
            Object createFunction = null;
            boolean hasExecutionSlots = false;
            Object slotDefinitions = readPointerNode.read(moduleDef, CFields.PyModuleDef__m_slots);
            if (!interopLib.isNull(slotDefinitions)) {
                int i = 0;
                block7: while (true) {
                    int slotId = readI32Node.readStructArrayElement(slotDefinitions, i, CFields.PyModuleDef_Slot__slot);
                    switch (slotId) {
                        case 0: {
                            break block7;
                        }
                        case 1: {
                            if (createFunction != null) {
                                throw raiseNode.get(inliningTarget).raise(PythonErrorType.SystemError, ErrorMessages.MODULE_HAS_MULTIPLE_CREATE_SLOTS, mName);
                            }
                            createFunction = readPointerNode.readStructArrayElement(slotDefinitions, i, CFields.PyModuleDef_Slot__value);
                            break;
                        }
                        case 2: {
                            hasExecutionSlots = true;
                            break;
                        }
                        default: {
                            throw raiseNode.get(inliningTarget).raise(PythonErrorType.SystemError, ErrorMessages.MODULE_USES_UNKNOW_SLOT_ID, mName, slotId);
                        }
                    }
                    ++i;
                }
            }
            if (createFunction != null && !interopLib.isNull(createFunction)) {
                Object[] cArguments = new Object[]{CApiTransitions.PythonToNativeNode.executeUncached(moduleSpec.originalModuleSpec), moduleDef};
                try {
                    Object result;
                    if (!interopLib.isExecutable(createFunction)) {
                        Object signature = capiContext.getContext().getEnv().parseInternal(Source.newBuilder((String)"nfi", (CharSequence)"(POINTER,POINTER):POINTER", (String)"exec").build(), new String[0]).call(new Object[0]);
                        result = interopLib.execute(SignatureLibrary.getUncached().bind(signature, createFunction), cArguments);
                    } else {
                        result = interopLib.execute(createFunction, cArguments);
                    }
                    CExtCommonNodes.CheckFunctionResultNode.checkFunctionResult(inliningTarget, mName, interopLib.isNull(result), true, PythonLanguage.get(raiseNode), capiContext.getContext(), errOccurredProfile, ErrorMessages.CREATION_FAILD_WITHOUT_EXCEPTION, ErrorMessages.CREATION_RAISED_EXCEPTION);
                    module = toJavaNode.execute(result);
                }
                catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                if (!(module instanceof PythonModule)) {
                    if (mSize > 0L) {
                        throw raiseNode.get(inliningTarget).raise(PythonErrorType.SystemError, ErrorMessages.NOT_A_MODULE_OBJECT_BUT_REQUESTS_MODULE_STATE, mName);
                    }
                    if (hasExecutionSlots) {
                        throw raiseNode.get(inliningTarget).raise(PythonErrorType.SystemError, ErrorMessages.MODULE_SPECIFIES_EXEC_SLOTS_BUT_DIDNT_CREATE_INSTANCE, mName);
                    }
                } else {
                    ((PythonModule)module).setNativeModuleDef(moduleDef);
                }
            } else {
                PythonModule pythonModule = factory.createPythonModule(mName);
                pythonModule.setNativeModuleDef(moduleDef);
                module = pythonModule;
            }
            Object methodDefinitions = readPointerNode.read(moduleDef, CFields.PyModuleDef__m_methods);
            if (!interopLib.isNull(methodDefinitions)) {
                PBuiltinFunction fun;
                int i = 0;
                while ((fun = addLegacyMethodNode.execute(inliningTarget, methodDefinitions, i)) != null) {
                    PBuiltinMethod method = factory.createBuiltinMethod(module, fun);
                    writeAttrToMethodNode.execute((Object)method, SpecialAttributeNames.T___MODULE__, (Object)mName);
                    writeAttrNode.execute(module, fun.getName(), (Object)method);
                    ++i;
                }
            }
            writeAttrNode.execute(module, SpecialAttributeNames.T___DOC__, (Object)mDoc);
            writeAttrNode.execute(module, SpecialAttributeNames.T___LIBRARY__, library);
            capiContext.addLoadedExtensionLibrary(library);
            return module;
        }
    }

    static abstract class MultiPhaseExtensionModuleInitNode
    extends Node {
        static final int SLOT_PY_MOD_CREATE = 1;
        static final int SLOT_PY_MOD_EXEC = 2;

        MultiPhaseExtensionModuleInitNode() {
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class UnicodeFromFormatNode
    extends Node {
        private static Pattern pattern;

        private static Matcher match(String formatStr) {
            if (pattern == null) {
                pattern = Pattern.compile("%(?<flags>[-+ #0])?(?<width>\\d+)?(\\.(?<prec>\\d+))?(?<len>(l|ll|z))?(?<spec>[%cduixspAUVSR])");
            }
            return pattern.matcher(formatStr);
        }

        public abstract Object execute(Node var1, TruffleString var2, Object var3);

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object doGeneric(TruffleString f, Object vaList) {
            String format = f.toJavaStringUncached();
            CApiTransitions.NativeToPythonNode toJavaNode = CApiTransitionsFactory.NativeToPythonNodeGen.getUncached();
            CastToJavaStringNode castToJavaStringNode = CastToJavaStringNodeGen.getUncached();
            FromCharPointerNode fromCharPointerNode = CExtNodesFactory.FromCharPointerNodeGen.getUncached();
            InteropLibrary interopLibrary = InteropLibrary.getUncached();
            PRaiseNode raiseNode = PRaiseNode.getUncached();
            StringBuilder result = new StringBuilder();
            int vaArgIdx = 0;
            try {
                Matcher matcher = UnicodeFromFormatNode.match(format);
                int cur = 0;
                while (matcher.find(cur)) {
                    boolean valid = false;
                    result.append(format, cur, matcher.start());
                    cur = matcher.end();
                    String spec = matcher.group("spec");
                    String len = matcher.group("len");
                    int prec = UnicodeFromFormatNode.getPrec(matcher.group("prec"));
                    assert (spec.length() == 1);
                    char la = spec.charAt(0);
                    PythonContext context = PythonContext.get(raiseNode);
                    switch (la) {
                        case '%': {
                            result.append('%');
                            valid = true;
                            break;
                        }
                        case 'c': {
                            int ordinal = UnicodeFromFormatNode.getAndCastToInt(interopLibrary, raiseNode, vaList);
                            if (ordinal < 0 || ordinal > 0x110000) {
                                throw raiseNode.raise(PythonBuiltinClassType.OverflowError, ErrorMessages.CHARACTER_ARG_NOT_IN_RANGE);
                            }
                            result.append((char)ordinal);
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 'd': 
                        case 'i': {
                            if (len != null) {
                                switch (len) {
                                    case "ll": 
                                    case "l": 
                                    case "z": {
                                        ++vaArgIdx;
                                        result.append(UnicodeFromFormatNode.castToLong(interopLibrary, raiseNode, GetNextVaArgNode.executeUncached(vaList)));
                                        valid = true;
                                    }
                                }
                                break;
                            }
                            result.append(UnicodeFromFormatNode.getAndCastToInt(interopLibrary, raiseNode, vaList));
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 'u': {
                            if (len != null) {
                                switch (len) {
                                    case "ll": 
                                    case "l": 
                                    case "z": {
                                        ++vaArgIdx;
                                        result.append(UnicodeFromFormatNode.castToLong(interopLibrary, raiseNode, GetNextVaArgNode.executeUncached(vaList)));
                                        valid = true;
                                    }
                                }
                                break;
                            }
                            result.append(Integer.toUnsignedString(UnicodeFromFormatNode.getAndCastToInt(interopLibrary, raiseNode, vaList)));
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 'x': {
                            result.append(Integer.toHexString(UnicodeFromFormatNode.getAndCastToInt(interopLibrary, raiseNode, vaList)));
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 's': {
                            Object unicodeObj;
                            String sValue;
                            Object charPtr = GetNextVaArgNode.executeUncached(vaList);
                            if (interopLibrary.isNull(charPtr)) {
                                sValue = "(NULL)";
                            } else {
                                unicodeObj = fromCharPointerNode.execute(charPtr);
                                sValue = castToJavaStringNode.execute(unicodeObj);
                            }
                            try {
                                if (prec == -1) {
                                    result.append(sValue);
                                } else {
                                    result.append(sValue, 0, Math.min(sValue.length(), prec));
                                }
                            }
                            catch (CannotCastException e) {
                                throw CompilerDirectives.shouldNotReachHere();
                            }
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 'p': {
                            Object ptr = GetNextVaArgNode.executeUncached(vaList);
                            long value = interopLibrary.isPointer(ptr) ? interopLibrary.asPointer(ptr) : (interopLibrary.hasIdentity(ptr) ? (long)interopLibrary.identityHashCode(ptr) : (long)System.identityHashCode(ptr));
                            result.append(PythonUtils.formatJString("0x%x", value));
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 'A': {
                            result.append(UnicodeFromFormatNode.callBuiltin(context, BuiltinNames.T_ASCII, UnicodeFromFormatNode.getPyObject(vaList)));
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 'U': {
                            result.append(castToJavaStringNode.execute(UnicodeFromFormatNode.getPyObject(vaList)));
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 'V': {
                            Object pyObjectPtr = GetNextVaArgNode.executeUncached(vaList);
                            Object unicodeObj = InteropLibrary.getUncached().isNull(pyObjectPtr) ? fromCharPointerNode.execute(GetNextVaArgNode.executeUncached(vaList)) : toJavaNode.execute(pyObjectPtr);
                            result.append(castToJavaStringNode.execute(unicodeObj));
                            vaArgIdx += 2;
                            valid = true;
                            break;
                        }
                        case 'S': {
                            result.append(UnicodeFromFormatNode.callBuiltin(context, BuiltinNames.T_STR, UnicodeFromFormatNode.getPyObject(vaList)));
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 'R': {
                            result.append(UnicodeFromFormatNode.callBuiltin(context, BuiltinNames.T_REPR, UnicodeFromFormatNode.getPyObject(vaList)));
                            ++vaArgIdx;
                            valid = true;
                        }
                    }
                    if (valid) continue;
                    result.append(matcher.group());
                }
                result.append(format, cur, format.length());
            }
            catch (InteropException e) {
                throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.ERROR_WHEN_ACCESSING_VAR_ARG_AT_POS, vaArgIdx);
            }
            return PythonUtils.toTruffleStringUncached(result.toString());
        }

        private static int getPrec(String prec) {
            if (prec == null) {
                return -1;
            }
            return Integer.parseInt(prec);
        }

        private static int getAndCastToInt(InteropLibrary lib, PRaiseNode raiseNode, Object vaList) throws InteropException {
            Object value = GetNextVaArgNode.executeUncached(vaList);
            if (lib.fitsInInt(value)) {
                try {
                    return lib.asInt(value);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            if (!lib.isPointer(value)) {
                lib.toNative(value);
            }
            if (lib.isPointer(value)) {
                try {
                    return (int)lib.asPointer(value);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.P_OBJ_CANT_BE_INTEPRETED_AS_INTEGER, value);
        }

        private static long castToLong(InteropLibrary lib, PRaiseNode raiseNode, Object value) {
            if (lib.fitsInLong(value)) {
                try {
                    return lib.asLong(value);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            if (!lib.isPointer(value)) {
                lib.toNative(value);
            }
            if (lib.isPointer(value)) {
                try {
                    return lib.asPointer(value);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.P_OBJ_CANT_BE_INTEPRETED_AS_INTEGER, value);
        }

        private static Object getPyObject(Object vaList) throws InteropException {
            return CApiTransitions.NativeToPythonNode.executeUncached(GetNextVaArgNode.executeUncached(vaList));
        }

        @CompilerDirectives.TruffleBoundary
        private static Object callBuiltin(PythonContext context, TruffleString builtinName, Object object) {
            Object attribute = PyObjectLookupAttr.executeUncached(context.getBuiltins(), builtinName);
            return CastToJavaStringNodeGen.getUncached().execute(CallNode.getUncached().execute(null, attribute, object));
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class ObSizeNode
    extends PNodeWithContext {
        public abstract long execute(Node var1, Object var2);

        @Specialization
        static long doBoolean(boolean object) {
            return object ? 1L : 0L;
        }

        @Specialization
        static long doInteger(int object) {
            return ObSizeNode.doLong(object);
        }

        @Specialization
        static long doLong(long object) {
            int sign = object < 0L ? -1 : 1;
            int size = 0;
            for (long t = PInt.abs(object); t != 0L; t >>>= CConstants.PYLONG_BITS_IN_DIGIT.intValue()) {
                ++size;
            }
            return size * sign;
        }

        @Specialization
        static long doPInt(PInt object) {
            int bw = CConstants.PYLONG_BITS_IN_DIGIT.intValue();
            int len = (PInt.bitLength(object.abs()) + bw - 1) / bw;
            return object.isNegative() ? (long)(-len) : (long)len;
        }

        @Specialization
        static long doPythonNativeVoidPtr(PythonNativeVoidPtr object) {
            return 63 / CConstants.PYLONG_BITS_IN_DIGIT.intValue() + 1;
        }

        @Specialization
        static long doClass(PythonManagedClass object) {
            return 0L;
        }

        @Fallback
        static long doOther(Node inliningTarget, Object object, @Cached PyObjectSizeNode sizeNode) {
            try {
                return sizeNode.execute(null, inliningTarget, object);
            }
            catch (PException e) {
                return -1L;
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ResolvePointerNode
    extends PNodeWithContext {
        public static Object executeUncached(Object pointerObject) {
            return CExtNodesFactory.ResolvePointerNodeGen.getUncached().execute(null, pointerObject);
        }

        public abstract Object execute(Node var1, Object var2);

        public abstract Object executeLong(Node var1, long var2);

        @Specialization
        static Object resolveLongCached(Node inliningTarget, long pointer, @Cached.Exclusive @Cached CApiTransitions.ResolveHandleNode resolveHandleNode) {
            Object lookup = CApiTransitions.lookupNative(pointer);
            if (lookup != null) {
                if (lookup instanceof PythonNativeWrapper.PythonAbstractObjectNativeWrapper) {
                    PythonNativeWrapper.PythonAbstractObjectNativeWrapper objectNativeWrapper = (PythonNativeWrapper.PythonAbstractObjectNativeWrapper)lookup;
                    objectNativeWrapper.incRef();
                }
                return lookup;
            }
            if (CApiTransitions.HandlePointerConverter.pointsToPyHandleSpace(pointer)) {
                return resolveHandleNode.execute(inliningTarget, pointer);
            }
            return pointer;
        }

        @Specialization(guards={"!isLong(pointerObject)"})
        static Object resolveGeneric(Node inliningTarget, Object pointerObject, @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Exclusive @Cached CApiTransitions.ResolveHandleNode resolveHandleNode) {
            if (lib.isPointer(pointerObject)) {
                long pointer;
                try {
                    pointer = lib.asPointer(pointerObject);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                Object lookup = CApiTransitions.lookupNative(pointer);
                if (lookup != null) {
                    if (lookup instanceof PythonNativeWrapper.PythonAbstractObjectNativeWrapper) {
                        PythonNativeWrapper.PythonAbstractObjectNativeWrapper objectNativeWrapper = (PythonNativeWrapper.PythonAbstractObjectNativeWrapper)lookup;
                        objectNativeWrapper.incRef();
                    }
                    return lookup;
                }
                if (CApiTransitions.HandlePointerConverter.pointsToPyHandleSpace(pointer)) {
                    return resolveHandleNode.execute(inliningTarget, pointer);
                }
            }
            return pointerObject;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={PGuards.class})
    public static abstract class ClearNativeWrapperNode
    extends Node {
        public abstract void execute(Node var1, Object var2, PythonNativeWrapper var3);

        @Specialization(guards={"!isPrimitiveNativeWrapper(nativeWrapper)"})
        static void doPythonAbstractObject(PythonAbstractObject delegate, PythonNativeWrapper nativeWrapper) {
            assert (!(nativeWrapper instanceof PythonObjectNativeWrapper) || delegate.getNativeWrapper() == nativeWrapper) : "inconsistent native wrappers";
            delegate.clearNativeWrapper();
        }

        @Specialization(guards={"delegate == null"})
        static void doPrimitiveNativeWrapper(Node inliningTarget, Object delegate, PrimitiveNativeWrapper nativeWrapper) {
            assert (!ClearNativeWrapperNode.isSmallIntegerWrapperSingleton(nativeWrapper, PythonContext.get(inliningTarget))) : "clearing primitive native wrapper singleton of small integer";
        }

        @Specialization(guards={"delegate != null"})
        static void doPrimitiveNativeWrapperMaterialized(Node inliningTarget, PythonAbstractObject delegate, PrimitiveNativeWrapper nativeWrapper, @Cached InlinedConditionProfile profile) {
            if (profile.profile(inliningTarget, delegate.getNativeWrapper() == nativeWrapper)) {
                assert (!ClearNativeWrapperNode.isSmallIntegerWrapperSingleton(nativeWrapper, PythonContext.get(inliningTarget))) : "clearing primitive native wrapper singleton of small integer";
                delegate.clearNativeWrapper();
            }
        }

        @Specialization(guards={"delegate != null", "!isAnyPythonObject(delegate)"})
        static void doOther(Object delegate, PythonNativeWrapper nativeWrapper) {
            assert (!ClearNativeWrapperNode.isPrimitiveNativeWrapper(nativeWrapper));
        }

        static boolean isPrimitiveNativeWrapper(PythonNativeWrapper nativeWrapper) {
            return nativeWrapper instanceof PrimitiveNativeWrapper;
        }

        private static boolean isSmallIntegerWrapperSingleton(PrimitiveNativeWrapper nativeWrapper, PythonContext context) {
            return CApiGuards.isSmallIntegerWrapper(nativeWrapper) && GetNativeWrapperNode.doLongSmall(nativeWrapper.getLong(), context) == nativeWrapper;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={CApiGuards.class})
    public static abstract class AddRefCntNode
    extends PNodeWithContext {
        public static Object executeUncached(Object object, long value) {
            return CExtNodesFactory.AddRefCntNodeGen.getUncached().execute(null, object, value);
        }

        public abstract Object execute(Node var1, Object var2, long var3);

        @Specialization(guards={"value == 1"})
        static PythonNativeWrapper.PythonAbstractObjectNativeWrapper doNativeWrapperIncByOne(Node inliningTarget, PythonNativeWrapper.PythonAbstractObjectNativeWrapper nativeWrapper, long value, @Cached.Shared @Cached InlinedConditionProfile isNativeProfile) {
            if (nativeWrapper.isNative(inliningTarget, isNativeProfile)) {
                nativeWrapper.incRef();
            }
            return nativeWrapper;
        }

        @Specialization(replaces={"doNativeWrapperIncByOne"})
        static PythonNativeWrapper.PythonAbstractObjectNativeWrapper doNativeWrapper(Node inliningTarget, PythonNativeWrapper.PythonAbstractObjectNativeWrapper nativeWrapper, long value, @Cached.Shared @Cached InlinedConditionProfile isNativeProfile, @Cached.Exclusive @Cached InlinedConditionProfile hasRefProfile) {
            assert (value >= 0L) : "adding negative reference count; dealloc might not happen";
            if (nativeWrapper.isNative(inliningTarget, isNativeProfile)) {
                nativeWrapper.setRefCount(inliningTarget, nativeWrapper.getRefCount() + value, hasRefProfile);
            }
            return nativeWrapper;
        }

        @Specialization(guards={"!isNativeWrapper(object)"}, limit="2")
        static Object doNativeObject(Object object, long value, @CachedLibrary(value="object") InteropLibrary lib) {
            CApiContext cApiContext = PythonContext.get((Node)lib).getCApiContext();
            if (cApiContext != null && !lib.isNull(object)) {
                assert (value >= 0L) : "adding negative reference count; dealloc might not happen";
                try {
                    long pointer = lib.asPointer(object);
                    cApiContext.checkAccess(object, lib);
                    long refCount = CApiTransitions.readNativeRefCount(pointer);
                    CApiTransitions.writeNativeRefCount(pointer, refCount + value);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            return object;
        }
    }

    @GenerateUncached
    @GenerateCached
    @GenerateInline(value=false)
    public static abstract class PRaiseNativeNode
    extends Node {
        public final int raiseInt(Frame frame, int errorValue, PythonBuiltinClassType errType, TruffleString format, Object ... arguments) {
            return this.executeInt(frame, errorValue, errType, format, arguments);
        }

        public final <T> T raise(Frame frame, T errorValue, PythonBuiltinClassType errType, TruffleString format, Object ... arguments) {
            Object result = this.execute(frame, errorValue, errType, format, arguments);
            assert (result == errorValue);
            return errorValue;
        }

        public final int raiseIntWithoutFrame(int errorValue, PythonBuiltinClassType errType, TruffleString format, Object ... arguments) {
            return this.executeInt(null, errorValue, errType, format, arguments);
        }

        public abstract Object execute(Frame var1, Object var2, PythonBuiltinClassType var3, TruffleString var4, Object[] var5);

        public abstract int executeInt(Frame var1, int var2, PythonBuiltinClassType var3, TruffleString var4, Object[] var5);

        @Specialization
        static int doInt(Frame frame, int errorValue, PythonBuiltinClassType errType, TruffleString format, Object[] arguments, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode, @Cached.Shared(value="transformExceptionToNativeNode") @Cached TransformExceptionToNativeNode transformExceptionToNativeNode) {
            PRaiseNativeNode.raiseNative(frame, inliningTarget, errType, format, arguments, raiseNode, transformExceptionToNativeNode);
            return errorValue;
        }

        @Specialization
        static Object doObject(Frame frame, Object errorValue, PythonBuiltinClassType errType, TruffleString format, Object[] arguments, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode, @Cached.Shared(value="transformExceptionToNativeNode") @Cached TransformExceptionToNativeNode transformExceptionToNativeNode) {
            PRaiseNativeNode.raiseNative(frame, inliningTarget, errType, format, arguments, raiseNode, transformExceptionToNativeNode);
            return errorValue;
        }

        private static void raiseNative(Frame frame, Node inliningTarget, PythonBuiltinClassType errType, TruffleString format, Object[] arguments, PRaiseNode raiseNode, TransformExceptionToNativeNode transformExceptionToNativeNode) {
            try {
                throw raiseNode.raise(errType, format, arguments);
            }
            catch (PException p) {
                transformExceptionToNativeNode.execute(frame, inliningTarget, p);
                return;
            }
        }

        @GenerateInline
        @GenerateUncached
        @GenerateCached(value=false)
        public static abstract class Lazy
        extends Node {
            public final PRaiseNativeNode get(Node inliningTarget) {
                return this.execute(inliningTarget);
            }

            abstract PRaiseNativeNode execute(Node var1);

            @Specialization
            static PRaiseNativeNode doIt(@Cached(inline=false) PRaiseNativeNode node) {
                return node;
            }
        }
    }

    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    @GenerateUncached
    public static abstract class TransformExceptionToNativeNode
    extends Node {
        public abstract void execute(Frame var1, Node var2, PException var3);

        public final void execute(Node inliningTarget, PException e) {
            this.execute(null, inliningTarget, e);
        }

        public final void executeCached(PException e) {
            this.execute(null, this, e);
        }

        @Specialization
        static void setCurrentException(Frame frame, Node inliningTarget, PException e, @Cached GetCurrentFrameRef getCurrentFrameRef, @Cached PythonContext.GetThreadStateNode getThreadStateNode) {
            getCurrentFrameRef.execute(frame, inliningTarget).markAsEscaped();
            getThreadStateNode.setCurrentException(inliningTarget, e);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class LookupNativeI64MemberFromBaseNode
    extends Node {
        public final long execute(Object cls, CFields nativeMemberName, Object managedMemberName) {
            return this.execute(cls, nativeMemberName, managedMemberName, null);
        }

        public abstract long execute(Object var1, CFields var2, Object var3, Function<PythonBuiltinClassType, Integer> var4);

        @Specialization
        static long doSingleContext(Object cls, CFields nativeMember, Object managedMemberName, Function<PythonBuiltinClassType, Integer> builtinCallback, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.GetBaseClassNode getBaseClassNode, @Cached(value="createForceType()") ReadAttributeFromObjectNode readAttrNode, @Cached CStructAccess.ReadI64Node getTypeMemberNode, @Cached PyNumberAsSizeNode asSizeNode) {
            CompilerAsserts.partialEvaluationConstant(builtinCallback);
            Object current = cls;
            do {
                if (current instanceof PythonBuiltinClassType) {
                    PythonBuiltinClassType pbct = (PythonBuiltinClassType)((Object)current);
                    current = PythonContext.get(inliningTarget).lookupType(pbct);
                }
                if (builtinCallback != null && current instanceof PythonBuiltinClass) {
                    PythonBuiltinClass builtinClass = (PythonBuiltinClass)current;
                    return ((Integer)builtinCallback.apply(builtinClass.getType())).intValue();
                }
                if (PGuards.isManagedClass(current)) {
                    Object attr = readAttrNode.execute(current, managedMemberName);
                    if (attr == PNone.NO_VALUE) continue;
                    return asSizeNode.executeExact(null, inliningTarget, attr);
                }
                assert (PGuards.isNativeClass(current)) : "invalid class inheritance structure; expected native class";
                return getTypeMemberNode.readFromObj((PythonNativeClass)current, nativeMember);
            } while ((current = getBaseClassNode.execute(inliningTarget, current)) != null);
            return nativeMember == CFields.PyTypeObject__tp_basicsize || nativeMember == CFields.PyTypeObject__tp_weaklistoffset ? (long)CStructs.PyObject.size() : 0L;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class LookupNativeI64MemberInMRONode
    extends Node {
        public final long execute(Object cls, CFields nativeMemberName, Object managedMemberName) {
            return this.execute(cls, nativeMemberName, managedMemberName, null);
        }

        public abstract long execute(Object var1, CFields var2, Object var3, Function<PythonBuiltinClassType, Integer> var4);

        @Specialization
        static long doSingleContext(Object cls, CFields nativeMemberName, Object managedMemberName, Function<PythonBuiltinClassType, Integer> builtinCallback, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.GetMroStorageNode getMroNode, @Cached SequenceStorageNodes.GetItemDynamicNode getItemNode, @Cached(value="createForceType()") ReadAttributeFromObjectNode readAttrNode, @Cached CStructAccess.ReadI64Node getTypeMemberNode, @Cached PyNumberAsSizeNode asSizeNode) {
            CompilerAsserts.partialEvaluationConstant(builtinCallback);
            MroSequenceStorage mroStorage = getMroNode.execute(inliningTarget, cls);
            int n = mroStorage.length();
            for (int i = 0; i < n; ++i) {
                PythonAbstractClass mroCls = (PythonAbstractClass)getItemNode.execute(inliningTarget, mroStorage, i);
                if (builtinCallback != null && mroCls instanceof PythonBuiltinClass) {
                    PythonBuiltinClass builtinClass = (PythonBuiltinClass)mroCls;
                    return ((Integer)builtinCallback.apply(builtinClass.getType())).intValue();
                }
                if (PGuards.isManagedClass(mroCls)) {
                    Object attr = readAttrNode.execute(mroCls, managedMemberName);
                    if (attr == PNone.NO_VALUE) continue;
                    return asSizeNode.executeExact(null, inliningTarget, attr);
                }
                assert (PGuards.isNativeClass(mroCls)) : "invalid class inheritance structure; expected native class";
                return getTypeMemberNode.readFromObj((PythonNativeClass)mroCls, nativeMemberName);
            }
            return nativeMemberName == CFields.PyTypeObject__tp_basicsize || nativeMemberName == CFields.PyTypeObject__tp_weaklistoffset ? (long)CStructs.PyObject.size() : 0L;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class LookupNativeMemberInMRONode
    extends Node {
        public abstract Object execute(Object var1, CFields var2, HiddenKey var3);

        static boolean isSpecialHeapSlot(Object cls, HiddenKey key) {
            return cls instanceof PythonClass && (key == TypeBuiltins.TYPE_ALLOC || key == TypeBuiltins.TYPE_DEL);
        }

        @Specialization(guards={"!isSpecialHeapSlot(cls, managedMemberName)"})
        static Object doSingleContext(Object cls, CFields nativeMemberName, HiddenKey managedMemberName, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.GetMroStorageNode getMroNode, @Cached SequenceStorageNodes.GetItemDynamicNode getItemNode, @Cached.Shared @Cached(value="createForceType()") ReadAttributeFromObjectNode readAttrNode, @Cached CStructAccess.ReadPointerNode getTypeMemberNode, @CachedLibrary(limit="3") InteropLibrary lib) {
            MroSequenceStorage mroStorage = getMroNode.execute(inliningTarget, cls);
            int n = mroStorage.length();
            for (int i = 0; i < n; ++i) {
                Object result;
                PythonAbstractClass mroCls = (PythonAbstractClass)getItemNode.execute(inliningTarget, mroStorage, i);
                if (PGuards.isManagedClass(mroCls)) {
                    result = readAttrNode.execute(mroCls, managedMemberName);
                    if (result == PNone.NO_VALUE) continue;
                    return result;
                }
                assert (PGuards.isNativeClass(mroCls)) : "invalid class inheritance structure; expected native class";
                result = getTypeMemberNode.readFromObj((PythonNativeClass)mroCls, nativeMemberName);
                if (PGuards.isNullOrZero(result, lib)) continue;
                return result;
            }
            return readAttrNode.execute(PythonContext.get(readAttrNode).lookupType(PythonBuiltinClassType.PythonObject), managedMemberName);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object createSpecialHeapSlot(Object cls, HiddenKey managedMemberName, Node node) {
            if (managedMemberName != TypeBuiltins.TYPE_ALLOC && managedMemberName != TypeBuiltins.TYPE_DEL) {
                throw PRaiseNode.raiseUncached(node, PythonErrorType.SystemError, PythonUtils.tsLiteral("not supported yet!"));
            }
            PythonBuiltinClass object = PythonContext.get(null).lookupType(PythonBuiltinClassType.PythonObject);
            Object func = ReadAttributeFromObjectNode.getUncachedForceType().execute(object, managedMemberName);
            WriteAttributeToObjectNode.getUncached().execute(cls, managedMemberName, func);
            return func;
        }

        @Specialization(guards={"isSpecialHeapSlot(cls, managedMemberName)"})
        static Object doToAllocOrDelManaged(Object cls, CFields nativeMemberName, HiddenKey managedMemberName, @Cached.Shared @Cached(value="createForceType()") ReadAttributeFromObjectNode readAttrNode) {
            Object func = readAttrNode.execute(cls, managedMemberName);
            if (func == PNone.NO_VALUE) {
                func = LookupNativeMemberInMRONode.createSpecialHeapSlot(cls, managedMemberName, readAttrNode);
            }
            return func;
        }
    }

    @ImportStatic(value={PythonUtils.class})
    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    @GenerateUncached
    public static abstract class CastToNativeLongNode
    extends PNodeWithContext {
        public abstract long execute(Node var1, boolean var2);

        public abstract long execute(Node var1, byte var2);

        public abstract long execute(Node var1, int var2);

        public abstract long execute(Node var1, long var2);

        public abstract long execute(Node var1, double var2);

        public abstract Object execute(Node var1, Object var2);

        @Specialization(guards={"lengthNode.execute(value, TS_ENCODING) == 1"}, limit="1")
        static long doString(TruffleString value, @Cached(inline=false) TruffleString.CodePointAtIndexNode codepointAtIndexNode, @Cached(inline=false) TruffleString.CodePointLengthNode lengthNode) {
            return codepointAtIndexNode.execute((AbstractTruffleString)value, 0, PythonUtils.TS_ENCODING);
        }

        @Specialization
        static long doBoolean(boolean value) {
            return value ? 1L : 0L;
        }

        @Specialization
        static long doByte(byte value) {
            return value;
        }

        @Specialization
        static long doInt(int value) {
            return value;
        }

        @Specialization
        static long doLong(long value) {
            return value;
        }

        @Specialization
        static long doDouble(double value) {
            return (long)value;
        }

        @Specialization
        static long doPInt(PInt value) {
            return value.longValue();
        }

        @Specialization
        static long doPFloat(PFloat value) {
            return (long)value.getValue();
        }

        @Specialization
        static Object doPythonNativeVoidPtr(PythonNativeVoidPtr object) {
            return object.getPointerObject();
        }

        @Specialization(guards={"!object.isDouble()"})
        static long doLongNativeWrapper(PrimitiveNativeWrapper object) {
            return object.getLong();
        }

        @Specialization(guards={"object.isDouble()"})
        static long doDoubleNativeWrapper(PrimitiveNativeWrapper object) {
            return (long)object.getDouble();
        }

        @Specialization
        static Object run(Node inliningTarget, PythonNativeWrapper value, @Cached(inline=false) CastToNativeLongNode recursive) {
            return recursive.execute(inliningTarget, value.getDelegate());
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={SpecialMethodNames.class})
    public static abstract class AsNativeComplexNode
    extends PNodeWithContext {
        public abstract PComplex execute(Node var1, boolean var2);

        public abstract PComplex execute(Node var1, int var2);

        public abstract PComplex execute(Node var1, long var2);

        public abstract PComplex execute(Node var1, double var2);

        public abstract PComplex execute(Node var1, Object var2);

        @Specialization
        static PComplex doPComplex(PComplex value) {
            return value;
        }

        @Specialization
        static PComplex doBoolean(boolean value, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory) {
            return factory.createComplex(value ? 1.0 : 0.0, 0.0);
        }

        @Specialization
        static PComplex doInt(int value, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory) {
            return factory.createComplex(value, 0.0);
        }

        @Specialization
        static PComplex doLong(long value, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory) {
            return factory.createComplex(value, 0.0);
        }

        @Specialization
        PComplex doDouble(double value, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory) {
            return factory.createComplex(value, 0.0);
        }

        @Specialization
        static PComplex doPInt(PInt value, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory) {
            return factory.createComplex(value.doubleValue(), 0.0);
        }

        @Specialization
        static PComplex doPFloat(PFloat value, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory) {
            return factory.createComplex(value.getValue(), 0.0);
        }

        @Specialization(replaces={"doPComplex", "doBoolean", "doInt", "doLong", "doDouble", "doPInt", "doPFloat"})
        static PComplex runGeneric(Node inliningTarget, Object value, @Cached PyFloatAsDoubleNode asDoubleNode, @Cached(inline=false) LookupAndCallUnaryNode.LookupAndCallUnaryDynamicNode callComplex, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            Object result = callComplex.executeObject(value, SpecialMethodNames.T___COMPLEX__);
            if (result != PNone.NO_VALUE) {
                if (result instanceof PComplex) {
                    return (PComplex)result;
                }
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.COMPLEX_RETURNED_NON_COMPLEX, value);
            }
            return factory.createComplex(asDoubleNode.execute(null, inliningTarget, value), 0.0);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class PointerCompareNode
    extends Node {
        public abstract boolean execute(TruffleString var1, Object var2, Object var3);

        private static boolean executeCFunction(Node inliningTarget, int op, Object a, Object b, InteropLibrary interopLibrary, CExtCommonNodes.ImportCExtSymbolNode importCAPISymbolNode) {
            try {
                Object sym = importCAPISymbolNode.execute(inliningTarget, PythonContext.get(inliningTarget).getCApiContext(), NativeCAPISymbol.FUN_PTR_COMPARE);
                return (Integer)interopLibrary.execute(sym, new Object[]{a, b, op}) != 0;
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException(String.valueOf(NativeCAPISymbol.FUN_PTR_COMPARE) + " didn't work!");
            }
        }

        @Specialization(guards={"isEq(opName, equalNode)"}, limit="2")
        static boolean doEq(TruffleString opName, PythonAbstractNativeObject a, PythonAbstractNativeObject b, @CachedLibrary(value="a") InteropLibrary aLib, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary bLib, @Cached.Shared @Cached TruffleString.EqualNode equalNode) {
            return aLib.isIdentical((Object)a, (Object)b, bLib);
        }

        @Specialization(guards={"isNe(opName, equalNode)"}, limit="2")
        static boolean doNe(TruffleString opName, PythonAbstractNativeObject a, PythonAbstractNativeObject b, @CachedLibrary(value="a") InteropLibrary aLib, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary bLib, @Cached.Shared @Cached TruffleString.EqualNode equalNode) {
            return !aLib.isIdentical((Object)a, (Object)b, bLib);
        }

        @Specialization(guards={"areEqual(cachedOpName, opName, equalNode)"})
        static boolean doPythonNativeObject(TruffleString opName, PythonNativeObject a, PythonNativeObject b, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached TruffleString.EqualNode equalNode, @Cached.Shared @Cached(value="opName", neverDefault=true) TruffleString cachedOpName, @Cached(value="findOp(opName, equalNode)", allowUncached=true, neverDefault=false) int op, @Cached.Shared @CachedLibrary(limit="1") InteropLibrary interopLibrary, @Cached.Shared @Cached CExtCommonNodes.ImportCExtSymbolNode importCAPISymbolNode) {
            return PointerCompareNode.executeCFunction(inliningTarget, op, a.getPtr(), b.getPtr(), interopLibrary, importCAPISymbolNode);
        }

        @Specialization(guards={"areEqual(cachedOpName, opName, equalNode)"})
        static boolean doPythonNativeObjectLong(TruffleString opName, PythonNativeObject a, long b, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached TruffleString.EqualNode equalNode, @Cached.Shared @Cached(value="opName", neverDefault=true) TruffleString cachedOpName, @Cached(value="findOp(opName, equalNode)", allowUncached=true, neverDefault=false) int op, @Cached.Shared @CachedLibrary(limit="1") InteropLibrary interopLibrary, @Cached.Shared @Cached CExtCommonNodes.ImportCExtSymbolNode importCAPISymbolNode) {
            return PointerCompareNode.executeCFunction(inliningTarget, op, a.getPtr(), b, interopLibrary, importCAPISymbolNode);
        }

        @Specialization(guards={"areEqual(cachedOpName, opName, equalNode)"})
        static boolean doNativeVoidPtrLong(TruffleString opName, PythonNativeVoidPtr a, long b, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached TruffleString.EqualNode equalNode, @Cached.Shared @Cached(value="opName", neverDefault=true) TruffleString cachedOpName, @Cached(value="findOp(opName, equalNode)", allowUncached=true, neverDefault=false) int op, @Cached.Shared @CachedLibrary(limit="1") InteropLibrary interopLibrary, @Cached.Shared @Cached CExtCommonNodes.ImportCExtSymbolNode importCAPISymbolNode) {
            return PointerCompareNode.executeCFunction(inliningTarget, op, a.getPointerObject(), b, interopLibrary, importCAPISymbolNode);
        }

        static int findOp(TruffleString specialMethodName, TruffleString.EqualNode equalNode) {
            for (int i = 0; i < SpecialMethodNames.COMPARE_OP_COUNT; ++i) {
                if (!equalNode.execute((AbstractTruffleString)SpecialMethodNames.getCompareName(i), (AbstractTruffleString)specialMethodName, PythonUtils.TS_ENCODING)) continue;
                return i;
            }
            throw new RuntimeException("The special method used for Python C API pointer comparison must be a constant literal (i.e., interned) string");
        }

        static boolean areEqual(TruffleString cachedOpName, TruffleString opName, TruffleString.EqualNode equalNode) {
            return equalNode.execute((AbstractTruffleString)cachedOpName, (AbstractTruffleString)opName, PythonUtils.TS_ENCODING);
        }

        static boolean isEq(TruffleString opName, TruffleString.EqualNode equalNode) {
            return equalNode.execute((AbstractTruffleString)SpecialMethodNames.T___EQ__, (AbstractTruffleString)opName, PythonUtils.TS_ENCODING);
        }

        static boolean isNe(TruffleString opName, TruffleString.EqualNode equalNode) {
            return equalNode.execute((AbstractTruffleString)SpecialMethodNames.T___NE__, (AbstractTruffleString)opName, PythonUtils.TS_ENCODING);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class GetNativeClassNode
    extends PNodeWithContext {
        public abstract Object execute(Node var1, PythonAbstractNativeObject var2);

        @Specialization
        static Object getNativeClass(Node inliningTarget, PythonAbstractNativeObject object, @Cached(inline=false) CStructAccess.ReadObjectNode callGetObTypeNode, @Cached TypeNodes.ProfileClassNode classProfile) {
            return classProfile.profile(inliningTarget, callGetObTypeNode.readFromObj(object, CFields.PyObject__ob_type));
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class FromCharPointerNode
    extends Node {
        public final TruffleString execute(Object charPtr) {
            return this.execute(charPtr, true);
        }

        public abstract TruffleString execute(Object var1, boolean var2);

        @Specialization
        static TruffleString doCStringWrapper(CArrayWrappers.CStringWrapper cStringWrapper, boolean copy) {
            return cStringWrapper.getString();
        }

        @Specialization
        static TruffleString doCByteArrayWrapper(CArrayWrappers.CByteArrayWrapper cByteArrayWrapper, boolean copy, @Cached.Shared @Cached TruffleString.FromByteArrayNode fromBytes, @Cached.Shared(value="switchEncoding") @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            CompilerAsserts.partialEvaluationConstant((boolean)copy);
            byte[] byteArray = cByteArrayWrapper.getByteArray();
            return switchEncodingNode.execute((AbstractTruffleString)fromBytes.execute(byteArray, 0, byteArray.length, TruffleString.Encoding.UTF_8, copy), PythonUtils.TS_ENCODING);
        }

        @Specialization(guards={"!isCArrayWrapper(charPtr)"}, limit="3")
        static TruffleString doPointer(Object charPtr, boolean copy, @Cached CStructAccess.ReadByteNode read, @CachedLibrary(value="charPtr") InteropLibrary lib, @Cached TruffleString.FromNativePointerNode fromNative, @Cached.Shared @Cached TruffleString.FromByteArrayNode fromBytes, @Cached.Shared(value="switchEncoding") @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            int length = 0;
            while (read.readArrayElement(charPtr, length) != 0) {
                ++length;
            }
            if (lib.isPointer(charPtr)) {
                return switchEncodingNode.execute((AbstractTruffleString)fromNative.execute(charPtr, 0, length, TruffleString.Encoding.UTF_8, copy), PythonUtils.TS_ENCODING);
            }
            byte[] result = read.readByteArray(charPtr, length);
            return switchEncodingNode.execute((AbstractTruffleString)fromBytes.execute(result, TruffleString.Encoding.UTF_8, false), PythonUtils.TS_ENCODING);
        }

        static boolean isCArrayWrapper(Object object) {
            return object instanceof CArrayWrappers.CArrayWrapper || object instanceof PySequenceArrayWrapper;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class AsCharPointerNode
    extends Node {
        public abstract Object execute(Object var1, boolean var2);

        public final Object execute(Object obj) {
            return this.execute(obj, false);
        }

        @Specialization
        static Object doPString(PString str, boolean allocatePyMem, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castToStringNode, @Cached.Shared @Cached TruffleString.CopyToByteArrayNode toBytes, @Cached.Shared @Cached TruffleString.SwitchEncodingNode switchEncoding, @Cached.Shared @Cached CStructAccess.AllocateNode alloc, @Cached.Shared @Cached CStructAccess.WriteByteNode write) {
            TruffleString value = castToStringNode.execute(inliningTarget, str);
            byte[] bytes = toBytes.execute((AbstractTruffleString)switchEncoding.execute((AbstractTruffleString)value, TruffleString.Encoding.UTF_8), TruffleString.Encoding.UTF_8);
            Object mem = alloc.alloc(bytes.length + 1, allocatePyMem);
            write.writeByteArray(mem, bytes);
            return mem;
        }

        @Specialization
        static Object doString(TruffleString str, boolean allocatePyMem, @Cached.Shared @Cached TruffleString.CopyToByteArrayNode toBytes, @Cached.Shared @Cached TruffleString.SwitchEncodingNode switchEncoding, @Cached.Shared @Cached CStructAccess.AllocateNode alloc, @Cached.Shared @Cached CStructAccess.WriteByteNode write) {
            byte[] bytes = toBytes.execute((AbstractTruffleString)switchEncoding.execute((AbstractTruffleString)str, TruffleString.Encoding.UTF_8), TruffleString.Encoding.UTF_8);
            Object mem = alloc.alloc(bytes.length + 1, allocatePyMem);
            write.writeByteArray(mem, bytes);
            return mem;
        }

        @Specialization
        static Object doBytes(PBytes bytes, boolean allocatePyMem, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SequenceStorageNodes.ToByteArrayNode toBytesNode, @Cached.Shared @Cached CStructAccess.AllocateNode alloc, @Cached.Shared @Cached CStructAccess.WriteByteNode write) {
            return AsCharPointerNode.doByteArray(toBytesNode.execute(inliningTarget, bytes.getSequenceStorage()), allocatePyMem, alloc, write);
        }

        @Specialization
        static Object doBytes(PByteArray bytes, boolean allocatePyMem, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SequenceStorageNodes.ToByteArrayNode toBytesNode, @Cached.Shared @Cached CStructAccess.AllocateNode alloc, @Cached.Shared @Cached CStructAccess.WriteByteNode write) {
            return AsCharPointerNode.doByteArray(toBytesNode.execute(inliningTarget, bytes.getSequenceStorage()), allocatePyMem, alloc, write);
        }

        @Specialization
        static Object doByteArray(byte[] arr, boolean allocatePyMem, @Cached.Shared @Cached CStructAccess.AllocateNode alloc, @Cached.Shared @Cached CStructAccess.WriteByteNode write) {
            Object mem = alloc.alloc(arr.length + 1, allocatePyMem);
            write.writeByteArray(mem, arr);
            return mem;
        }

        public static AsCharPointerNode getUncached() {
            return CExtNodesFactory.AsCharPointerNodeGen.getUncached();
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={CApiGuards.class})
    public static abstract class MaterializeDelegateNode
    extends Node {
        public abstract Object execute(Node var1, PythonNativeWrapper var2);

        @Specialization(guards={"!isMaterialized(object)", "object.isBool()"})
        static PInt doBoolNativeWrapper(Node inliningTarget, PrimitiveNativeWrapper object) {
            PythonContext core = PythonContext.get(inliningTarget);
            PInt materializedInt = object.getBool() ? core.getTrue() : core.getFalse();
            object.setMaterializedObject(materializedInt);
            if (materializedInt.getNativeWrapper() != null) {
                object.setNativePointer(materializedInt.getNativeWrapper().getNativePointer());
            } else {
                materializedInt.setNativeWrapper(object);
            }
            return materializedInt;
        }

        @Specialization(guards={"!isMaterialized(object)", "object.isInt()"})
        static PInt doIntNativeWrapper(PrimitiveNativeWrapper object, @Cached.Shared(value="factory") @Cached(inline=false) PythonObjectFactory factory) {
            PInt materializedInt = factory.createInt(object.getInt());
            object.setMaterializedObject(materializedInt);
            materializedInt.setNativeWrapper(object);
            return materializedInt;
        }

        @Specialization(guards={"!isMaterialized(object)", "object.isLong()"})
        static PInt doLongNativeWrapper(PrimitiveNativeWrapper object, @Cached.Shared(value="factory") @Cached(inline=false) PythonObjectFactory factory) {
            PInt materializedInt = factory.createInt(object.getLong());
            object.setMaterializedObject(materializedInt);
            materializedInt.setNativeWrapper(object);
            return materializedInt;
        }

        @Specialization(guards={"!isMaterialized(object)", "object.isDouble()", "!isNaN(object)"})
        static PFloat doDoubleNativeWrapper(PrimitiveNativeWrapper object, @Cached.Shared(value="factory") @Cached(inline=false) PythonObjectFactory factory) {
            PFloat materializedInt = factory.createFloat(object.getDouble());
            materializedInt.setNativeWrapper(object);
            object.setMaterializedObject(materializedInt);
            return materializedInt;
        }

        @Specialization(guards={"!isMaterialized(object)", "object.isDouble()", "isNaN(object)"})
        static PFloat doDoubleNativeWrapperNaN(Node inliningTarget, PrimitiveNativeWrapper object) {
            PFloat materializedFloat = PythonContext.get(inliningTarget).getNaN();
            object.setMaterializedObject(materializedFloat);
            if (materializedFloat.getNativeWrapper() != null) {
                object.setNativePointer(materializedFloat.getNativeWrapper().getNativePointer());
            } else {
                materializedFloat.setNativeWrapper(object);
            }
            return materializedFloat;
        }

        @Specialization(guards={"isMaterialized(object)"})
        static Object doMaterialized(PrimitiveNativeWrapper object) {
            return object.getDelegate();
        }

        @Specialization(guards={"!isPrimitiveNativeWrapper(object)"})
        static Object doNativeWrapperGeneric(PythonNativeWrapper object) {
            return object.getDelegate();
        }

        protected static boolean isPrimitiveNativeWrapper(PythonNativeWrapper object) {
            return object instanceof PrimitiveNativeWrapper;
        }

        protected static boolean isNaN(PrimitiveNativeWrapper object) {
            assert (object.isDouble());
            return Double.isNaN(object.getDouble());
        }

        static boolean isMaterialized(PrimitiveNativeWrapper wrapper) {
            return wrapper.getDelegate() != null;
        }
    }

    @GenerateInline(value=false)
    public static abstract class FromNativeSubclassNode
    extends Node {
        public abstract Double execute(VirtualFrame var1, PythonAbstractNativeObject var2);

        @Specialization
        static Double doDouble(VirtualFrame frame, PythonAbstractNativeObject object, @Bind(value="this") Node inliningTarget, @Cached GetClassNode.GetPythonObjectClassNode getClass, @Cached IsSubtypeNode isSubtype, @Cached CStructAccess.ReadDoubleNode read) {
            if (FromNativeSubclassNode.isFloatSubtype(frame, inliningTarget, object, getClass, isSubtype)) {
                return read.readFromObj(object, CFields.PyFloatObject__ob_fval);
            }
            return null;
        }

        public static boolean isFloatSubtype(VirtualFrame frame, Node inliningTarget, Object object, GetClassNode getClass, IsSubtypeNode isSubtype) {
            return isSubtype.execute(frame, getClass.execute(inliningTarget, object), (Object)PythonBuiltinClassType.PFloat);
        }

        public static boolean isFloatSubtype(VirtualFrame frame, Node inliningTarget, PythonAbstractNativeObject object, GetClassNode.GetPythonObjectClassNode getClass, IsSubtypeNode isSubtype) {
            return isSubtype.execute(frame, getClass.execute(inliningTarget, object), (Object)PythonBuiltinClassType.PFloat);
        }

        @NeverDefault
        public static FromNativeSubclassNode create() {
            return CExtNodesFactory.FromNativeSubclassNodeGen.create();
        }
    }

    public static abstract class StringSubtypeNew
    extends SubtypeNew {
        private static final NativeCAPISymbol NEW_FUNCTION = StringSubtypeNew.getFunction("unicode");
        @Node.Child
        private CApiTransitions.PythonToNativeNode toSulongNode;

        @Override
        protected final NativeCAPISymbol getFunction() {
            return NEW_FUNCTION;
        }

        public final Object call(Object object, Object arg) {
            if (this.toSulongNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toSulongNode = (CApiTransitions.PythonToNativeNode)this.insert(CApiTransitionsFactory.PythonToNativeNodeGen.create());
            }
            return this.execute(object, this.toSulongNode.execute(arg));
        }

        public static StringSubtypeNew create() {
            return CExtNodesFactory.StringSubtypeNewNodeGen.create();
        }
    }

    public static abstract class TupleSubtypeNew
    extends SubtypeNew {
        private static final NativeCAPISymbol NEW_FUNCTION = TupleSubtypeNew.getFunction("tuple");
        @Node.Child
        private CApiTransitions.PythonToNativeNode toSulongNode;

        @Override
        protected final NativeCAPISymbol getFunction() {
            return NEW_FUNCTION;
        }

        public final Object call(Object object, Object arg) {
            if (this.toSulongNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toSulongNode = (CApiTransitions.PythonToNativeNode)this.insert(CApiTransitionsFactory.PythonToNativeNodeGen.create());
            }
            return this.execute(object, this.toSulongNode.execute(arg));
        }

        @NeverDefault
        public static TupleSubtypeNew create() {
            return CExtNodesFactory.TupleSubtypeNewNodeGen.create();
        }
    }

    @GenerateInline(value=false)
    public static abstract class FloatSubtypeNew
    extends SubtypeNew {
        private static final NativeCAPISymbol NEW_FUNCTION = FloatSubtypeNew.getFunction("float");

        @Override
        protected final NativeCAPISymbol getFunction() {
            return NEW_FUNCTION;
        }

        public final Object call(Object object, double arg) {
            return this.execute(object, arg);
        }

        public static FloatSubtypeNew create() {
            return CExtNodesFactory.FloatSubtypeNewNodeGen.create();
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateInline(value=false)
    public static abstract class SubtypeNew
    extends Node {
        protected NativeCAPISymbol getFunction() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        protected abstract Object execute(Object var1, Object var2);

        protected static NativeCAPISymbol getFunction(String typenamePrefix) {
            CompilerAsserts.neverPartOfCompilation();
            String subtypeNewFunctionName = typenamePrefix + CExtNodes.J_SUBTYPE_NEW;
            NativeCAPISymbol result = NativeCAPISymbol.getByName(subtypeNewFunctionName);
            assert (result != null) : "SubtypeNew function not found: " + subtypeNewFunctionName;
            return result;
        }

        @Specialization
        Object callNativeConstructor(Object object, Object arg, @Bind(value="this") Node inliningTarget, @Cached CApiTransitions.PythonToNativeNode toSulongNode, @Cached CApiTransitions.NativeToPythonNode toJavaNode, @CachedLibrary(limit="1") InteropLibrary interopLibrary, @Cached CExtCommonNodes.ImportCExtSymbolNode importCAPISymbolNode) {
            assert (TypeNodes.NeedsNativeAllocationNode.executeUncached(object));
            try {
                CApiContext cApiContext = PythonContext.get(inliningTarget).getCApiContext();
                Object result = interopLibrary.execute(importCAPISymbolNode.execute(inliningTarget, cApiContext, this.getFunction()), new Object[]{toSulongNode.execute(object), arg});
                return toJavaNode.execute(result);
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw CompilerDirectives.shouldNotReachHere((String)"C subtype_new function failed", (Throwable)e);
            }
        }
    }
}

