/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.ToNativeTypeNode;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccessFactory;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.TypeBuiltins;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.TypeNodesFactory;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.strings.TruffleString;

@ExportLibrary(value=InteropLibrary.class)
public final class PythonClassNativeWrapper
extends PythonNativeWrapper.PythonAbstractObjectNativeWrapper {
    private final CArrayWrappers.CStringWrapper nameWrapper;

    private PythonClassNativeWrapper(PythonManagedClass object, TruffleString name) {
        super(object, true);
        this.nameWrapper = new CArrayWrappers.CStringWrapper(name);
    }

    public CArrayWrappers.CStringWrapper getNameWrapper() {
        return this.nameWrapper;
    }

    public static PythonClassNativeWrapper wrap(PythonManagedClass obj, TruffleString name) {
        PythonClassNativeWrapper nativeWrapper = obj.getClassNativeWrapper();
        if (nativeWrapper == null) {
            nativeWrapper = new PythonClassNativeWrapper(obj, name);
            obj.setNativeWrapper(nativeWrapper);
        }
        return nativeWrapper;
    }

    public static void wrapNative(PythonManagedClass clazz, TruffleString name, Object pointer) {
        Object as_buffer;
        Object clear_fun;
        Object free_fun;
        Object dealloc_fun;
        Object alloc_fun;
        long vectorcall_offset;
        long itemsize;
        if (clazz.getNativeWrapper() != null) {
            throw CompilerDirectives.shouldNotReachHere();
        }
        PythonClassNativeWrapper wrapper = new PythonClassNativeWrapper(clazz, name);
        clazz.setNativeWrapper(wrapper);
        CStructAccess.ReadI64Node readI64 = CStructAccess.ReadI64Node.getUncached();
        CStructAccess.ReadPointerNode readPointer = CStructAccess.ReadPointerNode.getUncached();
        WriteAttributeToObjectNode writeAttr = WriteAttributeToObjectNode.getUncached();
        InteropLibrary lib = InteropLibrary.getUncached();
        long basicsize = readI64.read(pointer, CFields.PyTypeObject__tp_basicsize);
        if (basicsize != 0L) {
            TypeNodesFactory.SetBasicSizeNodeGen.getUncached().execute(null, clazz, basicsize);
        }
        if ((itemsize = readI64.read(pointer, CFields.PyTypeObject__tp_itemsize)) != 0L) {
            TypeNodesFactory.SetItemSizeNodeGen.getUncached().execute(null, clazz, itemsize);
        }
        if ((vectorcall_offset = readI64.read(pointer, CFields.PyTypeObject__tp_vectorcall_offset)) != 0L) {
            writeAttr.execute((Object)clazz, TypeBuiltins.TYPE_VECTORCALL_OFFSET, (Object)vectorcall_offset);
        }
        if (!PGuards.isNullOrZero(alloc_fun = readPointer.read(pointer, CFields.PyTypeObject__tp_alloc), lib)) {
            writeAttr.execute((Object)clazz, TypeBuiltins.TYPE_ALLOC, alloc_fun);
        }
        if (!PGuards.isNullOrZero(dealloc_fun = readPointer.read(pointer, CFields.PyTypeObject__tp_dealloc), lib)) {
            writeAttr.execute((Object)clazz, TypeBuiltins.TYPE_DEALLOC, dealloc_fun);
        }
        if (!PGuards.isNullOrZero(free_fun = readPointer.read(pointer, CFields.PyTypeObject__tp_free), lib)) {
            writeAttr.execute((Object)clazz, TypeBuiltins.TYPE_FREE, free_fun);
        }
        if (!PGuards.isNullOrZero(clear_fun = readPointer.read(pointer, CFields.PyTypeObject__tp_clear), lib)) {
            writeAttr.execute((Object)clazz, TypeBuiltins.TYPE_CLEAR, clear_fun);
        }
        if (!PGuards.isNullOrZero(as_buffer = readPointer.read(pointer, CFields.PyTypeObject__tp_as_buffer), lib)) {
            writeAttr.execute((Object)clazz, TypeBuiltins.TYPE_AS_BUFFER, as_buffer);
        }
        long flags = TypeNodes.GetTypeFlagsNode.getUncached().execute(clazz);
        TypeNodes.SetTypeFlagsNode.executeUncached(clazz, flags |= 0x1100L);
        wrapper.replacement = pointer;
        wrapper.registerReplacement(pointer, lib);
    }

    public static void initNative(PythonManagedClass clazz, Object pointer) {
        PythonClassNativeWrapper classNativeWrapper = clazz.getClassNativeWrapper();
        if (classNativeWrapper == null) {
            throw CompilerDirectives.shouldNotReachHere();
        }
        ToNativeTypeNode.initializeType(classNativeWrapper, pointer);
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return PythonUtils.formatJString("PythonClassNativeWrapper(%s, isNative=%s)", this.getDelegate(), this.isNative());
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getReplacement(InteropLibrary lib) {
        if (this.replacement == null) {
            Object pointerObject = CStructAccessFactory.AllocateNodeGen.getUncached().alloc(CStructs.PyTypeObject);
            this.replacement = this.registerReplacement(pointerObject, lib);
            ToNativeTypeNode.initializeType(this, pointerObject);
        }
        return this.replacement;
    }

    @ExportMessage
    boolean isPointer() {
        return this.isNative();
    }

    @ExportMessage
    long asPointer() throws UnsupportedMessageException {
        if (!this.isNative()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnsupportedMessageException.create();
        }
        return this.getNativePointer();
    }

    @ExportMessage
    void toNative() {
        if (!this.isNative()) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }
}

