/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi.transitions;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.nativeimage.ImageInfo;

public final class CApiTiming {
    private static final int PROFILE_CALL_INTERVAL = Integer.getInteger("python.CAPITiming", 0);
    private static final int INITIAL_STACK = 100;
    private static final double CUTOFF_TIME = 0.95;
    private static final double CUTOFF_COUNT = 0.95;
    private static final ThreadLocal<TimingStack> STACK = ThreadLocal.withInitial(TimingStack::new);
    private static final ArrayList<CApiTiming> TIMINGS = new ArrayList();
    private final String name;
    private final boolean fromJava;
    private long time;
    private long count;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CApiTiming(boolean fromJava, String name) {
        this.fromJava = fromJava;
        this.name = name;
        ArrayList<CApiTiming> arrayList = TIMINGS;
        synchronized (arrayList) {
            TIMINGS.add(this);
        }
    }

    public static CApiTiming create(boolean fromJava, Object delegate) {
        return PROFILE_CALL_INTERVAL == 0 ? null : new CApiTiming(fromJava, String.valueOf(delegate) + (fromJava ? " J->N" : " N->J"));
    }

    private static void dumpCallStatistics() {
        ArrayList<CApiTiming> sorted = new ArrayList<CApiTiming>(TIMINGS);
        sorted.sort((a, b) -> Boolean.compare(a.fromJava, b.fromJava) * 100 + a.name.compareTo(b.name));
        System.out.println("======================================================================");
        System.out.printf("%70s  %8s %10s\n", "Name:", "Count:", "Time:");
        long totalCount = sorted.stream().collect(Collectors.summingLong(e -> e.count));
        long totalTime = sorted.stream().collect(Collectors.summingLong(e -> e.time));
        long cutoffTime = CApiTiming.getCutoff(totalTime, sorted.stream().map(e -> e.time));
        long cutoffCount = CApiTiming.getCutoff(totalCount, sorted.stream().map(e -> e.count));
        long percent = totalTime / 100L;
        long visibleCount = 0L;
        long visibleTime = 0L;
        for (CApiTiming e2 : sorted) {
            if (e2.time < cutoffTime && e2.count < cutoffCount) continue;
            System.out.printf("%70s  %8s %8sms %s\n", e2.name, e2.count, e2.time / 1000000L, CApiTiming.stars(percent, e2.time));
            visibleCount += e2.count;
            visibleTime += e2.time;
        }
        System.out.printf("%70s  %8s %8sms %s\n", "Others:", totalCount - visibleCount, (totalTime - visibleTime) / 1000000L, CApiTiming.stars(percent, totalTime - visibleTime));
        System.out.println("----------------------------------------------------------------------");
        System.out.printf("%70s  %8s %8sms\n", "Total:", totalCount, totalTime / 1000000L);
        System.out.printf("%70s  %8s %8sms)\n", "(cutoff:", cutoffCount, cutoffTime / 1000000L);
        System.out.println();
    }

    private static long getCutoff(long total, Stream<Long> values) {
        ArrayList<Long> sorted = new ArrayList<Long>(values.toList());
        sorted.sort(Long::compare);
        long accountedTime = 0L;
        long cutoffTime = 0L;
        for (int i = sorted.size() - 1; i >= 0; --i) {
            if (!((double)accountedTime <= (double)total * 0.95)) continue;
            cutoffTime = sorted.get(i);
            accountedTime += cutoffTime;
        }
        return cutoffTime;
    }

    private static String stars(long percent, long time) {
        if (percent <= 0L || percent > 100L) {
            return "";
        }
        String STARS = "****************************************************************************************************";
        int value = (int)((time + percent / 2L) / percent);
        return String.format("%2d", value) + "% " + STARS.substring(0, value);
    }

    public static void enter() {
        if (PROFILE_CALL_INTERVAL != 0) {
            CApiTiming.enterInternal();
        }
    }

    public static void exit(CApiTiming t) {
        if (PROFILE_CALL_INTERVAL != 0) {
            CApiTiming.exitInternal(t);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void enterInternal() {
        TimingStack stack = STACK.get();
        if (stack.sp >= stack.startTimes.length) {
            int newSize = stack.startTimes.length * 2;
            stack.subTimes = Arrays.copyOf(stack.subTimes, newSize);
            stack.startTimes = Arrays.copyOf(stack.startTimes, newSize);
        }
        stack.subTimes[stack.sp] = 0L;
        stack.startTimes[stack.sp++] = System.nanoTime();
    }

    @CompilerDirectives.TruffleBoundary
    private static void exitInternal(CApiTiming t) {
        TimingStack stack = STACK.get();
        long startTime = stack.startTimes[--stack.sp];
        long delta = System.nanoTime() - startTime;
        t.time += delta - stack.subTimes[stack.sp];
        if (stack.sp > 0) {
            int n = stack.sp - 1;
            stack.subTimes[n] = stack.subTimes[n] + delta;
        }
        ++t.count;
    }

    static {
        if (PROFILE_CALL_INTERVAL != 0 && !ImageInfo.inImageBuildtimeCode()) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(PROFILE_CALL_INTERVAL);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ArrayList<CApiTiming> arrayList = TIMINGS;
                        synchronized (arrayList) {
                            CApiTiming.dumpCallStatistics();
                        }
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    CApiTiming.dumpCallStatistics();
                }
            });
        }
    }

    private static final class TimingStack {
        long[] subTimes = new long[101];
        long[] startTimes = new long[100];
        int sp;

        private TimingStack() {
        }
    }
}

