/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy.jni;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.capsule.PyCapsule;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.common.CExtContext;
import com.oracle.graal.python.builtins.objects.cext.common.LoadCExtException;
import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyBoxing;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyCAccess;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyCField;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContextFunctions;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyData;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyDef;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyHandle;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNativeContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodes;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyContextMember;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyContextSignature;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyContextSignatureType;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyMode;
import com.oracle.graal.python.builtins.objects.cext.hpy.jni.GraalHPyJNICallHelperFunctionNode;
import com.oracle.graal.python.builtins.objects.cext.hpy.jni.GraalHPyJNINodes;
import com.oracle.graal.python.builtins.objects.cext.hpy.jni.GraalHPyJNINodesFactory;
import com.oracle.graal.python.builtins.objects.cext.hpy.jni.GraalHPyJNITrampolines;
import com.oracle.graal.python.builtins.objects.common.EconomicMapStorage;
import com.oracle.graal.python.builtins.objects.common.EmptyStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVar;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.ellipsis.PEllipsis;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.CanBeDoubleNode;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyLongAsDoubleNode;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectSetItem;
import com.oracle.graal.python.lib.PyObjectSizeNodeGen;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.CallTernaryMethodNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNodeGen;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.nodes.object.IsNodeGen;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectSlowPathFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.DoubleSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.IntSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.LongSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.NativeAllocator;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.graalvm.nativeimage.ImageInfo;

@ExportLibrary(value=InteropLibrary.class)
public final class GraalHPyJNIContext
extends GraalHPyNativeContext {
    private static final String J_NAME = "HPy Universal ABI (GraalVM JNI backend)";
    private static final TruffleLogger LOGGER = GraalHPyContext.getLogger(GraalHPyJNIContext.class);
    static final NativeAllocator TS_NATIVE_ALLOCATOR = byteSize -> new NativePointer(CArrayWrappers.UNSAFE.allocateMemory(byteSize));
    private static boolean jniBackendLoaded = false;
    private final PythonObjectSlowPathFactory slowPathFactory;
    private final int[] counts;
    private final int[] ctypeSizes;
    private final int[] cfieldOffsets;
    private long hPyDebugContext;
    private long hPyTraceContext;
    private long nativePointer;
    private final List<Object> loadedExtensions = new LinkedList<Object>();

    public GraalHPyJNIContext(GraalHPyContext context, boolean traceUpcalls) {
        super(context, traceUpcalls);
        assert (!PythonOptions.WITHOUT_JNI);
        this.slowPathFactory = context.getContext().factory();
        this.counts = traceUpcalls ? new int[HPyJNIUpcall.VALUES.length] : null;
        this.ctypeSizes = new int[HPyContextSignatureType.values().length];
        this.cfieldOffsets = new int[GraalHPyCField.values().length];
    }

    @Override
    protected String getName() {
        return J_NAME;
    }

    @Override
    protected Object loadExtensionLibrary(Node location, PythonContext context, TruffleString name, TruffleString path) throws LoadCExtException.ImportException {
        CompilerAsserts.neverPartOfCompilation();
        TruffleFile extLibFile = context.getPublicTruffleFileRelaxed(path, context.getSoAbi());
        try {
            String src = "load \"" + String.valueOf(extLibFile) + "\"";
            Source loadSrc = Source.newBuilder((String)"nfi", (CharSequence)src, (String)("load:" + String.valueOf(name))).internal(true).build();
            Object extLib = context.getEnv().parseInternal(loadSrc, new String[0]).call(new Object[0]);
            this.loadedExtensions.add(extLib);
            return extLib;
        }
        catch (SecurityException e) {
            throw new LoadCExtException.ImportException(CExtContext.wrapJavaException(e, location), name, path, ErrorMessages.CANNOT_LOAD_M, path, e);
        }
    }

    @Override
    protected GraalHPyContext.HPyABIVersion getHPyABIVersion(Object extLib, String getMajorVersionFuncName, String getMinorVersionFuncName) throws UnknownIdentifierException {
        CompilerAsserts.neverPartOfCompilation();
        try {
            InteropLibrary lib = InteropLibrary.getUncached((Object)extLib);
            Object majorVersionFun = lib.readMember(extLib, getMajorVersionFuncName);
            Object minorVersionFun = lib.readMember(extLib, getMinorVersionFuncName);
            int requiredMajorVersion = (int)GraalHPyJNITrampolines.executeModuleInit(GraalHPyJNIContext.coerceToPointer(majorVersionFun));
            int requiredMinorVersion = (int)GraalHPyJNITrampolines.executeModuleInit(GraalHPyJNIContext.coerceToPointer(minorVersionFun));
            return new GraalHPyContext.HPyABIVersion(requiredMajorVersion, requiredMinorVersion);
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    @Override
    protected Object initHPyModule(Object extLib, String initFuncName, TruffleString name, TruffleString path, HPyMode mode) throws LoadCExtException.ImportException, LoadCExtException.ApiInitException {
        Object initFunction;
        CompilerAsserts.neverPartOfCompilation();
        if (Objects.requireNonNull(mode) == HPyMode.MODE_DEBUG) {
            this.initHPyDebugContext();
        } else if (mode == HPyMode.MODE_TRACE) {
            this.initHPyTraceContext();
        }
        try {
            InteropLibrary lib = InteropLibrary.getUncached((Object)extLib);
            initFunction = lib.readMember(extLib, initFuncName);
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e1) {
            throw new LoadCExtException.ImportException(null, name, path, ErrorMessages.CANNOT_INITIALIZE_EXT_NO_ENTRY, name, path, initFuncName);
        }
        assert (!InteropLibrary.getUncached().isExecutable(initFunction));
        long moduleDefPtr = GraalHPyJNITrampolines.executeModuleInit(GraalHPyJNIContext.coerceToPointer(initFunction));
        return this.convertLongArg(HPyContextSignatureType.HPyModuleDefPtr, moduleDefPtr);
    }

    @Override
    protected GraalHPyContext.HPyUpcall[] getUpcalls() {
        return HPyJNIUpcall.VALUES;
    }

    @Override
    protected int[] getUpcallCounts() {
        return this.counts;
    }

    @Override
    protected int getCTypeSize(HPyContextSignatureType ctype) {
        return this.ctypeSizes[ctype.ordinal()];
    }

    @Override
    protected int getCFieldOffset(GraalHPyCField cfield) {
        return this.cfieldOffsets[cfield.ordinal()];
    }

    @Override
    protected NativePointer nativeToInteropPointer(Object object) {
        assert (object instanceof Long);
        return new NativePointer((Long)object);
    }

    static long interopPointerToNative(Object object, InteropLibrary lib) {
        if (!lib.isPointer(object)) {
            lib.toNative(object);
        }
        try {
            return lib.asPointer(object);
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @Override
    protected Object getNativeNull() {
        return 0L;
    }

    @ExportMessage
    boolean isPointer() {
        return this.nativePointer != 0L;
    }

    @ExportMessage
    long asPointer() throws UnsupportedMessageException {
        if (this.isPointer()) {
            return this.nativePointer;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw UnsupportedMessageException.create();
    }

    @Override
    protected void toNativeInternal() {
        if (this.nativePointer == 0L) {
            CompilerDirectives.transferToInterpreter();
            assert (PythonLanguage.get(null).getEngineOption(PythonOptions.HPyBackend) == PythonOptions.HPyBackendMode.JNI);
            if (!this.getContext().getEnv().isNativeAccessAllowed()) {
                throw new RuntimeException(ErrorMessages.NATIVE_ACCESS_NOT_ALLOWED.toJavaStringUncached());
            }
            GraalHPyJNIContext.loadJNIBackend();
            this.nativePointer = GraalHPyJNIContext.initJNI(this, this.context, this.createContextHandleArray(), this.ctypeSizes, this.cfieldOffsets);
            if (this.nativePointer == 0L) {
                throw CompilerDirectives.shouldNotReachHere((String)"Could not initialize HPy JNI backend.");
            }
        }
    }

    @Override
    protected void initNativeFastPaths() {
        assert (this.useNativeFastPaths());
        GraalHPyJNIContext.initJNINativeFastPaths(this.nativePointer);
    }

    public static void loadJNIBackend() {
        if (!ImageInfo.inImageBuildtimeCode() && !jniBackendLoaded) {
            String pythonJNIPath = GraalHPyJNIContext.getJNILibrary();
            try {
                LOGGER.fine("Loading HPy JNI backend from " + pythonJNIPath);
                System.load(pythonJNIPath);
                jniBackendLoaded = true;
            }
            catch (NullPointerException | UnsatisfiedLinkError e) {
                LOGGER.severe("HPy JNI backend library could not be found: " + pythonJNIPath);
                LOGGER.severe("Error was: " + String.valueOf(e));
            }
        }
    }

    public static String getJNILibrary() {
        CompilerAsserts.neverPartOfCompilation();
        PythonContext context = PythonContext.get(null);
        TruffleFile libPath = context.getPublicTruffleFileRelaxed(context.getJNIHome(), new TruffleString[0]).resolve(PythonContext.J_PYTHON_JNI_LIBRARY_NAME).getAbsoluteFile();
        try {
            return libPath.getCanonicalFile(new LinkOption[]{LinkOption.NOFOLLOW_LINKS}).toString();
        }
        catch (IOException e) {
            LOGGER.severe(String.format("Cannot determine canonical path for %s: %s", libPath, e));
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected void initNativeContext() {
        this.toNative();
    }

    @Override
    protected void finalizeNativeContext() {
        GraalHPyJNIContext.finalizeJNIContext(this.nativePointer);
        this.nativePointer = 0L;
        if (this.hPyDebugContext != 0L) {
            GraalHPyJNIContext.finalizeJNIDebugContext(this.hPyDebugContext);
            this.hPyDebugContext = 0L;
        }
        if (this.hPyTraceContext != 0L) {
            GraalHPyJNIContext.finalizeJNITraceContext(this.hPyTraceContext);
            this.hPyTraceContext = 0L;
        }
        this.loadedExtensions.clear();
    }

    @Override
    public void initHPyDebugContext() throws LoadCExtException.ApiInitException {
        if (this.hPyDebugContext == 0L) {
            CompilerDirectives.transferToInterpreter();
            if (!this.getContext().getEnv().isNativeAccessAllowed() || this.getContext().getLanguage().getEngineOption(PythonOptions.HPyBackend) != PythonOptions.HPyBackendMode.JNI) {
                throw new LoadCExtException.ApiInitException(ErrorMessages.HPY_S_MODE_NOT_AVAILABLE, "debug");
            }
            try {
                this.toNativeInternal();
                long debugCtxPtr = GraalHPyJNIContext.initJNIDebugContext(this.nativePointer);
                if (debugCtxPtr == 0L) {
                    throw new RuntimeException("Could not initialize HPy debug context");
                }
                this.hPyDebugContext = debugCtxPtr;
            }
            catch (CannotCastException e) {
                throw new LoadCExtException.ApiInitException(ErrorMessages.HPY_S_MODE_NOT_AVAILABLE, "debug");
            }
        }
    }

    @Override
    public void initHPyTraceContext() throws LoadCExtException.ApiInitException {
        if (this.hPyTraceContext == 0L) {
            CompilerDirectives.transferToInterpreter();
            if (!this.getContext().getEnv().isNativeAccessAllowed() || this.getContext().getLanguage().getEngineOption(PythonOptions.HPyBackend) != PythonOptions.HPyBackendMode.JNI) {
                throw new LoadCExtException.ApiInitException(ErrorMessages.HPY_S_MODE_NOT_AVAILABLE, "trace");
            }
            try {
                this.toNativeInternal();
                long traceCtxPtr = GraalHPyJNIContext.initJNITraceContext(this.nativePointer);
                if (traceCtxPtr == 0L) {
                    throw new RuntimeException("Could not initialize HPy trace context");
                }
                this.hPyTraceContext = traceCtxPtr;
            }
            catch (CannotCastException e) {
                throw new LoadCExtException.ApiInitException(ErrorMessages.HPY_S_MODE_NOT_AVAILABLE, "trace");
            }
        }
    }

    @Override
    protected Object createArgumentsArray(Object[] args) {
        return this.context.createNativeArguments(args);
    }

    @Override
    protected void freeArgumentsArray(Object argsArray) {
        if (argsArray instanceof Long) {
            Long argsArrayPtr = (Long)argsArray;
            this.context.freeNativeArgumentsUntil(argsArrayPtr);
        }
    }

    long getHPyDebugContext() {
        if (this.hPyDebugContext == 0L) {
            try {
                this.initHPyDebugContext();
            }
            catch (LoadCExtException.ApiInitException e) {
                throw CompilerDirectives.shouldNotReachHere((String)e.getMessage());
            }
        }
        return this.hPyDebugContext;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public PythonModule getHPyDebugModule() throws LoadCExtException.ImportException {
        this.toNativeInternal();
        long debugModuleDef = GraalHPyJNIContext.initJNIDebugModule(this.nativePointer);
        if (debugModuleDef == 0L) {
            throw new LoadCExtException.ImportException(null, null, null, ErrorMessages.HPY_S_MODE_NOT_AVAILABLE, "debug");
        }
        return this.loadInternalModule(debugModuleDef, PythonUtils.tsLiteral("_debug"));
    }

    long getHPyTraceContext() {
        if (this.hPyTraceContext == 0L) {
            try {
                this.initHPyTraceContext();
            }
            catch (LoadCExtException.ApiInitException e) {
                throw CompilerDirectives.shouldNotReachHere((String)e.getMessage());
            }
        }
        return this.hPyTraceContext;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public PythonModule getHPyTraceModule() throws LoadCExtException.ImportException {
        this.toNativeInternal();
        long debugModuleDef = GraalHPyJNIContext.initJNITraceModule(this.nativePointer);
        if (debugModuleDef == 0L) {
            throw new LoadCExtException.ImportException(null, null, null, ErrorMessages.HPY_S_MODE_NOT_AVAILABLE, "trace");
        }
        return this.loadInternalModule(debugModuleDef, PythonUtils.tsLiteral("_trace"));
    }

    private PythonModule loadInternalModule(long debugModuleDef, TruffleString name) {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.getContext().getEnv().isNativeAccessAllowed());
        assert (this.getContext().getLanguage().getEngineOption(PythonOptions.HPyBackend) == PythonOptions.HPyBackendMode.JNI);
        Object moduleDefPtrObj = this.convertLongArg(HPyContextSignatureType.HPyModuleDefPtr, debugModuleDef);
        Object nativeModule = GraalHPyNodesFactory.GraalHPyModuleCreateNodeGen.getUncached().execute(this.context, name, null, moduleDefPtrObj);
        if (nativeModule instanceof PythonModule) {
            PythonModule pythonModule = (PythonModule)nativeModule;
            GraalHPyNodesFactory.GraalHPyModuleExecNodeGen.getUncached().execute(null, this.context, pythonModule);
            return (PythonModule)nativeModule;
        }
        throw new RuntimeException(name.toJavaStringUncached() + " module is expected to be a Python module object");
    }

    @Override
    protected void setNativeCache(long cachePtr) {
        assert (this.useNativeFastPaths());
        GraalHPyJNIContext.setNativeSpaceFunction(this.nativePointer, cachePtr);
    }

    @Override
    public GraalHPyNodes.HPyCallHelperFunctionNode createCallHelperFunctionNode() {
        return GraalHPyJNICallHelperFunctionNode.UNCACHED;
    }

    @Override
    public GraalHPyNodes.HPyCallHelperFunctionNode getUncachedCallHelperFunctionNode() {
        return GraalHPyJNICallHelperFunctionNode.UNCACHED;
    }

    @Override
    public GraalHPyNodes.HPyFromCharPointerNode createFromCharPointerNode() {
        return GraalHPyJNINodesFactory.HPyJNIFromCharPointerNodeGen.create();
    }

    @Override
    public GraalHPyNodes.HPyFromCharPointerNode getUncachedFromCharPointerNode() {
        return GraalHPyJNINodesFactory.HPyJNIFromCharPointerNodeGen.getUncached();
    }

    @Override
    public GraalHPyNodes.HPyAsCharPointerNode createAsCharPointerNode() {
        return GraalHPyJNINodesFactory.HPyJNIAsCharPointerNodeGen.create();
    }

    @Override
    public GraalHPyNodes.HPyAsCharPointerNode getUncachedAsCharPointerNode() {
        return GraalHPyJNINodesFactory.HPyJNIAsCharPointerNodeGen.getUncached();
    }

    @Override
    public GraalHPyCAccess.AllocateNode createAllocateNode() {
        return GraalHPyJNINodes.UnsafeAllocateNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.AllocateNode getUncachedAllocateNode() {
        return GraalHPyJNINodes.UnsafeAllocateNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.FreeNode createFreeNode() {
        return GraalHPyJNINodes.UnsafeFreeNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.FreeNode getUncachedFreeNode() {
        return GraalHPyJNINodes.UnsafeFreeNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.BulkFreeHandleReferencesNode createBulkFreeHandleReferencesNode() {
        return GraalHPyJNINodes.UnsafeBulkFreeHandleReferencesNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.GetElementPtrNode createGetElementPtrNode() {
        return GraalHPyJNINodes.UnsafeGetElementPtrNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.GetElementPtrNode getUncachedGetElementPtrNode() {
        return GraalHPyJNINodes.UnsafeGetElementPtrNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.ReadI32Node createReadI32Node() {
        return GraalHPyJNINodes.UnsafeReadI32Node.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.ReadI32Node getUncachedReadI32Node() {
        return GraalHPyJNINodes.UnsafeReadI32Node.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.ReadI64Node createReadI64Node() {
        return GraalHPyJNINodes.UnsafeReadI64Node.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.ReadI64Node getUncachedReadI64Node() {
        return GraalHPyJNINodes.UnsafeReadI64Node.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.ReadFloatNode createReadFloatNode() {
        return GraalHPyJNINodes.UnsafeReadFloatNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.ReadFloatNode getUncachedReadFloatNode() {
        return GraalHPyJNINodes.UnsafeReadFloatNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.ReadDoubleNode createReadDoubleNode() {
        return GraalHPyJNINodes.UnsafeReadDoubleNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.ReadDoubleNode getUncachedReadDoubleNode() {
        return GraalHPyJNINodes.UnsafeReadDoubleNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.ReadPointerNode createReadPointerNode() {
        return GraalHPyJNINodes.UnsafeReadPointerNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.ReadPointerNode getUncachedReadPointerNode() {
        return GraalHPyJNINodes.UnsafeReadPointerNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.IsNullNode createIsNullNode() {
        return GraalHPyJNINodes.UnsafeIsNullNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.IsNullNode getUncachedIsNullNode() {
        return GraalHPyJNINodes.UnsafeIsNullNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.ReadGenericNode createReadGenericNode() {
        return GraalHPyJNINodes.UnsafeReadGenericNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.ReadGenericNode getUncachedReadGenericNode() {
        return GraalHPyJNINodes.UnsafeReadGenericNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.ReadHPyNode createReadHPyNode() {
        return GraalHPyJNINodes.UnsafeReadHPyNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.ReadHPyNode getUncachedReadHPyNode() {
        return GraalHPyJNINodes.UnsafeReadHPyNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.ReadHPyFieldNode createReadHPyFieldNode() {
        return GraalHPyJNINodes.UnsafeReadHPyFieldNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.ReadHPyFieldNode getUncachedReadFieldHPyNode() {
        return GraalHPyJNINodes.UnsafeReadHPyFieldNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.WriteDoubleNode createWriteDoubleNode() {
        return GraalHPyJNINodes.UnsafeWriteDoubleNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.WriteDoubleNode getUncachedWriteDoubleNode() {
        return GraalHPyJNINodes.UnsafeWriteDoubleNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.WriteI32Node createWriteI32Node() {
        return GraalHPyJNINodes.UnsafeWriteI32Node.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.WriteI32Node getUncachedWriteI32Node() {
        return GraalHPyJNINodes.UnsafeWriteI32Node.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.WriteI64Node createWriteI64Node() {
        return GraalHPyJNINodes.UnsafeWriteI64Node.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.WriteI64Node getUncachedWriteI64Node() {
        return GraalHPyJNINodes.UnsafeWriteI64Node.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.WriteHPyNode createWriteHPyNode() {
        return GraalHPyJNINodes.UnsafeWriteHPyNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.WriteHPyNode getUncachedWriteHPyNode() {
        return GraalHPyJNINodes.UnsafeWriteHPyNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.WritePointerNode createWritePointerNode() {
        return GraalHPyJNINodes.UnsafeWritePointerNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.WritePointerNode getUncachedWritePointerNode() {
        return GraalHPyJNINodes.UnsafeWritePointerNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.ReadI8ArrayNode createReadI8ArrayNode() {
        return GraalHPyJNINodes.UnsafeReadI8ArrayNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.ReadI8ArrayNode getUncachedReadI8ArrayNode() {
        return GraalHPyJNINodes.UnsafeReadI8ArrayNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.ReadHPyArrayNode createReadHPyArrayNode() {
        return GraalHPyJNINodes.UnsafeReadHPyArrayNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.ReadHPyArrayNode getUncachedReadHPyArrayNode() {
        return GraalHPyJNINodes.UnsafeReadHPyArrayNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.WriteSizeTNode createWriteSizeTNode() {
        return GraalHPyJNINodes.UnsafeWriteSizeTNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.WriteSizeTNode getUncachedWriteSizeTNode() {
        return GraalHPyJNINodes.UnsafeWriteSizeTNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.WriteGenericNode createWriteGenericNode() {
        return GraalHPyJNINodes.UnsafeWriteGenericNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.WriteGenericNode getUncachedWriteGenericNode() {
        return GraalHPyJNINodes.UnsafeWriteGenericNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.WriteHPyFieldNode createWriteHPyFieldNode() {
        return GraalHPyJNINodes.UnsafeWriteHPyFieldNode.UNCACHED;
    }

    @Override
    public GraalHPyCAccess.WriteHPyFieldNode getUncachedWriteHPyFieldNode() {
        return GraalHPyJNINodes.UnsafeWriteHPyFieldNode.UNCACHED;
    }

    @CompilerDirectives.TruffleBoundary
    public static native int strcmp(long var0, long var2);

    @CompilerDirectives.TruffleBoundary
    private static native int setNativeSpaceFunction(long var0, long var2);

    @CompilerDirectives.TruffleBoundary
    private static native int initJNINativeFastPaths(long var0);

    @CompilerDirectives.TruffleBoundary
    public static native int getErrno();

    @CompilerDirectives.TruffleBoundary
    public static native long getStrerror(int var0);

    @CompilerDirectives.TruffleBoundary
    private static native long initJNI(GraalHPyJNIContext var0, GraalHPyContext var1, long[] var2, int[] var3, int[] var4);

    @CompilerDirectives.TruffleBoundary
    private static native int finalizeJNIContext(long var0);

    @CompilerDirectives.TruffleBoundary
    private static native long initJNIDebugContext(long var0);

    @CompilerDirectives.TruffleBoundary
    private static native int finalizeJNIDebugContext(long var0);

    @CompilerDirectives.TruffleBoundary
    private static native long initJNIDebugModule(long var0);

    @CompilerDirectives.TruffleBoundary
    private static native long initJNITraceContext(long var0);

    @CompilerDirectives.TruffleBoundary
    private static native int finalizeJNITraceContext(long var0);

    @CompilerDirectives.TruffleBoundary
    private static native long initJNITraceModule(long var0);

    @CompilerDirectives.TruffleBoundary
    static native void bulkFreeNativeSpace(long[] var0, long[] var1, int var2);

    private void increment(HPyJNIUpcall upcall) {
        if (this.counts != null) {
            int n = upcall.ordinal();
            this.counts[n] = this.counts[n] + 1;
        }
    }

    private static PythonBuiltinClassType getBuiltinClass(Object cls) {
        if (cls instanceof PythonBuiltinClassType) {
            return (PythonBuiltinClassType)((Object)cls);
        }
        if (cls instanceof PythonBuiltinClass) {
            return ((PythonBuiltinClass)cls).getType();
        }
        return null;
    }

    private int typeCheck(long handle, Object type) {
        Object receiver = GraalHPyBoxing.isBoxedDouble(handle) ? PythonBuiltinClassType.PFloat : (GraalHPyBoxing.isBoxedInt(handle) ? PythonBuiltinClassType.PInt : GetClassNode.executeUncached(this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(handle))));
        if (receiver == type) {
            return 1;
        }
        PythonBuiltinClassType receiverBuiltin = GraalHPyJNIContext.getBuiltinClass(receiver);
        if (receiverBuiltin != null) {
            PythonBuiltinClassType typeBuiltin = GraalHPyJNIContext.getBuiltinClass(type);
            if (typeBuiltin == null) {
                return 0;
            }
            while (true) {
                if (receiverBuiltin == typeBuiltin) {
                    return 1;
                }
                if (receiverBuiltin == PythonBuiltinClassType.PythonObject) {
                    return 0;
                }
                receiverBuiltin = receiverBuiltin.getBase();
            }
        }
        try {
            return IsSubtypeNode.getUncached().execute(receiver, type) ? 1 : 0;
        }
        catch (PException e) {
            GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(this.context, e);
            return 0;
        }
    }

    static long coerceToPointer(Object value) {
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof NativePointer) {
            NativePointer nativePointer = (NativePointer)value;
            return nativePointer.asPointer();
        }
        return GraalHPyJNIContext.interopPointerToNative(value, InteropLibrary.getUncached((Object)value));
    }

    public static long expectPointer(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        InteropLibrary interopLibrary = InteropLibrary.getUncached((Object)value);
        if (interopLibrary.isPointer(value)) {
            try {
                return interopLibrary.asPointer(value);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((String)("cannot cast " + String.valueOf(value)));
            }
        }
        return 0L;
    }

    private long capsuleNameToNative(Object name) {
        if (name instanceof TruffleString) {
            TruffleString tname = (TruffleString)name;
            return GraalHPyJNINodesFactory.HPyJNIAsCharPointerNodeGen.getUncached().executeLong(this.context, tname, TruffleString.Encoding.UTF_8);
        }
        return GraalHPyJNIContext.coerceToPointer(name);
    }

    private long createHPyObject(long typeHandle, long dataOutVar) {
        PythonObject pythonObject;
        Object type = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(typeHandle));
        if (type instanceof PythonClass) {
            PythonClass clazz = (PythonClass)type;
            long basicSize = clazz.getBasicSize();
            if (basicSize == -1L) {
                pythonObject = this.slowPathFactory.createPythonObject(clazz, clazz.getInstanceShape());
            } else {
                long dataPtr = CArrayWrappers.UNSAFE.allocateMemory(basicSize);
                CArrayWrappers.UNSAFE.setMemory(dataPtr, basicSize, (byte)0);
                if (dataOutVar != 0L) {
                    CArrayWrappers.UNSAFE.putAddress(dataOutVar, dataPtr);
                }
                pythonObject = this.slowPathFactory.createPythonHPyObject(clazz, dataPtr);
                Object destroyFunc = clazz.getHPyDestroyFunc();
                this.context.createHandleReference(pythonObject, dataPtr, destroyFunc != PNone.NO_VALUE ? destroyFunc : null);
            }
            Object defaultCallFunc = clazz.getHPyDefaultCallFunc();
            if (defaultCallFunc != null) {
                GraalHPyData.setHPyCallFunction(pythonObject, defaultCallFunc);
            }
        } else {
            if (!TypeNodes.IsTypeNode.executeUncached(type)) {
                return GraalHPyNodesFactory.HPyRaiseNodeGen.getUncached().raiseIntWithoutFrame(this.context, 0, PythonBuiltinClassType.TypeError, ErrorMessages.HPY_NEW_ARG_1_MUST_BE_A_TYPE, new Object[0]);
            }
            pythonObject = this.slowPathFactory.createPythonObject(type);
        }
        return GraalHPyBoxing.boxHandle(this.context.getHPyHandleForObject(pythonObject));
    }

    public int ctxTypeCheck(long bits, long typeBits) {
        this.increment(HPyJNIUpcall.HPyTypeCheck);
        Object type = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(typeBits));
        return this.typeCheck(bits, type);
    }

    public int ctxTypeCheckg(long bits, long typeGlobalBits) {
        this.increment(HPyJNIUpcall.HPyTypeCheck);
        Object type = this.context.getObjectForHPyGlobal(GraalHPyBoxing.unboxHandle(typeGlobalBits));
        return this.typeCheck(bits, type);
    }

    public long ctxLength(long handle) {
        this.increment(HPyJNIUpcall.HPyLength);
        assert (GraalHPyBoxing.isBoxedHandle(handle));
        Object receiver = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(handle));
        Object clazz = GetClassNode.executeUncached(receiver);
        if (clazz == PythonBuiltinClassType.PList || clazz == PythonBuiltinClassType.PTuple) {
            PSequence sequence = (PSequence)receiver;
            SequenceStorage storage = sequence.getSequenceStorage();
            return storage.length();
        }
        try {
            return PyObjectSizeNodeGen.executeUncached(receiver);
        }
        catch (PException e) {
            GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(this.context, e);
            return -1L;
        }
    }

    public int ctxListCheck(long handle) {
        this.increment(HPyJNIUpcall.HPyListCheck);
        if (GraalHPyBoxing.isBoxedHandle(handle)) {
            Object obj = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(handle));
            Object clazz = GetClassNode.executeUncached(obj);
            return PInt.intValue(clazz == PythonBuiltinClassType.PList || IsSubtypeNodeGen.getUncached().execute(clazz, (Object)PythonBuiltinClassType.PList));
        }
        return 0;
    }

    public long ctxUnicodeFromWideChar(long wcharArrayPtr, long size) {
        this.increment(HPyJNIUpcall.HPyUnicodeFromWideChar);
        if (!PInt.isIntRange(size)) {
            return 0L;
        }
        int isize = (int)size;
        char[] decoded = new char[isize];
        int i = 0;
        while ((long)i < size) {
            int wchar = CArrayWrappers.UNSAFE.getInt(wcharArrayPtr + 4L * (long)i);
            if (!Character.isBmpCodePoint(wchar)) {
                throw new RuntimeException();
            }
            decoded[i] = (char)wchar;
            ++i;
        }
        TruffleString result = PythonUtils.toTruffleStringUncached(new String(decoded, 0, isize));
        return GraalHPyBoxing.boxHandle(this.context.getHPyHandleForObject(result));
    }

    public long ctxUnicodeFromJCharArray(char[] arr) {
        this.increment(HPyJNIUpcall.HPyUnicodeFromJCharArray);
        TruffleString string = TruffleString.fromCharArrayUTF16Uncached((char[])arr).switchEncodingUncached(PythonUtils.TS_ENCODING);
        return GraalHPyBoxing.boxHandle(this.context.getHPyHandleForObject(string));
    }

    public long ctxDictNew() {
        this.increment(HPyJNIUpcall.HPyDictNew);
        PDict dict = this.slowPathFactory.createDict();
        return GraalHPyBoxing.boxHandle(this.context.getHPyHandleForObject(dict));
    }

    public long ctxListNew(long llen) {
        try {
            this.increment(HPyJNIUpcall.HPyListNew);
            int len = CastToJavaIntExactNode.executeUncached(llen);
            Object[] data = new Object[len];
            Arrays.fill(data, PNone.NONE);
            PList list = this.slowPathFactory.createList(data);
            return GraalHPyBoxing.boxHandle(this.context.getHPyHandleForObject(list));
        }
        catch (PException e) {
            GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(this.context, e);
            return 0L;
        }
    }

    public long ctxSequenceFromArray(long[] hItems, boolean steal, boolean create_list) {
        this.increment(HPyJNIUpcall.HPySequenceFromArray);
        Object[] objects = new Object[hItems.length];
        for (int i = 0; i < hItems.length; ++i) {
            long hBits = hItems[i];
            objects[i] = this.context.bitsAsPythonObject(hBits);
            if (!steal) continue;
            this.closeNativeHandle(hBits);
        }
        PSequence result = create_list ? this.slowPathFactory.createList(objects) : this.slowPathFactory.createTuple(objects);
        return GraalHPyBoxing.boxHandle(this.context.getHPyHandleForObject(result));
    }

    public long ctxFieldLoad(long bits, long idx) {
        this.increment(HPyJNIUpcall.HPyFieldLoad);
        Object owner = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(bits));
        assert (idx > 0L);
        Object referent = GraalHPyData.getHPyField((PythonObject)owner, (int)idx);
        return GraalHPyBoxing.boxHandle(this.context.getHPyHandleForObject(referent));
    }

    public long ctxFieldStore(long bits, long idx, long value) {
        this.increment(HPyJNIUpcall.HPyFieldStore);
        PythonObject owner = (PythonObject)this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(bits));
        Object referent = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(value));
        return GraalHPyData.setHPyField(owner, referent, (int)idx);
    }

    public long ctxGlobalLoad(long bits) {
        this.increment(HPyJNIUpcall.HPyGlobalLoad);
        assert (GraalHPyBoxing.isBoxedHandle(bits));
        return GraalHPyBoxing.boxHandle(this.context.getHPyHandleForObject(this.context.getObjectForHPyGlobal(GraalHPyBoxing.unboxHandle(bits))));
    }

    public long ctxGlobalStore(long bits, long v) {
        this.increment(HPyJNIUpcall.HPyGlobalStore);
        assert (GraalHPyBoxing.isBoxedHandle(bits));
        return this.context.createGlobal(this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(v)), GraalHPyBoxing.unboxHandle(bits));
    }

    public long ctxType(long bits) {
        Object clazz;
        this.increment(HPyJNIUpcall.HPyType);
        if (GraalHPyBoxing.isBoxedHandle(bits)) {
            clazz = GetClassNode.executeUncached(this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(bits)));
        } else if (GraalHPyBoxing.isBoxedInt(bits)) {
            clazz = GetClassNode.executeUncached(GraalHPyBoxing.unboxInt(bits));
        } else if (GraalHPyBoxing.isBoxedDouble(bits)) {
            clazz = GetClassNode.executeUncached(GraalHPyBoxing.unboxDouble(bits));
        } else {
            assert (false);
            clazz = null;
        }
        return GraalHPyBoxing.boxHandle(this.context.getHPyHandleForObject(clazz));
    }

    public long ctxTypeGetName(long bits) {
        this.increment(HPyJNIUpcall.HPyTypeGetName);
        assert (GraalHPyBoxing.isBoxedHandle(bits));
        Object clazz = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(bits));
        Object tpName = GraalHPyNodes.HPyTypeGetNameNode.executeUncached(this.context, clazz);
        try {
            return GraalHPyJNIContext.coerceToPointer(tpName);
        }
        catch (CannotCastException e) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    public long ctxContextVarGet(long varBits, long defBits, long errBits) {
        this.increment(HPyJNIUpcall.HPyContextVarGet);
        assert (GraalHPyBoxing.isBoxedHandle(varBits));
        Object var = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(varBits));
        if (!(var instanceof PContextVar)) {
            try {
                throw PRaiseNode.raiseUncached(null, PythonBuiltinClassType.TypeError, ErrorMessages.INSTANCE_OF_CONTEXTVAR_EXPECTED);
            }
            catch (PException e) {
                GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(this.context, e);
                return errBits;
            }
        }
        PythonContext ctx = this.getContext();
        PythonLanguage lang = ctx.getLanguage();
        Object def = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(defBits));
        Object res = GraalHPyContextFunctions.GraalHPyContextVarGet.getObject(ctx.getThreadState(lang), (PContextVar)var, def);
        if (res == GraalHPyHandle.NULL_HANDLE_DELEGATE) {
            return 0L;
        }
        return GraalHPyBoxing.boxHandle(this.context.getHPyHandleForObject(res));
    }

    public int ctxIs(long aBits, long bBits) {
        Object a = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(aBits));
        Object b = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(bBits));
        try {
            return PInt.intValue(IsNodeGen.getUncached().execute(a, b));
        }
        catch (PException e) {
            GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(this.context, e);
            return -1;
        }
    }

    public int ctxIsg(long aBits, long bBits) {
        Object a = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(aBits));
        Object b = this.context.getObjectForHPyGlobal(GraalHPyBoxing.unboxHandle(bBits));
        try {
            return PInt.intValue(IsNodeGen.getUncached().execute(a, b));
        }
        catch (PException e) {
            GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(this.context, e);
            return -1;
        }
    }

    public long ctxCapsuleNew(long pointer, long name, long destructor) {
        long hpyDestructor;
        if (pointer == 0L) {
            return GraalHPyNodesFactory.HPyRaiseNodeGen.getUncached().raiseIntWithoutFrame(this.context, 0, PythonBuiltinClassType.ValueError, ErrorMessages.HPYCAPSULE_NEW_NULL_PTR_ERROR, new Object[0]);
        }
        if (destructor != 0L) {
            long cpyTrampoline = CArrayWrappers.UNSAFE.getLong(destructor);
            hpyDestructor = CArrayWrappers.UNSAFE.getLong(destructor + 8L);
            if (cpyTrampoline == 0L || hpyDestructor == 0L) {
                return GraalHPyNodesFactory.HPyRaiseNodeGen.getUncached().raiseIntWithoutFrame(this.context, 0, PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_HPYCAPSULE_DESTRUCTOR, new Object[0]);
            }
        } else {
            hpyDestructor = 0L;
        }
        PyCapsule result = this.slowPathFactory.createCapsule(pointer, new NativePointer(name), hpyDestructor);
        return GraalHPyBoxing.boxHandle(this.context.getHPyHandleForObject(result));
    }

    static boolean capsuleNameMatches(long name1, long name2) {
        if (name1 == name2) {
            return true;
        }
        if (name1 == 0L || name2 == 0L) {
            return false;
        }
        return GraalHPyJNIContext.strcmp(name1, name2) == 0;
    }

    public long ctxCapsuleGet(long capsuleBits, int key, long namePtr) {
        Object capsule = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(capsuleBits));
        try {
            Object result;
            PyCapsule pyCapsule;
            block13: {
                block12: {
                    if (!(capsule instanceof PyCapsule)) break block12;
                    pyCapsule = (PyCapsule)capsule;
                    if (((PyCapsule)capsule).getPointer() != null) break block13;
                }
                return GraalHPyNodesFactory.HPyRaiseNodeGen.getUncached().raiseIntWithoutFrame(this.context, 0, PythonBuiltinClassType.ValueError, GraalHPyContextFunctions.GraalHPyCapsuleGet.getErrorMessage(key), new Object[0]);
            }
            GraalHPyContextFunctions.GraalHPyCapsuleGet.isLegalCapsule(capsule, key, PRaiseNode.getUncached());
            switch (key) {
                case 0: {
                    if (!GraalHPyJNIContext.capsuleNameMatches(namePtr, GraalHPyJNIContext.coerceToPointer(this.capsuleNameToNative(pyCapsule.getName())))) {
                        return GraalHPyNodesFactory.HPyRaiseNodeGen.getUncached().raiseIntWithoutFrame(this.context, 0, PythonBuiltinClassType.ValueError, GraalHPyContextFunctions.GraalHPyCapsuleGet.INCORRECT_NAME, new Object[0]);
                    }
                    result = pyCapsule.getPointer();
                    break;
                }
                case 2: {
                    result = pyCapsule.getContext();
                    break;
                }
                case 1: {
                    result = this.capsuleNameToNative(pyCapsule.getName());
                    break;
                }
                case 3: {
                    result = pyCapsule.getDestructor();
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere((String)"invalid key");
                }
            }
            return GraalHPyJNIContext.coerceToPointer(result);
        }
        catch (CannotCastException e) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    public long ctxGetAttrs(long receiverHandle, String name) {
        Object result;
        this.increment(HPyJNIUpcall.HPyGetAttrs);
        Object receiver = this.context.bitsAsPythonObject(receiverHandle);
        TruffleString tsName = PythonUtils.toTruffleStringUncached(name);
        try {
            result = PyObjectGetAttr.executeUncached(receiver, tsName);
        }
        catch (PException e) {
            GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(this.context, e);
            return 0L;
        }
        return this.context.pythonObjectAsBits(result);
    }

    public long ctxFloatFromDouble(double value) {
        this.increment(HPyJNIUpcall.HPyFloatFromDouble);
        return GraalHPyBoxing.boxDouble(value);
    }

    public double ctxFloatAsDouble(long handle) {
        this.increment(HPyJNIUpcall.HPyFloatAsDouble);
        if (GraalHPyBoxing.isBoxedDouble(handle)) {
            return GraalHPyBoxing.unboxDouble(handle);
        }
        if (GraalHPyBoxing.isBoxedInt(handle)) {
            return GraalHPyBoxing.unboxInt(handle);
        }
        Object object = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(handle));
        try {
            return PyFloatAsDoubleNode.executeUncached(object);
        }
        catch (PException e) {
            GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(this.context, e);
            return -1.0;
        }
    }

    public int ctxLongAsInt32t(long h) {
        this.increment(HPyJNIUpcall.HPyLongAsInt32t);
        if (GraalHPyBoxing.isBoxedInt(h)) {
            return GraalHPyBoxing.unboxInt(h);
        }
        return this.executeIntBinaryContextFunction(HPyContextMember.CTX_LONG_ASINT32_T, h);
    }

    public int ctxLongAsUInt32t(long h) {
        int unboxedVal;
        this.increment(HPyJNIUpcall.HPyLongAsUInt32t);
        if (GraalHPyBoxing.isBoxedInt(h) && (unboxedVal = GraalHPyBoxing.unboxInt(h)) >= 0) {
            return unboxedVal;
        }
        return this.executeIntBinaryContextFunction(HPyContextMember.CTX_LONG_ASUINT32_T, h);
    }

    public int ctxLongAsUInt32tMask(long h) {
        this.increment(HPyJNIUpcall.HPyLongAsUInt32tMask);
        if (GraalHPyBoxing.isBoxedInt(h)) {
            return GraalHPyBoxing.unboxInt(h);
        }
        return this.executeIntBinaryContextFunction(HPyContextMember.CTX_LONG_ASUINT32_TMASK, h);
    }

    public long ctxLongAsInt64t(long handle) {
        this.increment(HPyJNIUpcall.HPyLongAsInt64t);
        if (GraalHPyBoxing.isBoxedInt(handle)) {
            return GraalHPyBoxing.unboxInt(handle);
        }
        Object object = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(handle));
        try {
            return (Long)CExtCommonNodesFactory.AsNativePrimitiveNodeGen.getUncached().execute(object, 1, 8, true);
        }
        catch (PException e) {
            GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(this.context, e);
            return -1L;
        }
    }

    public long ctxLongAsUInt64t(long h) {
        this.increment(HPyJNIUpcall.HPyLongAsUInt64t);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_LONG_ASUINT64_T, h);
    }

    public long ctxLongAsUInt64tMask(long h) {
        this.increment(HPyJNIUpcall.HPyLongAsUInt64tMask);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_LONG_ASUINT64_TMASK, h);
    }

    public double ctxLongAsDouble(long handle) {
        this.increment(HPyJNIUpcall.HPyLongAsDouble);
        if (GraalHPyBoxing.isBoxedInt(handle)) {
            return GraalHPyBoxing.unboxInt(handle);
        }
        Object object = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(handle));
        try {
            return (Double)PyLongAsDoubleNode.executeUncached(object);
        }
        catch (PException e) {
            GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(this.context, e);
            return -1.0;
        }
    }

    public long ctxLongFromInt32t(int v) {
        this.increment(HPyJNIUpcall.HPyLongFromInt32t);
        return GraalHPyBoxing.boxInt(v);
    }

    public long ctxLongFromUInt32t(int value) {
        this.increment(HPyJNIUpcall.HPyLongFromUInt32t);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_LONG_FROMUINT32_T, value);
    }

    public long ctxLongFromInt64t(long v) {
        this.increment(HPyJNIUpcall.HPyLongFromInt64t);
        if (PInt.isIntRange(v)) {
            return GraalHPyBoxing.boxInt((int)v);
        }
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_LONG_FROMINT64_T, v);
    }

    public long ctxLongFromUInt64t(long v) {
        this.increment(HPyJNIUpcall.HPyLongFromUInt64t);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_LONG_FROMUINT64_T, v);
    }

    public long ctxBoolFromBool(boolean v) {
        this.increment(HPyJNIUpcall.HPyBoolFromBool);
        PythonContext core = this.context.getContext();
        return GraalHPyBoxing.boxHandle(this.context.getHPyHandleForObject(v ? core.getTrue() : core.getFalse()));
    }

    public long ctxAsStructObject(long h) {
        this.increment(HPyJNIUpcall.HPyAsStructObject);
        Object receiver = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(h));
        return GraalHPyJNIContext.expectPointer(GraalHPyNodes.HPyGetNativeSpacePointerNode.executeUncached(receiver));
    }

    public long ctxAsStructLegacy(long h) {
        this.increment(HPyJNIUpcall.HPyAsStructLegacy);
        Object receiver = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(h));
        return GraalHPyJNIContext.expectPointer(GraalHPyNodes.HPyGetNativeSpacePointerNode.executeUncached(receiver));
    }

    public long ctxAsStructType(long h) {
        this.increment(HPyJNIUpcall.HPyAsStructType);
        Object receiver = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(h));
        return GraalHPyJNIContext.expectPointer(GraalHPyNodes.HPyGetNativeSpacePointerNode.executeUncached(receiver));
    }

    public long ctxAsStructLong(long h) {
        this.increment(HPyJNIUpcall.HPyAsStructLong);
        Object receiver = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(h));
        return GraalHPyJNIContext.expectPointer(GraalHPyNodes.HPyGetNativeSpacePointerNode.executeUncached(receiver));
    }

    public long ctxAsStructFloat(long h) {
        this.increment(HPyJNIUpcall.HPyAsStructFloat);
        Object receiver = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(h));
        return GraalHPyJNIContext.expectPointer(GraalHPyNodes.HPyGetNativeSpacePointerNode.executeUncached(receiver));
    }

    public long ctxAsStructUnicode(long h) {
        this.increment(HPyJNIUpcall.HPyAsStructUnicode);
        Object receiver = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(h));
        return GraalHPyJNIContext.expectPointer(GraalHPyNodes.HPyGetNativeSpacePointerNode.executeUncached(receiver));
    }

    public long ctxAsStructTuple(long h) {
        this.increment(HPyJNIUpcall.HPyAsStructTuple);
        Object receiver = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(h));
        return GraalHPyJNIContext.expectPointer(GraalHPyNodes.HPyGetNativeSpacePointerNode.executeUncached(receiver));
    }

    public long ctxAsStructList(long h) {
        this.increment(HPyJNIUpcall.HPyAsStructList);
        Object receiver = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(h));
        return GraalHPyJNIContext.expectPointer(GraalHPyNodes.HPyGetNativeSpacePointerNode.executeUncached(receiver));
    }

    public int ctxSetItems(long receiverHandle, String name, long valueHandle) {
        this.increment(HPyJNIUpcall.HPySetItems);
        Object receiver = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(receiverHandle));
        Object value = this.context.bitsAsPythonObject(valueHandle);
        if (value == GraalHPyHandle.NULL_HANDLE_DELEGATE) {
            GraalHPyNodes.HPyRaiseNode.raiseIntUncached(this.context, -1, PythonBuiltinClassType.SystemError, ErrorMessages.HPY_UNEXPECTED_HPY_NULL, new Object[0]);
            return -1;
        }
        TruffleString tsName = PythonUtils.toTruffleStringUncached(name);
        try {
            PyObjectSetItem.executeUncached(receiver, tsName, value);
            return 0;
        }
        catch (PException e) {
            GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(this.context, e);
            return -1;
        }
    }

    public long ctxGetItems(long receiverHandle, String name) {
        Object result;
        this.increment(HPyJNIUpcall.HPyGetItems);
        Object receiver = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(receiverHandle));
        TruffleString tsName = PythonUtils.toTruffleStringUncached(name);
        try {
            result = PyObjectGetItem.executeUncached(receiver, tsName);
        }
        catch (PException e) {
            GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(this.context, e);
            return 0L;
        }
        return GraalHPyBoxing.boxHandle(this.context.getHPyHandleForObject(result));
    }

    public long ctxNew(long typeHandle, long dataOutVar) {
        this.increment(HPyJNIUpcall.HPyNew);
        return this.createHPyObject(typeHandle, dataOutVar);
    }

    public long ctxTypeGenericNew(long typeHandle, long args, long nargs, long kw) {
        this.increment(HPyJNIUpcall.HPyTypeGenericNew);
        return this.createHPyObject(typeHandle, 0L);
    }

    private void closeNativeHandle(long handle) {
        if (GraalHPyBoxing.isBoxedHandle(handle)) {
            this.context.releaseHPyHandleForObject(GraalHPyBoxing.unboxHandle(handle));
        }
    }

    public void ctxClose(long handle) {
        this.increment(HPyJNIUpcall.HPyClose);
        this.closeNativeHandle(handle);
    }

    public void ctxBulkClose(long unclosedHandlePtr, int size) {
        this.increment(HPyJNIUpcall.HPyBulkClose);
        for (int i = 0; i < size; ++i) {
            long handle = CArrayWrappers.UNSAFE.getLong(unclosedHandlePtr);
            unclosedHandlePtr += 8L;
            assert (GraalHPyBoxing.isBoxedHandle(handle));
            assert (handle >= 256L);
            this.context.releaseHPyHandleForObject(GraalHPyBoxing.unboxHandle(handle));
        }
    }

    public long ctxDup(long handle) {
        this.increment(HPyJNIUpcall.HPyDup);
        if (GraalHPyBoxing.isBoxedHandle(handle)) {
            Object delegate = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(handle));
            return GraalHPyBoxing.boxHandle(this.context.getHPyHandleForObject(delegate));
        }
        return handle;
    }

    public long ctxGetItemi(long hCollection, long lidx) {
        this.increment(HPyJNIUpcall.HPyGetItemi);
        try {
            if (!GraalHPyBoxing.isBoxedHandle(hCollection)) {
                throw PRaiseNode.raiseUncached(null, PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_NOT_SUBSCRIPTABLE, 0);
            }
            Object receiver = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(hCollection));
            Object clazz = GetClassNode.executeUncached(receiver);
            if (clazz == PythonBuiltinClassType.PList || clazz == PythonBuiltinClassType.PTuple) {
                if (!PInt.isIntRange(lidx)) {
                    throw PRaiseNode.raiseUncached(null, PythonBuiltinClassType.IndexError, ErrorMessages.CANNOT_FIT_P_INTO_INDEXSIZED_INT, lidx);
                }
                int idx = (int)lidx;
                PSequence sequence = (PSequence)receiver;
                SequenceStorage storage = sequence.getSequenceStorage();
                if (storage instanceof IntSequenceStorage) {
                    return GraalHPyBoxing.boxInt(((IntSequenceStorage)storage).getIntItemNormalized(idx));
                }
                if (storage instanceof DoubleSequenceStorage) {
                    return GraalHPyBoxing.boxDouble(((DoubleSequenceStorage)storage).getDoubleItemNormalized(idx));
                }
                if (storage instanceof LongSequenceStorage) {
                    long lresult = ((LongSequenceStorage)storage).getLongItemNormalized(idx);
                    if (PInt.isIntRange(lresult)) {
                        return GraalHPyBoxing.boxInt((int)lresult);
                    }
                    return GraalHPyBoxing.boxHandle(this.context.getHPyHandleForObject(lresult));
                }
                if (storage instanceof ObjectSequenceStorage) {
                    Object result = ((ObjectSequenceStorage)storage).getItemNormalized(idx);
                    if (result instanceof Integer) {
                        return GraalHPyBoxing.boxInt((Integer)result);
                    }
                    if (result instanceof Double) {
                        return GraalHPyBoxing.boxDouble((Double)result);
                    }
                    return GraalHPyBoxing.boxHandle(this.context.getHPyHandleForObject(result));
                }
            }
            Object result = PythonAbstractObject.PInteropSubscriptNode.getUncached().execute(receiver, lidx);
            return GraalHPyBoxing.boxHandle(this.context.getHPyHandleForObject(result));
        }
        catch (PException e) {
            GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(this.context, e);
            return 0L;
        }
    }

    public int ctxSetItem(long hSequence, long hKey, long hValue) {
        this.increment(HPyJNIUpcall.HPySetItem);
        try {
            if (!GraalHPyBoxing.isBoxedHandle(hSequence)) {
                throw PRaiseNode.raiseUncached(null, PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_DOES_NOT_SUPPORT_ITEM_ASSIGMENT, 0);
            }
            Object receiver = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(hSequence));
            Object clazz = GetClassNode.executeUncached(receiver);
            Object key = GraalHPyNodesFactory.HPyAsPythonObjectNodeGen.getUncached().execute(hKey);
            Object value = GraalHPyNodesFactory.HPyAsPythonObjectNodeGen.getUncached().execute(hValue);
            if (clazz == PythonBuiltinClassType.PDict) {
                PDict dict = (PDict)receiver;
                HashingStorage dictStorage = dict.getDictStorage();
                if (key instanceof TruffleString) {
                    if (dictStorage instanceof EmptyStorage) {
                        dictStorage = PDict.createNewStorage(1);
                        dict.setDictStorage(dictStorage);
                    }
                    if (dictStorage instanceof EconomicMapStorage) {
                        ((EconomicMapStorage)dictStorage).putUncached((TruffleString)key, value);
                        return 0;
                    }
                }
                dict.setDictStorage(HashingStorageNodes.HashingStorageSetItem.executeUncached(dictStorage, key, value));
                return 0;
            }
            if (clazz == PythonBuiltinClassType.PList && PGuards.isInteger(key) && this.ctxListSetItem(receiver, ((Number)key).longValue(), hValue)) {
                return 0;
            }
            return GraalHPyJNIContext.setItemGeneric(receiver, clazz, key, value);
        }
        catch (PException e) {
            GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(this.context, e);
            return -1;
        }
    }

    public int ctxSetItemi(long hSequence, long lidx, long hValue) {
        this.increment(HPyJNIUpcall.HPySetItemi);
        try {
            if (!GraalHPyBoxing.isBoxedHandle(hSequence)) {
                throw PRaiseNode.raiseUncached(null, PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_DOES_NOT_SUPPORT_ITEM_ASSIGMENT, 0);
            }
            Object receiver = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(hSequence));
            Object clazz = GetClassNode.executeUncached(receiver);
            if (clazz == PythonBuiltinClassType.PList && this.ctxListSetItem(receiver, lidx, hValue)) {
                return 0;
            }
            Object value = GraalHPyNodesFactory.HPyAsPythonObjectNodeGen.getUncached().execute(hValue);
            return GraalHPyJNIContext.setItemGeneric(receiver, clazz, lidx, value);
        }
        catch (PException e) {
            GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(this.context, e);
            return -1;
        }
    }

    private boolean ctxListSetItem(Object receiver, long lidx, long hValue) {
        if (!PInt.isIntRange(lidx)) {
            throw PRaiseNode.raiseUncached(null, PythonBuiltinClassType.IndexError, ErrorMessages.CANNOT_FIT_P_INTO_INDEXSIZED_INT, lidx);
        }
        int idx = (int)lidx;
        PList sequence = (PList)receiver;
        SequenceStorage storage = sequence.getSequenceStorage();
        if (storage instanceof IntSequenceStorage && GraalHPyBoxing.isBoxedInt(hValue)) {
            ((IntSequenceStorage)storage).setIntItemNormalized(idx, GraalHPyBoxing.unboxInt(hValue));
            return true;
        }
        if (storage instanceof DoubleSequenceStorage && GraalHPyBoxing.isBoxedDouble(hValue)) {
            ((DoubleSequenceStorage)storage).setDoubleItemNormalized(idx, GraalHPyBoxing.unboxDouble(hValue));
            return true;
        }
        if (storage instanceof LongSequenceStorage && GraalHPyBoxing.isBoxedInt(hValue)) {
            ((LongSequenceStorage)storage).setLongItemNormalized(idx, GraalHPyBoxing.unboxInt(hValue));
            return true;
        }
        if (storage instanceof ObjectSequenceStorage) {
            Object value = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(hValue));
            ((ObjectSequenceStorage)storage).setItemNormalized(idx, value);
            return true;
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    private static int setItemGeneric(Object receiver, Object clazz, Object key, Object value) {
        Object setItemAttribute = LookupCallableSlotInMRONode.getUncached(SpecialMethodSlot.SetItem).execute(clazz);
        if (setItemAttribute == PNone.NO_VALUE) {
            throw PRaiseNode.raiseUncached(null, PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_NOT_SUBSCRIPTABLE, receiver);
        }
        CallTernaryMethodNode.getUncached().execute(null, setItemAttribute, receiver, key, value);
        return 0;
    }

    public int ctxNumberCheck(long handle) {
        this.increment(HPyJNIUpcall.HPyNumberCheck);
        if (GraalHPyBoxing.isBoxedDouble(handle) || GraalHPyBoxing.isBoxedInt(handle)) {
            return 1;
        }
        Object receiver = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(handle));
        try {
            if (PyIndexCheckNode.executeUncached(receiver) || CanBeDoubleNode.executeUncached(receiver)) {
                return 1;
            }
            Object receiverType = GetClassNode.executeUncached(receiver);
            return PInt.intValue(LookupCallableSlotInMRONode.getUncached(SpecialMethodSlot.Int).execute(receiverType) != PNone.NO_VALUE);
        }
        catch (PException e) {
            GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(this.context, e);
            return 0;
        }
    }

    public long ctxLongFromSizet(long value) {
        this.increment(HPyJNIUpcall.HPyLongFromSizet);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_LONG_FROMSIZE_T, value);
    }

    public long ctxLongFromSsizet(long value) {
        this.increment(HPyJNIUpcall.HPyLongFromSsizet);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_LONG_FROMSSIZE_T, value);
    }

    public long ctxLongAsSizet(long h) {
        this.increment(HPyJNIUpcall.HPyLongAsSizet);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_LONG_ASSIZE_T, h);
    }

    public long ctxLongAsSsizet(long h) {
        this.increment(HPyJNIUpcall.HPyLongAsSsizet);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_LONG_ASSSIZE_T, h);
    }

    public long ctxLongAsVoidPtr(long h) {
        this.increment(HPyJNIUpcall.HPyLongAsVoidPtr);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_LONG_ASVOIDPTR, h);
    }

    public long ctxAdd(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPyAdd);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_ADD, h1, h2);
    }

    public long ctxSubtract(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPySubtract);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_SUBTRACT, h1, h2);
    }

    public long ctxMultiply(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPyMultiply);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_MULTIPLY, h1, h2);
    }

    public long ctxMatrixMultiply(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPyMatrixMultiply);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_MATRIXMULTIPLY, h1, h2);
    }

    public long ctxFloorDivide(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPyFloorDivide);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_FLOORDIVIDE, h1, h2);
    }

    public long ctxTrueDivide(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPyTrueDivide);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_TRUEDIVIDE, h1, h2);
    }

    public long ctxRemainder(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPyRemainder);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_REMAINDER, h1, h2);
    }

    public long ctxDivmod(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPyDivmod);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_DIVMOD, h1, h2);
    }

    public long ctxPower(long h1, long h2, long h3) {
        this.increment(HPyJNIUpcall.HPyPower);
        return this.executeLongContextFunction(HPyContextMember.CTX_POWER, new long[]{h1, h2, h3});
    }

    public long ctxNegative(long h1) {
        this.increment(HPyJNIUpcall.HPyNegative);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_NEGATIVE, h1);
    }

    public long ctxPositive(long h1) {
        this.increment(HPyJNIUpcall.HPyPositive);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_POSITIVE, h1);
    }

    public long ctxAbsolute(long h1) {
        this.increment(HPyJNIUpcall.HPyAbsolute);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_ABSOLUTE, h1);
    }

    public long ctxInvert(long h1) {
        this.increment(HPyJNIUpcall.HPyInvert);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_INVERT, h1);
    }

    public long ctxLshift(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPyLshift);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_LSHIFT, h1, h2);
    }

    public long ctxRshift(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPyRshift);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_RSHIFT, h1, h2);
    }

    public long ctxAnd(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPyAnd);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_AND, h1, h2);
    }

    public long ctxXor(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPyXor);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_XOR, h1, h2);
    }

    public long ctxOr(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPyOr);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_OR, h1, h2);
    }

    public long ctxIndex(long h1) {
        this.increment(HPyJNIUpcall.HPyIndex);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_INDEX, h1);
    }

    public long ctxLong(long h1) {
        this.increment(HPyJNIUpcall.HPyLong);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_LONG, h1);
    }

    public long ctxFloat(long h1) {
        this.increment(HPyJNIUpcall.HPyFloat);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_FLOAT, h1);
    }

    public long ctxInPlaceAdd(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPyInPlaceAdd);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_INPLACEADD, h1, h2);
    }

    public long ctxInPlaceSubtract(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPyInPlaceSubtract);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_INPLACESUBTRACT, h1, h2);
    }

    public long ctxInPlaceMultiply(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPyInPlaceMultiply);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_INPLACEMULTIPLY, h1, h2);
    }

    public long ctxInPlaceMatrixMultiply(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPyInPlaceMatrixMultiply);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_INPLACEMATRIXMULTIPLY, h1, h2);
    }

    public long ctxInPlaceFloorDivide(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPyInPlaceFloorDivide);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_INPLACEFLOORDIVIDE, h1, h2);
    }

    public long ctxInPlaceTrueDivide(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPyInPlaceTrueDivide);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_INPLACETRUEDIVIDE, h1, h2);
    }

    public long ctxInPlaceRemainder(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPyInPlaceRemainder);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_INPLACEREMAINDER, h1, h2);
    }

    public long ctxInPlacePower(long h1, long h2, long h3) {
        this.increment(HPyJNIUpcall.HPyInPlacePower);
        return this.executeLongContextFunction(HPyContextMember.CTX_INPLACEPOWER, new long[]{h1, h2, h3});
    }

    public long ctxInPlaceLshift(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPyInPlaceLshift);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_INPLACELSHIFT, h1, h2);
    }

    public long ctxInPlaceRshift(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPyInPlaceRshift);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_INPLACERSHIFT, h1, h2);
    }

    public long ctxInPlaceAnd(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPyInPlaceAnd);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_INPLACEAND, h1, h2);
    }

    public long ctxInPlaceXor(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPyInPlaceXor);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_INPLACEXOR, h1, h2);
    }

    public long ctxInPlaceOr(long h1, long h2) {
        this.increment(HPyJNIUpcall.HPyInPlaceOr);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_INPLACEOR, h1, h2);
    }

    public int ctxCallableCheck(long h) {
        this.increment(HPyJNIUpcall.HPyCallableCheck);
        return this.executeIntBinaryContextFunction(HPyContextMember.CTX_CALLABLE_CHECK, h);
    }

    public long ctxCallTupleDict(long callable, long args, long kw) {
        this.increment(HPyJNIUpcall.HPyCallTupleDict);
        return this.executeLongContextFunction(HPyContextMember.CTX_CALLTUPLEDICT, new long[]{callable, args, kw});
    }

    public void ctxFatalError(long message) {
        this.increment(HPyJNIUpcall.HPyFatalError);
        this.executeIntBinaryContextFunction(HPyContextMember.CTX_FATALERROR, message);
    }

    public void ctxErrSetString(long h_type, long message) {
        this.increment(HPyJNIUpcall.HPyErrSetString);
        this.executeIntTernaryContextFunction(HPyContextMember.CTX_ERR_SETSTRING, h_type, message);
    }

    public void ctxErrSetObject(long h_type, long h_value) {
        this.increment(HPyJNIUpcall.HPyErrSetObject);
        this.executeIntTernaryContextFunction(HPyContextMember.CTX_ERR_SETOBJECT, h_type, h_value);
    }

    public long ctxErrSetFromErrnoWithFilename(long h_type, long filename_fsencoded) {
        this.increment(HPyJNIUpcall.HPyErrSetFromErrnoWithFilename);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_ERR_SETFROMERRNOWITHFILENAME, h_type, filename_fsencoded);
    }

    public void ctxErrSetFromErrnoWithFilenameObjects(long h_type, long filename1, long filename2) {
        this.increment(HPyJNIUpcall.HPyErrSetFromErrnoWithFilenameObjects);
        this.executeIntContextFunction(HPyContextMember.CTX_ERR_SETFROMERRNOWITHFILENAMEOBJECTS, new long[]{h_type, filename1, filename2});
    }

    public int ctxErrOccurred() {
        this.increment(HPyJNIUpcall.HPyErrOccurred);
        return this.executeIntContextFunction(HPyContextMember.CTX_ERR_OCCURRED, new long[0]);
    }

    public int ctxErrExceptionMatches(long exc) {
        this.increment(HPyJNIUpcall.HPyErrExceptionMatches);
        return this.executeIntBinaryContextFunction(HPyContextMember.CTX_ERR_EXCEPTIONMATCHES, exc);
    }

    public void ctxErrNoMemory() {
        this.increment(HPyJNIUpcall.HPyErrNoMemory);
        this.executeIntContextFunction(HPyContextMember.CTX_ERR_NOMEMORY, new long[0]);
    }

    public void ctxErrClear() {
        this.increment(HPyJNIUpcall.HPyErrClear);
        this.executeIntContextFunction(HPyContextMember.CTX_ERR_CLEAR, new long[0]);
    }

    public long ctxErrNewException(long name, long base, long dict) {
        this.increment(HPyJNIUpcall.HPyErrNewException);
        return this.executeLongContextFunction(HPyContextMember.CTX_ERR_NEWEXCEPTION, new long[]{name, base, dict});
    }

    public long ctxErrNewExceptionWithDoc(long name, long doc, long base, long dict) {
        this.increment(HPyJNIUpcall.HPyErrNewExceptionWithDoc);
        return this.executeLongContextFunction(HPyContextMember.CTX_ERR_NEWEXCEPTIONWITHDOC, new long[]{name, doc, base, dict});
    }

    public int ctxErrWarnEx(long category, long message, long stack_level) {
        this.increment(HPyJNIUpcall.HPyErrWarnEx);
        return this.executeIntContextFunction(HPyContextMember.CTX_ERR_WARNEX, new long[]{category, message, stack_level});
    }

    public void ctxErrWriteUnraisable(long obj) {
        this.increment(HPyJNIUpcall.HPyErrWriteUnraisable);
        this.executeIntBinaryContextFunction(HPyContextMember.CTX_ERR_WRITEUNRAISABLE, obj);
    }

    public int ctxIsTrue(long h) {
        this.increment(HPyJNIUpcall.HPyIsTrue);
        return this.executeIntBinaryContextFunction(HPyContextMember.CTX_ISTRUE, h);
    }

    public long ctxTypeFromSpec(long spec, long params) {
        this.increment(HPyJNIUpcall.HPyTypeFromSpec);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_TYPE_FROMSPEC, spec, params);
    }

    public long ctxGetAttr(long obj, long name) {
        this.increment(HPyJNIUpcall.HPyGetAttr);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_GETATTR, obj, name);
    }

    public int ctxHasAttr(long obj, long name) {
        this.increment(HPyJNIUpcall.HPyHasAttr);
        return this.executeIntTernaryContextFunction(HPyContextMember.CTX_HASATTR, obj, name);
    }

    public int ctxHasAttrs(long obj, long name) {
        this.increment(HPyJNIUpcall.HPyHasAttrs);
        return this.executeIntTernaryContextFunction(HPyContextMember.CTX_HASATTR_S, obj, name);
    }

    public int ctxSetAttr(long obj, long name, long value) {
        this.increment(HPyJNIUpcall.HPySetAttr);
        return this.executeIntContextFunction(HPyContextMember.CTX_SETATTR, new long[]{obj, name, value});
    }

    public int ctxSetAttrs(long obj, long name, long value) {
        this.increment(HPyJNIUpcall.HPySetAttrs);
        return this.executeIntContextFunction(HPyContextMember.CTX_SETATTR_S, new long[]{obj, name, value});
    }

    public long ctxGetItem(long obj, long key) {
        this.increment(HPyJNIUpcall.HPyGetItem);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_GETITEM, obj, key);
    }

    public int ctxContains(long container, long key) {
        this.increment(HPyJNIUpcall.HPyContains);
        return this.executeIntTernaryContextFunction(HPyContextMember.CTX_CONTAINS, container, key);
    }

    public int ctxTypeIsSubtype(long sub, long type) {
        this.increment(HPyJNIUpcall.HPyTypeIsSubtype);
        return this.executeIntTernaryContextFunction(HPyContextMember.CTX_TYPE_ISSUBTYPE, sub, type);
    }

    public long ctxRepr(long obj) {
        this.increment(HPyJNIUpcall.HPyRepr);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_REPR, obj);
    }

    public long ctxStr(long obj) {
        this.increment(HPyJNIUpcall.HPyStr);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_STR, obj);
    }

    public long ctxASCII(long obj) {
        this.increment(HPyJNIUpcall.HPyASCII);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_ASCII, obj);
    }

    public long ctxBytes(long obj) {
        this.increment(HPyJNIUpcall.HPyBytes);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_BYTES, obj);
    }

    public long ctxRichCompare(long v, long w, int op) {
        this.increment(HPyJNIUpcall.HPyRichCompare);
        return this.executeLongContextFunction(HPyContextMember.CTX_RICHCOMPARE, new Object[]{v, w, op});
    }

    public int ctxRichCompareBool(long v, long w, int op) {
        this.increment(HPyJNIUpcall.HPyRichCompareBool);
        return this.executeIntContextFunction(HPyContextMember.CTX_RICHCOMPAREBOOL, new Object[]{v, w, op});
    }

    public long ctxHash(long obj) {
        this.increment(HPyJNIUpcall.HPyHash);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_HASH, obj);
    }

    public int ctxBytesCheck(long h) {
        this.increment(HPyJNIUpcall.HPyBytesCheck);
        if (GraalHPyBoxing.isBoxedHandle(h)) {
            Object object = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(h));
            if (object instanceof PBytes) {
                return 1;
            }
            return this.executeIntBinaryContextFunction(HPyContextMember.CTX_BYTES_CHECK, h);
        }
        return 0;
    }

    public long ctxBytesSize(long h) {
        this.increment(HPyJNIUpcall.HPyBytesSize);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_BYTES_SIZE, h);
    }

    public long ctxBytesGETSIZE(long h) {
        this.increment(HPyJNIUpcall.HPyBytesGETSIZE);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_BYTES_GET_SIZE, h);
    }

    public long ctxBytesAsString(long h) {
        this.increment(HPyJNIUpcall.HPyBytesAsString);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_BYTES_ASSTRING, h);
    }

    public long ctxBytesASSTRING(long h) {
        this.increment(HPyJNIUpcall.HPyBytesASSTRING);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_BYTES_AS_STRING, h);
    }

    public long ctxBytesFromString(long v) {
        this.increment(HPyJNIUpcall.HPyBytesFromString);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_BYTES_FROMSTRING, v);
    }

    public long ctxBytesFromStringAndSize(long v, long len) {
        this.increment(HPyJNIUpcall.HPyBytesFromStringAndSize);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_BYTES_FROMSTRINGANDSIZE, v, len);
    }

    public long ctxUnicodeFromString(long utf8) {
        this.increment(HPyJNIUpcall.HPyUnicodeFromString);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_UNICODE_FROMSTRING, utf8);
    }

    public int ctxUnicodeCheck(long h) {
        this.increment(HPyJNIUpcall.HPyUnicodeCheck);
        return this.executeIntBinaryContextFunction(HPyContextMember.CTX_UNICODE_CHECK, h);
    }

    public long ctxUnicodeAsASCIIString(long h) {
        this.increment(HPyJNIUpcall.HPyUnicodeAsASCIIString);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_UNICODE_ASASCIISTRING, h);
    }

    public long ctxUnicodeAsLatin1String(long h) {
        this.increment(HPyJNIUpcall.HPyUnicodeAsLatin1String);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_UNICODE_ASLATIN1STRING, h);
    }

    public long ctxUnicodeAsUTF8String(long h) {
        this.increment(HPyJNIUpcall.HPyUnicodeAsUTF8String);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_UNICODE_ASUTF8STRING, h);
    }

    public long ctxUnicodeAsUTF8AndSize(long h, long size) {
        TruffleString tsUtf8;
        this.increment(HPyJNIUpcall.HPyUnicodeAsUTF8AndSize);
        Object string = this.context.bitsAsPythonObject(h);
        try {
            tsUtf8 = TruffleString.SwitchEncodingNode.getUncached().execute((AbstractTruffleString)CastToTruffleStringNode.executeUncached(string), TruffleString.Encoding.UTF_8);
        }
        catch (CannotCastException e) {
            return GraalHPyNodes.HPyRaiseNode.raiseIntUncached(this.context, 0, PythonBuiltinClassType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP, new Object[0]);
        }
        TruffleString nativeTName = TruffleString.AsNativeNode.getUncached().execute(tsUtf8, TS_NATIVE_ALLOCATOR, TruffleString.Encoding.UTF_8, false, true);
        Object result = TruffleString.GetInternalNativePointerNode.getUncached().execute((AbstractTruffleString)nativeTName, TruffleString.Encoding.UTF_8);
        if (size != 0L) {
            InternalByteArray internalByteArray = TruffleString.GetInternalByteArrayNode.getUncached().execute((AbstractTruffleString)tsUtf8, TruffleString.Encoding.UTF_8);
            GraalHPyJNINodes.UnsafeWriteSizeTNode.write(size, internalByteArray.getLength());
        }
        if (result instanceof NativePointer) {
            NativePointer nativePointer = (NativePointer)result;
            return nativePointer.asPointer();
        }
        return GraalHPyJNIContext.interopPointerToNative(result, InteropLibrary.getUncached((Object)result));
    }

    public long ctxUnicodeDecodeFSDefault(long v) {
        this.increment(HPyJNIUpcall.HPyUnicodeDecodeFSDefault);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_UNICODE_DECODEFSDEFAULT, v);
    }

    public long ctxUnicodeDecodeFSDefaultAndSize(long v, long size) {
        this.increment(HPyJNIUpcall.HPyUnicodeDecodeFSDefaultAndSize);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_UNICODE_DECODEFSDEFAULTANDSIZE, v, size);
    }

    public long ctxUnicodeEncodeFSDefault(long h) {
        this.increment(HPyJNIUpcall.HPyUnicodeEncodeFSDefault);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_UNICODE_ENCODEFSDEFAULT, h);
    }

    public int ctxUnicodeReadChar(long h, long index) {
        this.increment(HPyJNIUpcall.HPyUnicodeReadChar);
        return this.executeIntTernaryContextFunction(HPyContextMember.CTX_UNICODE_READCHAR, h, index);
    }

    public long ctxUnicodeDecodeASCII(long s, long size, long errors) {
        this.increment(HPyJNIUpcall.HPyUnicodeDecodeASCII);
        return this.executeLongContextFunction(HPyContextMember.CTX_UNICODE_DECODEASCII, new long[]{s, size, errors});
    }

    public long ctxUnicodeDecodeLatin1(long s, long size, long errors) {
        this.increment(HPyJNIUpcall.HPyUnicodeDecodeLatin1);
        return this.executeLongContextFunction(HPyContextMember.CTX_UNICODE_DECODELATIN1, new long[]{s, size, errors});
    }

    public long ctxUnicodeFromEncodedObject(long obj, long encoding, long errors) {
        this.increment(HPyJNIUpcall.HPyUnicodeFromEncodedObject);
        return this.executeLongContextFunction(HPyContextMember.CTX_UNICODE_FROMENCODEDOBJECT, new long[]{obj, encoding, errors});
    }

    public long ctxUnicodeSubstring(long obj, long start, long end) {
        this.increment(HPyJNIUpcall.HPyUnicodeSubstring);
        return this.executeLongContextFunction(HPyContextMember.CTX_UNICODE_SUBSTRING, new long[]{obj, start, end});
    }

    public int ctxListAppend(long h_list, long h_item) {
        this.increment(HPyJNIUpcall.HPyListAppend);
        return this.executeIntTernaryContextFunction(HPyContextMember.CTX_LIST_APPEND, h_list, h_item);
    }

    public int ctxDictCheck(long h) {
        this.increment(HPyJNIUpcall.HPyDictCheck);
        return this.executeIntBinaryContextFunction(HPyContextMember.CTX_DICT_CHECK, h);
    }

    public long ctxDictKeys(long h) {
        this.increment(HPyJNIUpcall.HPyDictKeys);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_DICT_KEYS, h);
    }

    public int ctxTupleCheck(long h) {
        this.increment(HPyJNIUpcall.HPyTupleCheck);
        return this.executeIntBinaryContextFunction(HPyContextMember.CTX_TUPLE_CHECK, h);
    }

    public int ctxSliceUnpack(long slice, long start, long stop, long step) {
        this.increment(HPyJNIUpcall.HPySliceUnpack);
        return this.executeIntContextFunction(HPyContextMember.CTX_SLICE_UNPACK, new long[]{slice, start, stop, step});
    }

    public long ctxContextVarNew(long name, long default_value) {
        this.increment(HPyJNIUpcall.HPyContextVarNew);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_CONTEXTVAR_NEW, name, default_value);
    }

    public long ctxContextVarSet(long context_var, long value) {
        this.increment(HPyJNIUpcall.HPyContextVarSet);
        return this.executeLongTernaryContextFunction(HPyContextMember.CTX_CONTEXTVAR_SET, context_var, value);
    }

    public long ctxImportImportModule(long name) {
        this.increment(HPyJNIUpcall.HPyImportImportModule);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_IMPORT_IMPORTMODULE, name);
    }

    public int ctxCapsuleIsValid(long capsule, long name) {
        this.increment(HPyJNIUpcall.HPyCapsuleIsValid);
        return this.executeIntTernaryContextFunction(HPyContextMember.CTX_CAPSULE_ISVALID, capsule, name);
    }

    public int ctxCapsuleSet(long capsule, int key, long value) {
        this.increment(HPyJNIUpcall.HPyCapsuleSet);
        return this.executeIntContextFunction(HPyContextMember.CTX_CAPSULE_SET, new Object[]{capsule, key, value});
    }

    public long ctxFromPyObject(long obj) {
        this.increment(HPyJNIUpcall.HPyFromPyObject);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_FROMPYOBJECT, obj);
    }

    public long ctxAsPyObject(long h) {
        this.increment(HPyJNIUpcall.HPyAsPyObject);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_ASPYOBJECT, h);
    }

    public long ctxListBuilderNew(long initial_size) {
        this.increment(HPyJNIUpcall.HPyListBuilderNew);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_LISTBUILDER_NEW, initial_size);
    }

    public void ctxListBuilderSet(long builder, long index, long h_item) {
        this.increment(HPyJNIUpcall.HPyListBuilderSet);
        this.executeIntContextFunction(HPyContextMember.CTX_LISTBUILDER_SET, new long[]{builder, index, h_item});
    }

    public long ctxListBuilderBuild(long builder) {
        this.increment(HPyJNIUpcall.HPyListBuilderBuild);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_LISTBUILDER_BUILD, builder);
    }

    public void ctxListBuilderCancel(long builder) {
        this.increment(HPyJNIUpcall.HPyListBuilderCancel);
        this.executeIntBinaryContextFunction(HPyContextMember.CTX_LISTBUILDER_CANCEL, builder);
    }

    public long ctxTupleBuilderNew(long initial_size) {
        this.increment(HPyJNIUpcall.HPyTupleBuilderNew);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_TUPLEBUILDER_NEW, initial_size);
    }

    public void ctxTupleBuilderSet(long builder, long index, long h_item) {
        this.increment(HPyJNIUpcall.HPyTupleBuilderSet);
        this.executeIntContextFunction(HPyContextMember.CTX_TUPLEBUILDER_SET, new long[]{builder, index, h_item});
    }

    public long ctxTupleBuilderBuild(long builder) {
        this.increment(HPyJNIUpcall.HPyTupleBuilderBuild);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_TUPLEBUILDER_BUILD, builder);
    }

    public void ctxTupleBuilderCancel(long builder) {
        this.increment(HPyJNIUpcall.HPyTupleBuilderCancel);
        this.executeIntBinaryContextFunction(HPyContextMember.CTX_TUPLEBUILDER_CANCEL, builder);
    }

    public void ctxReenterPythonExecution(long state) {
        this.increment(HPyJNIUpcall.HPyReenterPythonExecution);
        this.executeIntBinaryContextFunction(HPyContextMember.CTX_REENTERPYTHONEXECUTION, state);
    }

    public long ctxLeavePythonExecution() {
        this.increment(HPyJNIUpcall.HPyLeavePythonExecution);
        return this.executeLongContextFunction(HPyContextMember.CTX_LEAVEPYTHONEXECUTION, new long[0]);
    }

    public void ctxDump(long h) {
        this.increment(HPyJNIUpcall.HPyDump);
        this.executeIntBinaryContextFunction(HPyContextMember.CTX_DUMP, h);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long ctxCall(long callable, long args, long lnargs, long kwnames) {
        this.increment(HPyJNIUpcall.HPyCall);
        assert (callable != 0L && GraalHPyBoxing.isBoxedHandle(callable));
        assert (kwnames == 0L || GraalHPyBoxing.isBoxedHandle(kwnames));
        assert (args != 0L || lnargs == 0L);
        try {
            PKeyword[] keywords;
            if (!PInt.isIntRange(lnargs)) {
                throw PRaiseNode.raiseUncached(null, PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_DOES_NOT_SUPPORT_ITEM_ASSIGMENT, 0);
            }
            int nargs = (int)lnargs;
            Object callableObj = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(callable));
            Object[] argsArr = new Object[nargs];
            for (int i = 0; i < argsArr.length; ++i) {
                long argBits = CArrayWrappers.UNSAFE.getLong(args + (long)i * 8L);
                argsArr[i] = this.context.bitsAsPythonObject(argBits);
            }
            if (kwnames != 0L) {
                Object kwnamesObj = this.context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(kwnames));
                if (!(kwnamesObj instanceof PTuple)) throw CompilerDirectives.shouldNotReachHere();
                PTuple kwnamesTuple = (PTuple)kwnamesObj;
                int nkw = kwnamesTuple.getSequenceStorage().length();
                Object[] kwvalues = new Object[nkw];
                long kwvaluesPtr = args + (long)nargs * 8L;
                for (int i = 0; i < kwvalues.length; ++i) {
                    long argBits = CArrayWrappers.UNSAFE.getLong(kwvaluesPtr + (long)i * 8L);
                    kwvalues[i] = this.context.bitsAsPythonObject(argBits);
                }
                keywords = GraalHPyNodesFactory.HPyPackKeywordArgsNodeGen.getUncached().execute(null, kwvalues, kwnamesTuple, nkw);
            } else {
                keywords = PKeyword.EMPTY_KEYWORDS;
            }
            Object result = CallNode.getUncached().execute(callableObj, argsArr, keywords);
            return this.context.pythonObjectAsBits(result);
        }
        catch (PException e) {
            GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(e);
            return 0L;
        }
        catch (Throwable t) {
            throw GraalHPyJNIContext.checkThrowableBeforeNative(t, "HPy context function", HPyJNIUpcall.HPyCall.getName());
        }
    }

    public long ctxCallMethod(long name, long args, long nargs, long kwnames) {
        this.increment(HPyJNIUpcall.HPyCallMethod);
        return this.executeLongContextFunction(HPyContextMember.CTX_CALLMETHOD, new long[]{name, args, nargs, kwnames});
    }

    public int ctxDelItem(long obj, long key) {
        this.increment(HPyJNIUpcall.HPyDelItem);
        return this.executeIntTernaryContextFunction(HPyContextMember.CTX_DELITEM, obj, key);
    }

    public int ctxDelItemi(long obj, long idx) {
        this.increment(HPyJNIUpcall.HPyDelItemi);
        return this.executeIntTernaryContextFunction(HPyContextMember.CTX_DELITEM_I, obj, idx);
    }

    public int ctxDelItems(long obj, long utf8_key) {
        this.increment(HPyJNIUpcall.HPyDelItems);
        return this.executeIntTernaryContextFunction(HPyContextMember.CTX_DELITEM_S, obj, utf8_key);
    }

    public int ctxTypeGetBuiltinShape(long h_type) {
        this.increment(HPyJNIUpcall.HPyTypeGetBuiltinShape);
        assert (GraalHPyBoxing.isBoxedHandle(h_type));
        Object typeObject = this.context.bitsAsPythonObject(h_type);
        int result = GraalHPyDef.getBuiltinShapeFromHiddenAttribute(typeObject);
        if (result == -2) {
            return GraalHPyNodes.HPyRaiseNode.raiseIntUncached(this.context, -2, PythonBuiltinClassType.TypeError, ErrorMessages.S_MUST_BE_S, "arg", "type");
        }
        assert (GraalHPyDef.isValidBuiltinShape(result));
        return result;
    }

    public long ctxDictCopy(long h) {
        this.increment(HPyJNIUpcall.HPyDictCopy);
        return this.executeLongBinaryContextFunction(HPyContextMember.CTX_DICT_COPY, h);
    }

    public long ctxCompiles(long utf8_source, long utf8_filename, int kind) {
        this.increment(HPyJNIUpcall.HPyCompiles);
        return this.executeLongContextFunction(HPyContextMember.CTX_COMPILE_S, new Object[]{utf8_source, utf8_filename, kind});
    }

    public long ctxEvalCode(long code, long globals, long locals) {
        this.increment(HPyJNIUpcall.HPyEvalCode);
        return this.executeLongContextFunction(HPyContextMember.CTX_EVALCODE, new long[]{code, globals, locals});
    }

    public int ctxSetCallFunction(long h, long func) {
        this.increment(HPyJNIUpcall.HPySetCallFunction);
        return this.executeIntTernaryContextFunction(HPyContextMember.CTX_SETCALLFUNCTION, h, func);
    }

    private long createConstant(Object value) {
        return this.context.getHPyContextHandle(value);
    }

    private long createBuiltinsConstant() {
        return this.createConstant(GetOrCreateDictNode.executeUncached(this.context.getContext().getBuiltins()));
    }

    private static long createSingletonConstant(Object value, int handle) {
        assert (GraalHPyContext.getHPyHandleForSingleton(value) == handle);
        return handle;
    }

    private long createTypeConstant(PythonBuiltinClassType value) {
        return this.context.getHPyContextHandle(this.context.getContext().lookupType(value));
    }

    private long[] createContextHandleArray() {
        long[] ctxHandles = new long[244];
        ctxHandles[0] = GraalHPyJNIContext.createSingletonConstant(PNone.NONE, 1);
        ctxHandles[1] = this.createConstant(this.context.getContext().getTrue());
        ctxHandles[2] = this.createConstant(this.context.getContext().getFalse());
        ctxHandles[3] = GraalHPyJNIContext.createSingletonConstant(PNotImplemented.NOT_IMPLEMENTED, 2);
        ctxHandles[4] = GraalHPyJNIContext.createSingletonConstant(PEllipsis.INSTANCE, 3);
        ctxHandles[5] = this.createTypeConstant(PythonBuiltinClassType.PBaseException);
        ctxHandles[6] = this.createTypeConstant(PythonBuiltinClassType.Exception);
        ctxHandles[7] = this.createTypeConstant(PythonBuiltinClassType.StopAsyncIteration);
        ctxHandles[8] = this.createTypeConstant(PythonBuiltinClassType.StopIteration);
        ctxHandles[9] = this.createTypeConstant(PythonBuiltinClassType.GeneratorExit);
        ctxHandles[10] = this.createTypeConstant(PythonBuiltinClassType.ArithmeticError);
        ctxHandles[11] = this.createTypeConstant(PythonBuiltinClassType.LookupError);
        ctxHandles[12] = this.createTypeConstant(PythonBuiltinClassType.AssertionError);
        ctxHandles[13] = this.createTypeConstant(PythonBuiltinClassType.AttributeError);
        ctxHandles[14] = this.createTypeConstant(PythonBuiltinClassType.BufferError);
        ctxHandles[15] = this.createTypeConstant(PythonBuiltinClassType.EOFError);
        ctxHandles[16] = this.createTypeConstant(PythonBuiltinClassType.FloatingPointError);
        ctxHandles[17] = this.createTypeConstant(PythonBuiltinClassType.OSError);
        ctxHandles[18] = this.createTypeConstant(PythonBuiltinClassType.ImportError);
        ctxHandles[19] = this.createTypeConstant(PythonBuiltinClassType.ModuleNotFoundError);
        ctxHandles[20] = this.createTypeConstant(PythonBuiltinClassType.IndexError);
        ctxHandles[21] = this.createTypeConstant(PythonBuiltinClassType.KeyError);
        ctxHandles[22] = this.createTypeConstant(PythonBuiltinClassType.KeyboardInterrupt);
        ctxHandles[23] = this.createTypeConstant(PythonBuiltinClassType.MemoryError);
        ctxHandles[24] = this.createTypeConstant(PythonBuiltinClassType.NameError);
        ctxHandles[25] = this.createTypeConstant(PythonBuiltinClassType.OverflowError);
        ctxHandles[26] = this.createTypeConstant(PythonBuiltinClassType.RuntimeError);
        ctxHandles[27] = this.createTypeConstant(PythonBuiltinClassType.RecursionError);
        ctxHandles[28] = this.createTypeConstant(PythonBuiltinClassType.NotImplementedError);
        ctxHandles[29] = this.createTypeConstant(PythonBuiltinClassType.SyntaxError);
        ctxHandles[30] = this.createTypeConstant(PythonBuiltinClassType.IndentationError);
        ctxHandles[31] = this.createTypeConstant(PythonBuiltinClassType.TabError);
        ctxHandles[32] = this.createTypeConstant(PythonBuiltinClassType.ReferenceError);
        ctxHandles[33] = this.createTypeConstant(PythonBuiltinClassType.SystemError);
        ctxHandles[34] = this.createTypeConstant(PythonBuiltinClassType.SystemExit);
        ctxHandles[35] = this.createTypeConstant(PythonBuiltinClassType.TypeError);
        ctxHandles[36] = this.createTypeConstant(PythonBuiltinClassType.UnboundLocalError);
        ctxHandles[37] = this.createTypeConstant(PythonBuiltinClassType.UnicodeError);
        ctxHandles[38] = this.createTypeConstant(PythonBuiltinClassType.UnicodeEncodeError);
        ctxHandles[39] = this.createTypeConstant(PythonBuiltinClassType.UnicodeDecodeError);
        ctxHandles[40] = this.createTypeConstant(PythonBuiltinClassType.UnicodeTranslateError);
        ctxHandles[41] = this.createTypeConstant(PythonBuiltinClassType.ValueError);
        ctxHandles[42] = this.createTypeConstant(PythonBuiltinClassType.ZeroDivisionError);
        ctxHandles[43] = this.createTypeConstant(PythonBuiltinClassType.BlockingIOError);
        ctxHandles[44] = this.createTypeConstant(PythonBuiltinClassType.BrokenPipeError);
        ctxHandles[45] = this.createTypeConstant(PythonBuiltinClassType.ChildProcessError);
        ctxHandles[46] = this.createTypeConstant(PythonBuiltinClassType.ConnectionError);
        ctxHandles[47] = this.createTypeConstant(PythonBuiltinClassType.ConnectionAbortedError);
        ctxHandles[48] = this.createTypeConstant(PythonBuiltinClassType.ConnectionRefusedError);
        ctxHandles[49] = this.createTypeConstant(PythonBuiltinClassType.ConnectionResetError);
        ctxHandles[50] = this.createTypeConstant(PythonBuiltinClassType.FileExistsError);
        ctxHandles[51] = this.createTypeConstant(PythonBuiltinClassType.FileNotFoundError);
        ctxHandles[52] = this.createTypeConstant(PythonBuiltinClassType.InterruptedError);
        ctxHandles[53] = this.createTypeConstant(PythonBuiltinClassType.IsADirectoryError);
        ctxHandles[54] = this.createTypeConstant(PythonBuiltinClassType.NotADirectoryError);
        ctxHandles[55] = this.createTypeConstant(PythonBuiltinClassType.PermissionError);
        ctxHandles[56] = this.createTypeConstant(PythonBuiltinClassType.ProcessLookupError);
        ctxHandles[57] = this.createTypeConstant(PythonBuiltinClassType.TimeoutError);
        ctxHandles[58] = this.createTypeConstant(PythonBuiltinClassType.Warning);
        ctxHandles[59] = this.createTypeConstant(PythonBuiltinClassType.UserWarning);
        ctxHandles[60] = this.createTypeConstant(PythonBuiltinClassType.DeprecationWarning);
        ctxHandles[61] = this.createTypeConstant(PythonBuiltinClassType.PendingDeprecationWarning);
        ctxHandles[62] = this.createTypeConstant(PythonBuiltinClassType.SyntaxWarning);
        ctxHandles[63] = this.createTypeConstant(PythonBuiltinClassType.RuntimeWarning);
        ctxHandles[64] = this.createTypeConstant(PythonBuiltinClassType.FutureWarning);
        ctxHandles[65] = this.createTypeConstant(PythonBuiltinClassType.ImportWarning);
        ctxHandles[66] = this.createTypeConstant(PythonBuiltinClassType.UnicodeWarning);
        ctxHandles[67] = this.createTypeConstant(PythonBuiltinClassType.BytesWarning);
        ctxHandles[68] = this.createTypeConstant(PythonBuiltinClassType.ResourceWarning);
        ctxHandles[69] = this.createTypeConstant(PythonBuiltinClassType.PythonObject);
        ctxHandles[70] = this.createTypeConstant(PythonBuiltinClassType.PythonClass);
        ctxHandles[71] = this.createTypeConstant(PythonBuiltinClassType.Boolean);
        ctxHandles[72] = this.createTypeConstant(PythonBuiltinClassType.PInt);
        ctxHandles[73] = this.createTypeConstant(PythonBuiltinClassType.PFloat);
        ctxHandles[74] = this.createTypeConstant(PythonBuiltinClassType.PString);
        ctxHandles[75] = this.createTypeConstant(PythonBuiltinClassType.PTuple);
        ctxHandles[76] = this.createTypeConstant(PythonBuiltinClassType.PList);
        ctxHandles[238] = this.createTypeConstant(PythonBuiltinClassType.PComplex);
        ctxHandles[239] = this.createTypeConstant(PythonBuiltinClassType.PBytes);
        ctxHandles[240] = this.createTypeConstant(PythonBuiltinClassType.PMemoryView);
        ctxHandles[241] = this.createTypeConstant(PythonBuiltinClassType.Capsule);
        ctxHandles[242] = this.createTypeConstant(PythonBuiltinClassType.PSlice);
        ctxHandles[243] = this.createBuiltinsConstant();
        return ctxHandles;
    }

    private Object executeContextFunction(HPyContextMember member, long[] arguments) {
        HPyContextSignature signature = member.getSignature();
        HPyContextSignatureType[] argTypes = signature.parameterTypes();
        assert (arguments.length == argTypes.length - 1);
        Object[] argCast = new Object[argTypes.length];
        argCast[0] = this.context;
        for (int i = 1; i < argCast.length; ++i) {
            argCast[i] = this.convertLongArg(argTypes[i], arguments[i - 1]);
        }
        return GraalHPyContextFunctions.GraalHPyContextFunction.getUncached(member).execute(argCast);
    }

    private Object executeBinaryContextFunction(HPyContextMember member, long larg0) {
        HPyContextSignature signature = member.getSignature();
        HPyContextSignatureType[] argTypes = signature.parameterTypes();
        assert (argTypes.length - 1 == 1);
        Object arg0 = this.convertLongArg(argTypes[1], larg0);
        return ((GraalHPyContextFunctions.HPyBinaryContextFunction)GraalHPyContextFunctions.GraalHPyContextFunction.getUncached(member)).execute(this.context, arg0);
    }

    private Object executeTernaryContextFunction(HPyContextMember member, long larg0, long larg1) {
        HPyContextSignature signature = member.getSignature();
        HPyContextSignatureType[] argTypes = signature.parameterTypes();
        assert (argTypes.length - 1 == 2);
        Object arg0 = this.convertLongArg(argTypes[1], larg0);
        Object arg1 = this.convertLongArg(argTypes[2], larg1);
        return ((GraalHPyContextFunctions.HPyTernaryContextFunction)GraalHPyContextFunctions.GraalHPyContextFunction.getUncached(member)).execute(this.context, arg0, arg1);
    }

    private Object executeContextFunction(HPyContextMember member, Object[] arguments) {
        HPyContextSignature signature = member.getSignature();
        HPyContextSignatureType[] argTypes = signature.parameterTypes();
        assert (arguments.length == argTypes.length - 1);
        Object[] argCast = new Object[argTypes.length];
        argCast[0] = this.context;
        for (int i = 1; i < argCast.length; ++i) {
            argCast[i] = this.convertArg(argTypes[i], arguments[i - 1]);
        }
        return GraalHPyContextFunctions.GraalHPyContextFunction.getUncached(member).execute(argCast);
    }

    private long executeLongContextFunction(HPyContextMember member, long[] arguments) {
        try {
            Object result = this.executeContextFunction(member, arguments);
            return this.convertLongRet(member.getSignature().returnType(), result);
        }
        catch (PException e) {
            GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(e);
            return this.getLongErrorValue(member.getSignature().returnType());
        }
        catch (Throwable t) {
            throw GraalHPyJNIContext.checkThrowableBeforeNative(t, "HPy context function", member.getName());
        }
    }

    private long executeLongBinaryContextFunction(HPyContextMember member, long arg0) {
        try {
            Object result = this.executeBinaryContextFunction(member, arg0);
            return this.convertLongRet(member.getSignature().returnType(), result);
        }
        catch (PException e) {
            GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(e);
            return this.getLongErrorValue(member.getSignature().returnType());
        }
        catch (Throwable t) {
            throw GraalHPyJNIContext.checkThrowableBeforeNative(t, "HPy context function", member.getName());
        }
    }

    private long executeLongTernaryContextFunction(HPyContextMember member, long arg0, long arg1) {
        try {
            Object result = this.executeTernaryContextFunction(member, arg0, arg1);
            return this.convertLongRet(member.getSignature().returnType(), result);
        }
        catch (PException e) {
            GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(e);
            return this.getLongErrorValue(member.getSignature().returnType());
        }
        catch (Throwable t) {
            throw GraalHPyJNIContext.checkThrowableBeforeNative(t, "HPy context function", member.getName());
        }
    }

    private int executeIntContextFunction(HPyContextMember member, long[] arguments) {
        try {
            Object result = this.executeContextFunction(member, arguments);
            return this.convertIntRet(member.getSignature().returnType(), result);
        }
        catch (PException e) {
            GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(e);
            return this.getIntErrorValue(member.getSignature().returnType());
        }
        catch (Throwable t) {
            throw GraalHPyJNIContext.checkThrowableBeforeNative(t, "HPy context function", member.getName());
        }
    }

    @CompilerDirectives.TruffleBoundary
    private int executeIntBinaryContextFunction(HPyContextMember member, long arg0) {
        try {
            Object result = this.executeBinaryContextFunction(member, arg0);
            return this.convertIntRet(member.getSignature().returnType(), result);
        }
        catch (PException e) {
            GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(e);
            return this.getIntErrorValue(member.getSignature().returnType());
        }
        catch (Throwable t) {
            throw GraalHPyJNIContext.checkThrowableBeforeNative(t, "HPy context function", member.getName());
        }
    }

    private int executeIntTernaryContextFunction(HPyContextMember member, long arg0, long arg1) {
        try {
            Object result = this.executeTernaryContextFunction(member, arg0, arg1);
            return this.convertIntRet(member.getSignature().returnType(), result);
        }
        catch (PException e) {
            GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(e);
            return this.getIntErrorValue(member.getSignature().returnType());
        }
        catch (Throwable t) {
            throw GraalHPyJNIContext.checkThrowableBeforeNative(t, "HPy context function", member.getName());
        }
    }

    private long executeLongContextFunction(HPyContextMember member, Object[] arguments) {
        try {
            Object result = this.executeContextFunction(member, arguments);
            return this.convertLongRet(member.getSignature().returnType(), result);
        }
        catch (PException e) {
            GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(e);
            return this.getLongErrorValue(member.getSignature().returnType());
        }
        catch (Throwable t) {
            throw GraalHPyJNIContext.checkThrowableBeforeNative(t, "HPy context function", member.getName());
        }
    }

    private int executeIntContextFunction(HPyContextMember member, Object[] arguments) {
        try {
            Object result = this.executeContextFunction(member, arguments);
            return this.convertIntRet(member.getSignature().returnType(), result);
        }
        catch (PException e) {
            GraalHPyNodes.HPyTransformExceptionToNativeNode.executeUncached(e);
            return this.getIntErrorValue(member.getSignature().returnType());
        }
        catch (Throwable t) {
            throw GraalHPyJNIContext.checkThrowableBeforeNative(t, "HPy context function", member.getName());
        }
    }

    private Object convertLongArg(HPyContextSignatureType type, long argBits) {
        return switch (type) {
            case HPyContextSignatureType.HPy, HPyContextSignatureType.HPyThreadState, HPyContextSignatureType.HPyListBuilder, HPyContextSignatureType.HPyTupleBuilder -> this.context.bitsAsPythonObject(argBits);
            case HPyContextSignatureType.Int, HPyContextSignatureType.HPy_UCS4 -> -1;
            case HPyContextSignatureType.Int64_t, HPyContextSignatureType.Uint64_t, HPyContextSignatureType.Size_t, HPyContextSignatureType.HPy_ssize_t, HPyContextSignatureType.HPy_hash_t, HPyContextSignatureType.VoidPtr, HPyContextSignatureType.CVoid -> argBits;
            case HPyContextSignatureType.Int32_t, HPyContextSignatureType.Uint32_t -> argBits & 0xFFFFFFFFL;
            case HPyContextSignatureType.CDouble -> throw CompilerDirectives.shouldNotReachHere((String)"invalid argument handle");
            case HPyContextSignatureType.HPyModuleDefPtr, HPyContextSignatureType.HPyType_SpecPtr, HPyContextSignatureType.HPyType_SpecParamPtr, HPyContextSignatureType.HPy_ssize_tPtr, HPyContextSignatureType.ConstHPyPtr, HPyContextSignatureType.HPyPtr, HPyContextSignatureType.HPyCallFunctionPtr, HPyContextSignatureType.CharPtr, HPyContextSignatureType.ConstCharPtr -> argBits;
            case HPyContextSignatureType.Cpy_PyObjectPtr -> this.nativeToInteropPointer(argBits);
            default -> throw CompilerDirectives.shouldNotReachHere((String)"unsupported arg type");
        };
    }

    private Object convertArg(HPyContextSignatureType type, Object arg) {
        return switch (type) {
            case HPyContextSignatureType.Int, HPyContextSignatureType.HPy_UCS4, HPyContextSignatureType.Int32_t, HPyContextSignatureType.Uint32_t, HPyContextSignatureType._HPyCapsule_key, HPyContextSignatureType.HPy_SourceKind -> (Integer)arg;
            default -> this.convertLongArg(type, (Long)arg);
        };
    }

    private long convertLongRet(HPyContextSignatureType type, Object result) {
        return switch (type) {
            case HPyContextSignatureType.HPy, HPyContextSignatureType.HPyThreadState, HPyContextSignatureType.HPyListBuilder, HPyContextSignatureType.HPyTupleBuilder -> GraalHPyBoxing.boxHandle(this.context.getHPyHandleForObject(result));
            case HPyContextSignatureType.VoidPtr, HPyContextSignatureType.CharPtr, HPyContextSignatureType.ConstCharPtr, HPyContextSignatureType.Cpy_PyObjectPtr -> GraalHPyJNIContext.coerceToPointer(result);
            case HPyContextSignatureType.Int64_t, HPyContextSignatureType.Uint64_t, HPyContextSignatureType.Size_t, HPyContextSignatureType.HPy_ssize_t, HPyContextSignatureType.HPy_hash_t -> (Long)GraalHPyNodesFactory.HPyAsNativeInt64NodeGen.getUncached().execute(result);
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
    }

    private int convertIntRet(HPyContextSignatureType type, Object result) {
        return switch (type) {
            case HPyContextSignatureType.Int, HPyContextSignatureType.HPy_UCS4, HPyContextSignatureType.Int32_t, HPyContextSignatureType.Uint32_t -> (Integer)result;
            case HPyContextSignatureType.CVoid -> 0;
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
    }

    private long getLongErrorValue(HPyContextSignatureType type) {
        return switch (type) {
            case HPyContextSignatureType.HPy, HPyContextSignatureType.HPyThreadState, HPyContextSignatureType.HPyListBuilder, HPyContextSignatureType.HPyTupleBuilder, HPyContextSignatureType.VoidPtr, HPyContextSignatureType.CharPtr, HPyContextSignatureType.ConstCharPtr, HPyContextSignatureType.Cpy_PyObjectPtr -> 0L;
            case HPyContextSignatureType.Int64_t, HPyContextSignatureType.Uint64_t, HPyContextSignatureType.Size_t, HPyContextSignatureType.HPy_ssize_t, HPyContextSignatureType.HPy_hash_t -> -1L;
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
    }

    private int getIntErrorValue(HPyContextSignatureType type) {
        return switch (type) {
            case HPyContextSignatureType.Int, HPyContextSignatureType.HPy_UCS4, HPyContextSignatureType.Int32_t, HPyContextSignatureType.Uint32_t -> -1;
            case HPyContextSignatureType.CVoid -> 0;
            case HPyContextSignatureType.HPyType_BuiltinShape -> -2;
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
    }

    static enum HPyJNIUpcall implements GraalHPyContext.HPyUpcall
    {
        HPyUnicodeFromJCharArray,
        HPyBulkClose,
        HPySequenceFromArray,
        HPyDup,
        HPyClose,
        HPyLongFromInt32t,
        HPyLongFromUInt32t,
        HPyLongFromInt64t,
        HPyLongFromUInt64t,
        HPyLongFromSizet,
        HPyLongFromSsizet,
        HPyLongAsInt32t,
        HPyLongAsUInt32t,
        HPyLongAsUInt32tMask,
        HPyLongAsInt64t,
        HPyLongAsUInt64t,
        HPyLongAsUInt64tMask,
        HPyLongAsSizet,
        HPyLongAsSsizet,
        HPyLongAsVoidPtr,
        HPyLongAsDouble,
        HPyFloatFromDouble,
        HPyFloatAsDouble,
        HPyBoolFromBool,
        HPyLength,
        HPyNumberCheck,
        HPyAdd,
        HPySubtract,
        HPyMultiply,
        HPyMatrixMultiply,
        HPyFloorDivide,
        HPyTrueDivide,
        HPyRemainder,
        HPyDivmod,
        HPyPower,
        HPyNegative,
        HPyPositive,
        HPyAbsolute,
        HPyInvert,
        HPyLshift,
        HPyRshift,
        HPyAnd,
        HPyXor,
        HPyOr,
        HPyIndex,
        HPyLong,
        HPyFloat,
        HPyInPlaceAdd,
        HPyInPlaceSubtract,
        HPyInPlaceMultiply,
        HPyInPlaceMatrixMultiply,
        HPyInPlaceFloorDivide,
        HPyInPlaceTrueDivide,
        HPyInPlaceRemainder,
        HPyInPlacePower,
        HPyInPlaceLshift,
        HPyInPlaceRshift,
        HPyInPlaceAnd,
        HPyInPlaceXor,
        HPyInPlaceOr,
        HPyCallableCheck,
        HPyCallTupleDict,
        HPyCall,
        HPyCallMethod,
        HPyFatalError,
        HPyErrSetString,
        HPyErrSetObject,
        HPyErrSetFromErrnoWithFilename,
        HPyErrSetFromErrnoWithFilenameObjects,
        HPyErrOccurred,
        HPyErrExceptionMatches,
        HPyErrNoMemory,
        HPyErrClear,
        HPyErrNewException,
        HPyErrNewExceptionWithDoc,
        HPyErrWarnEx,
        HPyErrWriteUnraisable,
        HPyIsTrue,
        HPyTypeFromSpec,
        HPyTypeGenericNew,
        HPyGetAttr,
        HPyGetAttrs,
        HPyHasAttr,
        HPyHasAttrs,
        HPySetAttr,
        HPySetAttrs,
        HPyGetItem,
        HPyGetItemi,
        HPyGetItems,
        HPyContains,
        HPySetItem,
        HPySetItemi,
        HPySetItems,
        HPyDelItem,
        HPyDelItemi,
        HPyDelItems,
        HPyType,
        HPyTypeCheck,
        HPyTypeGetName,
        HPyTypeIsSubtype,
        HPyIs,
        HPyAsStructObject,
        HPyAsStructLegacy,
        HPyAsStructType,
        HPyAsStructLong,
        HPyAsStructFloat,
        HPyAsStructUnicode,
        HPyAsStructTuple,
        HPyAsStructList,
        HPyTypeGetBuiltinShape,
        HPyNew,
        HPyRepr,
        HPyStr,
        HPyASCII,
        HPyBytes,
        HPyRichCompare,
        HPyRichCompareBool,
        HPyHash,
        HPyBytesCheck,
        HPyBytesSize,
        HPyBytesGETSIZE,
        HPyBytesAsString,
        HPyBytesASSTRING,
        HPyBytesFromString,
        HPyBytesFromStringAndSize,
        HPyUnicodeFromString,
        HPyUnicodeCheck,
        HPyUnicodeAsASCIIString,
        HPyUnicodeAsLatin1String,
        HPyUnicodeAsUTF8String,
        HPyUnicodeAsUTF8AndSize,
        HPyUnicodeFromWideChar,
        HPyUnicodeDecodeFSDefault,
        HPyUnicodeDecodeFSDefaultAndSize,
        HPyUnicodeEncodeFSDefault,
        HPyUnicodeReadChar,
        HPyUnicodeDecodeASCII,
        HPyUnicodeDecodeLatin1,
        HPyUnicodeFromEncodedObject,
        HPyUnicodeSubstring,
        HPyListCheck,
        HPyListNew,
        HPyListAppend,
        HPyDictCheck,
        HPyDictNew,
        HPyDictKeys,
        HPyDictCopy,
        HPyTupleCheck,
        HPyTupleFromArray,
        HPySliceUnpack,
        HPyImportImportModule,
        HPyCapsuleNew,
        HPyCapsuleGet,
        HPyCapsuleIsValid,
        HPyCapsuleSet,
        HPyFromPyObject,
        HPyAsPyObject,
        HPyCallRealFunctionFromTrampoline,
        HPyListBuilderNew,
        HPyListBuilderSet,
        HPyListBuilderBuild,
        HPyListBuilderCancel,
        HPyTupleBuilderNew,
        HPyTupleBuilderSet,
        HPyTupleBuilderBuild,
        HPyTupleBuilderCancel,
        HPyTrackerNew,
        HPyTrackerAdd,
        HPyTrackerForgetAll,
        HPyTrackerClose,
        HPyFieldStore,
        HPyFieldLoad,
        HPyReenterPythonExecution,
        HPyLeavePythonExecution,
        HPyGlobalStore,
        HPyGlobalLoad,
        HPyDump,
        HPyCompiles,
        HPyEvalCode,
        HPyContextVarNew,
        HPyContextVarGet,
        HPyContextVarSet,
        HPySetCallFunction;

        @CompilerDirectives.CompilationFinal(dimensions=1)
        private static final HPyJNIUpcall[] VALUES;

        @Override
        public String getName() {
            return this.name();
        }

        static {
            VALUES = HPyJNIUpcall.values();
        }
    }
}

