/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.code;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.code.CodeBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.code.CodeBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.code.CodeNodes;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.compiler.CodeUnit;
import com.oracle.graal.python.compiler.SourceMap;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PCode})
public final class CodeBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CodeBuiltinsFactory.getFactories();
    }

    private static boolean hasStrings(Object[] values) {
        for (Object o : values) {
            if (!(o instanceof TruffleString)) continue;
            return true;
        }
        return false;
    }

    private static PTuple internStrings(Node inliningTarget, Object[] values, StringNodes.InternStringNode internStringNode, PythonObjectFactory factory) {
        Object[] result;
        if (values == null) {
            return factory.createEmptyTuple();
        }
        if (!CodeBuiltins.hasStrings(values)) {
            result = values;
        } else {
            result = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                result[i] = values[i] instanceof TruffleString ? internStringNode.execute(inliningTarget, values[i]) : values[i];
            }
        }
        return factory.createTuple(result);
    }

    @Builtin(name="replace", minNumOfPositionalArgs=1, parameterNames={"$self", "co_argcount", "co_posonlyargcount", "co_kwonlyargcount", "co_nlocals", "co_stacksize", "co_flags", "co_firstlineno", "co_code", "co_consts", "co_names", "co_varnames", "co_freevars", "co_cellvars", "co_filename", "co_name", "co_linetable"})
    @ArgumentsClinic(value={@ArgumentClinic(name="co_argcount", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true), @ArgumentClinic(name="co_posonlyargcount", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true), @ArgumentClinic(name="co_kwonlyargcount", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true), @ArgumentClinic(name="co_nlocals", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true), @ArgumentClinic(name="co_stacksize", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true), @ArgumentClinic(name="co_flags", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true), @ArgumentClinic(name="co_firstlineno", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true), @ArgumentClinic(name="co_code", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer, defaultValue="PNone.NONE", useDefaultForNone=true), @ArgumentClinic(name="co_consts", conversion=ArgumentClinic.ClinicConversion.Tuple), @ArgumentClinic(name="co_names", conversion=ArgumentClinic.ClinicConversion.Tuple), @ArgumentClinic(name="co_varnames", conversion=ArgumentClinic.ClinicConversion.Tuple), @ArgumentClinic(name="co_freevars", conversion=ArgumentClinic.ClinicConversion.Tuple), @ArgumentClinic(name="co_cellvars", conversion=ArgumentClinic.ClinicConversion.Tuple), @ArgumentClinic(name="co_filename", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_EMPTY_STRING", useDefaultForNone=true), @ArgumentClinic(name="co_name", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_EMPTY_STRING", useDefaultForNone=true), @ArgumentClinic(name="co_linetable", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer, defaultValue="PNone.NONE", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class ReplaceNode
    extends PythonClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CodeBuiltinsClinicProviders.ReplaceNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static PCode create(VirtualFrame frame, PCode self, int coArgcount, int coPosonlyargcount, int coKwonlyargcount, int coNlocals, int coStacksize, int coFlags, int coFirstlineno, Object coCode, Object[] coConsts, Object[] coNames, Object[] coVarnames, Object[] coFreevars, Object[] coCellvars, TruffleString coFilename, TruffleString coName, Object coLnotab, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached CodeNodes.CreateCodeNode createCodeNode, @Cached CastToTruffleStringNode castToTruffleStringNode, @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
            try {
                PCode pCode = createCodeNode.execute(frame, coArgcount == -1 ? self.co_argcount() : coArgcount, coPosonlyargcount == -1 ? self.co_posonlyargcount() : coPosonlyargcount, coKwonlyargcount == -1 ? self.co_kwonlyargcount() : coKwonlyargcount, coNlocals == -1 ? self.co_nlocals() : coNlocals, coStacksize == -1 ? self.co_stacksize() : coStacksize, coFlags == -1 ? self.co_flags() : coFlags, PGuards.isNone(coCode) ? self.getCodestring() : bufferLib.getInternalOrCopiedByteArray(coCode), coConsts.length == 0 ? null : coConsts, coNames.length == 0 ? null : PythonUtils.objectArrayToTruffleStringArray(inliningTarget, coNames, castToTruffleStringNode), coVarnames.length == 0 ? null : PythonUtils.objectArrayToTruffleStringArray(inliningTarget, coVarnames, castToTruffleStringNode), coFreevars.length == 0 ? null : PythonUtils.objectArrayToTruffleStringArray(inliningTarget, coFreevars, castToTruffleStringNode), coCellvars.length == 0 ? null : PythonUtils.objectArrayToTruffleStringArray(inliningTarget, coCellvars, castToTruffleStringNode), coFilename.isEmpty() ? self.co_filename() : coFilename, coName.isEmpty() ? self.co_name() : coName, coFirstlineno == -1 ? self.co_firstlineno() : coFirstlineno, PGuards.isNone(coLnotab) ? self.getLinetable() : bufferLib.getInternalOrCopiedByteArray(coLnotab));
                return pCode;
            }
            finally {
                if (!PGuards.isNone(coCode)) {
                    bufferLib.release(coCode, frame, indirectCallData);
                }
                if (!PGuards.isNone(coLnotab)) {
                    bufferLib.release(coLnotab, frame, indirectCallData);
                }
            }
        }
    }

    @Builtin(name="__hash__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class CodeHashNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static long hash(VirtualFrame frame, PCode self, @Bind(value="this") Node inliningTarget, @Cached PyObjectHashNode hashNode, @Cached PythonObjectFactory factory) {
            long h6;
            long h5;
            long h4;
            long h3;
            long h2;
            long h1;
            long h0 = hashNode.execute((Frame)frame, inliningTarget, self.co_name());
            long h = h0 ^ (h1 = hashNode.execute((Frame)frame, inliningTarget, self.co_code(factory))) ^ (h2 = hashNode.execute((Frame)frame, inliningTarget, self.co_consts(factory))) ^ (h3 = hashNode.execute((Frame)frame, inliningTarget, self.co_names(factory))) ^ (h4 = hashNode.execute((Frame)frame, inliningTarget, self.co_varnames(factory))) ^ (h5 = hashNode.execute((Frame)frame, inliningTarget, self.co_freevars(factory))) ^ (h6 = hashNode.execute((Frame)frame, inliningTarget, self.co_cellvars(factory))) ^ (long)self.co_argcount() ^ (long)self.co_posonlyargcount() ^ (long)self.co_kwonlyargcount() ^ (long)self.co_nlocals() ^ (long)self.co_flags();
            if (h == -1L) {
                h = -2L;
            }
            return h;
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class CodeEqNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        boolean eq(PCode self, PCode other) {
            if (self == other) {
                return true;
            }
            if (self.getRootNode() != null && other.getRootNode() != null) {
                if (!self.getName().equalsUncached((AbstractTruffleString)other.getName(), PythonUtils.TS_ENCODING)) {
                    return false;
                }
                if (self.co_argcount() != other.co_argcount() || self.co_posonlyargcount() != other.co_posonlyargcount() || self.co_kwonlyargcount() != other.co_kwonlyargcount() || self.co_nlocals() != other.co_nlocals() || self.co_flags() != other.co_flags() || self.co_firstlineno() != other.co_firstlineno()) {
                    return false;
                }
                if (!Arrays.equals(self.getCodestring(), other.getCodestring())) {
                    return false;
                }
                return Arrays.equals(self.getNames(), other.getNames()) && Arrays.equals(self.getVarnames(), other.getVarnames()) && Arrays.equals(self.getFreeVars(), other.getFreeVars()) && Arrays.equals(self.getCellVars(), other.getCellVars());
            }
            return false;
        }

        @Fallback
        Object fail(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CodeReprNode
    extends PythonUnaryBuiltinNode {
        CodeReprNode() {
        }

        @Specialization
        static TruffleString repr(PCode self, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            TruffleString codeName = self.getName() == null ? StringLiterals.T_NONE : self.getName();
            TruffleString codeFilename = self.getFilename() == null ? StringLiterals.T_NONE : self.getFilename();
            int codeFirstLineNo = self.getFirstLineNo() == 0 ? -1 : self.getFirstLineNo();
            return simpleTruffleStringFormatNode.format("<code object %s, file \"%s\", line %d>", codeName, codeFilename, codeFirstLineNo);
        }
    }

    @Builtin(name="co_lines", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CoLinesNode
    extends PythonUnaryBuiltinNode {
        CoLinesNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object lines(PCode self) {
            PTuple tuple;
            PythonObjectFactory factory = PythonObjectFactory.getUncached();
            if (self.getRootNode() instanceof PBytecodeRootNode) {
                CodeUnit co = ((PBytecodeRootNode)self.getRootNode()).getCodeUnit();
                SourceMap map = co.getSourceMap();
                ArrayList lines = new ArrayList();
                if (map != null && map.startLineMap.length > 0) {
                    IteratorData data = new IteratorData();
                    data.line = map.startLineMap[0];
                    co.iterateBytecode((bci, op, oparg, followingArgs) -> {
                        int nextStart = bci + op.length();
                        if (map.startLineMap[bci] != data.line || nextStart == co.code.length) {
                            lines.add(factory.createTuple(new int[]{data.start, nextStart, data.line}));
                            data.line = map.startLineMap[bci];
                            data.start = nextStart;
                        }
                    });
                }
                tuple = factory.createTuple(lines.toArray());
            } else {
                tuple = factory.createEmptyTuple();
            }
            return PyObjectGetIter.executeUncached(tuple);
        }

        private static final class IteratorData {
            int start = 0;
            int line = -1;

            private IteratorData() {
            }
        }
    }

    @Builtins(value={@Builtin(name="co_lnotab", minNumOfPositionalArgs=1, isGetter=true), @Builtin(name="co_linetable", minNumOfPositionalArgs=1, isGetter=true)})
    @GenerateNodeFactory
    public static abstract class GetLineTableNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self, @Cached PythonObjectFactory factory) {
            byte[] linetable = self.getLinetable();
            if (linetable == null) {
                linetable = PythonUtils.EMPTY_BYTE_ARRAY;
            }
            return factory.createBytes(linetable);
        }
    }

    @Builtin(name="co_varnames", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetVarNamesNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self, @Bind(value="this") Node inliningTarget, @Cached StringNodes.InternStringNode internStringNode, @Cached PythonObjectFactory factory) {
            return CodeBuiltins.internStrings(inliningTarget, self.getVarnames(), internStringNode, factory);
        }
    }

    @Builtin(name="co_names", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetNamesNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self, @Bind(value="this") Node inliningTarget, @Cached StringNodes.InternStringNode internStringNode, @Cached PythonObjectFactory factory) {
            return CodeBuiltins.internStrings(inliningTarget, self.getNames(), internStringNode, factory);
        }
    }

    @Builtin(name="co_consts", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetConstsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self, @Bind(value="this") Node inliningTarget, @Cached StringNodes.InternStringNode internStringNode, @Cached PythonObjectFactory factory) {
            return CodeBuiltins.internStrings(inliningTarget, self.getConstants(), internStringNode, factory);
        }
    }

    @Builtin(name="co_code", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetCodeNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self, @Cached PythonObjectFactory factory) {
            return self.co_code(factory);
        }
    }

    @Builtin(name="co_flags", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetFlagsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self) {
            return self.co_flags();
        }
    }

    @Builtin(name="co_stacksize", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetStackSizeNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self) {
            return self.getStacksize();
        }
    }

    @Builtin(name="co_nlocals", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetNLocalsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self) {
            return self.co_nlocals();
        }
    }

    @Builtin(name="co_kwonlyargcount", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetKnownlyArgCountNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self) {
            return self.co_kwonlyargcount();
        }
    }

    @Builtin(name="co_posonlyargcount", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetPosOnlyArgCountNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self) {
            return self.co_posonlyargcount();
        }
    }

    @Builtin(name="co_argcount", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetArgCountNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self) {
            return self.co_argcount();
        }
    }

    @Builtin(name="co_name", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetNameNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object get(PCode self, @Bind(value="this") Node inliningTarget, @Cached StringNodes.InternStringNode internStringNode) {
            return internStringNode.execute(inliningTarget, self.co_name());
        }
    }

    @Builtin(name="co_firstlineno", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetLinenoNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self) {
            return self.getFirstLineNo();
        }
    }

    @Builtin(name="co_filename", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetFilenameNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self, @Bind(value="this") Node inliningTarget, @Cached StringNodes.InternStringNode internStringNode) {
            TruffleString filename = self.getFilename();
            if (filename != null) {
                return internStringNode.execute(inliningTarget, filename);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="co_cellvars", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetCellVarsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self, @Bind(value="this") Node inliningTarget, @Cached StringNodes.InternStringNode internStringNode, @Cached PythonObjectFactory factory) {
            return CodeBuiltins.internStrings(inliningTarget, self.getCellVars(), internStringNode, factory);
        }
    }

    @Builtin(name="co_freevars", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetFreeVarsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PCode self, @Bind(value="this") Node inliningTarget, @Cached StringNodes.InternStringNode internStringNode, @Cached PythonObjectFactory factory) {
            return CodeBuiltins.internStrings(inliningTarget, self.getFreeVars(), internStringNode, factory);
        }
    }
}

