/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.common;

import com.oracle.graal.python.builtins.objects.common.SequenceNodesFactory;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.lib.PySequenceCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;

public abstract class SequenceNodes {

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class CheckIsSequenceNode
    extends Node {
        public abstract void execute(Node var1, Object var2);

        @Specialization
        static void check(Node inliningTarget, Object obj, @Cached PySequenceCheckNode sequenceCheckNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (!sequenceCheckNode.execute(inliningTarget, obj)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.IS_NOT_A_SEQUENCE, obj);
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class SetSequenceStorageNode
    extends Node {
        public abstract void execute(Node var1, PSequence var2, SequenceStorage var3);

        public static void executeUncached(PSequence s, SequenceStorage storage) {
            SequenceNodesFactory.SetSequenceStorageNodeGen.getUncached().execute(null, s, storage);
        }

        @Specialization(guards={"s.getClass() == cachedClass"}, limit="1")
        static void doSpecial(PSequence s, SequenceStorage storage, @Cached(value="s.getClass()") Class<? extends PSequence> cachedClass) {
            cachedClass.cast(s).setSequenceStorage(storage);
        }

        @Specialization(replaces={"doSpecial"})
        @CompilerDirectives.TruffleBoundary
        static void doGeneric(PSequence s, SequenceStorage storage) {
            s.setSequenceStorage(storage);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class CachedGetObjectArrayNode
    extends Node {
        public abstract Object[] execute(Object var1);

        @Specialization
        Object[] doIt(Object seq, @Cached GetObjectArrayNode node) {
            return node.execute(this, seq);
        }

        public static CachedGetObjectArrayNode create() {
            return SequenceNodesFactory.CachedGetObjectArrayNodeGen.create();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetObjectArrayNode
    extends Node {
        public abstract Object[] execute(Node var1, Object var2);

        public static Object[] executeUncached(Object seq) {
            return SequenceNodesFactory.GetObjectArrayNodeGen.getUncached().execute(null, seq);
        }

        @Specialization
        static Object[] doGeneric(Node inliningTarget, Object seq, @Cached GetSequenceStorageNode getSequenceStorageNode, @Cached SequenceStorageNodes.ToArrayNode toArrayNode) {
            return toArrayNode.execute(inliningTarget, getSequenceStorageNode.execute(inliningTarget, seq));
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    public static abstract class GetSequenceStorageNode
    extends Node {
        public abstract SequenceStorage execute(Node var1, Object var2);

        public static SequenceStorage executeUncached(Object seq) {
            return SequenceNodesFactory.GetSequenceStorageNodeGen.getUncached().execute(null, seq);
        }

        public final SequenceStorage executeCached(Object seq) {
            return this.execute(this, seq);
        }

        @Specialization(guards={"seq.getClass() == cachedClass"}, limit="2")
        static SequenceStorage doSequenceCached(PSequence seq, @Cached(value="seq.getClass()") Class<? extends PSequence> cachedClass) {
            return ((PSequence)CompilerDirectives.castExact((Object)seq, cachedClass)).getSequenceStorage();
        }

        @Specialization(replaces={"doSequenceCached"})
        static SequenceStorage doSequence(PSequence seq) {
            return seq.getSequenceStorage();
        }

        @Specialization(guards={"!isPSequence(seq)"})
        static SequenceStorage doFallback(Object seq) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("cannot get sequence storage of non-sequence object");
        }

        static boolean isPSequence(Object object) {
            return object instanceof PSequence;
        }

        @NeverDefault
        public static GetSequenceStorageNode create() {
            return SequenceNodesFactory.GetSequenceStorageNodeGen.create();
        }

        @NeverDefault
        public static GetSequenceStorageNode getUncached() {
            return SequenceNodesFactory.GetSequenceStorageNodeGen.getUncached();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class LenNode
    extends Node {
        public abstract int execute(Node var1, PSequence var2);

        public static int executeUncached(PSequence seq) {
            return SequenceNodesFactory.LenNodeGen.getUncached().execute(null, seq);
        }

        @Specialization
        static int doPString(PString str, @Cached(inline=false) StringNodes.StringLenNode lenNode) {
            return lenNode.execute(str);
        }

        @Specialization(guards={"!isPString(seq)"})
        static int doWithStorage(Node inliningTarget, PSequence seq, @Cached GetSequenceStorageNode getStorage) {
            return getStorage.execute(inliningTarget, seq).length();
        }
    }
}

