/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.deque;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.common.IndexNodes;
import com.oracle.graal.python.builtins.objects.deque.DequeBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.deque.DequeBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.deque.PDeque;
import com.oracle.graal.python.builtins.objects.deque.PDequeIter;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PyObjectStrAsTruffleStringNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.expression.BinaryComparisonNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.Iterator;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PDeque})
public final class DequeBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return DequeBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        this.addBuiltinConstant(SpecialMethodNames.T___HASH__, (Object)PNone.NONE);
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object classGetItem(Object cls, Object key, @Cached PythonObjectFactory factory) {
            return factory.createGenericAlias(cls, key);
        }
    }

    @Builtin(name="__gt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class DequeGtNode
    extends DequeRelCompareNode {
        @Override
        BinaryComparisonNode createCmp() {
            return BinaryComparisonNode.GtNode.create();
        }
    }

    @Builtin(name="__ge__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class DequeGeNode
    extends DequeRelCompareNode {
        @Override
        boolean shortcutIdentityCheck(Object self, Object other) {
            return self == other;
        }

        @Override
        BinaryComparisonNode createCmp() {
            return BinaryComparisonNode.GeNode.create();
        }
    }

    @Builtin(name="__lt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class DequeLtNode
    extends DequeRelCompareNode {
        @Override
        BinaryComparisonNode createCmp() {
            return BinaryComparisonNode.LtNode.create();
        }
    }

    @Builtin(name="__le__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class DequeLeNode
    extends DequeRelCompareNode {
        @Override
        boolean shortcutIdentityCheck(Object self, Object other) {
            return self == other;
        }

        @Override
        BinaryComparisonNode createCmp() {
            return BinaryComparisonNode.LeNode.create();
        }
    }

    public static abstract class DequeRelCompareNode
    extends DequeCompareNode {
        @Node.Child
        private BinaryComparisonNode comparisonNode;
        @Node.Child
        private PyObjectIsTrueNode isTrueNode;

        @Override
        boolean compare(VirtualFrame frame, Object selfItem, Object otherItem) {
            if (this.comparisonNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.comparisonNode = (BinaryComparisonNode)this.insert(this.createCmp());
            }
            if (this.isTrueNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isTrueNode = (PyObjectIsTrueNode)this.insert(PyObjectIsTrueNode.create());
            }
            return this.isTrueNode.executeCached((Frame)frame, this.comparisonNode.executeObject(frame, selfItem, otherItem));
        }

        BinaryComparisonNode createCmp() {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class DequeEqNode
    extends DequeCompareNode {
        @Specialization(guards={"!shortcutLengthCheck(self, other)"}, insertBefore="doGeneric")
        static boolean doDifferentLength(PDeque self, PDeque other) {
            return false;
        }

        @Override
        boolean shortcutIdentityCheck(Object self, Object other) {
            return self == other;
        }

        @Override
        boolean shortcutLengthCheck(PDeque self, PDeque other) {
            return self.getSize() == other.getSize();
        }

        @Override
        boolean compare(VirtualFrame frame, Object selfItem, Object otherItem) {
            return this.compareEq(frame, selfItem, otherItem);
        }
    }

    public static abstract class DequeCompareNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        PyObjectRichCompareBool.EqNode eqNode;

        @Specialization(guards={"shortcutIdentityCheck(self, other)"})
        static boolean doSame(PDeque self, PDeque other) {
            return true;
        }

        @Specialization(guards={"!isPDeque(other)"})
        static Object doOther(PDeque self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @Specialization
        Object doGeneric(VirtualFrame frame, PDeque self, Object other, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIterSelf, @Cached PyObjectGetIter getIterOther, @Cached GetNextNode selfItNextNode, @Cached GetNextNode otherItNextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile profile) {
            if (!DequeCompareNode.isPDeque(other)) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            if (this.shortcutIdentityCheck(self, other)) {
                return true;
            }
            PDeque otherDeque = (PDeque)other;
            if (!this.shortcutLengthCheck(self, otherDeque)) {
                return false;
            }
            Object ait = getIterSelf.execute((Frame)frame, inliningTarget, self);
            Object bit = getIterOther.execute((Frame)frame, inliningTarget, otherDeque);
            try {
                Object otherItem;
                Object selfItem;
                while (this.compareEq(frame, selfItem = selfItNextNode.execute((Frame)frame, ait), otherItem = otherItNextNode.execute((Frame)frame, bit))) {
                }
                return this.compare(frame, selfItem, otherItem);
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonBuiltinClassType.StopIteration, profile);
                return this.compare(frame, self.getSize(), otherDeque.getSize());
            }
        }

        static boolean isPDeque(Object object) {
            return object instanceof PDeque;
        }

        boolean shortcutIdentityCheck(Object self, Object other) {
            return false;
        }

        boolean shortcutLengthCheck(PDeque self, PDeque other) {
            return true;
        }

        final boolean compareEq(VirtualFrame frame, Object selfItem, Object otherItem) {
            if (this.eqNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.eqNode = (PyObjectRichCompareBool.EqNode)this.insert(PyObjectRichCompareBool.EqNode.create());
            }
            return this.eqNode.compareCached((Frame)frame, selfItem, otherItem);
        }

        boolean compare(VirtualFrame frame, Object selfItem, Object otherItem) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class DequeReduceNode
    extends PythonUnaryBuiltinNode {
        DequeReduceNode() {
        }

        @Specialization
        Object doGeneric(VirtualFrame frame, PDeque self, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached PyObjectLookupAttr lookupAttr, @Cached PyObjectSizeNode sizeNode, @Cached GetClassNode getClassNode, @Cached PythonObjectFactory factory) {
            Object clazz = getClassNode.execute(inliningTarget, self);
            Object dict = lookupAttr.execute((Frame)frame, inliningTarget, self, SpecialAttributeNames.T___DICT__);
            if (PGuards.isNoValue(dict) || sizeNode.execute((Frame)frame, inliningTarget, dict) <= 0) {
                dict = PNone.NONE;
            }
            Object it = getIter.execute((Frame)frame, inliningTarget, self);
            PTuple emptyTuple = factory.createEmptyTuple();
            int maxLength = self.getMaxLength();
            if (maxLength != -1) {
                return factory.createTuple(new Object[]{clazz, factory.createTuple(new Object[]{emptyTuple, maxLength}), dict, it});
            }
            return factory.createTuple(new Object[]{clazz, emptyTuple, dict, it});
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class DequeReprNode
    extends PythonUnaryBuiltinNode {
        DequeReprNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        @CompilerDirectives.TruffleBoundary
        TruffleString repr(PDeque self) {
            if (!this.getContext().reprEnter(self)) {
                return StringLiterals.T_ELLIPSIS_IN_BRACKETS;
            }
            EncapsulatingNodeReference ref = EncapsulatingNodeReference.getCurrent();
            Node outerNode = ref.set((Node)this);
            try {
                Object[] items = self.data.toArray();
                PList asList = PythonObjectFactory.getUncached().createList(items);
                int maxLength = self.getMaxLength();
                TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
                sb.appendStringUncached(TypeNodes.GetNameNode.executeUncached(GetClassNode.GetPythonObjectClassNode.executeUncached(self)));
                sb.appendStringUncached(StringLiterals.T_LPAREN);
                sb.appendStringUncached(PyObjectStrAsTruffleStringNode.executeUncached(asList));
                if (maxLength != -1) {
                    sb.appendStringUncached(PythonUtils.toTruffleStringUncached(", maxlen="));
                    sb.appendIntNumberUncached(maxLength);
                }
                sb.appendStringUncached(StringLiterals.T_RPAREN);
                TruffleString truffleString = sb.toStringUncached();
                return truffleString;
            }
            finally {
                ref.set(outerNode);
                this.getContext().reprLeave(self);
            }
        }
    }

    @Builtin(name="__reversed__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class DequeReversedNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PDequeIter doGeneric(PDeque self, @Cached PythonObjectFactory factory) {
            return factory.createDequeRevIter(self);
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class DequeIterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PDequeIter doGeneric(PDeque self, @Cached PythonObjectFactory factory) {
            return factory.createDequeIter(self);
        }
    }

    @Builtin(name="__bool__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class DequeBoolNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static boolean doGeneric(PDeque self) {
            return self.getSize() != 0;
        }
    }

    @Builtin(name="__delitem__", minNumOfPositionalArgs=2, parameterNames={"$self", "n"})
    @GenerateNodeFactory
    @ArgumentClinic(name="n", conversion=ArgumentClinic.ClinicConversion.Index)
    public static abstract class DequeDelItemNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return DequeBuiltinsClinicProviders.DequeDelItemNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PNone doGeneric(PDeque self, int idx, @Cached IndexNodes.NormalizeIndexCustomMessageNode normalizeIndexNode) {
            int normIdx = normalizeIndexNode.execute(idx, self.getSize(), ErrorMessages.DEQUE_INDEX_OUT_OF_RANGE);
            self.setItem(normIdx, null);
            return PNone.NONE;
        }
    }

    @Builtin(name="__setitem__", minNumOfPositionalArgs=3, parameterNames={"$self", "n", "value"})
    @GenerateNodeFactory
    @ArgumentClinic(name="n", conversion=ArgumentClinic.ClinicConversion.Index)
    public static abstract class DequeSetItemNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return DequeBuiltinsClinicProviders.DequeSetItemNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PNone doGeneric(PDeque self, int idx, Object value, @Cached IndexNodes.NormalizeIndexCustomMessageNode normalizeIndexNode) {
            int normIdx = normalizeIndexNode.execute(idx, self.getSize(), ErrorMessages.DEQUE_INDEX_OUT_OF_RANGE);
            self.setItem(normIdx, value != PNone.NO_VALUE ? value : null);
            return PNone.NONE;
        }
    }

    @Builtin(name="__getitem__", minNumOfPositionalArgs=2, parameterNames={"$self", "n"})
    @GenerateNodeFactory
    @ArgumentClinic(name="n", conversion=ArgumentClinic.ClinicConversion.Index)
    public static abstract class DequeGetItemNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return DequeBuiltinsClinicProviders.DequeGetItemNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object doGeneric(PDeque self, int idx, @Cached IndexNodes.NormalizeIndexCustomMessageNode normalizeIndexNode) {
            int normIdx = normalizeIndexNode.execute(idx, self.getSize(), ErrorMessages.DEQUE_INDEX_OUT_OF_RANGE);
            return this.doGetItem(self, normIdx);
        }

        @CompilerDirectives.TruffleBoundary
        Object doGetItem(PDeque self, int idx) {
            assert (0 <= idx && idx < self.getSize());
            Iterator<Object> it = self.data.iterator();
            for (int i = 0; i < idx; ++i) {
                it.next();
            }
            return it.next();
        }
    }

    @Builtin(name="__contains__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class DequeContainsNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        boolean doGeneric(PDeque self, Object value) {
            int startState = self.getState();
            for (Object item : self.data) {
                if (PyObjectRichCompareBool.EqNode.compareUncached(item, value)) {
                    return true;
                }
                if (startState == self.getState()) continue;
                throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.RuntimeError, ErrorMessages.DEQUE_MUTATED_DURING_ITERATION);
            }
            return false;
        }
    }

    @Builtin(name="__rmul__", minNumOfPositionalArgs=2, parameterNames={"$self", "n"})
    @GenerateNodeFactory
    @ArgumentClinic(name="n", conversion=ArgumentClinic.ClinicConversion.Index)
    public static abstract class DequeRMulNode
    extends DequeMulNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return DequeBuiltinsClinicProviders.DequeRMulNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="__mul__", minNumOfPositionalArgs=2, parameterNames={"$self", "n"})
    @GenerateNodeFactory
    @ArgumentClinic(name="n", conversion=ArgumentClinic.ClinicConversion.Index)
    public static abstract class DequeMulNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return DequeBuiltinsClinicProviders.DequeMulNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        PDeque doGeneric(PDeque self, int n) {
            PDeque newDeque = PythonObjectFactory.getUncached().createDeque();
            newDeque.setMaxLength(self.getMaxLength());
            newDeque.addAll(self);
            return DequeInplaceMulNode.doGeneric(this, newDeque, n);
        }
    }

    @Builtin(name="__imul__", minNumOfPositionalArgs=2, parameterNames={"$self", "n"})
    @GenerateNodeFactory
    @ArgumentClinic(name="n", conversion=ArgumentClinic.ClinicConversion.Index)
    public static abstract class DequeInplaceMulNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return DequeBuiltinsClinicProviders.DequeInplaceMulNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        PDeque doGeneric(PDeque self, int n) {
            return DequeInplaceMulNode.doGeneric(this, self, n);
        }

        @CompilerDirectives.TruffleBoundary
        static PDeque doGeneric(Node node, PDeque self, int n) {
            int size = self.getSize();
            if (size == 0 || n == 1) {
                return self;
            }
            if (n <= 1) {
                self.clear();
                return self;
            }
            if (size > Integer.MAX_VALUE / n) {
                throw PRaiseNode.raiseUncached(node, PythonBuiltinClassType.MemoryError);
            }
            int repetitions = n;
            if (self.getMaxLength() >= 0 && n * size > self.getMaxLength()) {
                repetitions = (self.getMaxLength() + size - 1) / size;
            }
            Object[] items = self.data.toArray();
            for (int i = 0; i < repetitions - 1; ++i) {
                self.addAll(items);
            }
            return self;
        }
    }

    @Builtin(name="__add__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class DequeAddNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PDeque doDeque(PDeque self, PDeque other) {
            PDeque newDeque = PythonObjectFactory.getUncached().createDeque();
            newDeque.setMaxLength(self.getMaxLength());
            newDeque.addAll(self);
            newDeque.addAll(other);
            return newDeque;
        }

        @Specialization(replaces={"doDeque"})
        static PDeque doGeneric(PDeque self, Object other, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy raiseNode) {
            if (!(other instanceof PDeque)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.CAN_ONLY_CONCATENATE_DEQUE_NOT_P_TO_DEQUE, other);
            }
            return DequeAddNode.doDeque(self, (PDeque)other);
        }
    }

    @Builtin(name="__iadd__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class DequeInplaceAddNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PDeque doDeque(PDeque self, PDeque other) {
            if (self == other) {
                self.addAll(self.data.toArray());
            } else {
                self.addAll(other);
            }
            return self;
        }

        @Specialization
        static PDeque doOther(VirtualFrame frame, PDeque self, Object other, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached GetNextNode getNextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isStopIterationProfile) {
            if (other instanceof PDeque) {
                return DequeInplaceAddNode.doDeque(self, (PDeque)other);
            }
            assert (self != other);
            Object iterator = getIter.execute((Frame)frame, inliningTarget, other);
            try {
                while (true) {
                    self.append(getNextNode.execute((Frame)frame, iterator));
                }
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonBuiltinClassType.StopIteration, isStopIterationProfile);
                return self;
            }
        }
    }

    @Builtin(name="__len__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class DequeLenNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static int doGeneric(PDeque self) {
            return self.getSize();
        }
    }

    @Builtin(name="rotate", minNumOfPositionalArgs=1, parameterNames={"$self", "n"})
    @GenerateNodeFactory
    @ArgumentClinic(name="n", conversion=ArgumentClinic.ClinicConversion.Index, defaultValue="1")
    public static abstract class DequeRotateNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return DequeBuiltinsClinicProviders.DequeRotateNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"self.getSize() <= 1"})
        @CompilerDirectives.TruffleBoundary
        static PNone doEmptyOrSingleElement(PDeque self, int n) {
            return PNone.NONE;
        }

        @Specialization(guards={"n >= 0"})
        @CompilerDirectives.TruffleBoundary
        static PNone doRight(PDeque self, int n) {
            if (self.getSize() > 1) {
                int effectiveRot = n % self.getSize();
                for (int i = 0; i < effectiveRot; ++i) {
                    self.appendLeft(self.pop());
                }
            }
            return PNone.NONE;
        }

        @Specialization(guards={"n < 0"})
        @CompilerDirectives.TruffleBoundary
        static PNone doLeft(PDeque self, int n) {
            if (self.getSize() > 1) {
                int effectiveRot = -n % self.getSize();
                for (int i = 0; i < effectiveRot; ++i) {
                    self.append(self.popLeft());
                }
            }
            return PNone.NONE;
        }

        static void rotate(PDeque self, int n) {
            if (n < 0) {
                DequeRotateNode.doLeft(self, n);
            } else {
                DequeRotateNode.doRight(self, n);
            }
        }
    }

    @Builtin(name="reverse", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class DequeReverseNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        PNone doGeneric(PDeque self) {
            int i;
            Object[] items = new Object[self.getSize()];
            for (i = 0; i < items.length; ++i) {
                items[i] = self.data.pollLast();
            }
            for (i = 0; i < items.length; ++i) {
                self.data.addLast(items[i]);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="remove", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class DequeRemoveNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object doGeneric(PDeque self, Object value) {
            int n = self.getSize();
            for (int i = 0; i < n; ++i) {
                try {
                    boolean result = PyObjectRichCompareBool.EqNode.compareUncached(self.peekLeft(), value);
                    if (n != self.getSize()) {
                        throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.IndexError, ErrorMessages.DEQUE_MUTATED_DURING_REMOVE);
                    }
                    if (result) {
                        Object removed = self.popLeft();
                        assert (removed != null);
                        DequeRotateNode.doRight(self, i);
                        return PNone.NONE;
                    }
                    self.append(self.popLeft());
                    continue;
                }
                catch (PException e) {
                    DequeRotateNode.doRight(self, i);
                    throw e;
                }
            }
            throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.ValueError, ErrorMessages.DEQUE_REMOVE_X_NOT_IN_DEQUE);
        }
    }

    @Builtin(name="popleft", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class DequePopLeftNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doGeneric(PDeque self, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy raiseNode) {
            Object value = self.popLeft();
            if (value == null) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.IndexError, ErrorMessages.POP_FROM_EMPTY_DEQUE);
            }
            return value;
        }
    }

    @Builtin(name="pop", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class DequePopNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doGeneric(PDeque self, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy raiseNode) {
            Object value = self.pop();
            if (value == null) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.IndexError, ErrorMessages.POP_FROM_EMPTY_DEQUE);
            }
            return value;
        }
    }

    @Builtin(name="insert", minNumOfPositionalArgs=3, parameterNames={"$self", "index", "object"})
    @GenerateNodeFactory
    @ArgumentClinic(name="index", conversion=ArgumentClinic.ClinicConversion.Index)
    public static abstract class DequeInsertNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return DequeBuiltinsClinicProviders.DequeInsertNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        PNone doGeneric(PDeque self, int index, Object value) {
            int n = self.getSize();
            if (self.getMaxLength() == n) {
                throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.IndexError, ErrorMessages.DEQUE_AT_MAX_SIZE);
            }
            if (index >= n) {
                self.append(value);
            } else if (index <= -n || index == 0) {
                self.appendLeft(value);
            } else {
                DequeRotateNode.rotate(self, -index);
                if (index < 0) {
                    self.append(value);
                } else {
                    self.appendLeft(value);
                }
                DequeRotateNode.rotate(self, index);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="index", minNumOfPositionalArgs=2, parameterNames={"$self", "v", "start", "stop"})
    @GenerateNodeFactory
    public static abstract class DequeIndexNode
    extends PythonQuaternaryBuiltinNode {
        @Specialization(guards={"isNoValue(start)", "isNoValue(stop)"})
        static int doWithoutSlice(VirtualFrame frame, PDeque self, Object value, PNone start, PNone stop, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="eqNode") @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            return DequeIndexNode.doWithIntSlice(frame, self, value, 0, self.getSize(), inliningTarget, eqNode, raiseNode);
        }

        @Specialization
        static int doWithIntSlice(VirtualFrame frame, PDeque self, Object value, int start, int stop, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="eqNode") @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            int size = self.getSize();
            int normStart = DequeIndexNode.normalize(start, size);
            int normStop = DequeIndexNode.normalize(stop, size);
            int startState = self.getState();
            if (normStop > size) {
                normStop = size;
            }
            if (normStart > normStop) {
                normStart = normStop;
            }
            Iterator<Object> iterator = self.iterator();
            for (int idx = 0; idx < normStop; ++idx) {
                Object item = DequeIndexNode.next(iterator);
                if (normStart > idx) continue;
                if (eqNode.compare((Frame)frame, inliningTarget, item, value)) {
                    return idx;
                }
                if (startState == self.getState()) continue;
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.DEQUE_MUTATED_DURING_ITERATION);
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.S_IS_NOT_DEQUE, value);
        }

        @Specialization
        static int doGeneric(VirtualFrame frame, PDeque self, Object value, Object start, Object stop, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached CastToJavaIntExactNode castToIntNode, @Cached PyNumberAsSizeNode startIndexNode, @Cached PyNumberAsSizeNode stopIndexNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            int istart = start != PNone.NO_VALUE ? castToIntNode.execute(inliningTarget, startIndexNode.executeLossy((Frame)frame, inliningTarget, start)) : 0;
            int istop = stop != PNone.NO_VALUE ? castToIntNode.execute(inliningTarget, stopIndexNode.executeLossy((Frame)frame, inliningTarget, stop)) : self.getSize();
            return DequeIndexNode.doWithIntSlice(frame, self, value, istart, istop, inliningTarget, eqNode, raiseNode);
        }

        private static int normalize(int i, int size) {
            int res = i;
            if (res < 0) {
                res += size;
            }
            return Math.max(res, 0);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object next(Iterator<?> it) {
            return it.next();
        }
    }

    @Builtin(name="extendleft", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class DequeExtendLeftNode
    extends DequeExtendNode {
        @Override
        void appendOperation(PDeque self, Object item) {
            self.appendLeft(item);
        }
    }

    @Builtin(name="extend", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class DequeExtendNode
    extends PythonBinaryBuiltinNode {
        void appendOperation(PDeque self, Object item) {
            self.append(item);
        }

        @Specialization(guards={"self == other"})
        @CompilerDirectives.TruffleBoundary
        PNone doSelf(PDeque self, PDeque other) {
            Object[] items;
            for (Object item : items = self.data.toArray()) {
                this.appendOperation(self, item);
            }
            return PNone.NONE;
        }

        @Specialization
        PNone doGeneric(VirtualFrame frame, PDeque self, Object other, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile selfIsOtherProfile, @Cached InlinedConditionProfile maxLenZeroProfile, @Cached PyObjectGetIter getIter, @Cached GetNextNode getNextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isStopIterationProfile) {
            if (selfIsOtherProfile.profile(inliningTarget, self == other)) {
                return this.doSelf(self, self);
            }
            Object it = getIter.execute((Frame)frame, inliningTarget, other);
            if (maxLenZeroProfile.profile(inliningTarget, self.getMaxLength() == 0)) {
                DequeExtendNode.consumeIterator(frame, it, getNextNode, inliningTarget, isStopIterationProfile);
                return PNone.NONE;
            }
            try {
                while (true) {
                    this.appendOperation(self, getNextNode.execute((Frame)frame, it));
                }
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonBuiltinClassType.StopIteration, isStopIterationProfile);
                DequeExtendNode.consumeIterator(frame, it, getNextNode, inliningTarget, isStopIterationProfile);
                return PNone.NONE;
            }
        }

        private static void consumeIterator(VirtualFrame frame, Object it, GetNextNode getNextNode, Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile isStopIterationProfile) {
            try {
                while (true) {
                    getNextNode.execute((Frame)frame, it);
                }
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonBuiltinClassType.StopIteration, isStopIterationProfile);
                return;
            }
        }
    }

    @Builtin(name="count", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class DequeCountNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        int doGeneric(PDeque self, Object value) {
            int n = 0;
            int startState = self.getState();
            for (Object item : self.data) {
                if (PyObjectRichCompareBool.EqNode.compareUncached(item, value)) {
                    ++n;
                }
                if (startState == self.getState()) continue;
                throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.RuntimeError, ErrorMessages.DEQUE_MUTATED_DURING_ITERATION);
            }
            return n;
        }
    }

    @Builtins(value={@Builtin(name="__copy__", minNumOfPositionalArgs=1), @Builtin(name="copy", minNumOfPositionalArgs=1)})
    @GenerateNodeFactory
    public static abstract class DequeCopyNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PDeque doGeneric(PDeque self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached PythonObjectFactory factory) {
            PDeque copy = factory.createDeque(getClassNode.execute(inliningTarget, self));
            copy.setMaxLength(self.getMaxLength());
            copy.addAll(self);
            return copy;
        }
    }

    @Builtin(name="clear", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class DequeClearNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PNone doGeneric(PDeque self) {
            self.clear();
            return PNone.NONE;
        }
    }

    @Builtin(name="appendleft", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class DequeAppendLeftNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static PNone doGeneric(PDeque self, Object arg) {
            self.appendLeft(arg);
            return PNone.NONE;
        }
    }

    @Builtin(name="append", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class DequeAppendNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static PNone doGeneric(PDeque self, Object arg) {
            self.append(arg);
            return PNone.NONE;
        }
    }

    @Builtin(name="maxlen", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class DequeMaxLengthNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.getMaxLength() < 0"})
        static PNone doNone(PDeque self) {
            return PNone.NONE;
        }

        @Specialization(guards={"self.getMaxLength() >= 0"})
        static int doInt(PDeque self) {
            return self.getMaxLength();
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, parameterNames={"$self", "iterable", "maxlen"})
    @GenerateNodeFactory
    public static abstract class DequeInitNode
    extends PythonTernaryBuiltinNode {
        @Specialization(guards={"isNoValue(iterable)"})
        static PNone doNothing(PDeque self, PNone iterable, PNone maxlen) {
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(iterable)"})
        static PNone doIterable(VirtualFrame frame, PDeque self, Object iterable, PNone maxlen, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached InlinedConditionProfile sizeZeroProfile, @Cached.Exclusive @Cached PyObjectGetIter getIter, @Cached.Exclusive @Cached GetNextNode getNextNode, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isStopIterationProfile) {
            if (sizeZeroProfile.profile(inliningTarget, self.getSize() != 0)) {
                self.clear();
            }
            Object iterator = getIter.execute((Frame)frame, inliningTarget, iterable);
            try {
                while (true) {
                    self.append(getNextNode.execute((Frame)frame, iterator));
                }
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonBuiltinClassType.StopIteration, isStopIterationProfile);
                return PNone.NONE;
            }
        }

        @Specialization(replaces={"doNothing", "doIterable"})
        static PNone doGeneric(VirtualFrame frame, PDeque self, Object iterable, Object maxlenObj, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached InlinedConditionProfile sizeZeroProfile, @Cached CastToJavaIntExactNode castToIntNode, @Cached.Exclusive @Cached PyObjectGetIter getIter, @Cached.Exclusive @Cached GetNextNode getNextNode, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isTypeErrorProfile, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isStopIterationProfile, @Cached PRaiseNode.Lazy raiseNode) {
            if (!PGuards.isPNone(maxlenObj)) {
                try {
                    int maxlen = castToIntNode.execute(inliningTarget, maxlenObj);
                    if (maxlen < 0) {
                        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.MAXLEN_MUST_BE_NONNEG);
                    }
                    self.setMaxLength(maxlen);
                }
                catch (PException e) {
                    e.expect(inliningTarget, PythonBuiltinClassType.TypeError, isTypeErrorProfile);
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.PYTHON_INT_TOO_LARGE_TO_CONV_TO, "int");
                }
                catch (CannotCastException e) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.INTEGER_REQUIRED);
                }
            }
            if (iterable != PNone.NO_VALUE) {
                DequeInitNode.doIterable(frame, self, iterable, PNone.NO_VALUE, inliningTarget, sizeZeroProfile, getIter, getNextNode, isStopIterationProfile);
            }
            return PNone.NONE;
        }
    }
}

