/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.method;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.method.InstancemethodBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.method.PDecoratedMethod;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PInstancemethod})
public final class InstancemethodBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return InstancemethodBuiltinsFactory.getFactories();
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static TruffleString reprBuiltinFunction(VirtualFrame frame, PDecoratedMethod self, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getNameNode, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return simpleTruffleStringFormatNode.format("<instancemethod %s at 0x%s>", ReprNode.toStr(getNameNode.execute((Frame)frame, inliningTarget, self.getCallable(), SpecialAttributeNames.T___NAME__)), PythonAbstractObject.systemHashCodeAsHexString(self.getCallable()));
        }

        @CompilerDirectives.TruffleBoundary
        private static String toStr(Object o) {
            return o.toString();
        }
    }

    @Builtin(name="__get__", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class GetNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        static Object doGeneric(PDecoratedMethod self, Object obj, Object cls, @Cached PythonObjectFactory factory) {
            if (obj == null || obj == PNone.NONE) {
                return self.getCallable();
            }
            return factory.createMethod(obj, self.getCallable());
        }
    }

    @Builtin(name="__call__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class CallNode
    extends PythonVarargsBuiltinNode {
        @Specialization
        protected static Object doIt(VirtualFrame frame, PDecoratedMethod self, Object[] arguments, PKeyword[] keywords, @Cached com.oracle.graal.python.nodes.call.CallNode callNode) {
            return callNode.execute((Frame)frame, self.getCallable(), arguments, keywords);
        }

        @Override
        public Object varArgExecute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) throws PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported {
            Object[] argsWithoutSelf = new Object[arguments.length - 1];
            PythonUtils.arraycopy(arguments, 1, argsWithoutSelf, 0, argsWithoutSelf.length);
            return this.execute(frame, arguments[0], argsWithoutSelf, keywords);
        }
    }

    @Builtin(name="__doc__", maxNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class DocNode
    extends PythonUnaryBuiltinNode {
        DocNode() {
        }

        @Specialization
        static Object doc(VirtualFrame frame, PDecoratedMethod self, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttr) {
            return getAttr.execute((Frame)frame, inliningTarget, self.getCallable(), SpecialAttributeNames.T___DOC__);
        }
    }

    @Builtin(name="__getattribute__", minNumOfPositionalArgs=2)
    @ImportStatic(value={PGuards.class})
    @GenerateNodeFactory
    public static abstract class GetattributeNode
    extends PythonBuiltinNode {
        @Specialization
        protected static Object doIt(VirtualFrame frame, PDecoratedMethod self, Object key, @Bind(value="this") Node inliningTarget, @Cached ObjectBuiltins.GetAttributeNode objectGetattrNode, @Cached PyObjectGetAttr getAttrNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) {
            try {
                return objectGetattrNode.execute(frame, self, key);
            }
            catch (PException e) {
                e.expectAttributeError(inliningTarget, errorProfile);
                return getAttrNode.execute((Frame)frame, inliningTarget, self.getCallable(), key);
            }
        }
    }

    @Builtin(name="__func__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class FuncNode
    extends PythonUnaryBuiltinNode {
        FuncNode() {
        }

        @Specialization
        protected static Object func(PDecoratedMethod self) {
            return self.getCallable();
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class InitNode
    extends PythonBinaryBuiltinNode {
        InitNode() {
        }

        @Specialization(guards={"checkCallableNode.execute(this, callable)"})
        static PNone init(PDecoratedMethod self, Object callable, @Cached.Shared(value="checkCallable") @Cached PyCallableCheckNode checkCallableNode) {
            self.setCallable(callable);
            return PNone.NONE;
        }

        @Specialization(guards={"!checkCallableNode.execute(this, callable)"})
        static PNone noCallble(PDecoratedMethod self, Object callable, @Cached.Shared(value="checkCallable") @Cached PyCallableCheckNode checkCallableNode, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.FIRST_ARG_MUST_BE_CALLABLE_S, callable);
        }
    }
}

