/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.object;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.cell.PCell;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeVoidPtr;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.common.EconomicMapStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.ellipsis.PEllipsis;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.mappingproxy.PMappingproxy;
import com.oracle.graal.python.builtins.objects.object.ObjectNodesFactory;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.set.PFrozenSet;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyDictCheckNode;
import com.oracle.graal.python.lib.PyImportImport;
import com.oracle.graal.python.lib.PyListCheckNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PyTupleCheckNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromDynamicObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToDynamicObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.CallTernaryMethodNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.IsForeignObjectNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.IDUtils;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import org.graalvm.collections.Pair;

public abstract class ObjectNodes {
    public static final TruffleString T__REDUCE_EX = PythonUtils.tsLiteral("_reduce_ex");
    public static final TruffleString T__SLOTNAMES = PythonUtils.tsLiteral("_slotnames");

    public static abstract class AbstractSetattrNode
    extends PythonTernaryBuiltinNode {
        @Node.Child
        GetClassNode getDescClassNode;
        @Node.Child
        LookupCallableSlotInMRONode lookupSetNode;
        @Node.Child
        CallTernaryMethodNode callSetNode;

        public abstract PNone execute(VirtualFrame var1, Object var2, TruffleString var3, Object var4);

        protected boolean writeAttribute(Object object, TruffleString key, Object value) {
            throw CompilerDirectives.shouldNotReachHere((String)"writeAttribute");
        }

        @Specialization
        protected PNone doIt(VirtualFrame frame, Object object, Object keyObject, Object value, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castKeyToStringNode, @Cached GetClassNode getClassNode, @Cached LookupAttributeInMRONode.Dynamic getExisting, @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString key;
            try {
                key = castKeyToStringNode.execute(inliningTarget, keyObject);
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_NAME_MUST_BE_STRING, keyObject);
            }
            Object type = getClassNode.execute(inliningTarget, object);
            Object descr = getExisting.execute(type, key);
            if (descr != PNone.NO_VALUE) {
                Object dataDescClass = this.getDescClass(descr);
                Object set = this.ensureLookupSetNode().execute(dataDescClass);
                if (PGuards.isCallableOrDescriptor(set)) {
                    this.ensureCallSetNode().execute((Frame)frame, set, descr, object, value);
                    return PNone.NONE;
                }
            }
            if (this.writeAttribute(object, key, value)) {
                return PNone.NONE;
            }
            if (descr != PNone.NO_VALUE) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.ATTR_S_READONLY, key);
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.HAS_NO_ATTR, object, key);
        }

        private Object getDescClass(Object desc) {
            if (this.getDescClassNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getDescClassNode = (GetClassNode)this.insert(GetClassNode.create());
            }
            return this.getDescClassNode.executeCached(desc);
        }

        private LookupCallableSlotInMRONode ensureLookupSetNode() {
            if (this.lookupSetNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupSetNode = (LookupCallableSlotInMRONode)this.insert(LookupCallableSlotInMRONode.create(SpecialMethodSlot.Set));
            }
            return this.lookupSetNode;
        }

        private CallTernaryMethodNode ensureCallSetNode() {
            if (this.callSetNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callSetNode = (CallTernaryMethodNode)this.insert(CallTernaryMethodNode.create());
            }
            return this.callSetNode;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class GenericSetAttrNode
    extends Node {
        public abstract void execute(Node var1, VirtualFrame var2, Object var3, Object var4, Object var5, WriteAttributeToObjectNode var6);

        @Specialization
        static void doIt(Node inliningTarget, VirtualFrame frame, Object object, Object keyObject, Object value, WriteAttributeToObjectNode writeNode, @Cached CastToTruffleStringNode castKeyToStringNode, @Cached GetClassNode getClassNode, @Cached CallSetHelper callSetHelper, @Cached(inline=false) LookupAttributeInMRONode.Dynamic getExisting, @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString key;
            try {
                key = castKeyToStringNode.execute(inliningTarget, keyObject);
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_NAME_MUST_BE_STRING, keyObject);
            }
            Object type = getClassNode.execute(inliningTarget, object);
            Object descr = getExisting.execute(type, key);
            boolean calledSet = callSetHelper.execute(inliningTarget, frame, descr, object, value);
            if (calledSet) {
                return;
            }
            boolean wroteAttr = writeNode.execute(object, key, value);
            if (wroteAttr) {
                return;
            }
            if (descr != PNone.NO_VALUE) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.ATTR_S_READONLY, key);
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.HAS_NO_ATTR, object, key);
        }

        public static GenericSetAttrNode getUncached() {
            return ObjectNodesFactory.GenericSetAttrNodeGen.getUncached();
        }

        @GenerateInline
        @GenerateCached(value=false)
        @GenerateUncached
        @ImportStatic(value={SpecialMethodSlot.class, PGuards.class})
        static abstract class CallSetHelper
        extends Node {
            CallSetHelper() {
            }

            abstract boolean execute(Node var1, VirtualFrame var2, Object var3, Object var4, Object var5);

            @Specialization(guards={"isNoValue(descr)"})
            static boolean call(Node inliningTarget, VirtualFrame frame, Object descr, Object object, Object value) {
                return false;
            }

            @Specialization(guards={"!isNoValue(descr)"})
            static boolean call(Node inliningTarget, VirtualFrame frame, Object descr, Object object, Object value, @Cached GetClassNode getClassNode, @Cached(parameters={"Set"}, inline=false) LookupCallableSlotInMRONode lookup, @Cached(inline=false) CallTernaryMethodNode call) {
                Object descrClass = getClassNode.execute(inliningTarget, descr);
                Object setMethod = lookup.execute(descrClass);
                if (setMethod == PNone.NO_VALUE) {
                    return false;
                }
                call.execute((Frame)frame, setMethod, descr, object, value);
                return true;
            }
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    public static abstract class DefaultObjectReprNode
    extends PNodeWithContext {
        public abstract TruffleString execute(Frame var1, Node var2, Object var3);

        public final TruffleString executeCached(Frame frame, Object object) {
            return this.execute(frame, this, object);
        }

        @Specialization
        static TruffleString repr(VirtualFrame frame, Node inliningTarget, Object self, @Cached GetFullyQualifiedClassNameNode getFullyQualifiedClassNameNode, @Cached(inline=false) StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            TruffleString fqcn = getFullyQualifiedClassNameNode.execute((Frame)frame, inliningTarget, self);
            return simpleTruffleStringFormatNode.format("<%s object at 0x%s>", fqcn, PythonAbstractNativeObject.systemHashCodeAsHexString(self));
        }

        @NeverDefault
        public static DefaultObjectReprNode create() {
            return ObjectNodesFactory.DefaultObjectReprNodeGen.create();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={SpecialAttributeNames.class})
    public static abstract class GetFullyQualifiedClassNameNode
    extends PNodeWithContext {
        public abstract TruffleString execute(Frame var1, Node var2, Object var3);

        @Specialization
        static TruffleString get(VirtualFrame frame, Node inliningTarget, Object self, @Cached GetClassNode getClass, @Cached(inline=false) GetFullyQualifiedNameNode getFullyQualifiedNameNode) {
            return getFullyQualifiedNameNode.execute((Frame)frame, getClass.execute(inliningTarget, self));
        }
    }

    @GenerateUncached
    @ImportStatic(value={SpecialAttributeNames.class})
    public static abstract class GetFullyQualifiedNameNode
    extends PNodeWithContext {
        public abstract TruffleString execute(Frame var1, Object var2);

        @Specialization
        static TruffleString get(VirtualFrame frame, Object cls, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttr lookupAttr, @Cached CastToTruffleStringNode cast, @Cached TruffleString.EqualNode equalNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            Object moduleNameObject = lookupAttr.execute((Frame)frame, inliningTarget, cls, SpecialAttributeNames.T___MODULE__);
            Object qualNameObject = lookupAttr.execute((Frame)frame, inliningTarget, cls, SpecialAttributeNames.T___QUALNAME__);
            if (qualNameObject == PNone.NO_VALUE) {
                return StringLiterals.T_VALUE_UNKNOWN;
            }
            TruffleString qualName = cast.execute(inliningTarget, qualNameObject);
            if (moduleNameObject == PNone.NO_VALUE) {
                return qualName;
            }
            TruffleString moduleName = cast.execute(inliningTarget, moduleNameObject);
            if (equalNode.execute((AbstractTruffleString)moduleName, (AbstractTruffleString)BuiltinNames.T_BUILTINS, PythonUtils.TS_ENCODING)) {
                return qualName;
            }
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            appendStringNode.execute(sb, (AbstractTruffleString)moduleName);
            appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_DOT);
            appendStringNode.execute(sb, (AbstractTruffleString)qualName);
            return toStringNode.execute(sb);
        }

        @NeverDefault
        public static GetFullyQualifiedNameNode create() {
            return ObjectNodesFactory.GetFullyQualifiedNameNodeGen.create();
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class CommonReduceNode
    extends PNodeWithContext {
        protected static final TruffleString T_MOD_COPYREG = PythonUtils.tsLiteral("copyreg");

        CommonReduceNode() {
        }

        public abstract Object execute(VirtualFrame var1, Node var2, Object var3, int var4);

        @Specialization(guards={"proto >= 2"})
        static Object reduceNewObj(VirtualFrame frame, Node inliningTarget, Object obj, int proto, @Cached GetClassNode getClassNode, @Cached(value="create(T___NEW__)", inline=false) LookupAttributeInMRONode lookupNew, @Cached PyObjectLookupAttr lookupAttr, @Cached.Exclusive @Cached PyImportImport importNode, @Cached InlinedConditionProfile newObjProfile, @Cached InlinedConditionProfile hasArgsProfile, @Cached(inline=false) GetNewArgsNode getNewArgsNode, @Cached(inline=false) GetStateNode getStateNode, @Cached(inline=false) BuiltinFunctions.IsSubClassNode isSubClassNode, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached SequenceStorageNodes.ToArrayNode toArrayNode, @Cached PyObjectSizeNode sizeNode, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callMethod, @Cached PyObjectGetIter getIter, @Cached(inline=false) PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            PTuple newargs;
            Object newobj;
            Object cls = getClassNode.execute(inliningTarget, obj);
            if (lookupNew.execute(cls) == PNone.NO_VALUE) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_PICKLE_OBJECT_TYPE, obj);
            }
            Pair<Object, Object> rv = getNewArgsNode.execute(frame, obj);
            Object args = rv.getLeft();
            Object kwargs = rv.getRight();
            Object copyReg = importNode.execute(frame, inliningTarget, T_MOD_COPYREG);
            boolean hasargs = args != PNone.NONE;
            if (newObjProfile.profile(inliningTarget, kwargs == PNone.NONE || sizeNode.execute((Frame)frame, inliningTarget, kwargs) == 0)) {
                Object[] newargsVals;
                newobj = lookupAttr.execute((Frame)frame, inliningTarget, copyReg, SpecialAttributeNames.T___NEWOBJ__);
                if (hasArgsProfile.profile(inliningTarget, hasargs)) {
                    SequenceStorage sequenceStorage = getSequenceStorageNode.execute(inliningTarget, args);
                    Object[] vals = toArrayNode.execute(inliningTarget, sequenceStorage);
                    newargsVals = new Object[vals.length + 1];
                    newargsVals[0] = cls;
                    System.arraycopy(vals, 0, newargsVals, 1, vals.length);
                } else {
                    newargsVals = new Object[]{cls};
                }
                newargs = factory.createTuple(newargsVals);
            } else if (hasArgsProfile.profile(inliningTarget, hasargs)) {
                newobj = lookupAttr.execute((Frame)frame, inliningTarget, copyReg, SpecialAttributeNames.T___NEWOBJ_EX__);
                newargs = factory.createTuple(new Object[]{cls, args, kwargs});
            } else {
                throw raiseNode.get(inliningTarget).raiseBadInternalCall();
            }
            boolean objIsList = isSubClassNode.executeWith(frame, cls, (Object)PythonBuiltinClassType.PList);
            boolean objIsDict = isSubClassNode.executeWith(frame, cls, (Object)PythonBuiltinClassType.PDict);
            boolean required = !hasargs && !objIsDict && !objIsList;
            Object state = getStateNode.execute(frame, obj, required, copyReg);
            PNone listitems = objIsList ? getIter.execute((Frame)frame, inliningTarget, obj) : PNone.NONE;
            PNone dictitems = objIsDict ? getIter.execute((Frame)frame, inliningTarget, callMethod.execute((Frame)frame, inliningTarget, obj, SpecialMethodNames.T_ITEMS, new Object[0])) : PNone.NONE;
            return factory.createTuple(new Object[]{newobj, newargs, state, listitems, dictitems});
        }

        @Specialization(guards={"proto < 2"})
        static Object reduceCopyReg(VirtualFrame frame, Node inliningTarget, Object obj, int proto, @Cached.Exclusive @Cached PyImportImport importNode, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callMethod) {
            Object copyReg = importNode.execute(frame, inliningTarget, T_MOD_COPYREG);
            return callMethod.execute((Frame)frame, inliningTarget, copyReg, T__REDUCE_EX, obj, proto);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class CheckBasesizeForGetState
    extends Node {
        CheckBasesizeForGetState() {
        }

        public abstract boolean execute(Node var1, Object var2, Object var3, int var4);

        @Specialization
        boolean doNative(PythonAbstractNativeObject obj, Object type, int slotNum, @Cached(inline=false) CApiTransitions.PythonToNativeNode toSulongNode, @Cached(inline=false) CExtNodes.PCallCapiFunction callCapiFunction) {
            Object result = callCapiFunction.call(NativeCAPISymbol.FUN_CHECK_BASESIZE_FOR_GETSTATE, toSulongNode.execute(type), slotNum);
            return (Integer)result == 0;
        }

        @Fallback
        boolean doManaged(Object obj, Object type, int slotNum) {
            return obj.getClass() == PythonObject.class;
        }
    }

    @ImportStatic(value={PythonOptions.class, PGuards.class})
    static abstract class GetStateNode
    extends Node {
        GetStateNode() {
        }

        public abstract Object execute(VirtualFrame var1, Object var2, boolean var3, Object var4);

        @Specialization
        Object dispatch(VirtualFrame frame, Object obj, boolean required, Object copyReg, @Bind(value="this") Node inliningTarget, @Cached GetStateInternalNode getStateInternalNode, @Cached PyObjectLookupAttr lookupAttr) {
            Object getStateAttr = lookupAttr.execute((Frame)frame, inliningTarget, obj, SpecialMethodNames.T___GETSTATE__);
            return getStateInternalNode.execute(frame, obj, required, copyReg, getStateAttr);
        }

        @ImportStatic(value={PGuards.class})
        static abstract class GetStateInternalNode
        extends Node {
            GetStateInternalNode() {
            }

            public abstract Object execute(VirtualFrame var1, Object var2, boolean var3, Object var4, Object var5);

            @Specialization(guards={"!isNoValue(getStateAttr)"})
            static Object getState(VirtualFrame frame, Object obj, boolean required, Object copyReg, Object getStateAttr, @Cached CallNode callNode) {
                return callNode.execute((Frame)frame, getStateAttr, new Object[0]);
            }

            @Specialization
            static Object getStateFromSlots(VirtualFrame frame, Object obj, boolean required, Object copyReg, PNone getStateAttr, @Bind(value="this") Node inliningTarget, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached SequenceStorageNodes.ToArrayNode toArrayNode, @Cached TypeNodes.GetItemSizeNode getItemsizeNode, @Cached CastToTruffleStringNode toStringNode, @Cached GetSlotNamesNode getSlotNamesNode, @Cached GetClassNode getClassNode, @Cached PyObjectSizeNode sizeNode, @Cached PyObjectLookupAttr lookupAttr, @Cached HashingStorageNodes.HashingStorageSetItem setHashingStorageItem, @Cached CheckBasesizeForGetState checkBasesize, @Cached PythonObjectFactory.Lazy factory, @Cached PRaiseNode.Lazy raiseNode) {
                Object type = getClassNode.execute(inliningTarget, obj);
                if (required && getItemsizeNode.execute(inliningTarget, type) != 0L) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_PICKLE_OBJECT_TYPE, obj);
                }
                Object dict = lookupAttr.execute((Frame)frame, inliningTarget, obj, SpecialAttributeNames.T___DICT__);
                Object state = !PGuards.isNoValue(dict) && sizeNode.execute((Frame)frame, inliningTarget, dict) > 0 ? dict : PNone.NONE;
                Object slotnames = getSlotNamesNode.execute(frame, type, copyReg);
                Object[] names = PythonUtils.EMPTY_OBJECT_ARRAY;
                if (!PGuards.isNone(slotnames)) {
                    SequenceStorage sequenceStorage = getSequenceStorageNode.execute(inliningTarget, slotnames);
                    names = toArrayNode.execute(inliningTarget, sequenceStorage);
                }
                if (required && !checkBasesize.execute(inliningTarget, obj, type, names.length)) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_PICKLE_OBJECT_TYPE, obj);
                }
                if (names.length > 0) {
                    EconomicMapStorage slotsStorage = EconomicMapStorage.create(names.length);
                    boolean haveSlots = false;
                    for (Object o : names) {
                        try {
                            TruffleString name = toStringNode.execute(inliningTarget, o);
                            Object value = lookupAttr.execute((Frame)frame, inliningTarget, obj, name);
                            if (PGuards.isNoValue(value)) continue;
                            HashingStorage newStorage = setHashingStorageItem.execute((Frame)frame, inliningTarget, slotsStorage, name, value);
                            assert (newStorage == slotsStorage);
                            haveSlots = true;
                        }
                        catch (CannotCastException cce) {
                            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.ATTR_NAME_MUST_BE_STRING, o);
                        }
                    }
                    if (haveSlots) {
                        state = factory.get(inliningTarget).createTuple(new Object[]{state, factory.get(inliningTarget).createDict(slotsStorage)});
                    }
                }
                return state;
            }
        }
    }

    @ImportStatic(value={PythonOptions.class, PGuards.class})
    static abstract class GetSlotNamesNode
    extends Node {
        @Node.Child
        PyObjectLookupAttr lookupAttr = PyObjectLookupAttr.create();

        GetSlotNamesNode() {
        }

        public final Object execute(VirtualFrame frame, Object cls, Object copyReg) {
            Object clsDict = this.lookupAttr.executeCached((Frame)frame, cls, SpecialAttributeNames.T___DICT__);
            return this.executeInternal(frame, cls, clsDict, copyReg);
        }

        abstract Object executeInternal(VirtualFrame var1, Object var2, Object var3, Object var4);

        @Specialization
        Object dispatchDict(VirtualFrame frame, Object cls, PDict clsDict, Object copyReg, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="internal") @Cached GetSlotNamesInternalNode getSlotNamesInternalNode, @Cached.Shared(value="getItem") @Cached HashingStorageNodes.HashingStorageGetItem getItem) {
            Object slotNames = getItem.execute(inliningTarget, clsDict.getDictStorage(), T__SLOTNAMES);
            slotNames = slotNames == null ? PNone.NO_VALUE : slotNames;
            return getSlotNamesInternalNode.execute(frame, cls, copyReg, slotNames);
        }

        @Specialization(guards={"isDict(mapping)"})
        Object dispatchMappingProxy(VirtualFrame frame, Object cls, PMappingproxy clsDict, Object copyReg, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="internal") @Cached GetSlotNamesInternalNode getSlotNamesInternalNode, @Bind(value="clsDict.getMapping()") Object mapping, @Cached.Shared(value="getItem") @Cached HashingStorageNodes.HashingStorageGetItem getItem) {
            PDict mappingDict = (PDict)mapping;
            return this.dispatchDict(frame, cls, mappingDict, copyReg, inliningTarget, getSlotNamesInternalNode, getItem);
        }

        @Specialization(guards={"isNoValue(noValue)"})
        Object dispatchNoValue(VirtualFrame frame, Object cls, PNone noValue, Object copyReg, @Cached.Shared(value="internal") @Cached GetSlotNamesInternalNode getSlotNamesInternalNode) {
            return getSlotNamesInternalNode.execute(frame, cls, copyReg, noValue);
        }

        @Fallback
        static Object dispatchGeneric(VirtualFrame frame, Object cls, Object clsDict, Object copyReg, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="internal") @Cached GetSlotNamesInternalNode getSlotNamesInternalNode, @Cached PyObjectGetItem getItemNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isBuiltinClassProfile) {
            Object slotNames = PNone.NO_VALUE;
            if (!PGuards.isNoValue(clsDict)) {
                try {
                    slotNames = getItemNode.execute((Frame)frame, inliningTarget, clsDict, SpecialAttributeNames.T___SLOTNAMES__);
                }
                catch (PException ex) {
                    ex.expect(inliningTarget, PythonBuiltinClassType.KeyError, isBuiltinClassProfile);
                }
            }
            return getSlotNamesInternalNode.execute(frame, cls, copyReg, slotNames);
        }

        @ImportStatic(value={PGuards.class})
        static abstract class GetSlotNamesInternalNode
        extends Node {
            GetSlotNamesInternalNode() {
            }

            public abstract Object execute(VirtualFrame var1, Object var2, Object var3, Object var4);

            @Specialization(guards={"!isNoValue(slotNames)"})
            static Object getSlotNames(Object cls, Object copyReg, Object slotNames, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PyListCheckNode listCheckNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
                Object names = slotNames;
                if (!PGuards.isNone(names) && !listCheckNode.execute(inliningTarget, names)) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.SLOTNAMES_SHOULD_BE_A_NOT_B, cls, "list or None", names);
                }
                return names;
            }

            @Specialization
            static Object getCopyRegSlotNames(VirtualFrame frame, Object cls, Object copyReg, PNone slotNames, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PyListCheckNode listCheckNode, @Cached PyObjectCallMethodObjArgs callMethod, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
                Object names = callMethod.execute((Frame)frame, inliningTarget, copyReg, T__SLOTNAMES, cls);
                if (!PGuards.isNone(names) && !listCheckNode.execute(inliningTarget, names)) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.COPYREG_SLOTNAMES);
                }
                return names;
            }
        }
    }

    @ImportStatic(value={PythonOptions.class, PGuards.class})
    static abstract class GetNewArgsNode
    extends Node {
        GetNewArgsNode() {
        }

        public abstract Pair<Object, Object> execute(VirtualFrame var1, Object var2);

        @Specialization
        static Pair<Object, Object> dispatch(VirtualFrame frame, Object obj, @Bind(value="this") Node inliningTarget, @Cached GetNewArgsInternalNode getNewArgsInternalNode, @Cached PyObjectLookupAttr lookupAttr) {
            Object getNewArgsExAttr = lookupAttr.execute((Frame)frame, inliningTarget, obj, SpecialMethodNames.T___GETNEWARGS_EX__);
            Object getNewArgsAttr = lookupAttr.execute((Frame)frame, inliningTarget, obj, SpecialMethodNames.T___GETNEWARGS__);
            return getNewArgsInternalNode.execute(frame, getNewArgsExAttr, getNewArgsAttr);
        }

        @ImportStatic(value={PGuards.class})
        static abstract class GetNewArgsInternalNode
        extends Node {
            GetNewArgsInternalNode() {
            }

            public abstract Pair<Object, Object> execute(VirtualFrame var1, Object var2, Object var3);

            @Specialization(guards={"!isNoValue(getNewArgsExAttr)"})
            static Pair<Object, Object> doNewArgsEx(VirtualFrame frame, Object getNewArgsExAttr, Object getNewArgsAttr, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CallNode callNode, @Cached.Exclusive @Cached PyTupleCheckNode tupleCheckNode, @Cached PyDictCheckNode isDictSubClassNode, @Cached SequenceStorageNodes.GetItemNode getItemNode, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached PyObjectSizeNode sizeNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
                Object newargs = callNode.execute((Frame)frame, getNewArgsExAttr, new Object[0]);
                if (!tupleCheckNode.execute(inliningTarget, newargs)) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.SHOULD_RETURN_TYPE_A_NOT_TYPE_B, SpecialMethodNames.T___GETNEWARGS_EX__, "tuple", newargs);
                }
                int length = sizeNode.execute((Frame)frame, inliningTarget, newargs);
                if (length != 2) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.SHOULD_RETURN_A_NOT_B, SpecialMethodNames.T___GETNEWARGS_EX__, "tuple of length 2", length);
                }
                SequenceStorage sequenceStorage = getSequenceStorageNode.execute(inliningTarget, newargs);
                Object args = getItemNode.execute(sequenceStorage, 0);
                Object kwargs = getItemNode.execute(sequenceStorage, 1);
                if (!tupleCheckNode.execute(inliningTarget, args)) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.MUST_BE_TYPE_A_NOT_TYPE_B, "first item of the tuple returned by __getnewargs_ex__", "tuple", args);
                }
                if (!isDictSubClassNode.execute(inliningTarget, kwargs)) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.MUST_BE_TYPE_A_NOT_TYPE_B, "second item of the tuple returned by __getnewargs_ex__", "dict", kwargs);
                }
                return Pair.create((Object)args, (Object)kwargs);
            }

            @Specialization(guards={"!isNoValue(getNewArgsAttr)"})
            static Pair<Object, Object> doNewArgs(VirtualFrame frame, PNone getNewArgsExAttr, Object getNewArgsAttr, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CallNode callNode, @Cached.Exclusive @Cached PyTupleCheckNode tupleCheckNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
                Object args = callNode.execute((Frame)frame, getNewArgsAttr, new Object[0]);
                if (!tupleCheckNode.execute(inliningTarget, args)) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.SHOULD_RETURN_TYPE_A_NOT_TYPE_B, SpecialMethodNames.T___GETNEWARGS__, "tuple", args);
                }
                return Pair.create((Object)args, (Object)PNone.NONE);
            }

            @Specialization
            static Pair<Object, Object> doHasNeither(PNone getNewArgsExAttr, PNone getNewArgsAttr) {
                return Pair.create((Object)PNone.NONE, (Object)PNone.NONE);
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetIdentityHashNode
    extends Node {
        public abstract int execute(Node var1, Object var2);

        @Specialization
        static int idHash(Object object, @Cached(inline=false) GetIdNode getIdNode) {
            Object id = getIdNode.execute(object);
            if (id instanceof Long) {
                return Long.hashCode((Long)id);
            }
            assert (id instanceof PInt);
            return Long.hashCode(((PInt)id).longValue());
        }
    }

    @ImportStatic(value={PythonOptions.class, PGuards.class})
    @GenerateUncached
    public static abstract class GetIdNode
    extends PNodeWithContext {
        public abstract Object execute(Object var1);

        @Specialization
        static Object id(PBytes self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetObjectIdNode getObjectIdNode, @Cached.Shared @Cached BuiltinClassProfiles.IsAnyBuiltinObjectProfile isBuiltin, @Cached.Shared @Cached PyObjectSizeNode sizeNode) {
            if (isBuiltin.profileIsAnyBuiltinObject(inliningTarget, self) && sizeNode.execute(null, inliningTarget, self) == 0) {
                return IDUtils.ID_EMPTY_BYTES;
            }
            return getObjectIdNode.execute(inliningTarget, self);
        }

        @Specialization
        static Object id(PFrozenSet self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetObjectIdNode getObjectIdNode, @Cached.Shared @Cached BuiltinClassProfiles.IsAnyBuiltinObjectProfile isBuiltin, @Cached.Shared @Cached PyObjectSizeNode sizeNode) {
            if (isBuiltin.profileIsAnyBuiltinObject(inliningTarget, self) && sizeNode.execute(null, inliningTarget, self) == 0) {
                return IDUtils.ID_EMPTY_FROZENSET;
            }
            return getObjectIdNode.execute(inliningTarget, self);
        }

        @Specialization
        static Object id(PTuple self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetObjectIdNode getObjectIdNode, @Cached.Shared @Cached BuiltinClassProfiles.IsAnyBuiltinObjectProfile isBuiltin, @Cached.Shared @Cached PyObjectSizeNode sizeNode) {
            if (isBuiltin.profileIsAnyBuiltinObject(inliningTarget, self) && sizeNode.execute(null, inliningTarget, self) == 0) {
                return IDUtils.ID_EMPTY_TUPLE;
            }
            return getObjectIdNode.execute(inliningTarget, self);
        }

        @Specialization
        static Object id(PEllipsis self) {
            return IDUtils.ID_ELLIPSIS;
        }

        @Specialization
        static Object id(PNone self) {
            return IDUtils.ID_NONE;
        }

        @Specialization
        static Object id(PNotImplemented self) {
            return IDUtils.ID_NOTIMPLEMENTED;
        }

        @Specialization
        static Object id(PythonBuiltinClassType self) {
            return IDUtils.getId(self);
        }

        @Specialization
        static Object id(PythonBuiltinClass self) {
            return IDUtils.getId(self.getType());
        }

        @Specialization
        static Object id(PythonAbstractNativeObject self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetObjectIdNode getObjectIdNode) {
            return getObjectIdNode.execute(inliningTarget, self);
        }

        @Specialization
        static Object id(boolean self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetObjectIdNode getObjectIdNode) {
            PythonContext context = PythonContext.get(getObjectIdNode);
            PInt bool = self ? context.getTrue() : context.getFalse();
            return getObjectIdNode.execute(inliningTarget, bool);
        }

        @Specialization
        static Object id(double self, @Cached.Shared @Cached PythonObjectFactory factory) {
            return IDUtils.getId(self, factory);
        }

        @Specialization
        static Object id(PFloat self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetObjectIdNode getObjectIdNode) {
            return getObjectIdNode.execute(inliningTarget, self);
        }

        @Specialization
        static Object id(long self, @Cached.Shared @Cached PythonObjectFactory factory) {
            return IDUtils.getId(self, factory);
        }

        @Specialization
        static Object id(PInt self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetObjectIdNode getObjectIdNode) {
            return getObjectIdNode.execute(inliningTarget, self);
        }

        @Specialization
        static Object id(int self) {
            return IDUtils.getId(self);
        }

        @Specialization
        static Object id(TruffleString self, @Bind(value="this") Node inliningTarget) {
            if (self.isEmpty()) {
                return IDUtils.ID_EMPTY_UNICODE;
            }
            return PythonContext.get(inliningTarget).getNextStringId(self);
        }

        @Specialization
        static Object id(PString self, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetObjectIdNode getObjectIdNode, @Cached StringNodes.IsInternedStringNode isInternedStringNode, @Cached StringNodes.StringMaterializeNode materializeNode) {
            if (isInternedStringNode.execute(inliningTarget, self)) {
                return GetIdNode.id(materializeNode.execute(inliningTarget, self), inliningTarget);
            }
            return getObjectIdNode.execute(inliningTarget, self);
        }

        @Specialization
        Object id(PythonNativeVoidPtr self) {
            return self.getNativePointer();
        }

        @Specialization
        Object id(PCell self) {
            return PythonContext.get(this).getNextObjectId(self);
        }

        protected static boolean isDefaultCase(PythonObject object) {
            return !(object instanceof PBytes) && !(object instanceof PFrozenSet) && !(object instanceof PTuple) && !(object instanceof PInt) && !(object instanceof PFloat) && !(object instanceof PString) && !(object instanceof PythonBuiltinClass);
        }

        @Specialization(guards={"isDefaultCase(self)"})
        static Object id(PythonObject self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetObjectIdNode getObjectIdNode) {
            return getObjectIdNode.execute(inliningTarget, self);
        }

        @Specialization(guards={"isForeignObjectNode.execute(inliningTarget, self)"}, limit="1")
        static Object idForeign(Object self, @Bind(value="this") Node inliningTarget, @Cached IsForeignObjectNode isForeignObjectNode) {
            return PythonContext.get(isForeignObjectNode).getNextObjectId(self);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class GetObjectIdNode
    extends Node {
        private static final HiddenKey OBJECT_ID = new HiddenKey("_id");

        GetObjectIdNode() {
        }

        public abstract long execute(Node var1, Object var2);

        protected static Assumption getSingleThreadedAssumption(Node node) {
            return PythonLanguage.get((Node)node).singleThreadedAssumption;
        }

        protected static boolean isIDableObject(Object object) {
            return object instanceof PythonObject || object instanceof PythonAbstractNativeObject;
        }

        @Specialization(guards={"isIDableObject(self)"}, assumptions={"getSingleThreadedAssumption(readNode)"})
        static long singleThreadedObject(Object self, @Cached.Shared @Cached(inline=false) ReadAttributeFromDynamicObjectNode readNode, @Cached.Shared @Cached(inline=false) WriteAttributeToDynamicObjectNode writeNode) {
            Object objectId = readNode.execute(self, OBJECT_ID);
            if (objectId == PNone.NO_VALUE) {
                objectId = PythonContext.get(readNode).getNextObjectId();
                writeNode.execute(self, OBJECT_ID, objectId);
            }
            assert (objectId instanceof Long) : "internal object id hidden key must be a long at this point";
            return (Long)objectId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIDableObject(self)"}, replaces={"singleThreadedObject"})
        static long multiThreadedObject(Object self, @Cached.Shared @Cached(inline=false) ReadAttributeFromDynamicObjectNode readNode, @Cached.Shared @Cached(inline=false) WriteAttributeToDynamicObjectNode writeNode) {
            Object objectId = readNode.execute(self, OBJECT_ID);
            if (objectId == PNone.NO_VALUE) {
                Object object = self;
                synchronized (object) {
                    objectId = readNode.execute(self, OBJECT_ID);
                    if (objectId == PNone.NO_VALUE) {
                        objectId = PythonContext.get(readNode).getNextObjectId();
                        writeNode.execute(self, OBJECT_ID, objectId);
                    }
                }
            }
            assert (objectId instanceof Long) : "internal object id hidden key must be a long at this point";
            return (Long)objectId;
        }
    }
}

