/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.thread;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.thread.PThreadLocal;
import com.oracle.graal.python.builtins.objects.thread.ThreadLocalBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.thread.ThreadLocalNodes;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallTernaryMethodNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PThreadLocal})
public final class ThreadLocalBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ThreadLocalBuiltinsFactory.getFactories();
    }

    @Builtin(name="__delattr__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class DelattrNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        private GetClassNode getDescClassNode;

        @Specialization
        PNone doIt(VirtualFrame frame, PThreadLocal object, Object keyObj, @Bind(value="this") Node inliningTarget, @Cached ThreadLocalNodes.GetThreadLocalDict getThreadLocalDict, @Cached LookupAttributeInMRONode.Dynamic getExisting, @Cached GetClassNode getClassNode, @Cached(value="create(T___DELETE__)") LookupAttributeInMRONode lookupDeleteNode, @Cached CallBinaryMethodNode callDelete, @Cached HashingStorageNodes.HashingStorageDelItem delHashingStorageItem, @Cached CastToTruffleStringNode castKeyToStringNode, @Cached PRaiseNode.Lazy raiseNode) {
            Object dataDescClass;
            Object delete;
            TruffleString key;
            PDict localDict = getThreadLocalDict.execute(frame, object);
            try {
                key = castKeyToStringNode.execute(inliningTarget, keyObj);
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_NAME_MUST_BE_STRING, keyObj);
            }
            Object type = getClassNode.execute(inliningTarget, object);
            Object descr = getExisting.execute(type, key);
            if (descr != PNone.NO_VALUE && PGuards.isCallable(delete = lookupDeleteNode.execute(dataDescClass = this.getDescClass(descr)))) {
                callDelete.executeObject((Frame)frame, delete, descr, object);
                return PNone.NONE;
            }
            Object found = delHashingStorageItem.executePop(inliningTarget, localDict.getDictStorage(), key, localDict);
            if (found != null) {
                return PNone.NONE;
            }
            if (descr != PNone.NO_VALUE) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.ATTR_S_READONLY, key);
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, object, key);
        }

        private Object getDescClass(Object desc) {
            if (this.getDescClassNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getDescClassNode = (GetClassNode)this.insert(GetClassNode.create());
            }
            return this.getDescClassNode.executeCached(desc);
        }
    }

    @Builtin(name="__setattr__", minNumOfPositionalArgs=3)
    @ImportStatic(value={PGuards.class})
    @GenerateNodeFactory
    public static abstract class SetattrNode
    extends PythonTernaryBuiltinNode {
        @Node.Child
        private GetClassNode getDescClassNode;
        @Node.Child
        private LookupCallableSlotInMRONode lookupSetNode;
        @Node.Child
        private CallTernaryMethodNode callSetNode;
        @Node.Child
        private HashingStorageNodes.HashingStorageSetItem setHashingStorageItem;
        @CompilerDirectives.CompilationFinal
        private boolean changedStorage;

        @Specialization
        protected PNone doStringKey(VirtualFrame frame, PThreadLocal object, Object keyObject, Object value, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castKeyToStringNode, @Cached ThreadLocalNodes.GetThreadLocalDict getThreadLocalDict, @Cached GetClassNode getClassNode, @Cached LookupAttributeInMRONode.Dynamic getExisting, @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString key;
            PDict localDict = getThreadLocalDict.execute(frame, object);
            try {
                key = castKeyToStringNode.execute(inliningTarget, keyObject);
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_NAME_MUST_BE_STRING, keyObject);
            }
            Object type = getClassNode.execute(inliningTarget, object);
            Object descr = getExisting.execute(type, key);
            if (descr != PNone.NO_VALUE) {
                Object dataDescClass = this.getDescClass(descr);
                Object set = this.ensureLookupSetNode().execute(dataDescClass);
                if (PGuards.isCallableOrDescriptor(set)) {
                    this.ensureCallSetNode().execute((Frame)frame, set, descr, object, value);
                    return PNone.NONE;
                }
            }
            this.writeAttribute(frame, localDict, key, value);
            return PNone.NONE;
        }

        private Object getDescClass(Object desc) {
            if (this.getDescClassNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getDescClassNode = (GetClassNode)this.insert(GetClassNode.create());
            }
            return this.getDescClassNode.executeCached(desc);
        }

        private LookupCallableSlotInMRONode ensureLookupSetNode() {
            if (this.lookupSetNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupSetNode = (LookupCallableSlotInMRONode)this.insert(LookupCallableSlotInMRONode.create(SpecialMethodSlot.Set));
            }
            return this.lookupSetNode;
        }

        private CallTernaryMethodNode ensureCallSetNode() {
            if (this.callSetNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callSetNode = (CallTernaryMethodNode)this.insert(CallTernaryMethodNode.create());
            }
            return this.callSetNode;
        }

        private void writeAttribute(VirtualFrame frame, PDict dict, Object key, Object value) {
            HashingStorage newStorage;
            HashingStorage storage;
            if (this.setHashingStorageItem == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setHashingStorageItem = (HashingStorageNodes.HashingStorageSetItem)this.insert(HashingStorageNodes.HashingStorageSetItem.create());
            }
            if ((storage = dict.getDictStorage()) != (newStorage = this.setHashingStorageItem.executeCached((Frame)frame, storage, key, value))) {
                if (!this.changedStorage) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.changedStorage = true;
                }
                dict.setDictStorage(newStorage);
            }
        }
    }

    @Builtin(name="__getattribute__", minNumOfPositionalArgs=2)
    @ImportStatic(value={PGuards.class})
    @GenerateNodeFactory
    public static abstract class GetAttributeNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        private LookupCallableSlotInMRONode lookupGetNode;
        @Node.Child
        private LookupCallableSlotInMRONode lookupSetNode;
        @Node.Child
        private LookupCallableSlotInMRONode lookupDeleteNode;
        @Node.Child
        private CallTernaryMethodNode dispatchGet;
        @Node.Child
        private GetClassNode getDescClassNode;

        @Specialization
        Object doIt(VirtualFrame frame, PThreadLocal object, Object keyObj, @Bind(value="this") Node inliningTarget, @Cached ThreadLocalNodes.GetThreadLocalDict getThreadLocalDict, @Cached LookupAttributeInMRONode.Dynamic lookup, @Cached GetClassNode getClassNode, @Cached CastToTruffleStringNode castKeyToStringNode, @Cached HashingStorageNodes.HashingStorageGetItem getDictStorageItem, @Cached PRaiseNode.Lazy raiseNode) {
            Object value;
            boolean hasDescr;
            TruffleString key;
            PDict localDict = getThreadLocalDict.execute(frame, object);
            try {
                key = castKeyToStringNode.execute(inliningTarget, keyObj);
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_NAME_MUST_BE_STRING, keyObj);
            }
            Object type = getClassNode.execute(inliningTarget, object);
            Object descr = lookup.execute(type, key);
            Object dataDescClass = null;
            boolean bl = hasDescr = descr != PNone.NO_VALUE;
            if (hasDescr) {
                Object get;
                dataDescClass = this.getDescClass(descr);
                Object delete = PNone.NO_VALUE;
                Object set = this.lookupSet(dataDescClass);
                if (set == PNone.NO_VALUE) {
                    delete = this.lookupDelete(dataDescClass);
                }
                if ((set != PNone.NO_VALUE || delete != PNone.NO_VALUE) && PGuards.isCallableOrDescriptor(get = this.lookupGet(dataDescClass))) {
                    return this.dispatch(frame, object, type, descr, get);
                }
            }
            if ((value = getDictStorageItem.execute((Frame)frame, inliningTarget, localDict.getDictStorage(), key)) != null) {
                return value;
            }
            if (hasDescr) {
                Object get = this.lookupGet(dataDescClass);
                if (get == PNone.NO_VALUE) {
                    return descr;
                }
                if (PGuards.isCallableOrDescriptor(get)) {
                    return this.dispatch(frame, object, type, descr, get);
                }
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, object, key);
        }

        private Object dispatch(VirtualFrame frame, Object object, Object type, Object descr, Object get) {
            if (this.dispatchGet == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.dispatchGet = (CallTernaryMethodNode)this.insert(CallTernaryMethodNode.create());
            }
            return this.dispatchGet.execute((Frame)frame, get, descr, object, type);
        }

        private Object getDescClass(Object desc) {
            if (this.getDescClassNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getDescClassNode = (GetClassNode)this.insert(GetClassNode.create());
            }
            return this.getDescClassNode.executeCached(desc);
        }

        private Object lookupGet(Object dataDescClass) {
            if (this.lookupGetNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupGetNode = (LookupCallableSlotInMRONode)this.insert(LookupCallableSlotInMRONode.create(SpecialMethodSlot.Get));
            }
            return this.lookupGetNode.execute(dataDescClass);
        }

        private Object lookupDelete(Object dataDescClass) {
            if (this.lookupDeleteNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupDeleteNode = (LookupCallableSlotInMRONode)this.insert(LookupCallableSlotInMRONode.create(SpecialMethodSlot.Delete));
            }
            return this.lookupDeleteNode.execute(dataDescClass);
        }

        private Object lookupSet(Object dataDescClass) {
            if (this.lookupSetNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupSetNode = (LookupCallableSlotInMRONode)this.insert(LookupCallableSlotInMRONode.create(SpecialMethodSlot.Set));
            }
            return this.lookupSetNode.execute(dataDescClass);
        }

        public static ObjectBuiltins.GetAttributeNode create() {
            return ObjectBuiltinsFactory.GetAttributeNodeFactory.create();
        }
    }

    @Builtin(name="__dict__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class DictNode
    extends PythonUnaryBuiltinNode {
        DictNode() {
        }

        @Specialization
        PDict repr(VirtualFrame frame, PThreadLocal self, @Cached ThreadLocalNodes.GetThreadLocalDict getThreadLocalDict) {
            return getThreadLocalDict.execute(frame, self);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class InitNode
    extends PythonUnaryBuiltinNode {
        InitNode() {
        }

        @Specialization
        PNone repr(PThreadLocal self) {
            return PNone.NONE;
        }
    }
}

