/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.types;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.ellipsis.PEllipsis;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.types.GenericAliasBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.types.GenericTypeNodes;
import com.oracle.graal.python.builtins.objects.types.PGenericAlias;
import com.oracle.graal.python.lib.PyObjectDir;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.lib.PySequenceContainsNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PGenericAlias})
public final class GenericAliasBuiltins
extends PythonBuiltins {
    private static final TruffleString[] ATTR_EXCEPTIONS = new TruffleString[]{SpecialAttributeNames.T___ORIGIN__, SpecialAttributeNames.T___ARGS__, SpecialAttributeNames.T___PARAMETERS__, SpecialMethodNames.T___MRO_ENTRIES__, SpecialMethodNames.T___REDUCE_EX__, SpecialMethodNames.T___REDUCE__, SpecialMethodNames.T___COPY__, SpecialMethodNames.T___DEEPCOPY__};

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return GenericAliasBuiltinsFactory.getFactories();
    }

    @Builtin(name="__getitem__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GetItemNode
    extends PythonBinaryBuiltinNode {
        GetItemNode() {
        }

        @Specialization
        Object getitem(PGenericAlias self, Object item, @Cached PythonObjectFactory factory) {
            if (self.getParameters() == null) {
                self.setParameters(factory.createTuple(GenericTypeNodes.makeParameters(self.getArgs())));
            }
            Object[] newargs = GenericTypeNodes.subsParameters(this, self, self.getArgs(), self.getParameters(), item);
            PTuple newargsTuple = factory.createTuple(newargs);
            return factory.createGenericAlias(self.getOrigin(), newargsTuple);
        }
    }

    @Builtin(name="__dir__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class DirNode
    extends PythonUnaryBuiltinNode {
        DirNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object dir(PGenericAlias self, @Bind(value="this") Node inliningTarget, @Cached PyObjectDir dir, @Cached PySequenceContainsNode containsNode, @Cached ListNodes.AppendNode appendNode) {
            PList list = dir.execute(null, inliningTarget, self.getOrigin());
            for (int i = 0; i < ATTR_EXCEPTIONS.length; ++i) {
                if (containsNode.execute(null, inliningTarget, list, ATTR_EXCEPTIONS[i])) continue;
                appendNode.execute(list, ATTR_EXCEPTIONS[i]);
            }
            return list;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        ReduceNode() {
        }

        @Specialization
        static Object reduce(PGenericAlias self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached PythonObjectFactory factory) {
            PTuple args = factory.createTuple(new Object[]{self.getOrigin(), self.getArgs()});
            return factory.createTuple(new Object[]{getClassNode.execute(inliningTarget, self), args});
        }
    }

    @Builtin(name="__subclasscheck__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class SubclassCheckNode
    extends PythonBinaryBuiltinNode {
        SubclassCheckNode() {
        }

        @Specialization
        static Object check(PGenericAlias self, Object other, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ISSUBCLASS_ARG_2_CANNOT_BE_A_PARAMETERIZED_GENERIC);
        }
    }

    @Builtin(name="__instancecheck__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class InstanceCheckNode
    extends PythonBinaryBuiltinNode {
        InstanceCheckNode() {
        }

        @Specialization
        static Object check(PGenericAlias self, Object other, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ISINSTANCE_ARG_2_CANNOT_BE_A_PARAMETERIZED_GENERIC);
        }
    }

    @Builtin(name="__mro_entries__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class MroEntriesNode
    extends PythonBinaryBuiltinNode {
        MroEntriesNode() {
        }

        @Specialization
        static Object mro(PGenericAlias self, Object bases, @Cached PythonObjectFactory factory) {
            return factory.createTuple(new Object[]{self.getOrigin()});
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class EqNode
    extends PythonBinaryBuiltinNode {
        EqNode() {
        }

        @Specialization
        boolean eq(VirtualFrame frame, PGenericAlias self, PGenericAlias other, @Bind(value="this") Node inliningTarget, @Cached PyObjectRichCompareBool.EqNode eqOrigin, @Cached PyObjectRichCompareBool.EqNode eqArgs) {
            return eqOrigin.compare((Frame)frame, inliningTarget, self.getOrigin(), other.getOrigin()) && eqArgs.compare((Frame)frame, inliningTarget, self.getArgs(), other.getArgs());
        }

        @Fallback
        Object eq(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__getattribute__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GetAttributeNode
    extends PythonBinaryBuiltinNode {
        GetAttributeNode() {
        }

        @Specialization
        @ExplodeLoop
        Object getattribute(VirtualFrame frame, PGenericAlias self, Object nameObj, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode cast, @Cached TruffleString.EqualNode equalNode, @Cached PyObjectGetAttr getAttr, @Cached ObjectBuiltins.GetAttributeNode genericGetAttribute) {
            TruffleString name;
            try {
                name = cast.execute(inliningTarget, nameObj);
            }
            catch (CannotCastException e) {
                return genericGetAttribute.execute(frame, self, nameObj);
            }
            for (int i = 0; i < ATTR_EXCEPTIONS.length; ++i) {
                if (!equalNode.execute((AbstractTruffleString)name, (AbstractTruffleString)ATTR_EXCEPTIONS[i], PythonUtils.TS_ENCODING)) continue;
                return genericGetAttribute.execute(frame, self, nameObj);
            }
            return getAttr.execute((Frame)frame, inliningTarget, self.getOrigin(), name);
        }
    }

    @Builtin(name="__call__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    static abstract class CallMethodNode
    extends PythonVarargsBuiltinNode {
        CallMethodNode() {
        }

        @Specialization
        Object call(VirtualFrame frame, PGenericAlias self, Object[] args, PKeyword[] kwargs, @Bind(value="this") Node inliningTarget, @Cached CallNode callNode, @Cached PyObjectSetAttr setAttr, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile typeErrorProfile, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile attributeErrorProfile) {
            Object result;
            block2: {
                result = callNode.execute((Frame)frame, self.getOrigin(), args, kwargs);
                try {
                    setAttr.execute((Frame)frame, inliningTarget, result, SpecialAttributeNames.T___ORIG_CLASS__, self);
                }
                catch (PException e) {
                    if (typeErrorProfile.profileException(inliningTarget, e, PythonBuiltinClassType.TypeError) || attributeErrorProfile.profileException(inliningTarget, e, PythonBuiltinClassType.AttributeError)) break block2;
                    throw e;
                }
            }
            return result;
        }
    }

    @Builtin(name="__hash__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class HashNode
    extends PythonUnaryBuiltinNode {
        HashNode() {
        }

        @Specialization
        long hash(VirtualFrame frame, PGenericAlias self, @Bind(value="this") Node inliningTarget, @Cached PyObjectHashNode hashOrigin, @Cached PyObjectHashNode hashArgs) {
            long h0 = hashOrigin.execute((Frame)frame, inliningTarget, self.getOrigin());
            long h1 = hashArgs.execute((Frame)frame, inliningTarget, self.getArgs());
            return h0 ^ h1;
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        private static final TruffleString SEPARATOR = PythonUtils.tsLiteral(", ");

        ReprNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object repr(PGenericAlias self) {
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            ReprNode.reprItem(sb, self.getOrigin());
            sb.appendCodePointUncached(91);
            SequenceStorage argsStorage = self.getArgs().getSequenceStorage();
            for (int i = 0; i < argsStorage.length(); ++i) {
                if (i > 0) {
                    sb.appendStringUncached(SEPARATOR);
                }
                ReprNode.reprItem(sb, argsStorage.getItemNormalized(i));
            }
            if (argsStorage.length() == 0) {
                sb.appendCodePointUncached(40);
                sb.appendCodePointUncached(41);
            }
            sb.appendCodePointUncached(93);
            return sb.toStringUncached();
        }

        private static void reprItem(TruffleStringBuilder sb, Object obj) {
            if (obj == PEllipsis.INSTANCE) {
                sb.appendStringUncached(StringLiterals.T_ELLIPSIS);
                return;
            }
            GenericTypeNodes.reprItem(sb, obj);
        }
    }

    @Builtins(value={@Builtin(name="__or__", minNumOfPositionalArgs=2), @Builtin(name="__ror__", minNumOfPositionalArgs=2, reverseOperation=true)})
    @GenerateNodeFactory
    static abstract class OrNode
    extends PythonBinaryBuiltinNode {
        OrNode() {
        }

        @Specialization
        Object union(Object self, Object other, @Cached GenericTypeNodes.UnionTypeOrNode orNode) {
            return orNode.execute(self, other);
        }
    }

    @Builtin(name="__parameters__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ParametersNode
    extends PythonUnaryBuiltinNode {
        ParametersNode() {
        }

        @Specialization
        Object parameters(PGenericAlias self, @Bind(value="this") Node inliningTarget, @Cached PythonObjectFactory.Lazy factory) {
            if (self.getParameters() == null) {
                self.setParameters(factory.get(inliningTarget).createTuple(GenericTypeNodes.makeParameters(self.getArgs())));
            }
            return self.getParameters();
        }
    }

    @Builtin(name="__args__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ArgsNode
    extends PythonUnaryBuiltinNode {
        ArgsNode() {
        }

        @Specialization
        Object args(PGenericAlias self) {
            return self.getArgs();
        }
    }

    @Builtin(name="__origin__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class OriginNode
    extends PythonUnaryBuiltinNode {
        OriginNode() {
        }

        @Specialization
        Object origin(PGenericAlias self) {
            return self.getOrigin();
        }
    }
}

