/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.set.PSet;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyObjectIsTrueNodeGen;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaBooleanNode;
import com.oracle.graal.python.nodes.util.CastToJavaIntLossyNode;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached
@ImportStatic(value={SpecialMethodSlot.class})
public abstract class PyObjectIsTrueNode
extends PNodeWithContext {
    public final boolean executeCached(Frame frame, Object object) {
        return this.execute(frame, this, object);
    }

    public abstract boolean execute(Frame var1, Node var2, Object var3);

    protected abstract Object executeObject(Frame var1, Node var2, Object var3);

    @Specialization
    static boolean doBoolean(boolean object) {
        return object;
    }

    @Specialization
    static boolean doNone(PNone object) {
        return false;
    }

    @Specialization
    static boolean doInt(int object) {
        return object != 0;
    }

    @Specialization
    static boolean doLong(long object) {
        return object != 0L;
    }

    @Specialization
    static boolean doDouble(double object) {
        return object != 0.0;
    }

    @Specialization
    static boolean doString(TruffleString object) {
        return !object.isEmpty();
    }

    @Specialization(guards={"cannotBeOverriddenForImmutableType(object)"})
    static boolean doList(Node inliningTarget, PList object) {
        return object.getSequenceStorage().length() != 0;
    }

    @Specialization(guards={"cannotBeOverriddenForImmutableType(object)"})
    static boolean doTuple(Node inliningTarget, PTuple object) {
        return object.getSequenceStorage().length() != 0;
    }

    @Specialization(guards={"cannotBeOverriddenForImmutableType(object)"})
    static boolean doDict(Node inliningTarget, PDict object, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageLen lenNode) {
        return lenNode.execute(inliningTarget, object.getDictStorage()) != 0;
    }

    @Specialization(guards={"cannotBeOverridden(object, inliningTarget, getClassNode)"}, limit="1")
    @HostCompilerDirectives.InliningCutoff
    static boolean doSet(Node inliningTarget, PSet object, @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageLen lenNode) {
        return lenNode.execute(inliningTarget, object.getDictStorage()) != 0;
    }

    @HostCompilerDirectives.InliningCutoff
    @Fallback
    static boolean doOthers(Frame frame, Object object, @Cached(inline=false) PyObjectIsTrueNodeGeneric internalNode) {
        return internalNode.execute(frame, object);
    }

    private static boolean checkBoolResult(Node inliningTarget, CastToJavaBooleanNode cast, PRaiseNode raiseNode, Object result) {
        try {
            return cast.execute(inliningTarget, result);
        }
        catch (CannotCastException e) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.BOOL_SHOULD_RETURN_BOOL, result);
        }
    }

    @NeverDefault
    public static PyObjectIsTrueNode create() {
        return PyObjectIsTrueNodeGen.create();
    }

    public static PyObjectIsTrueNode getUncached() {
        return PyObjectIsTrueNodeGen.getUncached();
    }

    @GenerateInline(value=false)
    @GenerateUncached
    public static abstract class PyObjectIsTrueNodeGeneric
    extends PNodeWithContext {
        public abstract boolean execute(Frame var1, Object var2);

        protected abstract Object executeObject(Frame var1, Object var2);

        @Specialization(guards={"!isBoolean(object)", "!isPNone(object)", "!isInteger(object)", "!isDouble(object)"}, rewriteOn={UnexpectedResultException.class})
        static boolean doObjectUnboxed(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getClassNode") @Cached GetClassNode getClassNode, @Cached.Shared(value="lookupBool") @Cached(parameters={"Bool"}) LookupSpecialMethodSlotNode lookupBool, @Cached.Shared(value="lookupLen") @Cached(parameters={"Len"}) LookupSpecialMethodSlotNode lookupLen, @Cached.Shared(value="callBool") @Cached CallUnaryMethodNode callBool, @Cached.Shared(value="callLen") @Cached CallUnaryMethodNode callLen, @Cached.Shared(value="cast") @Cached CastToJavaBooleanNode cast, @Cached.Shared(value="index") @Cached PyNumberIndexNode indexNode, @Cached.Shared(value="castLossy") @Cached CastToJavaIntLossyNode castLossy, @Cached.Shared(value="asSize") @Cached PyNumberAsSizeNode asSizeNode, @Cached.Shared(value="raise") @Cached PRaiseNode.Lazy raiseNode) throws UnexpectedResultException {
            Object type = getClassNode.execute(inliningTarget, object);
            Object boolDescr = lookupBool.execute((Frame)frame, type, object);
            if (boolDescr != PNone.NO_VALUE) {
                try {
                    return PGuards.expectBoolean(callBool.executeObject((Frame)frame, boolDescr, object));
                }
                catch (UnexpectedResultException e) {
                    throw new UnexpectedResultException((Object)PyObjectIsTrueNode.checkBoolResult(inliningTarget, cast, raiseNode.get(inliningTarget), e.getResult()));
                }
            }
            Object lenDescr = lookupLen.execute((Frame)frame, type, object);
            if (lenDescr != PNone.NO_VALUE) {
                try {
                    return PyObjectSizeNode.checkLen(raiseNode.get(inliningTarget), PGuards.expectInteger(callLen.executeObject((Frame)frame, lenDescr, object))) != 0;
                }
                catch (UnexpectedResultException e) {
                    int len = PyObjectSizeNode.convertAndCheckLen(frame, inliningTarget, e.getResult(), indexNode, castLossy, asSizeNode, raiseNode.get(inliningTarget));
                    throw new UnexpectedResultException((Object)(len != 0 ? 1 : 0));
                }
            }
            return true;
        }

        @Specialization(guards={"!isBoolean(object)", "!isPNone(object)", "!isInteger(object)", "!isDouble(object)"}, replaces={"doObjectUnboxed"})
        static boolean doObject(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getClassNode") @Cached GetClassNode getClassNode, @Cached.Shared(value="lookupBool") @Cached(parameters={"Bool"}) LookupSpecialMethodSlotNode lookupBool, @Cached.Shared(value="lookupLen") @Cached(parameters={"Len"}) LookupSpecialMethodSlotNode lookupLen, @Cached.Shared(value="callBool") @Cached CallUnaryMethodNode callBool, @Cached.Shared(value="callLen") @Cached CallUnaryMethodNode callLen, @Cached.Shared(value="cast") @Cached CastToJavaBooleanNode cast, @Cached.Shared(value="index") @Cached PyNumberIndexNode indexNode, @Cached.Shared(value="castLossy") @Cached CastToJavaIntLossyNode castLossy, @Cached.Shared(value="asSize") @Cached PyNumberAsSizeNode asSizeNode, @Cached.Shared(value="raise") @Cached PRaiseNode.Lazy raiseNode) {
            Object type = getClassNode.execute(inliningTarget, object);
            Object boolDescr = lookupBool.execute((Frame)frame, type, object);
            if (boolDescr != PNone.NO_VALUE) {
                Object result = callBool.executeObject((Frame)frame, boolDescr, object);
                return PyObjectIsTrueNode.checkBoolResult(inliningTarget, cast, raiseNode.get(inliningTarget), result);
            }
            Object lenDescr = lookupLen.execute((Frame)frame, type, object);
            if (lenDescr != PNone.NO_VALUE) {
                Object result = callLen.executeObject((Frame)frame, lenDescr, object);
                int len = PyObjectSizeNode.convertAndCheckLen(frame, inliningTarget, result, indexNode, castLossy, asSizeNode, raiseNode.get(inliningTarget));
                return len != 0;
            }
            return true;
        }
    }
}

