/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.argument.keywords;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.common.EmptyStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.KeywordsStorage;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.argument.keywords.ConcatDictToStorageNode;
import com.oracle.graal.python.nodes.argument.keywords.NonMappingException;
import com.oracle.graal.python.nodes.argument.keywords.SameDictKeyException;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedIntValueProfile;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class MappingToKeywordsNode
extends PNodeWithContext {
    public abstract PKeyword[] execute(VirtualFrame var1, Node var2, Object var3) throws SameDictKeyException, NonMappingException;

    @Specialization(guards={"hasBuiltinDictIter(inliningTarget, starargs, getClassNode, lookupIter)"}, limit="1")
    static PKeyword[] doDict(VirtualFrame frame, Node inliningTarget, PDict starargs, @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached(parameters={"Iter"}, inline=false) LookupCallableSlotInMRONode lookupIter, @Cached.Exclusive @Cached HashingStorageToKeywords convert) {
        return convert.execute(frame, inliningTarget, starargs.getDictStorage());
    }

    @Fallback
    static PKeyword[] doMapping(VirtualFrame frame, Node inliningTarget, Object starargs, @Cached(inline=false) ConcatDictToStorageNode concatDictToStorageNode, @Cached.Exclusive @Cached HashingStorageToKeywords convert) throws SameDictKeyException, NonMappingException {
        HashingStorage storage = concatDictToStorageNode.execute(frame, EmptyStorage.INSTANCE, starargs);
        return convert.execute(frame, inliningTarget, storage);
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class HashingStorageToKeywords
    extends PNodeWithContext {
        HashingStorageToKeywords() {
        }

        public abstract PKeyword[] execute(VirtualFrame var1, Node var2, HashingStorage var3);

        @Specialization
        static PKeyword[] doKeywordsStorage(KeywordsStorage storage) {
            return storage.getStore();
        }

        @Specialization
        static PKeyword[] doEmptyStorage(EmptyStorage storage) {
            return PKeyword.EMPTY_KEYWORDS;
        }

        @Specialization(guards={"!isKeywordsStorage(storage)", "!isEmptyStorage(storage)"})
        static PKeyword[] doCached(VirtualFrame frame, Node inliningTarget, HashingStorage storage, @Cached(parameters={"Iter"}, inline=false) LookupCallableSlotInMRONode lookupIter, @Cached(inline=false) AddKeywordNode addKeywordNode, @Cached HashingStorageNodes.HashingStorageForEach forEachNode, @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached InlinedIntValueProfile lenProfile) {
            int profiledLen = lenProfile.profile(inliningTarget, HashingStorageToKeywords.len(inliningTarget, lenNode, storage));
            PKeyword[] keywords = PKeyword.create(profiledLen);
            forEachNode.execute((Frame)frame, inliningTarget, storage, addKeywordNode, new CopyKeywordsState(keywords));
            return keywords;
        }

        static boolean isKeywordsStorage(HashingStorage storage) {
            return storage instanceof KeywordsStorage;
        }

        static boolean isEmptyStorage(HashingStorage storage) {
            return storage instanceof EmptyStorage;
        }

        static int len(Node inliningTarget, HashingStorageNodes.HashingStorageLen lenNode, HashingStorage storage) {
            return lenNode.execute(inliningTarget, storage);
        }
    }

    @CompilerDirectives.ValueType
    protected static final class CopyKeywordsState {
        private final PKeyword[] keywords;
        private int i = 0;

        public CopyKeywordsState(PKeyword[] keywords) {
            this.keywords = keywords;
        }

        void addKeyword(TruffleString key, Object value) {
            assert (this.i < this.keywords.length) : "AddKeywordNode: current index (over hashingStorage) exceeds keywords array length!";
            this.keywords[this.i++] = new PKeyword(key, value);
        }
    }

    @GenerateUncached
    @ImportStatic(value={PythonOptions.class})
    @GenerateInline(value=false)
    static abstract class AddKeywordNode
    extends HashingStorageNodes.HashingStorageForEachCallback<CopyKeywordsState> {
        AddKeywordNode() {
        }

        @Override
        public abstract CopyKeywordsState execute(Frame var1, Node var2, HashingStorage var3, HashingStorageNodes.HashingStorageIterator var4, CopyKeywordsState var5);

        @Specialization
        public CopyKeywordsState add(Node Node2, HashingStorage storage, HashingStorageNodes.HashingStorageIterator it, CopyKeywordsState state, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode raiseNode, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached HashingStorageNodes.HashingStorageIteratorKey itKey, @Cached HashingStorageNodes.HashingStorageIteratorKeyHash itKeyHash, @Cached HashingStorageNodes.HashingStorageGetItemWithHash getItem) {
            Object key = itKey.execute(inliningTarget, storage, it);
            long hash = itKeyHash.execute(inliningTarget, storage, it);
            Object value = getItem.execute(null, inliningTarget, storage, key, hash);
            try {
                state.addKeyword(castToTruffleStringNode.execute(inliningTarget, key), value);
            }
            catch (CannotCastException e) {
                throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.KEYWORDS_S_MUST_BE_STRINGS);
            }
            return state;
        }
    }
}

