/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode.instrumentation;

import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.nodes.bytecode.instrumentation.InstrumentationRoot;
import com.oracle.graal.python.nodes.bytecode.instrumentation.InstrumentationSupport;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Set;

class InstrumentationRootImpl
extends InstrumentationRoot {
    @Node.Child
    private volatile InstrumentationSupport instrumentationSupport;

    InstrumentationRootImpl() {
    }

    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(StandardTags.StatementTag.class) && this.instrumentationSupport == null) {
            Node node = this.getParent();
            while (!(node instanceof PBytecodeRootNode)) {
                node = node.getParent();
            }
            PBytecodeRootNode rootNode = (PBytecodeRootNode)node;
            if (rootNode.getSource() != null && rootNode.getSource().hasCharacters()) {
                this.instrumentationSupport = (InstrumentationSupport)this.insert(new InstrumentationSupport(rootNode));
                rootNode.materializeContainedFunctionsForInstrumentation(materializedTags);
                this.notifyInserted(this.instrumentationSupport);
            }
        }
        return this;
    }

    @Override
    public InstrumentationSupport getInstrumentation() {
        return this.instrumentationSupport;
    }

    @Override
    public SourceSection getSourceSection() {
        return this.getRootNode().getSourceSection();
    }
}

