/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode.instrumentation;

import com.oracle.graal.python.nodes.bytecode.instrumentation.InstrumentedBytecodeStatement;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;

@GeneratedBy(value=InstrumentedBytecodeStatement.class)
final class InstrumentedBytecodeStatementWrapper
extends InstrumentedBytecodeStatement
implements InstrumentableNode.WrapperNode {
    @Node.Child
    private InstrumentedBytecodeStatement delegateNode;
    @Node.Child
    private ProbeNode probeNode;

    InstrumentedBytecodeStatementWrapper(InstrumentedBytecodeStatement delegateNode, ProbeNode probeNode) {
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    public InstrumentedBytecodeStatement getDelegateNode() {
        return this.delegateNode;
    }

    public ProbeNode getProbeNode() {
        return this.probeNode;
    }

    public NodeCost getCost() {
        return NodeCost.NONE;
    }

    @Override
    public void execute(VirtualFrame frame) {
        while (true) {
            boolean wasOnReturnExecuted = false;
            try {
                this.probeNode.onEnter(frame);
                this.delegateNode.execute(frame);
                wasOnReturnExecuted = true;
                this.probeNode.onReturnValue(frame, null);
            }
            catch (Throwable t) {
                Object result;
                if ((result = this.probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted)) == ProbeNode.UNWIND_ACTION_REENTER) continue;
                if (result != null) break;
                throw t;
            }
            break;
        }
    }

    @Override
    public void insertHelperNode(Node node, int bci) {
        this.delegateNode.insertHelperNode(node, bci);
    }

    @Override
    void setContainsBreakpoint() {
        this.delegateNode.setContainsBreakpoint();
    }

    @Override
    void coversBci(int bci, int length) {
        this.delegateNode.coversBci(bci, length);
    }
}

