/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.interop;

import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.nodes.interop.InteropBehaviorMethod;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;

public class InteropBehavior {
    private final PythonAbstractObject receiver;
    private final InteropBehaviorMethodRecord[] records = new InteropBehaviorMethodRecord[InteropBehaviorMethod.getLength()];

    public InteropBehavior(PythonAbstractObject receiver) {
        this.receiver = receiver;
    }

    public void defineBehavior(InteropBehaviorMethod method, PFunction function) {
        this.records[method.ordinal()] = new InteropBehaviorMethodRecord((CallTarget)function.getCode().getRootCallTarget(), function.getGlobals(), false);
    }

    public void defineBehavior(InteropBehaviorMethod method, boolean constant) {
        this.records[method.ordinal()] = new InteropBehaviorMethodRecord(null, null, constant);
    }

    public boolean isDefined(InteropBehaviorMethod method) {
        return this.records[method.ordinal()] != null;
    }

    public CallTarget getCallTarget(InteropBehaviorMethod method) {
        assert (this.isDefined(method)) : "interop behavior method not defined";
        return this.records[method.ordinal()].callTarget;
    }

    public PythonObject getGlobals(InteropBehaviorMethod method) {
        assert (this.isDefined(method)) : "interop behavior method not defined";
        return this.records[method.ordinal()].globals;
    }

    public boolean isConstant(InteropBehaviorMethod method) {
        assert (this.isDefined(method)) : "interop behavior method not defined";
        return this.records[method.ordinal()].callTarget == null;
    }

    public boolean getConstantValue(InteropBehaviorMethod method) {
        assert (this.isConstant(method)) : "interop behavior method not constant";
        return this.records[method.ordinal()].constant;
    }

    public Object[] createArguments(InteropBehaviorMethod method, PythonAbstractObject receiver, Object[] extraArguments) {
        assert (method.checkArity(extraArguments));
        Object[] pArguments = PArguments.create(1 + (method.takesVarArgs ? 0 : method.extraArguments));
        PArguments.setGlobals(pArguments, this.getGlobals(method));
        PArguments.setArgument(pArguments, 0, receiver);
        if (method.takesVarArgs) {
            PArguments.setVariableArguments(pArguments, extraArguments);
        } else {
            for (int i = 0; i < extraArguments.length; ++i) {
                PArguments.setArgument(pArguments, i + 1, extraArguments[i]);
            }
        }
        return pArguments;
    }

    public PythonAbstractObject getReceiver() {
        return this.receiver;
    }

    @CompilerDirectives.TruffleBoundary
    public Object[] getDefinedMethods() {
        ArrayList<TruffleString> defined = new ArrayList<TruffleString>();
        for (int i = 0; i < this.records.length; ++i) {
            InteropBehaviorMethod method = InteropBehaviorMethod.VALUES[i];
            if (!this.isDefined(method)) continue;
            defined.add(method.tsName);
        }
        return defined.toArray();
    }

    @CompilerDirectives.ValueType
    private record InteropBehaviorMethodRecord(CallTarget callTarget, PythonObject globals, boolean constant) {
    }
}

