/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
@TypeSystemReference(value=PythonArithmeticTypes.class)
@ImportStatic(value={MathGuards.class})
public abstract class CastToJavaDoubleNode
extends PNodeWithContext {
    public abstract double execute(Node var1, Object var2);

    @Specialization
    static double toDouble(double x) {
        return x;
    }

    @Specialization
    static double doBoolean(boolean x) {
        return x ? 1.0 : 0.0;
    }

    @Specialization
    static double doInt(int x) {
        return x;
    }

    @Specialization
    static double doLong(long x) {
        return x;
    }

    @Specialization
    double doPInt(PInt x) {
        return x.doubleValueWithOverflow(this);
    }

    @Specialization
    static double doString(TruffleString object) {
        throw CannotCastException.INSTANCE;
    }

    @Specialization
    static double doPBCT(PythonBuiltinClassType object) {
        throw CannotCastException.INSTANCE;
    }

    @Specialization
    static double doNativeObject(Node inliningTarget, PythonAbstractNativeObject x, @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached(inline=false) IsSubtypeNode isSubtypeNode, @Cached(inline=false) CStructAccess.ReadDoubleNode read) {
        if (isSubtypeNode.execute(getClassNode.execute(inliningTarget, x), (Object)PythonBuiltinClassType.PFloat)) {
            return read.readFromObj(x, CFields.PyFloatObject__ob_fval);
        }
        throw CannotCastException.INSTANCE;
    }

    public static Double doInterop(Object obj, InteropLibrary interopLibrary) {
        try {
            if (interopLibrary.fitsInDouble(obj)) {
                return interopLibrary.asDouble(obj);
            }
            if (interopLibrary.fitsInLong(obj)) {
                return interopLibrary.asLong(obj);
            }
            if (interopLibrary.isBoolean(obj)) {
                return interopLibrary.asBoolean(obj) ? 1.0 : 0.0;
            }
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
        return null;
    }

    @Specialization(guards={"!isNumber(obj)"})
    static double doGeneric(Object obj, @CachedLibrary(limit="3") InteropLibrary interopLibrary) {
        Double d = CastToJavaDoubleNode.doInterop(obj, interopLibrary);
        if (d != null) {
            return d;
        }
        throw CannotCastException.INSTANCE;
    }
}

