/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.GenericInvokeNode;
import com.oracle.graal.python.nodes.frame.ReadCallerFrameNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.ExceptionUtils;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.Supplier;
import com.oracle.graal.python.util.SuppressFBWarnings;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.ThreadLocalAction;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.graalvm.nativeimage.ImageInfo;

public class AsyncHandler {
    private final ScheduledExecutorService executorService;
    private final ArrayList<AsyncRunnable> registeredActions;
    private final WeakReference<PythonContext> context;
    private final Queue<AsyncAction> rescheduled = new ConcurrentLinkedDeque<AsyncAction>();
    private static final int ASYNC_ACTION_DELAY = 25;
    private static final int GIL_RELEASE_DELAY = 50;
    private final RootCallTarget callTarget;

    AsyncHandler(PythonContext context) {
        this.context = new WeakReference<PythonContext>(context);
        this.callTarget = context.getLanguage().createCachedCallTarget(CallRootNode::new, (Object)CallRootNode.class);
        if (PythonOptions.AUTOMATIC_ASYNC_ACTIONS) {
            this.executorService = Executors.newScheduledThreadPool(6, runnable -> {
                Thread t = Executors.defaultThreadFactory().newThread(runnable);
                t.setDaemon(true);
                t.setName(String.format("python-actions-%s", t.getName()));
                return t;
            });
            this.registeredActions = null;
        } else {
            this.executorService = null;
            this.registeredActions = new ArrayList();
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"})
    void registerAction(Supplier<AsyncAction> actionSupplier) {
        CompilerAsserts.neverPartOfCompilation();
        if (ImageInfo.inImageBuildtimeCode() || ((PythonContext)this.context.get()).getOption(PythonOptions.NoAsyncActions).booleanValue()) {
            return;
        }
        if (PythonOptions.AUTOMATIC_ASYNC_ACTIONS) {
            this.executorService.scheduleWithFixedDelay(new AsyncRunnable(actionSupplier), 25L, 25L, TimeUnit.MILLISECONDS);
        } else {
            this.registeredActions.add(new AsyncRunnable(actionSupplier));
        }
    }

    void poll() {
        if (!PythonOptions.AUTOMATIC_ASYNC_ACTIONS) {
            for (AsyncRunnable r : this.registeredActions) {
                r.run();
            }
        }
    }

    void activateGIL() {
        CompilerAsserts.neverPartOfCompilation();
        PythonContext ctx = (PythonContext)this.context.get();
        if (ctx == null) {
            return;
        }
        GilReleaseScheduler gilReleaseRunnable = new GilReleaseScheduler(ctx);
        if (PythonOptions.AUTOMATIC_ASYNC_ACTIONS) {
            this.executorService.scheduleWithFixedDelay(gilReleaseRunnable, 50L, 50L, TimeUnit.MILLISECONDS);
        } else {
            this.registeredActions.add(new AsyncRunnable(() -> {
                gilReleaseRunnable.run();
                return null;
            }));
        }
    }

    public void shutdown() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    private static class CallRootNode
    extends PRootNode {
        static final int ASYNC_CALLABLE_INDEX = 0;
        static final int ASYNC_FRAME_INDEX_INDEX = 1;
        static final int ASYNC_ARG_COUNT = 2;
        @Node.Child
        private CallNode callNode = CallNode.create();
        @Node.Child
        private ReadCallerFrameNode readCallerFrameNode = ReadCallerFrameNode.create();
        @Node.Child
        private ExecutionContext.CalleeContext calleeContext = ExecutionContext.CalleeContext.create();

        protected CallRootNode(TruffleLanguage<?> language) {
            super(language);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute(VirtualFrame frame) {
            this.calleeContext.enter(frame);
            Object[] frameArguments = frame.getArguments();
            Object callable = PArguments.getArgument(frameArguments, 0);
            int frameIndex = (Integer)PArguments.getArgument(frameArguments, 1);
            Object[] arguments = Arrays.copyOfRange(frameArguments, 11, frameArguments.length);
            if (frameIndex >= 0) {
                arguments[frameIndex] = this.readCallerFrameNode.executeWith(frame, 0);
            }
            try {
                Object object = this.callNode.execute((Frame)frame, callable, arguments);
                return object;
            }
            finally {
                this.calleeContext.exit(frame, this);
            }
        }

        @Override
        public Signature getSignature() {
            return Signature.EMPTY;
        }

        @Override
        public boolean isPythonInternal() {
            return true;
        }

        public boolean isInternal() {
            return true;
        }

        @Override
        public boolean setsUpCalleeContext() {
            return true;
        }
    }

    private class AsyncRunnable
    implements Runnable {
        private final Supplier<AsyncAction> actionSupplier;

        public AsyncRunnable(Supplier<AsyncAction> actionSupplier) {
            this.actionSupplier = actionSupplier;
        }

        @Override
        public void run() {
            Thread mainThread;
            PythonContext ctx;
            final AsyncAction asyncAction = (AsyncAction)this.actionSupplier.get();
            if (asyncAction != null && (ctx = (PythonContext)AsyncHandler.this.context.get()) != null && (mainThread = ctx.getMainThread()) != null) {
                ctx.getEnv().submitThreadLocal(new Thread[]{mainThread}, new ThreadLocalAction(this, true, false){
                    final /* synthetic */ AsyncRunnable this$1;
                    {
                        this.this$1 = this$1;
                        super(hasSideEffects, synchronous);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void perform(ThreadLocalAction.Access access) {
                        AsyncAction action = asyncAction;
                        do {
                            block8: {
                                if (ctx.tryEnterAsyncHandler()) {
                                    try {
                                        GilNode gil = GilNode.getUncached();
                                        boolean mustRelease = gil.acquire();
                                        try {
                                            action.execute(ctx);
                                            break block8;
                                        }
                                        finally {
                                            gil.release(mustRelease);
                                        }
                                    }
                                    finally {
                                        ctx.leaveAsyncHandler();
                                    }
                                }
                                this.this$1.AsyncHandler.this.rescheduled.add(action);
                                return;
                            }
                            action = this.this$1.AsyncHandler.this.rescheduled.poll();
                        } while (action != null);
                    }
                });
            }
        }
    }

    private static class GilReleaseScheduler
    implements Runnable {
        private final PythonContext ctx;
        private volatile boolean gilReleaseRequested;
        private Thread lastGilOwner;

        private GilReleaseScheduler(PythonContext ctx) {
            this.ctx = ctx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!this.ctx.gilHasQueuedThreads()) {
                return;
            }
            Thread gilOwner = this.ctx.getGilOwner();
            if (gilOwner != null) {
                GilReleaseScheduler gilReleaseScheduler = this;
                synchronized (gilReleaseScheduler) {
                    if (!this.gilReleaseRequested) {
                        this.gilReleaseRequested = true;
                        this.ctx.getEnv().submitThreadLocal(new Thread[]{gilOwner}, new ThreadLocalAction(false, false){

                            protected void perform(ThreadLocalAction.Access access) {
                                gilReleaseRequested = false;
                                RootNode rootNode = access.getLocation().getRootNode();
                                if (rootNode instanceof PRootNode) {
                                    if (rootNode.isInternal()) {
                                        return;
                                    }
                                    if (((PRootNode)rootNode).isPythonInternal()) {
                                        return;
                                    }
                                    GilNode gil = GilNode.getUncached();
                                    if (gil.tryRelease()) {
                                        gil.acquire(access.getLocation());
                                    }
                                }
                            }
                        });
                    } else if (gilOwner != this.lastGilOwner) {
                        this.gilReleaseRequested = false;
                    }
                    this.lastGilOwner = gilOwner;
                }
            }
        }
    }

    public static class SharedFinalizer {
        private static final TruffleLogger LOGGER = PythonLanguage.getLogger(SharedFinalizer.class);
        private final PythonContext pythonContext;
        private final ReferenceQueue<Object> queue = new ReferenceQueue();
        private final ConcurrentMap<FinalizableReference, FinalizableReference> liveReferencesSet = new ConcurrentHashMap<FinalizableReference, FinalizableReference>();

        public SharedFinalizer(PythonContext context) {
            this.pythonContext = context;
        }

        public void registerAsyncAction() {
            this.pythonContext.registerAsyncAction(() -> {
                Reference<Object> reference = null;
                if (PythonOptions.AUTOMATIC_ASYNC_ACTIONS) {
                    try {
                        reference = this.queue.remove();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } else {
                    reference = this.queue.poll();
                }
                ArrayList<AsyncAction> actions = new ArrayList<AsyncAction>();
                do {
                    if (!(reference instanceof FinalizableReference)) continue;
                    FinalizableReference object = (FinalizableReference)reference;
                    try {
                        AsyncAction action;
                        this.liveReferencesSet.remove(object);
                        if (object.isReleased() || (action = object.release()) == null) continue;
                        actions.add(action);
                    }
                    catch (Exception e) {
                        actions.add(new SharedFinalizerErrorCallback(object, e));
                    }
                } while ((reference = this.queue.poll()) != null);
                if (!actions.isEmpty()) {
                    return new AsyncActionsList(actions.toArray(new AsyncAction[0]));
                }
                return null;
            });
        }

        public static abstract class FinalizableReference
        extends PhantomReference<Object> {
            private final Object reference;
            private boolean released;

            public FinalizableReference(Object referent, Object reference, SharedFinalizer sharedFinalizer) {
                super(referent, sharedFinalizer.queue);
                assert (reference != null);
                this.reference = reference;
                FinalizableReference.addLiveReference(sharedFinalizer, this);
            }

            @CompilerDirectives.TruffleBoundary
            private static void addLiveReference(SharedFinalizer sharedFinalizer, FinalizableReference ref) {
                sharedFinalizer.liveReferencesSet.put(ref, ref);
            }

            public final Object getReference() {
                return this.reference;
            }

            public final boolean isReleased() {
                return this.released;
            }

            public final void markReleased() {
                this.released = true;
            }

            public abstract AsyncAction release();
        }

        static class SharedFinalizerErrorCallback
        implements AsyncAction {
            private final Exception exception;
            private final FinalizableReference referece;

            SharedFinalizerErrorCallback(FinalizableReference referece, Exception e) {
                this.exception = e;
                this.referece = referece;
            }

            @Override
            public void execute(PythonContext context) {
                LOGGER.severe(String.format("Error during async action for %s caused by %s", this.referece.getClass().getSimpleName(), this.exception.getMessage()));
            }
        }

        private static final class AsyncActionsList
        implements AsyncAction {
            private final AsyncAction[] array;

            public AsyncActionsList(AsyncAction[] array) {
                this.array = array;
            }

            @Override
            public void execute(PythonContext context) {
                for (AsyncAction action : this.array) {
                    try {
                        action.execute(context);
                    }
                    catch (RuntimeException e) {
                        ExceptionUtils.printPythonLikeStackTrace(e);
                    }
                }
            }
        }
    }

    public static abstract class AsyncPythonAction
    implements AsyncAction {
        protected abstract Object callable();

        protected abstract Object[] arguments();

        protected int frameIndex() {
            return -1;
        }

        protected boolean proceed() {
            return false;
        }

        protected void handleException(PException e) {
            throw e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void execute(PythonContext context) {
            Debugger debugger = null;
            PythonContext.PythonThreadState threadState = null;
            PythonLanguage language = context.getLanguage();
            do {
                boolean alreadyProfiling;
                boolean alreadyTracing;
                Object callable;
                if ((callable = this.callable()) == null) continue;
                Object[] arguments = this.arguments();
                Object[] args = PArguments.create(arguments.length + 2);
                PythonUtils.arraycopy(arguments, 0, args, 11, arguments.length);
                PArguments.setArgument(args, 0, callable);
                PArguments.setArgument(args, 1, this.frameIndex());
                PArguments.setException(args, PException.NO_EXCEPTION);
                if (debugger == null) {
                    debugger = Debugger.find((TruffleLanguage.Env)context.getEnv());
                }
                if (threadState == null) {
                    threadState = context.getThreadState(language);
                }
                if (!(alreadyTracing = threadState.isTracing())) {
                    threadState.tracingStart(PythonContext.TraceEvent.DISABLED);
                }
                if (!(alreadyProfiling = threadState.isProfiling())) {
                    threadState.profilingStart();
                }
                debugger.disableStepping();
                try {
                    GenericInvokeNode.getUncached().execute(context.getAsyncHandler().callTarget, args);
                }
                catch (PException e) {
                    this.handleException(e);
                }
                finally {
                    debugger.restoreStepping();
                    if (!alreadyTracing) {
                        threadState.tracingStop();
                    }
                    if (!alreadyProfiling) {
                        threadState.profilingStop();
                    }
                }
            } while (this.proceed());
        }
    }

    public static interface AsyncAction {
        public void execute(PythonContext var1);
    }
}

