/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.objects.exception.OSErrorEnum;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.object.IsNode;
import com.oracle.graal.python.runtime.PosixConstants;
import com.oracle.graal.python.runtime.PosixResources;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.ProcessWrapper;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PythonExitException;
import com.oracle.graal.python.util.FileDeleteShutdownHook;
import com.oracle.graal.python.util.IPAddressUtil;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.io.TruffleProcessBuilder;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.sun.security.auth.UnixNumericGroupPrincipal;
import com.sun.security.auth.module.UnixSystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NetworkChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ProcessProperties;
import org.graalvm.polyglot.io.ProcessHandler;

@ExportLibrary(value=PosixSupportLibrary.class)
public final class EmulatedPosixSupport
extends PosixResources {
    private static final int MAX_READ = 0x3FFFFFFF;
    private static final PosixFilePermission[][] otherBitsToPermission = new PosixFilePermission[][]{new PosixFilePermission[0], {PosixFilePermission.OTHERS_EXECUTE}, {PosixFilePermission.OTHERS_WRITE}, {PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_EXECUTE}, {PosixFilePermission.OTHERS_READ}, {PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_EXECUTE}, {PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE}, {PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_EXECUTE}};
    private static final PosixFilePermission[][] groupBitsToPermission = new PosixFilePermission[][]{new PosixFilePermission[0], {PosixFilePermission.GROUP_EXECUTE}, {PosixFilePermission.GROUP_WRITE}, {PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_EXECUTE}, {PosixFilePermission.GROUP_READ}, {PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE}, {PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE}, {PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_EXECUTE}};
    private static final PosixFilePermission[][] ownerBitsToPermission = new PosixFilePermission[][]{new PosixFilePermission[0], {PosixFilePermission.OWNER_EXECUTE}, {PosixFilePermission.OWNER_WRITE}, {PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE}, {PosixFilePermission.OWNER_READ}, {PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_EXECUTE}, {PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE}, {PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE}};
    private static final TruffleString T_BIN_SH = PythonUtils.tsLiteral("/bin/sh");
    private static final TruffleString T_DEV_TTY = PythonUtils.tsLiteral("/dev/tty");
    private final ConcurrentHashMap<String, String> environ = new ConcurrentHashMap();
    private int currentUmask = 18;
    private boolean hasDefaultUmask = true;
    private final boolean withoutIOSocket;
    private Map<String, List<Service>> etcServices;
    private static final TruffleString T_FILESYSTEM_DOES_NOT_SUPPORT_CHANGING_CUR_DIR = PythonUtils.tsLiteral("The filesystem does not support changing of the current working directory");
    private static final TruffleString[] KILL_SIGNALS = PythonUtils.tsArray("SIGKILL", "SIGQUIT", "SIGTRAP", "SIGABRT");
    private static final TruffleString[] TERMINATION_SIGNALS = PythonUtils.tsArray("SIGTERM", "SIGINT");
    private static final TruffleLogger LOGGER = PythonLanguage.getLogger(EmulatedPosixSupport.class);
    private static final TruffleLogger COMPATIBILITY_LOGGER = PythonLanguage.getCompatibilityLogger(EmulatedPosixSupport.class);

    public EmulatedPosixSupport(PythonContext context) {
        super(context);
        this.setEnv(context.getEnv());
        this.withoutIOSocket = !context.getContext().getEnv().isSocketIOAllowed();
    }

    @Override
    public void setEnv(TruffleLanguage.Env env) {
        super.setEnv(env);
        if (!ImageInfo.inImageBuildtimeCode()) {
            this.environ.putAll(System.getenv());
        }
    }

    @ExportMessage
    public TruffleString getBackend() {
        return StringLiterals.T_JAVA;
    }

    @ExportMessage
    public int umask(int umask) {
        int prev = this.currentUmask;
        this.currentUmask = umask & 0x1FF;
        if (this.hasDefaultUmask) {
            EmulatedPosixSupport.compatibilityInfo("Returning default umask '%o' (ignoring the real umask value set in the OS)", prev);
        }
        this.hasDefaultUmask = false;
        return umask;
    }

    @ExportMessage
    public TruffleString strerror(int errorCode, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch) {
        OSErrorEnum err = OSErrorEnum.fromNumber(errorCode);
        if (err == null) {
            errorBranch.enter(inliningTarget);
            err = OSErrorEnum.EINVAL;
        }
        return err.getMessage();
    }

    @ExportMessage(name="close")
    public int closeMessage(int fd) throws PosixSupportLibrary.PosixException {
        try {
            if (!this.removeFD(fd)) {
                throw EmulatedPosixSupport.posixException(OSErrorEnum.EBADF);
            }
            return 0;
        }
        catch (IOException ignored) {
            return -1;
        }
    }

    @ExportMessage
    public int openat(int dirFd, Object path, int flags, int mode, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch, @Cached.Shared(value="defaultDirProfile") @Cached InlinedConditionProfile defaultDirFdPofile, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode) throws PosixSupportLibrary.PosixException {
        TruffleString pathname = EmulatedPosixSupport.pathToTruffleString(path, fromJavaStringNode);
        TruffleFile file = this.resolvePath(inliningTarget, dirFd, pathname, defaultDirFdPofile, eqNode, toJavaStringNode);
        Set<StandardOpenOption> options = EmulatedPosixSupport.flagsToOptions(flags);
        FileAttribute<Set<PosixFilePermission>> attributes = EmulatedPosixSupport.modeToAttributes(mode & ~this.currentUmask);
        try {
            return this.openTruffleFile(file, options, attributes);
        }
        catch (Exception e) {
            errorBranch.enter(inliningTarget);
            OSErrorEnum.ErrorAndMessagePair errAndMsg = OSErrorEnum.fromException(e, eqNode);
            throw EmulatedPosixSupport.posixException(errAndMsg);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private int openTruffleFile(TruffleFile truffleFile, Set<StandardOpenOption> options, FileAttribute<Set<PosixFilePermission>> attributes) throws IOException {
        TruffleFile file;
        if (options.contains(StandardOpenOption.DELETE_ON_CLOSE)) {
            file = this.context.getEnv().createTempFile(truffleFile, null, null, new FileAttribute[0]);
            options.remove(StandardOpenOption.CREATE_NEW);
            options.remove(StandardOpenOption.DELETE_ON_CLOSE);
            options.add(StandardOpenOption.CREATE);
            this.context.registerAtexitHook(new FileDeleteShutdownHook(file));
        } else {
            file = truffleFile;
        }
        SeekableByteChannel fc = PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? file.newByteChannel(options, new FileAttribute[0]) : file.newByteChannel(options, new FileAttribute[]{attributes});
        return this.open(file, fc);
    }

    @ExportMessage
    public long write(int fd, PosixSupportLibrary.Buffer data, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
        Channel channel = this.getFileChannel(fd);
        if (!(channel instanceof WritableByteChannel)) {
            errorBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EBADF);
        }
        try {
            return EmulatedPosixSupport.doWriteOp(data.getByteBuffer(), (WritableByteChannel)channel);
        }
        catch (Exception e) {
            errorBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(e, eqNode));
        }
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static int doWriteOp(ByteBuffer data, WritableByteChannel channel) throws IOException {
        return channel.write(data);
    }

    @ExportMessage
    public PosixSupportLibrary.Buffer read(int fd, long length, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
        Channel channel = this.getFileChannel(fd);
        if (!(channel instanceof ReadableByteChannel)) {
            errorBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EBADF);
        }
        try {
            return EmulatedPosixSupport.readBytesFromChannel((ReadableByteChannel)channel, length);
        }
        catch (Exception e) {
            errorBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(e, eqNode));
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static PosixSupportLibrary.Buffer readBytesFromChannel(ReadableByteChannel channel, long size) throws IOException {
        ByteBuffer dst;
        int readSize;
        if (channel instanceof SeekableByteChannel) {
            SeekableByteChannel seekableByteChannel = (SeekableByteChannel)channel;
            long availableSize = seekableByteChannel.size() - seekableByteChannel.position();
            size = Math.min(size, availableSize);
        }
        if ((readSize = channel.read(dst = ByteBuffer.allocate((int)(size = Math.min(size, 0x3FFFFFFFL))))) <= 0) {
            return new PosixSupportLibrary.Buffer(PythonUtils.EMPTY_BYTE_ARRAY, 0L);
        }
        return new PosixSupportLibrary.Buffer(dst.array(), readSize);
    }

    @Override
    @ExportMessage
    public int dup(int fd) {
        return super.dup(fd);
    }

    @ExportMessage
    public int dup2(int fd, int fd2, boolean inheritable, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
        try {
            return super.dup2(fd, fd2);
        }
        catch (IOException ex) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(ex, eqNode));
        }
    }

    @ExportMessage
    public boolean getInheritable(int fd) {
        EmulatedPosixSupport.compatibilityIgnored("getting inheritable for file descriptor %d in POSIX emulation layer (not supported, always returns false)", fd);
        return false;
    }

    @ExportMessage
    public void setInheritable(int fd, boolean inheritable) {
        EmulatedPosixSupport.compatibilityIgnored("setting inheritable '%b' for file descriptor %d in POSIX emulation layer (not supported)", inheritable, fd);
    }

    @ExportMessage(name="pipe")
    public int[] pipeMessage(@Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
        try {
            return super.pipe();
        }
        catch (IOException ex) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(ex, eqNode));
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public PosixSupportLibrary.SelectResult select(int[] readfds, int[] writefds, int[] errorfds, PosixSupportLibrary.Timeval timeout) throws PosixSupportLibrary.PosixException {
        if (PythonOptions.WITHOUT_JAVA_INET || this.withoutIOSocket) {
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException("select was excluded");
        }
        SelectableChannel[] readChannels = this.getSelectableChannels(readfds);
        SelectableChannel[] writeChannels = this.getSelectableChannels(writefds);
        block16: for (int fd : errorfds) {
            for (int fd2 : readfds) {
                if (fd == fd2) continue block16;
            }
            for (int fd2 : writefds) {
                if (fd == fd2) continue block16;
            }
            EmulatedPosixSupport.compatibilityIgnored("POSIX emulation layer doesn't support waiting on exceptional conditions in select()", new Object[0]);
            break;
        }
        boolean[] wasBlocking = new boolean[readChannels.length + writeChannels.length];
        int i = 0;
        for (SelectableChannel channel : readChannels) {
            wasBlocking[i++] = channel.isBlocking();
        }
        for (SelectableChannel channel : writeChannels) {
            wasBlocking[i++] = channel.isBlocking();
        }
        int readOps = 17;
        int writeOps = 4;
        try {
            PosixSupportLibrary.SelectResult selectResult;
            block31: {
                Selector selector = Selector.open();
                try {
                    long timeoutMs;
                    for (SelectableChannel channel : readChannels) {
                        channel.configureBlocking(false);
                        channel.register(selector, 0x11 & channel.validOps());
                    }
                    for (SelectableChannel channel : writeChannels) {
                        channel.configureBlocking(false);
                        channel.register(selector, 4);
                    }
                    boolean useSelectNow = false;
                    if (timeout == null) {
                        timeoutMs = 0L;
                    } else {
                        try {
                            timeoutMs = Math.addExact(Math.multiplyExact(timeout.getSeconds(), 1000L), timeout.getMicroseconds() / 1000L);
                        }
                        catch (ArithmeticException ex) {
                            throw EmulatedPosixSupport.posixException(OSErrorEnum.EINVAL);
                        }
                        if (timeoutMs == 0L) {
                            useSelectNow = true;
                        }
                    }
                    int selected = useSelectNow ? selector.selectNow() : selector.select(timeoutMs);
                    boolean[] resReadfds = EmulatedPosixSupport.createSelectedMap(readfds, readChannels, selector, 17);
                    boolean[] resWritefds = EmulatedPosixSupport.createSelectedMap(writefds, writeChannels, selector, 4);
                    boolean[] resErrfds = new boolean[errorfds.length];
                    assert (selected == EmulatedPosixSupport.countSelected(resReadfds) + EmulatedPosixSupport.countSelected(resWritefds) + EmulatedPosixSupport.countSelected(resErrfds));
                    selectResult = new PosixSupportLibrary.SelectResult(resReadfds, resWritefds, resErrfds);
                    if (selector == null) break block31;
                }
                catch (Throwable throwable) {
                    try {
                        if (selector != null) {
                            try {
                                selector.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(e, TruffleString.EqualNode.getUncached()));
                    }
                }
                selector.close();
            }
            return selectResult;
        }
        finally {
            i = 0;
            try {
                for (SelectableChannel channel : readChannels) {
                    if (!wasBlocking[i++]) continue;
                    channel.configureBlocking(true);
                }
                for (SelectableChannel channel : writeChannels) {
                    if (!wasBlocking[i++]) continue;
                    channel.configureBlocking(true);
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static boolean[] createSelectedMap(int[] fds, SelectableChannel[] channels, Selector selector, int op) {
        boolean[] result = new boolean[fds.length];
        for (int i = 0; i < channels.length; ++i) {
            SelectableChannel channel = channels[i];
            SelectionKey selectionKey = channel.keyFor(selector);
            result[i] = (selectionKey.readyOps() & op) != 0;
        }
        return result;
    }

    private static int countSelected(boolean[] selected) {
        int res = 0;
        for (boolean b : selected) {
            if (!b) continue;
            ++res;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SelectableChannel[] getSelectableChannels(int[] fds) throws PosixSupportLibrary.PosixException {
        SelectableChannel[] channels = new SelectableChannel[fds.length];
        for (int i = 0; i < fds.length; ++i) {
            Channel ch = this.getFileChannel(fds[i]);
            if (ch == null) {
                throw EmulatedPosixSupport.posixException(OSErrorEnum.EBADF);
            }
            if (ch instanceof SelectableChannel) {
                channels[i] = (SelectableChannel)ch;
                continue;
            }
            if (ch instanceof EmulatedDatagramSocket) {
                channels[i] = ((EmulatedDatagramSocket)ch).channel;
                continue;
            }
            if (ch instanceof EmulatedStreamSocket) {
                EmulatedStreamSocket streamSocket;
                EmulatedStreamSocket emulatedStreamSocket = streamSocket = (EmulatedStreamSocket)ch;
                synchronized (emulatedStreamSocket) {
                    if (streamSocket.clientChannel != null) {
                        channels[i] = streamSocket.clientChannel;
                    } else if (streamSocket.serverChannel != null) {
                        channels[i] = streamSocket.serverChannel;
                    } else {
                        throw PosixSupportLibrary.ChannelNotSelectableException.INSTANCE;
                    }
                    continue;
                }
            }
            throw PosixSupportLibrary.ChannelNotSelectableException.INSTANCE;
        }
        return channels;
    }

    @ExportMessage
    public long lseek(int fd, long offset, int how, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached InlinedBranchProfile errorBranch, @Cached.Exclusive @Cached InlinedConditionProfile notSupported, @Cached.Exclusive @Cached InlinedConditionProfile noFile, @Cached.Exclusive @Cached InlinedConditionProfile notSeekable, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
        long newPos;
        Channel channel = this.getFileChannel(fd);
        if (noFile.profile(inliningTarget, channel == null)) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EBADF);
        }
        if (notSeekable.profile(inliningTarget, !(channel instanceof SeekableByteChannel))) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.ESPIPE);
        }
        SeekableByteChannel fc = (SeekableByteChannel)channel;
        try {
            newPos = EmulatedPosixSupport.setPosition(offset, how, fc);
        }
        catch (Exception e) {
            errorBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(e, eqNode));
        }
        if (notSupported.profile(inliningTarget, newPos < 0L)) {
            if (newPos == -2L) {
                throw new PosixSupportLibrary.UnsupportedPosixFeatureException("SEEK_HOLE and SEEK_DATA are not supported");
            }
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException("emulated lseek cannot seek beyond the file size. Please enable native posix support using the following option '--python.PosixModuleBackend=native'");
        }
        return newPos;
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static long setPosition(long pos, int how, SeekableByteChannel fc) throws IOException {
        long newPos;
        if (how == PosixConstants.SEEK_CUR.value) {
            newPos = pos + fc.position();
        } else if (how == PosixConstants.SEEK_END.value) {
            newPos = pos + fc.size();
        } else if (how == PosixConstants.SEEK_SET.value) {
            newPos = pos;
        } else {
            if (PosixConstants.SEEK_DATA.defined && how == PosixConstants.SEEK_DATA.getValueIfDefined() || PosixConstants.SEEK_HOLE.defined && how == PosixConstants.SEEK_HOLE.getValueIfDefined()) {
                return -2L;
            }
            throw new IllegalArgumentException();
        }
        fc.position(newPos);
        long p = fc.position();
        return p != newPos ? -1L : p;
    }

    @ExportMessage(name="ftruncate")
    public void ftruncateMessage(int fd, long length, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
        Object ret;
        try {
            ret = this.ftruncate(fd, length);
        }
        catch (Exception e) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(e, eqNode));
        }
        if (ret == null) {
            errorBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EBADF);
        }
    }

    @ExportMessage(name="fsync")
    public void fsyncMessage(int fd) throws PosixSupportLibrary.PosixException {
        if (!this.fsync(fd)) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.ENOENT);
        }
    }

    @ExportMessage
    void flock(int fd, int operation, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch) throws PosixSupportLibrary.PosixException {
        boolean blocking;
        Channel channel = this.getFileChannel(fd);
        if (channel == null) {
            errorBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EBADFD);
        }
        boolean unlock = operation == PosixConstants.LOCK_UN.value;
        boolean shared = (operation & PosixConstants.LOCK_SH.value) != 0;
        boolean exclusive = (operation & PosixConstants.LOCK_EX.value) != 0;
        boolean bl = blocking = (operation & PosixConstants.LOCK_NB.value) == 0;
        if (!(unlock || shared || exclusive)) {
            errorBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EINVAL);
        }
        this.doLockOperation(fd, channel, unlock, shared, blocking, 0, 0L, Long.MAX_VALUE);
    }

    @ExportMessage
    void fcntlLock(int fd, boolean blocking, int lockType, int whence, long start, long length, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch) throws PosixSupportLibrary.PosixException {
        boolean exclusive;
        Channel channel = this.getFileChannel(fd);
        if (channel == null) {
            errorBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EBADFD);
        }
        boolean unlock = lockType == PosixConstants.F_UNLCK.getValueIfDefined();
        boolean shared = lockType == PosixConstants.F_RDLCK.getValueIfDefined();
        boolean bl = exclusive = lockType == PosixConstants.F_WRLCK.getValueIfDefined();
        if (!(unlock || shared || exclusive)) {
            errorBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EINVAL);
        }
        this.doLockOperation(fd, channel, unlock, shared, blocking, whence, start, length);
    }

    @CompilerDirectives.TruffleBoundary
    private void doLockOperation(int fd, Channel channel, boolean unlock, boolean shared, boolean blocking, int whence, long start, long length) throws PosixSupportLibrary.PosixException {
        if (channel instanceof FileChannel) {
            FileChannel fc = (FileChannel)channel;
            FileLock lock = this.getFileLock(fd);
            try {
                long position = start;
                if (whence == PosixConstants.SEEK_CUR.value) {
                    position += fc.position();
                } else if (whence == PosixConstants.SEEK_END.value) {
                    position += fc.size();
                }
                if (lock == null) {
                    if (!unlock) {
                        lock = !blocking ? fc.tryLock(position, length, shared) : fc.lock(position, length, shared);
                    }
                } else if (unlock) {
                    lock.release();
                    lock = null;
                } else if (!shared && lock.isShared()) {
                    if (!blocking) {
                        FileLock newLock = fc.tryLock(position, length, false);
                        if (newLock != null) {
                            lock = newLock;
                        }
                    } else {
                        lock = fc.lock();
                    }
                }
            }
            catch (IOException e) {
                throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(e, TruffleString.EqualNode.getUncached()));
            }
            this.setFileLock(fd, lock);
        }
    }

    @ExportMessage
    public boolean getBlocking(int fd) throws PosixSupportLibrary.PosixException {
        Channel channel = this.getChannel(fd);
        if (channel == null) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EBADF);
        }
        if (channel instanceof EmulatedSocket) {
            return EmulatedPosixSupport.getBlocking((EmulatedSocket)channel);
        }
        Channel fileChannel = this.getFileChannel(fd);
        if (fileChannel instanceof SelectableChannel) {
            return EmulatedPosixSupport.getBlocking((SelectableChannel)fileChannel);
        }
        if (fileChannel == null) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EBADFD);
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage.Ignore
    private static boolean getBlocking(SelectableChannel channel) {
        return channel.isBlocking();
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage.Ignore
    private static boolean getBlocking(EmulatedSocket socket) {
        return socket.isBlocking();
    }

    @ExportMessage
    public void setBlocking(int fd, boolean blocking, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
        if (PythonOptions.WITHOUT_JAVA_INET || this.withoutIOSocket) {
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException("setBlocking was excluded");
        }
        try {
            Channel channel = this.getChannel(fd);
            if (channel instanceof EmulatedSocket) {
                EmulatedPosixSupport.setBlocking((EmulatedSocket)channel, blocking);
                return;
            }
            Channel fileChannel = this.getFileChannel(fd);
            if (fileChannel instanceof SelectableChannel) {
                EmulatedPosixSupport.setBlocking((SelectableChannel)fileChannel, blocking);
            } else if (fileChannel != null) {
                if (blocking) {
                    return;
                }
                throw new PosixSupportLibrary.PosixException(OSErrorEnum.EPERM.getNumber(), PythonUtils.toTruffleStringUncached("Emulated posix support does not support non-blocking mode for regular files."));
            }
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw e;
        }
        catch (Exception e) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(e, eqNode));
        }
        throw EmulatedPosixSupport.posixException(OSErrorEnum.EBADFD);
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage.Ignore
    private static void setBlocking(SelectableChannel channel, boolean block) throws IOException {
        channel.configureBlocking(block);
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage.Ignore
    private static void setBlocking(EmulatedSocket socket, boolean block) throws IOException {
        socket.configureBlocking(block);
    }

    @ExportMessage
    public int[] getTerminalSize(int fd) throws PosixSupportLibrary.PosixException {
        if (this.getFileChannel(fd) == null) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EBADF);
        }
        return new int[]{this.context.getOption(PythonOptions.TerminalWidth), this.context.getOption(PythonOptions.TerminalHeight)};
    }

    @ExportMessage
    public long[] fstatat(int dirFd, Object path, boolean followSymlinks, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached InlinedBranchProfile errorBranch, @Cached.Exclusive @Cached InlinedConditionProfile defaultDirFdPofile, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode) throws PosixSupportLibrary.PosixException {
        TruffleString pathname = EmulatedPosixSupport.pathToTruffleString(path, fromJavaStringNode);
        TruffleFile f = this.resolvePath(inliningTarget, dirFd, pathname, defaultDirFdPofile, eqNode, toJavaStringNode);
        LinkOption[] linkOptions = EmulatedPosixSupport.getLinkOptions(followSymlinks);
        try {
            return this.fstat(f, linkOptions);
        }
        catch (Exception e) {
            errorBranch.enter(inliningTarget);
            OSErrorEnum.ErrorAndMessagePair errAndMsg = OSErrorEnum.fromException(e, eqNode);
            throw EmulatedPosixSupport.posixException(errAndMsg);
        }
    }

    @ExportMessage
    public long[] fstat(int fd, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached InlinedBranchProfile nullPathProfile, @Cached.Exclusive @Cached InlinedBranchProfile errorBranch, @Cached.Exclusive @Cached InlinedConditionProfile defaultDirFdPofile, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) throws PosixSupportLibrary.PosixException {
        TruffleString path = this.getFilePath(fd, fromJavaStringNode);
        if (path == null) {
            nullPathProfile.enter(inliningTarget);
            Channel fileChannel = this.getFileChannel(fd);
            if (fileChannel == null) {
                errorBranch.enter(inliningTarget);
                throw EmulatedPosixSupport.posixException(OSErrorEnum.EBADF);
            }
            return EmulatedPosixSupport.fstatWithoutPath(fileChannel);
        }
        TruffleFile f = this.getTruffleFile(path, eqNode);
        try {
            return this.fstat(f, new LinkOption[0]);
        }
        catch (Exception e) {
            errorBranch.enter(inliningTarget);
            OSErrorEnum.ErrorAndMessagePair errAndMsg = OSErrorEnum.fromException(e, eqNode);
            throw EmulatedPosixSupport.posixException(errAndMsg);
        }
    }

    @ExportMessage
    public long[] statvfs(Object path) {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("Emulated statvfs not supported");
    }

    @ExportMessage
    public long[] fstatvfs(int fd) {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("Emulated fstatvfs not supported");
    }

    private static long[] fstatWithoutPath(Channel fileChannel) {
        int mode = 0;
        if (fileChannel instanceof ReadableByteChannel) {
            mode |= 0x124;
        }
        if (fileChannel instanceof WritableByteChannel) {
            mode |= 0x92;
        }
        long[] res = new long[13];
        res[0] = mode;
        return res;
    }

    @ExportMessage.Ignore
    @CompilerDirectives.TruffleBoundary
    private long[] fstat(TruffleFile f, LinkOption[] linkOptions) throws IOException {
        try {
            return EmulatedPosixSupport.unixStat(f, linkOptions);
        }
        catch (UnsupportedOperationException unsupported) {
            if (!PythonOptions.WITHOUT_PLATFORM_ACCESS) {
                try {
                    return this.posixStat(f, linkOptions);
                }
                catch (UnsupportedOperationException unsupported2) {
                    return this.basicStat(f, linkOptions);
                }
            }
            return this.basicStat(f, linkOptions);
        }
    }

    private static long[] unixStat(TruffleFile file, LinkOption ... linkOptions) throws IOException {
        TruffleFile.Attributes attributes = file.getAttributes(Arrays.asList(TruffleFile.UNIX_MODE, TruffleFile.UNIX_INODE, TruffleFile.UNIX_DEV, TruffleFile.UNIX_NLINK, TruffleFile.UNIX_UID, TruffleFile.UNIX_GID, TruffleFile.SIZE, TruffleFile.LAST_ACCESS_TIME, TruffleFile.LAST_MODIFIED_TIME, TruffleFile.UNIX_CTIME), linkOptions);
        return EmulatedPosixSupport.setTimestamps(attributes, (TruffleFile.AttributeDescriptor<FileTime>)TruffleFile.UNIX_CTIME, new long[]{((Integer)attributes.get(TruffleFile.UNIX_MODE)).intValue(), (Long)attributes.get(TruffleFile.UNIX_INODE), (Long)attributes.get(TruffleFile.UNIX_DEV), ((Integer)attributes.get(TruffleFile.UNIX_NLINK)).intValue(), ((Integer)attributes.get(TruffleFile.UNIX_UID)).intValue(), ((Integer)attributes.get(TruffleFile.UNIX_GID)).intValue(), (Long)attributes.get(TruffleFile.SIZE), 0L, 0L, 0L, 0L, 0L, 0L});
    }

    private long[] posixStat(TruffleFile file, LinkOption ... linkOptions) throws IOException {
        TruffleFile.Attributes attributes = file.getAttributes(Arrays.asList(TruffleFile.IS_DIRECTORY, TruffleFile.IS_SYMBOLIC_LINK, TruffleFile.IS_REGULAR_FILE, TruffleFile.LAST_MODIFIED_TIME, TruffleFile.LAST_ACCESS_TIME, TruffleFile.CREATION_TIME, TruffleFile.SIZE, TruffleFile.UNIX_OWNER, TruffleFile.UNIX_GROUP, TruffleFile.UNIX_PERMISSIONS), linkOptions);
        Set posixFilePermissions = (Set)attributes.get(TruffleFile.UNIX_PERMISSIONS);
        return EmulatedPosixSupport.setTimestamps(attributes, (TruffleFile.AttributeDescriptor<FileTime>)TruffleFile.CREATION_TIME, new long[]{EmulatedPosixSupport.posixPermissionsToMode(EmulatedPosixSupport.fileTypeBitsFromAttributes(attributes), posixFilePermissions), this.getEmulatedInode(file), 0L, 0L, EmulatedPosixSupport.getPrincipalId((UserPrincipal)attributes.get(TruffleFile.UNIX_OWNER)), EmulatedPosixSupport.getPrincipalId((UserPrincipal)attributes.get(TruffleFile.UNIX_GROUP)), (Long)attributes.get(TruffleFile.SIZE), 0L, 0L, 0L, 0L, 0L, 0L});
    }

    private long[] basicStat(TruffleFile file, LinkOption ... linkOptions) throws IOException {
        TruffleFile.Attributes attributes = file.getAttributes(Arrays.asList(TruffleFile.IS_DIRECTORY, TruffleFile.IS_SYMBOLIC_LINK, TruffleFile.IS_REGULAR_FILE, TruffleFile.LAST_MODIFIED_TIME, TruffleFile.LAST_ACCESS_TIME, TruffleFile.CREATION_TIME, TruffleFile.SIZE), linkOptions);
        int mode = EmulatedPosixSupport.fileTypeBitsFromAttributes(attributes);
        if (EmulatedPosixSupport.isReadable(file)) {
            mode |= 4;
            mode |= 0x20;
            mode |= 0x100;
        }
        if (EmulatedPosixSupport.isWritable(file)) {
            mode |= 2;
            mode |= 0x10;
            mode |= 0x80;
        }
        if (EmulatedPosixSupport.isExecutable(file)) {
            mode |= 1;
            mode |= 8;
            mode |= 0x40;
        }
        int inode = this.getEmulatedInode(file);
        return EmulatedPosixSupport.setTimestamps(attributes, (TruffleFile.AttributeDescriptor<FileTime>)TruffleFile.CREATION_TIME, new long[]{mode, inode, 0L, 0L, 0L, 0L, (Long)attributes.get(TruffleFile.SIZE), 0L, 0L, 0L, 0L, 0L, 0L});
    }

    private static boolean isReadable(TruffleFile file) {
        try {
            return file.isReadable();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private static boolean isWritable(TruffleFile file) {
        try {
            return file.isWritable();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private static boolean isExecutable(TruffleFile file) {
        try {
            return file.isExecutable();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private static long[] setTimestamps(TruffleFile.Attributes attributes, TruffleFile.AttributeDescriptor<FileTime> ctimeDescriptor, long[] statResult) {
        FileTime atime = (FileTime)attributes.get(TruffleFile.LAST_ACCESS_TIME);
        FileTime mtime = (FileTime)attributes.get(TruffleFile.LAST_MODIFIED_TIME);
        FileTime ctime = (FileTime)attributes.get(ctimeDescriptor);
        statResult[7] = EmulatedPosixSupport.fileTimeToSeconds(atime);
        statResult[8] = EmulatedPosixSupport.fileTimeToSeconds(mtime);
        statResult[9] = EmulatedPosixSupport.fileTimeToSeconds(ctime);
        statResult[10] = EmulatedPosixSupport.fileTimeNanoSecondsPart(atime);
        statResult[11] = EmulatedPosixSupport.fileTimeNanoSecondsPart(mtime);
        statResult[12] = EmulatedPosixSupport.fileTimeNanoSecondsPart(ctime);
        return statResult;
    }

    private static int fileTypeBitsFromAttributes(TruffleFile.Attributes attributes) {
        int mode = 0;
        mode = ((Boolean)attributes.get(TruffleFile.IS_REGULAR_FILE)).booleanValue() ? (mode |= PosixConstants.S_IFREG.value) : (((Boolean)attributes.get(TruffleFile.IS_DIRECTORY)).booleanValue() ? (mode |= PosixConstants.S_IFDIR.value) : (((Boolean)attributes.get(TruffleFile.IS_SYMBOLIC_LINK)).booleanValue() ? (mode |= PosixConstants.S_IFLNK.value) : (mode |= PosixConstants.S_IFSOCK.value | PosixConstants.S_IFBLK.value | PosixConstants.S_IFCHR.value | PosixConstants.S_IFIFO.value)));
        return mode;
    }

    private int getEmulatedInode(TruffleFile file) {
        TruffleFile canonical;
        EmulatedPosixSupport.compatibilityInfo("Using artificial emulated inode number for file '%s'", file);
        try {
            canonical = file.getCanonicalFile(new LinkOption[0]);
        }
        catch (IOException | SecurityException e) {
            canonical = file.getAbsoluteFile();
        }
        return this.getInodeId(canonical.getPath());
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static long getPrincipalId(UserPrincipal principal) {
        if (!PythonOptions.WITHOUT_PLATFORM_ACCESS && principal instanceof UnixNumericGroupPrincipal) {
            try {
                return Long.decode(principal.getName());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static int posixPermissionsToMode(int inputMode, Set<PosixFilePermission> posixFilePermissions) {
        int mode = inputMode;
        if (posixFilePermissions.contains((Object)PosixFilePermission.OTHERS_READ)) {
            mode |= 4;
        }
        if (posixFilePermissions.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
            mode |= 2;
        }
        if (posixFilePermissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            mode |= 1;
        }
        if (posixFilePermissions.contains((Object)PosixFilePermission.GROUP_READ)) {
            mode |= 0x20;
        }
        if (posixFilePermissions.contains((Object)PosixFilePermission.GROUP_WRITE)) {
            mode |= 0x10;
        }
        if (posixFilePermissions.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
            mode |= 8;
        }
        if (posixFilePermissions.contains((Object)PosixFilePermission.OWNER_READ)) {
            mode |= 0x100;
        }
        if (posixFilePermissions.contains((Object)PosixFilePermission.OWNER_WRITE)) {
            mode |= 0x80;
        }
        if (posixFilePermissions.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
            mode |= 0x40;
        }
        return mode;
    }

    @ExportMessage
    public Object[] uname(@Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        return new Object[]{PythonOS.getPythonOS().getName(), fromJavaStringNode.execute(EmulatedPosixSupport.getHostName(this.withoutIOSocket), PythonUtils.TS_ENCODING), fromJavaStringNode.execute(EmulatedPosixSupport.getOsVersion(), PythonUtils.TS_ENCODING), StringLiterals.T_EMPTY_STRING, PythonUtils.getPythonArch()};
    }

    @CompilerDirectives.TruffleBoundary
    private static String getOsVersion() {
        return System.getProperty("os.version", "");
    }

    @CompilerDirectives.TruffleBoundary
    private static String getHostName(boolean withoutSocket) {
        if (PythonOptions.WITHOUT_JAVA_INET || withoutSocket) {
            return "";
        }
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName();
        }
        catch (SecurityException | UnknownHostException ignore) {
            return "";
        }
    }

    @ExportMessage
    public void unlinkat(int dirFd, Object path, boolean rmdir, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch, @Cached.Shared(value="defaultDirProfile") @Cached InlinedConditionProfile defaultDirFdPofile, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode) throws PosixSupportLibrary.PosixException {
        boolean isDirectory;
        TruffleString pathname = EmulatedPosixSupport.pathToTruffleString(path, fromJavaStringNode);
        TruffleFile f = this.resolvePath(inliningTarget, dirFd, pathname, defaultDirFdPofile, eqNode, toJavaStringNode);
        if (f.exists(new LinkOption[]{LinkOption.NOFOLLOW_LINKS}) && (isDirectory = f.isDirectory(new LinkOption[]{LinkOption.NOFOLLOW_LINKS})) != rmdir) {
            errorBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(isDirectory ? OSErrorEnum.EISDIR : OSErrorEnum.ENOTDIR);
        }
        try {
            f.delete();
        }
        catch (Exception e) {
            errorBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(e, eqNode));
        }
    }

    @ExportMessage
    public void linkat(int oldFdDir, Object oldPath, int newFdDir, Object newPath, int flags, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch, @Cached.Shared(value="defaultDirProfile") @Cached InlinedConditionProfile defaultDirFdPofile, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode) throws PosixSupportLibrary.PosixException {
        TruffleString srcPath = EmulatedPosixSupport.pathToTruffleString(oldPath, fromJavaStringNode);
        TruffleFile srcFile = this.resolvePath(inliningTarget, oldFdDir, srcPath, defaultDirFdPofile, eqNode, toJavaStringNode);
        TruffleString dstPath = EmulatedPosixSupport.pathToTruffleString(newPath, fromJavaStringNode);
        TruffleFile dstFile = this.resolvePath(inliningTarget, newFdDir, srcPath, defaultDirFdPofile, eqNode, toJavaStringNode);
        try {
            if ((flags & PosixConstants.AT_SYMLINK_FOLLOW.value) != 0) {
                dstFile = dstFile.getCanonicalFile(new LinkOption[0]);
            }
            srcFile.createLink(dstFile);
        }
        catch (Exception e) {
            errorBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(e, eqNode));
        }
    }

    @ExportMessage
    public void symlinkat(Object target, int linkDirFd, Object link, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch, @Cached.Shared(value="defaultDirProfile") @Cached InlinedConditionProfile defaultDirFdPofile, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode) throws PosixSupportLibrary.PosixException {
        TruffleString linkPath = EmulatedPosixSupport.pathToTruffleString(link, fromJavaStringNode);
        TruffleFile linkFile = this.resolvePath(inliningTarget, linkDirFd, linkPath, defaultDirFdPofile, eqNode, toJavaStringNode);
        TruffleString targetPath = EmulatedPosixSupport.pathToTruffleString(target, fromJavaStringNode);
        TruffleFile targetFile = this.getTruffleFile(targetPath, eqNode);
        try {
            linkFile.createSymbolicLink(targetFile, new FileAttribute[0]);
        }
        catch (Exception e) {
            errorBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(e, eqNode));
        }
    }

    @ExportMessage
    public void mkdirat(int dirFd, Object path, int mode, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch, @Cached.Shared(value="defaultDirProfile") @Cached InlinedConditionProfile defaultDirFdPofile, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode) throws PosixSupportLibrary.PosixException {
        TruffleString pathStr = EmulatedPosixSupport.pathToTruffleString(path, fromJavaStringNode);
        TruffleFile linkFile = this.resolvePath(inliningTarget, dirFd, pathStr, defaultDirFdPofile, eqNode, toJavaStringNode);
        try {
            linkFile.createDirectory(new FileAttribute[0]);
        }
        catch (Exception e) {
            errorBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(e, eqNode));
        }
    }

    @ExportMessage
    public Object getcwd() {
        return this.context.getEnv().getCurrentWorkingDirectory().toString();
    }

    @ExportMessage
    public void chdir(Object path, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) throws PosixSupportLibrary.PosixException {
        this.chdirStr(inliningTarget, EmulatedPosixSupport.pathToTruffleString(path, fromJavaStringNode), errorBranch, eqNode);
    }

    @ExportMessage
    public void fchdir(int fd, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) throws PosixSupportLibrary.PosixException {
        TruffleString path = this.getFilePath(fd, fromJavaStringNode);
        if (path == null) {
            errorBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EBADF);
        }
        this.chdirStr(inliningTarget, path, errorBranch, eqNode);
    }

    private void chdirStr(Node inliningTarget, TruffleString pathStr, InlinedBranchProfile errorBranch, TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
        TruffleFile truffleFile = this.getTruffleFile(pathStr, eqNode).getAbsoluteFile();
        if (!truffleFile.exists(new LinkOption[0])) {
            errorBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.ENOENT);
        }
        if (!truffleFile.isDirectory(new LinkOption[0])) {
            errorBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.ENOTDIR);
        }
        try {
            this.context.getEnv().setCurrentWorkingDirectory(truffleFile);
        }
        catch (IllegalArgumentException ignored) {
            errorBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.ENOENT);
        }
        catch (SecurityException ignored) {
            errorBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EACCES);
        }
        catch (UnsupportedOperationException ignored) {
            errorBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(new OSErrorEnum.ErrorAndMessagePair(OSErrorEnum.EIO, T_FILESYSTEM_DOES_NOT_SUPPORT_CHANGING_CUR_DIR));
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public boolean isatty(int fd) {
        if (this.isStandardStream(fd)) {
            return this.context.getOption(PythonOptions.TerminalIsInteractive);
        }
        String path = this.getFilePath(fd);
        return path != null && (path.equals("/dev/tty") || path.equals("/dev/console"));
    }

    @ExportMessage
    public Object opendir(Object path, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) throws PosixSupportLibrary.PosixException {
        return this.opendirImpl(EmulatedPosixSupport.pathToTruffleString(path, fromJavaStringNode), -1, eqNode);
    }

    @ExportMessage
    public Object fdopendir(int fd, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) throws PosixSupportLibrary.PosixException {
        TruffleString path = this.getFilePath(fd, fromJavaStringNode);
        if (path == null) {
            errorBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.ENOENT);
        }
        return this.opendirImpl(path, fd, eqNode);
    }

    private EmulatedDirStream opendirImpl(TruffleString path, int fd, TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
        TruffleFile file = this.getTruffleFile(path, eqNode);
        return new EmulatedDirStream(file, fd);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public void closedir(Object dirStreamObj, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
        EmulatedDirStream dirStream = (EmulatedDirStream)dirStreamObj;
        try {
            dirStream.closeStream();
        }
        catch (IOException e) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(e, eqNode));
        }
        finally {
            if (dirStream.fd != -1) {
                this.close(dirStream.fd);
            }
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public Object readdir(Object dirStreamObj, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
        EmulatedDirStream dirStream = (EmulatedDirStream)dirStreamObj;
        if (dirStream.needsReopen) {
            dirStream.reopen();
        }
        try {
            if (dirStream.iterator.hasNext()) {
                return dirStream.iterator.next();
            }
            return null;
        }
        catch (DirectoryIteratorException e) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(e.getCause(), eqNode));
        }
    }

    @ExportMessage
    public void rewinddir(Object dirStreamObj) {
        EmulatedDirStream dirStream = (EmulatedDirStream)dirStreamObj;
        dirStream.needsReopen = true;
    }

    @ExportMessage
    public Object dirEntryGetName(Object dirEntry) {
        TruffleFile file = (TruffleFile)dirEntry;
        return file.getName();
    }

    @ExportMessage
    public Object dirEntryGetPath(Object dirEntry, Object scandirPath, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        TruffleFile file = (TruffleFile)dirEntry;
        TruffleFile dir = this.context.getPublicTruffleFileRelaxed(EmulatedPosixSupport.pathToTruffleString(scandirPath, fromJavaStringNode), new TruffleString[0]);
        return dir.resolve(file.getName()).getPath();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public long dirEntryGetInode(Object dirEntry, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
        TruffleFile file = (TruffleFile)dirEntry;
        try {
            TruffleFile.Attributes attributes = file.getAttributes(Collections.singletonList(TruffleFile.UNIX_INODE), new LinkOption[]{LinkOption.NOFOLLOW_LINKS});
            return (Long)attributes.get(TruffleFile.UNIX_INODE);
        }
        catch (UnsupportedOperationException e) {
            return this.getEmulatedInode(file);
        }
        catch (IOException e) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(e, eqNode));
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public int dirEntryGetType(Object dirEntry) {
        TruffleFile file = (TruffleFile)dirEntry;
        try {
            TruffleFile.Attributes attrs = file.getAttributes(Arrays.asList(TruffleFile.IS_DIRECTORY, TruffleFile.IS_SYMBOLIC_LINK, TruffleFile.IS_REGULAR_FILE), new LinkOption[]{LinkOption.NOFOLLOW_LINKS});
            if (((Boolean)attrs.get(TruffleFile.IS_DIRECTORY)).booleanValue()) {
                return PosixConstants.DT_DIR.value;
            }
            if (((Boolean)attrs.get(TruffleFile.IS_SYMBOLIC_LINK)).booleanValue()) {
                return PosixConstants.DT_LNK.value;
            }
            if (((Boolean)attrs.get(TruffleFile.IS_REGULAR_FILE)).booleanValue()) {
                return PosixConstants.DT_REG.value;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Silenced exception in dirEntryGetType", (Throwable)e);
        }
        return PosixConstants.DT_UNKNOWN.value;
    }

    @ExportMessage
    public void utimensat(int dirFd, Object path, long[] timespec, boolean followSymlinks, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="setUTime") @Cached SetUTimeNode setUTimeNode, @Cached.Shared(value="defaultDirProfile") @Cached InlinedConditionProfile defaultDirFdPofile, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode) throws PosixSupportLibrary.PosixException {
        TruffleString pathStr = EmulatedPosixSupport.pathToTruffleString(path, fromJavaStringNode);
        TruffleFile file = this.resolvePath(inliningTarget, dirFd, pathStr, defaultDirFdPofile, eqNode, toJavaStringNode);
        setUTimeNode.execute(inliningTarget, file, timespec, followSymlinks);
    }

    @ExportMessage
    public void futimens(int fd, long[] timespec, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="setUTime") @Cached SetUTimeNode setUTimeNode, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) throws PosixSupportLibrary.PosixException {
        TruffleString path = this.getFilePath(fd, fromJavaStringNode);
        TruffleFile file = this.getTruffleFile(path, eqNode);
        setUTimeNode.execute(inliningTarget, file, timespec, true);
    }

    @ExportMessage
    public void futimes(int fd, PosixSupportLibrary.Timeval[] timeval, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="setUTime") @Cached SetUTimeNode setUTimeNode, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) throws PosixSupportLibrary.PosixException {
        TruffleString path = this.getFilePath(fd, fromJavaStringNode);
        TruffleFile file = this.getTruffleFile(path, eqNode);
        setUTimeNode.execute(inliningTarget, file, EmulatedPosixSupport.timevalToTimespec(timeval), true);
    }

    @ExportMessage
    public void lutimes(Object filename, PosixSupportLibrary.Timeval[] timeval, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="setUTime") @Cached SetUTimeNode setUTimeNode, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) throws PosixSupportLibrary.PosixException {
        TruffleString filenameStr = EmulatedPosixSupport.pathToTruffleString(filename, fromJavaStringNode);
        TruffleFile file = this.getTruffleFile(filenameStr, eqNode);
        setUTimeNode.execute(inliningTarget, file, EmulatedPosixSupport.timevalToTimespec(timeval), false);
    }

    @ExportMessage
    public void utimes(Object filename, PosixSupportLibrary.Timeval[] timeval, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="setUTime") @Cached SetUTimeNode setUTimeNode, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) throws PosixSupportLibrary.PosixException {
        TruffleString filenameStr = EmulatedPosixSupport.pathToTruffleString(filename, fromJavaStringNode);
        TruffleFile file = this.getTruffleFile(filenameStr, eqNode);
        setUTimeNode.execute(inliningTarget, file, EmulatedPosixSupport.timevalToTimespec(timeval), true);
    }

    private static long[] timevalToTimespec(PosixSupportLibrary.Timeval[] timeval) {
        if (timeval == null) {
            return null;
        }
        return new long[]{timeval[0].getSeconds(), timeval[0].getMicroseconds() * 1000L, timeval[1].getSeconds(), timeval[1].getMicroseconds() * 1000L};
    }

    @ExportMessage
    public void renameat(int oldDirFd, Object oldPath, int newDirFd, Object newPath, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="defaultDirProfile") @Cached InlinedConditionProfile defaultDirFdPofile, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode) throws PosixSupportLibrary.PosixException {
        try {
            TruffleFile newFile = this.resolvePath(inliningTarget, newDirFd, EmulatedPosixSupport.pathToTruffleString(newPath, fromJavaStringNode), defaultDirFdPofile, eqNode, toJavaStringNode);
            if (newFile.isDirectory(new LinkOption[0])) {
                throw EmulatedPosixSupport.posixException(OSErrorEnum.EISDIR);
            }
            TruffleFile oldFile = this.resolvePath(inliningTarget, oldDirFd, EmulatedPosixSupport.pathToTruffleString(oldPath, fromJavaStringNode), defaultDirFdPofile, eqNode, toJavaStringNode);
            oldFile.move(newFile, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE});
        }
        catch (Exception e) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(e, eqNode));
        }
    }

    @ExportMessage
    public boolean faccessat(int dirFd, Object path, int mode, boolean effectiveIds, boolean followSymlinks, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errBranch, @Cached.Shared(value="defaultDirProfile") @Cached InlinedConditionProfile defaultDirFdPofile, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
        if (effectiveIds) {
            errBranch.enter(inliningTarget);
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException("faccess with effective user IDs");
        }
        TruffleFile file = null;
        try {
            file = this.resolvePath(inliningTarget, dirFd, EmulatedPosixSupport.pathToTruffleString(path, fromJavaStringNode), defaultDirFdPofile, eqNode, toJavaStringNode);
        }
        catch (PosixSupportLibrary.PosixException e) {
            return false;
        }
        if (!file.exists(EmulatedPosixSupport.getLinkOptions(followSymlinks))) {
            return false;
        }
        if (mode == PosixConstants.F_OK.value) {
            return true;
        }
        if (!followSymlinks) {
            errBranch.enter(inliningTarget);
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException("faccess with effective user IDs");
        }
        boolean result = true;
        if ((mode & PosixConstants.X_OK.value) != 0) {
            boolean bl = result = result && EmulatedPosixSupport.isExecutable(file);
        }
        if ((mode & PosixConstants.R_OK.value) != 0) {
            boolean bl = result = result && EmulatedPosixSupport.isReadable(file);
        }
        if ((mode & PosixConstants.W_OK.value) != 0) {
            result = result && EmulatedPosixSupport.isWritable(file);
        }
        return result;
    }

    @ExportMessage
    public void fchmodat(int dirFd, Object path, int mode, boolean followSymlinks, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="defaultDirProfile") @Cached InlinedConditionProfile defaultDirFdPofile, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode) throws PosixSupportLibrary.PosixException {
        TruffleFile file = this.resolvePath(inliningTarget, dirFd, EmulatedPosixSupport.pathToTruffleString(path, fromJavaStringNode), defaultDirFdPofile, eqNode, toJavaStringNode);
        Set<PosixFilePermission> permissions = EmulatedPosixSupport.modeToPosixFilePermissions(mode);
        if (PythonOS.getPythonOS() != PythonOS.PLATFORM_WIN32) {
            try {
                file.setPosixPermissions(permissions, EmulatedPosixSupport.getLinkOptions(followSymlinks));
            }
            catch (Exception e) {
                throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(e, eqNode));
            }
        }
    }

    @ExportMessage
    public void fchmod(int fd, int mode, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) throws PosixSupportLibrary.PosixException {
        TruffleString path = this.getFilePath(fd, fromJavaStringNode);
        if (path == null) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EBADF);
        }
        TruffleFile file = this.getTruffleFile(path, eqNode);
        Set<PosixFilePermission> permissions = EmulatedPosixSupport.modeToPosixFilePermissions(mode);
        try {
            file.setPosixPermissions(permissions, new LinkOption[0]);
        }
        catch (Exception e) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(e, eqNode));
        }
    }

    @ExportMessage
    public void fchownat(int dirFd, Object path, long owner, long group, boolean followSymlinks) {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("Emulated fchownat not supported");
    }

    @ExportMessage
    public void fchown(int fd, long owner, long group) {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("Emulated fchown not supported");
    }

    @ExportMessage
    public Object readlinkat(int dirFd, Object path, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="defaultDirProfile") @Cached InlinedConditionProfile defaultDirFdPofile, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode) throws PosixSupportLibrary.PosixException {
        TruffleFile file = this.resolvePath(inliningTarget, dirFd, EmulatedPosixSupport.pathToTruffleString(path, fromJavaStringNode), defaultDirFdPofile, eqNode, toJavaStringNode);
        try {
            TruffleFile canonicalFile = file.getCanonicalFile(new LinkOption[0]);
            if (file.equals((Object)canonicalFile)) {
                throw EmulatedPosixSupport.posixException(OSErrorEnum.EINVAL);
            }
            return canonicalFile.getPath();
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw e;
        }
        catch (Exception e) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(e, eqNode));
        }
    }

    @ExportMessage
    public void kill(long pid, int signal, @Cached ReadAttributeFromObjectNode readSignalNode, @Cached IsNode isNode) throws PosixSupportLibrary.PosixException {
        Object value;
        PythonModule signalModule = this.context.lookupBuiltinModule(BuiltinNames.T__SIGNAL);
        for (TruffleString name : TERMINATION_SIGNALS) {
            value = readSignalNode.execute(signalModule, name);
            if (!isNode.execute(signal, value)) continue;
            try {
                this.sigterm((int)pid);
            }
            catch (IndexOutOfBoundsException e) {
                throw EmulatedPosixSupport.posixException(OSErrorEnum.ESRCH);
            }
            return;
        }
        for (TruffleString name : KILL_SIGNALS) {
            value = readSignalNode.execute(signalModule, name);
            if (!isNode.execute(signal, value)) continue;
            try {
                this.sigkill((int)pid);
            }
            catch (IndexOutOfBoundsException e) {
                throw EmulatedPosixSupport.posixException(OSErrorEnum.ESRCH);
            }
            return;
        }
        Object dfl = readSignalNode.execute(signalModule, PythonUtils.toTruffleStringUncached("SIG_DFL"));
        if (isNode.execute(signal, dfl)) {
            try {
                this.sigdfl((int)pid);
            }
            catch (IndexOutOfBoundsException e) {
                throw EmulatedPosixSupport.posixException(OSErrorEnum.ESRCH);
            }
            return;
        }
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("Sending arbitrary signals to child processes. Can only send some kill and term signals.");
    }

    @ExportMessage
    public long killpg(long pgid, int signal) {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("Emulated killpg not supported");
    }

    @ExportMessage
    public long[] waitpid(long pid, int options, @CachedLibrary(value="this") PosixSupportLibrary posixLib) throws PosixSupportLibrary.PosixException {
        try {
            if (options == 0) {
                int[] exitStatus = new int[1];
                TruffleSafepoint.setBlockedThreadInterruptible((Node)posixLib, s -> {
                    exitStatus[0] = s.waitpid((int)pid);
                }, (Object)this);
                return new long[]{pid, exitStatus[0]};
            }
            if (options == PosixConstants.WNOHANG.value) {
                int[] res = this.exitStatus((int)pid);
                return new long[]{res[0], res[1]};
            }
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException("Only 0 or WNOHANG are supported for waitpid");
        }
        catch (IndexOutOfBoundsException e) {
            if (pid < -1L) {
                throw new PosixSupportLibrary.UnsupportedPosixFeatureException("Process groups are not supported.");
            }
            if (pid <= 0L) {
                throw EmulatedPosixSupport.posixException(OSErrorEnum.ECHILD);
            }
            throw EmulatedPosixSupport.posixException(OSErrorEnum.ESRCH);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void interruptThread() {
        Thread.currentThread().interrupt();
    }

    @ExportMessage
    public void abort(@CachedLibrary(value="this") PosixSupportLibrary thisLib) {
        throw new PythonExitException((Node)thisLib, 134);
    }

    @ExportMessage
    public boolean wcoredump(int status) {
        return false;
    }

    @ExportMessage
    public boolean wifcontinued(int status) {
        return false;
    }

    @ExportMessage
    public boolean wifstopped(int status) {
        return false;
    }

    @ExportMessage
    public boolean wifsignaled(int status) {
        return status > 128;
    }

    @ExportMessage
    public boolean wifexited(int status) {
        return !this.wifsignaled(status);
    }

    @ExportMessage
    public int wexitstatus(int status) {
        return status & 0x7F;
    }

    @ExportMessage
    public int wtermsig(int status) {
        return status - 128;
    }

    @ExportMessage
    public int wstopsig(int status) {
        return 0;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public long getuid() {
        if (!PythonOptions.WITHOUT_PLATFORM_ACCESS) {
            switch (PythonOS.getPythonOS()) {
                case PLATFORM_LINUX: 
                case PLATFORM_DARWIN: {
                    return new UnixSystem().getUid();
                }
            }
        }
        return 1000L;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public long geteuid() {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("Emulated geteuid not supported");
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public long getgid() {
        if (!PythonOptions.WITHOUT_PLATFORM_ACCESS) {
            switch (PythonOS.getPythonOS()) {
                case PLATFORM_LINUX: 
                case PLATFORM_DARWIN: {
                    return new UnixSystem().getGid();
                }
            }
        }
        return 1000L;
    }

    @ExportMessage
    public long getppid() {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("Emulated getppid not supported");
    }

    @ExportMessage
    public long getpgid(long pid) {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("Emulated getpgid not supported");
    }

    @ExportMessage
    public void setpgid(long pid, long pgid) {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("Emulated setpgid not supported");
    }

    @ExportMessage
    public long getpgrp() {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("Emulated getpgrp not supported");
    }

    @ExportMessage
    public long getsid(long pid) {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("Emulated getsid not supported");
    }

    @ExportMessage
    public long setsid() {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("Emulated getsid not supported");
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public long[] getgroups() {
        if (!PythonOptions.WITHOUT_PLATFORM_ACCESS) {
            switch (PythonOS.getPythonOS()) {
                case PLATFORM_LINUX: 
                case PLATFORM_DARWIN: {
                    return new UnixSystem().getGroups();
                }
            }
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException("emulated getgroups is not available on this platform");
        }
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("getgroups was excluded");
    }

    @ExportMessage
    public PosixSupportLibrary.OpenPtyResult openpty() {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("Emulated openpty not supported");
    }

    @ExportMessage
    public TruffleString ctermid() {
        return T_DEV_TTY;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public void setenv(Object name, Object value, boolean overwrite) {
        String nameStr = EmulatedPosixSupport.pathToJavaString(name);
        String valueStr = EmulatedPosixSupport.pathToJavaString(value);
        if (overwrite) {
            this.environ.put(nameStr, valueStr);
        } else {
            this.environ.putIfAbsent(nameStr, valueStr);
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public void unsetenv(Object name) {
        String nameStr = EmulatedPosixSupport.pathToJavaString(name);
        this.environ.remove(nameStr);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public int forkExec(Object[] executables, Object[] args, Object cwd, Object[] env, int stdinReadFd, int stdinWriteFd, int stdoutReadFd, int stdoutWriteFd, int stderrReadFd, int stderrWriteFd, int errPipeReadFd, int errPipeWriteFd, boolean closeFds, boolean restoreSignals, boolean callSetsid, int[] fdsToKeep, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) throws PosixSupportLibrary.PosixException {
        String[] argStrings;
        TruffleFile cwdFile;
        if (PythonOptions.WITHOUT_PLATFORM_ACCESS) {
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException("forkExec was excluded");
        }
        TruffleFile truffleFile = cwdFile = cwd == null ? this.context.getEnv().getCurrentWorkingDirectory() : this.getTruffleFile(EmulatedPosixSupport.pathToTruffleString(cwd, fromJavaStringNode), TruffleString.EqualNode.getUncached());
        if (!cwdFile.exists(new LinkOption[0])) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.ENOENT);
        }
        HashMap<String, String> envMap = null;
        if (env != null) {
            envMap = new HashMap<String, String>(env.length);
            for (Object o : env) {
                String str = EmulatedPosixSupport.pathToJavaString(o);
                String[] strings = str.split("=", 2);
                if (strings.length != 2) {
                    throw new PosixSupportLibrary.UnsupportedPosixFeatureException("Only key=value environment variables are supported");
                }
                envMap.put(strings[0], strings[1]);
            }
        }
        if (args.length == 0) {
            argStrings = new String[1];
        } else {
            argStrings = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                argStrings[i] = EmulatedPosixSupport.pathToJavaString(args[i]);
            }
        }
        IOException firstError = null;
        for (Object o : executables) {
            String path = EmulatedPosixSupport.pathToJavaString(o);
            TruffleFile executableFile = cwdFile.resolve(path);
            if (EmulatedPosixSupport.isExecutable(executableFile)) {
                argStrings[0] = path;
                try {
                    return this.exec(argStrings, cwdFile, envMap, stdinWriteFd, stdinReadFd, stdoutWriteFd, stdoutReadFd, stderrWriteFd, errPipeWriteFd, stderrReadFd);
                }
                catch (IOException ex) {
                    if (firstError != null) continue;
                    firstError = ex;
                    continue;
                }
            }
            LOGGER.finest(() -> "_posixsubprocess.fork_exec not executable: " + String.valueOf(executableFile));
        }
        if (errPipeWriteFd != -1) {
            this.handleIOError(errPipeWriteFd, firstError);
        }
        return -1;
    }

    private int exec(String[] argStrings, TruffleFile cwd, Map<String, String> env, int p2cwrite, int p2cread, int c2pwrite, int c2pread, int errwrite, int errpipe_write, int errread) throws IOException {
        LOGGER.finest(() -> "_posixsubprocess.fork_exec trying to exec: " + String.join((CharSequence)" ", argStrings));
        TruffleProcessBuilder pb = this.context.getEnv().newProcessBuilder(argStrings);
        if (p2cread != -1 && p2cwrite != -1) {
            pb.redirectInput(ProcessHandler.Redirect.PIPE);
        } else {
            pb.redirectInput(ProcessHandler.Redirect.INHERIT);
        }
        if (c2pread != -1 && c2pwrite != -1) {
            pb.redirectOutput(ProcessHandler.Redirect.PIPE);
        } else {
            pb.redirectOutput(ProcessHandler.Redirect.INHERIT);
        }
        if (errread != -1 && errwrite != -1) {
            pb.redirectError(ProcessHandler.Redirect.PIPE);
        } else {
            pb.redirectError(ProcessHandler.Redirect.INHERIT);
        }
        if (errwrite == c2pwrite) {
            pb.redirectErrorStream(true);
        }
        pb.directory(cwd);
        if (env != null) {
            pb.clearEnvironment(true);
            pb.environment(env);
        }
        ProcessWrapper process = new ProcessWrapper(pb.start(), p2cwrite != -1, c2pread != 1, errread != -1);
        try {
            if (p2cwrite != -1) {
                this.getFileChannel(p2cwrite).close();
                this.fdopen(p2cwrite, process.getOutputChannel());
            }
            if (c2pread != -1) {
                this.getFileChannel(c2pread).close();
                this.fdopen(c2pread, process.getInputChannel());
            }
            if (errread != -1) {
                this.getFileChannel(errread).close();
                this.fdopen(errread, process.getErrorChannel());
            }
        }
        catch (IOException ex) {
            if (errpipe_write != -1) {
                this.handleIOError(errpipe_write, ex);
            }
            return -1;
        }
        return this.registerChild(process);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private void handleIOError(int errpipe_write, IOException e) {
        Channel err = this.getFileChannel(errpipe_write);
        if (!(err instanceof WritableByteChannel)) {
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException(ErrorMessages.ERROR_WRITING_FORKEXEC.toJavaStringUncached());
        }
        OSErrorEnum.ErrorAndMessagePair pair = e == null ? new OSErrorEnum.ErrorAndMessagePair(OSErrorEnum.ENOENT, OSErrorEnum.ENOENT.getMessage()) : OSErrorEnum.fromException(e, TruffleString.EqualNode.getUncached());
        try {
            ((WritableByteChannel)err).write(ByteBuffer.wrap(("OSError:" + Long.toHexString(pair.oserror.getNumber()) + ":" + String.valueOf(pair.message)).getBytes()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @ExportMessage
    public void execv(Object pathname, Object[] args, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
        assert (args.length > 0);
        String[] cmd = new String[args.length];
        cmd[0] = EmulatedPosixSupport.pathToJavaString(pathname);
        for (int i = 1; i < cmd.length; ++i) {
            cmd[i] = EmulatedPosixSupport.pathToJavaString(args[i]);
        }
        try {
            this.execvInternal(cmd);
        }
        catch (Exception e) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(e, eqNode));
        }
        throw CompilerDirectives.shouldNotReachHere((String)"Execv must not return normally");
    }

    @CompilerDirectives.TruffleBoundary
    private void execvInternal(String[] cmd) throws IOException {
        String line;
        TruffleProcessBuilder builder = this.context.getEnv().newProcessBuilder(cmd);
        builder.clearEnvironment(true);
        builder.environment(this.environ);
        Process pr = builder.start();
        BufferedReader bfr = new BufferedReader(new InputStreamReader(pr.getInputStream()));
        OutputStream stream = this.context.getEnv().out();
        while ((line = bfr.readLine()) != null) {
            stream.write(line.getBytes());
            stream.write("\n".getBytes());
        }
        BufferedReader stderr = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
        OutputStream errStream = this.context.getEnv().err();
        while ((line = stderr.readLine()) != null) {
            errStream.write(line.getBytes());
            errStream.write("\n".getBytes());
        }
        try {
            pr.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        throw new PythonExitException(null, pr.exitValue());
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public int system(Object commandObj) {
        if (PythonOptions.WITHOUT_PLATFORM_ACCESS) {
            return 126;
        }
        String cmd = EmulatedPosixSupport.pathToJavaString(commandObj);
        LOGGER.fine(() -> "os.system: " + cmd);
        String[] command = PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? new String[]{"cmd.exe", "/c", cmd} : new String[]{this.environ.getOrDefault("SHELL", "sh"), "-c", cmd};
        TruffleLanguage.Env env = this.context.getEnv();
        try {
            boolean stdsArePipes;
            TruffleProcessBuilder pb = this.context.getEnv().newProcessBuilder(command);
            pb.directory(env.getCurrentWorkingDirectory());
            PipePump stdout = null;
            PipePump stderr = null;
            boolean bl = stdsArePipes = this.context.getOption(PythonOptions.TerminalIsInteractive) == false;
            if (stdsArePipes) {
                pb.redirectInput(ProcessHandler.Redirect.PIPE);
                pb.redirectOutput(ProcessHandler.Redirect.PIPE);
                pb.redirectError(ProcessHandler.Redirect.PIPE);
            } else {
                pb.inheritIO(true);
            }
            Process proc = pb.start();
            if (stdsArePipes) {
                proc.getOutputStream().close();
                stdout = new PipePump(cmd + " [stdout]", proc.getInputStream(), env.out());
                stderr = new PipePump(cmd + " [stderr]", proc.getErrorStream(), env.err());
                stdout.start();
                stderr.start();
            }
            int exitStatus = proc.waitFor();
            if (stdsArePipes) {
                stdout.finish();
                stderr.finish();
            }
            return exitStatus;
        }
        catch (IOException | InterruptedException e) {
            return -1;
        }
    }

    @ExportMessage
    final MMapHandle mmap(long length, int prot, int flags, int fd, long offset, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="defaultDirProfile") @Cached InlinedConditionProfile isAnonymousProfile, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) throws PosixSupportLibrary.PosixException {
        if (prot == PosixConstants.PROT_NONE.value) {
            return MMapHandle.NONE;
        }
        if (isAnonymousProfile.profile(inliningTarget, (flags & PosixConstants.MAP_ANONYMOUS.value) != 0)) {
            try {
                return new MMapHandle(new AnonymousMap(PythonUtils.toIntExact(length)), 0L);
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreter();
                throw new PosixSupportLibrary.UnsupportedPosixFeatureException(String.format("Anonymous mapping in mmap for memory larger than %d", Integer.MAX_VALUE));
            }
        }
        TruffleString path = this.getFilePath(fd, fromJavaStringNode);
        TruffleFile file = this.getTruffleFile(path, eqNode);
        Set<StandardOpenOption> options = EmulatedPosixSupport.mmapProtToOptions(prot);
        try {
            SeekableByteChannel fileChannel = EmulatedPosixSupport.newByteChannel(file, options);
            EmulatedPosixSupport.position(fileChannel, offset);
            return new MMapHandle(fileChannel, offset);
        }
        catch (IOException e) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(e, eqNode));
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static Set<StandardOpenOption> mmapProtToOptions(int prot) {
        HashSet<StandardOpenOption> options = new HashSet<StandardOpenOption>();
        if ((prot & PosixConstants.PROT_READ.value) != 0) {
            options.add(StandardOpenOption.READ);
        }
        if ((prot & PosixConstants.PROT_WRITE.value) != 0) {
            options.add(StandardOpenOption.WRITE);
        }
        if ((prot & PosixConstants.PROT_EXEC.value) != 0) {
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException("mmap: flag PROT_EXEC is not supported");
        }
        return options;
    }

    @CompilerDirectives.TruffleBoundary
    private static SeekableByteChannel newByteChannel(TruffleFile file, Set<StandardOpenOption> options) throws IOException {
        return file.newByteChannel(options, new FileAttribute[0]);
    }

    @ExportMessage
    public byte mmapReadByte(Object mmap, long index, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errBranch, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
        if (mmap == MMapHandle.NONE) {
            errBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EACCES);
        }
        MMapHandle handle = (MMapHandle)mmap;
        ByteBuffer readingBuffer = EmulatedPosixSupport.allocateByteBuffer(1);
        int readSize = EmulatedPosixSupport.readBytes(inliningTarget, handle, index, readingBuffer, errBranch, eqNode);
        if (readSize == 0) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.ENODATA);
        }
        return EmulatedPosixSupport.getByte(readingBuffer);
    }

    @ExportMessage
    public void mmapWriteByte(Object mmap, long index, byte value, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errBranch, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
        this.mmapWriteBytes(mmap, index, new byte[]{value}, 1, inliningTarget, errBranch, eqNode);
    }

    @ExportMessage
    public int mmapReadBytes(Object mmap, long index, byte[] bytes, int length, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errBranch, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
        int sz;
        if (mmap == MMapHandle.NONE) {
            errBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EACCES);
        }
        MMapHandle handle = (MMapHandle)mmap;
        try {
            sz = PythonUtils.toIntExact(length);
        }
        catch (OverflowException e) {
            errBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EOVERFLOW);
        }
        ByteBuffer readingBuffer = EmulatedPosixSupport.allocateByteBuffer(sz);
        int readSize = EmulatedPosixSupport.readBytes(inliningTarget, handle, index, readingBuffer, errBranch, eqNode);
        if (readSize > 0) {
            EmulatedPosixSupport.getByteBufferArray(readingBuffer, bytes, readSize);
        }
        return readSize;
    }

    private static int readBytes(Node inliningTarget, MMapHandle handle, long index, ByteBuffer readingBuffer, InlinedBranchProfile errBranch, TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
        try {
            EmulatedPosixSupport.position(handle.channel, index + handle.offset);
            return EmulatedPosixSupport.readChannel(handle.channel, readingBuffer);
        }
        catch (IOException e) {
            errBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(e, eqNode));
        }
    }

    @ExportMessage
    public void mmapWriteBytes(Object mmap, long index, byte[] bytes, int length, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errBranch, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
        if (mmap == MMapHandle.NONE) {
            errBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EACCES);
        }
        MMapHandle handle = (MMapHandle)mmap;
        try {
            SeekableByteChannel channel = handle.channel;
            EmulatedPosixSupport.position(channel, handle.offset + index);
            int written = EmulatedPosixSupport.writeChannel(channel, bytes, length);
            if (written != length) {
                throw EmulatedPosixSupport.posixException(OSErrorEnum.EIO);
            }
        }
        catch (Exception e) {
            errBranch.enter(inliningTarget);
            throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(e, eqNode));
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static int writeChannel(SeekableByteChannel channel, byte[] bytes, int length) throws IOException {
        return channel.write(ByteBuffer.wrap(bytes, 0, length));
    }

    @ExportMessage
    public void mmapFlush(Object mmap, long offset, long length) {
    }

    @ExportMessage
    public void mmapUnmap(Object mmap, long length, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
        if (mmap == MMapHandle.NONE) {
            return;
        }
        MMapHandle handle = (MMapHandle)mmap;
        if (handle.channel != null) {
            try {
                EmulatedPosixSupport.closeChannel(handle.channel);
            }
            catch (IOException e) {
                throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(e, eqNode));
            }
            handle.channel = null;
        }
    }

    @ExportMessage
    public long mmapGetPointer(Object mmap) {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("Unable to obtain mmap pointer in emulated posix backend");
    }

    @CompilerDirectives.TruffleBoundary
    private static void closeChannel(Channel ch) throws IOException {
        ch.close();
    }

    @CompilerDirectives.TruffleBoundary
    private static void position(SeekableByteChannel ch, long offset) throws IOException {
        ch.position(offset);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static ByteBuffer allocateByteBuffer(int n) {
        return ByteBuffer.allocate(n);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    protected static void getByteBufferArray(ByteBuffer src, byte[] dst, int readSize) {
        src.flip();
        src.get(dst, 0, readSize);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    protected static byte getByte(ByteBuffer src) {
        src.flip();
        return src.get();
    }

    @CompilerDirectives.TruffleBoundary
    private static int readChannel(Object readableChannel, ByteBuffer dst) throws IOException {
        return ((ReadableByteChannel)readableChannel).read(dst);
    }

    @ExportMessage
    public TruffleString crypt(TruffleString word, TruffleString salt) throws PosixSupportLibrary.PosixException {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("crypt not supported");
    }

    @ExportMessage
    long semOpen(Object name, int openFlags, int mode, int value) throws PosixSupportLibrary.PosixException {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("semaphore operations not supported");
    }

    @ExportMessage
    void semClose(long handle) throws PosixSupportLibrary.PosixException {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("semaphore operations not supported");
    }

    @ExportMessage
    void semUnlink(Object name) throws PosixSupportLibrary.PosixException {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("semaphore operations not supported");
    }

    @ExportMessage
    int semGetValue(long handle) throws PosixSupportLibrary.PosixException {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("semaphore operations not supported");
    }

    @ExportMessage
    void semPost(long handle) throws PosixSupportLibrary.PosixException {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("semaphore operations not supported");
    }

    @ExportMessage
    void semWait(long handle) throws PosixSupportLibrary.PosixException {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("semaphore operations not supported");
    }

    @ExportMessage
    boolean semTryWait(long handle) throws PosixSupportLibrary.PosixException {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("semaphore operations not supported");
    }

    @ExportMessage
    boolean semTimedWait(long handle, long deadlineNs) throws PosixSupportLibrary.PosixException {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("semaphore operations not supported");
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public PosixSupportLibrary.PwdResult getpwuid(long uid) throws PosixSupportLibrary.PosixException {
        if (!PythonOptions.WITHOUT_PLATFORM_ACCESS) {
            switch (PythonOS.getPythonOS()) {
                case PLATFORM_LINUX: 
                case PLATFORM_DARWIN: {
                    UnixSystem unix = new UnixSystem();
                    if (unix.getUid() != uid) {
                        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("getpwuid with other uid than the current user");
                    }
                    EmulatedPosixSupport.compatibilityInfo("gtpwuid: default shell cannot be retrieved for %d, using '/bin/sh' instead.", uid);
                    return EmulatedPosixSupport.createPwdResult(unix);
                }
            }
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException("emulated getpwuid is not available on this platform");
        }
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("getpwuid was excluded");
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public PosixSupportLibrary.PwdResult getpwnam(Object name) {
        if (!PythonOptions.WITHOUT_PLATFORM_ACCESS) {
            switch (PythonOS.getPythonOS()) {
                case PLATFORM_LINUX: 
                case PLATFORM_DARWIN: {
                    UnixSystem unix = new UnixSystem();
                    if (!unix.getUsername().equals(name)) {
                        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("getpwnam with other uid than the current user");
                    }
                    EmulatedPosixSupport.compatibilityInfo("gtpwuid: default shell cannot be retrieved for %s, using '/bin/sh' instead.", name);
                    return EmulatedPosixSupport.createPwdResult(unix);
                }
            }
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException("emulated getpwnam is not available on this platform");
        }
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("getpwnam was excluded");
    }

    @ExportMessage
    public boolean hasGetpwentries() {
        return false;
    }

    @ExportMessage
    public PosixSupportLibrary.PwdResult[] getpwentries() {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("getpwent");
    }

    private static PosixSupportLibrary.PwdResult createPwdResult(UnixSystem unix) {
        TruffleString homeDir = PythonUtils.toTruffleStringUncached(System.getProperty("user.home"));
        return new PosixSupportLibrary.PwdResult(PythonUtils.toTruffleStringUncached(unix.getUsername()), unix.getUid(), unix.getGid(), homeDir, T_BIN_SH);
    }

    @ExportMessage
    public int socket(int domain, int type, int protocol, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
        if (PythonOptions.WITHOUT_JAVA_INET || this.withoutIOSocket) {
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException("socket was excluded");
        }
        if (domain != PosixConstants.AF_INET.value && domain != PosixConstants.AF_INET6.value) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EAFNOSUPPORT);
        }
        if (type != PosixConstants.SOCK_DGRAM.value && type != PosixConstants.SOCK_STREAM.value) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EINVAL);
        }
        try {
            EmulatedSocket socket = type == PosixConstants.SOCK_DGRAM.value ? new EmulatedDatagramSocket(domain, protocol) : new EmulatedStreamSocket(domain, protocol);
            return this.assignFileDescriptor(socket);
        }
        catch (Exception e) {
            throw EmulatedPosixSupport.posixException(e, eqNode);
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public PosixSupportLibrary.AcceptResult accept(int sockfd) throws PosixSupportLibrary.PosixException {
        if (PythonOptions.WITHOUT_JAVA_INET || this.withoutIOSocket) {
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException("accept was excluded");
        }
        EmulatedSocket socket = this.getEmulatedSocket(sockfd);
        EmulatedSocket c = null;
        try {
            c = socket.accept();
            EmulatedUniversalSockAddrImpl addr = EmulatedUniversalSockAddrImpl.fromSocketAddress(socket.family, c.getPeerName());
            int fd = this.assignFileDescriptor(c);
            c = null;
            PosixSupportLibrary.AcceptResult acceptResult = new PosixSupportLibrary.AcceptResult(fd, addr);
            return acceptResult;
        }
        catch (Exception e) {
            throw EmulatedPosixSupport.posixException(e, TruffleString.EqualNode.getUncached());
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public void bind(int sockfd, PosixSupportLibrary.UniversalSockAddr addr) throws PosixSupportLibrary.PosixException {
        if (PythonOptions.WITHOUT_JAVA_INET || this.withoutIOSocket) {
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException("bind was excluded");
        }
        EmulatedSocket socket = this.getEmulatedSocket(sockfd);
        EmulatedUniversalSockAddrImpl usa = (EmulatedUniversalSockAddrImpl)addr;
        if (socket.family != usa.getFamily()) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EINVAL);
        }
        try {
            socket.bind(usa.socketAddress);
        }
        catch (Exception e) {
            throw EmulatedPosixSupport.posixException(e, TruffleString.EqualNode.getUncached());
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public void connect(int sockfd, PosixSupportLibrary.UniversalSockAddr addr) throws PosixSupportLibrary.PosixException {
        if (PythonOptions.WITHOUT_JAVA_INET || this.withoutIOSocket) {
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException("connect was excluded");
        }
        EmulatedSocket socket = this.getEmulatedSocket(sockfd);
        EmulatedUniversalSockAddrImpl usa = (EmulatedUniversalSockAddrImpl)addr;
        if (socket.family == PosixConstants.AF_INET.value && usa.getFamily() == PosixConstants.AF_INET6.value) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EINVAL);
        }
        try {
            socket.connect(usa.socketAddress);
        }
        catch (Exception e) {
            throw EmulatedPosixSupport.posixException(e, TruffleString.EqualNode.getUncached());
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public void listen(int sockfd, int backlog) throws PosixSupportLibrary.PosixException {
        if (PythonOptions.WITHOUT_JAVA_INET || this.withoutIOSocket) {
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException("listen was excluded");
        }
        EmulatedSocket socket = this.getEmulatedSocket(sockfd);
        try {
            socket.listen(backlog);
        }
        catch (Exception e) {
            throw EmulatedPosixSupport.posixException(e, TruffleString.EqualNode.getUncached());
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public PosixSupportLibrary.UniversalSockAddr getpeername(int sockfd) throws PosixSupportLibrary.PosixException {
        if (PythonOptions.WITHOUT_JAVA_INET || this.withoutIOSocket) {
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException("getpeername was excluded");
        }
        EmulatedSocket socket = this.getEmulatedSocket(sockfd);
        try {
            SocketAddress sa = socket.getPeerName();
            if (sa == null) {
                throw EmulatedPosixSupport.posixException(OSErrorEnum.ENOTCONN);
            }
            return EmulatedUniversalSockAddrImpl.fromSocketAddress(socket.family, sa);
        }
        catch (Exception e) {
            throw EmulatedPosixSupport.posixException(e, TruffleString.EqualNode.getUncached());
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public PosixSupportLibrary.UniversalSockAddr getsockname(int sockfd) throws PosixSupportLibrary.PosixException {
        EmulatedSocket socket = this.getEmulatedSocket(sockfd);
        try {
            SocketAddress sa = socket.getSockName();
            if (sa == null) {
                if (socket.family == PosixConstants.AF_INET.value) {
                    return EmulatedUniversalSockAddrImpl.inet4(new byte[4], 0);
                }
                return EmulatedUniversalSockAddrImpl.inet6(PosixConstants.IN6ADDR_ANY, 0, 0);
            }
            return EmulatedUniversalSockAddrImpl.fromSocketAddress(socket.family, sa);
        }
        catch (Exception e) {
            throw EmulatedPosixSupport.posixException(e, TruffleString.EqualNode.getUncached());
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public int send(int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
        if (PythonOptions.WITHOUT_JAVA_INET || this.withoutIOSocket) {
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException("send was excluded");
        }
        EmulatedSocket socket = this.getEmulatedSocket(sockfd);
        ByteBuffer bb = ByteBuffer.wrap(buf, offset, len);
        try {
            return socket.send(bb, flags);
        }
        catch (Exception e) {
            throw EmulatedPosixSupport.posixException(e, TruffleString.EqualNode.getUncached());
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public int sendto(int sockfd, byte[] buf, int offset, int len, int flags, PosixSupportLibrary.UniversalSockAddr destAddr) throws PosixSupportLibrary.PosixException {
        if (PythonOptions.WITHOUT_JAVA_INET || this.withoutIOSocket) {
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException("sendto was excluded");
        }
        EmulatedSocket socket = this.getEmulatedSocket(sockfd);
        EmulatedUniversalSockAddrImpl usa = (EmulatedUniversalSockAddrImpl)destAddr;
        if (socket.family == PosixConstants.AF_INET.value && usa.getFamily() == PosixConstants.AF_INET6.value) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EINVAL);
        }
        ByteBuffer bb = ByteBuffer.wrap(buf, offset, len);
        try {
            return socket.sendto(bb, flags, usa.socketAddress);
        }
        catch (Exception e) {
            throw EmulatedPosixSupport.posixException(e, TruffleString.EqualNode.getUncached());
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public int recv(int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
        if (PythonOptions.WITHOUT_JAVA_INET || this.withoutIOSocket) {
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException("recv was excluded");
        }
        EmulatedSocket socket = this.getEmulatedSocket(sockfd);
        ByteBuffer bb = ByteBuffer.wrap(buf, offset, len);
        try {
            return socket.recv(bb, flags);
        }
        catch (Exception e) {
            throw EmulatedPosixSupport.posixException(e, TruffleString.EqualNode.getUncached());
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public PosixSupportLibrary.RecvfromResult recvfrom(int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
        if (PythonOptions.WITHOUT_JAVA_INET || this.withoutIOSocket) {
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException("recvfrom was excluded");
        }
        EmulatedSocket socket = this.getEmulatedSocket(sockfd);
        ByteBuffer bb = ByteBuffer.wrap(buf, offset, len);
        try {
            SocketAddress sa = socket.recvfrom(bb, flags);
            return new PosixSupportLibrary.RecvfromResult(bb.position(), EmulatedUniversalSockAddrImpl.fromSocketAddress(socket.family, sa));
        }
        catch (Exception e) {
            throw EmulatedPosixSupport.posixException(e, TruffleString.EqualNode.getUncached());
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public void shutdown(int sockfd, int how) throws PosixSupportLibrary.PosixException {
        EmulatedSocket socket = this.getEmulatedSocket(sockfd);
        try {
            socket.shutdown(how);
        }
        catch (Exception e) {
            throw EmulatedPosixSupport.posixException(e, TruffleString.EqualNode.getUncached());
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public int getsockopt(int sockfd, int level, int optname, byte[] optval, int optlen) throws PosixSupportLibrary.PosixException {
        if (PythonOptions.WITHOUT_JAVA_INET || this.withoutIOSocket) {
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException("getsockopt was excluded");
        }
        assert (optval.length >= optlen);
        EmulatedSocket socket = this.getEmulatedSocket(sockfd);
        try {
            if (level == PosixConstants.SOL_SOCKET.value) {
                if (optname == PosixConstants.SO_TYPE.value) {
                    return EmulatedPosixSupport.encodeIntOptVal(optval, optlen, socket instanceof EmulatedDatagramSocket ? PosixConstants.SOCK_DGRAM.value : PosixConstants.SOCK_STREAM.value);
                }
                if (PosixConstants.SO_DOMAIN.defined && optname == PosixConstants.SO_DOMAIN.getValueIfDefined()) {
                    return EmulatedPosixSupport.encodeIntOptVal(optval, optlen, socket.family);
                }
                if (PosixConstants.SO_PROTOCOL.defined && optname == PosixConstants.SO_PROTOCOL.getValueIfDefined()) {
                    return EmulatedPosixSupport.encodeIntOptVal(optval, optlen, socket.protocol);
                }
                if (optname == PosixConstants.SO_KEEPALIVE.value) {
                    return EmulatedPosixSupport.encodeBooleanOptVal(optval, optlen, socket.getsockopt(StandardSocketOptions.SO_KEEPALIVE));
                }
                if (optname == PosixConstants.SO_REUSEADDR.value) {
                    return EmulatedPosixSupport.encodeBooleanOptVal(optval, optlen, socket.getsockopt(StandardSocketOptions.SO_REUSEADDR));
                }
                if (optname == PosixConstants.SO_SNDBUF.value) {
                    return EmulatedPosixSupport.encodeIntOptVal(optval, optlen, socket.getsockopt(StandardSocketOptions.SO_SNDBUF));
                }
                if (optname == PosixConstants.SO_RCVBUF.value) {
                    return EmulatedPosixSupport.encodeIntOptVal(optval, optlen, socket.getsockopt(StandardSocketOptions.SO_RCVBUF));
                }
                if (optname == PosixConstants.SO_BROADCAST.value) {
                    return EmulatedPosixSupport.encodeBooleanOptVal(optval, optlen, socket.getsockopt(StandardSocketOptions.SO_BROADCAST));
                }
            } else if (level == PosixConstants.IPPROTO_TCP.value && PosixConstants.TCP_NODELAY.defined && optname == PosixConstants.TCP_NODELAY.getValueIfDefined()) {
                return EmulatedPosixSupport.encodeBooleanOptVal(optval, optlen, socket.getsockopt(StandardSocketOptions.TCP_NODELAY));
            }
            throw EmulatedPosixSupport.posixException(OSErrorEnum.ENOPROTOOPT);
        }
        catch (UnsupportedOperationException e) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.ENOPROTOOPT);
        }
        catch (Exception e) {
            throw EmulatedPosixSupport.posixException(e, TruffleString.EqualNode.getUncached());
        }
    }

    private static ByteArraySupport nativeByteArraySupport() {
        return ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? ByteArraySupport.littleEndian() : ByteArraySupport.bigEndian();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public void setsockopt(int sockfd, int level, int optname, byte[] optval, int optlen) throws PosixSupportLibrary.PosixException {
        block12: {
            if (PythonOptions.WITHOUT_JAVA_INET || this.withoutIOSocket) {
                throw new PosixSupportLibrary.UnsupportedPosixFeatureException("setsockopt was excluded");
            }
            EmulatedSocket s = this.getEmulatedSocket(sockfd);
            try {
                if (level == PosixConstants.SOL_SOCKET.value) {
                    if (optname == PosixConstants.SO_KEEPALIVE.value) {
                        s.setsockopt(StandardSocketOptions.SO_KEEPALIVE, EmulatedPosixSupport.decodeBooleanOptVal(optval, optlen));
                        break block12;
                    }
                    if (optname == PosixConstants.SO_REUSEADDR.value) {
                        s.setsockopt(StandardSocketOptions.SO_REUSEADDR, EmulatedPosixSupport.decodeBooleanOptVal(optval, optlen));
                        break block12;
                    }
                    if (optname == PosixConstants.SO_SNDBUF.value) {
                        s.setsockopt(StandardSocketOptions.SO_SNDBUF, EmulatedPosixSupport.decodeIntOptVal(optval, optlen));
                        break block12;
                    }
                    if (optname == PosixConstants.SO_RCVBUF.value) {
                        s.setsockopt(StandardSocketOptions.SO_RCVBUF, EmulatedPosixSupport.decodeIntOptVal(optval, optlen));
                        break block12;
                    }
                    if (optname == PosixConstants.SO_BROADCAST.value) {
                        s.setsockopt(StandardSocketOptions.SO_BROADCAST, EmulatedPosixSupport.decodeBooleanOptVal(optval, optlen));
                        break block12;
                    }
                    throw EmulatedPosixSupport.posixException(OSErrorEnum.ENOPROTOOPT);
                }
                if (level == PosixConstants.IPPROTO_TCP.value) {
                    if (PosixConstants.TCP_NODELAY.defined && optname == PosixConstants.TCP_NODELAY.getValueIfDefined()) {
                        s.setsockopt(StandardSocketOptions.TCP_NODELAY, EmulatedPosixSupport.decodeBooleanOptVal(optval, optlen));
                        break block12;
                    }
                    throw EmulatedPosixSupport.posixException(OSErrorEnum.ENOPROTOOPT);
                }
                throw EmulatedPosixSupport.posixException(OSErrorEnum.ENOPROTOOPT);
            }
            catch (UnsupportedOperationException e) {
                throw EmulatedPosixSupport.posixException(OSErrorEnum.ENOPROTOOPT);
            }
            catch (Exception e) {
                throw EmulatedPosixSupport.posixException(e, TruffleString.EqualNode.getUncached());
            }
        }
    }

    private static int encodeIntOptVal(byte[] optval, int optlen, int value) {
        if (optlen < 4) {
            byte[] tmp = new byte[4];
            EmulatedPosixSupport.nativeByteArraySupport().putInt(tmp, 0, value);
            PythonUtils.arraycopy(tmp, 0, optval, 0, optlen);
        } else {
            EmulatedPosixSupport.nativeByteArraySupport().putInt(optval, 0, value);
        }
        return 4;
    }

    private static int encodeBooleanOptVal(byte[] optval, int optlen, boolean value) {
        return EmulatedPosixSupport.encodeIntOptVal(optval, optlen, value ? 1 : 0);
    }

    private static int decodeIntOptVal(byte[] optval, int optlen) throws PosixSupportLibrary.PosixException {
        assert (optval.length >= optlen);
        if (optlen != 4) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EINVAL);
        }
        return EmulatedPosixSupport.nativeByteArraySupport().getInt(optval, 0);
    }

    private static boolean decodeBooleanOptVal(byte[] optval, int optlen) throws PosixSupportLibrary.PosixException {
        return EmulatedPosixSupport.decodeIntOptVal(optval, optlen) != 0;
    }

    @ExportMessage
    public int inet_addr(Object src) {
        try {
            return this.inet_aton(src);
        }
        catch (PosixSupportLibrary.InvalidAddressException e) {
            return PosixConstants.INADDR_NONE.value;
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public int inet_aton(Object src) throws PosixSupportLibrary.InvalidAddressException {
        String s = (String)src;
        if (s.charAt(0) == '.' || s.charAt(s.length() - 1) == '.') {
            throw new PosixSupportLibrary.InvalidAddressException();
        }
        String[] parts = s.split("\\.");
        switch (parts.length) {
            case 1: {
                return EmulatedPosixSupport.parseUnsigned(parts[0], 0xFFFFFFFFL);
            }
            case 2: {
                return EmulatedPosixSupport.parseUnsigned(parts[0], 255L) << 24 | EmulatedPosixSupport.parseUnsigned(parts[1], 0xFFFFFFL);
            }
            case 3: {
                return EmulatedPosixSupport.parseUnsigned(parts[0], 255L) << 24 | EmulatedPosixSupport.parseUnsigned(parts[1], 255L) << 16 | EmulatedPosixSupport.parseUnsigned(parts[2], 65535L);
            }
            case 4: {
                return EmulatedPosixSupport.parseUnsigned(parts[0], 255L) << 24 | EmulatedPosixSupport.parseUnsigned(parts[1], 255L) << 16 | EmulatedPosixSupport.parseUnsigned(parts[2], 255L) << 8 | EmulatedPosixSupport.parseUnsigned(parts[3], 255L);
            }
        }
        throw new PosixSupportLibrary.InvalidAddressException();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public Object inet_ntoa(int address) {
        return String.format("%d.%d.%d.%d", address >> 24 & 0xFF, address >> 16 & 0xFF, address >> 8 & 0xFF, address & 0xFF);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public byte[] inet_pton(int family, Object src) throws PosixSupportLibrary.PosixException, PosixSupportLibrary.InvalidAddressException {
        if (family == PosixConstants.AF_INET.value) {
            String s = (String)src;
            String[] parts = s.split("\\.");
            if (s.charAt(0) == '.' || s.charAt(s.length() - 1) == '.' || parts.length != 4) {
                throw new PosixSupportLibrary.InvalidAddressException();
            }
            byte[] bytes = new byte[4];
            for (int i = 0; i < 4; ++i) {
                if (parts[i].charAt(0) == '0') {
                    throw new PosixSupportLibrary.InvalidAddressException();
                }
                bytes[i] = (byte)EmulatedPosixSupport.parseUnsigned(parts[i], 10, 255L);
            }
            return bytes;
        }
        if (family == PosixConstants.AF_INET6.value) {
            byte[] bytes = IPAddressUtil.textToNumericFormatV6((String)src);
            if (bytes == null) {
                throw new PosixSupportLibrary.InvalidAddressException();
            }
            if (bytes.length == 4) {
                return EmulatedPosixSupport.mapIPv4toIPv6(bytes);
            }
            return bytes;
        }
        throw EmulatedPosixSupport.posixException(OSErrorEnum.EAFNOSUPPORT);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public Object inet_ntop(int family, byte[] src) throws PosixSupportLibrary.PosixException {
        int len;
        if (family != PosixConstants.AF_INET.value && family != PosixConstants.AF_INET6.value) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EAFNOSUPPORT);
        }
        int n = len = family == PosixConstants.AF_INET.value ? 4 : 16;
        if (src.length < len) {
            throw new IllegalArgumentException();
        }
        byte[] bytes = src.length > len ? PythonUtils.arrayCopyOf(src, len) : src;
        try {
            InetAddress addr = InetAddress.getByAddress(bytes);
            if (family == PosixConstants.AF_INET6.value && addr instanceof Inet4Address) {
                return "::ffff:" + addr.getHostAddress();
            }
            return addr.getHostAddress();
        }
        catch (UnknownHostException e) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @ExportMessage
    public Object gethostname() throws PosixSupportLibrary.PosixException {
        return EmulatedPosixSupport.getHostName(this.withoutIOSocket);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public Object[] getnameinfo(PosixSupportLibrary.UniversalSockAddr addr, int flags) throws PosixSupportLibrary.GetAddrInfoException {
        if (PythonOptions.WITHOUT_JAVA_INET || this.withoutIOSocket) {
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException("getnameinfo was excluded");
        }
        InetSocketAddress sa = ((EmulatedUniversalSockAddrImpl)addr).socketAddress;
        InetAddress a = sa.getAddress();
        int port = sa.getPort();
        String host = (flags & PosixConstants.NI_NUMERICHOST.value) == PosixConstants.NI_NUMERICHOST.value ? a.getHostAddress() : a.getCanonicalHostName();
        if ((flags & PosixConstants.NI_NAMEREQD.value) == PosixConstants.NI_NAMEREQD.value && host.equals(a.getHostAddress())) {
            throw EmulatedPosixSupport.gaiError(PosixConstants.EAI_NONAME.value);
        }
        String service = null;
        if ((flags & PosixConstants.NI_NUMERICSERV.value) != PosixConstants.NI_NUMERICSERV.value) {
            String protocol = (flags & PosixConstants.NI_DGRAM.value) != 0 ? "udp" : "tcp";
            service = this.searchServicesForPort(this.context.getEnv(), port, protocol);
        }
        if (service == null) {
            service = String.valueOf(port);
        }
        return new Object[]{host, service};
    }

    @CompilerDirectives.TruffleBoundary
    private String searchServicesForPort(TruffleLanguage.Env env, int port, String protocol) {
        Map<String, List<Service>> services = this.getServices();
        Set<String> servicesNames = services.keySet();
        for (String servName : servicesNames) {
            List<Service> serv = services.get(servName);
            for (Service servProto : serv) {
                if (servProto.port != port || protocol != null && !protocol.equals(servProto.protocol)) continue;
                return servName;
            }
        }
        return null;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public PosixSupportLibrary.AddrInfoCursor getaddrinfo(Object node, Object service, int family, int sockType, int protocol, int flags) throws PosixSupportLibrary.GetAddrInfoException {
        int port;
        if (PythonOptions.WITHOUT_JAVA_INET || this.withoutIOSocket) {
            throw new PosixSupportLibrary.UnsupportedPosixFeatureException("getaddrinfo was excluded");
        }
        if (node == null && service == null) {
            throw EmulatedPosixSupport.gaiError(PosixConstants.EAI_NONAME.value);
        }
        if (family != PosixConstants.AF_UNSPEC.value && family != PosixConstants.AF_INET.value && family != PosixConstants.AF_INET6.value) {
            throw EmulatedPosixSupport.gaiError(PosixConstants.EAI_FAMILY.value);
        }
        if (sockType != 0 && sockType != PosixConstants.SOCK_DGRAM.value && sockType != PosixConstants.SOCK_STREAM.value) {
            throw EmulatedPosixSupport.gaiError(PosixConstants.EAI_SOCKTYPE.value);
        }
        if (node == null && (flags & PosixConstants.AI_CANONNAME.value) != 0) {
            throw EmulatedPosixSupport.gaiError(PosixConstants.EAI_BADFLAGS.value);
        }
        boolean ip4 = family == PosixConstants.AF_UNSPEC.value || family == PosixConstants.AF_INET.value;
        boolean ip6 = family == PosixConstants.AF_UNSPEC.value || family == PosixConstants.AF_INET6.value;
        boolean udp = sockType == 0 && (protocol == 0 || protocol == PosixConstants.IPPROTO_UDP.value) || sockType == PosixConstants.SOCK_DGRAM.value;
        boolean tcp = sockType == 0 && (protocol == 0 || protocol == PosixConstants.IPPROTO_TCP.value) || sockType == PosixConstants.SOCK_STREAM.value;
        ArrayList<InetAddress> addresses = null;
        if (node != null || (flags & PosixConstants.AI_PASSIVE.value) == 0) {
            InetAddress[] addrs;
            try {
                addrs = InetAddress.getAllByName((String)node);
            }
            catch (UnknownHostException e) {
                throw EmulatedPosixSupport.gaiError(PosixConstants.EAI_NONAME.value);
            }
            addresses = new ArrayList<InetAddress>();
            for (InetAddress a : addrs) {
                if ((!ip4 || !(a instanceof Inet4Address)) && (!ip6 || !(a instanceof Inet6Address))) continue;
                addresses.add(a);
            }
            if (addresses.isEmpty()) {
                throw EmulatedPosixSupport.gaiError(PosixConstants.EAI_ADDRFAMILY.value);
            }
        }
        ArrayList<Service> serviceList = new ArrayList<Service>();
        if (service == null) {
            port = 0;
        } else {
            try {
                port = Integer.parseInt((String)service);
            }
            catch (NumberFormatException e) {
                if ((flags & PosixConstants.AI_NUMERICSERV.value) != 0) {
                    throw EmulatedPosixSupport.gaiError(PosixConstants.EAI_NONAME.value);
                }
                port = -1;
            }
        }
        if (port >= 0 && port <= 65535) {
            if (udp) {
                serviceList.add(new Service(port, "udp"));
            }
            if (tcp) {
                serviceList.add(new Service(port, "tcp"));
            }
        } else {
            List<Service> ss = this.getServices().get(service);
            if (ss != null) {
                for (Service s : ss) {
                    if ((!udp || !"udp".equals(s.protocol)) && (!tcp || !"tcp".equals(s.protocol))) continue;
                    serviceList.add(s);
                }
            }
        }
        if (serviceList.isEmpty()) {
            throw EmulatedPosixSupport.gaiError(PosixConstants.EAI_SERVICE.value);
        }
        ArrayList<EmulatedAddrInfoCursorImpl.Item> items = new ArrayList<EmulatedAddrInfoCursorImpl.Item>();
        if (addresses == null) {
            for (Service s : serviceList) {
                if (ip4) {
                    items.add(new EmulatedAddrInfoCursorImpl.Item(PosixConstants.AF_INET.value, null, s));
                }
                if (!ip6) continue;
                items.add(new EmulatedAddrInfoCursorImpl.Item(PosixConstants.AF_INET6.value, null, s));
            }
        } else {
            for (InetAddress a : addresses) {
                for (Service s : serviceList) {
                    items.add(new EmulatedAddrInfoCursorImpl.Item(a instanceof Inet4Address ? PosixConstants.AF_INET.value : PosixConstants.AF_INET6.value, a, s));
                }
            }
        }
        String canonName = null;
        if ((flags & PosixConstants.AI_CANONNAME.value) != 0) {
            assert (addresses != null && !addresses.isEmpty());
            canonName = ((InetAddress)addresses.get(0)).getHostName();
        }
        return new EmulatedAddrInfoCursorImpl(items.iterator(), canonName, protocol, flags);
    }

    @ExportMessage
    PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrInet4(PosixSupportLibrary.Inet4SockAddr src) {
        return EmulatedUniversalSockAddrImpl.inet4(src.getAddressAsBytes(), src.getPort());
    }

    @ExportMessage
    PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrInet6(PosixSupportLibrary.Inet6SockAddr src) {
        return EmulatedUniversalSockAddrImpl.inet6(src.getAddress(), src.getScopeId(), src.getPort());
    }

    @ExportMessage
    PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrUnix(PosixSupportLibrary.UnixSockAddr src) {
        throw new PosixSupportLibrary.UnsupportedPosixFeatureException("AF_UNIX cannot be emulated");
    }

    private static StandardProtocolFamily mapFamily(int family) {
        assert (family == PosixConstants.AF_INET.value || family == PosixConstants.AF_INET6.value);
        return family == PosixConstants.AF_INET.value ? StandardProtocolFamily.INET : StandardProtocolFamily.INET6;
    }

    private EmulatedSocket getEmulatedSocket(int fd) throws PosixSupportLibrary.PosixException {
        CompilerAsserts.neverPartOfCompilation();
        Channel channel = this.getChannel(fd);
        if (channel == null) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EBADF);
        }
        if (channel instanceof EmulatedSocket) {
            return (EmulatedSocket)channel;
        }
        throw EmulatedPosixSupport.posixException(OSErrorEnum.ENOTSOCK);
    }

    private static int parseUnsigned(String value, long max) throws PosixSupportLibrary.InvalidAddressException {
        if (value.startsWith("0x") || value.startsWith("0X")) {
            return EmulatedPosixSupport.parseUnsigned(value.substring(2), 16, max);
        }
        if (value.startsWith("0")) {
            return EmulatedPosixSupport.parseUnsigned(value, 8, max);
        }
        return EmulatedPosixSupport.parseUnsigned(value, 10, max);
    }

    private static int parseUnsigned(String value, int radix, long max) throws PosixSupportLibrary.InvalidAddressException {
        try {
            long l = Long.parseUnsignedLong(value, radix);
            if (l < 0L || l > max) {
                throw new PosixSupportLibrary.InvalidAddressException();
            }
            return (int)l;
        }
        catch (NumberFormatException e) {
            throw new PosixSupportLibrary.InvalidAddressException();
        }
    }

    private static byte[] mapIPv4toIPv6(byte[] ipv4) {
        byte[] ipv6 = new byte[16];
        ipv6[10] = -1;
        ipv6[11] = -1;
        System.arraycopy(ipv4, 0, ipv6, 12, 4);
        return ipv6;
    }

    @ExportMessage
    public Object createPathFromString(TruffleString path, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
        return EmulatedPosixSupport.checkEmbeddedNulls(toJavaStringNode.execute((AbstractTruffleString)path));
    }

    @ExportMessage
    public Object createPathFromBytes(byte[] path) {
        return EmulatedPosixSupport.checkEmbeddedNulls(EmulatedPosixSupport.createUTF8String(path));
    }

    @ExportMessage
    public TruffleString getPathAsString(Object path, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        return fromJavaStringNode.execute((String)path, PythonUtils.TS_ENCODING);
    }

    @ExportMessage
    public PosixSupportLibrary.Buffer getPathAsBytes(Object path) {
        return PosixSupportLibrary.Buffer.wrap(EmulatedPosixSupport.utf8StringToBytes((String)path));
    }

    @CompilerDirectives.TruffleBoundary
    private static String createUTF8String(byte[] retbuf) {
        return new String(retbuf, StandardCharsets.UTF_8);
    }

    @CompilerDirectives.TruffleBoundary
    private static byte[] utf8StringToBytes(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    private static String checkEmbeddedNulls(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\u0000') continue;
            return null;
        }
        return s;
    }

    private synchronized Map<String, List<Service>> getServices() {
        if (this.etcServices == null) {
            this.etcServices = EmulatedPosixSupport.parseServices(this.context.getEnv());
        }
        return this.etcServices;
    }

    @CompilerDirectives.TruffleBoundary
    private static Map<String, List<Service>> parseServices(TruffleLanguage.Env env) {
        TruffleFile services_file = env.getPublicTruffleFile("/etc/services");
        try {
            String line;
            BufferedReader br = services_file.newBufferedReader();
            HashMap<String, List<Service>> parsedServices = new HashMap<String, List<Service>>();
            while ((line = br.readLine()) != null) {
                String[] service = EmulatedPosixSupport.cleanLine(line);
                if (service == null) continue;
                String[] portAndProtocol = service[1].split("/");
                List serviceObj = parsedServices.computeIfAbsent(service[0], k -> new LinkedList());
                Service newService = new Service(Integer.parseInt(portAndProtocol[0]), portAndProtocol[1]);
                serviceObj.add(newService);
                if (service.length <= 2) continue;
                for (int i = 2; i < service.length; ++i) {
                    serviceObj = parsedServices.computeIfAbsent(service[i], k -> new LinkedList());
                    serviceObj.add(newService);
                }
            }
            return parsedServices;
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    private static String[] cleanLine(String input) {
        String line = input;
        if (line.startsWith("#")) {
            return null;
        }
        if ((line = line.replaceAll("\\s+", " ")).startsWith(" ")) {
            return null;
        }
        String[] words = (line = line.split("#")[0]).split(" ");
        if (words.length < 2) {
            return null;
        }
        return words;
    }

    private static PosixSupportLibrary.GetAddrInfoException gaiError(int err) throws PosixSupportLibrary.GetAddrInfoException {
        String msg;
        if (err == PosixConstants.EAI_NONAME.value) {
            msg = "Name or service not known";
        } else if (err == PosixConstants.EAI_FAMILY.value) {
            msg = "ai_family not supported";
        } else if (err == PosixConstants.EAI_SOCKTYPE.value) {
            msg = "ai_socktype not supported";
        } else if (err == PosixConstants.EAI_SERVICE.value) {
            msg = "Servname not supported for ai_socktype";
        } else if (err == PosixConstants.EAI_ADDRFAMILY.value) {
            msg = "Address family for hostname not supported";
        } else if (err == PosixConstants.EAI_BADFLAGS.value) {
            msg = "Bad value for ai_flags";
        } else {
            throw CompilerDirectives.shouldNotReachHere();
        }
        throw new PosixSupportLibrary.GetAddrInfoException(err, PythonUtils.toTruffleStringUncached(msg));
    }

    static PosixSupportLibrary.PosixException posixException(OSErrorEnum osError) throws PosixSupportLibrary.PosixException {
        throw new PosixSupportLibrary.PosixException(osError.getNumber(), osError.getMessage());
    }

    private static PosixSupportLibrary.PosixException posixException(Exception e, TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
        if (e instanceof PosixSupportLibrary.PosixException) {
            throw (PosixSupportLibrary.PosixException)e;
        }
        OSErrorEnum.ErrorAndMessagePair pair = OSErrorEnum.fromException(e, eqNode);
        throw new PosixSupportLibrary.PosixException(pair.oserror.getNumber(), pair.message);
    }

    private static PosixSupportLibrary.PosixException posixException(OSErrorEnum.ErrorAndMessagePair pair) throws PosixSupportLibrary.PosixException {
        throw new PosixSupportLibrary.PosixException(pair.oserror.getNumber(), pair.message);
    }

    @CompilerDirectives.TruffleBoundary
    static long fileTimeToSeconds(FileTime t) {
        return t.to(TimeUnit.SECONDS);
    }

    @CompilerDirectives.TruffleBoundary
    static long fileTimeNanoSecondsPart(FileTime t) {
        return t.toInstant().getNano();
    }

    private TruffleFile getTruffleFile(TruffleString path, TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
        try {
            return this.context.getPublicTruffleFileRelaxed(path, PythonLanguage.T_DEFAULT_PYTHON_EXTENSIONS);
        }
        catch (Exception ex) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(ex, eqNode));
        }
    }

    private TruffleFile resolvePath(Node inliningTarget, int dirFd, TruffleString pathname, InlinedConditionProfile defaultDirFdPofile, TruffleString.EqualNode eqNode, TruffleString.ToJavaStringNode toJavaStringNode) throws PosixSupportLibrary.PosixException {
        if (defaultDirFdPofile.profile(inliningTarget, dirFd == PosixConstants.AT_FDCWD.value)) {
            return this.getTruffleFile(pathname, eqNode);
        }
        TruffleFile file = this.getTruffleFile(pathname, eqNode);
        if (file.isAbsolute()) {
            return file;
        }
        TruffleString dirPath = this.getFilePathOrDefault(dirFd, null);
        if (dirPath == null) {
            throw EmulatedPosixSupport.posixException(OSErrorEnum.EBADF);
        }
        TruffleFile dir = this.getTruffleFile(dirPath, eqNode);
        return dir.resolve(toJavaStringNode.execute((AbstractTruffleString)pathname));
    }

    private static TruffleString pathToTruffleString(Object path, TruffleString.FromJavaStringNode fromJavaStringNode) {
        return fromJavaStringNode.execute((String)path, PythonUtils.TS_ENCODING);
    }

    private static String pathToJavaString(Object path) {
        return (String)path;
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private TruffleString getFilePathOrDefault(int fd, String defaultValue) {
        String path = this.filePaths.getOrDefault(fd, defaultValue);
        return path != null ? PythonUtils.toTruffleStringUncached(path) : null;
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static FileAttribute<Set<PosixFilePermission>> modeToAttributes(int fileMode) {
        Set<PosixFilePermission> perms = EmulatedPosixSupport.modeToPosixFilePermissions(fileMode);
        return PosixFilePermissions.asFileAttribute(perms);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static Set<PosixFilePermission> modeToPosixFilePermissions(int fileMode) {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>(Arrays.asList(ownerBitsToPermission[fileMode >> 6 & 7]));
        perms.addAll(Arrays.asList(groupBitsToPermission[fileMode >> 3 & 7]));
        perms.addAll(Arrays.asList(otherBitsToPermission[fileMode & 7]));
        return perms;
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static Set<StandardOpenOption> flagsToOptions(int flags) {
        HashSet<StandardOpenOption> options = new HashSet<StandardOpenOption>();
        int maskedFlags = flags & (PosixConstants.O_RDONLY.value | PosixConstants.O_WRONLY.value | PosixConstants.O_RDWR.value);
        if ((flags & PosixConstants.O_APPEND.value) != 0) {
            options.add(StandardOpenOption.WRITE);
            options.add(StandardOpenOption.APPEND);
        } else if (maskedFlags == PosixConstants.O_WRONLY.value) {
            options.add(StandardOpenOption.WRITE);
        } else if (maskedFlags == PosixConstants.O_RDWR.value) {
            options.add(StandardOpenOption.READ);
            options.add(StandardOpenOption.WRITE);
        } else if (maskedFlags == PosixConstants.O_RDONLY.value) {
            options.add(StandardOpenOption.READ);
        }
        if ((flags & PosixConstants.O_CREAT.value) != 0) {
            options.add(StandardOpenOption.WRITE);
            options.add(StandardOpenOption.CREATE);
        }
        if ((flags & PosixConstants.O_EXCL.value) != 0) {
            options.add(StandardOpenOption.WRITE);
            options.add(StandardOpenOption.CREATE_NEW);
        }
        if (PosixConstants.O_NDELAY.defined && (flags & PosixConstants.O_NDELAY.getValueIfDefined()) != 0 || PosixConstants.O_DIRECT.defined && (flags & PosixConstants.O_DIRECT.getValueIfDefined()) != 0) {
            options.add(StandardOpenOption.DSYNC);
        }
        if (PosixConstants.O_SYNC.defined && (flags & PosixConstants.O_SYNC.getValueIfDefined()) != 0) {
            options.add(StandardOpenOption.SYNC);
        }
        if ((flags & PosixConstants.O_TRUNC.value) != 0) {
            options.add(StandardOpenOption.WRITE);
            options.add(StandardOpenOption.TRUNCATE_EXISTING);
        }
        if (PosixConstants.O_TMPFILE.defined && (flags & PosixConstants.O_TMPFILE.getValueIfDefined()) != 0) {
            options.add(StandardOpenOption.DELETE_ON_CLOSE);
        }
        return options;
    }

    public static LinkOption[] getLinkOptions(boolean followSymlinks) {
        LinkOption[] linkOptionArray;
        if (followSymlinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        return linkOptionArray;
    }

    public static void compatibilityInfo(String fmt, Object ... args) {
        if (COMPATIBILITY_LOGGER.isLoggable(Level.FINER)) {
            COMPATIBILITY_LOGGER.log(Level.FINER, PythonUtils.formatJString(fmt, args));
        }
    }

    public static void compatibilityIgnored(String fmt, Object ... args) {
        if (COMPATIBILITY_LOGGER.isLoggable(Level.FINE)) {
            COMPATIBILITY_LOGGER.log(Level.FINE, EmulatedPosixSupport.getIgnoredMessage(fmt, args));
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static String getIgnoredMessage(String fmt, Object[] args) {
        return "Ignored: " + String.format(fmt, args);
    }

    private TruffleString getFilePath(int fd, TruffleString.FromJavaStringNode fromJavaStringNode) {
        String path = this.getFilePath(fd);
        return path != null ? fromJavaStringNode.execute(path, PythonUtils.TS_ENCODING) : null;
    }

    private static final class EmulatedDatagramSocket
    extends EmulatedSocket {
        private final DatagramChannel channel;

        @CompilerDirectives.TruffleBoundary
        EmulatedDatagramSocket(int family, int protocol) throws IOException {
            super(family, protocol == 0 ? PosixConstants.IPPROTO_UDP.value : protocol);
            this.channel = DatagramChannel.open(EmulatedPosixSupport.mapFamily(family));
        }

        @Override
        public boolean isOpen() {
            CompilerAsserts.neverPartOfCompilation();
            return this.channel.isOpen();
        }

        @Override
        public void close() throws IOException {
            CompilerAsserts.neverPartOfCompilation();
            this.channel.close();
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            CompilerAsserts.neverPartOfCompilation();
            int start = dst.position();
            if (this.channel.receive(dst) == null) {
                throw new OSErrorEnum.OperationWouldBlockException();
            }
            return dst.position() - start;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            CompilerAsserts.neverPartOfCompilation();
            return this.channel.write(src);
        }

        @Override
        EmulatedSocket accept() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        void bind(SocketAddress socketAddress) throws IOException {
            CompilerAsserts.neverPartOfCompilation();
            this.channel.bind(socketAddress);
        }

        @Override
        void connect(SocketAddress socketAddress) throws IOException {
            CompilerAsserts.neverPartOfCompilation();
            this.channel.connect(socketAddress);
        }

        @Override
        void listen(int backlog) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        SocketAddress getPeerName() throws IOException {
            CompilerAsserts.neverPartOfCompilation();
            return this.channel.getRemoteAddress();
        }

        @Override
        SocketAddress getSockName() throws IOException {
            CompilerAsserts.neverPartOfCompilation();
            return this.channel.getLocalAddress();
        }

        @Override
        int recv(ByteBuffer bb, int flags) throws IOException {
            CompilerAsserts.neverPartOfCompilation();
            int start = bb.position();
            if (this.channel.receive(bb) == null) {
                throw new OSErrorEnum.OperationWouldBlockException();
            }
            return bb.position() - start;
        }

        @Override
        SocketAddress recvfrom(ByteBuffer bb, int flags) throws IOException {
            CompilerAsserts.neverPartOfCompilation();
            SocketAddress addr = this.channel.receive(bb);
            if (addr == null) {
                throw new OSErrorEnum.OperationWouldBlockException();
            }
            return addr;
        }

        @Override
        int send(ByteBuffer bb, int flags) throws IOException {
            CompilerAsserts.neverPartOfCompilation();
            return this.channel.write(bb);
        }

        @Override
        int sendto(ByteBuffer bb, int flags, SocketAddress destAddr) throws IOException {
            CompilerAsserts.neverPartOfCompilation();
            return this.channel.send(bb, destAddr);
        }

        @Override
        void shutdown(int how) throws IOException {
        }

        @Override
        void configureBlocking(boolean block) throws IOException {
            CompilerAsserts.neverPartOfCompilation();
            this.channel.configureBlocking(block);
        }

        @Override
        boolean isBlocking() {
            CompilerAsserts.neverPartOfCompilation();
            return this.channel.isBlocking();
        }

        @Override
        <T> void setsockopt(SocketOption<T> option, T value) throws IOException {
            this.channel.setOption((SocketOption)option, (Object)value);
        }

        @Override
        <T> T getsockopt(SocketOption<T> option) throws IOException {
            return this.channel.getOption(option);
        }
    }

    private static final class EmulatedStreamSocket
    extends EmulatedSocket {
        private SocketChannel clientChannel;
        private ServerSocketChannel serverChannel;
        private SocketAddress bindAddress;
        private boolean blocking;
        private List<OptionWithValue> options;

        @CompilerDirectives.TruffleBoundary
        EmulatedStreamSocket(int family, int protocol) {
            super(family, protocol == 0 ? PosixConstants.IPPROTO_TCP.value : protocol);
            this.blocking = true;
        }

        private EmulatedStreamSocket(int family, int protocol, SocketChannel client) {
            super(family, protocol);
            this.clientChannel = client;
        }

        @Override
        public synchronized boolean isOpen() {
            CompilerAsserts.neverPartOfCompilation();
            if (this.clientChannel != null) {
                return this.clientChannel.isOpen();
            }
            if (this.serverChannel != null) {
                return this.serverChannel.isOpen();
            }
            return true;
        }

        @Override
        public synchronized void close() throws IOException {
            CompilerAsserts.neverPartOfCompilation();
            if (this.clientChannel != null) {
                this.clientChannel.close();
            } else if (this.serverChannel != null) {
                this.serverChannel.close();
            }
        }

        private synchronized SocketChannel getClientChannel() {
            if (this.clientChannel == null) {
                throw new NotYetConnectedException();
            }
            return this.clientChannel;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            CompilerAsserts.neverPartOfCompilation();
            int cnt = this.getClientChannel().read(dst);
            if (cnt == 0) {
                throw new OSErrorEnum.OperationWouldBlockException();
            }
            if (cnt == -1) {
                return 0;
            }
            return cnt;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            CompilerAsserts.neverPartOfCompilation();
            int cnt = this.getClientChannel().write(src);
            if (cnt == 0) {
                throw new OSErrorEnum.OperationWouldBlockException();
            }
            return cnt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        EmulatedStreamSocket accept() throws IOException {
            ServerSocketChannel s;
            CompilerAsserts.neverPartOfCompilation();
            EmulatedStreamSocket emulatedStreamSocket = this;
            synchronized (emulatedStreamSocket) {
                if (this.serverChannel == null) {
                    throw new IllegalArgumentException();
                }
                s = this.serverChannel;
            }
            SocketChannel client = s.accept();
            if (client == null) {
                throw new OSErrorEnum.OperationWouldBlockException();
            }
            return new EmulatedStreamSocket(this.family, this.protocol, client);
        }

        @Override
        synchronized void bind(SocketAddress socketAddress) throws IOException {
            CompilerAsserts.neverPartOfCompilation();
            if (this.clientChannel != null || this.serverChannel != null || this.bindAddress != null) {
                throw new IllegalArgumentException();
            }
            this.bindAddress = socketAddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void connect(SocketAddress socketAddress) throws IOException {
            List<OptionWithValue> opts;
            boolean block;
            SocketAddress addr;
            SocketChannel c;
            CompilerAsserts.neverPartOfCompilation();
            EmulatedStreamSocket emulatedStreamSocket = this;
            synchronized (emulatedStreamSocket) {
                if (this.clientChannel != null || this.serverChannel != null) {
                    throw new AlreadyConnectedException();
                }
                c = this.clientChannel = SocketChannel.open();
                addr = this.bindAddress;
                block = this.blocking;
                opts = this.options;
                this.options = null;
            }
            c.bind(addr);
            c.connect(socketAddress);
            c.configureBlocking(block);
            EmulatedStreamSocket.replayOptions(opts, c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void listen(int backlog) throws IOException {
            List<OptionWithValue> opts;
            boolean block;
            SocketAddress addr;
            ServerSocketChannel s;
            CompilerAsserts.neverPartOfCompilation();
            EmulatedStreamSocket emulatedStreamSocket = this;
            synchronized (emulatedStreamSocket) {
                if (this.clientChannel != null) {
                    throw new IllegalArgumentException();
                }
                if (this.serverChannel != null) {
                    return;
                }
                s = this.serverChannel = ServerSocketChannel.open();
                addr = this.bindAddress;
                block = this.blocking;
                opts = this.options;
                this.options = null;
            }
            s.bind(addr, backlog);
            s.configureBlocking(block);
            EmulatedStreamSocket.replayOptions(opts, s);
        }

        @Override
        SocketAddress getPeerName() throws IOException {
            CompilerAsserts.neverPartOfCompilation();
            return this.getClientChannel().getRemoteAddress();
        }

        @Override
        synchronized SocketAddress getSockName() throws IOException {
            CompilerAsserts.neverPartOfCompilation();
            if (this.clientChannel != null) {
                return this.clientChannel.getLocalAddress();
            }
            if (this.serverChannel != null) {
                return this.serverChannel.getLocalAddress();
            }
            return this.bindAddress;
        }

        @Override
        int recv(ByteBuffer bb, int flags) throws IOException {
            CompilerAsserts.neverPartOfCompilation();
            int cnt = this.getClientChannel().read(bb);
            if (cnt == 0) {
                throw new OSErrorEnum.OperationWouldBlockException();
            }
            if (cnt == -1) {
                return 0;
            }
            return cnt;
        }

        @Override
        SocketAddress recvfrom(ByteBuffer bb, int flags) throws IOException {
            CompilerAsserts.neverPartOfCompilation();
            int cnt = this.getClientChannel().read(bb);
            if (cnt == 0) {
                throw new OSErrorEnum.OperationWouldBlockException();
            }
            return null;
        }

        @Override
        int send(ByteBuffer bb, int flags) throws IOException {
            CompilerAsserts.neverPartOfCompilation();
            int cnt = this.getClientChannel().write(bb);
            if (cnt == 0) {
                throw new OSErrorEnum.OperationWouldBlockException();
            }
            return cnt;
        }

        @Override
        int sendto(ByteBuffer bb, int flags, SocketAddress destAddr) throws IOException {
            CompilerAsserts.neverPartOfCompilation();
            throw new AlreadyConnectedException();
        }

        @Override
        void shutdown(int how) throws IOException {
            CompilerAsserts.neverPartOfCompilation();
            SocketChannel c = this.getClientChannel();
            if (how == PosixConstants.SHUT_RD.value || how == PosixConstants.SHUT_RDWR.value) {
                c.shutdownInput();
            }
            if (how == PosixConstants.SHUT_WR.value || how == PosixConstants.SHUT_RDWR.value) {
                c.shutdownOutput();
            }
        }

        @Override
        synchronized void configureBlocking(boolean block) throws IOException {
            CompilerAsserts.neverPartOfCompilation();
            if (this.clientChannel != null) {
                this.clientChannel.configureBlocking(block);
            } else if (this.serverChannel != null) {
                this.serverChannel.configureBlocking(block);
            } else {
                this.blocking = block;
            }
        }

        @Override
        synchronized boolean isBlocking() {
            CompilerAsserts.neverPartOfCompilation();
            if (this.clientChannel != null) {
                return this.clientChannel.isBlocking();
            }
            if (this.serverChannel != null) {
                return this.serverChannel.isBlocking();
            }
            return this.blocking;
        }

        @Override
        synchronized <T> void setsockopt(SocketOption<T> option, T value) throws IOException {
            if (this.clientChannel != null) {
                this.clientChannel.setOption((SocketOption)option, (Object)value);
            } else if (this.serverChannel != null) {
                this.serverChannel.setOption((SocketOption)option, (Object)value);
            } else if (this.options == null) {
                this.options = new ArrayList<OptionWithValue>();
                this.options.add(new OptionWithValue(option, value));
            }
        }

        @Override
        synchronized <T> T getsockopt(SocketOption<T> option) throws IOException {
            if (this.clientChannel != null) {
                return this.clientChannel.getOption(option);
            }
            if (this.serverChannel != null) {
                return this.serverChannel.getOption(option);
            }
            throw new UnsupportedOperationException();
        }

        private static void replayOptions(List<OptionWithValue> opts, NetworkChannel channel) throws IOException {
            if (opts != null) {
                for (OptionWithValue o : opts) {
                    channel.setOption(o.option, o.value);
                }
            }
        }

        private static class OptionWithValue {
            final SocketOption<?> option;
            final Object value;

            OptionWithValue(SocketOption<?> option, Object value) {
                this.option = option;
                this.value = value;
            }
        }
    }

    private static abstract class EmulatedSocket
    implements ByteChannel {
        protected final int family;
        protected final int protocol;

        protected EmulatedSocket(int family, int protocol) {
            assert (family == PosixConstants.AF_INET.value || family == PosixConstants.AF_INET6.value);
            this.family = family;
            this.protocol = protocol;
        }

        abstract EmulatedSocket accept() throws IOException;

        abstract void bind(SocketAddress var1) throws IOException;

        abstract void connect(SocketAddress var1) throws IOException;

        abstract void listen(int var1) throws IOException;

        abstract SocketAddress getPeerName() throws IOException;

        abstract SocketAddress getSockName() throws IOException;

        abstract int recv(ByteBuffer var1, int var2) throws IOException;

        abstract SocketAddress recvfrom(ByteBuffer var1, int var2) throws IOException;

        abstract int send(ByteBuffer var1, int var2) throws IOException;

        abstract int sendto(ByteBuffer var1, int var2, SocketAddress var3) throws IOException;

        abstract void shutdown(int var1) throws IOException;

        abstract void configureBlocking(boolean var1) throws IOException;

        abstract boolean isBlocking();

        abstract <T> T getsockopt(SocketOption<T> var1) throws IOException;

        abstract <T> void setsockopt(SocketOption<T> var1, T var2) throws IOException;
    }

    private static final class EmulatedDirStream {
        final TruffleFile file;
        final int fd;
        DirectoryStream<TruffleFile> dirStream;
        Iterator<TruffleFile> iterator;
        boolean needsReopen;

        private EmulatedDirStream(TruffleFile file, int fd) throws PosixSupportLibrary.PosixException {
            this.file = file;
            this.fd = fd;
            this.reopen();
        }

        private void closeStream() throws IOException {
            DirectoryStream<TruffleFile> oldStream = this.dirStream;
            this.dirStream = null;
            this.iterator = null;
            if (oldStream != null) {
                oldStream.close();
            }
        }

        @CompilerDirectives.TruffleBoundary
        void reopen() throws PosixSupportLibrary.PosixException {
            try {
                this.closeStream();
                this.needsReopen = false;
                this.dirStream = this.file.newDirectoryStream();
                this.iterator = this.dirStream.iterator();
            }
            catch (Exception e) {
                throw EmulatedPosixSupport.posixException(OSErrorEnum.fromException(e, TruffleString.EqualNode.getUncached()));
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class SetUTimeNode
    extends Node {
        abstract void execute(Node var1, TruffleFile var2, long[] var3, boolean var4) throws PosixSupportLibrary.PosixException;

        @Specialization(guards={"timespec == null"})
        static void doCurrentTime(Node inliningTarget, TruffleFile file, long[] timespec, boolean followSymlinks, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errBranch, @Cached.Shared(value="eq") @Cached(inline=false) TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
            FileTime time = FileTime.fromMillis(System.currentTimeMillis());
            SetUTimeNode.setFileTimes(inliningTarget, followSymlinks, file, time, time, errBranch, eqNode);
        }

        @Specialization(guards={"timespec != null", "file != null"})
        static void doGivenTime(Node inliningTarget, TruffleFile file, long[] timespec, boolean followSymlinks, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errBranch, @Cached.Shared(value="eq") @Cached(inline=false) TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
            FileTime atime = SetUTimeNode.toFileTime(timespec[0], timespec[1]);
            FileTime mtime = SetUTimeNode.toFileTime(timespec[2], timespec[3]);
            SetUTimeNode.setFileTimes(inliningTarget, followSymlinks, file, mtime, atime, errBranch, eqNode);
        }

        private static void setFileTimes(Node inliningTarget, boolean followSymlinks, TruffleFile file, FileTime mtime, FileTime atime, InlinedBranchProfile errBranch, TruffleString.EqualNode eqNode) throws PosixSupportLibrary.PosixException {
            try {
                file.setLastAccessTime(atime, EmulatedPosixSupport.getLinkOptions(followSymlinks));
                file.setLastModifiedTime(mtime, EmulatedPosixSupport.getLinkOptions(followSymlinks));
            }
            catch (Exception e) {
                errBranch.enter(inliningTarget);
                OSErrorEnum.ErrorAndMessagePair errAndMsg = OSErrorEnum.fromException(e, eqNode);
                if (errAndMsg.oserror == OSErrorEnum.ELOOP && !followSymlinks) {
                    throw new PosixSupportLibrary.UnsupportedPosixFeatureException("utime with 'follow symlinks' flag is not supported");
                }
                throw EmulatedPosixSupport.posixException(errAndMsg);
            }
        }

        private static FileTime toFileTime(long seconds, long nanos) {
            return FileTime.from(seconds, TimeUnit.SECONDS);
        }
    }

    static class PipePump
    extends Thread {
        private static final int MAX_READ = 8192;
        private final InputStream in;
        private final OutputStream out;
        private final byte[] buffer;
        private volatile boolean finish;

        public PipePump(String name, InputStream in, OutputStream out) {
            this.setName(name);
            this.in = in;
            this.out = out;
            this.buffer = new byte[8192];
            this.finish = false;
        }

        @Override
        public void run() {
            try {
                while (!this.finish || this.in.available() > 0) {
                    int read;
                    if (Thread.interrupted()) {
                        this.finish = true;
                    }
                    if ((read = this.in.read(this.buffer, 0, Math.min(8192, this.in.available()))) == -1) {
                        return;
                    }
                    this.out.write(this.buffer, 0, read);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void finish() {
            this.finish = true;
            this.setPriority(10);
            Thread.yield();
        }
    }

    public static final class MMapHandle {
        private static final MMapHandle NONE = new MMapHandle(null, 0L);
        private SeekableByteChannel channel;
        private final long offset;

        public MMapHandle(SeekableByteChannel channel, long offset) {
            this.channel = channel;
            this.offset = offset;
        }

        public String toString() {
            CompilerAsserts.neverPartOfCompilation();
            return String.format("Emulated mmap [channel=%s, offset=%d]", this.channel, this.offset);
        }
    }

    private static final class AnonymousMap
    implements SeekableByteChannel {
        private final byte[] data;
        private boolean open = true;
        private int cur;

        public AnonymousMap(int cap) {
            this.data = new byte[cap];
        }

        @Override
        public boolean isOpen() {
            return this.open;
        }

        @Override
        public void close() throws IOException {
            this.open = false;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            int nread = Math.min(dst.remaining(), this.data.length - this.cur);
            dst.put(this.data, this.cur, nread);
            return nread;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            int nwrite = Math.min(src.remaining(), this.data.length - this.cur);
            src.get(this.data, this.cur, nwrite);
            return nwrite;
        }

        @Override
        public long position() throws IOException {
            return this.cur;
        }

        @Override
        public SeekableByteChannel position(long newPosition) throws IOException {
            if (newPosition < 0L || newPosition >= (long)this.data.length) {
                throw new IllegalArgumentException();
            }
            this.cur = (int)newPosition;
            return this;
        }

        @Override
        public long size() throws IOException {
            return this.data.length;
        }

        @Override
        public SeekableByteChannel truncate(long size) throws IOException {
            int i = 0;
            while ((long)i < size) {
                this.data[i] = 0;
                ++i;
            }
            return this;
        }
    }

    @ExportLibrary(value=PosixSupportLibrary.UniversalSockAddrLibrary.class)
    protected static class EmulatedUniversalSockAddrImpl
    implements PosixSupportLibrary.UniversalSockAddr {
        final int family;
        final InetSocketAddress socketAddress;

        private EmulatedUniversalSockAddrImpl(int family, InetSocketAddress socketAddress) {
            assert (family == PosixConstants.AF_UNSPEC.value || family == PosixConstants.AF_INET.value || family == PosixConstants.AF_INET6.value);
            this.family = family;
            this.socketAddress = socketAddress;
        }

        @ExportMessage
        int getFamily() {
            return this.family;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        PosixSupportLibrary.Inet4SockAddr asInet4SockAddr() {
            if (this.getFamily() != PosixConstants.AF_INET.value) {
                throw new IllegalArgumentException("Only AF_INET socket address can be converted to Inet4SockAddr");
            }
            return new PosixSupportLibrary.Inet4SockAddr(this.socketAddress.getPort(), this.socketAddress.getAddress().getAddress());
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        PosixSupportLibrary.Inet6SockAddr asInet6SockAddr() {
            if (this.getFamily() != PosixConstants.AF_INET6.value) {
                throw new IllegalArgumentException("Only AF_INET6 socket address can be converted to Inet6SockAddr");
            }
            InetAddress sa = this.socketAddress.getAddress();
            if (sa instanceof Inet6Address) {
                Inet6Address a = (Inet6Address)sa;
                return new PosixSupportLibrary.Inet6SockAddr(this.socketAddress.getPort(), a.getAddress(), 0, a.getScopeId());
            }
            byte[] ipv4 = ((Inet4Address)sa).getAddress();
            byte[] ipv6 = EmulatedPosixSupport.mapIPv4toIPv6(ipv4);
            return new PosixSupportLibrary.Inet6SockAddr(this.socketAddress.getPort(), ipv6, 0, 0);
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        PosixSupportLibrary.UnixSockAddr asUnixSockAddr() {
            assert (this.getFamily() != PosixConstants.AF_UNIX.value);
            throw new IllegalArgumentException("Only AF_UNIX socket address can be converted to Unix4SockAddr");
        }

        static EmulatedUniversalSockAddrImpl inet4(byte[] address, int port) {
            assert (address.length == 4);
            return new EmulatedUniversalSockAddrImpl(PosixConstants.AF_INET.value, EmulatedUniversalSockAddrImpl.createInet4Address(address, port));
        }

        static EmulatedUniversalSockAddrImpl inet6(byte[] address, int scopeId, int port) {
            assert (address.length == 16);
            return new EmulatedUniversalSockAddrImpl(PosixConstants.AF_INET6.value, EmulatedUniversalSockAddrImpl.createInet6Address(address, scopeId, port));
        }

        static EmulatedUniversalSockAddrImpl fromSocketAddress(int family, SocketAddress sa) {
            assert (family == PosixConstants.AF_INET.value || family == PosixConstants.AF_INET6.value);
            if (sa == null) {
                return new EmulatedUniversalSockAddrImpl(PosixConstants.AF_UNSPEC.value, null);
            }
            return new EmulatedUniversalSockAddrImpl(family, (InetSocketAddress)sa);
        }

        @CompilerDirectives.TruffleBoundary
        private static InetSocketAddress createInet4Address(byte[] address, int port) {
            assert (address.length == 4);
            try {
                return new InetSocketAddress(Inet4Address.getByAddress(address), port);
            }
            catch (UnknownHostException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static InetSocketAddress createInet6Address(byte[] address, int scopeId, int port) {
            assert (address.length == 16);
            try {
                return new InetSocketAddress(Inet6Address.getByAddress(null, address, scopeId), port);
            }
            catch (UnknownHostException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
    }

    private static class Service {
        final int port;
        final String protocol;

        Service(int port, String protocol) {
            this.port = port;
            this.protocol = protocol;
        }
    }

    @ExportLibrary(value=PosixSupportLibrary.AddrInfoCursorLibrary.class)
    protected static class EmulatedAddrInfoCursorImpl
    implements PosixSupportLibrary.AddrInfoCursor {
        final Iterator<Item> iterator;
        final String canonName;
        final int protocol;
        final int flags;
        Item item;

        EmulatedAddrInfoCursorImpl(Iterator<Item> iterator, String canonName, int protocol, int flags) {
            this.iterator = iterator;
            this.canonName = canonName;
            this.protocol = protocol;
            this.flags = flags;
            this.item = iterator.next();
        }

        @ExportMessage
        final void release() {
            this.checkReleased();
            this.item = null;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        final boolean next() {
            if (!this.iterator.hasNext()) {
                return false;
            }
            this.item = this.iterator.next();
            return true;
        }

        @ExportMessage
        final int getFlags() {
            return this.flags;
        }

        @ExportMessage
        final int getFamily() {
            return this.item.address.getFamily();
        }

        @ExportMessage
        final int getSockType() {
            return this.item.socketType;
        }

        @ExportMessage
        final int getProtocol() {
            if (this.protocol != 0) {
                return this.protocol;
            }
            return this.item.socketType == PosixConstants.SOCK_DGRAM.value ? PosixConstants.IPPROTO_UDP.value : PosixConstants.IPPROTO_TCP.value;
        }

        @ExportMessage
        final Object getCanonName() {
            return this.canonName;
        }

        @ExportMessage
        final PosixSupportLibrary.UniversalSockAddr getSockAddr() {
            return this.item.address;
        }

        private void checkReleased() {
            if (this.item == null) {
                throw CompilerDirectives.shouldNotReachHere((String)"AddrInfoCursor has already been released");
            }
        }

        static final class Item {
            final EmulatedUniversalSockAddrImpl address;
            final int socketType;

            Item(int family, InetAddress inetAddress, Service service) {
                this.address = new EmulatedUniversalSockAddrImpl(family, new InetSocketAddress(inetAddress, service.port));
                this.socketType = "tcp".equals(service.protocol) ? PosixConstants.SOCK_STREAM.value : PosixConstants.SOCK_DGRAM.value;
            }
        }
    }

    @ExportMessage
    public static class Getpid {
        private static final TruffleString T_PROC_SELF_STAT = PythonUtils.tsLiteral("/proc/self/stat");

        @Specialization(rewriteOn={Exception.class})
        @CompilerDirectives.TruffleBoundary
        static long getPid(EmulatedPosixSupport receiver) throws Exception {
            if (ImageInfo.inImageRuntimeCode()) {
                return ProcessProperties.getProcessID();
            }
            TruffleFile statFile = receiver.context.getPublicTruffleFileRelaxed(T_PROC_SELF_STAT, new TruffleString[0]);
            return Long.parseLong(new String(statFile.readAllBytes()).trim().split(" ")[0]);
        }

        @Specialization(replaces={"getPid"})
        @CompilerDirectives.TruffleBoundary
        static long getPidFallback(EmulatedPosixSupport receiver) {
            if (!PythonOptions.WITHOUT_PLATFORM_ACCESS) {
                String info = ManagementFactory.getRuntimeMXBean().getName();
                return Long.parseLong(info.split("@")[0]);
            }
            return Long.MAX_VALUE;
        }
    }
}

