/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.object;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.PosixModuleBuiltins;
import com.oracle.graal.python.builtins.modules.bz2.BZ2Object;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodec;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecObject;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteIncrementalDecoderObject;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteIncrementalEncoderObject;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteStreamReaderObject;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteStreamWriterObject;
import com.oracle.graal.python.builtins.modules.codecs.PEncodingMap;
import com.oracle.graal.python.builtins.modules.csv.CSVDialect;
import com.oracle.graal.python.builtins.modules.csv.CSVReader;
import com.oracle.graal.python.builtins.modules.csv.CSVWriter;
import com.oracle.graal.python.builtins.modules.csv.QuoteStyle;
import com.oracle.graal.python.builtins.modules.ctypes.CDataObject;
import com.oracle.graal.python.builtins.modules.ctypes.CFieldObject;
import com.oracle.graal.python.builtins.modules.ctypes.CThunkObject;
import com.oracle.graal.python.builtins.modules.ctypes.PyCArgObject;
import com.oracle.graal.python.builtins.modules.ctypes.PyCFuncPtrObject;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.modules.ctypes.StructParamObject;
import com.oracle.graal.python.builtins.modules.ctypes.memory.Pointer;
import com.oracle.graal.python.builtins.modules.functools.LruCacheObject;
import com.oracle.graal.python.builtins.modules.functools.PKeyWrapper;
import com.oracle.graal.python.builtins.modules.functools.PPartial;
import com.oracle.graal.python.builtins.modules.hashlib.DigestObject;
import com.oracle.graal.python.builtins.modules.io.PBuffered;
import com.oracle.graal.python.builtins.modules.io.PBytesIO;
import com.oracle.graal.python.builtins.modules.io.PBytesIOBuffer;
import com.oracle.graal.python.builtins.modules.io.PFileIO;
import com.oracle.graal.python.builtins.modules.io.PNLDecoder;
import com.oracle.graal.python.builtins.modules.io.PRWPair;
import com.oracle.graal.python.builtins.modules.io.PStringIO;
import com.oracle.graal.python.builtins.modules.io.PTextIO;
import com.oracle.graal.python.builtins.modules.json.PJSONEncoder;
import com.oracle.graal.python.builtins.modules.json.PJSONScanner;
import com.oracle.graal.python.builtins.modules.lzma.LZMAObject;
import com.oracle.graal.python.builtins.modules.multiprocessing.PGraalPySemLock;
import com.oracle.graal.python.builtins.modules.multiprocessing.PSemLock;
import com.oracle.graal.python.builtins.modules.zlib.ZLibCompObject;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.array.PArray;
import com.oracle.graal.python.builtins.objects.asyncio.PAsyncGen;
import com.oracle.graal.python.builtins.objects.asyncio.PAsyncGenASend;
import com.oracle.graal.python.builtins.objects.asyncio.PAsyncGenAThrow;
import com.oracle.graal.python.builtins.objects.asyncio.PAsyncGenWrappedValue;
import com.oracle.graal.python.builtins.objects.asyncio.PCoroutineWrapper;
import com.oracle.graal.python.builtins.objects.bytes.PByteArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.capsule.PyCapsule;
import com.oracle.graal.python.builtins.objects.cell.PCell;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeVoidPtr;
import com.oracle.graal.python.builtins.objects.cext.hpy.PythonHPyObject;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.common.DynamicObjectStorage;
import com.oracle.graal.python.builtins.objects.common.EconomicMapStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.PHashingCollection;
import com.oracle.graal.python.builtins.objects.complex.PComplex;
import com.oracle.graal.python.builtins.objects.contextvars.PContextIterator;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVar;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVarsContext;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVarsToken;
import com.oracle.graal.python.builtins.objects.deque.PDeque;
import com.oracle.graal.python.builtins.objects.deque.PDequeIter;
import com.oracle.graal.python.builtins.objects.dict.PDefaultDict;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.dict.PDictView;
import com.oracle.graal.python.builtins.objects.enumerate.PEnumerate;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.generator.PGenerator;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.GetSetDescriptor;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.HiddenKeyDescriptor;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.iterator.PArrayIterator;
import com.oracle.graal.python.builtins.objects.iterator.PBaseSetIterator;
import com.oracle.graal.python.builtins.objects.iterator.PBigRangeIterator;
import com.oracle.graal.python.builtins.objects.iterator.PDoubleSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PForeignArrayIterator;
import com.oracle.graal.python.builtins.objects.iterator.PIntRangeIterator;
import com.oracle.graal.python.builtins.objects.iterator.PIntegerSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PLongSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PObjectSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PSentinelIterator;
import com.oracle.graal.python.builtins.objects.iterator.PSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PStringIterator;
import com.oracle.graal.python.builtins.objects.iterator.PZip;
import com.oracle.graal.python.builtins.objects.itertools.PAccumulate;
import com.oracle.graal.python.builtins.objects.itertools.PChain;
import com.oracle.graal.python.builtins.objects.itertools.PCombinations;
import com.oracle.graal.python.builtins.objects.itertools.PCombinationsWithReplacement;
import com.oracle.graal.python.builtins.objects.itertools.PCompress;
import com.oracle.graal.python.builtins.objects.itertools.PCount;
import com.oracle.graal.python.builtins.objects.itertools.PCycle;
import com.oracle.graal.python.builtins.objects.itertools.PDropwhile;
import com.oracle.graal.python.builtins.objects.itertools.PFilterfalse;
import com.oracle.graal.python.builtins.objects.itertools.PGroupBy;
import com.oracle.graal.python.builtins.objects.itertools.PGrouper;
import com.oracle.graal.python.builtins.objects.itertools.PIslice;
import com.oracle.graal.python.builtins.objects.itertools.PPairwise;
import com.oracle.graal.python.builtins.objects.itertools.PPermutations;
import com.oracle.graal.python.builtins.objects.itertools.PProduct;
import com.oracle.graal.python.builtins.objects.itertools.PRepeat;
import com.oracle.graal.python.builtins.objects.itertools.PStarmap;
import com.oracle.graal.python.builtins.objects.itertools.PTakewhile;
import com.oracle.graal.python.builtins.objects.itertools.PTee;
import com.oracle.graal.python.builtins.objects.itertools.PTeeDataObject;
import com.oracle.graal.python.builtins.objects.itertools.PZipLongest;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.map.PMap;
import com.oracle.graal.python.builtins.objects.mappingproxy.PMappingproxy;
import com.oracle.graal.python.builtins.objects.memoryview.BufferLifecycleManager;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.method.PDecoratedMethod;
import com.oracle.graal.python.builtins.objects.method.PMethod;
import com.oracle.graal.python.builtins.objects.mmap.PMMap;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.namespace.PSimpleNamespace;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.ordereddict.POrderedDict;
import com.oracle.graal.python.builtins.objects.ordereddict.POrderedDictIterator;
import com.oracle.graal.python.builtins.objects.posix.PDirEntry;
import com.oracle.graal.python.builtins.objects.posix.PScandirIterator;
import com.oracle.graal.python.builtins.objects.property.PProperty;
import com.oracle.graal.python.builtins.objects.queue.PSimpleQueue;
import com.oracle.graal.python.builtins.objects.random.PRandom;
import com.oracle.graal.python.builtins.objects.range.PBigRange;
import com.oracle.graal.python.builtins.objects.range.PIntRange;
import com.oracle.graal.python.builtins.objects.referencetype.PReferenceType;
import com.oracle.graal.python.builtins.objects.reversed.PSequenceReverseIterator;
import com.oracle.graal.python.builtins.objects.reversed.PStringReverseIterator;
import com.oracle.graal.python.builtins.objects.set.PBaseSet;
import com.oracle.graal.python.builtins.objects.set.PFrozenSet;
import com.oracle.graal.python.builtins.objects.set.PSet;
import com.oracle.graal.python.builtins.objects.slice.PIntSlice;
import com.oracle.graal.python.builtins.objects.slice.PObjectSlice;
import com.oracle.graal.python.builtins.objects.socket.PSocket;
import com.oracle.graal.python.builtins.objects.ssl.PMemoryBIO;
import com.oracle.graal.python.builtins.objects.ssl.PSSLContext;
import com.oracle.graal.python.builtins.objects.ssl.PSSLSocket;
import com.oracle.graal.python.builtins.objects.ssl.SSLMethod;
import com.oracle.graal.python.builtins.objects.str.NativeCharSequence;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.superobject.SuperObject;
import com.oracle.graal.python.builtins.objects.thread.PLock;
import com.oracle.graal.python.builtins.objects.thread.PRLock;
import com.oracle.graal.python.builtins.objects.thread.PThread;
import com.oracle.graal.python.builtins.objects.thread.PThreadLocal;
import com.oracle.graal.python.builtins.objects.traceback.LazyTraceback;
import com.oracle.graal.python.builtins.objects.traceback.PTraceback;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.PTupleGetter;
import com.oracle.graal.python.builtins.objects.tuple.StructSequence;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.types.PGenericAlias;
import com.oracle.graal.python.builtins.objects.types.PUnionType;
import com.oracle.graal.python.compiler.CodeUnit;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.runtime.NFIZlibSupport;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.object.PythonObjectFactoryNodeGen;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.DoubleSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.EmptySequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.IntSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.LongSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorageFactory;
import com.oracle.graal.python.util.BufferFormat;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.instrumentation.AllocationReporter;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.ref.ReferenceQueue;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.concurrent.Semaphore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

@GenerateUncached
@ImportStatic(value={PythonOptions.class})
@GenerateInline(value=false)
public abstract class PythonObjectFactory
extends Node {
    @NeverDefault
    public static PythonObjectFactory create() {
        return PythonObjectFactoryNodeGen.create();
    }

    public static PythonObjectFactory getUncached() {
        return PythonObjectFactoryNodeGen.getUncached();
    }

    protected abstract AllocationReporter executeTrace(Object var1, long var2);

    protected abstract Shape executeGetShape(Object var1, boolean var2);

    @Specialization
    static Shape getShape(Object o, boolean flag, @Cached TypeNodes.GetInstanceShape getShapeNode) {
        return getShapeNode.execute(o);
    }

    @Specialization
    static AllocationReporter doTrace(Object o, long size, @Cached(value="getAllocationReporter()", allowUncached=true) AllocationReporter reporter) {
        if (reporter.isActive()) {
            PythonObjectFactory.doTraceImpl(o, size, reporter);
        }
        return null;
    }

    @HostCompilerDirectives.InliningCutoff
    private static void doTraceImpl(Object o, long size, AllocationReporter reporter) {
        reporter.onEnter(null, 0L, size);
        reporter.onReturnValue(o, 0L, size);
    }

    @NeverDefault
    protected AllocationReporter getAllocationReporter() {
        return PythonContext.get(this).getAllocationReporter();
    }

    public PythonLanguage getLanguage() {
        return PythonLanguage.get(this);
    }

    public final Shape getShape(PythonBuiltinClassType cls) {
        return cls.getInstanceShape(this.getLanguage());
    }

    public final Shape getShape(Object cls) {
        return this.executeGetShape(cls, true);
    }

    public final <T> T trace(T allocatedObject) {
        this.executeTrace(allocatedObject, Long.MIN_VALUE);
        return allocatedObject;
    }

    public final PythonObject createPythonObject(Object cls) {
        return this.createPythonObject(cls, this.getShape(cls));
    }

    public final PythonObject createPythonHPyObject(Object cls, Object hpyNativeSpace) {
        return this.trace(new PythonHPyObject(cls, this.getShape(cls), hpyNativeSpace));
    }

    public final PythonObject createPythonObject(Object klass, Shape instanceShape) {
        return this.trace(new PythonObject(klass, instanceShape));
    }

    public final PythonNativeVoidPtr createNativeVoidPtr(Object obj) {
        return this.trace(new PythonNativeVoidPtr(obj));
    }

    public final PythonNativeVoidPtr createNativeVoidPtr(Object obj, long nativePtr) {
        return this.trace(new PythonNativeVoidPtr(obj, nativePtr));
    }

    public final SuperObject createSuperObject(Object self) {
        return this.trace(new SuperObject(self, this.getShape(self)));
    }

    public final PInt createInt(int value) {
        Shape shape = this.getLanguage().getBuiltinTypeInstanceShape(PythonBuiltinClassType.PInt);
        return this.trace(new PInt((Object)PythonBuiltinClassType.PInt, shape, PInt.longToBigInteger(value)));
    }

    public final PInt createInt(long value) {
        Shape shape = this.getLanguage().getBuiltinTypeInstanceShape(PythonBuiltinClassType.PInt);
        return this.trace(new PInt((Object)PythonBuiltinClassType.PInt, shape, PInt.longToBigInteger(value)));
    }

    public final PInt createInt(BigInteger value) {
        Shape shape = this.getLanguage().getBuiltinTypeInstanceShape(PythonBuiltinClassType.PInt);
        return this.trace(new PInt((Object)PythonBuiltinClassType.PInt, shape, value));
    }

    public final Object createInt(Object cls, int value) {
        return this.createInt(cls, PInt.longToBigInteger(value));
    }

    public final Object createInt(Object cls, long value) {
        return this.createInt(cls, PInt.longToBigInteger(value));
    }

    public final PInt createInt(Object cls, BigInteger value) {
        return this.trace(new PInt(cls, this.getShape(cls), value));
    }

    public final PFloat createFloat(double value) {
        Shape shape = this.getLanguage().getBuiltinTypeInstanceShape(PythonBuiltinClassType.PFloat);
        return this.trace(new PFloat((Object)PythonBuiltinClassType.PFloat, shape, value));
    }

    public final PFloat createFloat(Object cls, double value) {
        return this.trace(new PFloat(cls, this.getShape(cls), value));
    }

    public final PString createString(TruffleString string) {
        Shape shape = this.getLanguage().getBuiltinTypeInstanceShape(PythonBuiltinClassType.PString);
        return this.trace(new PString((Object)PythonBuiltinClassType.PString, shape, string));
    }

    public final PString createString(Object cls, TruffleString string) {
        return this.trace(new PString(cls, this.getShape(cls), string));
    }

    public final PString createString(NativeCharSequence string) {
        return this.createString((Object)PythonBuiltinClassType.PString, string);
    }

    public final PString createString(Object cls, NativeCharSequence string) {
        return this.trace(new PString(cls, this.getShape(cls), string));
    }

    public final PBytes createBytes(byte[] array) {
        return this.createBytes(array, array.length);
    }

    public final PBytes createBytes(byte[] array, int offset, int length) {
        if (length != array.length) {
            byte[] buf = new byte[length];
            PythonUtils.arraycopy(array, offset, buf, 0, buf.length);
            return this.createBytes(buf, length);
        }
        return this.createBytes(array, length);
    }

    public final PBytes createBytes(Object cls, byte[] array) {
        return this.createBytes(cls, array, array.length);
    }

    public final PBytes createBytes(byte[] array, int length) {
        return this.createBytes(new ByteSequenceStorage(array, length));
    }

    public final PBytes createBytes(Object cls, byte[] array, int length) {
        return this.createBytes(cls, new ByteSequenceStorage(array, length));
    }

    public final PBytes createBytes(SequenceStorage storage) {
        return this.trace(new PBytes((Object)PythonBuiltinClassType.PBytes, this.getShape(PythonBuiltinClassType.PBytes), storage));
    }

    public final PBytes createBytes(Object cls, SequenceStorage storage) {
        return this.trace(new PBytes(cls, this.getShape(cls), storage));
    }

    public final PTuple createEmptyTuple() {
        return this.createTuple(PythonUtils.EMPTY_OBJECT_ARRAY);
    }

    public final PTuple createEmptyTuple(Object cls) {
        return this.createTuple(cls, EmptySequenceStorage.INSTANCE);
    }

    public final PTuple createTuple(Object[] objects) {
        Shape shape = PythonBuiltinClassType.PTuple.getInstanceShape(this.getLanguage());
        return this.trace(new PTuple((Object)PythonBuiltinClassType.PTuple, shape, objects));
    }

    public final PTuple createTuple(int[] ints) {
        return this.createTuple(new IntSequenceStorage(ints));
    }

    public final PTuple createTuple(SequenceStorage store) {
        Shape shape = PythonBuiltinClassType.PTuple.getInstanceShape(this.getLanguage());
        return this.trace(new PTuple((Object)PythonBuiltinClassType.PTuple, shape, store));
    }

    public final PTuple createTuple(Object cls, Shape instanceShape, Object[] objects) {
        return this.trace(new PTuple(cls, instanceShape, objects));
    }

    public final PTuple createTuple(Object cls, Object[] objects) {
        return this.trace(new PTuple(cls, this.getShape(cls), objects));
    }

    public final PTuple createTuple(Object cls, SequenceStorage store) {
        return this.trace(new PTuple(cls, this.getShape(cls), store));
    }

    public final PTuple createStructSeq(StructSequence.BuiltinTypeDescriptor desc, Object ... values) {
        assert (desc.inSequence <= values.length && values.length <= desc.fieldNames.length);
        return this.createTuple((Object)desc.type, new ObjectSequenceStorage(values, desc.inSequence));
    }

    public final PTupleGetter createTupleGetter(int index, Object doc) {
        return this.createTupleGetter((Object)PythonBuiltinClassType.PTupleGetter, index, doc);
    }

    public final PTupleGetter createTupleGetter(Object cls, int index, Object doc) {
        return this.trace(new PTupleGetter(cls, this.getShape(cls), index, doc));
    }

    public final PComplex createComplex(Object cls, double real, double imag) {
        return this.trace(new PComplex(cls, this.getShape(cls), real, imag));
    }

    public final PComplex createComplex(double real, double imag) {
        return this.createComplex((Object)PythonBuiltinClassType.PComplex, real, imag);
    }

    public final PIntRange createIntRange(int stop) {
        return this.trace(new PIntRange(this.getLanguage(), 0, stop, 1, stop));
    }

    public final PIntRange createIntRange(int start, int stop, int step, int len) {
        return this.trace(new PIntRange(this.getLanguage(), start, stop, step, len));
    }

    public final PBigRange createBigRange(BigInteger start, BigInteger stop, BigInteger step, BigInteger len) {
        return this.createBigRange(this.createInt(start), this.createInt(stop), this.createInt(step), this.createInt(len));
    }

    public final PBigRange createBigRange(PInt start, PInt stop, PInt step, PInt len) {
        return this.trace(new PBigRange(this.getLanguage(), start, stop, step, len));
    }

    public final PIntSlice createIntSlice(int start, int stop, int step) {
        return this.trace(new PIntSlice(this.getLanguage(), start, stop, step));
    }

    public final PIntSlice createIntSlice(int start, int stop, int step, boolean isStartNone, boolean isStepNone) {
        return this.trace(new PIntSlice(this.getLanguage(), start, stop, step, isStartNone, isStepNone));
    }

    public final PObjectSlice createObjectSlice(Object start, Object stop, Object step) {
        return this.trace(new PObjectSlice(this.getLanguage(), start, stop, step));
    }

    public final PRandom createRandom(Object cls) {
        return this.trace(new PRandom(cls, this.getShape(cls)));
    }

    public final PythonModule createPythonModule(TruffleString name) {
        return this.trace(PythonModule.createInternal(name));
    }

    public final PythonModule createPythonModule(Object cls) {
        return this.trace(new PythonModule(cls, this.getShape(cls)));
    }

    public final PythonClass createPythonClassAndFixupSlots(PythonLanguage language, Object metaclass, TruffleString name, Object base, PythonAbstractClass[] bases) {
        PythonClass result = this.trace(new PythonClass(language, metaclass, this.getShape(metaclass), name, base, bases));
        SpecialMethodSlot.initializeSpecialMethodSlots(result, TypeNodes.GetMroStorageNode.executeUncached(result), language);
        result.initializeMroShape(language);
        return result;
    }

    public final PythonClass createPythonClass(Object metaclass, TruffleString name, boolean invokeMro, Object base, PythonAbstractClass[] bases) {
        return this.trace(new PythonClass(this.getLanguage(), metaclass, this.getShape(metaclass), name, invokeMro, base, bases));
    }

    public final PMemoryView createMemoryView(PythonContext context, BufferLifecycleManager bufferLifecycleManager, Object buffer, Object owner, int len, boolean readonly, int itemsize, BufferFormat format, TruffleString formatString, int ndim, Object bufPointer, int offset, int[] shape, int[] strides, int[] suboffsets, int flags) {
        PythonBuiltinClassType cls = PythonBuiltinClassType.PMemoryView;
        return this.trace(new PMemoryView((Object)cls, this.getShape(cls), context, bufferLifecycleManager, buffer, owner, len, readonly, itemsize, format, formatString, ndim, bufPointer, offset, shape, strides, suboffsets, flags));
    }

    private final PMemoryView createMemoryView(PythonContext context, BufferLifecycleManager bufferLifecycleManager, Object buffer, Object owner, int len, boolean readonly, int itemsize, TruffleString formatString, int ndim, Object bufPointer, int offset, int[] shape, int[] strides, int[] suboffsets, int flags, TruffleString.CodePointLengthNode lengthNode, TruffleString.CodePointAtIndexNode atIndexNode) {
        PythonBuiltinClassType cls = PythonBuiltinClassType.PMemoryView;
        return this.trace(new PMemoryView((Object)cls, this.getShape(cls), context, bufferLifecycleManager, buffer, owner, len, readonly, itemsize, BufferFormat.forMemoryView(formatString, lengthNode, atIndexNode), formatString, ndim, bufPointer, offset, shape, strides, suboffsets, flags));
    }

    public final PMemoryView createMemoryViewForManagedObject(Object buffer, Object owner, int itemsize, int length, boolean readonly, TruffleString format, TruffleString.CodePointLengthNode lengthNode, TruffleString.CodePointAtIndexNode atIndexNode) {
        return this.createMemoryView(null, null, buffer, owner, length, readonly, itemsize, format, 1, null, 0, new int[]{length / itemsize}, new int[]{itemsize}, null, 6, lengthNode, atIndexNode);
    }

    public final PMemoryView createMemoryViewForManagedObject(Object owner, int itemsize, int length, boolean readonly, TruffleString format, TruffleString.CodePointLengthNode lengthNode, TruffleString.CodePointAtIndexNode atIndexNode) {
        return this.createMemoryViewForManagedObject(owner, owner, itemsize, length, readonly, format, lengthNode, atIndexNode);
    }

    public final PMethod createMethod(Object cls, Object self, Object function) {
        return this.trace(new PMethod(cls, this.getShape(cls), self, function));
    }

    public final PMethod createMethod(Object self, Object function) {
        return this.createMethod((Object)PythonBuiltinClassType.PMethod, self, function);
    }

    public final PMethod createBuiltinMethod(Object self, PFunction function) {
        return this.createMethod((Object)PythonBuiltinClassType.PBuiltinFunctionOrMethod, self, function);
    }

    public final PBuiltinMethod createBuiltinMethod(Object cls, Object self, PBuiltinFunction function) {
        return this.trace(new PBuiltinMethod(cls, this.getShape(cls), self, function, null));
    }

    public final PBuiltinMethod createBuiltinMethod(Object self, PBuiltinFunction function, Object classObject) {
        return this.trace(new PBuiltinMethod((Object)PythonBuiltinClassType.PBuiltinMethod, this.getShape(PythonBuiltinClassType.PBuiltinMethod), self, function, classObject));
    }

    public final PBuiltinMethod createBuiltinMethod(Object self, PBuiltinFunction function) {
        return this.createBuiltinMethod((Object)PythonBuiltinClassType.PBuiltinFunctionOrMethod, self, function);
    }

    public final PFunction createFunction(TruffleString name, PCode code, PythonObject globals, PCell[] closure) {
        return this.trace(new PFunction(this.getLanguage(), name, name, code, globals, closure));
    }

    public final PFunction createFunction(TruffleString name, TruffleString qualname, PCode code, PythonObject globals, Object[] defaultValues, PKeyword[] kwDefaultValues, PCell[] closure) {
        return this.trace(new PFunction(this.getLanguage(), name, qualname, code, globals, defaultValues, kwDefaultValues, closure));
    }

    public final PFunction createFunction(TruffleString name, PCode code, PythonObject globals, Object[] defaultValues, PKeyword[] kwDefaultValues, PCell[] closure) {
        return this.trace(new PFunction(this.getLanguage(), name, name, code, globals, defaultValues, kwDefaultValues, closure));
    }

    public final PFunction createFunction(TruffleString name, TruffleString qualname, PCode code, PythonObject globals, Object[] defaultValues, PKeyword[] kwDefaultValues, PCell[] closure, Assumption codeStableAssumption, Assumption defaultsStableAssumption) {
        return this.trace(new PFunction(this.getLanguage(), name, qualname, code, globals, defaultValues, kwDefaultValues, closure, codeStableAssumption, defaultsStableAssumption));
    }

    public final PBuiltinFunction createBuiltinFunction(TruffleString name, Object type, int numDefaults, int flags, RootCallTarget callTarget) {
        return this.trace(new PBuiltinFunction(PythonBuiltinClassType.PBuiltinFunction, PythonBuiltinClassType.PBuiltinFunction.getInstanceShape(this.getLanguage()), name, type, PBuiltinFunction.generateDefaults(numDefaults), null, flags, callTarget));
    }

    public final PBuiltinFunction createBuiltinFunction(TruffleString name, Object type, Object[] defaults, PKeyword[] kw, int flags, RootCallTarget callTarget) {
        return this.trace(new PBuiltinFunction(PythonBuiltinClassType.PBuiltinFunction, PythonBuiltinClassType.PBuiltinFunction.getInstanceShape(this.getLanguage()), name, type, defaults, kw, flags, callTarget));
    }

    public final PBuiltinFunction createWrapperDescriptor(TruffleString name, Object type, int numDefaults, int flags, RootCallTarget callTarget) {
        return this.trace(new PBuiltinFunction(PythonBuiltinClassType.WrapperDescriptor, PythonBuiltinClassType.WrapperDescriptor.getInstanceShape(this.getLanguage()), name, type, PBuiltinFunction.generateDefaults(numDefaults), null, flags, callTarget));
    }

    public final PBuiltinFunction createWrapperDescriptor(TruffleString name, Object type, Object[] defaults, PKeyword[] kw, int flags, RootCallTarget callTarget) {
        return this.trace(new PBuiltinFunction(PythonBuiltinClassType.WrapperDescriptor, PythonBuiltinClassType.WrapperDescriptor.getInstanceShape(this.getLanguage()), name, type, defaults, kw, flags, callTarget));
    }

    public final PBuiltinFunction createBuiltinFunction(PBuiltinFunction function, Object klass) {
        PythonBuiltinClassType type = (PythonBuiltinClassType)((Object)function.getInitialPythonClass());
        return this.trace(new PBuiltinFunction(type, type.getInstanceShape(this.getLanguage()), function.getName(), klass, function.getDefaults(), function.getKwDefaults(), function.getFlags(), function.getCallTarget()));
    }

    public final GetSetDescriptor createGetSetDescriptor(Object get, Object set, TruffleString name, Object type) {
        return this.trace(new GetSetDescriptor(this.getLanguage(), get, set, name, type));
    }

    public final GetSetDescriptor createGetSetDescriptor(Object get, Object set, TruffleString name, Object type, boolean allowsDelete) {
        return this.trace(new GetSetDescriptor(this.getLanguage(), get, set, name, type, allowsDelete));
    }

    public final GetSetDescriptor createMemberDescriptor(Object get, Object set, TruffleString name, Object type) {
        return this.trace(new GetSetDescriptor((Object)PythonBuiltinClassType.MemberDescriptor, PythonBuiltinClassType.MemberDescriptor.getInstanceShape(this.getLanguage()), get, set, name, type, set != null));
    }

    public final HiddenKeyDescriptor createHiddenKeyDescriptor(HiddenKey key, Object type) {
        return this.trace(new HiddenKeyDescriptor(this.getLanguage(), key, type));
    }

    public final PDecoratedMethod createClassmethod(Object cls) {
        return this.trace(new PDecoratedMethod(cls, this.getShape(cls)));
    }

    public final PDecoratedMethod createClassmethodFromCallableObj(Object callable) {
        return this.trace(new PDecoratedMethod((Object)PythonBuiltinClassType.PClassmethod, PythonBuiltinClassType.PClassmethod.getInstanceShape(this.getLanguage()), callable));
    }

    public final PDecoratedMethod createBuiltinClassmethodFromCallableObj(Object callable) {
        return this.trace(new PDecoratedMethod((Object)PythonBuiltinClassType.PBuiltinClassMethod, PythonBuiltinClassType.PBuiltinClassMethod.getInstanceShape(this.getLanguage()), callable));
    }

    public final PDecoratedMethod createInstancemethod(Object cls) {
        return this.trace(new PDecoratedMethod(cls, this.getShape(cls)));
    }

    public final PDecoratedMethod createStaticmethod(Object cls) {
        return this.trace(new PDecoratedMethod(cls, this.getShape(cls)));
    }

    public final PDecoratedMethod createStaticmethodFromCallableObj(Object callable) {
        Object func = callable;
        if (func instanceof PBuiltinFunction) {
            func = this.createBuiltinMethod(((PBuiltinFunction)func).getEnclosingType(), (PBuiltinFunction)func);
        }
        return this.trace(new PDecoratedMethod((Object)PythonBuiltinClassType.PStaticmethod, PythonBuiltinClassType.PStaticmethod.getInstanceShape(this.getLanguage()), func));
    }

    public final PList createList() {
        return this.createList(PythonUtils.EMPTY_OBJECT_ARRAY);
    }

    public final PList createList(SequenceStorage storage) {
        return this.createList((Object)PythonBuiltinClassType.PList, storage);
    }

    public final PList createList(Object cls, Shape instanceShape, SequenceStorage storage) {
        return this.trace(new PList(cls, instanceShape, storage));
    }

    public final PList createList(SequenceStorage storage, PList.ListOrigin origin) {
        return this.trace(new PList((Object)PythonBuiltinClassType.PList, PythonBuiltinClassType.PList.getInstanceShape(this.getLanguage()), storage, origin));
    }

    public final PList createList(Object cls, SequenceStorage storage) {
        return this.trace(new PList(cls, this.getShape(cls), storage));
    }

    public final PList createList(Object cls) {
        return this.createList(cls, PythonUtils.EMPTY_OBJECT_ARRAY);
    }

    public final PList createList(Object[] array) {
        return this.createList((Object)PythonBuiltinClassType.PList, array);
    }

    public final PList createList(Object cls, Object[] array) {
        return this.trace(new PList(cls, this.getShape(cls), SequenceStorageFactory.createStorage(array)));
    }

    public final PSet createSet() {
        Shape shape = PythonBuiltinClassType.PSet.getInstanceShape(this.getLanguage());
        return this.trace(new PSet((Object)PythonBuiltinClassType.PSet, shape));
    }

    public final PSet createSet(Object cls) {
        return this.trace(new PSet(cls, this.getShape(cls)));
    }

    public final PSet createSet(Object cls, Shape instanceShape) {
        return this.trace(new PSet(cls, instanceShape));
    }

    public final PSet createSet(HashingStorage storage) {
        Shape shape = PythonBuiltinClassType.PSet.getInstanceShape(this.getLanguage());
        return this.trace(new PSet((Object)PythonBuiltinClassType.PSet, shape, storage));
    }

    public final PFrozenSet createFrozenSet(Object cls) {
        return this.trace(new PFrozenSet(cls, this.getShape(cls)));
    }

    public final PFrozenSet createFrozenSet(Object cls, HashingStorage storage) {
        return this.trace(new PFrozenSet(cls, this.getShape(cls), storage));
    }

    public final PFrozenSet createFrozenSet(HashingStorage storage) {
        Shape shape = PythonBuiltinClassType.PFrozenSet.getInstanceShape(this.getLanguage());
        return this.trace(new PFrozenSet((Object)PythonBuiltinClassType.PFrozenSet, shape, storage));
    }

    public final PDict createDict() {
        Shape shape = PythonBuiltinClassType.PDict.getInstanceShape(this.getLanguage());
        return this.trace(new PDict((Object)PythonBuiltinClassType.PDict, shape));
    }

    public final PDict createDict(PKeyword[] keywords) {
        Shape shape = PythonBuiltinClassType.PDict.getInstanceShape(this.getLanguage());
        return this.trace(new PDict((Object)PythonBuiltinClassType.PDict, shape, keywords));
    }

    public final PDict createDict(Object cls) {
        return this.trace(new PDict(cls, this.getShape(cls)));
    }

    public final POrderedDict createOrderedDict(Object cls) {
        return this.trace(new POrderedDict(cls, this.getShape(cls)));
    }

    public final PDictView.PDictKeysView createOrderedDictKeys(POrderedDict dict) {
        PythonBuiltinClassType cls = PythonBuiltinClassType.POrderedDictKeys;
        return this.trace(new PDictView.PDictKeysView((Object)cls, cls.getInstanceShape(this.getLanguage()), dict));
    }

    public final PDictView.PDictValuesView createOrderedDictValues(POrderedDict dict) {
        PythonBuiltinClassType cls = PythonBuiltinClassType.POrderedDictValues;
        return this.trace(new PDictView.PDictValuesView((Object)cls, cls.getInstanceShape(this.getLanguage()), dict));
    }

    public final PDictView.PDictItemsView createOrderedDictItems(POrderedDict dict) {
        PythonBuiltinClassType cls = PythonBuiltinClassType.POrderedDictItems;
        return this.trace(new PDictView.PDictItemsView((Object)cls, cls.getInstanceShape(this.getLanguage()), dict));
    }

    public POrderedDictIterator createOrderedDictIterator(POrderedDict dict, POrderedDictIterator.IteratorType type, boolean reversed) {
        PythonBuiltinClassType cls = PythonBuiltinClassType.POrderedDictIterator;
        return this.trace(new POrderedDictIterator((Object)cls, cls.getInstanceShape(this.getLanguage()), dict, type, reversed));
    }

    public final PDict createDictFromMap(LinkedHashMap<String, Object> map) {
        return this.createDict(EconomicMapStorage.create(map));
    }

    public final PDict createDictFromMapGeneric(LinkedHashMap<Object, Object> map) {
        return this.createDict(EconomicMapStorage.createGeneric(map));
    }

    public final PDict createDictFixedStorage(PythonObject pythonObject, MroSequenceStorage mroSequenceStorage) {
        return this.createDict(new DynamicObjectStorage(pythonObject.getStorage(), mroSequenceStorage));
    }

    public final PDict createDictFixedStorage(PythonObject pythonObject) {
        return this.createDict(new DynamicObjectStorage(pythonObject.getStorage()));
    }

    public final PDict createDict(Object cls, HashingStorage storage) {
        return this.trace(new PDict(cls, this.getShape(cls), storage));
    }

    public final PDict createDict(HashingStorage storage) {
        return this.createDict((Object)PythonBuiltinClassType.PDict, storage);
    }

    public final PDict createDict(Object cls, Shape instanceShape, HashingStorage storage) {
        return this.trace(new PDict(cls, instanceShape, storage));
    }

    public final PSimpleNamespace createSimpleNamespace() {
        return this.createSimpleNamespace((Object)PythonBuiltinClassType.PSimpleNamespace);
    }

    public final PSimpleNamespace createSimpleNamespace(Object cls) {
        return this.createSimpleNamespace(cls, this.getShape(cls));
    }

    public final PSimpleNamespace createSimpleNamespace(Object cls, Shape instanceShape) {
        return this.trace(new PSimpleNamespace(cls, instanceShape));
    }

    public final PKeyWrapper createKeyWrapper(Object cmp) {
        return this.trace(new PKeyWrapper((Object)PythonBuiltinClassType.PKeyWrapper, this.getShape(PythonBuiltinClassType.PKeyWrapper), cmp));
    }

    public final PPartial createPartial(Object cls, Object function, Object[] args, PDict kwDict) {
        return this.trace(new PPartial(cls, this.getShape(cls), function, args, kwDict));
    }

    public LruCacheObject createLruCacheObject(Object cls) {
        return this.trace(new LruCacheObject(cls, this.getShape(cls)));
    }

    public final PDefaultDict createDefaultDict(Object cls) {
        return this.createDefaultDict(cls, PNone.NONE);
    }

    public final PDefaultDict createDefaultDict(Object cls, Object defaultFactory) {
        return this.trace(new PDefaultDict(cls, this.getShape(cls), defaultFactory));
    }

    public final PDefaultDict createDefaultDict(Object defaultFactory, HashingStorage storage) {
        return this.createDefaultDict((Object)PythonBuiltinClassType.PDefaultDict, defaultFactory, storage);
    }

    public final PDefaultDict createDefaultDict(Object cls, Object defaultFactory, HashingStorage storage) {
        return this.trace(new PDefaultDict(cls, this.getShape(cls), storage, defaultFactory));
    }

    public final PDictView createDictKeysView(PHashingCollection dict) {
        return this.trace(new PDictView.PDictKeysView((Object)PythonBuiltinClassType.PDictKeysView, PythonBuiltinClassType.PDictKeysView.getInstanceShape(this.getLanguage()), dict));
    }

    public final PDictView createDictValuesView(PHashingCollection dict) {
        return this.trace(new PDictView.PDictValuesView((Object)PythonBuiltinClassType.PDictValuesView, PythonBuiltinClassType.PDictValuesView.getInstanceShape(this.getLanguage()), dict));
    }

    public final PDictView createDictItemsView(PHashingCollection dict) {
        return this.trace(new PDictView.PDictItemsView((Object)PythonBuiltinClassType.PDictItemsView, PythonBuiltinClassType.PDictItemsView.getInstanceShape(this.getLanguage()), dict));
    }

    public final PGenerator createGenerator(TruffleString name, TruffleString qualname, PBytecodeRootNode rootNode, RootCallTarget[] callTargets, Object[] arguments) {
        return this.trace(PGenerator.create(this.getLanguage(), name, qualname, rootNode, callTargets, arguments, PythonBuiltinClassType.PGenerator));
    }

    public final PGenerator createIterableCoroutine(TruffleString name, TruffleString qualname, PBytecodeRootNode rootNode, RootCallTarget[] callTargets, Object[] arguments) {
        return this.trace(PGenerator.create(this.getLanguage(), name, qualname, rootNode, callTargets, arguments, PythonBuiltinClassType.PGenerator, true));
    }

    public final PGenerator createCoroutine(TruffleString name, TruffleString qualname, PBytecodeRootNode rootNode, RootCallTarget[] callTargets, Object[] arguments) {
        return this.trace(PGenerator.create(this.getLanguage(), name, qualname, rootNode, callTargets, arguments, PythonBuiltinClassType.PCoroutine));
    }

    public final PCoroutineWrapper createCoroutineWrapper(PGenerator generator) {
        return this.trace(new PCoroutineWrapper(this.getLanguage(), generator));
    }

    public final PAsyncGen createAsyncGenerator(TruffleString name, TruffleString qualname, PBytecodeRootNode rootNode, RootCallTarget[] callTargets, Object[] arguments) {
        return this.trace(PAsyncGen.create(this.getLanguage(), name, qualname, rootNode, callTargets, arguments));
    }

    public final PMappingproxy createMappingproxy(Object object) {
        PythonBuiltinClassType mpClass = PythonBuiltinClassType.PMappingproxy;
        return this.trace(new PMappingproxy((Object)mpClass, mpClass.getInstanceShape(this.getLanguage()), object));
    }

    public final PMappingproxy createMappingproxy(Object cls, Object object) {
        return this.trace(new PMappingproxy(cls, this.getShape(cls), object));
    }

    public final PReferenceType createReferenceType(Object cls, Object object, Object callback, ReferenceQueue<Object> queue) {
        return this.trace(new PReferenceType(cls, this.getShape(cls), object, callback, queue));
    }

    public final PReferenceType createReferenceType(Object object, Object callback, ReferenceQueue<Object> queue) {
        return this.createReferenceType((Object)PythonBuiltinClassType.PReferenceType, object, callback, queue);
    }

    public final PCell createCell(Assumption effectivelyFinal) {
        return this.trace(new PCell(effectivelyFinal));
    }

    public final PFrame createPFrame(PFrame.Reference frameInfo, Node location, MaterializedFrame locals) {
        return this.trace(new PFrame(this.getLanguage(), frameInfo, location, locals));
    }

    public final PFrame createPFrame(Object threadState, PCode code, PythonObject globals, Object localsDict) {
        return this.trace(new PFrame(this.getLanguage(), threadState, code, globals, localsDict));
    }

    public final PTraceback createTraceback(PFrame frame, int lineno, PTraceback next) {
        return this.trace(new PTraceback(this.getLanguage(), frame, lineno, next));
    }

    public final PTraceback createTraceback(PFrame frame, int lineno, int lasti, PTraceback next) {
        return this.trace(new PTraceback(this.getLanguage(), frame, lineno, lasti, next));
    }

    public final PTraceback createTraceback(LazyTraceback tb) {
        return this.trace(new PTraceback(this.getLanguage(), tb));
    }

    public final PBaseException createBaseException(Object cls, PTuple args) {
        return this.createBaseException(cls, null, args);
    }

    public final PBaseException createBaseException(Object cls, Object[] data, PTuple args) {
        return this.trace(new PBaseException(cls, this.getShape(cls), data, args));
    }

    public final PBaseException createBaseException(Object cls, TruffleString format, Object[] args) {
        return this.createBaseException(cls, null, format, args);
    }

    public final PBaseException createBaseException(Object cls, Object[] data, TruffleString format, Object[] args) {
        assert (format != null);
        return this.trace(new PBaseException(cls, this.getShape(cls), data, format, args));
    }

    public final PBaseException createBaseException(Object cls) {
        return this.trace(new PBaseException(cls, this.getShape(cls), null));
    }

    public final PBaseException createBaseException(Object cls, Object[] data) {
        return this.trace(new PBaseException(cls, this.getShape(cls), data));
    }

    public final PArray createArray(Object cls, TruffleString formatString, BufferFormat format) {
        assert (format != null);
        return this.trace(new PArray(cls, this.getShape(cls), formatString, format));
    }

    public final PArray createArray(TruffleString formatString, BufferFormat format, int length) throws OverflowException {
        return this.createArray((Object)PythonBuiltinClassType.PArray, formatString, format, length);
    }

    public final PArray createArray(Object cls, TruffleString formatString, BufferFormat format, int length) throws OverflowException {
        assert (format != null);
        return this.trace(new PArray(cls, this.getShape(cls), formatString, format, length));
    }

    public final PByteArray createByteArray(byte[] array) {
        return this.createByteArray(array, array.length);
    }

    public final PByteArray createByteArray(Object cls, byte[] array) {
        return this.createByteArray(cls, array, array.length);
    }

    public final PByteArray createByteArray(byte[] array, int length) {
        return this.createByteArray(new ByteSequenceStorage(array, length));
    }

    public final PByteArray createByteArray(Object cls, byte[] array, int length) {
        return this.createByteArray(cls, new ByteSequenceStorage(array, length));
    }

    public final PByteArray createByteArray(SequenceStorage storage) {
        return this.createByteArray((Object)PythonBuiltinClassType.PByteArray, storage);
    }

    public final PByteArray createByteArray(Object cls, SequenceStorage storage) {
        return this.trace(new PByteArray(cls, this.getShape(cls), storage));
    }

    public final PStringIterator createStringIterator(TruffleString str) {
        return this.trace(new PStringIterator((Object)PythonBuiltinClassType.PIterator, PythonBuiltinClassType.PIterator.getInstanceShape(this.getLanguage()), str));
    }

    public final PStringReverseIterator createStringReverseIterator(Object cls, TruffleString str) {
        return this.trace(new PStringReverseIterator(cls, this.getShape(cls), str));
    }

    public final PIntegerSequenceIterator createIntegerSequenceIterator(IntSequenceStorage storage, Object list) {
        return this.trace(new PIntegerSequenceIterator((Object)PythonBuiltinClassType.PIterator, PythonBuiltinClassType.PIterator.getInstanceShape(this.getLanguage()), storage, list));
    }

    public final PLongSequenceIterator createLongSequenceIterator(LongSequenceStorage storage, Object list) {
        return this.trace(new PLongSequenceIterator((Object)PythonBuiltinClassType.PIterator, PythonBuiltinClassType.PIterator.getInstanceShape(this.getLanguage()), storage, list));
    }

    public final PDoubleSequenceIterator createDoubleSequenceIterator(DoubleSequenceStorage storage, Object list) {
        return this.trace(new PDoubleSequenceIterator((Object)PythonBuiltinClassType.PIterator, PythonBuiltinClassType.PIterator.getInstanceShape(this.getLanguage()), storage, list));
    }

    public final PObjectSequenceIterator createObjectSequenceIterator(ObjectSequenceStorage storage, Object list) {
        return this.trace(new PObjectSequenceIterator((Object)PythonBuiltinClassType.PIterator, PythonBuiltinClassType.PIterator.getInstanceShape(this.getLanguage()), storage, list));
    }

    public final PSequenceIterator createSequenceIterator(Object sequence) {
        return this.trace(new PSequenceIterator((Object)PythonBuiltinClassType.PIterator, PythonBuiltinClassType.PIterator.getInstanceShape(this.getLanguage()), sequence));
    }

    public final PSequenceReverseIterator createSequenceReverseIterator(Object cls, Object sequence, int lengthHint) {
        return this.trace(new PSequenceReverseIterator(cls, this.getShape(cls), sequence, lengthHint));
    }

    public final PIntRangeIterator createIntRangeIterator(PIntRange fastRange) {
        return this.createIntRangeIterator(fastRange.getIntStart(), fastRange.getIntStop(), fastRange.getIntStep(), fastRange.getIntLength());
    }

    public final PIntRangeIterator createIntRangeIterator(int start, int stop, int step, int len) {
        return this.trace(new PIntRangeIterator((Object)PythonBuiltinClassType.PIterator, PythonBuiltinClassType.PIterator.getInstanceShape(this.getLanguage()), start, stop, step, len));
    }

    public final PBigRangeIterator createBigRangeIterator(PInt start, PInt stop, PInt step, PInt len) {
        return this.trace(new PBigRangeIterator((Object)PythonBuiltinClassType.PIterator, PythonBuiltinClassType.PIterator.getInstanceShape(this.getLanguage()), start, stop, step, len));
    }

    public final PBigRangeIterator createBigRangeIterator(PBigRange longRange) {
        return this.createBigRangeIterator(longRange.getPIntStart(), longRange.getPIntStop(), longRange.getPIntStep(), longRange.getPIntLength());
    }

    public final PBigRangeIterator createBigRangeIterator(BigInteger start, BigInteger stop, BigInteger step, BigInteger len) {
        return this.createBigRangeIterator(this.createInt(start), this.createInt(stop), this.createInt(step), this.createInt(len));
    }

    public final PArrayIterator createArrayIterator(PArray array) {
        return this.trace(new PArrayIterator((Object)PythonBuiltinClassType.PArrayIterator, PythonBuiltinClassType.PArrayIterator.getInstanceShape(this.getLanguage()), array));
    }

    public final PBaseSetIterator createBaseSetIterator(PBaseSet set, HashingStorageNodes.HashingStorageIterator iterator, int initialSize) {
        return this.trace(new PBaseSetIterator((Object)PythonBuiltinClassType.PIterator, PythonBuiltinClassType.PIterator.getInstanceShape(this.getLanguage()), set, iterator, initialSize));
    }

    public final PDictView.PDictItemIterator createDictItemIterator(HashingStorageNodes.HashingStorageIterator iterator, HashingStorage hashingStorage, int initialSize) {
        return this.trace(new PDictView.PDictItemIterator((Object)PythonBuiltinClassType.PDictItemIterator, PythonBuiltinClassType.PDictItemIterator.getInstanceShape(this.getLanguage()), iterator, hashingStorage, initialSize));
    }

    public final PDictView.PDictKeyIterator createDictKeyIterator(HashingStorageNodes.HashingStorageIterator iterator, HashingStorage hashingStorage, int initialSize) {
        return this.trace(new PDictView.PDictKeyIterator((Object)PythonBuiltinClassType.PDictKeyIterator, PythonBuiltinClassType.PDictKeyIterator.getInstanceShape(this.getLanguage()), iterator, hashingStorage, initialSize));
    }

    public final PDictView.PDictValueIterator createDictValueIterator(HashingStorageNodes.HashingStorageIterator iterator, HashingStorage hashingStorage, int initialSize) {
        return this.trace(new PDictView.PDictValueIterator((Object)PythonBuiltinClassType.PDictValueIterator, PythonBuiltinClassType.PDictValueIterator.getInstanceShape(this.getLanguage()), iterator, hashingStorage, initialSize));
    }

    public final Object createSentinelIterator(Object callable, Object sentinel) {
        return this.trace(new PSentinelIterator((Object)PythonBuiltinClassType.PSentinelIterator, PythonBuiltinClassType.PSentinelIterator.getInstanceShape(this.getLanguage()), callable, sentinel));
    }

    public final PEnumerate createEnumerate(Object cls, Object iterator, long start) {
        return this.trace(new PEnumerate(cls, this.getShape(cls), iterator, start));
    }

    public final PEnumerate createEnumerate(Object cls, Object iterator, PInt start) {
        return this.trace(new PEnumerate(cls, this.getShape(cls), iterator, start));
    }

    public final PMap createMap(Object cls) {
        return this.trace(new PMap(cls, this.getShape(cls)));
    }

    public final PZip createZip(Object cls, Object[] iterables, boolean strict) {
        return this.trace(new PZip(cls, this.getShape(cls), iterables, strict));
    }

    public final PForeignArrayIterator createForeignArrayIterator(Object iterable) {
        return this.trace(new PForeignArrayIterator((Object)PythonBuiltinClassType.PForeignArrayIterator, PythonBuiltinClassType.PForeignArrayIterator.getInstanceShape(this.getLanguage()), iterable));
    }

    public final PCode createCode(RootCallTarget ct) {
        return this.trace(new PCode((Object)PythonBuiltinClassType.PCode, PythonBuiltinClassType.PCode.getInstanceShape(this.getLanguage()), ct));
    }

    public final PCode createCode(RootCallTarget ct, int flags, int firstlineno, byte[] linetable, TruffleString filename) {
        return this.trace(new PCode((Object)PythonBuiltinClassType.PCode, PythonBuiltinClassType.PCode.getInstanceShape(this.getLanguage()), ct, flags, firstlineno, linetable, filename));
    }

    public final PCode createCode(RootCallTarget callTarget, Signature signature, CodeUnit codeUnit) {
        return this.trace(new PCode((Object)PythonBuiltinClassType.PCode, this.getShape(PythonBuiltinClassType.PCode), callTarget, signature, codeUnit));
    }

    public final PCode createCode(RootCallTarget callTarget, Signature signature, int nlocals, int stacksize, int flags, Object[] constants, TruffleString[] names, TruffleString[] varnames, TruffleString[] freevars, TruffleString[] cellvars, TruffleString filename, TruffleString name, int firstlineno, byte[] linetable) {
        return this.trace(new PCode((Object)PythonBuiltinClassType.PCode, this.getShape(PythonBuiltinClassType.PCode), callTarget, signature, nlocals, stacksize, flags, constants, names, varnames, freevars, cellvars, filename, name, firstlineno, linetable));
    }

    public PCode createCode(Supplier<CallTarget> createCode, int flags, int firstlineno, byte[] lnotab, TruffleString filename) {
        return this.trace(new PCode((Object)PythonBuiltinClassType.PCode, this.getShape(PythonBuiltinClassType.PCode), createCode, flags, firstlineno, lnotab, filename));
    }

    public final PSocket createSocket(Object cls) {
        return this.trace(new PSocket(cls, this.getShape(cls)));
    }

    public PThreadLocal createThreadLocal(Object cls, Object[] args, PKeyword[] kwArgs) {
        return this.trace(new PThreadLocal(cls, this.getShape(cls), args, kwArgs));
    }

    public final PLock createLock() {
        return this.createLock((Object)PythonBuiltinClassType.PLock);
    }

    public final PLock createLock(Object cls) {
        return this.trace(new PLock(cls, this.getShape(cls)));
    }

    public final PRLock createRLock() {
        return this.createRLock((Object)PythonBuiltinClassType.PRLock);
    }

    public final PRLock createRLock(Object cls) {
        return this.trace(new PRLock(cls, this.getShape(cls)));
    }

    public final PThread createPythonThread(Thread thread) {
        return this.trace(new PThread((Object)PythonBuiltinClassType.PThread, PythonBuiltinClassType.PThread.getInstanceShape(this.getLanguage()), thread));
    }

    public final PThread createPythonThread(Object cls, Thread thread) {
        return this.trace(new PThread(cls, this.getShape(cls), thread));
    }

    public final PSemLock createSemLock(Object cls, long handle, int kind, int maxValue, TruffleString name) {
        return this.trace(new PSemLock(cls, this.getShape(cls), handle, kind, maxValue, name));
    }

    public final PGraalPySemLock createGraalPySemLock(Object cls, TruffleString name, int kind, Semaphore sharedSemaphore) {
        return this.trace(new PGraalPySemLock(cls, this.getShape(cls), name, kind, sharedSemaphore));
    }

    public final PScandirIterator createScandirIterator(PythonContext context, Object dirStream, PosixModuleBuiltins.PosixFileHandle path, boolean needsRewind) {
        return this.trace(new PScandirIterator((Object)PythonBuiltinClassType.PScandirIterator, PythonBuiltinClassType.PScandirIterator.getInstanceShape(this.getLanguage()), context, dirStream, path, needsRewind));
    }

    public final PDirEntry createDirEntry(Object dirEntryData, PosixModuleBuiltins.PosixFileHandle path) {
        return this.trace(new PDirEntry((Object)PythonBuiltinClassType.PDirEntry, PythonBuiltinClassType.PDirEntry.getInstanceShape(this.getLanguage()), dirEntryData, path));
    }

    public final PEncodingMap createEncodingMap(int count2, int count3, byte[] level1, byte[] level23) {
        return this.trace(new PEncodingMap((Object)PythonBuiltinClassType.PEncodingMap, PythonBuiltinClassType.PEncodingMap.getInstanceShape(this.getLanguage()), count2, count3, level1, level23));
    }

    public final PMMap createMMap(PythonContext context, Object clazz, Object mmapHandle, int fd, long length, int access) {
        return this.trace(new PMMap(clazz, this.getShape(clazz), context, mmapHandle, fd, length, access));
    }

    public final BZ2Object.BZ2Compressor createBZ2Compressor(Object clazz) {
        return this.trace(BZ2Object.createCompressor(clazz, this.getShape(clazz)));
    }

    public final BZ2Object.BZ2Decompressor createBZ2Decompressor(Object clazz) {
        return this.trace(BZ2Object.createDecompressor(clazz, this.getShape(clazz)));
    }

    public final ZLibCompObject createJavaZLibCompObject(Object clazz, Object stream, int level, int wbits, int strategy, byte[] zdict) {
        return this.trace(ZLibCompObject.createJava(clazz, this.getShape(clazz), stream, level, wbits, strategy, zdict));
    }

    public final ZLibCompObject createJavaZLibCompObject(Object clazz, Object stream, int wbits, byte[] zdict) {
        return this.trace(ZLibCompObject.createJava(clazz, this.getShape(clazz), stream, wbits, zdict));
    }

    public final ZLibCompObject createNativeZLibCompObject(Object clazz, Object zst, NFIZlibSupport zlibSupport) {
        return this.trace(ZLibCompObject.createNative(clazz, this.getShape(clazz), zst, zlibSupport));
    }

    public final LZMAObject.LZMADecompressor createLZMADecompressor(Object clazz, boolean isNative) {
        return this.trace(LZMAObject.createDecompressor(clazz, this.getShape(clazz), isNative));
    }

    public final LZMAObject.LZMACompressor createLZMACompressor(Object clazz, boolean isNative) {
        return this.trace(LZMAObject.createCompressor(clazz, this.getShape(clazz), isNative));
    }

    public final CSVReader createCSVReader(Object clazz, Object inputIter, CSVDialect dialect) {
        return this.trace(new CSVReader(clazz, this.getShape(clazz), inputIter, dialect));
    }

    public final CSVWriter createCSVWriter(Object clazz, Object write, CSVDialect dialect) {
        return this.trace(new CSVWriter(clazz, this.getShape(clazz), write, dialect));
    }

    public final CSVDialect createCSVDialect(Object clazz, TruffleString delimiter, int delimiterCodePoint, boolean doubleQuote, TruffleString escapeChar, int escapeCharCodePoint, TruffleString lineTerminator, TruffleString quoteChar, int quoteCharCodePoint, QuoteStyle quoting, boolean skipInitialSpace, boolean strict) {
        return this.trace(new CSVDialect(clazz, this.getShape(clazz), delimiter, delimiterCodePoint, doubleQuote, escapeChar, escapeCharCodePoint, lineTerminator, quoteChar, quoteCharCodePoint, quoting, skipInitialSpace, strict));
    }

    public final PFileIO createFileIO(Object clazz) {
        return this.trace(new PFileIO(clazz, this.getShape(clazz)));
    }

    public final PChain createChain(Object cls) {
        return this.trace(new PChain(cls, this.getShape(cls)));
    }

    public final PCount createCount(Object cls) {
        return this.trace(new PCount(cls, this.getShape(cls)));
    }

    public final PIslice createIslice(Object cls) {
        return this.trace(new PIslice(cls, this.getShape(cls)));
    }

    public final PPairwise createPairwise(Object cls) {
        return this.trace(new PPairwise(cls, this.getShape(cls)));
    }

    public final PPermutations createPermutations(Object cls) {
        return this.trace(new PPermutations(cls, this.getShape(cls)));
    }

    public final PProduct createProduct(Object cls) {
        return this.trace(new PProduct(cls, this.getShape(cls)));
    }

    public final PRepeat createRepeat(Object cls) {
        return this.trace(new PRepeat(cls, this.getShape(cls)));
    }

    public final PAccumulate createAccumulate(Object cls) {
        return this.trace(new PAccumulate(cls, this.getShape(cls)));
    }

    public final PDropwhile createDropwhile(Object cls) {
        return this.trace(new PDropwhile(cls, this.getShape(cls)));
    }

    public final PCombinations createCombinations(Object cls) {
        return this.trace(new PCombinations(cls, this.getShape(cls)));
    }

    public final PCombinationsWithReplacement createCombinationsWithReplacement(Object cls) {
        return this.trace(new PCombinationsWithReplacement(cls, this.getShape(cls)));
    }

    public final PCompress createCompress(Object cls) {
        return this.trace(new PCompress(cls, this.getShape(cls)));
    }

    public final PCycle createCycle(Object cls) {
        return this.trace(new PCycle(cls, this.getShape(cls)));
    }

    public final PFilterfalse createFilterfalse(Object cls) {
        return this.trace(new PFilterfalse(cls, this.getShape(cls)));
    }

    public final PGroupBy createGroupBy(Object cls) {
        return this.trace(new PGroupBy(cls, this.getShape(cls)));
    }

    public final PGrouper createGrouper(Object cls) {
        return this.trace(new PGrouper(cls, this.getShape(cls)));
    }

    public final PGrouper createGrouper(PGroupBy parent, Object tgtKey) {
        return this.trace(new PGrouper(parent, tgtKey, (Object)PythonBuiltinClassType.PGrouper, PythonBuiltinClassType.PGrouper.getInstanceShape(this.getLanguage())));
    }

    public final PTee createTee() {
        return this.trace(new PTee((Object)PythonBuiltinClassType.PTee, PythonBuiltinClassType.PTee.getInstanceShape(this.getLanguage())));
    }

    public final PTee createTee(PTeeDataObject dataObj, int index) {
        return this.trace(new PTee(dataObj, index, (Object)PythonBuiltinClassType.PTee, PythonBuiltinClassType.PTee.getInstanceShape(this.getLanguage())));
    }

    public final PStarmap createStarmap(Object cls) {
        return this.trace(new PStarmap(cls, this.getShape(cls)));
    }

    public final PTakewhile createTakewhile(Object cls) {
        return this.trace(new PTakewhile(cls, this.getShape(cls)));
    }

    public final PTeeDataObject createTeeDataObject() {
        return this.trace(new PTeeDataObject((Object)PythonBuiltinClassType.PTeeDataObject, PythonBuiltinClassType.PTeeDataObject.getInstanceShape(this.getLanguage())));
    }

    public final PTeeDataObject createTeeDataObject(Object it) {
        return this.trace(new PTeeDataObject(it, (Object)PythonBuiltinClassType.PTeeDataObject, PythonBuiltinClassType.PTeeDataObject.getInstanceShape(this.getLanguage())));
    }

    public final PZipLongest createZipLongest(Object cls) {
        return this.trace(new PZipLongest(cls, this.getShape(cls)));
    }

    public final PTextIO createTextIO(Object clazz) {
        return this.trace(new PTextIO(clazz, this.getShape(clazz)));
    }

    public final PStringIO createStringIO(Object clazz) {
        return this.trace(new PStringIO(clazz, this.getShape(clazz)));
    }

    public final PBytesIO createBytesIO(Object clazz) {
        return this.trace(new PBytesIO(clazz, this.getShape(clazz)));
    }

    public final PBytesIOBuffer createBytesIOBuf(Object clazz, PBytesIO source) {
        return this.trace(new PBytesIOBuffer(clazz, this.getShape(clazz), source));
    }

    public final PNLDecoder createNLDecoder(Object clazz) {
        return this.trace(new PNLDecoder(clazz, this.getShape(clazz)));
    }

    public final PBuffered createBufferedReader(Object clazz) {
        return this.trace(new PBuffered(clazz, this.getShape(clazz), true, false));
    }

    public final PBuffered createBufferedWriter(Object clazz) {
        return this.trace(new PBuffered(clazz, this.getShape(clazz), false, true));
    }

    public final PBuffered createBufferedRandom(Object clazz) {
        return this.trace(new PBuffered(clazz, this.getShape(clazz), true, true));
    }

    public final PRWPair createRWPair(Object clazz) {
        return this.trace(new PRWPair(clazz, this.getShape(clazz)));
    }

    public final PyCArgObject createCArgObject() {
        return this.trace(new PyCArgObject((Object)PythonBuiltinClassType.CArgObject, this.getShape(PythonBuiltinClassType.CArgObject)));
    }

    public final CThunkObject createCThunkObject(Object clazz, int nArgs) {
        return this.trace(new CThunkObject(clazz, this.getShape(clazz), nArgs));
    }

    public final StructParamObject createStructParamObject(Object clazz) {
        return this.trace(new StructParamObject(clazz, this.getShape(clazz)));
    }

    public final CDataObject createCDataObject(Object clazz, Pointer b_ptr, int b_size, boolean b_needsfree) {
        return this.trace(new CDataObject(clazz, this.getShape(clazz), b_ptr, b_size, b_needsfree));
    }

    public final PyCFuncPtrObject createPyCFuncPtrObject(Object clazz, Pointer b_ptr, int b_size, boolean b_needsfree) {
        return this.trace(new PyCFuncPtrObject(clazz, this.getShape(clazz), b_ptr, b_size, b_needsfree));
    }

    public final CFieldObject createCFieldObject(Object clazz) {
        return this.trace(new CFieldObject(clazz, this.getShape(clazz)));
    }

    public final StgDictObject createStgDictObject(Object clazz) {
        return this.trace(new StgDictObject(clazz, this.getShape(clazz)));
    }

    public final PSSLContext createSSLContext(Object clazz, SSLMethod method, int verifyFlags, boolean checkHostname, int verifyMode, SSLContext context) {
        return this.trace(new PSSLContext(clazz, this.getShape(clazz), method, verifyFlags, checkHostname, verifyMode, context));
    }

    public final PSSLSocket createSSLSocket(Object clazz, PSSLContext context, SSLEngine engine, PSocket socket) {
        return this.trace(new PSSLSocket(clazz, this.getShape(clazz), context, engine, socket, this.createMemoryBIO(), this.createMemoryBIO(), this.createMemoryBIO()));
    }

    public final PSSLSocket createSSLSocket(Object clazz, PSSLContext context, SSLEngine engine, PMemoryBIO inbound, PMemoryBIO outbound) {
        return this.trace(new PSSLSocket(clazz, this.getShape(clazz), context, engine, null, inbound, outbound, this.createMemoryBIO()));
    }

    public final PMemoryBIO createMemoryBIO(Object clazz) {
        return this.trace(new PMemoryBIO(clazz, this.getShape(clazz)));
    }

    public final PMemoryBIO createMemoryBIO() {
        return this.trace(new PMemoryBIO((Object)PythonBuiltinClassType.PMemoryBIO, this.getShape(PythonBuiltinClassType.PMemoryBIO)));
    }

    public final PProperty createProperty() {
        return this.trace(new PProperty((Object)PythonBuiltinClassType.PProperty, this.getShape(PythonBuiltinClassType.PProperty)));
    }

    public final PProperty createProperty(Object cls) {
        return this.trace(new PProperty(cls, this.getShape(cls)));
    }

    @CompilerDirectives.TruffleBoundary
    public final PJSONScanner createJSONScanner(Object clazz, boolean strict, Object objectHook, Object objectPairsHook, Object parseFloat, Object parseInt, Object parseConstant) {
        return this.trace(new PJSONScanner(clazz, this.getShape(clazz), strict, objectHook, objectPairsHook, parseFloat, parseInt, parseConstant));
    }

    @CompilerDirectives.TruffleBoundary
    public final PJSONEncoder createJSONEncoder(Object clazz, Object markers, Object defaultFn, Object encoder, Object indent, TruffleString keySeparator, TruffleString itemSeparator, boolean sortKeys, boolean skipKeys, boolean allowNan, PJSONEncoder.FastEncode fastEncode) {
        return this.trace(new PJSONEncoder(clazz, this.getShape(clazz), markers, defaultFn, encoder, indent, keySeparator, itemSeparator, sortKeys, skipKeys, allowNan, fastEncode));
    }

    public final PDeque createDeque() {
        return this.trace(new PDeque((Object)PythonBuiltinClassType.PDeque, this.getShape(PythonBuiltinClassType.PDeque)));
    }

    public final PDeque createDeque(Object cls) {
        return this.trace(new PDeque(cls, this.getShape(cls)));
    }

    public final PDequeIter createDequeIter(PDeque deque) {
        return this.trace(new PDequeIter((Object)PythonBuiltinClassType.PDequeIter, this.getShape(PythonBuiltinClassType.PDequeIter), deque, false));
    }

    public final PDequeIter createDequeRevIter(PDeque deque) {
        return this.trace(new PDequeIter((Object)PythonBuiltinClassType.PDequeRevIter, this.getShape(PythonBuiltinClassType.PDequeRevIter), deque, true));
    }

    public final PSimpleQueue createSimpleQueue(Object cls) {
        return this.trace(new PSimpleQueue(cls, this.getShape(cls)));
    }

    public final PContextVar createContextVar(TruffleString name, Object def) {
        return this.trace(new PContextVar((Object)PythonBuiltinClassType.ContextVar, this.getShape(PythonBuiltinClassType.ContextVar), name, def));
    }

    public final PContextVarsContext createContextVarsContext() {
        return this.trace(new PContextVarsContext((Object)PythonBuiltinClassType.ContextVarsContext, this.getShape(PythonBuiltinClassType.ContextVarsContext)));
    }

    public final PContextIterator createContextIterator(PContextVarsContext ctx, PContextIterator.ItemKind kind) {
        return this.trace(new PContextIterator((Object)PythonBuiltinClassType.ContextIterator, this.getShape(PythonBuiltinClassType.ContextIterator), ctx, kind));
    }

    public final PContextVarsContext copyContextVarsContext(PContextVarsContext original) {
        return this.trace(new PContextVarsContext(original, (Object)PythonBuiltinClassType.ContextVarsContext, this.getShape(PythonBuiltinClassType.ContextVarsContext)));
    }

    public final PContextVarsToken createContextVarsToken(PContextVar var, Object oldValue) {
        return this.trace(new PContextVarsToken(var, oldValue, (Object)PythonBuiltinClassType.ContextVarsToken, this.getShape(PythonBuiltinClassType.ContextVarsToken)));
    }

    public final PGenericAlias createGenericAlias(Object cls, Object origin, Object arguments) {
        PTuple argumentsTuple = arguments instanceof PTuple ? (PTuple)arguments : this.createTuple(new Object[]{arguments});
        return this.trace(new PGenericAlias(cls, this.getShape(cls), origin, argumentsTuple));
    }

    public final PGenericAlias createGenericAlias(Object origin, Object arguments) {
        return this.createGenericAlias((Object)PythonBuiltinClassType.PGenericAlias, origin, arguments);
    }

    public final PUnionType createUnionType(Object[] args) {
        return this.trace(new PUnionType((Object)PythonBuiltinClassType.PUnionType, this.getShape(PythonBuiltinClassType.PUnionType), this.createTuple(args)));
    }

    public final DigestObject createDigestObject(PythonBuiltinClassType type, String name, Object digest) {
        return this.trace(DigestObject.create(type, this.getShape(type), name, digest));
    }

    public final PyCapsule createCapsule(Object pointer, Object name, Object destructor) {
        return this.trace(new PyCapsule(this.getLanguage(), pointer, name, destructor));
    }

    public final MultibyteIncrementalDecoderObject createMultibyteIncrementalDecoderObject(Object type) {
        return this.trace(new MultibyteIncrementalDecoderObject(type, this.getShape(type)));
    }

    public final MultibyteIncrementalEncoderObject createMultibyteIncrementalEncoderObject(Object type) {
        return this.trace(new MultibyteIncrementalEncoderObject(type, this.getShape(type)));
    }

    public final MultibyteStreamReaderObject createMultibyteStreamReaderObject(Object type) {
        return this.trace(new MultibyteStreamReaderObject(type, this.getShape(type)));
    }

    public final MultibyteStreamWriterObject createMultibyteStreamWriterObject(Object type) {
        return this.trace(new MultibyteStreamWriterObject(type, this.getShape(type)));
    }

    public final MultibyteCodecObject createMultibyteCodecObject(Object type, MultibyteCodec codec) {
        return this.trace(new MultibyteCodecObject(type, this.getShape(type), codec));
    }

    public PAsyncGenASend createAsyncGeneratorASend(PAsyncGen receiver, Object message) {
        return this.trace(new PAsyncGenASend(this.getLanguage(), receiver, message));
    }

    public PAsyncGenAThrow createAsyncGeneratorAThrow(PAsyncGen receiver, Object arg1, Object arg2, Object arg3) {
        return this.trace(new PAsyncGenAThrow(this.getLanguage(), receiver, arg1, arg2, arg3));
    }

    public PAsyncGenWrappedValue createAsyncGeneratorWrappedValue(Object wrapped) {
        return this.trace(new PAsyncGenWrappedValue(this.getLanguage(), wrapped));
    }

    @GenerateInline
    @GenerateUncached
    @GenerateCached(value=false)
    public static abstract class Lazy
    extends Node {
        public static Lazy getUncached() {
            return PythonObjectFactoryNodeGen.LazyNodeGen.getUncached();
        }

        public final PythonObjectFactory get(Node inliningTarget) {
            return this.execute(inliningTarget);
        }

        abstract PythonObjectFactory execute(Node var1);

        @Specialization
        static PythonObjectFactory doIt(@Cached(inline=false) PythonObjectFactory node) {
            return node;
        }
    }
}

