/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.memoryview.MemoryViewBuiltins;
import com.oracle.graal.python.builtins.objects.memoryview.MemoryViewNodes;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.lib.PyMemoryViewFromObject;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.util.BufferFormat;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextMemoryViewBuiltins {
    public static final int PY_BUF_READ = 256;
    public static final int PY_BUF_WRITE = 512;

    static abstract class PyMemoryView_FromObject
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyMemoryView_FromObject() {
        }

        @Specialization
        static Object wrap(Object object, @Cached PyMemoryViewFromObject memoryViewNode) {
            return memoryViewNode.execute(null, object);
        }
    }

    static abstract class PyMemoryView_GetContiguous
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyMemoryView_GetContiguous() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object get(Object obj, int buffertype, byte orderByte, @Bind(value="this") Node inliningTarget, @Cached PyMemoryViewFromObject memoryViewFromObject, @Cached MemoryViewNodes.ReleaseNode releaseNode, @Cached MemoryViewBuiltins.ToBytesNode toBytesNode, @Cached MemoryViewBuiltins.CastNode castNode, @Cached MemoryViewBuiltins.ContiguousNode contiguousNode, @Cached TruffleString.EqualNode eqNode, @Cached TruffleString.FromCodePointNode fromCodePointNode, @Cached PRaiseNode.Lazy raiseNode) {
            assert (buffertype == 256 || buffertype == 512);
            char order = (char)orderByte;
            assert (order == 'C' || order == 'F' || order == 'A');
            PMemoryView mv = memoryViewFromObject.execute(null, obj);
            boolean release = true;
            try {
                if (buffertype == 512 && mv.isReadOnly()) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.BufferError, ErrorMessages.UNDERLYING_BUFFER_IS_NOT_WRITABLE);
                }
                if (((Boolean)contiguousNode.execute(null, mv)).booleanValue()) {
                    release = false;
                    PMemoryView pMemoryView = mv;
                    return pMemoryView;
                }
                if (buffertype == 512) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.BufferError, ErrorMessages.WRITABLE_CONTIGUES_FOR_NON_CONTIGUOUS);
                }
                PMemoryView mvBytes = memoryViewFromObject.execute(null, toBytesNode.execute(null, mv, fromCodePointNode.execute((int)order, PythonUtils.TS_ENCODING, true)));
                if (eqNode.execute((AbstractTruffleString)BufferFormat.T_UINT_8_TYPE_CODE, (AbstractTruffleString)mv.getFormatString(), PythonUtils.TS_ENCODING)) {
                    PMemoryView pMemoryView = mvBytes;
                    return pMemoryView;
                }
                try {
                    Object object = castNode.execute(null, mvBytes, mv.getFormatString(), PNone.NONE);
                    releaseNode.execute(mvBytes);
                    return object;
                }
                catch (Throwable throwable) {
                    releaseNode.execute(mvBytes);
                    throw throwable;
                }
            }
            finally {
                if (release && mv != null) {
                    releaseNode.execute(mv);
                }
            }
        }
    }
}

