/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.thread.PLock;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;

public final class PythonCextPyThreadBuiltins {
    private static final long LOCK_MASK = -6842093733882626048L;

    static abstract class PyThread_get_thread_ident
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyThread_get_thread_ident() {
        }

        @Specialization
        long get() {
            return Thread.currentThread().getId();
        }
    }

    static abstract class PyTruffle_tss_delete
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTruffle_tss_delete() {
        }

        @Specialization
        Object tssDelete(long key) {
            this.getCApiContext().tssDelete(key);
            return PNone.NONE;
        }
    }

    static abstract class PyTruffle_tss_set
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffle_tss_set() {
        }

        @Specialization
        int tssSet(long key, Object value) {
            this.getCApiContext().tssSet(key, value);
            return 0;
        }
    }

    static abstract class PyTruffle_tss_get
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTruffle_tss_get() {
        }

        @Specialization
        Object tssGet(long key) {
            Object value = this.getCApiContext().tssGet(key);
            if (value == null) {
                return this.getNULL();
            }
            return value;
        }
    }

    static abstract class PyTruffle_tss_create
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyTruffle_tss_create() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        long tssCreate() {
            return this.getCApiContext().nextTssKey();
        }
    }

    static abstract class PyThread_release_lock
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyThread_release_lock() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object release(long id) {
            CApiContext context = this.getCApiContext();
            PLock lock = context.locks.get(id);
            if (lock == null) {
                throw this.badInternalCall("lock");
            }
            lock.release();
            return PNone.NO_VALUE;
        }

        @Specialization(guards={"lib.isPointer(id)"}, limit="1")
        Object release(Object id, @CachedLibrary(value="id") InteropLibrary lib) {
            try {
                return this.release(lib.asPointer(id));
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
    }

    static abstract class PyThread_acquire_lock
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyThread_acquire_lock() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        int acquire(long id, int waitflag) {
            PLock lock = this.getCApiContext().locks.get(id);
            if (lock == null) {
                throw this.badInternalCall("lock");
            }
            boolean result = waitflag != 0 ? lock.acquireBlocking(this) : lock.acquireNonBlocking();
            return PInt.intValue(result);
        }

        @Specialization(guards={"lib.isPointer(id)"}, limit="1")
        int acquire(Object id, int waitflag, @CachedLibrary(value="id") InteropLibrary lib) {
            try {
                return this.acquire(lib.asPointer(id), waitflag);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
    }

    static abstract class PyThread_allocate_lock
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyThread_allocate_lock() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        long allocate() {
            CApiContext context = this.getCApiContext();
            long id = context.lockId.incrementAndGet() ^ 0xA10C000000000000L;
            PLock lock = PythonObjectFactory.getUncached().createLock((Object)PythonBuiltinClassType.PLock);
            context.locks.put(id, lock);
            return id;
        }
    }
}

