/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGuards;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccessFactory;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import java.util.logging.Level;

@GenerateInline
@GenerateCached(value=false)
@GenerateUncached
@ImportStatic(value={CApiGuards.class})
public abstract class PyTruffleObjectFree
extends Node {
    private static final TruffleLogger LOGGER = CApiContext.getLogger(PyTruffleObjectFree.class);

    public abstract int execute(Node var1, Object var2);

    @Specialization(guards={"!isCArrayWrapper(nativeWrapper)"})
    static int doNativeWrapper(Node inliningTarget, PythonNativeWrapper nativeWrapper, @Cached(inline=false) CStructAccess.FreeNode freeNode, @Cached CExtNodes.ClearNativeWrapperNode clearNativeWrapperNode) {
        Object delegate = nativeWrapper.getDelegate();
        clearNativeWrapperNode.execute(inliningTarget, delegate, nativeWrapper);
        PyTruffleObjectFree.releaseNativeWrapper(nativeWrapper, freeNode);
        return 1;
    }

    @Specialization
    static int arrayWrapper(CArrayWrappers.CArrayWrapper object) {
        return 1;
    }

    @Specialization(guards={"!isNativeWrapper(object)"})
    static int doOther(Object object) {
        return 0;
    }

    protected static boolean isCArrayWrapper(Object obj) {
        return obj instanceof CArrayWrappers.CArrayWrapper;
    }

    @CompilerDirectives.TruffleBoundary
    public static void releaseNativeWrapperUncached(PythonNativeWrapper nativeWrapper) {
        PyTruffleObjectFree.releaseNativeWrapper(nativeWrapper, CStructAccessFactory.FreeNodeGen.getUncached());
    }

    static void releaseNativeWrapper(PythonNativeWrapper nativeWrapper, CStructAccess.FreeNode freeNode) {
        if (nativeWrapper.isNative()) {
            long nativePointer = nativeWrapper.getNativePointer();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(PythonUtils.formatJString("Freeing pointer: 0x%x (wrapper: %s ;; object: %s)", nativePointer, nativeWrapper, nativeWrapper.getDelegate()));
            }
            if (CApiTransitions.HandlePointerConverter.pointsToPyHandleSpace(nativePointer)) {
                assert (PyTruffleObjectFree.tableEntryRemoved(PythonContext.get((Node)freeNode).nativeContext, nativeWrapper));
                nativePointer = CApiTransitions.HandlePointerConverter.pointerToStub(nativePointer);
            } else {
                CApiTransitions.nativeLookupRemove(PythonContext.get((Node)freeNode).nativeContext, nativePointer);
            }
            freeNode.free(nativePointer);
        }
    }

    private static boolean tableEntryRemoved(CApiTransitions.HandleContext context, PythonNativeWrapper nativeWrapper) {
        CApiTransitions.PythonObjectReference ref = nativeWrapper.ref;
        if (ref != null) {
            int id = ref.getHandleTableIndex();
            return id <= 0 || CApiTransitions.nativeStubLookupGet(context, nativeWrapper.getNativePointer(), id) == null;
        }
        return true;
    }
}

