/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.copying;

import com.oracle.graal.python.builtins.objects.cext.copying.ElfFile;
import com.oracle.graal.python.builtins.objects.cext.copying.NativeLibraryLocator;
import com.oracle.graal.python.builtins.objects.cext.copying.PEFile;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.io.TruffleProcessBuilder;
import java.io.IOException;
import java.io.OutputStream;

abstract class SharedObject
implements AutoCloseable {
    protected static final TruffleLogger LOGGER = NativeLibraryLocator.LOGGER;

    SharedObject() {
    }

    abstract void setId(String var1) throws IOException, InterruptedException;

    abstract void changeOrAddDependency(String var1, String var2) throws IOException, InterruptedException;

    abstract void write(TruffleFile var1) throws IOException, InterruptedException;

    @Override
    public abstract void close() throws IOException, InterruptedException;

    static SharedObject open(TruffleFile file, PythonContext context) throws IOException {
        byte[] f = file.readAllBytes();
        switch (f[0]) {
            case 127: {
                return new ElfFile(f, context);
            }
            case 77: 
            case 90: {
                return new PEFile(f, context);
            }
            case -54: 
            case -50: 
            case -49: 
            case -2: {
                throw new IOException("Modifying Mach-O files is not yet supported");
            }
        }
        throw new IOException("Unknown shared object format");
    }

    protected static TruffleProcessBuilder newProcessBuilder(PythonContext context) {
        TruffleProcessBuilder pb = context.getEnv().newProcessBuilder(new String[0]);
        pb.redirectOutput(pb.createRedirectToStream((OutputStream)new LoggingOutputStream()));
        pb.redirectError(pb.createRedirectToStream((OutputStream)new LoggingOutputStream()));
        return pb;
    }

    protected static final class LoggingOutputStream
    extends OutputStream {
        private final StringBuilder sb = new StringBuilder();

        protected LoggingOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.sb.append((char)b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.sb.append(new String(b, off, len));
        }

        @Override
        public void flush() {
            LOGGER.fine(this.sb::toString);
            this.sb.setLength(0);
        }
    }
}

