/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.thread;

import com.oracle.graal.python.builtins.objects.thread.AbstractPythonLock;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public final class PLock
extends AbstractPythonLock {
    private final Semaphore semaphore = new Semaphore(1);

    @CompilerDirectives.TruffleBoundary
    public PLock(Object cls, Shape instanceShape) {
        super(cls, instanceShape);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean acquireNonBlocking() {
        return this.semaphore.tryAcquire();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean acquireBlocking(Node node) {
        boolean[] b = new boolean[1];
        TruffleSafepoint.setBlockedThreadInterruptible((Node)node, s -> {
            s.acquire();
            b[0] = true;
        }, (Object)this.semaphore);
        return b[0];
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean acquireTimeout(Node node, long timeout) {
        boolean[] b = new boolean[1];
        TruffleSafepoint.setBlockedThreadInterruptible((Node)node, s -> {
            b[0] = s.tryAcquire(timeout, TimeUnit.MILLISECONDS);
        }, (Object)this.semaphore);
        return b[0];
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void release() {
        this.semaphore.release();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean locked() {
        return this.semaphore.availablePermits() == 0;
    }
}

