/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.tuple;

import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodesFactory;
import com.oracle.graal.python.builtins.objects.iterator.PBuiltinIterator;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyIndexCheckNodeGen;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNodeGen;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectHashNodeGen;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNodeGen;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.PyObjectRichCompareBoolFactory;
import com.oracle.graal.python.lib.PyTupleCheckExactNode;
import com.oracle.graal.python.lib.PyTupleCheckExactNodeGen;
import com.oracle.graal.python.lib.PyTupleCheckNode;
import com.oracle.graal.python.lib.PyTupleCheckNodeGen;
import com.oracle.graal.python.lib.PyTupleGetItem;
import com.oracle.graal.python.lib.PyTupleGetItemNodeGen;
import com.oracle.graal.python.lib.PyTupleSizeNode;
import com.oracle.graal.python.lib.PyTupleSizeNodeGen;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNodeGen;
import com.oracle.graal.python.nodes.builtins.TupleNodes;
import com.oracle.graal.python.nodes.builtins.TupleNodesFactory;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypesGen;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.object.PythonObjectFactoryNodeGen;
import com.oracle.graal.python.util.ComparisonOp;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;

@GeneratedBy(value=TupleBuiltins.class)
public final class TupleBuiltinsFactory {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final ComparisonOp[] COMPARISON_OP_VALUES = (ComparisonOp[])DSLSupport.lookupEnumConstants(ComparisonOp.class);

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return List.of(IndexNodeFactory.getInstance(), CountNodeFactory.getInstance(), LenNodeFactory.getInstance(), ReprNodeFactory.getInstance(), TupleSqItemFactory.getInstance(), GetItemNodeFactory.getInstance(), EqNodeFactory.getInstance(), NeNodeFactory.getInstance(), GeNodeFactory.getInstance(), LeNodeFactory.getInstance(), GtNodeFactory.getInstance(), LtNodeFactory.getInstance(), RichCompareNodeFactory.getInstance(), TupleConcatNodeFactory.getInstance(), MulNodeFactory.getInstance(), ContainsNodeFactory.getInstance(), IterNodeFactory.getInstance(), HashNodeFactory.getInstance(), GetNewargsNodeFactory.getInstance(), ClassGetItemNodeFactory.getInstance());
    }

    private static ComparisonOp decodeComparisonOp(int state) {
        if (state >= 0) {
            return COMPARISON_OP_VALUES[state];
        }
        return null;
    }

    private static int encodeComparisonOp(ComparisonOp e) {
        if (e != null) {
            return e.ordinal();
        }
        return -1;
    }

    @GeneratedBy(value=TupleBuiltins.IndexNode.class)
    public static final class IndexNodeFactory
    implements NodeFactory<TupleBuiltins.IndexNode> {
        private static final IndexNodeFactory INDEX_NODE_FACTORY_INSTANCE = new IndexNodeFactory();

        private IndexNodeFactory() {
        }

        public Class<TupleBuiltins.IndexNode> getNodeClass() {
            return TupleBuiltins.IndexNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public TupleBuiltins.IndexNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return IndexNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TupleBuiltins.IndexNode> getInstance() {
            return INDEX_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TupleBuiltins.IndexNode create() {
            return new IndexNodeGen();
        }

        @GeneratedBy(value=TupleBuiltins.IndexNode.class)
        public static final class IndexNodeGen
        extends TupleBuiltins.IndexNode {
            private static final InlineSupport.StateField STATE_0_IndexNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final TupleNodes.GetTupleStorage INLINED_GET_TUPLE_STORAGE_ = TupleNodesFactory.GetTupleStorageNodeGen.inline(InlineSupport.InlineTarget.create(TupleNodes.GetTupleStorage.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_IndexNode_UPDATER.subUpdater(5, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getTupleStorage__field1_", Node.class)}));
            private static final InlinedBranchProfile INLINED_START_LE0PROFILE_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_IndexNode_UPDATER.subUpdater(7, 1)}));
            private static final InlinedBranchProfile INLINED_END_LE0PROFILE_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_IndexNode_UPDATER.subUpdater(8, 1)}));
            private static final SequenceStorageNodes.ItemIndexNode INLINED_ITEM_INDEX_NODE_ = SequenceStorageNodesFactory.ItemIndexNodeGen.inline(InlineSupport.InlineTarget.create(SequenceStorageNodes.ItemIndexNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_IndexNode_UPDATER.subUpdater(9, 6), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"itemIndexNode__field1_", Node.class)}));
            private static final PRaiseNode.Lazy INLINED_RAISE_NODE_ = PRaiseNodeGen.LazyNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.Lazy.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_IndexNode_UPDATER.subUpdater(15, 1), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"raiseNode__field1_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getTupleStorage__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node itemIndexNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node raiseNode__field1_;

            private IndexNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value, Object arg3Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitInteger((state_0 & 6) >>> 1, arg2Value)) {
                    int arg2Value_ = PythonArithmeticTypesGen.asImplicitInteger((state_0 & 6) >>> 1, arg2Value);
                    if (PythonArithmeticTypesGen.isImplicitInteger((state_0 & 0x18) >>> 3, arg3Value)) {
                        int arg3Value_ = PythonArithmeticTypesGen.asImplicitInteger((state_0 & 0x18) >>> 3, arg3Value);
                        IndexNodeGen inliningTarget__ = this;
                        return this.index(frameValue, arg0Value, arg1Value, arg2Value_, arg3Value_, inliningTarget__, INLINED_GET_TUPLE_STORAGE_, INLINED_START_LE0PROFILE_, INLINED_END_LE0PROFILE_, INLINED_ITEM_INDEX_NODE_, INLINED_RAISE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private int executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value, Object arg3Value) {
                int state_0 = this.state_0_;
                IndexNodeGen inliningTarget__ = null;
                int intCast2 = PythonArithmeticTypesGen.specializeImplicitInteger(arg2Value);
                if (intCast2 != 0) {
                    int arg2Value_ = PythonArithmeticTypesGen.asImplicitInteger(intCast2, arg2Value);
                    int intCast3 = PythonArithmeticTypesGen.specializeImplicitInteger(arg3Value);
                    if (intCast3 != 0) {
                        int arg3Value_ = PythonArithmeticTypesGen.asImplicitInteger(intCast3, arg3Value);
                        inliningTarget__ = this;
                        state_0 |= intCast2 << 1;
                        state_0 |= intCast3 << 3;
                        this.state_0_ = state_0 |= 1;
                        return this.index(frameValue, arg0Value, arg1Value, arg2Value_, arg3Value_, inliningTarget__, INLINED_GET_TUPLE_STORAGE_, INLINED_START_LE0PROFILE_, INLINED_END_LE0PROFILE_, INLINED_ITEM_INDEX_NODE_, INLINED_RAISE_NODE_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value});
            }
        }
    }

    @GeneratedBy(value=TupleBuiltins.CountNode.class)
    public static final class CountNodeFactory
    implements NodeFactory<TupleBuiltins.CountNode> {
        private static final CountNodeFactory COUNT_NODE_FACTORY_INSTANCE = new CountNodeFactory();

        private CountNodeFactory() {
        }

        public Class<TupleBuiltins.CountNode> getNodeClass() {
            return TupleBuiltins.CountNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public TupleBuiltins.CountNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return CountNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TupleBuiltins.CountNode> getInstance() {
            return COUNT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TupleBuiltins.CountNode create() {
            return new CountNodeGen();
        }

        @GeneratedBy(value=TupleBuiltins.CountNode.class)
        public static final class CountNodeGen
        extends TupleBuiltins.CountNode {
            private static final InlineSupport.StateField STATE_0_CountNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final TupleNodes.GetTupleStorage INLINED_GET_TUPLE_STORAGE_ = TupleNodesFactory.GetTupleStorageNodeGen.inline(InlineSupport.InlineTarget.create(TupleNodes.GetTupleStorage.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_CountNode_UPDATER.subUpdater(1, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getTupleStorage__field1_", Node.class)}));
            private static final PyObjectRichCompareBool.EqNode INLINED_EQ_NODE_ = PyObjectRichCompareBoolFactory.EqNodeGen.inline(InlineSupport.InlineTarget.create(PyObjectRichCompareBool.EqNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_CountNode_UPDATER.subUpdater(3, 25), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"eqNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"eqNode__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getTupleStorage__field1_;
            @Node.Child
            private SequenceStorageNodes.GetItemNode getItemNode_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node eqNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node eqNode__field2_;

            private CountNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                SequenceStorageNodes.GetItemNode getItemNode__;
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && (getItemNode__ = this.getItemNode_) != null) {
                    CountNodeGen inliningTarget__ = this;
                    return this.count(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_GET_TUPLE_STORAGE_, getItemNode__, INLINED_EQ_NODE_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private long executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                CountNodeGen inliningTarget__ = null;
                inliningTarget__ = this;
                SequenceStorageNodes.GetItemNode getItemNode__ = (SequenceStorageNodes.GetItemNode)this.insert(SequenceStorageNodes.GetItemNode.createNotNormalized());
                Objects.requireNonNull(getItemNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.getItemNode_ = getItemNode__;
                this.state_0_ = state_0 |= 1;
                return this.count(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_GET_TUPLE_STORAGE_, getItemNode__, INLINED_EQ_NODE_);
            }
        }
    }

    @GeneratedBy(value=TupleBuiltins.LenNode.class)
    public static final class LenNodeFactory
    implements NodeFactory<TupleBuiltins.LenNode> {
        private static final LenNodeFactory LEN_NODE_FACTORY_INSTANCE = new LenNodeFactory();

        private LenNodeFactory() {
        }

        public Class<TupleBuiltins.LenNode> getNodeClass() {
            return TupleBuiltins.LenNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public TupleBuiltins.LenNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return LenNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public TupleBuiltins.LenNode getUncachedInstance() {
            return LenNodeGen.UNCACHED;
        }

        public static NodeFactory<TupleBuiltins.LenNode> getInstance() {
            return LEN_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TupleBuiltins.LenNode create() {
            return new LenNodeGen();
        }

        @NeverDefault
        public static TupleBuiltins.LenNode getUncached() {
            return LenNodeGen.UNCACHED;
        }

        @GeneratedBy(value=TupleBuiltins.LenNode.class)
        public static final class LenNodeGen
        extends TupleBuiltins.LenNode {
            private static final InlineSupport.StateField STATE_0_LenNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyTupleSizeNode INLINED_PY_TUPLE_SIZE_NODE_ = PyTupleSizeNodeGen.inline(InlineSupport.InlineTarget.create(PyTupleSizeNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_LenNode_UPDATER.subUpdater(0, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"pyTupleSizeNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"pyTupleSizeNode__field2_", Node.class)}));
            private static final Uncached UNCACHED = new Uncached();
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node pyTupleSizeNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node pyTupleSizeNode__field2_;

            private LenNodeGen() {
            }

            @Override
            public int executeInt(VirtualFrame frameValue, Object arg0Value) {
                LenNodeGen inliningTarget__ = this;
                return this.len(arg0Value, inliningTarget__, INLINED_PY_TUPLE_SIZE_NODE_);
            }

            @GeneratedBy(value=TupleBuiltins.LenNode.class)
            @DenyReplace
            private static final class Uncached
            extends TupleBuiltins.LenNode
            implements UnadoptableNode {
                private Uncached() {
                }

                @Override
                public int executeInt(VirtualFrame frameValue, Object arg0Value) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return this.len(arg0Value, this, PyTupleSizeNodeGen.getUncached());
                }
            }
        }
    }

    @GeneratedBy(value=TupleBuiltins.ReprNode.class)
    public static final class ReprNodeFactory
    implements NodeFactory<TupleBuiltins.ReprNode> {
        private static final ReprNodeFactory REPR_NODE_FACTORY_INSTANCE = new ReprNodeFactory();

        private ReprNodeFactory() {
        }

        public Class<TupleBuiltins.ReprNode> getNodeClass() {
            return TupleBuiltins.ReprNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public TupleBuiltins.ReprNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return ReprNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TupleBuiltins.ReprNode> getInstance() {
            return REPR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TupleBuiltins.ReprNode create() {
            return new ReprNodeGen();
        }

        @GeneratedBy(value=TupleBuiltins.ReprNode.class)
        public static final class ReprNodeGen
        extends TupleBuiltins.ReprNode {
            private static final InlineSupport.StateField STATE_0_ReprNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlineSupport.StateField STATE_1_ReprNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_1_");
            private static final TupleNodes.GetTupleStorage INLINED_GET_TUPLE_STORAGE_ = TupleNodesFactory.GetTupleStorageNodeGen.inline(InlineSupport.InlineTarget.create(TupleNodes.GetTupleStorage.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ReprNode_UPDATER.subUpdater(1, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getTupleStorage__field1_", Node.class)}));
            private static final PyObjectReprAsTruffleStringNode INLINED_REPR_NODE_ = PyObjectReprAsTruffleStringNodeGen.inline(InlineSupport.InlineTarget.create(PyObjectReprAsTruffleStringNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_ReprNode_UPDATER.subUpdater(0, 30), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"reprNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"reprNode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"reprNode__field3_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"reprNode__field4_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"reprNode__field5_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"reprNode__field6_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"reprNode__field7_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"reprNode__field8_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"reprNode__field9_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getTupleStorage__field1_;
            @Node.Child
            private SequenceStorageNodes.GetItemNode getItemNode_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node reprNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node reprNode__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node reprNode__field3_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node reprNode__field4_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node reprNode__field5_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node reprNode__field6_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node reprNode__field7_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node reprNode__field8_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node reprNode__field9_;
            @Node.Child
            private TruffleStringBuilder.AppendStringNode appendStringNode_;
            @Node.Child
            private TruffleStringBuilder.ToStringNode toStringNode_;

            private ReprNodeGen() {
            }

            @Override
            public TruffleString execute(VirtualFrame frameValue, Object arg0Value) {
                TruffleStringBuilder.ToStringNode toStringNode__;
                TruffleStringBuilder.AppendStringNode appendStringNode__;
                SequenceStorageNodes.GetItemNode getItemNode__;
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && (getItemNode__ = this.getItemNode_) != null && (appendStringNode__ = this.appendStringNode_) != null && (toStringNode__ = this.toStringNode_) != null) {
                    ReprNodeGen inliningTarget__ = this;
                    return TupleBuiltins.ReprNode.repr(frameValue, arg0Value, inliningTarget__, INLINED_GET_TUPLE_STORAGE_, getItemNode__, INLINED_REPR_NODE_, appendStringNode__, toStringNode__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private TruffleString executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                ReprNodeGen inliningTarget__ = null;
                inliningTarget__ = this;
                SequenceStorageNodes.GetItemNode getItemNode__ = (SequenceStorageNodes.GetItemNode)this.insert(SequenceStorageNodes.GetItemNode.createNotNormalized());
                Objects.requireNonNull(getItemNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.getItemNode_ = getItemNode__;
                TruffleStringBuilder.AppendStringNode appendStringNode__ = (TruffleStringBuilder.AppendStringNode)this.insert((Node)TruffleStringBuilder.AppendStringNode.create());
                Objects.requireNonNull(appendStringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.appendStringNode_ = appendStringNode__;
                TruffleStringBuilder.ToStringNode toStringNode__ = (TruffleStringBuilder.ToStringNode)this.insert((Node)TruffleStringBuilder.ToStringNode.create());
                Objects.requireNonNull(toStringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.toStringNode_ = toStringNode__;
                this.state_0_ = state_0 |= 1;
                return TupleBuiltins.ReprNode.repr(frameValue, arg0Value, inliningTarget__, INLINED_GET_TUPLE_STORAGE_, getItemNode__, INLINED_REPR_NODE_, appendStringNode__, toStringNode__);
            }
        }
    }

    @GeneratedBy(value=TupleBuiltins.TupleSqItem.class)
    public static final class TupleSqItemFactory
    implements NodeFactory<TupleBuiltins.TupleSqItem> {
        private static final TupleSqItemFactory TUPLE_SQ_ITEM_FACTORY_INSTANCE = new TupleSqItemFactory();

        private TupleSqItemFactory() {
        }

        public Class<TupleBuiltins.TupleSqItem> getNodeClass() {
            return TupleBuiltins.TupleSqItem.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public TupleBuiltins.TupleSqItem createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return TupleSqItemFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TupleBuiltins.TupleSqItem> getInstance() {
            return TUPLE_SQ_ITEM_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TupleBuiltins.TupleSqItem create() {
            return new TupleSqItemNodeGen();
        }

        @GeneratedBy(value=TupleBuiltins.TupleSqItem.class)
        public static final class TupleSqItemNodeGen
        extends TupleBuiltins.TupleSqItem {
            private static final InlineSupport.StateField STATE_0_TupleSqItem_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyTupleGetItem INLINED_GET_ITEM_ = PyTupleGetItemNodeGen.inline(InlineSupport.InlineTarget.create(PyTupleGetItem.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_TupleSqItem_UPDATER.subUpdater(0, 13), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getItem__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getItem__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getItem__field3_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getItem__field4_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getItem__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getItem__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getItem__field3_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getItem__field4_;

            private TupleSqItemNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, int arg1Value) {
                TupleSqItemNodeGen inliningTarget__ = this;
                return TupleBuiltins.TupleSqItem.doIt(arg0Value, arg1Value, inliningTarget__, INLINED_GET_ITEM_);
            }
        }
    }

    @GeneratedBy(value=TupleBuiltins.GetItemNode.class)
    public static final class GetItemNodeFactory
    implements NodeFactory<TupleBuiltins.GetItemNode> {
        private static final GetItemNodeFactory GET_ITEM_NODE_FACTORY_INSTANCE = new GetItemNodeFactory();

        private GetItemNodeFactory() {
        }

        public Class<TupleBuiltins.GetItemNode> getNodeClass() {
            return TupleBuiltins.GetItemNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public TupleBuiltins.GetItemNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return GetItemNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TupleBuiltins.GetItemNode> getInstance() {
            return GET_ITEM_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TupleBuiltins.GetItemNode create() {
            return new GetItemNodeGen();
        }

        @GeneratedBy(value=TupleBuiltins.GetItemNode.class)
        public static final class GetItemNodeGen
        extends TupleBuiltins.GetItemNode {
            private static final InlineSupport.StateField STATE_0_GetItemNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlinedConditionProfile INLINED_VALID_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_GetItemNode_UPDATER.subUpdater(0, 2)}));
            private static final PyIndexCheckNode INLINED_INDEX_CHECK_NODE_ = PyIndexCheckNodeGen.inline(InlineSupport.InlineTarget.create(PyIndexCheckNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_GetItemNode_UPDATER.subUpdater(2, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"indexCheckNode__field1_", Node.class)}));
            private static final PRaiseNode.Lazy INLINED_RAISE_NODE_ = PRaiseNodeGen.LazyNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.Lazy.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_GetItemNode_UPDATER.subUpdater(9, 1), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"raiseNode__field1_", Node.class)}));
            private static final TupleNodes.GetTupleStorage INLINED_GET_TUPLE_STORAGE_ = TupleNodesFactory.GetTupleStorageNodeGen.inline(InlineSupport.InlineTarget.create(TupleNodes.GetTupleStorage.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_GetItemNode_UPDATER.subUpdater(10, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getTupleStorage__field1_", Node.class)}));
            private static final SequenceStorageNodes.SequenceStorageMpSubscriptNode INLINED_SUBSCRIPT_NODE_ = SequenceStorageNodesFactory.SequenceStorageMpSubscriptNodeGen.inline(InlineSupport.InlineTarget.create(SequenceStorageNodes.SequenceStorageMpSubscriptNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_GetItemNode_UPDATER.subUpdater(12, 20), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"subscriptNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"subscriptNode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"subscriptNode__field3_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"subscriptNode__field4_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"subscriptNode__field5_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"subscriptNode__field6_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node indexCheckNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node raiseNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getTupleStorage__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node subscriptNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node subscriptNode__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node subscriptNode__field3_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node subscriptNode__field4_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node subscriptNode__field5_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node subscriptNode__field6_;

            private GetItemNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                GetItemNodeGen inliningTarget__ = this;
                return TupleBuiltins.GetItemNode.doIt(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_VALID_PROFILE_, INLINED_INDEX_CHECK_NODE_, INLINED_RAISE_NODE_, INLINED_GET_TUPLE_STORAGE_, INLINED_SUBSCRIPT_NODE_);
            }
        }
    }

    @GeneratedBy(value=TupleBuiltins.EqNode.class)
    static final class EqNodeFactory
    implements NodeFactory<TupleBuiltins.EqNode> {
        private static final EqNodeFactory EQ_NODE_FACTORY_INSTANCE = new EqNodeFactory();

        private EqNodeFactory() {
        }

        public Class<TupleBuiltins.EqNode> getNodeClass() {
            return TupleBuiltins.EqNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public TupleBuiltins.EqNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return EqNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<TupleBuiltins.EqNode> getInstance() {
            return EQ_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TupleBuiltins.EqNode create() {
            return new EqNodeGen();
        }

        @GeneratedBy(value=TupleBuiltins.EqNode.class)
        static final class EqNodeGen
        extends TupleBuiltins.EqNode {
            private static final InlineSupport.StateField STATE_0_EqNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyTupleCheckNode INLINED_TUPLE_CHECK_RIGHT_ = PyTupleCheckNodeGen.inline(InlineSupport.InlineTarget.create(PyTupleCheckNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_EqNode_UPDATER.subUpdater(4, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"tuple_checkRight__field1_", Node.class)}));
            private static final TupleNodes.GetTupleStorage INLINED_TUPLE_GET_LEFT_ = TupleNodesFactory.GetTupleStorageNodeGen.inline(InlineSupport.InlineTarget.create(TupleNodes.GetTupleStorage.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_EqNode_UPDATER.subUpdater(7, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"tuple_getLeft__field1_", Node.class)}));
            private static final TupleNodes.GetTupleStorage INLINED_TUPLE_GET_RIGHT_ = TupleNodesFactory.GetTupleStorageNodeGen.inline(InlineSupport.InlineTarget.create(TupleNodes.GetTupleStorage.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_EqNode_UPDATER.subUpdater(9, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"tuple_getRight__field1_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            private SequenceStorageNodes.CmpNode cmp;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node tuple_checkRight__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node tuple_getLeft__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node tuple_getRight__field1_;

            private EqNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                EqNodeGen inliningTarget__ = this;
                PyTupleCheckNode checkRight__ = INLINED_TUPLE_CHECK_RIGHT_;
                return (state_0 & 2) != 0 || (state_0 & 4) != 0 && inliningTarget__ != null && checkRight__ != null && !checkRight__.execute(inliningTarget__, arg1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xB) != 0) {
                    if ((state_0 & 1) != 0 && arg0Value instanceof PTuple) {
                        PTuple arg0Value_ = (PTuple)arg0Value;
                        if (arg1Value instanceof PTuple) {
                            PTuple arg1Value_ = (PTuple)arg1Value;
                            SequenceStorageNodes.CmpNode cmp_ = this.cmp;
                            if (cmp_ != null) {
                                return TupleBuiltins.AbstractCmpNode.doPTuple(frameValue, arg0Value_, arg1Value_, cmp_);
                            }
                        }
                    }
                    if ((state_0 & 0xA) != 0) {
                        EqNodeGen inliningTarget__;
                        SequenceStorageNodes.CmpNode cmp_1;
                        if ((state_0 & 2) != 0 && (cmp_1 = this.cmp) != null && INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__ = this, arg1Value)) {
                            return TupleBuiltins.AbstractCmpNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, cmp_1);
                        }
                        if ((state_0 & 8) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return TupleBuiltins.AbstractCmpNode.doOther(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                SequenceStorageNodes.CmpNode cmp_1;
                int state_0 = this.state_0_;
                if ((state_0 & 2) == 0 && arg0Value instanceof PTuple) {
                    PTuple arg0Value_ = (PTuple)arg0Value;
                    if (arg1Value instanceof PTuple) {
                        SequenceStorageNodes.CmpNode cmp_;
                        PTuple arg1Value_ = (PTuple)arg1Value;
                        SequenceStorageNodes.CmpNode cmp__shared = this.cmp;
                        if (cmp__shared != null) {
                            cmp_ = cmp__shared;
                        } else {
                            cmp_ = (SequenceStorageNodes.CmpNode)this.insert(this.createCmp());
                            if (cmp_ == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.cmp == null) {
                            VarHandle.storeStoreFence();
                            this.cmp = cmp_;
                        }
                        this.state_0_ = state_0 |= 1;
                        return TupleBuiltins.AbstractCmpNode.doPTuple(frameValue, arg0Value_, arg1Value_, cmp_);
                    }
                }
                EqNodeGen inliningTarget__ = null;
                boolean Tuple_duplicateFound_ = false;
                if ((state_0 & 2) != 0 && (cmp_1 = this.cmp) != null && INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__ = this, arg1Value)) {
                    Tuple_duplicateFound_ = true;
                }
                if (!Tuple_duplicateFound_) {
                    inliningTarget__ = this;
                    if ((state_0 & 4) == 0) {
                        state_0 |= 4;
                    }
                    if (INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value) && (state_0 & 2) == 0) {
                        SequenceStorageNodes.CmpNode cmp_1_shared = this.cmp;
                        if (cmp_1_shared != null) {
                            cmp_1 = cmp_1_shared;
                        } else {
                            cmp_1 = (SequenceStorageNodes.CmpNode)this.insert(this.createCmp());
                            if (cmp_1 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.cmp == null) {
                            this.cmp = cmp_1;
                        }
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        Tuple_duplicateFound_ = true;
                    }
                }
                if (Tuple_duplicateFound_) {
                    return TupleBuiltins.AbstractCmpNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, this.cmp);
                }
                this.state_0_ = state_0 |= 8;
                return TupleBuiltins.AbstractCmpNode.doOther(arg0Value, arg1Value);
            }
        }
    }

    @GeneratedBy(value=TupleBuiltins.NeNode.class)
    static final class NeNodeFactory
    implements NodeFactory<TupleBuiltins.NeNode> {
        private static final NeNodeFactory NE_NODE_FACTORY_INSTANCE = new NeNodeFactory();

        private NeNodeFactory() {
        }

        public Class<TupleBuiltins.NeNode> getNodeClass() {
            return TupleBuiltins.NeNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public TupleBuiltins.NeNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return NeNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<TupleBuiltins.NeNode> getInstance() {
            return NE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TupleBuiltins.NeNode create() {
            return new NeNodeGen();
        }

        @GeneratedBy(value=TupleBuiltins.NeNode.class)
        static final class NeNodeGen
        extends TupleBuiltins.NeNode {
            private static final InlineSupport.StateField STATE_0_NeNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyTupleCheckNode INLINED_TUPLE_CHECK_RIGHT_ = PyTupleCheckNodeGen.inline(InlineSupport.InlineTarget.create(PyTupleCheckNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_NeNode_UPDATER.subUpdater(4, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"tuple_checkRight__field1_", Node.class)}));
            private static final TupleNodes.GetTupleStorage INLINED_TUPLE_GET_LEFT_ = TupleNodesFactory.GetTupleStorageNodeGen.inline(InlineSupport.InlineTarget.create(TupleNodes.GetTupleStorage.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_NeNode_UPDATER.subUpdater(7, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"tuple_getLeft__field1_", Node.class)}));
            private static final TupleNodes.GetTupleStorage INLINED_TUPLE_GET_RIGHT_ = TupleNodesFactory.GetTupleStorageNodeGen.inline(InlineSupport.InlineTarget.create(TupleNodes.GetTupleStorage.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_NeNode_UPDATER.subUpdater(9, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"tuple_getRight__field1_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            private SequenceStorageNodes.CmpNode cmp;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node tuple_checkRight__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node tuple_getLeft__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node tuple_getRight__field1_;

            private NeNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                NeNodeGen inliningTarget__ = this;
                PyTupleCheckNode checkRight__ = INLINED_TUPLE_CHECK_RIGHT_;
                return (state_0 & 2) != 0 || (state_0 & 4) != 0 && inliningTarget__ != null && checkRight__ != null && !checkRight__.execute(inliningTarget__, arg1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xB) != 0) {
                    if ((state_0 & 1) != 0 && arg0Value instanceof PTuple) {
                        PTuple arg0Value_ = (PTuple)arg0Value;
                        if (arg1Value instanceof PTuple) {
                            PTuple arg1Value_ = (PTuple)arg1Value;
                            SequenceStorageNodes.CmpNode cmp_ = this.cmp;
                            if (cmp_ != null) {
                                return TupleBuiltins.AbstractCmpNode.doPTuple(frameValue, arg0Value_, arg1Value_, cmp_);
                            }
                        }
                    }
                    if ((state_0 & 0xA) != 0) {
                        NeNodeGen inliningTarget__;
                        SequenceStorageNodes.CmpNode cmp_1;
                        if ((state_0 & 2) != 0 && (cmp_1 = this.cmp) != null && INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__ = this, arg1Value)) {
                            return TupleBuiltins.AbstractCmpNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, cmp_1);
                        }
                        if ((state_0 & 8) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return TupleBuiltins.AbstractCmpNode.doOther(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                SequenceStorageNodes.CmpNode cmp_1;
                int state_0 = this.state_0_;
                if ((state_0 & 2) == 0 && arg0Value instanceof PTuple) {
                    PTuple arg0Value_ = (PTuple)arg0Value;
                    if (arg1Value instanceof PTuple) {
                        SequenceStorageNodes.CmpNode cmp_;
                        PTuple arg1Value_ = (PTuple)arg1Value;
                        SequenceStorageNodes.CmpNode cmp__shared = this.cmp;
                        if (cmp__shared != null) {
                            cmp_ = cmp__shared;
                        } else {
                            cmp_ = (SequenceStorageNodes.CmpNode)this.insert(this.createCmp());
                            if (cmp_ == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.cmp == null) {
                            VarHandle.storeStoreFence();
                            this.cmp = cmp_;
                        }
                        this.state_0_ = state_0 |= 1;
                        return TupleBuiltins.AbstractCmpNode.doPTuple(frameValue, arg0Value_, arg1Value_, cmp_);
                    }
                }
                NeNodeGen inliningTarget__ = null;
                boolean Tuple_duplicateFound_ = false;
                if ((state_0 & 2) != 0 && (cmp_1 = this.cmp) != null && INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__ = this, arg1Value)) {
                    Tuple_duplicateFound_ = true;
                }
                if (!Tuple_duplicateFound_) {
                    inliningTarget__ = this;
                    if ((state_0 & 4) == 0) {
                        state_0 |= 4;
                    }
                    if (INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value) && (state_0 & 2) == 0) {
                        SequenceStorageNodes.CmpNode cmp_1_shared = this.cmp;
                        if (cmp_1_shared != null) {
                            cmp_1 = cmp_1_shared;
                        } else {
                            cmp_1 = (SequenceStorageNodes.CmpNode)this.insert(this.createCmp());
                            if (cmp_1 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.cmp == null) {
                            this.cmp = cmp_1;
                        }
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        Tuple_duplicateFound_ = true;
                    }
                }
                if (Tuple_duplicateFound_) {
                    return TupleBuiltins.AbstractCmpNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, this.cmp);
                }
                this.state_0_ = state_0 |= 8;
                return TupleBuiltins.AbstractCmpNode.doOther(arg0Value, arg1Value);
            }
        }
    }

    @GeneratedBy(value=TupleBuiltins.GeNode.class)
    static final class GeNodeFactory
    implements NodeFactory<TupleBuiltins.GeNode> {
        private static final GeNodeFactory GE_NODE_FACTORY_INSTANCE = new GeNodeFactory();

        private GeNodeFactory() {
        }

        public Class<TupleBuiltins.GeNode> getNodeClass() {
            return TupleBuiltins.GeNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public TupleBuiltins.GeNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return GeNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<TupleBuiltins.GeNode> getInstance() {
            return GE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TupleBuiltins.GeNode create() {
            return new GeNodeGen();
        }

        @GeneratedBy(value=TupleBuiltins.GeNode.class)
        static final class GeNodeGen
        extends TupleBuiltins.GeNode {
            private static final InlineSupport.StateField STATE_0_GeNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyTupleCheckNode INLINED_TUPLE_CHECK_RIGHT_ = PyTupleCheckNodeGen.inline(InlineSupport.InlineTarget.create(PyTupleCheckNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_GeNode_UPDATER.subUpdater(4, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"tuple_checkRight__field1_", Node.class)}));
            private static final TupleNodes.GetTupleStorage INLINED_TUPLE_GET_LEFT_ = TupleNodesFactory.GetTupleStorageNodeGen.inline(InlineSupport.InlineTarget.create(TupleNodes.GetTupleStorage.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_GeNode_UPDATER.subUpdater(7, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"tuple_getLeft__field1_", Node.class)}));
            private static final TupleNodes.GetTupleStorage INLINED_TUPLE_GET_RIGHT_ = TupleNodesFactory.GetTupleStorageNodeGen.inline(InlineSupport.InlineTarget.create(TupleNodes.GetTupleStorage.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_GeNode_UPDATER.subUpdater(9, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"tuple_getRight__field1_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            private SequenceStorageNodes.CmpNode cmp;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node tuple_checkRight__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node tuple_getLeft__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node tuple_getRight__field1_;

            private GeNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                GeNodeGen inliningTarget__ = this;
                PyTupleCheckNode checkRight__ = INLINED_TUPLE_CHECK_RIGHT_;
                return (state_0 & 2) != 0 || (state_0 & 4) != 0 && inliningTarget__ != null && checkRight__ != null && !checkRight__.execute(inliningTarget__, arg1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xB) != 0) {
                    if ((state_0 & 1) != 0 && arg0Value instanceof PTuple) {
                        PTuple arg0Value_ = (PTuple)arg0Value;
                        if (arg1Value instanceof PTuple) {
                            PTuple arg1Value_ = (PTuple)arg1Value;
                            SequenceStorageNodes.CmpNode cmp_ = this.cmp;
                            if (cmp_ != null) {
                                return TupleBuiltins.AbstractCmpNode.doPTuple(frameValue, arg0Value_, arg1Value_, cmp_);
                            }
                        }
                    }
                    if ((state_0 & 0xA) != 0) {
                        GeNodeGen inliningTarget__;
                        SequenceStorageNodes.CmpNode cmp_1;
                        if ((state_0 & 2) != 0 && (cmp_1 = this.cmp) != null && INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__ = this, arg1Value)) {
                            return TupleBuiltins.AbstractCmpNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, cmp_1);
                        }
                        if ((state_0 & 8) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return TupleBuiltins.AbstractCmpNode.doOther(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                SequenceStorageNodes.CmpNode cmp_1;
                int state_0 = this.state_0_;
                if ((state_0 & 2) == 0 && arg0Value instanceof PTuple) {
                    PTuple arg0Value_ = (PTuple)arg0Value;
                    if (arg1Value instanceof PTuple) {
                        SequenceStorageNodes.CmpNode cmp_;
                        PTuple arg1Value_ = (PTuple)arg1Value;
                        SequenceStorageNodes.CmpNode cmp__shared = this.cmp;
                        if (cmp__shared != null) {
                            cmp_ = cmp__shared;
                        } else {
                            cmp_ = (SequenceStorageNodes.CmpNode)this.insert(this.createCmp());
                            if (cmp_ == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.cmp == null) {
                            VarHandle.storeStoreFence();
                            this.cmp = cmp_;
                        }
                        this.state_0_ = state_0 |= 1;
                        return TupleBuiltins.AbstractCmpNode.doPTuple(frameValue, arg0Value_, arg1Value_, cmp_);
                    }
                }
                GeNodeGen inliningTarget__ = null;
                boolean Tuple_duplicateFound_ = false;
                if ((state_0 & 2) != 0 && (cmp_1 = this.cmp) != null && INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__ = this, arg1Value)) {
                    Tuple_duplicateFound_ = true;
                }
                if (!Tuple_duplicateFound_) {
                    inliningTarget__ = this;
                    if ((state_0 & 4) == 0) {
                        state_0 |= 4;
                    }
                    if (INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value) && (state_0 & 2) == 0) {
                        SequenceStorageNodes.CmpNode cmp_1_shared = this.cmp;
                        if (cmp_1_shared != null) {
                            cmp_1 = cmp_1_shared;
                        } else {
                            cmp_1 = (SequenceStorageNodes.CmpNode)this.insert(this.createCmp());
                            if (cmp_1 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.cmp == null) {
                            this.cmp = cmp_1;
                        }
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        Tuple_duplicateFound_ = true;
                    }
                }
                if (Tuple_duplicateFound_) {
                    return TupleBuiltins.AbstractCmpNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, this.cmp);
                }
                this.state_0_ = state_0 |= 8;
                return TupleBuiltins.AbstractCmpNode.doOther(arg0Value, arg1Value);
            }
        }
    }

    @GeneratedBy(value=TupleBuiltins.LeNode.class)
    static final class LeNodeFactory
    implements NodeFactory<TupleBuiltins.LeNode> {
        private static final LeNodeFactory LE_NODE_FACTORY_INSTANCE = new LeNodeFactory();

        private LeNodeFactory() {
        }

        public Class<TupleBuiltins.LeNode> getNodeClass() {
            return TupleBuiltins.LeNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public TupleBuiltins.LeNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return LeNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<TupleBuiltins.LeNode> getInstance() {
            return LE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TupleBuiltins.LeNode create() {
            return new LeNodeGen();
        }

        @GeneratedBy(value=TupleBuiltins.LeNode.class)
        static final class LeNodeGen
        extends TupleBuiltins.LeNode {
            private static final InlineSupport.StateField STATE_0_LeNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyTupleCheckNode INLINED_TUPLE_CHECK_RIGHT_ = PyTupleCheckNodeGen.inline(InlineSupport.InlineTarget.create(PyTupleCheckNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_LeNode_UPDATER.subUpdater(4, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"tuple_checkRight__field1_", Node.class)}));
            private static final TupleNodes.GetTupleStorage INLINED_TUPLE_GET_LEFT_ = TupleNodesFactory.GetTupleStorageNodeGen.inline(InlineSupport.InlineTarget.create(TupleNodes.GetTupleStorage.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_LeNode_UPDATER.subUpdater(7, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"tuple_getLeft__field1_", Node.class)}));
            private static final TupleNodes.GetTupleStorage INLINED_TUPLE_GET_RIGHT_ = TupleNodesFactory.GetTupleStorageNodeGen.inline(InlineSupport.InlineTarget.create(TupleNodes.GetTupleStorage.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_LeNode_UPDATER.subUpdater(9, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"tuple_getRight__field1_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            private SequenceStorageNodes.CmpNode cmp;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node tuple_checkRight__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node tuple_getLeft__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node tuple_getRight__field1_;

            private LeNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                LeNodeGen inliningTarget__ = this;
                PyTupleCheckNode checkRight__ = INLINED_TUPLE_CHECK_RIGHT_;
                return (state_0 & 2) != 0 || (state_0 & 4) != 0 && inliningTarget__ != null && checkRight__ != null && !checkRight__.execute(inliningTarget__, arg1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xB) != 0) {
                    if ((state_0 & 1) != 0 && arg0Value instanceof PTuple) {
                        PTuple arg0Value_ = (PTuple)arg0Value;
                        if (arg1Value instanceof PTuple) {
                            PTuple arg1Value_ = (PTuple)arg1Value;
                            SequenceStorageNodes.CmpNode cmp_ = this.cmp;
                            if (cmp_ != null) {
                                return TupleBuiltins.AbstractCmpNode.doPTuple(frameValue, arg0Value_, arg1Value_, cmp_);
                            }
                        }
                    }
                    if ((state_0 & 0xA) != 0) {
                        LeNodeGen inliningTarget__;
                        SequenceStorageNodes.CmpNode cmp_1;
                        if ((state_0 & 2) != 0 && (cmp_1 = this.cmp) != null && INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__ = this, arg1Value)) {
                            return TupleBuiltins.AbstractCmpNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, cmp_1);
                        }
                        if ((state_0 & 8) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return TupleBuiltins.AbstractCmpNode.doOther(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                SequenceStorageNodes.CmpNode cmp_1;
                int state_0 = this.state_0_;
                if ((state_0 & 2) == 0 && arg0Value instanceof PTuple) {
                    PTuple arg0Value_ = (PTuple)arg0Value;
                    if (arg1Value instanceof PTuple) {
                        SequenceStorageNodes.CmpNode cmp_;
                        PTuple arg1Value_ = (PTuple)arg1Value;
                        SequenceStorageNodes.CmpNode cmp__shared = this.cmp;
                        if (cmp__shared != null) {
                            cmp_ = cmp__shared;
                        } else {
                            cmp_ = (SequenceStorageNodes.CmpNode)this.insert(this.createCmp());
                            if (cmp_ == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.cmp == null) {
                            VarHandle.storeStoreFence();
                            this.cmp = cmp_;
                        }
                        this.state_0_ = state_0 |= 1;
                        return TupleBuiltins.AbstractCmpNode.doPTuple(frameValue, arg0Value_, arg1Value_, cmp_);
                    }
                }
                LeNodeGen inliningTarget__ = null;
                boolean Tuple_duplicateFound_ = false;
                if ((state_0 & 2) != 0 && (cmp_1 = this.cmp) != null && INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__ = this, arg1Value)) {
                    Tuple_duplicateFound_ = true;
                }
                if (!Tuple_duplicateFound_) {
                    inliningTarget__ = this;
                    if ((state_0 & 4) == 0) {
                        state_0 |= 4;
                    }
                    if (INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value) && (state_0 & 2) == 0) {
                        SequenceStorageNodes.CmpNode cmp_1_shared = this.cmp;
                        if (cmp_1_shared != null) {
                            cmp_1 = cmp_1_shared;
                        } else {
                            cmp_1 = (SequenceStorageNodes.CmpNode)this.insert(this.createCmp());
                            if (cmp_1 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.cmp == null) {
                            this.cmp = cmp_1;
                        }
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        Tuple_duplicateFound_ = true;
                    }
                }
                if (Tuple_duplicateFound_) {
                    return TupleBuiltins.AbstractCmpNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, this.cmp);
                }
                this.state_0_ = state_0 |= 8;
                return TupleBuiltins.AbstractCmpNode.doOther(arg0Value, arg1Value);
            }
        }
    }

    @GeneratedBy(value=TupleBuiltins.GtNode.class)
    static final class GtNodeFactory
    implements NodeFactory<TupleBuiltins.GtNode> {
        private static final GtNodeFactory GT_NODE_FACTORY_INSTANCE = new GtNodeFactory();

        private GtNodeFactory() {
        }

        public Class<TupleBuiltins.GtNode> getNodeClass() {
            return TupleBuiltins.GtNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public TupleBuiltins.GtNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return GtNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<TupleBuiltins.GtNode> getInstance() {
            return GT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TupleBuiltins.GtNode create() {
            return new GtNodeGen();
        }

        @GeneratedBy(value=TupleBuiltins.GtNode.class)
        static final class GtNodeGen
        extends TupleBuiltins.GtNode {
            private static final InlineSupport.StateField STATE_0_GtNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyTupleCheckNode INLINED_TUPLE_CHECK_RIGHT_ = PyTupleCheckNodeGen.inline(InlineSupport.InlineTarget.create(PyTupleCheckNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_GtNode_UPDATER.subUpdater(4, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"tuple_checkRight__field1_", Node.class)}));
            private static final TupleNodes.GetTupleStorage INLINED_TUPLE_GET_LEFT_ = TupleNodesFactory.GetTupleStorageNodeGen.inline(InlineSupport.InlineTarget.create(TupleNodes.GetTupleStorage.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_GtNode_UPDATER.subUpdater(7, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"tuple_getLeft__field1_", Node.class)}));
            private static final TupleNodes.GetTupleStorage INLINED_TUPLE_GET_RIGHT_ = TupleNodesFactory.GetTupleStorageNodeGen.inline(InlineSupport.InlineTarget.create(TupleNodes.GetTupleStorage.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_GtNode_UPDATER.subUpdater(9, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"tuple_getRight__field1_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            private SequenceStorageNodes.CmpNode cmp;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node tuple_checkRight__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node tuple_getLeft__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node tuple_getRight__field1_;

            private GtNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                GtNodeGen inliningTarget__ = this;
                PyTupleCheckNode checkRight__ = INLINED_TUPLE_CHECK_RIGHT_;
                return (state_0 & 2) != 0 || (state_0 & 4) != 0 && inliningTarget__ != null && checkRight__ != null && !checkRight__.execute(inliningTarget__, arg1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xB) != 0) {
                    if ((state_0 & 1) != 0 && arg0Value instanceof PTuple) {
                        PTuple arg0Value_ = (PTuple)arg0Value;
                        if (arg1Value instanceof PTuple) {
                            PTuple arg1Value_ = (PTuple)arg1Value;
                            SequenceStorageNodes.CmpNode cmp_ = this.cmp;
                            if (cmp_ != null) {
                                return TupleBuiltins.AbstractCmpNode.doPTuple(frameValue, arg0Value_, arg1Value_, cmp_);
                            }
                        }
                    }
                    if ((state_0 & 0xA) != 0) {
                        GtNodeGen inliningTarget__;
                        SequenceStorageNodes.CmpNode cmp_1;
                        if ((state_0 & 2) != 0 && (cmp_1 = this.cmp) != null && INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__ = this, arg1Value)) {
                            return TupleBuiltins.AbstractCmpNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, cmp_1);
                        }
                        if ((state_0 & 8) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return TupleBuiltins.AbstractCmpNode.doOther(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                SequenceStorageNodes.CmpNode cmp_1;
                int state_0 = this.state_0_;
                if ((state_0 & 2) == 0 && arg0Value instanceof PTuple) {
                    PTuple arg0Value_ = (PTuple)arg0Value;
                    if (arg1Value instanceof PTuple) {
                        SequenceStorageNodes.CmpNode cmp_;
                        PTuple arg1Value_ = (PTuple)arg1Value;
                        SequenceStorageNodes.CmpNode cmp__shared = this.cmp;
                        if (cmp__shared != null) {
                            cmp_ = cmp__shared;
                        } else {
                            cmp_ = (SequenceStorageNodes.CmpNode)this.insert(this.createCmp());
                            if (cmp_ == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.cmp == null) {
                            VarHandle.storeStoreFence();
                            this.cmp = cmp_;
                        }
                        this.state_0_ = state_0 |= 1;
                        return TupleBuiltins.AbstractCmpNode.doPTuple(frameValue, arg0Value_, arg1Value_, cmp_);
                    }
                }
                GtNodeGen inliningTarget__ = null;
                boolean Tuple_duplicateFound_ = false;
                if ((state_0 & 2) != 0 && (cmp_1 = this.cmp) != null && INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__ = this, arg1Value)) {
                    Tuple_duplicateFound_ = true;
                }
                if (!Tuple_duplicateFound_) {
                    inliningTarget__ = this;
                    if ((state_0 & 4) == 0) {
                        state_0 |= 4;
                    }
                    if (INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value) && (state_0 & 2) == 0) {
                        SequenceStorageNodes.CmpNode cmp_1_shared = this.cmp;
                        if (cmp_1_shared != null) {
                            cmp_1 = cmp_1_shared;
                        } else {
                            cmp_1 = (SequenceStorageNodes.CmpNode)this.insert(this.createCmp());
                            if (cmp_1 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.cmp == null) {
                            this.cmp = cmp_1;
                        }
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        Tuple_duplicateFound_ = true;
                    }
                }
                if (Tuple_duplicateFound_) {
                    return TupleBuiltins.AbstractCmpNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, this.cmp);
                }
                this.state_0_ = state_0 |= 8;
                return TupleBuiltins.AbstractCmpNode.doOther(arg0Value, arg1Value);
            }
        }
    }

    @GeneratedBy(value=TupleBuiltins.LtNode.class)
    static final class LtNodeFactory
    implements NodeFactory<TupleBuiltins.LtNode> {
        private static final LtNodeFactory LT_NODE_FACTORY_INSTANCE = new LtNodeFactory();

        private LtNodeFactory() {
        }

        public Class<TupleBuiltins.LtNode> getNodeClass() {
            return TupleBuiltins.LtNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public TupleBuiltins.LtNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return LtNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<TupleBuiltins.LtNode> getInstance() {
            return LT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TupleBuiltins.LtNode create() {
            return new LtNodeGen();
        }

        @GeneratedBy(value=TupleBuiltins.LtNode.class)
        static final class LtNodeGen
        extends TupleBuiltins.LtNode {
            private static final InlineSupport.StateField STATE_0_LtNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyTupleCheckNode INLINED_TUPLE_CHECK_RIGHT_ = PyTupleCheckNodeGen.inline(InlineSupport.InlineTarget.create(PyTupleCheckNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_LtNode_UPDATER.subUpdater(4, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"tuple_checkRight__field1_", Node.class)}));
            private static final TupleNodes.GetTupleStorage INLINED_TUPLE_GET_LEFT_ = TupleNodesFactory.GetTupleStorageNodeGen.inline(InlineSupport.InlineTarget.create(TupleNodes.GetTupleStorage.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_LtNode_UPDATER.subUpdater(7, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"tuple_getLeft__field1_", Node.class)}));
            private static final TupleNodes.GetTupleStorage INLINED_TUPLE_GET_RIGHT_ = TupleNodesFactory.GetTupleStorageNodeGen.inline(InlineSupport.InlineTarget.create(TupleNodes.GetTupleStorage.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_LtNode_UPDATER.subUpdater(9, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"tuple_getRight__field1_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            private SequenceStorageNodes.CmpNode cmp;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node tuple_checkRight__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node tuple_getLeft__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node tuple_getRight__field1_;

            private LtNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                LtNodeGen inliningTarget__ = this;
                PyTupleCheckNode checkRight__ = INLINED_TUPLE_CHECK_RIGHT_;
                return (state_0 & 2) != 0 || (state_0 & 4) != 0 && inliningTarget__ != null && checkRight__ != null && !checkRight__.execute(inliningTarget__, arg1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xB) != 0) {
                    if ((state_0 & 1) != 0 && arg0Value instanceof PTuple) {
                        PTuple arg0Value_ = (PTuple)arg0Value;
                        if (arg1Value instanceof PTuple) {
                            PTuple arg1Value_ = (PTuple)arg1Value;
                            SequenceStorageNodes.CmpNode cmp_ = this.cmp;
                            if (cmp_ != null) {
                                return TupleBuiltins.AbstractCmpNode.doPTuple(frameValue, arg0Value_, arg1Value_, cmp_);
                            }
                        }
                    }
                    if ((state_0 & 0xA) != 0) {
                        LtNodeGen inliningTarget__;
                        SequenceStorageNodes.CmpNode cmp_1;
                        if ((state_0 & 2) != 0 && (cmp_1 = this.cmp) != null && INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__ = this, arg1Value)) {
                            return TupleBuiltins.AbstractCmpNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, cmp_1);
                        }
                        if ((state_0 & 8) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return TupleBuiltins.AbstractCmpNode.doOther(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                SequenceStorageNodes.CmpNode cmp_1;
                int state_0 = this.state_0_;
                if ((state_0 & 2) == 0 && arg0Value instanceof PTuple) {
                    PTuple arg0Value_ = (PTuple)arg0Value;
                    if (arg1Value instanceof PTuple) {
                        SequenceStorageNodes.CmpNode cmp_;
                        PTuple arg1Value_ = (PTuple)arg1Value;
                        SequenceStorageNodes.CmpNode cmp__shared = this.cmp;
                        if (cmp__shared != null) {
                            cmp_ = cmp__shared;
                        } else {
                            cmp_ = (SequenceStorageNodes.CmpNode)this.insert(this.createCmp());
                            if (cmp_ == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.cmp == null) {
                            VarHandle.storeStoreFence();
                            this.cmp = cmp_;
                        }
                        this.state_0_ = state_0 |= 1;
                        return TupleBuiltins.AbstractCmpNode.doPTuple(frameValue, arg0Value_, arg1Value_, cmp_);
                    }
                }
                LtNodeGen inliningTarget__ = null;
                boolean Tuple_duplicateFound_ = false;
                if ((state_0 & 2) != 0 && (cmp_1 = this.cmp) != null && INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__ = this, arg1Value)) {
                    Tuple_duplicateFound_ = true;
                }
                if (!Tuple_duplicateFound_) {
                    inliningTarget__ = this;
                    if ((state_0 & 4) == 0) {
                        state_0 |= 4;
                    }
                    if (INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value) && (state_0 & 2) == 0) {
                        SequenceStorageNodes.CmpNode cmp_1_shared = this.cmp;
                        if (cmp_1_shared != null) {
                            cmp_1 = cmp_1_shared;
                        } else {
                            cmp_1 = (SequenceStorageNodes.CmpNode)this.insert(this.createCmp());
                            if (cmp_1 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.cmp == null) {
                            this.cmp = cmp_1;
                        }
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        Tuple_duplicateFound_ = true;
                    }
                }
                if (Tuple_duplicateFound_) {
                    return TupleBuiltins.AbstractCmpNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, this.cmp);
                }
                this.state_0_ = state_0 |= 8;
                return TupleBuiltins.AbstractCmpNode.doOther(arg0Value, arg1Value);
            }
        }
    }

    @GeneratedBy(value=TupleBuiltins.RichCompareNode.class)
    static final class RichCompareNodeFactory
    implements NodeFactory<TupleBuiltins.RichCompareNode> {
        private static final RichCompareNodeFactory RICH_COMPARE_NODE_FACTORY_INSTANCE = new RichCompareNodeFactory();

        private RichCompareNodeFactory() {
        }

        public Class<TupleBuiltins.RichCompareNode> getNodeClass() {
            return TupleBuiltins.RichCompareNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public TupleBuiltins.RichCompareNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return RichCompareNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<TupleBuiltins.RichCompareNode> getInstance() {
            return RICH_COMPARE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TupleBuiltins.RichCompareNode create() {
            return new RichCompareNodeGen();
        }

        @GeneratedBy(value=TupleBuiltins.RichCompareNode.class)
        static final class RichCompareNodeGen
        extends TupleBuiltins.RichCompareNode {
            private static final InlineSupport.StateField GENERIC_RICH_COMPARE_NODE_GENERIC_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)GenericData.lookup_(), (String)"generic_state_0_");
            static final InlineSupport.ReferenceField<PTupleData> P_TUPLE_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"pTuple_cache", PTupleData.class);
            static final InlineSupport.ReferenceField<GenericData> GENERIC_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"generic_cache", GenericData.class);
            private static final PyTupleCheckNode INLINED_GENERIC_CHECK_LEFT_ = PyTupleCheckNodeGen.inline(InlineSupport.InlineTarget.create(PyTupleCheckNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERIC_RICH_COMPARE_NODE_GENERIC_STATE_0_UPDATER.subUpdater(3, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GenericData.lookup_(), (String)"generic_checkLeft__field1_", Node.class)}));
            private static final PyTupleCheckNode INLINED_GENERIC_CHECK_RIGHT_ = PyTupleCheckNodeGen.inline(InlineSupport.InlineTarget.create(PyTupleCheckNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERIC_RICH_COMPARE_NODE_GENERIC_STATE_0_UPDATER.subUpdater(6, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GenericData.lookup_(), (String)"generic_checkRight__field1_", Node.class)}));
            private static final TupleNodes.GetTupleStorage INLINED_GENERIC_GET_LEFT_ = TupleNodesFactory.GetTupleStorageNodeGen.inline(InlineSupport.InlineTarget.create(TupleNodes.GetTupleStorage.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERIC_RICH_COMPARE_NODE_GENERIC_STATE_0_UPDATER.subUpdater(9, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GenericData.lookup_(), (String)"generic_getLeft__field1_", Node.class)}));
            private static final TupleNodes.GetTupleStorage INLINED_GENERIC_GET_RIGHT_ = TupleNodesFactory.GetTupleStorageNodeGen.inline(InlineSupport.InlineTarget.create(TupleNodes.GetTupleStorage.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{GENERIC_RICH_COMPARE_NODE_GENERIC_STATE_0_UPDATER.subUpdater(11, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)GenericData.lookup_(), (String)"generic_getRight__field1_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private PTupleData pTuple_cache;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private GenericData generic_cache;

            private RichCompareNodeGen() {
            }

            @Override
            @ExplodeLoop
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 && arg2Value instanceof Integer) {
                    int arg2Value_ = (Integer)arg2Value;
                    if ((state_0 & 1) != 0 && arg0Value instanceof PTuple) {
                        PTuple arg0Value_ = (PTuple)arg0Value;
                        if (arg1Value instanceof PTuple) {
                            PTuple arg1Value_ = (PTuple)arg1Value;
                            PTupleData s0_ = this.pTuple_cache;
                            while (s0_ != null) {
                                if (arg2Value_ == TupleBuiltinsFactory.decodeComparisonOp((int)((s0_.pTuple_state_0_ >>> 0) - 2)).opCode) {
                                    return TupleBuiltins.RichCompareNode.doPTuple(frameValue, arg0Value_, arg1Value_, arg2Value_, TupleBuiltinsFactory.decodeComparisonOp((s0_.pTuple_state_0_ >>> 0) - 2), s0_.cmpNode_);
                                }
                                s0_ = s0_.next_;
                            }
                        }
                    }
                    if ((state_0 & 2) != 0) {
                        GenericData s1_ = this.generic_cache;
                        while (s1_ != null) {
                            if (arg2Value_ == TupleBuiltinsFactory.decodeComparisonOp((int)(((s1_.generic_state_0_ & 7) >>> 0) - 2)).opCode) {
                                GenericData inliningTarget__ = s1_;
                                return TupleBuiltins.RichCompareNode.doGeneric(frameValue, arg0Value, arg1Value, arg2Value_, inliningTarget__, TupleBuiltinsFactory.decodeComparisonOp(((s1_.generic_state_0_ & 7) >>> 0) - 2), INLINED_GENERIC_CHECK_LEFT_, INLINED_GENERIC_CHECK_RIGHT_, INLINED_GENERIC_GET_LEFT_, INLINED_GENERIC_GET_RIGHT_, s1_.cmpNode_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if (arg2Value instanceof Integer) {
                    GenericData s1_;
                    GenericData inliningTarget__;
                    int arg2Value_;
                    block11: {
                        GenericData s1_original;
                        arg2Value_ = (Integer)arg2Value;
                        if ((state_0 & 2) == 0 && arg0Value instanceof PTuple) {
                            PTuple arg0Value_ = (PTuple)arg0Value;
                            if (arg1Value instanceof PTuple) {
                                PTupleData s0_;
                                PTuple arg1Value_;
                                block10: {
                                    PTupleData s0_original;
                                    arg1Value_ = (PTuple)arg1Value;
                                    do {
                                        int count0_ = 0;
                                        s0_original = s0_ = (PTupleData)((Object)P_TUPLE_CACHE_UPDATER.getVolatile((Node)this));
                                        while (s0_ != null && arg2Value_ != TupleBuiltinsFactory.decodeComparisonOp((int)((s0_.pTuple_state_0_ >>> 0) - 2)).opCode) {
                                            ++count0_;
                                            s0_ = s0_.next_;
                                        }
                                        if (s0_ != null) break block10;
                                        ComparisonOp cachedOp__ = ComparisonOp.fromOpCode(arg2Value_);
                                        if (arg2Value_ != cachedOp__.opCode || count0_ >= 6) break block10;
                                        s0_ = (PTupleData)this.insert(new PTupleData(s0_original));
                                        s0_.pTuple_state_0_ |= TupleBuiltinsFactory.encodeComparisonOp(cachedOp__) + 2 << 0;
                                        SequenceStorageNodes.CmpNode cmpNode__ = (SequenceStorageNodes.CmpNode)s0_.insert(TupleBuiltins.RichCompareNode.createCmpNode(cachedOp__));
                                        Objects.requireNonNull(cmpNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s0_.cmpNode_ = cmpNode__;
                                    } while (!P_TUPLE_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                                    this.state_0_ = state_0 |= 1;
                                }
                                if (s0_ != null) {
                                    return TupleBuiltins.RichCompareNode.doPTuple(frameValue, arg0Value_, arg1Value_, arg2Value_, TupleBuiltinsFactory.decodeComparisonOp((s0_.pTuple_state_0_ >>> 0) - 2), s0_.cmpNode_);
                                }
                            }
                        }
                        inliningTarget__ = null;
                        do {
                            int count1_ = 0;
                            s1_original = s1_ = (GenericData)((Object)GENERIC_CACHE_UPDATER.getVolatile((Node)this));
                            while (s1_ != null) {
                                if (arg2Value_ == TupleBuiltinsFactory.decodeComparisonOp((int)(((s1_.generic_state_0_ & 7) >>> 0) - 2)).opCode) {
                                    inliningTarget__ = s1_;
                                    break;
                                }
                                ++count1_;
                                s1_ = s1_.next_;
                            }
                            if (s1_ != null) break block11;
                            ComparisonOp cachedOp__1 = ComparisonOp.fromOpCode(arg2Value_);
                            if (arg2Value_ != cachedOp__1.opCode || count1_ >= 6) break block11;
                            inliningTarget__ = s1_ = (GenericData)this.insert(new GenericData(s1_original));
                            s1_.generic_state_0_ |= TupleBuiltinsFactory.encodeComparisonOp(cachedOp__1) + 2 << 0;
                            SequenceStorageNodes.CmpNode cmpNode__1 = (SequenceStorageNodes.CmpNode)s1_.insert(TupleBuiltins.RichCompareNode.createCmpNode(cachedOp__1));
                            Objects.requireNonNull(cmpNode__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s1_.cmpNode_ = cmpNode__1;
                        } while (!GENERIC_CACHE_UPDATER.compareAndSet((Node)this, (Object)s1_original, (Object)s1_));
                        this.pTuple_cache = null;
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                    }
                    if (s1_ != null) {
                        return TupleBuiltins.RichCompareNode.doGeneric(frameValue, arg0Value, arg1Value, arg2Value_, inliningTarget__, TupleBuiltinsFactory.decodeComparisonOp(((s1_.generic_state_0_ & 7) >>> 0) - 2), INLINED_GENERIC_CHECK_LEFT_, INLINED_GENERIC_CHECK_RIGHT_, INLINED_GENERIC_GET_LEFT_, INLINED_GENERIC_GET_RIGHT_, s1_.cmpNode_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            @GeneratedBy(value=TupleBuiltins.RichCompareNode.class)
            @DenyReplace
            private static final class PTupleData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                PTupleData next_;
                @CompilerDirectives.CompilationFinal
                private int pTuple_state_0_;
                @Node.Child
                SequenceStorageNodes.CmpNode cmpNode_;

                PTupleData(PTupleData next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=TupleBuiltins.RichCompareNode.class)
            @DenyReplace
            private static final class GenericData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                GenericData next_;
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int generic_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node generic_checkLeft__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node generic_checkRight__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node generic_getLeft__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node generic_getRight__field1_;
                @Node.Child
                SequenceStorageNodes.CmpNode cmpNode_;

                GenericData(GenericData next_) {
                    this.next_ = next_;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=TupleBuiltins.TupleConcatNode.class)
    static final class TupleConcatNodeFactory
    implements NodeFactory<TupleBuiltins.TupleConcatNode> {
        private static final TupleConcatNodeFactory TUPLE_CONCAT_NODE_FACTORY_INSTANCE = new TupleConcatNodeFactory();

        private TupleConcatNodeFactory() {
        }

        public Class<TupleBuiltins.TupleConcatNode> getNodeClass() {
            return TupleBuiltins.TupleConcatNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public TupleBuiltins.TupleConcatNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return TupleConcatNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<TupleBuiltins.TupleConcatNode> getInstance() {
            return TUPLE_CONCAT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TupleBuiltins.TupleConcatNode create() {
            return new TupleConcatNodeGen();
        }

        @GeneratedBy(value=TupleBuiltins.TupleConcatNode.class)
        static final class TupleConcatNodeGen
        extends TupleBuiltins.TupleConcatNode {
            private static final InlineSupport.StateField TUPLE_TUPLE_CONCAT_NODE_TUPLE_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)TupleData.lookup_(), (String)"tuple_state_0_");
            static final InlineSupport.ReferenceField<TupleData> TUPLE_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"tuple_cache", TupleData.class);
            private static final PyTupleCheckNode INLINED_TUPLE_CHECK_RIGHT_ = PyTupleCheckNodeGen.inline(InlineSupport.InlineTarget.create(PyTupleCheckNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{TUPLE_TUPLE_CONCAT_NODE_TUPLE_STATE_0_UPDATER.subUpdater(2, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)TupleData.lookup_(), (String)"tuple_checkRight__field1_", Node.class)}));
            private static final TupleNodes.GetTupleStorage INLINED_TUPLE_GET_LEFT_ = TupleNodesFactory.GetTupleStorageNodeGen.inline(InlineSupport.InlineTarget.create(TupleNodes.GetTupleStorage.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{TUPLE_TUPLE_CONCAT_NODE_TUPLE_STATE_0_UPDATER.subUpdater(5, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)TupleData.lookup_(), (String)"tuple_getLeft__field1_", Node.class)}));
            private static final TupleNodes.GetTupleStorage INLINED_TUPLE_GET_RIGHT_ = TupleNodesFactory.GetTupleStorageNodeGen.inline(InlineSupport.InlineTarget.create(TupleNodes.GetTupleStorage.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{TUPLE_TUPLE_CONCAT_NODE_TUPLE_STATE_0_UPDATER.subUpdater(7, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)TupleData.lookup_(), (String)"tuple_getRight__field1_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private TupleData tuple_cache;
            @Node.Child
            private PRaiseNode fallback_raiseNode_;

            private TupleConcatNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                TupleData s0_ = this.tuple_cache;
                return s0_ != null && (s0_.tuple_state_0_ & 1) != 0 && !INLINED_TUPLE_CHECK_RIGHT_.execute(s0_, arg1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0) {
                    PRaiseNode raiseNode__;
                    TupleData inliningTarget__;
                    TupleData s0_;
                    if ((state_0 & 1) != 0 && (s0_ = this.tuple_cache) != null && (s0_.tuple_state_0_ & 2) != 0 && INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__ = s0_, arg1Value)) {
                        return TupleBuiltins.TupleConcatNode.doTuple(arg0Value, arg1Value, inliningTarget__, INLINED_TUPLE_CHECK_RIGHT_, INLINED_TUPLE_GET_LEFT_, INLINED_TUPLE_GET_RIGHT_, s0_.concatNode_, s0_.factory_);
                    }
                    if ((state_0 & 2) != 0 && (raiseNode__ = this.fallback_raiseNode_) != null && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return TupleBuiltins.TupleConcatNode.doGeneric(arg0Value, arg1Value, raiseNode__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * Unable to fully structure code
             */
            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                block4: {
                    block5: {
                        state_0 = this.state_0_;
                        inliningTarget__ = null;
                        do lbl-1000:
                        // 3 sources

                        {
                            block6: {
                                count0_ = 0;
                                s0_original = s0_ = (TupleData)TupleConcatNodeGen.TUPLE_CACHE_UPDATER.getVolatile((Node)this);
                                if (!(s0_ == null || (s0_.tuple_state_0_ & 2) != 0 && TupleConcatNodeGen.INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__ = s0_, arg1Value))) {
                                    if ((s0_.tuple_state_0_ & 2) != 0) {
                                        ++count0_;
                                    }
                                    s0_ = null;
                                }
                                if (s0_ != null || count0_ >= true) break block4;
                                inliningTarget__ = s0_ = (TupleData)this.insert(new TupleData());
                                if ((s0_.tuple_state_0_ & 1) != 0) break block6;
                                s0_.tuple_state_0_ |= 1;
                                if (!TupleConcatNodeGen.TUPLE_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_)) ** GOTO lbl-1000
                                s0_original = s0_;
                                s0_ = (TupleData)this.insert(new TupleData(s0_));
                            }
                            if (!TupleConcatNodeGen.INLINED_TUPLE_CHECK_RIGHT_.execute(inliningTarget__, arg1Value)) break block5;
                            concatNode__ = (SequenceStorageNodes.ConcatNode)s0_.insert(TupleBuiltins.TupleConcatNode.createConcat());
                            Objects.requireNonNull(concatNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s0_.concatNode_ = concatNode__;
                            factory__ = (PythonObjectFactory)s0_.insert(PythonObjectFactory.create());
                            Objects.requireNonNull(factory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s0_.factory_ = factory__;
                            s0_.tuple_state_0_ |= 2;
                        } while (!TupleConcatNodeGen.TUPLE_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                        this.state_0_ = state_0 |= 1;
                        break block4;
                    }
                    s0_ = null;
                }
                if (s0_ != null) {
                    return TupleBuiltins.TupleConcatNode.doTuple(arg0Value, arg1Value, inliningTarget__, TupleConcatNodeGen.INLINED_TUPLE_CHECK_RIGHT_, TupleConcatNodeGen.INLINED_TUPLE_GET_LEFT_, TupleConcatNodeGen.INLINED_TUPLE_GET_RIGHT_, s0_.concatNode_, s0_.factory_);
                }
                raiseNode__ = (PRaiseNode)this.insert(PRaiseNode.create());
                Objects.requireNonNull(raiseNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.fallback_raiseNode_ = raiseNode__;
                this.state_0_ = state_0 |= 2;
                return TupleBuiltins.TupleConcatNode.doGeneric(arg0Value, arg1Value, raiseNode__);
            }

            @GeneratedBy(value=TupleBuiltins.TupleConcatNode.class)
            @DenyReplace
            private static final class TupleData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int tuple_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node tuple_checkRight__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node tuple_getLeft__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node tuple_getRight__field1_;
                @Node.Child
                SequenceStorageNodes.ConcatNode concatNode_;
                @Node.Child
                PythonObjectFactory factory_;

                TupleData() {
                }

                TupleData(TupleData delegate) {
                    this.tuple_state_0_ = delegate.tuple_state_0_;
                    this.tuple_checkRight__field1_ = delegate.tuple_checkRight__field1_;
                    this.tuple_getLeft__field1_ = delegate.tuple_getLeft__field1_;
                    this.tuple_getRight__field1_ = delegate.tuple_getRight__field1_;
                    this.concatNode_ = delegate.concatNode_;
                    this.factory_ = delegate.factory_;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=TupleBuiltins.MulNode.class)
    static final class MulNodeFactory
    implements NodeFactory<TupleBuiltins.MulNode> {
        private static final MulNodeFactory MUL_NODE_FACTORY_INSTANCE = new MulNodeFactory();

        private MulNodeFactory() {
        }

        public Class<TupleBuiltins.MulNode> getNodeClass() {
            return TupleBuiltins.MulNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public TupleBuiltins.MulNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return MulNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<TupleBuiltins.MulNode> getInstance() {
            return MUL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TupleBuiltins.MulNode create() {
            return new MulNodeGen();
        }

        @GeneratedBy(value=TupleBuiltins.MulNode.class)
        static final class MulNodeGen
        extends TupleBuiltins.MulNode {
            private static final InlineSupport.StateField STATE_0_MulNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyTupleCheckExactNode INLINED_CHECK_TUPLE_ = PyTupleCheckExactNodeGen.inline(InlineSupport.InlineTarget.create(PyTupleCheckExactNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_MulNode_UPDATER.subUpdater(1, 2)}));
            private static final TupleNodes.GetTupleStorage INLINED_GET_LEFT_ = TupleNodesFactory.GetTupleStorageNodeGen.inline(InlineSupport.InlineTarget.create(TupleNodes.GetTupleStorage.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_MulNode_UPDATER.subUpdater(3, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getLeft__field1_", Node.class)}));
            private static final InlinedConditionProfile INLINED_IS_SINGLE_REPEAT_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_MulNode_UPDATER.subUpdater(5, 2)}));
            private static final PyNumberAsSizeNode INLINED_AS_SIZE_NODE_ = PyNumberAsSizeNodeGen.inline(InlineSupport.InlineTarget.create(PyNumberAsSizeNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_MulNode_UPDATER.subUpdater(7, 5), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"asSizeNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"asSizeNode__field2_", Node.class)}));
            private static final PythonObjectFactory.Lazy INLINED_FACTORY_ = PythonObjectFactoryNodeGen.LazyNodeGen.inline(InlineSupport.InlineTarget.create(PythonObjectFactory.Lazy.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_MulNode_UPDATER.subUpdater(12, 1), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"factory__field1_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getLeft__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node asSizeNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node asSizeNode__field2_;
            @Node.Child
            private SequenceStorageNodes.RepeatNode repeatNode_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node factory__field1_;

            private MulNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, int arg1Value) {
                SequenceStorageNodes.RepeatNode repeatNode__;
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && (repeatNode__ = this.repeatNode_) != null) {
                    MulNodeGen inliningTarget__ = this;
                    return TupleBuiltins.MulNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_CHECK_TUPLE_, INLINED_GET_LEFT_, INLINED_IS_SINGLE_REPEAT_, INLINED_AS_SIZE_NODE_, repeatNode__, INLINED_FACTORY_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                MulNodeGen inliningTarget__ = null;
                inliningTarget__ = this;
                SequenceStorageNodes.RepeatNode repeatNode__ = (SequenceStorageNodes.RepeatNode)this.insert(SequenceStorageNodes.RepeatNode.create());
                Objects.requireNonNull(repeatNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.repeatNode_ = repeatNode__;
                this.state_0_ = state_0 |= 1;
                return TupleBuiltins.MulNode.doTuple(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_CHECK_TUPLE_, INLINED_GET_LEFT_, INLINED_IS_SINGLE_REPEAT_, INLINED_AS_SIZE_NODE_, repeatNode__, INLINED_FACTORY_);
            }
        }
    }

    @GeneratedBy(value=TupleBuiltins.ContainsNode.class)
    static final class ContainsNodeFactory
    implements NodeFactory<TupleBuiltins.ContainsNode> {
        private static final ContainsNodeFactory CONTAINS_NODE_FACTORY_INSTANCE = new ContainsNodeFactory();

        private ContainsNodeFactory() {
        }

        public Class<TupleBuiltins.ContainsNode> getNodeClass() {
            return TupleBuiltins.ContainsNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public TupleBuiltins.ContainsNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return ContainsNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<TupleBuiltins.ContainsNode> getInstance() {
            return CONTAINS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TupleBuiltins.ContainsNode create() {
            return new ContainsNodeGen();
        }

        @GeneratedBy(value=TupleBuiltins.ContainsNode.class)
        static final class ContainsNodeGen
        extends TupleBuiltins.ContainsNode {
            private static final InlineSupport.StateField STATE_0_ContainsNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final TupleNodes.GetTupleStorage INLINED_GET_TUPLE_STORAGE_ = TupleNodesFactory.GetTupleStorageNodeGen.inline(InlineSupport.InlineTarget.create(TupleNodes.GetTupleStorage.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ContainsNode_UPDATER.subUpdater(0, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getTupleStorage__field1_", Node.class)}));
            private static final SequenceStorageNodes.ContainsNode INLINED_CONTAINS_NODE_ = SequenceStorageNodesFactory.ContainsNodeGen.inline(InlineSupport.InlineTarget.create(SequenceStorageNodes.ContainsNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ContainsNode_UPDATER.subUpdater(2, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"containsNode__field1_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getTupleStorage__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node containsNode__field1_;

            private ContainsNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                ContainsNodeGen inliningTarget__ = this;
                return this.contains(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_GET_TUPLE_STORAGE_, INLINED_CONTAINS_NODE_);
            }
        }
    }

    @GeneratedBy(value=TupleBuiltins.IterNode.class)
    public static final class IterNodeFactory
    implements NodeFactory<TupleBuiltins.IterNode> {
        private static final IterNodeFactory ITER_NODE_FACTORY_INSTANCE = new IterNodeFactory();

        private IterNodeFactory() {
        }

        public Class<TupleBuiltins.IterNode> getNodeClass() {
            return TupleBuiltins.IterNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public TupleBuiltins.IterNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return IterNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TupleBuiltins.IterNode> getInstance() {
            return ITER_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TupleBuiltins.IterNode create() {
            return new IterNodeGen();
        }

        @GeneratedBy(value=TupleBuiltins.IterNode.class)
        public static final class IterNodeGen
        extends TupleBuiltins.IterNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private PythonObjectFactory factory;

            private IterNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0) {
                    PythonAbstractObject arg0Value_;
                    if ((state_0 & 0x1F) != 0 && arg0Value instanceof PTuple) {
                        PythonObjectFactory factory_4;
                        PythonObjectFactory factory_3;
                        PythonObjectFactory factory_2;
                        PythonObjectFactory factory_1;
                        PythonObjectFactory factory_;
                        arg0Value_ = (PTuple)arg0Value;
                        if ((state_0 & 1) != 0 && (factory_ = this.factory) != null && PGuards.isIntStorage(arg0Value_)) {
                            return TupleBuiltins.IterNode.doPTupleInt(arg0Value_, factory_);
                        }
                        if ((state_0 & 2) != 0 && (factory_1 = this.factory) != null && PGuards.isObjectStorage(arg0Value_)) {
                            return TupleBuiltins.IterNode.doPTupleObject(arg0Value_, factory_1);
                        }
                        if ((state_0 & 4) != 0 && (factory_2 = this.factory) != null && PGuards.isLongStorage(arg0Value_)) {
                            return TupleBuiltins.IterNode.doPTupleLong(arg0Value_, factory_2);
                        }
                        if ((state_0 & 8) != 0 && (factory_3 = this.factory) != null && PGuards.isDoubleStorage(arg0Value_)) {
                            return TupleBuiltins.IterNode.doPTupleDouble(arg0Value_, factory_3);
                        }
                        if (!((state_0 & 0x10) == 0 || (factory_4 = this.factory) == null || PGuards.isIntStorage(arg0Value_) || PGuards.isLongStorage(arg0Value_) || PGuards.isDoubleStorage(arg0Value_))) {
                            return TupleBuiltins.IterNode.doPTuple(arg0Value_, factory_4);
                        }
                    }
                    if ((state_0 & 0x20) != 0 && arg0Value instanceof PythonAbstractNativeObject) {
                        arg0Value_ = (PythonAbstractNativeObject)arg0Value;
                        PythonObjectFactory factory_5 = this.factory;
                        if (factory_5 != null) {
                            return TupleBuiltins.IterNode.doNativeTuple((PythonAbstractNativeObject)arg0Value_, factory_5);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            private PBuiltinIterator executeAndSpecialize(Object arg0Value) {
                PythonAbstractObject arg0Value_;
                int state_0 = this.state_0_;
                if (arg0Value instanceof PTuple) {
                    arg0Value_ = (PTuple)arg0Value;
                    if (PGuards.isIntStorage(arg0Value_)) {
                        PythonObjectFactory factory_;
                        PythonObjectFactory factory__shared = this.factory;
                        if (factory__shared != null) {
                            factory_ = factory__shared;
                        } else {
                            factory_ = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                            if (factory_ == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.factory == null) {
                            VarHandle.storeStoreFence();
                            this.factory = factory_;
                        }
                        this.state_0_ = state_0 |= 1;
                        return TupleBuiltins.IterNode.doPTupleInt(arg0Value_, factory_);
                    }
                    if (PGuards.isObjectStorage(arg0Value_)) {
                        PythonObjectFactory factory_1;
                        PythonObjectFactory factory_1_shared = this.factory;
                        if (factory_1_shared != null) {
                            factory_1 = factory_1_shared;
                        } else {
                            factory_1 = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                            if (factory_1 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.factory == null) {
                            VarHandle.storeStoreFence();
                            this.factory = factory_1;
                        }
                        this.state_0_ = state_0 |= 2;
                        return TupleBuiltins.IterNode.doPTupleObject(arg0Value_, factory_1);
                    }
                    if (PGuards.isLongStorage(arg0Value_)) {
                        PythonObjectFactory factory_2;
                        PythonObjectFactory factory_2_shared = this.factory;
                        if (factory_2_shared != null) {
                            factory_2 = factory_2_shared;
                        } else {
                            factory_2 = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                            if (factory_2 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.factory == null) {
                            VarHandle.storeStoreFence();
                            this.factory = factory_2;
                        }
                        this.state_0_ = state_0 |= 4;
                        return TupleBuiltins.IterNode.doPTupleLong(arg0Value_, factory_2);
                    }
                    if (PGuards.isDoubleStorage(arg0Value_)) {
                        PythonObjectFactory factory_3;
                        PythonObjectFactory factory_3_shared = this.factory;
                        if (factory_3_shared != null) {
                            factory_3 = factory_3_shared;
                        } else {
                            factory_3 = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                            if (factory_3 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.factory == null) {
                            VarHandle.storeStoreFence();
                            this.factory = factory_3;
                        }
                        this.state_0_ = state_0 |= 8;
                        return TupleBuiltins.IterNode.doPTupleDouble(arg0Value_, factory_3);
                    }
                    if (!(PGuards.isIntStorage(arg0Value_) || PGuards.isLongStorage(arg0Value_) || PGuards.isDoubleStorage(arg0Value_))) {
                        PythonObjectFactory factory_4;
                        PythonObjectFactory factory_4_shared = this.factory;
                        if (factory_4_shared != null) {
                            factory_4 = factory_4_shared;
                        } else {
                            factory_4 = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                            if (factory_4 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.factory == null) {
                            VarHandle.storeStoreFence();
                            this.factory = factory_4;
                        }
                        this.state_0_ = state_0 |= 0x10;
                        return TupleBuiltins.IterNode.doPTuple(arg0Value_, factory_4);
                    }
                }
                if (arg0Value instanceof PythonAbstractNativeObject) {
                    PythonObjectFactory factory_5;
                    arg0Value_ = (PythonAbstractNativeObject)arg0Value;
                    PythonObjectFactory factory_5_shared = this.factory;
                    if (factory_5_shared != null) {
                        factory_5 = factory_5_shared;
                    } else {
                        factory_5 = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                        if (factory_5 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.factory == null) {
                        VarHandle.storeStoreFence();
                        this.factory = factory_5;
                    }
                    this.state_0_ = state_0 |= 0x20;
                    return TupleBuiltins.IterNode.doNativeTuple((PythonAbstractNativeObject)arg0Value_, factory_5);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
            }
        }
    }

    @GeneratedBy(value=TupleBuiltins.HashNode.class)
    public static final class HashNodeFactory
    implements NodeFactory<TupleBuiltins.HashNode> {
        private static final HashNodeFactory HASH_NODE_FACTORY_INSTANCE = new HashNodeFactory();

        private HashNodeFactory() {
        }

        public Class<TupleBuiltins.HashNode> getNodeClass() {
            return TupleBuiltins.HashNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public TupleBuiltins.HashNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return HashNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TupleBuiltins.HashNode> getInstance() {
            return HASH_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TupleBuiltins.HashNode create() {
            return new HashNodeGen();
        }

        @GeneratedBy(value=TupleBuiltins.HashNode.class)
        public static final class HashNodeGen
        extends TupleBuiltins.HashNode {
            private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyObjectHashNode INLINED_HASH = PyObjectHashNodeGen.inline(InlineSupport.InlineTarget.create(PyObjectHashNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(3, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"hash_field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"hash_field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"hash_field3_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            private SequenceStorageNodes.GetItemNode getItem;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node hash_field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node hash_field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node hash_field3_;
            @Node.Child
            private TupleNodes.GetNativeTupleStorage computeHash1_getStorage_;

            private HashNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 7) != 0) {
                    PythonAbstractObject arg0Value_;
                    if ((state_0 & 3) != 0 && arg0Value instanceof PTuple) {
                        SequenceStorageNodes.GetItemNode getItem_;
                        arg0Value_ = (PTuple)arg0Value;
                        if ((state_0 & 1) != 0 && ((PTuple)arg0Value_).getHash() != TupleBuiltins.HashNode.HASH_UNSET) {
                            return this.getHash((PTuple)arg0Value_);
                        }
                        if ((state_0 & 2) != 0 && (getItem_ = this.getItem) != null && ((PTuple)arg0Value_).getHash() == TupleBuiltins.HashNode.HASH_UNSET) {
                            HashNodeGen inliningTarget__ = this;
                            return this.computeHash(frameValue, (PTuple)arg0Value_, inliningTarget__, getItem_, INLINED_HASH);
                        }
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PythonAbstractNativeObject) {
                        TupleNodes.GetNativeTupleStorage getStorage__;
                        arg0Value_ = (PythonAbstractNativeObject)arg0Value;
                        SequenceStorageNodes.GetItemNode getItem_1 = this.getItem;
                        if (getItem_1 != null && (getStorage__ = this.computeHash1_getStorage_) != null) {
                            HashNodeGen inliningTarget__1 = this;
                            return this.computeHash(frameValue, (PythonAbstractNativeObject)arg0Value_, inliningTarget__1, getItem_1, INLINED_HASH, getStorage__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private long executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PTuple) {
                    PTuple arg0Value_ = (PTuple)arg0Value;
                    if (arg0Value_.getHash() != TupleBuiltins.HashNode.HASH_UNSET) {
                        this.state_0_ = state_0 |= 1;
                        return this.getHash(arg0Value_);
                    }
                    HashNodeGen inliningTarget__ = null;
                    if (arg0Value_.getHash() == TupleBuiltins.HashNode.HASH_UNSET) {
                        SequenceStorageNodes.GetItemNode getItem_;
                        inliningTarget__ = this;
                        SequenceStorageNodes.GetItemNode getItem__shared = this.getItem;
                        if (getItem__shared != null) {
                            getItem_ = getItem__shared;
                        } else {
                            getItem_ = (SequenceStorageNodes.GetItemNode)this.insert(SequenceStorageNodes.GetItemNode.createNotNormalized());
                            if (getItem_ == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.getItem == null) {
                            VarHandle.storeStoreFence();
                            this.getItem = getItem_;
                        }
                        this.state_0_ = state_0 |= 2;
                        return this.computeHash(frameValue, arg0Value_, inliningTarget__, getItem_, INLINED_HASH);
                    }
                }
                HashNodeGen inliningTarget__1 = null;
                if (arg0Value instanceof PythonAbstractNativeObject) {
                    SequenceStorageNodes.GetItemNode getItem_1;
                    PythonAbstractNativeObject arg0Value_ = (PythonAbstractNativeObject)arg0Value;
                    inliningTarget__1 = this;
                    SequenceStorageNodes.GetItemNode getItem_1_shared = this.getItem;
                    if (getItem_1_shared != null) {
                        getItem_1 = getItem_1_shared;
                    } else {
                        getItem_1 = (SequenceStorageNodes.GetItemNode)this.insert(SequenceStorageNodes.GetItemNode.createNotNormalized());
                        if (getItem_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.getItem == null) {
                        VarHandle.storeStoreFence();
                        this.getItem = getItem_1;
                    }
                    TupleNodes.GetNativeTupleStorage getStorage__ = (TupleNodes.GetNativeTupleStorage)this.insert(TupleNodesFactory.GetNativeTupleStorageNodeGen.create());
                    Objects.requireNonNull(getStorage__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.computeHash1_getStorage_ = getStorage__;
                    this.state_0_ = state_0 |= 4;
                    return this.computeHash(frameValue, arg0Value_, inliningTarget__1, getItem_1, INLINED_HASH, getStorage__);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
            }
        }
    }

    @GeneratedBy(value=TupleBuiltins.GetNewargsNode.class)
    public static final class GetNewargsNodeFactory
    implements NodeFactory<TupleBuiltins.GetNewargsNode> {
        private static final GetNewargsNodeFactory GET_NEWARGS_NODE_FACTORY_INSTANCE = new GetNewargsNodeFactory();

        private GetNewargsNodeFactory() {
        }

        public Class<TupleBuiltins.GetNewargsNode> getNodeClass() {
            return TupleBuiltins.GetNewargsNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public TupleBuiltins.GetNewargsNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return GetNewargsNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TupleBuiltins.GetNewargsNode> getInstance() {
            return GET_NEWARGS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TupleBuiltins.GetNewargsNode create() {
            return new GetNewargsNodeGen();
        }

        @GeneratedBy(value=TupleBuiltins.GetNewargsNode.class)
        public static final class GetNewargsNodeGen
        extends TupleBuiltins.GetNewargsNode {
            private static final InlineSupport.StateField STATE_0_GetNewargsNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final TupleNodes.GetTupleStorage INLINED_GET_TUPLE_STORAGE_ = TupleNodesFactory.GetTupleStorageNodeGen.inline(InlineSupport.InlineTarget.create(TupleNodes.GetTupleStorage.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_GetNewargsNode_UPDATER.subUpdater(1, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getTupleStorage__field1_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getTupleStorage__field1_;
            @Node.Child
            private PythonObjectFactory factory_;

            private GetNewargsNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                PythonObjectFactory factory__;
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && (factory__ = this.factory_) != null) {
                    GetNewargsNodeGen inliningTarget__ = this;
                    return TupleBuiltins.GetNewargsNode.doIt(arg0Value, inliningTarget__, INLINED_GET_TUPLE_STORAGE_, factory__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            private PTuple executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                GetNewargsNodeGen inliningTarget__ = null;
                inliningTarget__ = this;
                PythonObjectFactory factory__ = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                Objects.requireNonNull(factory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.factory_ = factory__;
                this.state_0_ = state_0 |= 1;
                return TupleBuiltins.GetNewargsNode.doIt(arg0Value, inliningTarget__, INLINED_GET_TUPLE_STORAGE_, factory__);
            }
        }
    }

    @GeneratedBy(value=TupleBuiltins.ClassGetItemNode.class)
    public static final class ClassGetItemNodeFactory
    implements NodeFactory<TupleBuiltins.ClassGetItemNode> {
        private static final ClassGetItemNodeFactory CLASS_GET_ITEM_NODE_FACTORY_INSTANCE = new ClassGetItemNodeFactory();

        private ClassGetItemNodeFactory() {
        }

        public Class<TupleBuiltins.ClassGetItemNode> getNodeClass() {
            return TupleBuiltins.ClassGetItemNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public TupleBuiltins.ClassGetItemNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return ClassGetItemNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TupleBuiltins.ClassGetItemNode> getInstance() {
            return CLASS_GET_ITEM_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TupleBuiltins.ClassGetItemNode create() {
            return new ClassGetItemNodeGen();
        }

        @GeneratedBy(value=TupleBuiltins.ClassGetItemNode.class)
        public static final class ClassGetItemNodeGen
        extends TupleBuiltins.ClassGetItemNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private PythonObjectFactory factory_;

            private ClassGetItemNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                PythonObjectFactory factory__;
                int state_0 = this.state_0_;
                if (state_0 != 0 && (factory__ = this.factory_) != null) {
                    return TupleBuiltins.ClassGetItemNode.classGetItem(arg0Value, arg1Value, factory__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                PythonObjectFactory factory__ = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                Objects.requireNonNull(factory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.factory_ = factory__;
                this.state_0_ = state_0 |= 1;
                return TupleBuiltins.ClassGetItemNode.classGetItem(arg0Value, arg1Value, factory__);
            }
        }
    }
}

